/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * $Revision: 1.3 $
 */

#if !defined( PUBMED_H )
#define PUBMED_H

typedef unsigned int pubmedid_t;
class pubmed{
public:
    pubmed( );
    ~pubmed( );
    
    pubmedid_t getID( ) const;
    const char* getTitle( ) const;
    const char* getAuthor( ) const;
    const char* getJournal( ) const;
    int getYearOfPublication( ) const;
    int getVolume( ) const;
    int getNumber( ) const;
    const char* getPage( ) const;
    const char* getAbstract( ) const;

    void setID( pubmedid_t );
    void setTitle( const char* );
    void setAuthor( const char* );
    void setJournal( const char* );
    void setYearOfPublication( int );
    void setVolume( int );
    void setNumber( int );
    void setPage( const char* );
    void setAbstract( const char* );
    
private:
    pubmedid_t id;
    char* title;
    char* author;
    char* journal;
    int pub_year;
    int volume;
    int number;
    char* page;
    char* abstract;
};
typedef pubmed pubmed_t;

#endif
