/*
 * account饹Υƥ
 * 
 * gcc -o test_account test_account.cc common.cc ../account.cc ../common.cc
 * 
 * $Revision: 1.2 $
 * $Log: test_account.cc,v $
 * Revision 1.2  2004/11/25 08:58:15  youi
 * ʣaccount_tǼƥȴؿf.
 *
 * Revision 1.1  2004/11/22 08:24:35  youi
 * initial version
 *
 * 
 */

#include <stdio.h>
#include <string.h>
#include <time.h>

#include "../account.h"
#include "common.h"

#define TEST( x ) test( x, #x );

void f( const account_t** acc )
{
    account* p = new account[ 2 ];
    p[0].setUname( "my account A" );
    p[1].setUname( "my account B" );
    *acc = p;
}

void main( void )
{
    account* ac = new account( );
    
    TEST( ac -> getUID( ) == 0 );
    TEST( ac -> getActivate( ) == false );
    TEST( strcmp( ac -> getAddress( ), "" ) == 0 );
    TEST( strcmp( ac -> getInstitute( ), "" ) == 0 );
    TEST( strcmp( ac -> getTel( ), "" ) == 0 );
    TEST( strcmp( ac -> getOrganization( ), "" ) == 0 );
    TEST( strcmp( ac -> getCountry( ), "" ) == 0 );
    TEST( strcmp( ac -> getZipcode( ), "" ) == 0 );
    TEST( strcmp( ac -> getFax( ), "" ) == 0 );
    TEST( strcmp( ac -> getBaseURL( ), "" ) == 0 );
    TEST( ac -> getNoticeMail( ) == 1 );
    TEST( ac -> getNoticeMailSince( ) == 0 );
    
    TEST( strcmp( ac -> getUname( ), "" ) == 0 );
    TEST( strcmp( ac -> getName( ), "" ) == 0 );
    TEST( strcmp( ac -> getEmail( ), "" ) == 0 );
    TEST( strcmp( ac -> getURL( ), "" ) == 0 );
    TEST( strcmp( ac -> getUserAvatar( ), "" ) == 0 );
    TEST( ac -> getUserRegdate( ) == 0 );
    TEST( strcmp( ac -> getUserIcq( ), "" ) == 0 );
    TEST( strcmp( ac -> getUserFrom( ), "" ) == 0 );
    TEST( strcmp( ac -> getUserSig( ), "" ) == 0 );
    TEST( ac -> getUserViewemail( ) == 0 );
    TEST( strcmp( ac -> getActkey( ), "" ) == 0 );
    TEST( strcmp( ac -> getUserAim( ), "" ) == 0 );
    TEST( strcmp( ac -> getUserYim( ), "" ) == 0 );
    TEST( strcmp( ac -> getUserMsnm( ), "" ) == 0 );
    TEST( strcmp( ac -> getPass( ), "" ) == 0 );
    TEST( ac -> getPosts( ) == 0 );
    TEST( ac -> getAttachsig( ) == 0 );
    TEST( ac -> getRank( ) == 0 );
    TEST( ac -> getLevel( ) == 0 );
    TEST( strcmp( ac -> getTheme( ), "" ) == 0 );
    TEST( ac -> getTimezoneOffset( ) == 0.0 );
    TEST( ac -> getLastLogin( ) == 0 );
    TEST( strcmp( ac -> getUmode( ), "" ) == 0 );
    TEST( ac -> getUorder( ) == 0 );
    TEST( ac -> getNotifyMethod( ) == 0 );
    TEST( ac -> getNotifyMode( ) == 0 );
    TEST( strcmp( ac -> getUserOcc( ), "" ) == 0 );
    TEST( strcmp( ac -> getBio( ), "" ) == 0 );
    TEST( strcmp( ac -> getUserIntrest( ), "" ) == 0 );
    TEST( ac -> getUserMailok( ) == 0 );
    
    //
    ac -> setUID( 110 );
    TEST( ac -> getUID( ) == 110 );
    ac -> setUID( -1 );
    TEST( ac -> getUID( ) == -1 );
    
    ac -> setActivate( true );
    TEST( ac -> getActivate( ) );
    ac -> setActivate( false );
    TEST( ac -> getActivate( ) == false );
    
    ac -> setAddress( "my address" );
    TEST( strcmp( ac -> getAddress( ), "my address" ) == 0 );
    ac -> setAddress( 0 );
    TEST( strcmp( ac -> getAddress( ), "" ) == 0 );
    ac -> setAddress( "my address2" );
    TEST( strcmp( ac -> getAddress( ), "my address2" ) == 0 );
    
    ac -> setInstitute( "my institute" );
    TEST( strcmp( ac -> getInstitute( ), "my institute" ) == 0 );
    ac -> setInstitute( 0 );
    TEST( strcmp( ac -> getInstitute( ), "" ) == 0 );
    ac -> setInstitute( "my institute2" );
    TEST( strcmp( ac -> getInstitute( ), "my institute2" ) == 0 );
    
    ac -> setTel( "my tel" );
    TEST( strcmp( ac -> getTel( ), "my tel" ) == 0 );
    ac -> setTel( 0 );
    TEST( strcmp( ac -> getTel( ), "" ) == 0 );
    ac -> setTel( "my tel2" );
    TEST( strcmp( ac -> getTel( ), "my tel2" ) == 0 );
    
    ac -> setOrganization( "my organization" );
    TEST( strcmp( ac -> getOrganization( ), "my organization" ) == 0 );
    ac -> setOrganization( 0 );
    TEST( strcmp( ac -> getOrganization( ), "" ) == 0 );
    ac -> setOrganization( "my organization2" );
    TEST( strcmp( ac -> getOrganization( ), "my organization2" ) == 0 );
    
    ac -> setCountry( "my country" );
    TEST( strcmp( ac -> getCountry( ), "my country" ) == 0 );
    ac -> setCountry( 0 );
    TEST( strcmp( ac -> getCountry( ), "" ) == 0 );
    ac -> setCountry( "my country2" );
    TEST( strcmp( ac -> getCountry( ), "my country2" ) == 0 );
    
    ac -> setZipcode( "my zipcode" );
    TEST( strcmp( ac -> getZipcode( ), "my zipcode" ) == 0 );
    ac -> setZipcode( 0 );
    TEST( strcmp( ac -> getZipcode( ), "" ) == 0 );
    ac -> setZipcode( "my zipcode2" );
    TEST( strcmp( ac -> getZipcode( ), "my zipcode2" ) == 0 );
    
    ac -> setFax( "my fax" );
    TEST( strcmp( ac -> getFax( ), "my fax" ) == 0 );
    ac -> setFax( 0 );
    TEST( strcmp( ac -> getFax( ), "" ) == 0 );
    ac -> setFax( "my fax2" );
    TEST( strcmp( ac -> getFax( ), "my fax2" ) == 0 );
    
    ac -> setBaseURL( "my BaseURL" );
    TEST( strcmp( ac -> getBaseURL( ), "my BaseURL" ) == 0 );
    ac -> setBaseURL( 0 );
    TEST( strcmp( ac -> getBaseURL( ), "" ) == 0 );
    ac -> setBaseURL( "my BaseURL2" );
    TEST( strcmp( ac -> getBaseURL( ), "my BaseURL2" ) == 0 );
    
    ac -> setNoticeMail( 1 );
    TEST( ac -> getNoticeMail( ) == 1 );
    ac -> setNoticeMail( -1 );
    TEST( ac -> getNoticeMail( ) == -1 );
    
    ac -> setNoticeMailSince( 1 );
    TEST( ac -> getNoticeMailSince( ) == 1 );
    ac -> setNoticeMailSince( -1 );
    TEST( ac -> getNoticeMailSince( ) == -1 );
    
    ac -> setUname( "my uname" );
    TEST( strcmp( ac -> getUname( ), "my uname" ) == 0 );
    ac -> setUname( 0 );
    TEST( strcmp( ac -> getUname( ), "" ) == 0 );
    ac -> setUname( "my uname2" );
    TEST( strcmp( ac -> getUname( ), "my uname2" ) == 0 );
    
    ac -> setName( "my name" );
    TEST( strcmp( ac -> getName( ), "my name" ) == 0 );
    ac -> setName( 0 );
    TEST( strcmp( ac -> getName( ), "" ) == 0 );
    ac -> setName( "my name2" );
    TEST( strcmp( ac -> getName( ), "my name2" ) == 0 );
    
    ac -> setEmail( "my email" );
    TEST( strcmp( ac -> getEmail( ), "my email" ) == 0 );
    ac -> setEmail( 0 );
    TEST( strcmp( ac -> getEmail( ), "" ) == 0 );
    ac -> setEmail( "my email2" );
    TEST( strcmp( ac -> getEmail( ), "my email2" ) == 0 );

    ac -> setURL( "my URL" );
    TEST( strcmp( ac -> getURL( ), "my URL" ) == 0 );
    ac -> setURL( 0 );
    TEST( strcmp( ac -> getURL( ), "" ) == 0 );
    ac -> setURL( "my URL2" );
    TEST( strcmp( ac -> getURL( ), "my URL2" ) == 0 );
    
    ac -> setUserAvatar( "my UserAvatar" );
    TEST( strcmp( ac -> getUserAvatar( ), "my UserAvatar" ) == 0 );
    ac -> setUserAvatar( 0 );
    TEST( strcmp( ac -> getUserAvatar( ), "" ) == 0 );
    ac -> setUserAvatar( "my UserAvatar2" );
    TEST( strcmp( ac -> getUserAvatar( ), "my UserAvatar2" ) == 0 );
    
    ac -> setUserRegdate( 1 );
    TEST( ac -> getUserRegdate( ) == 1 );
    
    ac -> setUserIcq( "my UserIcq" );
    TEST( strcmp( ac -> getUserIcq( ), "my UserIcq" ) == 0 );
    ac -> setUserIcq( 0 );
    TEST( strcmp( ac -> getUserIcq( ), "" ) == 0 );
    ac -> setUserIcq( "my UserIcq2" );
    TEST( strcmp( ac -> getUserIcq( ), "my UserIcq2" ) == 0 );
    
    ac -> setUserFrom( "my UserFrom" );
    TEST( strcmp( ac -> getUserFrom( ), "my UserFrom" ) == 0 );
    ac -> setUserFrom( 0 );
    TEST( strcmp( ac -> getUserFrom( ), "" ) == 0 );
    ac -> setUserFrom( "my UserFrom2" );
    TEST( strcmp( ac -> getUserFrom( ), "my UserFrom2" ) == 0 );
    
    ac -> setUserSig( "my UserSig" );
    TEST( strcmp( ac -> getUserSig( ), "my UserSig" ) == 0 );
    ac -> setUserSig( 0 );
    TEST( strcmp( ac -> getUserSig( ), "" ) == 0 );
    ac -> setUserSig( "my UserSig2" );
    TEST( strcmp( ac -> getUserSig( ), "my UserSig2" ) == 0 );
    
    ac -> setUserViewemail( 1 );
    TEST( ac -> getUserViewemail( ) == 1 );
    
    ac -> setActkey( "my Actkey" );
    TEST( strcmp( ac -> getActkey( ), "my Actkey" ) == 0 );
    ac -> setActkey( 0 );
    TEST( strcmp( ac -> getActkey( ), "" ) == 0 );
    ac -> setActkey( "my Actkey2" );
    TEST( strcmp( ac -> getActkey( ), "my Actkey2" ) == 0 );
    
    ac -> setUserAim( "my UserAim" );
    TEST( strcmp( ac -> getUserAim( ), "my UserAim" ) == 0 );
    ac -> setUserAim( 0 );
    TEST( strcmp( ac -> getUserAim( ), "" ) == 0 );
    ac -> setUserAim( "my UserAim2" );
    TEST( strcmp( ac -> getUserAim( ), "my UserAim2" ) == 0 );
    
    ac -> setUserYim( "my UserYim" );
    TEST( strcmp( ac -> getUserYim( ), "my UserYim" ) == 0 );
    ac -> setUserYim( 0 );
    TEST( strcmp( ac -> getUserYim( ), "" ) == 0 );
    ac -> setUserYim( "my UserYim2" );
    TEST( strcmp( ac -> getUserYim( ), "my UserYim2" ) == 0 );
    
    ac -> setUserMsnm( "my UserMsnm" );
    TEST( strcmp( ac -> getUserMsnm( ), "my UserMsnm" ) == 0 );
    ac -> setUserMsnm( 0 );
    TEST( strcmp( ac -> getUserMsnm( ), "" ) == 0 );
    ac -> setUserMsnm( "my UserMsnm2" );
    TEST( strcmp( ac -> getUserMsnm( ), "my UserMsnm2" ) == 0 );
    
    ac -> setPass( "my Pass" );
    TEST( strcmp( ac -> getPass( ), "my Pass" ) == 0 );
    ac -> setPass( 0 );
    TEST( strcmp( ac -> getPass( ), "" ) == 0 );
    ac -> setPass( "my Pass2" );
    TEST( strcmp( ac -> getPass( ), "my Pass2" ) == 0 );
    
    ac -> setPosts( 1 );
    TEST( ac -> getPosts( ) == 1 );
    
    ac -> setAttachsig( 1 );
    TEST( ac -> getAttachsig( ) == 1 );
    
    ac -> setRank( 1 );
    TEST( ac -> getRank( ) == 1 );
    
    ac -> setLevel( 1 );
    TEST( ac -> getLevel( ) == 1 );
    
    ac -> setTheme( "my theme" );
    TEST( strcmp( ac -> getTheme( ), "my theme" ) == 0 );
    ac -> setTheme( 0 );
    TEST( strcmp( ac -> getTheme( ), "" ) == 0 );
    ac -> setTheme( "my theme2" );
    TEST( strcmp( ac -> getTheme( ), "my theme2" ) == 0 );
    
    ac -> setTimezoneOffset( 1.5 );
    TEST( ac -> getTimezoneOffset( ) == 1.5 );
    
    ac -> setLevel( 1 );
    TEST( ac -> getLevel( ) == 1 );

    ac -> setLastLogin( 12334 );
    TEST( ac -> getLastLogin( ) == 12334 );
    
    ac -> setUmode( "my Umode" );
    TEST( strcmp( ac -> getUmode( ), "my Umode" ) == 0 );
    ac -> setUmode( 0 );
    TEST( strcmp( ac -> getUmode( ), "" ) == 0 );
    ac -> setUmode( "my Umode2" );
    TEST( strcmp( ac -> getUmode( ), "my Umode2" ) == 0 );
    
    ac -> setUorder( 1 );
    TEST( ac -> getUorder( ) == 1 );

    ac -> setNotifyMethod( 1 );
    TEST( ac -> getNotifyMethod( ) == 1 );

    ac -> setNotifyMode( 1 );
    TEST( ac -> getNotifyMode( ) == 1 );

    ac -> setUserOcc( "my UserOcc" );
    TEST( strcmp( ac -> getUserOcc( ), "my UserOcc" ) == 0 );
    ac -> setUserOcc( 0 );
    TEST( strcmp( ac -> getUserOcc( ), "" ) == 0 );
    ac -> setUserOcc( "my UserOcc2" );
    TEST( strcmp( ac -> getUserOcc( ), "my UserOcc2" ) == 0 );
    
    ac -> setBio( "my bio" );
    TEST( strcmp( ac -> getBio( ), "my bio" ) == 0 );
    ac -> setBio( 0 );
    TEST( strcmp( ac -> getBio( ), "" ) == 0 );
    ac -> setBio( "my bio2" );
    TEST( strcmp( ac -> getBio( ), "my bio2" ) == 0 );
    
    ac -> setUserIntrest( "my UserIntrest" );
    TEST( strcmp( ac -> getUserIntrest( ), "my UserIntrest" ) == 0 );
    ac -> setUserIntrest( 0 );
    TEST( strcmp( ac -> getUserIntrest( ), "" ) == 0 );
    ac -> setUserIntrest( "my UserIntrest2" );
    TEST( strcmp( ac -> getUserIntrest( ), "my UserIntrest2" ) == 0 );
    
    ac -> setUserMailok( 1 );
    TEST( ac -> getUserMailok( ) == 1 );
    
    
    const account_t* accounts;
    f( &accounts );
    TEST( strcmp( accounts[ 0 ].getUname( ), "my account A" ) == 0 );
    TEST( strcmp( accounts[ 1 ].getUname( ), "my account B" ) == 0 );
    //accounts[ 1 ].setUname( "hoge" ); // ϥѥǤʤ
    
/*
    //
    ac -> setUID( );
    TEST( ac -> getUID( ) == 0 );
    ac -> setActivate( );
    TEST( ac -> getActivate( ) == false );
    ac -> setAddress( );
    TEST( ac -> getAddress( ) == 0 );
    ac -> setInstitute( );
    TEST( ac -> getInstitute( ) == 0 );
    ac -> setTel( );
    TEST( ac -> getTel( ) == 0 );
    ac -> setOrganization( );
    TEST( ac -> getOrganization( ) == 0 );
    ac -> setCountry( );
    TEST( ac -> getCountry( ) == 0 );
    ac -> setZipcode( );
    TEST( ac -> getZipcode( ) == 0 );
    ac -> setFax( );
    TEST( ac -> getFax( ) == 0 );
    ac -> setBaseURL( );
    TEST( ac -> getBaseURL( ) == 0 );
    ac -> setNoticeMail( );
    TEST( ac -> getNoticeMail( ) == 1 );
    ac -> setNoticeMailSince( );
    TEST( ac -> getNoticeMailSince( ) == 0 );
    
    ac -> setUname( );
    TEST( ac -> getUname( ) == 0 );
    ac -> setName( );
    TEST( ac -> getName( ) == 0 );
    ac -> setEmail( );
    TEST( ac -> getEmail( ) == 0 );
    ac -> setURL( );
    TEST( ac -> getURL( ) == 0 );
    ac -> setUserAvatar( );
    TEST( ac -> getUserAvatar( ) == 0 );
    ac -> setUserRegdate( );
    TEST( ac -> getUserRegdate( ) == 0 );
    ac -> setUserIcq( );
    TEST( ac -> getUserIcq( ) == 0 );
    ac -> setUserFrom( );
    TEST( ac -> getUserFrom( ) == 0 );
    ac -> setUserSig( );
    TEST( ac -> getUserSig( ) == 0 );
    ac -> setUserViewemail( );
    TEST( ac -> getUserViewemail( ) == 0 );
    ac -> setActkey( );
    TEST( ac -> getActkey( ) == 0 );
    ac -> setUserAim( );
    TEST( ac -> getUserAim( ) == 0 );
    ac -> setUserYim( );
    TEST( ac -> getUserYim( ) == 0 );
    ac -> setUserMsnm( );
    TEST( ac -> getUserMsnm( ) == 0 );
    ac -> setPass( );
    TEST( ac -> getPass( ) == 0 );
    ac -> setPosts( );
    TEST( ac -> getPosts( ) == 0 );
    ac -> setAttachsig( );
    TEST( ac -> getAttachsig( ) == 0 );
    ac -> setRank( );
    TEST( ac -> getRank( ) == 0 );
    ac -> setLevel( );
    TEST( ac -> getLevel( ) == 0 );
    ac -> setTheme( );
    TEST( ac -> getTheme( ) == 0 );
    ac -> setTimezoneOffset( );
    TEST( ac -> getTimezoneOffset( ) == 0.0 );
    ac -> setLastLogin( );
    TEST( ac -> getLastLogin( ) == 0 );
    ac -> setUmode( );
    TEST( ac -> getUmode( ) == 0 );
    ac -> setUorder( );
    TEST( ac -> getUorder( ) == 0 );
    ac -> setNotifyMethod( );
    TEST( ac -> getNotifyMethod( ) == 0 );
    ac -> setNotifyMode( );
    TEST( ac -> getNotifyMode( ) == 0 );
    ac -> setUserOcc( );
    TEST( ac -> getUserOcc( ) == 0 );
    ac -> setBio( );
    TEST( ac -> getBio( ) == 0 );
    ac -> setUserIntrest( );
    TEST( ac -> getUserIntrest( ) == 0 );
    ac -> setUserMailok( );
    TEST( ac -> getUserMailok( ) == 0 );
*/
    
    delete ac;
}
