/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * $Revision: 1.59 $
 * XNPAL: XooNiPs Platform Abstract Layer
 * zend_parse_parametersphp4.1.0ɬ
 * .soեϳ鸫ʤ֤٤
 * C++Ǥϡextern "C"{}, BEGIN/END_EXTERN_C()ɬס
 */


#include <stdio.h>
#include "criteria.h"
#include "common.h"
#include "commonal.h"
#include "session.h"
#include "group.h"
#include "index.h"
#include "xnpal.h"
#include "amazonbook.h"

// for inet_aton
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

// global variables

PHP_MSHUTDOWN_FUNCTION(xnpalmod)
{
	uninitializeDB();
	return SUCCESS;
}

PHP_RINIT_FUNCTION(xnpalmod)
{
    useSyslog(false);
	return SUCCESS;
}

/* declaration of functions to be exported */
extern "C" {
ZEND_FUNCTION(first_module         );
ZEND_FUNCTION(xnp_initialize_db     );
ZEND_FUNCTION(xnp_login_user        );
ZEND_FUNCTION(xnp_logout_user       );
ZEND_FUNCTION(xnp_create_session    );
ZEND_FUNCTION(xnp_get_session       );
ZEND_FUNCTION(xnp_is_activated      );
ZEND_FUNCTION(xnp_activate          );
ZEND_FUNCTION(xnp_get_account_count );
ZEND_FUNCTION(xnp_delete_account    );
ZEND_FUNCTION(xnp_get_account       );
ZEND_FUNCTION(xnp_get_accounts      );
ZEND_FUNCTION(xnp_insert_account    );
ZEND_FUNCTION(xnp_update_account    );
ZEND_FUNCTION(xnp_dump_uids         );
ZEND_FUNCTION(xnp_get_group_count   );
ZEND_FUNCTION(xnp_get_groups_by_uid );
ZEND_FUNCTION(xnp_is_group_admin    );
ZEND_FUNCTION(xnp_dump_gids         );
ZEND_FUNCTION(xnp_dump_group_admins );
ZEND_FUNCTION(xnp_delete_member     );
ZEND_FUNCTION(xnp_insert_member     );
ZEND_FUNCTION(xnp_get_members       );
ZEND_FUNCTION(xnp_delete_group      );
ZEND_FUNCTION(xnp_insert_group      );
ZEND_FUNCTION(xnp_update_group      );
ZEND_FUNCTION(xnp_get_group         );
ZEND_FUNCTION(xnp_get_groups        );
ZEND_FUNCTION(xnp_is_moderator      );
ZEND_FUNCTION(xnp_get_uid           );

ZEND_FUNCTION(xnp_get_all_indexes     );
ZEND_FUNCTION(xnp_get_indexes         );
ZEND_FUNCTION(xnp_insert_index        );
ZEND_FUNCTION(xnp_update_index        );
ZEND_FUNCTION(xnp_delete_index        );
ZEND_FUNCTION(xnp_get_index           );
ZEND_FUNCTION(xnp_is_index_readable   );
ZEND_FUNCTION(xnp_is_index_writable   );
ZEND_FUNCTION(xnp_swap_index_sort_number );

ZEND_FUNCTION(xnp_is_valid_session_id );
ZEND_FUNCTION(xnp_get_last_error_string );

ZEND_FUNCTION(xnp_test_criteria     );
ZEND_FUNCTION(xnp_test_uids         );


ZEND_FUNCTION(xnp_get_item_permission      );
ZEND_FUNCTION(xnp_get_index_permission     );
ZEND_FUNCTION(xnp_get_certify_permission   );

ZEND_FUNCTION(xnp_get_certify_state        );
ZEND_FUNCTION(xnp_set_certify_state        );

ZEND_FUNCTION(xnp_insert_change_log        );
ZEND_FUNCTION(xnp_get_change_logs          );

ZEND_FUNCTION(xnp_get_config_value         );
ZEND_FUNCTION(xnp_set_config_value         );

ZEND_FUNCTION(xnp_dump_item_id             );
ZEND_FUNCTION(xnp_get_item_id_by_binder_id );
ZEND_FUNCTION(xnp_get_item_id_by_index_id  );
ZEND_FUNCTION(xnp_get_overlapped_items     );

ZEND_FUNCTION(xnp_insert_item              );
ZEND_FUNCTION(xnp_insert_item_direct       );
ZEND_FUNCTION(xnp_update_item              );
ZEND_FUNCTION(xnp_delete_item              );
ZEND_FUNCTION(xnp_get_item                 );
ZEND_FUNCTION(xnp_get_items                );

ZEND_FUNCTION(xnp_pubmed_complete          );
ZEND_FUNCTION(xnp_amazon_complete          );

//ZEND_FUNCTION(xnp_uninitialize_db          );

ZEND_FUNCTION(xnp_register_binder_item     );
ZEND_FUNCTION(xnp_unregister_binder_item   );

ZEND_FUNCTION(xnp_register_item            );
ZEND_FUNCTION(xnp_unregister_item          );

ZEND_FUNCTION(xnp_get_uncertified_link     );
ZEND_FUNCTION(xnp_get_private_item_id      );
ZEND_FUNCTION(xnp_get_group_item_id        );

ZEND_FUNCTION(xnp_get_item_types           );
ZEND_FUNCTION(xnp_get_index_id_by_item_id  );
ZEND_FUNCTION(xnp_get_own_public_item_id   );

ZEND_FUNCTION(xnp_zip_create               );
ZEND_FUNCTION(xnp_get_item_count           );
ZEND_FUNCTION(xnp_get_item_count_group_by_index );

ZEND_FUNCTION(xnp_extract_public_item_id);
ZEND_FUNCTION(xnp_extract_nonbinder_item_id);
ZEND_FUNCTION(xnp_insert_event);
ZEND_FUNCTION(xnp_get_events);
ZEND_FUNCTION(xnp_get_events_for_rss);

ZEND_FUNCTION(xnp_update_item_status       );
ZEND_FUNCTION(xnp_refresh_item_status      );
ZEND_FUNCTION(xnp_selective_harvesting     );
ZEND_FUNCTION(xnp_get_item_status          );

ZEND_FUNCTION(xnp_insert_related_to );
ZEND_FUNCTION(xnp_delete_related_to );
ZEND_FUNCTION(xnp_get_related_to    );

ZEND_FUNCTION(xnp_use_syslog               );
};


#ifdef ZEND_ENGINE_2
static
	ZEND_BEGIN_ARG_INFO(second_and_third_args_force_ref, 0)
		ZEND_ARG_PASS_INFO(0)
		ZEND_ARG_PASS_INFO(1)
		ZEND_ARG_PASS_INFO(1)
	ZEND_END_ARG_INFO();
#else
static   unsigned char fourth_arg_force_ref[] = { 4, BYREF_NONE, BYREF_NONE, BYREF_NONE, BYREF_FORCE };
static   unsigned char second_and_third_args_force_ref[] = { 3, BYREF_NONE, BYREF_FORCE, BYREF_FORCE };
#endif


/* compiled function list so Zend knows what's in this module */
zend_function_entry xnpalmod_functions[] =
{
	ZEND_FE(first_module          ,NULL)
	ZEND_FE(xnp_initialize_db     ,NULL)
	ZEND_FE(xnp_login_user        ,third_arg_force_ref)
	ZEND_FE(xnp_logout_user       ,NULL)
	ZEND_FE(xnp_create_session    ,third_arg_force_ref)
	ZEND_FE(xnp_get_session       ,second_arg_force_ref )
	ZEND_FE(xnp_is_activated      ,NULL)
	ZEND_FE(xnp_activate          ,NULL)
	ZEND_FE(xnp_get_account_count ,NULL)
	ZEND_FE(xnp_delete_account    ,NULL)
	ZEND_FE(xnp_get_account       ,third_arg_force_ref)
	ZEND_FE(xnp_get_accounts      ,fourth_arg_force_ref)
	ZEND_FE(xnp_insert_account    ,third_arg_force_ref)
	ZEND_FE(xnp_update_account    ,NULL)
	ZEND_FE(xnp_dump_uids         ,third_arg_force_ref)
	ZEND_FE(xnp_get_group_count   ,NULL)
	ZEND_FE(xnp_get_groups_by_uid ,fourth_arg_force_ref)
	ZEND_FE(xnp_is_group_admin    ,NULL)
	ZEND_FE(xnp_dump_gids         ,third_arg_force_ref)
	ZEND_FE(xnp_dump_group_admins ,NULL)
	ZEND_FE(xnp_delete_member     ,NULL)
	ZEND_FE(xnp_insert_member     ,NULL)
	ZEND_FE(xnp_get_members       ,fourth_arg_force_ref)
	ZEND_FE(xnp_delete_group      ,NULL)
	ZEND_FE(xnp_insert_group      ,third_arg_force_ref)
	ZEND_FE(xnp_update_group      ,NULL)
	ZEND_FE(xnp_get_group         ,third_arg_force_ref)
	ZEND_FE(xnp_get_groups        ,fourth_arg_force_ref)
	ZEND_FE(xnp_is_moderator      ,NULL)
	ZEND_FE(xnp_get_uid           ,second_arg_force_ref)

	ZEND_FE(xnp_get_all_indexes     ,third_arg_force_ref)
	ZEND_FE(xnp_get_indexes         ,fourth_arg_force_ref)
	ZEND_FE(xnp_insert_index        ,third_arg_force_ref)
	ZEND_FE(xnp_update_index        ,NULL)
	ZEND_FE(xnp_delete_index        ,NULL)
	ZEND_FE(xnp_get_index           ,third_arg_force_ref)
	ZEND_FE(xnp_is_index_readable   ,NULL)
	ZEND_FE(xnp_is_index_writable   ,NULL)
	ZEND_FE(xnp_swap_index_sort_number ,NULL)

	ZEND_FE(xnp_is_valid_session_id ,NULL)
	ZEND_FE(xnp_get_last_error_string ,NULL)
	ZEND_FE(xnp_test_criteria     ,NULL)
	ZEND_FE(xnp_test_uids         ,NULL)

	ZEND_FE(xnp_get_item_permission      ,NULL)
	ZEND_FE(xnp_get_index_permission     ,NULL)
	ZEND_FE(xnp_get_certify_permission   ,NULL)

	ZEND_FE(xnp_get_certify_state        ,fourth_arg_force_ref)
	ZEND_FE(xnp_set_certify_state        ,NULL)

	ZEND_FE(xnp_insert_change_log        ,NULL)
	ZEND_FE(xnp_get_change_logs          ,third_arg_force_ref)

	ZEND_FE(xnp_get_config_value         ,second_arg_force_ref)
	ZEND_FE(xnp_set_config_value         ,NULL)

	ZEND_FE(xnp_dump_item_id             ,NULL)
	ZEND_FE(xnp_get_item_id_by_binder_id ,fourth_arg_force_ref)
	ZEND_FE(xnp_get_item_id_by_index_id  ,fourth_arg_force_ref)
	ZEND_FE(xnp_get_overlapped_items     ,NULL) /*?*/

	ZEND_FE(xnp_insert_item              ,third_arg_force_ref)
	ZEND_FE(xnp_insert_item_direct       ,third_arg_force_ref)
	ZEND_FE(xnp_update_item              ,NULL)
	ZEND_FE(xnp_delete_item              ,NULL)
	ZEND_FE(xnp_get_item                 ,third_arg_force_ref)
	ZEND_FE(xnp_get_items                ,fourth_arg_force_ref)

	ZEND_FE(xnp_pubmed_complete          ,second_arg_force_ref)
	ZEND_FE(xnp_amazon_complete          ,second_arg_force_ref)

//    ZEND_FE(xnp_uninitialize_db          ,NULL)

	ZEND_FE(xnp_register_binder_item     ,NULL)
	ZEND_FE(xnp_unregister_binder_item   ,NULL)

	ZEND_FE(xnp_register_item            ,NULL)
	ZEND_FE(xnp_unregister_item          ,NULL)

	ZEND_FE(xnp_get_uncertified_link     ,second_and_third_args_force_ref)
	ZEND_FE(xnp_get_private_item_id      ,third_arg_force_ref)
	ZEND_FE(xnp_get_group_item_id        ,third_arg_force_ref)

	ZEND_FE(xnp_get_item_types           ,first_arg_force_ref)
    
    ZEND_FE(xnp_get_index_id_by_item_id  ,third_arg_force_ref)
    ZEND_FE(xnp_get_own_public_item_id   ,third_arg_force_ref)

    ZEND_FE(xnp_zip_create               ,NULL)
    ZEND_FE(xnp_get_item_count           ,NULL)
    ZEND_FE(xnp_get_item_count_group_by_index ,second_arg_force_ref)

    ZEND_FE(xnp_extract_public_item_id   ,third_arg_force_ref)
    ZEND_FE(xnp_extract_nonbinder_item_id,third_arg_force_ref)
    ZEND_FE(xnp_insert_event             ,NULL)
    ZEND_FE(xnp_get_events               ,second_arg_force_ref)
    ZEND_FE(xnp_get_events_for_rss       ,NULL)

    ZEND_FE(xnp_update_item_status       ,NULL)
    ZEND_FE(xnp_refresh_item_status      ,NULL)
    ZEND_FE(xnp_selective_harvesting     ,NULL)
    ZEND_FE(xnp_get_item_status          ,NULL)

    ZEND_FE(xnp_insert_related_to        ,NULL)
    ZEND_FE(xnp_delete_related_to        ,NULL)
    ZEND_FE(xnp_get_related_to           ,NULL)

    ZEND_FE(xnp_use_syslog               ,NULL)
    {NULL, NULL, NULL}
};

/* compiled module information */
zend_module_entry xnpalmod_module_entry =
{
	STANDARD_MODULE_HEADER,
	"XNPAL",
	xnpalmod_functions,
	NULL,
	PHP_MSHUTDOWN(xnpalmod),
	PHP_RINIT(xnpalmod),
	NULL,
	NULL,
	NO_VERSION_YET,
	STANDARD_MODULE_PROPERTIES
};

/* implement standard "stub" routine to introduce ourselves to Zend */
#if COMPILE_DL_FIRST_MODULE
BEGIN_EXTERN_C()
ZEND_GET_MODULE(xnpalmod)
END_EXTERN_C()
#endif


/* implement function that is meant to be made available to PHP */
ZEND_FUNCTION(first_module)
{
	long parameter;
//	if(ZEND_NUM_ARGS() != 2) WRONG_PARAM_COUNT;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "l", &parameter) == FAILURE) {
		return;
	}
	parameter++;
	RETURN_LONG(parameter);
}
/** zvalCʸ롣
  */
char *getZvalString( zval **p ){
	convert_to_string_ex(p);
	return Z_STRVAL_PP(p); //(**p).value.str.val;
}

/** zvalint롣
  */
int getZvalInt( zval **p ){
	convert_to_long_ex(p);
	return Z_LVAL_PP(p); // (int)(**p).value.lval;
}

// keylen\0ޤࡣ
static void print_hash_key( int res, const char *key, uint keyLen, ulong index ){
	zend_printf( "print_hash_key : key=0x%08x keylen=%08d index=%08d<br>  ", key, keyLen, index );
	if ( res == HASH_KEY_IS_STRING ){
		char *p = new char[keyLen+1];
		memcpy( p, key, keyLen );
		p[keyLen] = 0;
		zend_printf( "  key is string[%s]<br>\n", p );
	}
	else {
		zend_printf( "  key is integer[%d]<br>\n", index );
	}
}


/** zval*criteria_t뤿Υ饹ԤʤgetResult()!=RES_OK <br>
	criteria :
	array( 'start'=>0, 'rows'=>10,
	   'orders'=>array(
		array('name'=>'id','order'=>'0'),
		array('name'=>'timestamp','name'=>'1'), ...)
	); ʷϢ
  */
class zCriteria_t : public criteria {
private:
	result_t result;

	// pz: array('name'=>'timestamp','name'=>'1')
	// 줫orderbyɲá
	void setOrder( zval *pz ){
		char *column = 0;
		order_t order = (order_t)0;

		HashPosition pos;
		zval **ppzTmp = 0;
		int res2;
		zend_hash_internal_pointer_reset_ex(Z_ARRVAL_P(pz), &pos);
		while ( (res2=zend_hash_get_current_data_ex(Z_ARRVAL_P(pz), (void **)&ppzTmp, &pos)) == SUCCESS ) {
			char *key = 0;
			uint keyLen = 0;
			ulong index = 0;
			int keyType = zend_hash_get_current_key_ex(Z_ARRVAL_P(pz), &key, &keyLen, &index, false/*duplicate flag*/, &pos );
			if ( keyType == HASH_KEY_IS_STRING/*1*/ ||  keyType == HASH_KEY_IS_LONG/*2*/ ){
				//print_hash_key( keyType, key, keyLen, index );
				if ( strncasecmp( key, "name", keyLen ) == 0 && keyLen == 5 ){
					SEPARATE_ZVAL(ppzTmp);
					column = getZvalString(ppzTmp);
//					zend_printf( "column=%s<br>\n", column );
				}
				else if ( strncasecmp( key, "order", keyLen ) == 0 && keyLen == 6 ){
					SEPARATE_ZVAL(ppzTmp);
					order = (order_t)getZvalInt(ppzTmp);
//					zend_printf( "order=%d<br>\n", order );
				}
			}

			zend_hash_move_forward_ex(Z_ARRVAL_P(pz), &pos);
		}
		if ( column ){
			orderby *o = new orderby( column, order );
			addOrderBy( o );
		}

		result = RES_OK;
	}

	// pz: array( array('column'=>'hoge','order'=>'1'), array('column'=>'huga','order'=>'2'), ...)
	void setOrders( zval *pz ){
		HashPosition pos;

		zend_hash_internal_pointer_reset_ex(Z_ARRVAL_P(pz), &pos);

		zval **ppzTmp = 0;
		int res2;
		while ( (res2=zend_hash_get_current_data_ex(Z_ARRVAL_P(pz), (void **)&ppzTmp, &pos)) == SUCCESS ) {
			char *key = 0;
			uint keyLen = 0;
			ulong index = 0;
			int keyType = zend_hash_get_current_key_ex(Z_ARRVAL_P(pz), &key, &keyLen, &index, false/*duplicate flag*/, &pos );
			if ( keyType == HASH_KEY_IS_STRING/*1*/ ||  keyType == HASH_KEY_IS_LONG/*2*/ ){
				//print_hash_key( keyType, key, keyLen, index );
				setOrder( *ppzTmp );
			}
			zend_hash_move_forward_ex(Z_ARRVAL_P(pz), &pos);
		}
		result = RES_OK;
	}

	void initialize( zval *pz ){
		HashPosition pos;
		zval **ppzTmp = 0;
		int res2;
		zend_hash_internal_pointer_reset_ex(Z_ARRVAL_P(pz), &pos);
		while ( (res2=zend_hash_get_current_data_ex(Z_ARRVAL_P(pz), (void **)&ppzTmp, &pos)) == SUCCESS ) {
			char *key = 0;
			uint keyLen = 0;
			ulong index = 0;
			int keyType = zend_hash_get_current_key_ex(Z_ARRVAL_P(pz), &key, &keyLen, &index, false/*duplicate flag*/, &pos );
			if ( keyType == HASH_KEY_IS_STRING/*1*/ ||  keyType == HASH_KEY_IS_LONG/*2*/ ){
				//print_hash_key( keyType, key, keyLen, index );
				if ( strncasecmp( key, "start", keyLen ) == 0 && keyLen == 6 ){
					SEPARATE_ZVAL(ppzTmp);
					int tmp = getZvalInt(ppzTmp);
//					zend_printf( "start=%d<br>\n", tmp );
					setLimit( tmp, getLimitRows() );
				}
				else if ( strncasecmp( key, "rows", keyLen ) == 0 && keyLen == 5 ){
					SEPARATE_ZVAL(ppzTmp);
					int tmp = getZvalInt(ppzTmp);
//					zend_printf( "rows=%d<br>\n", tmp );
					setLimit( getLimitStart(), tmp );
				}
				else if ( strncasecmp( key, "orders", keyLen ) == 0 && keyLen == 7 ){
					setOrders( *ppzTmp );
				}
				else
					;	// ignore unknown key
			}
			else
				; // ignore bad key
			zend_hash_move_forward_ex(Z_ARRVAL_P(pz), &pos);
		}
		result = RES_OK;
	}

public:
	zCriteria_t() : criteria(){ result = RES_ERROR; }
	zCriteria_t( zval *pz ) : criteria(){ initialize(pz); }
	zCriteria_t( zval **ppz ) : criteria() { initialize(*ppz); }
	result_t getResult(){ return result; };

	void dump(){
		zend_printf( "dumping zCriteria...<br>\n" );
		zend_printf( "result=%d<br>\n", (int)result );
		zend_printf( "start=%d, rows=%d<br>\n", getLimitStart(), getLimitRows() );
		const orderby *p = headOrderBy();
		while ( p ){
			zend_printf( "column=%s, order=%d<br>\n", p->getColumn(), p->getOrder() );
			p = nextOrderBy();
		}
	}
};


/** Ϣ˥longͤ롣
  @param   ht   Ϣ
  @param   key  
  @param   val  longͤݥ
  @return  ʤtrue
 */
static bool hashGetLong( HashTable *ht, const char *key, long *val ){
	zval         **tmp;
	if( zend_hash_find( ht, (char *)key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_long_ex( tmp );
		*val = Z_LVAL_PP(tmp);
		return true;
	}
	return false;
}

/** Ϣ˥ʸ롣
  @param   ht   Ϣ
  @param   key  
  @param   val  ʸݥ
  @return  ʤtrue
 */
static bool hashGetString( HashTable *ht, const char *key, char **val ){
	zval         **tmp;
	if( zend_hash_find( ht, (char *)key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_string_ex( tmp );
		*val = Z_STRVAL_PP(tmp);
		return true;
	}
	return false;
}

/** Ϣ˥doubleͤ롣
  @param   ht   Ϣ
  @param   key  
  @param   val  doubleͤݥ
  @return  ʤtrue
 */
static bool hashGetDouble( HashTable *ht, const char *key, double *val ){
	zval         **tmp;
	if( zend_hash_find( ht, (char *)key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_double_ex( tmp );
		*val = Z_DVAL_PP(tmp);
		return true;
	}
	return false;
}

/** zval*account뤿Υ饹 <br>
	ԤʤgetResult()!=RES_OK <br>
  */
class zAccount_t : public account {
private:
	result_t result;
	void initialize(zval *pz){
		HashTable *ht = Z_ARRVAL_P(pz);
		long l;
		char *p;
		double d;
		if ( hashGetLong  ( ht, "uid"               , &l ) ) setUID              ( l );
		if ( hashGetString( ht, "uname"             , &p ) ) setUname            ( p );
		if ( hashGetString( ht, "name"              , &p ) ) setName             ( p );
		if ( hashGetString( ht, "email"             , &p ) ) setEmail            ( p );
		if ( hashGetString( ht, "url"               , &p ) ) setURL              ( p );
		if ( hashGetString( ht, "user_avatar"       , &p ) ) setUserAvatar       ( p );
		if ( hashGetString( ht, "user_icq"          , &p ) ) setUserIcq          ( p );
		if ( hashGetString( ht, "user_from"         , &p ) ) setUserFrom         ( p );
		if ( hashGetString( ht, "user_sig"          , &p ) ) setUserSig          ( p );
		if ( hashGetString( ht, "actkey"            , &p ) ) setActkey           ( p );
		if ( hashGetString( ht, "user_aim"          , &p ) ) setUserAim          ( p );
		if ( hashGetString( ht, "user_yim"          , &p ) ) setUserYim          ( p );
		if ( hashGetString( ht, "user_msnm"         , &p ) ) setUserMsnm         ( p );
		if ( hashGetString( ht, "pass"              , &p ) ) setPass             ( p );
		if ( hashGetString( ht, "theme"             , &p ) ) setTheme            ( p );
		if ( hashGetString( ht, "umode"             , &p ) ) setUmode            ( p );
		if ( hashGetString( ht, "user_occ"          , &p ) ) setUserOcc          ( p );
		if ( hashGetString( ht, "bio"               , &p ) ) setBio              ( p );
		if ( hashGetString( ht, "user_intrest"      , &p ) ) setUserIntrest      ( p );
		if ( hashGetDouble( ht, "timezone_offset"   , &d ) ) setTimezoneOffset   ( d );
		if ( hashGetLong  ( ht, "attachsig"         , &l ) ) setAttachsig        ( l );
		if ( hashGetLong  ( ht, "last_login"        , &l ) ) setLastLogin        ( l );
		if ( hashGetLong  ( ht, "level"             , &l ) ) setLevel            ( l );
		if ( hashGetLong  ( ht, "notify_method"     , &l ) ) setNotifyMethod     ( l );
		if ( hashGetLong  ( ht, "notify_mode"       , &l ) ) setNotifyMode       ( l );
		if ( hashGetLong  ( ht, "posts"             , &l ) ) setPosts            ( l );
		if ( hashGetLong  ( ht, "rank"              , &l ) ) setRank             ( l );
		if ( hashGetLong  ( ht, "uorder"            , &l ) ) setUorder           ( l );
		if ( hashGetLong  ( ht, "user_mailok"       , &l ) ) setUserMailok       ( l );
		if ( hashGetLong  ( ht, "user_regdate"      , &l ) ) setUserRegdate      ( l );
		if ( hashGetLong  ( ht, "user_viewemail"    , &l ) ) setUserViewemail    ( l );
		if ( hashGetLong  ( ht, "activate"          , &l ) ) setActivate         ( l );
		if ( hashGetString( ht, "address"           , &p ) ) setAddress          ( p );
		if ( hashGetString( ht, "division"          , &p ) ) setDivision         ( p );
		if ( hashGetString( ht, "tel"               , &p ) ) setTel              ( p );
		if ( hashGetString( ht, "company_name"      , &p ) ) setCompanyName      ( p );
		if ( hashGetString( ht, "country"           , &p ) ) setCountry          ( p );
		if ( hashGetString( ht, "zipcode"           , &p ) ) setZipcode          ( p );
		if ( hashGetString( ht, "fax"               , &p ) ) setFax              ( p );
		if ( hashGetLong  ( ht, "notice_mail"       , &l ) ) setNoticeMail       ( l );
		if ( hashGetLong  ( ht, "notice_mail_since" , &l ) ) setNoticeMailSince  ( l );
		if ( hashGetLong  ( ht, "private_index_id " , &l ) ) setPrivateIndexID   ( l );
		if ( hashGetLong  ( ht, "item_number_limit" , &l ) ) setItemNumberLimit  ( l );
		if ( hashGetLong  ( ht, "index_number_limit", &l ) ) setIndexNumberLimit ( l );
		if ( hashGetDouble( ht, "item_storage_limit", &d ) ) setItemStorageLimit ( d );

		result = RES_OK;
	}
public:
	zAccount_t() : account(){ result = RES_ERROR; }

	/** 󥹥ȥ饯
	  @param pz  array( 'uid'=>1, 'uname'=>'root', ... ); ʷϢ */
	zAccount_t( zval *pz ) : account(){ initialize(pz); }
	zAccount_t( zval **ppz ) : account() { initialize(*ppz); }
	result_t getResult(){ return result; };
};

class zIndex_t : public index {
private:
	result_t result;

	void initialize(zval *pz){
		HashTable *ht = Z_ARRVAL_P(pz);
		long l;
		char *p;
		if ( hashGetLong  ( ht, "item_id"           , &l ) ) setItemID           ( l );
		if ( hashGetLong  ( ht, "item_type_id"      , &l ) ) setItemTypeID       ( l );
		if ( hashGetLong  ( ht, "contributor_uid"   , &l ) ) setContributorUID   ( l );
		if ( hashGetString( ht, "title"             , &p ) ) setTitle            ( p );
		if ( hashGetString( ht, "keywords"          , &p ) ) setKeywords         ( p );
		if ( hashGetString( ht, "description"       , &p ) ) setDescription      ( p );
		if ( hashGetLong  ( ht, "last_update_date"  , &l ) ) setLastUpdateDate   ( l );
		if ( hashGetLong  ( ht, "creation_date"     , &l ) ) setCreationDate     ( l );
		if ( hashGetLong  ( ht, "parent_index_id"   , &l ) ) setParentIndexID    ( l );
		if ( hashGetLong  ( ht, "owner_uid"         , &l ) ) setOwnerUID         ( l );
		if ( hashGetLong  ( ht, "owner_gid"         , &l ) ) setOwnerGID         ( l );
		if ( hashGetLong  ( ht, "open_level"        , &l ) ) setOpenLevel        ( l );
		if ( hashGetLong  ( ht, "sort_number"       , &l ) ) setSortNumber       ( l );

		result = RES_OK;
	}
public:
	zIndex_t() : index(){ result = RES_ERROR; }
	zIndex_t( zval *pz ) : index(){ initialize(pz); }
	zIndex_t( zval **ppz ) : index() { initialize(*ppz); }
	result_t getResult(){ return result; };

	void dump(){
	}
};

/** zval*(userid_t *puid,int uidLen)뤿Υ饹 <br>
	ԤʤgetResult()!=RES_OK <br>
  */
class zUIDs_t {
private:
	result_t result;
	userid_t *pUID;
	int len;
public:
	zUIDs_t(){
		pUID = 0;
		len = 0;
		result = RES_ERROR;
	}

	/** 󥹥ȥ饯
	  @param pza  array( '1', '3', '4', '6', ... ); ʷ */
	zUIDs_t( zval *pza ){
		pUID = 0;
		len = 0;
		result = RES_ERROR;

		if ( Z_TYPE_P(pza) != IS_ARRAY ){
			result = RES_ERROR;
		}
		else {
			len = zend_hash_num_elements(Z_ARRVAL_P(pza));
			if(len == 0) {
				pUID = new userid_t[1];
				result = RES_OK;
			}
			else {
				/* php/ext/standard/string.c  implodeΤ򻲹ͤˡ
				   zend_hash_*ΥɥȤäƤΤ
				*/
				zval         **tmp;
				HashPosition   pos;
				int i = 0;
				pUID = new userid_t[len];

				zend_hash_internal_pointer_reset_ex(Z_ARRVAL_P(pza), &pos);
				while (zend_hash_get_current_data_ex(Z_ARRVAL_P(pza), (void **) &tmp, &pos) == SUCCESS ) {
					SEPARATE_ZVAL(tmp); // zend.arguments.write-safety.html 
					convert_to_long_ex(tmp);
					if ( i < len )
						pUID[i++] = Z_LVAL_PP(tmp);
					zend_hash_move_forward_ex(Z_ARRVAL_P(pza), &pos);
				}
				len = i;
				result = RES_OK;
			}
		}
	}

	~zUIDs_t(){
		if ( pUID ) delete[] pUID;
	}
	result_t getResult(){ return result; }
	userid_t *getPUID(){ return pUID; }
	int getLen(){ return len; }
	void dump(){
	zend_printf( "dumping zUIDs...<br>\n" );
		zend_printf( "result=%d<br>\n", (int)result );
		zend_printf( "len=%d<br>\n", len );
		for ( int i = 0; i < len; i++ ){
			zend_printf( "pUID[%d] = %d<br>\n", i, pUID[i] );
		}
	}
};

/** zval*(itemid_t *piid,int iidLen)뤿Υ饹 <br>
	ԤʤgetResult()!=RES_OK <br>
  */
class zIIDs_t {
private:
	result_t result;
	itemid_t *pIID;
	int len;
public:
	zIIDs_t(){
		pIID = 0;
		len = 0;
		result = RES_ERROR;
	}

	/** 󥹥ȥ饯
	  @param pza  array( '1', '3', '4', '6', ... ); ʷ */
	zIIDs_t( zval *pza ){
		pIID = 0;
		len = 0;
		result = RES_ERROR;

		if ( Z_TYPE_P(pza) != IS_ARRAY ){
			result = RES_ERROR;
		}
		else {
			len = zend_hash_num_elements(Z_ARRVAL_P(pza));
			if(len == 0) {
				pIID = new itemid_t[1];
				result = RES_OK;
			}
			else {
				/* php/ext/standard/string.c  implodeΤ򻲹ͤˡ
				   zend_hash_*ΥɥȤäƤΤ
				*/
				zval         **tmp;
				HashPosition   pos;
				int i = 0;
				pIID = new itemid_t[len];

				zend_hash_internal_pointer_reset_ex(Z_ARRVAL_P(pza), &pos);
				while (zend_hash_get_current_data_ex(Z_ARRVAL_P(pza), (void **) &tmp, &pos) == SUCCESS ) {
					SEPARATE_ZVAL(tmp); // zend.arguments.write-safety.html 
					convert_to_long_ex(tmp);
					if ( i < len )
						pIID[i++] = Z_LVAL_PP(tmp);
					zend_hash_move_forward_ex(Z_ARRVAL_P(pza), &pos);
				}
				len = i;
				result = RES_OK;
			}
		}
	}

	~zIIDs_t(){
		if ( pIID ) delete[] pIID;
	}
	result_t getResult(){ return result; }
	itemid_t *getPIID(){ return pIID; }
	int getLen(){ return len; }
	void dump(){
	zend_printf( "dumping zIIDs...<br>\n" );
		zend_printf( "result=%d<br>\n", (int)result );
		zend_printf( "len=%d<br>\n", len );
		for ( int i = 0; i < len; i++ ){
			zend_printf( "pIID[%d] = %d<br>\n", i, pIID[i] );
		}
	}
};

/**
 *
 * amazonbook_tƤPHPѴ
 * @param pAmazonbook Ѵamazonbook_t*
 * @param z        Ѵ̤񤭹(ѤߤǤ뤳)
 * @return RES_OK
 *
 */
result_t amazonbookToZval( const amazonbook_t *pAmazonbook, zval *z )
{
	zend_hash_clean( z -> value.ht );
	
	add_assoc_string( z, "title", ( char* )pAmazonbook -> getTitle( ), 1 );
	add_assoc_string( z, "author", ( char* )pAmazonbook -> getAuthor( ), 1 );
	add_assoc_string( z, "publisher", ( char* )pAmazonbook -> getPublisher( ), 1 );
	add_assoc_long( z, "year_of_publication", pAmazonbook -> getYearOfPublication( ) );
	add_assoc_string( z, "isbn", ( char* )pAmazonbook -> getISBN( ), 1 );
	add_assoc_string( z, "url", ( char* )pAmazonbook -> getURL( ), 1 );
	
	return RES_OK;
}

/**
 *
 * pubmed_tƤPHPѴ
 * @param pPubmed Ѵpubmed_t*
 * @param z        Ѵ̤񤭹(ѤߤǤ뤳)
 * @return RES_OK
 *
 */
result_t pubmedToZval( const pubmed_t *pPubmed, zval *z )
{
	zend_hash_clean( z -> value.ht );
	
	add_assoc_long( z, "pmid", pPubmed -> getID( ) );
	add_assoc_string( z, "title", ( char* )pPubmed -> getTitle( ), 1 );
	add_assoc_string( z, "author", ( char* )pPubmed -> getAuthor( ), 1 );
	add_assoc_string( z, "journal", ( char* )pPubmed -> getJournal( ), 1 );
	add_assoc_long( z, "year_of_publication", pPubmed -> getYearOfPublication( ) );
	add_assoc_long( z, "volume", pPubmed -> getVolume( ) );
	add_assoc_long( z, "number", pPubmed -> getNumber( ) );
	add_assoc_string( z, "page", ( char* )pPubmed -> getPage( ), 1 );
	add_assoc_string( z, "abstract", ( char* )pPubmed -> getAbstract( ), 1 );
	
	return RES_OK;
}

/**
 *
 * itemid_tPHPѴ
 * @param piid Ѵitemid_t
 * @param len  piidĹ
 * @param ppz  Ѵ̤񤭹(ѤߤǤ뤳)
 * @return RES_OK
 *
 */
result_t itemidsToZval( const itemid_t *piid, int len, zval **ppz )
{
	zend_hash_clean( Z_ARRVAL_PP(ppz) );

	// add IDs
	for ( int i = 0; i < len; i++ ){
		add_next_index_long(*ppz, (long)(piid[i]) );
	}

	return RES_OK;
}

/**
 *
 * indexid_tPHPѴ
 * @param piid Ѵindexid_t
 * @param len  piidĹ
 * @param ppz  Ѵ̤񤭹(ѤߤǤ뤳)
 * @return RES_OK
 *
 */
result_t indexidsToZval( const indexid_t *piid, int len, zval **ppz )
{
	zend_hash_clean( Z_ARRVAL_PP(ppz) );
    
	// add IDs
	for ( int i = 0; i < len; i++ ){
		add_next_index_long(*ppz, (long)(piid[i]) );
	}

	return RES_OK;
}

/**
 *
 * uids_tPHPѴ
 *
 * @param pUID Ѵuserid_t
 * @param len pUIDĹ
 * @param pz Ѵ̤񤭹(ѤߤǤ뤳)
 * @return RES_OK
 *
 */
result_t uidsToZval( userid_t *pUID, int len, zval **ppz )
{
	zend_hash_clean( Z_ARRVAL_PP(ppz) );

	// add UIDs
	for ( int i = 0; i < len; i++ ){
		add_next_index_long(*ppz, (long)(pUID[i]) );
	}

	return RES_OK;
}

/**
 *
 * groupid_tPHPѴ
 * @param pGID Ѵgroupid_t
 * @param len  pGIDĹ
 * @param ppz  Ѵ̤񤭹(ѤߤǤ뤳)
 * @return RES_OK
 *
 */
result_t gidsToZval( groupid_t *pGID, int len, zval **ppz )
{
	zend_hash_clean( Z_ARRVAL_PP(ppz) );

	// add GIDs
	for ( int i = 0; i < len; i++ ){
		add_next_index_long(*ppz, (long)(pGID[i]) );
	}

	return RES_OK;
}

/**
 *
 * changelog_tƤPHPѴ
 * @param pChangelog Ѵchangelog_t*
 * @param z        Ѵ̤񤭹(ѤߤǤ뤳)
 * @return RES_OK
 *
 */
result_t changelogToZval( const changelog_t *pChangelog, zval *z )
{
	zend_hash_clean( z -> value.ht );

	add_assoc_long( z, "log_id", pChangelog -> getChangelogID( ) );
	add_assoc_long( z, "item_id", pChangelog -> getItemID( ) );
	add_assoc_long( z, "log_date", pChangelog -> getDate( ) );
	add_assoc_string( z, "log", ( char* )pChangelog -> getLog( ), 1 );

	return RES_OK;
}

/**
 *
 * item_tƤPHPѴ
 * @param pItem Ѵitem_t*
 * @param z        Ѵ̤񤭹(ѤߤǤ뤳)
 * @return RES_OK
 *
 */
result_t itemToZval( const item_t *pItem, zval *z )
{
	zend_hash_clean( z -> value.ht );

	add_assoc_long( z, "item_id", pItem -> getItemID( ) );
	add_assoc_long( z, "item_type_id", pItem -> getItemTypeID( ) );
	add_assoc_long( z, "uid", pItem -> getContributorUID( ) );
	add_assoc_string( z, "title", ( char* )pItem -> getTitle( ), 1 );
	add_assoc_string( z, "keywords", ( char* )pItem -> getKeywords( ), 1 );
	add_assoc_string( z, "description", ( char* )pItem -> getDescription( ), 1 );
	add_assoc_string( z, "doi", ( char* )pItem -> getDOI( ), 1 );
	add_assoc_long( z, "last_update_date", pItem -> getLastUpdateDate( ) );
	add_assoc_long( z, "creation_date", pItem -> getCreationDate( ) );
	add_assoc_long( z, "publication_year", pItem -> getPublicationYear( ) );
	add_assoc_long( z, "publication_month", pItem -> getPublicationMonth( ) );
	add_assoc_long( z, "publication_mday", pItem -> getPublicationMday( ) );
	add_assoc_string( z, "lang", ( char* )pItem -> getLang( ), 1 );

	return RES_OK;
}


result_t itemsToZval( const item_t *pItems, int itemsLen, zval *z )
{
	zend_hash_clean( z -> value.ht );
	for( int i = 0; i < itemsLen; i++ ){
		zval *new_array;
		MAKE_STD_ZVAL(new_array);
		if(array_init(new_array) != SUCCESS){
			return RES_ERROR;
		}
		add_index_zval( z, i, new_array );
		itemToZval( &pItems[ i ], new_array );
	}
	return RES_OK;
}

/**
 *
 * PHPϢƤgroup_tѴ
 *
 * @param z ѴϢ
 * @param pGroup Ѵ̤񤭹॰롼
 * @return RES_OK
 *
 */
result_t zvalToItem( zval *z, item_t* pItem )
{
	zval         **tmp;
	char* key = 0;

	key = "item_id";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_long_ex( tmp ) ;
		pItem -> setItemID( (*tmp) -> value.lval );
	}
	key = "item_type_id";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_long_ex( tmp ) ;
		pItem -> setItemTypeID( (*tmp) -> value.lval );
	}
	key = "uid";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_long_ex( tmp ) ;
		pItem -> setContributorUID( (*tmp) -> value.lval );
	}
	key = "title";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_string_ex( tmp ) ;
		pItem -> setTitle( (*tmp) -> value.str.val );
	}
	key = "keywords";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_string_ex( tmp ) ;
		pItem -> setKeywords( (*tmp) -> value.str.val );
	}
	key = "description";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_string_ex( tmp ) ;
		pItem -> setDescription( (*tmp) -> value.str.val );
	}
	key = "doi";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_string_ex( tmp ) ;
		pItem -> setDOI( (*tmp) -> value.str.val );
	}
	key = "last_update_date";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_long_ex( tmp ) ;
		pItem -> setLastUpdateDate( (*tmp) -> value.lval );
	}
	key = "creation_date";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_long_ex( tmp ) ;
		pItem -> setCreationDate( (*tmp) -> value.lval );
	}
	key = "publication_year";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_long_ex( tmp ) ;
		pItem -> setPublicationYear( (*tmp) -> value.lval );
	}
	key = "publication_month";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_long_ex( tmp ) ;
		pItem -> setPublicationMonth( (*tmp) -> value.lval );
	}
	key = "publication_mday";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_long_ex( tmp ) ;
		pItem -> setPublicationMday( (*tmp) -> value.lval );
	}
	key = "lang";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_string_ex( tmp ) ;
		pItem -> setLang( (*tmp) -> value.str.val );
	}
	return RES_OK;
}

/**
 *
 * account_tƤPHPѴ
 * @param pAccount Ѵaccount_t*
 * @param z        Ѵ̤񤭹(ѤߤǤ뤳)
 * @return RES_OK
 *
 */
result_t accountToZval( const account_t *pAccount, zval *z )
{
	zend_hash_clean( z -> value.ht );

	add_assoc_long( z, "uid", pAccount -> getUID( ) );
	add_assoc_string( z, "uname", ( char* )pAccount -> getUname( ), 1 );
	add_assoc_string( z, "name", ( char* )pAccount -> getName( ), 1 );
	add_assoc_string( z, "email", ( char* )pAccount -> getEmail( ), 1 );
	add_assoc_string( z, "url", ( char* )pAccount -> getURL( ), 1 );
	add_assoc_string( z, "user_avatar", ( char* )pAccount -> getUserAvatar( ), 1 );
	add_assoc_string( z, "user_icq", ( char* )pAccount -> getUserIcq( ), 1 );
	add_assoc_string( z, "user_from", ( char* )pAccount -> getUserFrom( ), 1 );
	add_assoc_string( z, "user_sig", ( char* )pAccount -> getUserSig( ), 1 );
	add_assoc_string( z, "actkey", ( char* )pAccount -> getActkey( ), 1 );
	add_assoc_string( z, "user_aim", ( char* )pAccount -> getUserAim( ), 1 );
	add_assoc_string( z, "user_yim", ( char* )pAccount -> getUserYim( ), 1 );
	add_assoc_string( z, "user_msnm", ( char* )pAccount -> getUserMsnm( ), 1 );
	add_assoc_string( z, "pass", ( char* )pAccount -> getPass( ), 1 );
	add_assoc_string( z, "theme", ( char* )pAccount -> getTheme( ), 1 );
	add_assoc_string( z, "umode", ( char* )pAccount -> getUmode( ), 1 );
	add_assoc_string( z, "user_occ", ( char* )pAccount -> getUserOcc( ), 1 );
	add_assoc_string( z, "bio", ( char* )pAccount -> getBio( ), 1 );
	add_assoc_string( z, "user_intrest", ( char* )pAccount -> getUserIntrest( ), 1 );
	add_assoc_double( z, "timezone_offset", pAccount -> getTimezoneOffset( ) );
	add_assoc_long( z, "attachsig", pAccount -> getAttachsig( ) );
	add_assoc_long( z, "last_login", pAccount -> getLastLogin( ) );
	add_assoc_long( z, "level", pAccount -> getLevel( ) );
	add_assoc_long( z, "notify_method", pAccount -> getNotifyMethod( ) );
	add_assoc_long( z, "notify_mode", pAccount -> getNotifyMode( ) );
	add_assoc_long( z, "posts", pAccount -> getPosts( ) );
	add_assoc_long( z, "rank", pAccount -> getRank( ) );
	add_assoc_long( z, "uorder", pAccount -> getUorder( ) );
	add_assoc_long( z, "user_mailok", pAccount -> getUserMailok( ) );
	add_assoc_long( z, "user_regdate", pAccount -> getUserRegdate( ) );
	add_assoc_long( z, "user_viewemail", pAccount -> getUserViewemail( ) );

	add_assoc_long( z, "activate", pAccount -> getActivate( ) );
	add_assoc_string( z, "address", ( char* )pAccount -> getAddress( ), 1 );
	add_assoc_string( z, "division", ( char* )pAccount -> getDivision( ), 1 );
	add_assoc_string( z, "tel", ( char* )pAccount -> getTel( ), 1 );
	add_assoc_string( z, "company_name", ( char* )pAccount -> getCompanyName( ), 1 );
	add_assoc_string( z, "country", ( char* )pAccount -> getCountry( ), 1 );
	add_assoc_string( z, "zipcode", ( char* )pAccount -> getZipcode( ), 1 );
	add_assoc_string( z, "fax", ( char* )pAccount -> getFax( ), 1 );
	add_assoc_long( z, "notice_mail", pAccount -> getNoticeMail( ) );
	add_assoc_long( z, "notice_mail_since", pAccount -> getNoticeMailSince( ) );
	add_assoc_long( z, "private_index_id", pAccount -> getPrivateIndexID( ) );
	add_assoc_long( z, "item_number_limit",  pAccount -> getItemNumberLimit( ) );
	add_assoc_long( z, "index_number_limit",  pAccount -> getIndexNumberLimit( ) );
	add_assoc_double( z, "item_storage_limit",  pAccount -> getItemStorageLimit( ) );
	return RES_OK;
}

/**
 *
 * ʣaccount_tƤPHPѴ
 * @param pAccounts Ѵaccount_t*
 * @param accountsLen pAccountsĹ
 * @param z        Ѵ̤񤭹(ѤߤǤ뤳)
 * @return RES_OK
 *
  z: ʴˤʤ롣 <br>
	array(
	  array(
		'uid'=>100,
		'activate'=>1,
		'division'=>'foo',
		'tel'=>'123-456-789',
		...
	  ),
	  ...
	)
 */
result_t accountsToZval( const account_t *pAccounts, int accountsLen, zval *z )
{
	zend_hash_clean( z -> value.ht );
	for( int i = 0; i < accountsLen; i++ ){
		zval *new_array;
		MAKE_STD_ZVAL(new_array);
		if(array_init(new_array) != SUCCESS){
			return RES_ERROR;
		}
		add_index_zval( z, i, new_array );
		accountToZval( &pAccounts[ i ], new_array );
	}
	return RES_OK;
}

/**
 *
 * ʣgroup_tƤPHPѴ
 * @param pGroups Ѵgroup_t*
 * @param groupsLen pGroupsĹ
 * @param z        Ѵ̤񤭹(ѤߤǤ뤳)
 * @return RES_OK
 *
  z: ʴˤʤ롣 <br>
	array(
	  array(
		'gid'=>1,
		'gname'=>'foo group',
		'gdesc'=>'group of foo'
	  ),
	  ...
	)
 */
result_t groupsToZval( const group_t *pGroups, int groupsLen, zval *z )
{
	zend_hash_clean( z -> value.ht );
	for( int i = 0; i < groupsLen; i++ ){
		zval *new_array;
		MAKE_STD_ZVAL(new_array);
		if(array_init(new_array) != SUCCESS){
			return RES_ERROR;
		}
		add_index_zval( z, i, new_array );
		add_assoc_long( new_array, "gid",  pGroups[ i ].getGID( ) );
		add_assoc_string( new_array, "gname", ( char* )pGroups[ i ].getGname( ), 1 );
		add_assoc_string( new_array, "gdesc", ( char* )pGroups[ i ].getDesc( ), 1 );
		add_assoc_long( new_array, "group_index_id",  pGroups[ i ].getGroupIndexID( ) );
		add_assoc_long( new_array, "item_number_limit",  pGroups[ i ].getItemNumberLimit( ) );
		add_assoc_long( new_array, "index_number_limit",  pGroups[ i ].getIndexNumberLimit( ) );
		add_assoc_double( new_array, "item_storage_limit",  pGroups[ i ].getItemStorageLimit( ) );
	}
	return RES_OK;
}

/**
 *
 * group_tƤPHPϢѴ
 *
 * @param pGroup ѴΥ롼׾
 * @param z Ѵ̤񤭹Ϣ(ѤߤǤ뤳)
 * @return RES_OK
 *
 */
result_t groupToZval( const group_t *pGroup, zval *z )
{
	zend_hash_clean( z -> value.ht );
	add_assoc_long( z, "gid",  pGroup -> getGID( ) );
	add_assoc_string( z, "gname", ( char* )pGroup -> getGname( ), 1 );
	add_assoc_string( z, "gdesc", ( char* )pGroup -> getDesc( ), 1 );
	add_assoc_long( z, "group_index_id",  pGroup -> getGroupIndexID( ) );
	add_assoc_long( z, "item_number_limit",  pGroup -> getItemNumberLimit( ) );
	add_assoc_long( z, "index_number_limit",  pGroup -> getIndexNumberLimit( ) );
	add_assoc_double( z, "item_storage_limit",  pGroup -> getItemStorageLimit( ) );
	return RES_OK;
}

/**
 *
 * PHPϢƤgroup_tѴ
 *
 * @param z ѴϢ
 * @param pGroup Ѵ̤񤭹॰롼
 * @return RES_OK
 *
 */
result_t zvalToGroup( zval *z, group_t *pGroup )
{
	zval         **tmp;
	char* key = 0;

	key = "gid";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_long_ex( tmp ) ;
		pGroup -> setGID( (*tmp) -> value.lval );
	}
	key = "gname";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_string_ex( tmp ) ;
		pGroup -> setGname( (*tmp) -> value.str.val );
	}
	key = "gdesc";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_string_ex( tmp ) ;
		pGroup -> setDesc( (*tmp) -> value.str.val );
	}
	key = "group_index_id";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_long_ex( tmp ) ;
		pGroup -> setGroupIndexID( (*tmp) -> value.lval );
	}
	key = "item_number_limit";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_long_ex( tmp ) ;
		pGroup -> setItemNumberLimit( (*tmp) -> value.lval );
	}
	key = "index_number_limit";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_long_ex( tmp ) ;
		pGroup -> setIndexNumberLimit( (*tmp) -> value.lval );
	}
	key = "item_storage_limit";
	if( zend_hash_find( z -> value.ht, key, strlen( key ) + 1, ( void** )&tmp ) == SUCCESS ){
		convert_to_double_ex( tmp ) ;
		pGroup -> setItemStorageLimit( (*tmp) -> value.dval );
	}
	return RES_OK;
}

/**
 *
 * session_tƤPHPϢѴ
 *
 * @param pSession Ѵsession_t
 * @param z Ѵ̤񤭹Ϣ(ѤߤǤ뤳)
 * @return RES_OK
 *
 */
result_t sessionToZval( const session_t *pSession, zval *z )
{
	string sessionID(unsignedIntToString(pSession->getSessionID()));
	add_assoc_string(z, "session_id", (char *)sessionID.c_str(), 1);

	string date(unsignedIntToString((unsigned int)pSession->getDate()));
	add_assoc_string(z, "date", (char *)date.c_str(), 1);

	string userID(unsignedIntToString((unsigned int)pSession->getUID()));
	add_assoc_string(z, "user_id", (char *)userID.c_str(), 1);

	return RES_OK;
}

/**
 *
 * index_tƤPHPѴ
 * @param pIndex Ѵindex_t*
 * @param z        Ѵ̤񤭹(ѤߤǤ뤳)
 * @return RES_OK
 *
 */
result_t indexToZval( const index_t *pIndex, zval *z )
{
	zend_hash_clean( z -> value.ht );

	add_assoc_long( z, "item_id", pIndex -> getItemID( ) );
	add_assoc_long( z, "item_type_id", pIndex -> getItemTypeID( ) );
	add_assoc_long( z, "contributor_uid", pIndex -> getContributorUID( ) );
	add_assoc_string( z, "title", ( char* )pIndex -> getTitle( ), 1 );
	add_assoc_string( z, "keywords", ( char* )pIndex -> getKeywords( ), 1 );
	add_assoc_string( z, "description", ( char* )pIndex -> getDescription( ), 1 );
	add_assoc_long( z, "last_update_date", pIndex -> getLastUpdateDate( ) );
	add_assoc_long( z, "creation_date", pIndex-> getCreationDate( ) );
	add_assoc_long( z, "parent_index_id", pIndex -> getParentIndexID( ) );
	add_assoc_long( z, "owner_uid", pIndex -> getOwnerUID( ) );
	add_assoc_long( z, "owner_gid", pIndex -> getOwnerGID( ) );
	add_assoc_long( z, "open_level", pIndex -> getOpenLevel( ) );
	add_assoc_long( z, "sort_number", pIndex -> getSortNumber( ) );
	return RES_OK;
}

result_t indexesToZval( const index_t *pIndexes, int indexesLen, zval *z )
{
	zend_hash_clean( z -> value.ht );
	for( int i = 0; i < indexesLen; i++ ){
		zval *new_array;
		MAKE_STD_ZVAL(new_array);
		if(array_init(new_array) != SUCCESS){
			return RES_ERROR;
		}
		add_index_zval( z, i, new_array );
		indexToZval( &pIndexes[ i ], new_array );
	}
	return RES_OK;
}

/**
 *
 * event_tƤPHPѴ
 * @param pevent Ѵevent_t*
 * @param z        Ѵ̤񤭹(ѤߤǤ뤳)
 * @return RES_OK
 *
 */
result_t eventToZval( const event_t *pEvent, zval *z )
{
	zend_hash_clean( z -> value.ht );

	add_assoc_long  ( z, "event_id"      , pEvent -> getEventID()       );
	add_assoc_long  ( z, "event_type_id" , pEvent -> getEventTypeID()   );
	
	if ( pEvent->isValidTimestamp     () ) add_assoc_long  ( z, "timestamp"      , pEvent -> getTimestamp()     );
	if ( pEvent->isValidExecUID       () ) add_assoc_long  ( z, "exec_uid"       , pEvent -> getExecUID()       );
	if ( pEvent->isValidIndexID       () ) add_assoc_long  ( z, "index_id"       , pEvent -> getIndexID()       );
	if ( pEvent->isValidItemID        () ) add_assoc_long  ( z, "item_id"        , pEvent -> getItemID()        );
	if ( pEvent->isValidFileID        () ) add_assoc_long  ( z, "file_id"        , pEvent -> getFileID()        );
	if ( pEvent->isValidUID           () ) add_assoc_long  ( z, "uid"            , pEvent -> getUID()           );
	if ( pEvent->isValidGID           () ) add_assoc_long  ( z, "gid"            , pEvent -> getGID()           );
	if ( pEvent->isValidRemoteHost    () ) add_assoc_string( z, "remote_host"    , (char*)pEvent -> getRemoteHost()    , 1 );
	if ( pEvent->isValidSearchKeyword () ) add_assoc_string( z, "search_keyword" , (char*)pEvent -> getSearchKeyword() , 1 );
	if ( pEvent->isValidAdditionalInfo() ) add_assoc_string( z, "additional_info", (char*)pEvent -> getAdditionalInfo(), 1 );

	return RES_OK;
}

result_t eventsToZval( const event_t *pevents, int eventsLen, zval *z )
{
	zend_hash_clean( z -> value.ht );
	for( int i = 0; i < eventsLen; i++ ){
		zval *new_array;
		MAKE_STD_ZVAL(new_array);
		if(array_init(new_array) != SUCCESS){
			return RES_ERROR;
		}
		add_index_zval( z, i, new_array );
		eventToZval( &pevents[ i ], new_array );
	}
	return RES_OK;
}




/** ꤷ롼פξ<br>
	int xnp_get_group( int sid, int gid, array group );
	@param sid    XNPΥåID
	@param gid    XNP  group_id
	@param group  ̤
	@return 0 success <br>
  */
ZEND_FUNCTION(xnp_get_group)
{
	long sid, gid;
	zval *zgroup;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lla",
							  &sid, &gid, &zgroup) == FAILURE) {
		return;
	}

	const group_t *pgroup;
	result_t result = getGroup( (sessionid_t)sid, (groupid_t)gid, &pgroup );
	if ( RES_OK == result ){
		groupToZval( pgroup, zgroup );
		freeGroup( pgroup );
	}

	RETURN_LONG(result);
}


/** ꤷ롼(ʣ)ξ<br>
	xnp_get_groups( int sid, array gids, array criteria, array groups );
	@param sid      XNPΥåID
	@param gids     XNP  group_id 
	@param criteria 
	@param groups   ̤
	@return 0 success <br>
  */
ZEND_FUNCTION(xnp_get_groups)
{
	result_t result;
    long sid;
	zval *zcriteria;
	zval *zgids;
	zval *zgroups;
	zval **ppzTmp = 0;
	HashPosition pos;
	int res2;
	int gidsLen;
	const group_t* groups;
	int groupsLen;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "laaa",
							  &sid, &zgids, &zcriteria, &zgroups) == FAILURE) {
		return;
	}

	//gids˥롼ID򥳥ԡ
	gidsLen = zend_hash_num_elements(Z_ARRVAL_P(zgids));
	groupid_t *gids = new groupid_t[ gidsLen ];
	zend_hash_internal_pointer_reset_ex(Z_ARRVAL_P(zgids), &pos);
	for( int i = 0; i < gidsLen; i++ ){
		if( (res2=zend_hash_get_current_data_ex(Z_ARRVAL_P(zgids), (void **)&ppzTmp, &pos)) == SUCCESS ){
			SEPARATE_ZVAL(ppzTmp);
			convert_to_long_ex(ppzTmp);
			gids[ i ] = Z_LVAL_PP(ppzTmp);
		}
		zend_hash_move_forward_ex(Z_ARRVAL_P(zgids), &pos);
	}

	zCriteria_t zcri(zcriteria);
	result = zcri.getResult();
	if ( RES_OK == result ){
		result = getGroups( (sessionid_t)sid, gids, gidsLen, &zcri, &groups, &groupsLen );
		if ( RES_OK == result ){
			groupsToZval( groups, groupsLen, zgroups );
			delete[] gids;
			freeGroup( groups );
		}
	}
	RETURN_LONG(result);
}


/** ꤷ桼ǥ졼ɤĴ٤<br>
	int xnp_is_moderator(int sid, int uid)
	@param sid      XNPΥåID
	@param uid      xoops  uid (xoops_users.uid)
	@return true  ǥ졼Ǥ <br>
  */
ZEND_FUNCTION(xnp_is_moderator)
{
	long xnpSessionID;
	userid_t uid;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ll",
							  &xnpSessionID, &uid) == FAILURE) {
		return;
	}

	bool result = isModerator( (sessionid_t)xnpSessionID, uid );
	RETURN_BOOL(result)
}

/** 桼̾uidĴ٤<br>
	int xnp_get_uid(string uname,int &uid)
	@param sid      XNPΥåID
	@param uname    xoops  uname (xoops_users.uname)
	@param uid      xoops  uid (xoops_users.uid) ѿ
	@return 0 success
  */
ZEND_FUNCTION(xnp_get_uid)
{
	char *uname;
	int unameLen;
	zval *zuid;
	userid_t uid;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "sz",
	  &uname, &unameLen, &zuid) == FAILURE) {
		return;
	}

	if (!PZVAL_IS_REF(zuid)) {
		zend_error(E_WARNING, "2nd parameter wasn't passed by reference");
		RETURN_LONG(RES_PHP_NONREF);
	}

	string strUname( uname, unameLen );
	result_t result = getUid( strUname.c_str(), &uid );
	ZVAL_LONG(zuid, (long)uid);
	RETURN_LONG((long)result);
}

ZEND_FUNCTION(xnp_test_criteria)
{
	zval *z;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "a",
	  &z) == FAILURE) {
		return;
	}
	zend_printf("zend_printf...<br>\n");
	zCriteria_t zcri(z);
	zcri.dump();
	RETURN_FALSE
}

ZEND_FUNCTION(xnp_test_uids)
{
	zval *z;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "a",
	  &z) == FAILURE) {
		return;
	}
	zend_printf("zend_printf...<br>\n");
	zUIDs_t zuids(z);
	zuids.dump();
	RETURN_FALSE
}



/** DB³롣³³Ĥ롣<br>
	int initialize_db( string host[, string user[, string password[, string dbname[, string prefix, int dbtype]]]] );
	@param host      ³衣άNULL
	@param user      DB³Υ桼̾άNULL
	@param password  DB³ΥѥɡάNULL
	@param dbname    DB³DB̾ά""
	@param prefix    XOOPS DB prefix
	@param dbtype    1=MySQL 2=SQLitecommon.h
	@return 0 success <br>
  */
ZEND_FUNCTION(xnp_initialize_db)
{
	zval **parameters[5];
	char *host;
	char *user;
	char *password;
	char *dbname;
	char *prefix;
	long dbtype;

	/* get the number of arguments */
	int argNum = ZEND_NUM_ARGS();
	if (argNum > 5)
		WRONG_PARAM_COUNT;

	/* argument count is correct, now retrieve arguments */
	if(zend_get_parameters_array_ex(argNum, parameters) != SUCCESS)
		WRONG_PARAM_COUNT;

	if (argNum < 1) host = NULL;
	else            host = getZvalString( parameters[0] );

	if (argNum < 2) user = NULL;
	else            user = getZvalString( parameters[1] );

	if (argNum < 3) password = NULL;
	else            password = getZvalString( parameters[2] );

	if (argNum < 4) dbname = "";
	else            dbname = getZvalString( parameters[3] );

	if (argNum < 5) prefix = "";
	else            prefix = getZvalString( parameters[4] );

	if (argNum < 6) dbtype = DBTYPE_MYSQL;
	else            dbtype = getZvalInt( parameters[5] );

	result_t result = initializeDB( host, user, password, dbname, prefix, (dbtype_t)dbtype );

	RETURN_LONG(result);
}

/** 󤹤롣<br>
	int xnp_login_user(string uname, string password, int &session_id)
	@param uname      桼̾(xoops_users.uname)
	@param password   ѥ(md5(password)=xoops_users.pass)
	@return 0 success
  */
ZEND_FUNCTION(xnp_login_user)
{
	char *uname;
	int unameLen;
	char *passwd;
	int passwdLen;
	zval *zXNPSessionID;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ssz",
	  &uname, &unameLen, &passwd, &passwdLen, &zXNPSessionID) == FAILURE) {
		return;
	}

	if (!PZVAL_IS_REF(zXNPSessionID)) {
		zend_error(E_WARNING, "3rd parameter wasn't passed by reference");
		RETURN_LONG(RES_PHP_NONREF);
	}

	sessionid_t xnpSessionID;
	result_t result = loginUser( uname, passwd, &xnpSessionID );
	if ( result == RES_OK )
		ZVAL_LONG(zXNPSessionID, (long)xnpSessionID);
	RETURN_LONG((long)result);
}

/** Ȥ롣<br>
	void xnp_logout_user(int xnp_session_id)
	@param xnp_session_id  XNPΥåID
	@return ʤ
  */
ZEND_FUNCTION(xnp_logout_user)
{
	long xnpSessionID;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "l", &xnpSessionID) == FAILURE) {
		return;
	}
	logoutUser( (sessionid_t)xnpSessionID );

	RETURN_NULL();
}

/** XNPΥåID <br>
	int xnp_create_session( string xoops_sess_id, int uid, int &session )
	@param xoops_sess_id  xoopsΥåID
	@param uid  xoops  uid (xoops_users.uid)
	@param session  XNPsessionѿ
	@return 0 
  */
ZEND_FUNCTION(xnp_create_session)
{
	char *xoopsSessionID;
	int xoopsSessionIDLen;
	long uid;
	zval *zXNPSessionID;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "slz",
	  &xoopsSessionID, &xoopsSessionIDLen, &uid, &zXNPSessionID) == FAILURE) {
		return;
	}

	if (!PZVAL_IS_REF(zXNPSessionID)) {
		zend_error(E_WARNING, "3rd parameter wasn't passed by reference");
		RETURN_LONG(RES_PHP_NONREF);
	}

	sessionid_t xnpSessionID = 0;
	result_t result = createSession( xoopsSessionID, (userid_t)uid, &xnpSessionID );
	if ( result == RES_OK )
		ZVAL_LONG(zXNPSessionID, (long)xnpSessionID);
	RETURN_LONG((long)result);
}

/** XNP  session ξܺپ<br>
	int xnp_get_session( int xnp_session_id, array session_info )
	@param xnp_session_id   XNPΥåID
	@param session_info  ̤
	@return 0 success
  */
ZEND_FUNCTION(xnp_get_session)
{
	long xnpSessionID;
	zval *sessionInfo;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "la",
	  &xnpSessionID, &sessionInfo) == FAILURE) {
		return;
	}
	const session_t *session = 0;
	result_t result = getSession( (sessionid_t)xnpSessionID, &session );
	if ( result == RES_OK ){
		sessionToZval( session, sessionInfo );
		freeSession( session );
	}

	RETURN_LONG((long)result);
}

/** 桼activate֤<br>
	bool xnp_is_activated( int xnp_session_id, int user_id )
	@param xnp_session_id   XNPΥåID
	@param user_id  xoops_users.uid
	@return 0 success
  */
ZEND_FUNCTION(xnp_is_activated)
{
	long sid, uid;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ll", &sid, &uid) == FAILURE) {
		return;
	}

	bool result = isActivated( (sessionid_t)sid, (userid_t)uid );

	RETURN_BOOL(result);
}

/** activate롣<br>
	bool xnp_activate( int xnp_session_id, int user_id, bool activated )
	@param xnp_session_id   xnp  session id
	@param user_id   xoops_users.uid
	@param activated  true:activate, false:inactivate
	@return 0 success
  */
ZEND_FUNCTION(xnp_activate)
{
	long sid, uid;
	bool activated;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "llb",
	  &sid, &uid, &activated) == FAILURE) {
		return;
	}

	result_t result = activate( (sessionid_t)sid, (userid_t)uid, activated );

	RETURN_LONG(result);
}

/** XNPΥȿ롣<br>
	int xnp_get_account_count( int xnp_session_id )
	@param xnp_session_id   XNPΥåID
	@return 0 success
  */
ZEND_FUNCTION(xnp_get_account_count)
{
	long sid;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "l",
	  &sid) == FAILURE) {
		return;
	}

	long count = getAccountCount( (sessionid_t)sid );
	RETURN_LONG(count);
}

/** Ȥ롣<br>
	bool xnp_delete_account( int xnp_session_id, int user_id )
	@param xnp_session_id   XNPΥåID
	@param user_id   xoops_users.uid
	@return 0 success
  */
ZEND_FUNCTION(xnp_delete_account)
{
	long sid, uid;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ll",
	  &sid, &uid) == FAILURE) {
		return;
	}

	result_t result = deleteAccount( (sessionid_t)sid, (userid_t)uid );

	RETURN_LONG(result);
}

/** Ⱦ롣<br>
	int xnp_get_account( int xnp_session_id, int user_id, array account_info )
	@param xnp_session_id   XNPΥåID
	@param user_id   xoops_users.uid
	@param account_info ȾϢ
	@return 0 success
  */
ZEND_FUNCTION(xnp_get_account)
{
	long sid, uid;
	zval *zaccount;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lla",
	  &sid, &uid, &zaccount) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}

	const account_t *paccount;
	result_t result = getAccount( (sessionid_t)sid, (userid_t)uid, &paccount );
	if ( RES_OK == result ){
		accountToZval( paccount, zaccount );
		freeAccount( paccount );
	}

	RETURN_LONG(result);
}

/** ˰פ륢Ȥξ롣<br>
	int xnp_get_accoutns( int sid, array uids, array criteria, array accounts );
	@param xnp_session_id   XNPΥåID
	@param user_id   xoops_users.uid
	@param criteria  ϰϡȽɽ
	@param account_info ȾϢ
	@return 0 success
  */
ZEND_FUNCTION(xnp_get_accounts)
{
	result_t result;
	long sid;
	zval *zuids;
	zval *zcriteria;
	zval *zaccount;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "laaa",
	  &sid, &zuids, &zcriteria, &zaccount) == FAILURE) {
		return;
	}

	zCriteria_t zcri(zcriteria);
	result = zcri.getResult();
	if ( RES_OK == result ){
		zUIDs_t zUIDs(zuids);
		result = zUIDs.getResult();
		if ( RES_OK == result ){
			const account_t *paccounts;
			int accountLen;
			result = getAccounts( (sessionid_t)sid,
				zUIDs.getPUID(), zUIDs.getLen(),
				&zcri, &paccounts, &accountLen );
			if ( RES_OK == result ){
				accountsToZval( paccounts, accountLen, zaccount );
				freeAccount( paccounts );
			}
		}
	}

	RETURN_LONG(result);
}

/** ȾϿ롣<br>
	int xnp_insert_account( int sid, array account_info, int &user_id );
	@param xnp_session_id   xnp  session id
	@param account_info ϿȤξ
	@param user_id 桼ID(xoops_users.uid)񤭹ե
	@return 0 success
  */
ZEND_FUNCTION(xnp_insert_account)
{
	result_t result;
	long sid;
	zval *zaccount;
	zval *zuid;
	userid_t uid;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "laz",
	  &sid, &zaccount, &zuid) == FAILURE) {
		return;
	}

	zAccount_t zacc(zaccount);
	result = zacc.getResult();
	if ( RES_OK == result ){
		result = insertAccount( (sessionid_t)sid, &zacc, &uid );
	}
	zuid -> type = IS_LONG;
	zuid -> value.lval = uid;
	RETURN_LONG(result);
}

/** Ⱦ򹹿롣<br>
	int xnp_update_account( int sid, array account );
	@param xnp_session_id   XNPΥåID
	@param account_info 񤭹٤ȾɽϢ
	@return 0 success
  */
ZEND_FUNCTION(xnp_update_account)
{
	result_t result;
	long sid;
	zval *zaccount;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "la",
	  &sid, &zaccount) == FAILURE) {
		return;
	}

	zAccount_t zacc(zaccount);
	result = zacc.getResult();
	if ( RES_OK == result ){
		result = updateAccount( (sessionid_t)sid, &zacc );
	}

	RETURN_LONG(result);
}

/** ˹礦Ȥuidΰ롣<br>
	int xnp_dump_uids( int xnp_session_id, array criteria, array uids );
	@param xnp_session_id   XNPΥåID
	@param criteria  ϰϡȽɽ
	@param uids uid
	@return 0 success
  */
ZEND_FUNCTION(xnp_dump_uids)
{
	result_t result;
	long sid;
	zval *zcriteria;
	zval *zuids;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "laa",
	  &sid, &zcriteria, &zuids) == FAILURE) {
		return;
	}

	zCriteria_t zcri(zcriteria);
	result = zcri.getResult();
	if ( RES_OK == result ){
		userid_t *puid;
		int uidLen;
		result = dumpUids( (sessionid_t)sid, &zcri, &puid, &uidLen );
		if ( RES_OK == result ){
			uidsToZval( puid, uidLen, &zuids );
			freeUID( puid );
		}
	}

	RETURN_LONG(result);
}

/** XNPΥ롼פο<br>
	int xnp_get_group_count( int xnp_session_id );
	@param xnp_session_id   XNPΥåID
	@return 롼׿
  */
ZEND_FUNCTION(xnp_get_group_count)
{
	long sid;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "l",
	  &sid) == FAILURE) {
		return;
	}

	int count = getGroupCount( (sessionid_t)sid );

	RETURN_LONG(count);
}

/** uidǻꤷ桼°롼פǡľ˰פ륰롼פgid<br>
	int xnp_get_group_by_uid( int xnp_session_id, int uid, array criteria, array gids );
	@param xnp_session_id   XNPΥåID
	@param user_id   xoops_users.uid
	@param criteria  ϰϡȽɽ
	@param gids gid
	@return 0 success
  */
ZEND_FUNCTION(xnp_get_groups_by_uid)
{
	result_t result;
	long sid, uid;
	zval *zcriteria;
	zval *zgids;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "llaa",
	  &sid, &uid, &zcriteria, &zgids) == FAILURE) {
		return;
	}

	zCriteria_t zcri(zcriteria);
	result = zcri.getResult();
	if ( RES_OK == result ){
		groupid_t *pgids;
		int gidLen;
		result = getGroupsByUid( (sessionid_t)sid, (userid_t)uid, &zcri, &pgids, &gidLen );
		if ( RES_OK == result ){
			gidsToZval( pgids, gidLen, &zgids );
			freeGID( pgids );
		}
	}

	RETURN_LONG(result);
}



/** uidǻꤷ桼gidǻꤷ롼פΥ롼״Ԥɤ<br>
	int xnp_is_group_admin( int sid, int gid, int uid );
	@param xnp_session_id   XNPΥåID
	@param group_id  XNPΥ롼ID
	@param user_id   xoops_users.uid
	@return true: 롼״ԤǤ롣
	@return false: 롼״ԤǤʤ뤤ϥ顼Ǥ롣
  */
ZEND_FUNCTION(xnp_is_group_admin)
{
	long sid, gid, uid;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lll",
	  &sid, &gid, &uid) == FAILURE) {
		return;
	}

	bool b  = isGroupAdmin( (sessionid_t)sid, (groupid_t)gid, (userid_t)uid );

	RETURN_BOOL(b);
}

/** ˰פ륰롼פgidΰ롣<br>
	int xnp_dump_gids( int sid, array criteria, array gids );
	@param xnp_session_id   XNPΥåID
	@param criteria  ϰϡȽɽ
	@param gids gid
	@return 0 success
  */
ZEND_FUNCTION(xnp_dump_gids)
{
	result_t result;
	long sid;
	zval *zcriteria;
	zval *zgids;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "laa",
	  &sid, &zcriteria, &zgids) == FAILURE) {
		return;
	}

	zCriteria_t zcri(zcriteria);
	result = zcri.getResult();
	if ( RES_OK == result ){
		groupid_t *pgid;
		int gidLen;
		result = dumpGids( (sessionid_t)sid, &zcri, &pgid, &gidLen );
		if ( RES_OK == result ){
			gidsToZval( pgid, gidLen, &zgids );
			freeGID( pgid );
		}
	}

	RETURN_LONG(result);
}

/** gidǻꤷ롼פδԤǡľ˰פ륰롼״Ԥuidΰ롣<br>
	int xnp_dump_group_admins(int sid, int group_id, array criteria, array uids )
	@param sid      XNPΥåID
	@param group_id XNPΥ롼ID
	@param criteria 
	@param uids     uidΰ
	@return 0 success
  */

ZEND_FUNCTION(xnp_dump_group_admins)
{
	long sid, gid;
	zval *zcriteria;
	zval *zuids;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "llaa",
							  &sid, &gid, &zcriteria, &zuids) == FAILURE) {
		return;
	}

	zCriteria_t zcri(zcriteria);
	result_t result = zcri.getResult();
	if ( result == RES_OK ){
		userid_t *uids;
		int uidsLen;
		result = dumpGroupAdmins( sid, gid, &zcri, &uids, &uidsLen );
		if ( result == RES_OK ){
			uidsToZval( uids, uidsLen, &zuids );
			freeUID( uids );
		}
	}
	RETURN_LONG( result );
}

/** 롼פС롣<br>
	int xnp_delete_member(int sid, int group_id, int user_id )
	@param sid      XNPΥåID
	@param group_id XNPΥ롼ID
	@param user_id  桼ID
	@return 0 success
  */

ZEND_FUNCTION(xnp_delete_member)
{
	long sid, gid, uid;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lll",
							  &sid, &gid, &uid) == FAILURE) {
		return;
	}

	result_t result = deleteMember( (sessionid_t)sid, (groupid_t)gid, (userid_t)uid );
	RETURN_LONG( result );
}

/** 롼פ˥Сɲä<br>
	int xnp_insert_member(int sid, int group_id, int user_id, bool admin )
	@param sid      XNPΥåID
	@param group_id XNPΥ롼ID
	@param user_id  桼ID
	@param admin    롼״Ԥʤtrue
	@return 0 success
  */

ZEND_FUNCTION(xnp_insert_member)
{
	long sid, gid, uid;
	zend_bool admin;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lllb",
							  &sid, &gid, &uid, &admin) == FAILURE) {
		return;
	}

	result_t result = insertMember( (sessionid_t)sid, (groupid_t)gid, (userid_t)uid, (bool)admin );
	RETURN_LONG( result );
}

/** gidǻꤷ롼פΥСuidΰ<br>
	int xnp_get_members(int sid, int group_id, array criteria, array uids )
	@param sid      XNPΥåID
	@param group_id XNPΥ롼ID
	@param criteria 
	@param uids     uidΰ
	@return 0 success
  */

ZEND_FUNCTION(xnp_get_members)
{
	long sid, gid;
	zval *zcriteria;
	zval *zuids;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "llaa",
							  &sid, &gid, &zcriteria, &zuids) == FAILURE) {
		return;
	}

	zCriteria_t zcri(zcriteria);
	result_t result = zcri.getResult();
	if ( result == RES_OK ){
		userid_t *uids;
		int uidsLen;
		result = getMembers( (sessionid_t)sid, (groupid_t)gid, &zcri, &uids, &uidsLen );
		if ( result == RES_OK ){
			uidsToZval( uids, uidsLen, &zuids );
			freeUID( uids );
		}
	}
	RETURN_LONG( result );
}

/** 롼׾ѹ롣<br>
	int xnp_update_group(int sid, array group )
	@param sid      XNPΥåID
	@param group    롼׾Ϣ
	@return 0 success
  */
ZEND_FUNCTION(xnp_update_group)
{
	long sid;
	zval *zgroup;
	group_t group;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "la",
							  &sid, &zgroup) == FAILURE) {
		return;
	}

	zvalToGroup( zgroup, &group );
	result_t result = updateGroup( sid, &group );
	RETURN_LONG( result );
}

/** 롼׾ɲä롣<br>
	int xnp_insert_group( int sid, array group, int &gid )
	@param sid      åID
	@param group    롼׾Ϣ
	@param gid      б륰롼ID񤭹ե
	@return RES_OK
	@return RES_DB_NOT_INITIALIZED
	@return RES_NO_SUCH_SESSION
	@return RES_DB_QUERY_ERROR
*/
ZEND_FUNCTION(xnp_insert_group)
{
	long sid;
	zval *zgroup;
	zval *zgid;
	group_t group;
	groupid_t gid;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "laz",
							  &sid, &zgroup, &zgid ) == FAILURE) {
		return;
	}

	zvalToGroup( zgroup, &group );
	result_t result = insertGroup( sid, &group, &gid );
	zgid -> type = IS_LONG;
	zgid -> value.lval = gid;
	RETURN_LONG( result );
}


/** 롼׾롣<br>
	int xnp_delete_group( int sid, int gid )
	@param sid      XNPΥåID
	@param gid      롼פID
	@return RES_OK
	@return RES_DB_QUERY_ERROR
	@return RES_NO_SUCH_SESSION
	@return RES_DB_NOT_INITIALIZED
  */
ZEND_FUNCTION(xnp_delete_group)
{
	long sid;
	long gid;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ll",
							  &sid, &gid) == FAILURE) {
		return;
	}
	RETURN_LONG( deleteGroup( sid, gid ) );
}

/** 롼פδԤ<br>
	int xnp_dump_group_admins( int sid, int gid, array criteria, array uids )
	@param sid      XNPΥåID
	@param gid      XNP롼פID
	@param criteria uids˽񤭹ȤΥȾϰϤλ
	@param uids     ԤUID񤭹
	@return RES_OK
	@return RES_DB_QUERY_ERROR
	@return RES_NO_SUCH_SESSION
	@return RES_DB_NOT_INITIALIZED
  */
/*
ZEND_FUNCTION(xnp_dump_group_admins)
{
	long sid;
	long gid;
	zval *zcriteria;
	zval *zuids;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "llaa",
							  &sid, &gid, &zcriteria, &zuids) == FAILURE) {
		return;
	}
	zCriteria_t zcri(zcriteria);
	result_t result = zcri.getResult();
	if ( RES_OK == result ){
		userid_t* uids;
		int uidsLen;
		result_t result = dumpGroupAdmins( sid, gid, &zcri, &uids, &uidsLen );
		if( result != RES_OK ) RETURN_LONG( result );
		uidsToZval( uids, uidsLen, &zuids );
		fprintf( stderr, "uidsLen=%d\n", uidsLen );
		for( int i = 0; i < uidsLen; i++ ){
			fprintf( stderr, "%d, \n", uids[ i ] );
		}
		freeUID( uids );
		RETURN_LONG( result );
	}
	RETURN_LONG( result );
}
*/

/** ƤΥǥå<br>
 *   int xnp_get_all_indexes( int sid, array criteria, array indexes );
 * @param sid XNPΥåID
 * @param cri ̤ϰϻꡤȾ
 * @return RES_OK
 */
ZEND_FUNCTION(xnp_get_all_indexes)
{
	long sid;
	zval *zcriteria;
	zval *zindexes;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "laa",
							  &sid, &zcriteria, &zindexes) == FAILURE) {
		return;
	}
	zCriteria_t zcri(zcriteria);
	result_t result = zcri.getResult();
	if ( RES_OK == result ){
		const index_t *indexes;
		int indexesLen;
		result = getAllIndexes( sid, &zcri, &indexes, &indexesLen );
		if ( RES_OK == result ){
			result = indexesToZval( indexes, indexesLen, zindexes );
			freeIndex( indexes );
		}
	}
	RETURN_LONG(result);
}

/** 륤ǥåƤλҥǥå<br>
 *   int xnp_get_indexes( int sid, int parentXID, array criteria, array indexes );
 * @param sid XNPΥåID
 * @param parentXID ƤindexID
 * @param cri ̤ϰϻꡤȾ
 * @param indexes ̤
 * @return RES_OK
 */
ZEND_FUNCTION(xnp_get_indexes)
{
	long sid;
	long parentXID;
	zval *zcriteria;
	zval *zindexes;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "llaa",
							  &sid, &parentXID, &zcriteria, &zindexes) == FAILURE) {
		return;
	}
	zCriteria_t zcri(zcriteria);
	result_t result = zcri.getResult();
	if ( RES_OK == result ){
		const index_t *indexes;
		int indexesLen;
		result = getIndexes( sid, parentXID, &zcri, &indexes, &indexesLen );
		if ( RES_OK == result ){
			result = indexesToZval( indexes, indexesLen, zindexes );
			freeIndex( indexes );
		}
	}
	RETURN_LONG(result);
}


/** ǥå<br>
 *   int xnp_insert_index( int sid, array index, int &indexID );
 * @param sid XNPΥåID
 * @param index 륤ǥå
 * @param indexID 줿ǥåIDѿ
 * @return RES_OK
 */
ZEND_FUNCTION(xnp_insert_index)
{
	long sid;
	zval *zindex;
	zval *zIndexID;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "laz",
							  &sid, &zindex, &zIndexID) == FAILURE) {
		return;
	}

	if (!PZVAL_IS_REF(zIndexID)) {
		zend_error(E_WARNING, "3rd parameter wasn't passed by reference");
		RETURN_LONG(RES_PHP_NONREF);
	}
	zIndex_t index( zindex );
	indexid_t xid;
	result_t result = insertIndex( sid, &index, &xid );
	if ( RES_OK == result )
		ZVAL_LONG(zIndexID, (long)xid);
	RETURN_LONG(result);
}

/** ǥå򹹿<br>
 *   int xnp_update_index( int sid, array index );
 * @param sid XNPΥåID
 * @param index 륤ǥå
 * @return RES_OK
 */
ZEND_FUNCTION(xnp_update_index)
{
	long sid;
	zval *zindex;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "la",
							  &sid, &zindex) == FAILURE) {
		return;
	}
	zIndex_t index(zindex);
	result_t result = index.getResult();
	if ( RES_OK == result ){
		result = updateIndex( sid, &index );
	}
	RETURN_LONG(result);
}

/** ǥå<br>
 *   int xnp_delete_index( int sid, int indexID );
 * @param sid XNPΥåID
 * @param indexID 륤ǥå
 * @return RES_OK
 */
ZEND_FUNCTION(xnp_delete_index)
{
	long sid;
	long xid;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ll",
							  &sid, &xid) == FAILURE) {
		return;
	}

	result_t result = deleteIndex( sid, xid );
	RETURN_LONG(result);
}


/** ǥå<br>
 *   int xnp_get_index( int sid, int indexID, array index );
 * @param sid XNPΥåID
 * @param indexID 륤ǥåID
 * @param index ̤Ϣ
 * @return RES_OK
 */
ZEND_FUNCTION(xnp_get_index)
{
	long sid;
	long xid;
	zval *zindex;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lla",
							  &sid, &xid, &zindex) == FAILURE) {
		return;
	}

	const index_t *index;
	result_t result = getIndex( sid, xid, &index );
	if ( RES_OK == result ){
		result = indexToZval( index, zindex );
		freeIndex( index );
	}
	RETURN_LONG(result);
}



/** ǥåɤ߹߲ǽɤĴ٤<br>
 *   int xnp_is_index_readable( int sid, int indexID );
 * @param sid XNPΥåID
 * @param indexID оݥǥåID
 * @return true false
 */
ZEND_FUNCTION(xnp_is_index_readable)
{
	long sid;
	long xid;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ll",
							  &sid, &xid) == FAILURE) {
		return;
	}
	RETURN_BOOL(isIndexReadable(sid,xid));
}


/** ǥå񤭹߲ǽɤĴ٤<br>
 *   int xnp_is_index_writable( int sid, int indexID );
 * @param sid XNPΥåID
 * @param indexID оݥǥåID
 * @return true false
 */
ZEND_FUNCTION(xnp_is_index_writable)
{
	long sid;
	long xid;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ll",
							  &sid, &xid) == FAILURE) {
		return;
	}
	RETURN_BOOL(isIndexWritable(sid,xid));
}

/** ǥåνؤ<br>
 *   int xnp_swap_index_sort_number( int sid, int indexID1, int indexID2 );
 * @param sid XNPΥåID
 * @param indexID1 оݥǥåID
 * @param indexID2 оݥǥåID
 * @return true false
 */
ZEND_FUNCTION(xnp_swap_index_sort_number)
{
	long sid;
	long xid1, xid2;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lll",
							  &sid, &xid1, &xid2) == FAILURE) {
		return;
	}

	result_t result = swapIndexSortNumber( sid, xid1, xid2 );
	RETURN_LONG(result);
}



/** XNPsession_idå<br>
	bool xnp_is_valid_session_id( int xnp_session_id)
	@return true ͭXNPsession_idǤ<br>
	@return false ̵session_idޤϥ顼
  */
ZEND_FUNCTION(xnp_is_valid_session_id)
{
	long sid;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "l", &sid ) == FAILURE) {
		return;
	}

	RETURN_BOOL(isValidSessionID((sessionid_t)sid));
}

/** 顼ʸ<br>
	string xnp_get_last_error_string()
	@return 0 success
  */
ZEND_FUNCTION(xnp_get_last_error_string)
{
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "" ) == FAILURE) {
		return;
	}

	string str( getLastErrorString() );
	RETURN_STRING((char *)str.c_str(), 1);
}


/**
 *
 * ƥؤΥ¤å
 *
 * @refer itemop_t
 * @param sid åID
 * @param iid åоݤȤʤ륢ƥID
 * @param op μ
 * @return true ¤
 * @return false ¤ʤ
 *
 */
ZEND_FUNCTION(xnp_get_item_permission)
{
	long sid;
	itemid_t iid;
    long op;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lll",
							  &sid, &iid, &op) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}
	RETURN_BOOL( getItemPermission( (sessionid_t)sid, iid, op ) );
}


/**
 *
 * ǥåؤΥ¤å
 *
 * @refer indexop_t
 * @param sid åID
 * @param xid åоݤȤʤ륤ǥåID
 * @param op μ
 * @return true ¤
 * @return false ¤ʤ
 *
 */
ZEND_FUNCTION(xnp_get_index_permission)
{
	long sid;
	indexid_t xid;
    long op;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lll",
							  &sid, &xid, &op) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}
	RETURN_BOOL( getIndexPermission( (sessionid_t)sid, xid, op ) );
}


/**
 *
 * ƥξǧ֤ѹ븢¤̵ͭĴ٤ޤ
 * @refer certify_t
 * @param sid åID
 * @param xid ѹоݥƥबϿƤ륤ǥåID
 * @param iid ѹоݥƥID
 * @param state ѹǧ
 * @return true ¤
 * @return false ¤ʤ
 *
 */
ZEND_FUNCTION(xnp_get_certify_permission)
{
	long sid;
	itemid_t iid;
	indexid_t xid;
    certify_t state;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "llll",
							  &sid, &xid, &iid, &state) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}
	RETURN_BOOL( getCertifyPermission( (sessionid_t)sid, xid, iid, state ) );
}


/**
 *
 * ƥξǧ֤ޤ
 * @refer certify_t
 * @param sid åID
 * @param xid оݥƥबϿƤ륤ǥåID
 * @param iid оݥƥID
 * @param state ǧ֤
 * @return RES_OK
 * @return RES_NO_WRITE_ACCESS_RIGHT
 *
 */
ZEND_FUNCTION(xnp_get_certify_state)
{
	long sid;
	indexid_t xid;
	itemid_t iid;
	zval *zstate;
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lllz",
							  &sid, &xid, &iid, &zstate) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}
	certify_t st;
	result = getCertifyState( (sessionid_t)sid, xid, iid, &st );
	if ( RES_OK == result ){
		zstate -> type = IS_LONG;
		zstate -> value.lval = st;
	}
	RETURN_LONG( result );
}


/**
 *
 * ƥξǧ֤ѹޤ
 * @refer certify_t
 * @param sid åID
 * @param xid ѹоݥƥबϿƤ륤ǥåID
 * @param iid ѹоݥƥID
 * @param state ѹǧ
 * @return RES_OK
 * @return RES_NO_WRITE_ACCESS_RIGHT
 *
 */
ZEND_FUNCTION(xnp_set_certify_state)
{
	long sid;
	indexid_t xid;
	itemid_t iid;
	certify_t state;
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "llll",
							  &sid, &xid, &iid, &state) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}
	result = setCertifyState( (sessionid_t)sid, xid, iid, state );
	RETURN_LONG( result );
}


/**
 *
 * ѹϿ롥
 *
 * @param sid åID
 * @param itemid ѹϿ륢ƥID
 * @param log 
 * @return RES_OK
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_ERROR
 *
 */
ZEND_FUNCTION(xnp_insert_change_log)
{
	long sid;
	itemid_t iid;
	zval *zlog;
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "llz",
							  &sid, &iid, &zlog) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}

	result = insertChangeLog( sid, iid, getZvalString( &zlog ) );
	RETURN_LONG( result );
}


/**
 *
 * ƥѹ롥
 *
 * @param sid åID
 * @param itemid ѹ륢ƥID
 * @param logs Ƥݥ
 * @param logsLen logs˳Ǽ줿θĿ
 * @return RES_OK
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_READ_ACCESS_RIGHT
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_ERROR
 *
 */
ZEND_FUNCTION(xnp_get_change_logs)
{
	result_t result;
	long sid;
	itemid_t iid;
	zval *zlogs;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lla",
	  &sid, &iid, &zlogs) == FAILURE) {
		return;
	}

	const changelog_t *plogs;
	int logLen;
	result = getChangeLogs( (sessionid_t)sid, iid, &plogs, &logLen );
	if ( RES_OK == result ){
		zend_hash_clean( zlogs -> value.ht );
		for( int i = 0; i < logLen; i++ ){
			zval *new_array;
			MAKE_STD_ZVAL(new_array);
			if(array_init(new_array) != SUCCESS){
				result = RES_ERROR;
				break;
			}
			add_index_zval( zlogs, i, new_array );
			changelogToZval( &plogs[ i ], new_array );
		}
		freeChangeLog( plogs );
	}
	RETURN_LONG(result);
}


/**
 *
 * ̾keyбͤvaule˼롥
 * valueλѸfreeStringǲ롥
 * @param key ꥭ̾
 * @param value ͤݥ
 *
 * @return RES_OK
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 */
ZEND_FUNCTION(xnp_get_config_value)
{
	char* name;
	int nameLen;
	zval* zvalue;
	char* value = 0;
	
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "sz",
							  &name, &nameLen, &zvalue ) == FAILURE) {
		return;
	}
	
	result = getConfigValue( name, &value );
	if( result == RES_OK ){
		ZVAL_STRING( zvalue, value, true/*duplicate*/ );
	}
	if ( value != 0 )
		freeString( value );
	RETURN_LONG( result );
}


/**
 *
 * ̾keyͤvauleꤹ
 *
 * @param key ꥭ̾
 * @param value 
 *
 * @return RES_OK
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 */
ZEND_FUNCTION(xnp_set_config_value)
{
	char *name;
	int nameLen;
	char *value;
	int valueLen;
	result_t result = RES_ERROR;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ss",
							  &name, &nameLen, &value, &valueLen ) == FAILURE) {
		return;
	}
	result = setConfigValue( name, value );
	RETURN_LONG( result );
}


/**
 *
 * ƥIDΰ.
 * ǽʥƥID֤.
 *
 * int xnp_dump_item_id( int sid, array cri, array iids )
 * @param sid åID
 * @param cri ̤ϰϻꡤȾ
 * @param iids ̤
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 *
 */
ZEND_FUNCTION(xnp_dump_item_id)
{
	long sid;
	zval *zcriteria;
	zval *ziids;
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "laa",
							  &sid, &zcriteria, &ziids) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}

	zCriteria_t zcri(zcriteria);
	result = zcri.getResult();
	if ( RES_OK == result ){
		const itemid_t *piids;
		int iidsLen;
		result = dumpItemID( (sessionid_t)sid, &zcri, &piids, &iidsLen );
		if ( RES_OK == result ){
			itemidsToZval( piids, iidsLen, &ziids );
			freeItemID( piids );
		}
	}

	RETURN_LONG( result );
}


/**
 *
 * ХϿ줿ƥIDޤ
 * @param sid åID
 * @param binderid оݥХID
 * @param cri ̤ϰϻꡤȾ
 * @param iids Ͽ줿ƥID
 * @param iidsLen iids˳Ǽ줿Ŀ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 *
 */
ZEND_FUNCTION(xnp_get_item_id_by_binder_id)
{
	result_t result;
	long sid;
	itemid_t iid;
	zval *zcriteria;
	zval *ziids;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "llaa",
	  &sid, &iid, &zcriteria, &ziids) == FAILURE) {
		return;
	}

	zCriteria_t zcri(zcriteria);
	result = zcri.getResult();
	if ( RES_OK == result ){
		const itemid_t *pitemids;
		int itemidLen;
		result = getItemIDByBinderID( (sessionid_t)sid, iid, &zcri, &pitemids, &itemidLen );
		if ( RES_OK == result ){
			itemidsToZval( pitemids, itemidLen, &ziids );
			freeItemID( pitemids );
		}
	}
	RETURN_LONG(result);
}


/**
 *
 * ǥåϿ줿ƥIDޤ
 * ¤̵ɤʤΤϷ̤˴ޤߤޤ
 * ̤ǧɤʤΤ̤˴ޤߤޤ
 *
 * @param sid åID
 * @param xid оݥǥåID
 * @param cri ̤ϰϻꡤȾ
 * @param iids Ͽ줿ƥID
 * @param iidsLen iids˳Ǽ줿Ŀ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 *
 */
ZEND_FUNCTION(xnp_get_item_id_by_index_id)
{
	result_t result;
	long sid;
	indexid_t xid;
	zval *zcriteria;
	zval *ziids;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "llaa",
	  &sid, &xid, &zcriteria, &ziids) == FAILURE) {
		return;
	}

	zCriteria_t zcri(zcriteria);
	result = zcri.getResult();
	if ( RES_OK == result ){
		const itemid_t *pitemids;
		int itemidLen;
		result = getItemIDByIndexID( (sessionid_t)sid, xid, &zcri, &pitemids, &itemidLen );
		if ( RES_OK == result ){
			itemidsToZval( pitemids, itemidLen, &ziids );
			freeItemID( pitemids );
		}
	}
	RETURN_LONG(result);
}


ZEND_FUNCTION(xnp_get_overlapped_items)
{
	RETURN_LONG( RES_ERROR );
}

/**
 *
 * ƥ(Basic Information)Ͽ.
 * Platform桼ʾθ¤ɬ.
 *
 * @param sid åID
 * @param item Ͽƥξ
 * @param itemid ϿƥID
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_WRITE_ACCESS_RIGHT
 *
 */
ZEND_FUNCTION(xnp_insert_item)
{
	long sid;
	zval *ziid;
	zval *zitem;
	item_t item;
	itemid_t iid;
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "laz",
							  &sid, &zitem, &ziid) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}

	zvalToItem( zitem, &item );
	result = insertItem( (sessionid_t)sid, &item, &iid );
	if ( RES_OK == result ){
		ziid -> type = IS_LONG;
		ziid -> value.lval = iid;
	}
	RETURN_LONG( result );
}

/**
 *
 * ƥ(Basic Information)Ͽ.
 * Platform桼ʾθ¤ɬ.
 *
 * @param sid åID
 * @param item Ͽƥξ
 * @param itemid ϿƥID
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_WRITE_ACCESS_RIGHT
 *
 */
ZEND_FUNCTION(xnp_insert_item_direct)
{
	long sid;
	zval *ziid;
	zval *zitem;
	item_t item;
	itemid_t iid;
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "laz",
							  &sid, &zitem, &ziid) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}

	zvalToItem( zitem, &item );
	result = insertItemDirect( (sessionid_t)sid, &item, &iid );
	if ( RES_OK == result ){
		ziid -> type = IS_LONG;
		ziid -> value.lval = iid;
	}
	RETURN_LONG( result );
}

/**
 *
 * ƥ(Basic Information)򹹿.
 * Platform桼ʾθ¤ɬ.
 * itemitem_idåȤ뤳.
 *
 * @param sid åID
 * @param item ƥξ
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_WRITE_ACCESS_RIGHT
 */
ZEND_FUNCTION(xnp_update_item)
{
	long sid;
	zval *zitem;
	item_t item;
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "la",
							  &sid, &zitem) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}

	zvalToItem( zitem, &item );
	result = updateItem( (sessionid_t)sid, &item );
	RETURN_LONG( result );
}

/**
 *
 * ƥ(Basic Information).
 *
 * @param sid åID
 * @param item ƥξ
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_WRITE_ACCESS_RIGHT
 */
ZEND_FUNCTION(xnp_delete_item)
{
	long sid;
	itemid_t iid;
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ll",
							  &sid, &iid) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}
	result = deleteItem( (sessionid_t)sid, iid );
	RETURN_LONG( result );
}


/**
 * 
 * ĿͤƥIDޤ
 * ǥåϿǧ줿ΤϷ̤˴ޤߤޤ
 * 
 * @param sid åID
 * @param uid оݥ桼ID
 * @param iids Ͽ줿ƥID
 * @param iidsLen iids˳Ǽ줿Ŀ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 * 
 */
//result_t getPrivateItemID( sessionid_t sid, userid_t uid, const itemid_t** iids, int* iidsLen )
ZEND_FUNCTION(xnp_get_private_item_id)
{
	long sid;
	userid_t uid;
    zval* ziids;
    
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lla",
                              &sid, &uid, &ziids) == FAILURE) {
		return;
	}
    
    const itemid_t *piids;
    int iidsLen;
    result_t result = getPrivateItemID( (sessionid_t)sid, uid, &piids, &iidsLen );
    if ( RES_OK == result ){
        itemidsToZval( piids, iidsLen, &ziids );
        freeItemID( piids );
    }
    
	RETURN_LONG( result );
    
}

/**
 * 
 * 롼ץǥåϿ줿ƥIDޤ
 * 
 * @param sid åID
 * @param uid оݥ롼פID
 * @param iids Ͽ줿ƥID
 * @param iidsLen iids˳Ǽ줿Ŀ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 * 
 */
//result_t getGroupItemID( sessionid_t sid, groupid_t gid, const itemid_t** iids, int* iidsLen )
ZEND_FUNCTION(xnp_get_group_item_id)
{
	long sid;
	groupid_t gid;
    zval* ziids;
    
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lla",
                              &sid, &gid, &ziids) == FAILURE) {
		return;
	}
    
    const itemid_t *piids;
    int iidsLen;
    result_t result = getGroupItemID( (sessionid_t)sid, gid, &piids, &iidsLen );
    if ( RES_OK == result ){
        itemidsToZval( piids, iidsLen, &ziids );
        freeItemID( piids );
    }
    
	RETURN_LONG( result );
}


/**
 *
 * ƥ.
 * ƥϡѸfreeItemǲ.
 *
 * @refer freeItem
 * @param sid åID
 * @param iid ƥID
 * @param item ̤Υƥ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_SUCH_ITEM
 * @return RES_DB_QUERY_ERROR
 *
 */
ZEND_FUNCTION(xnp_get_item)
{
	long sid;
	long iid;
	zval *zitem;
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lla",
							  &sid, &iid, &zitem) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}

	const item_t* pitem;
	result = getItem( (sessionid_t)sid, iid, &pitem );
	if ( RES_OK == result ){
		itemToZval( pitem,  zitem );
		freeItem( pitem );
	}
	RETURN_LONG( result );
}


/**
 *
 * ƥ.
 * ƥϡѸfreeItemǲ.
 *
 * @refer freeItem
 * @param sid åID
 * @param iids ƥID
 * @param iidsLen iidsǿ
 * @param cri ̤ϰϻꡤȾ
 * @param items ̤Υݥ󥿤񤭹
 * @param itemsLen ̤ο(*itemsǿ)
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 *
 */
ZEND_FUNCTION(xnp_get_items)
{
	result_t result;
	long sid;
	zval *ziids;
	zval *zcriteria;
	zval *zitem;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "laaa",
	  &sid, &ziids, &zcriteria, &zitem) == FAILURE) {
		return;
	}

	zCriteria_t zcri(zcriteria);
	result = zcri.getResult();
	if ( RES_OK == result ){
		zIIDs_t zIIDs(ziids);
		result = zIIDs.getResult();
		if ( RES_OK == result ){
			const item_t *pitems;
			int itemLen;
			result = getItems( (sessionid_t)sid,
							   zIIDs.getPIID(), zIIDs.getLen(),
							   &zcri, &pitems, &itemLen );
			if ( RES_OK == result ){
				itemsToZval( pitems, itemLen, zitem );
				freeItem( pitems );
			}
		}
	}

	RETURN_LONG(result);
}


/**
 *
 *
 * @param pmid PUBMEDID
 * @param pubmed ̤񤭹pubmed_tΥݥ󥿰
 *
 *
 *
 */
ZEND_FUNCTION(xnp_pubmed_complete)
{
	long pmid;
	zval *zpubmed;
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "la",
							  &pmid, &zpubmed) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}

	const pubmed_t* ppubmed;
	result = pubmedComplete( pmid, &ppubmed );
	if ( RES_OK == result ){
		pubmedToZval( ppubmed,  zpubmed );
		freePubmed( ppubmed );
	}
	RETURN_LONG( result );
}


/**
 *
 *
 * @param isbn ISBN
 * @param amazonbook ̤񤭹amazonbook_tΥݥ󥿰
 *
 *
 *
 */
ZEND_FUNCTION(xnp_amazon_complete)
{
	zval *zurl;
	zval *zamazonbook;
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "za",
							  &zurl, &zamazonbook) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}

	const amazonbook_t* pamazonbook;
	result = amazonComplete( getZvalString( &zurl ) , &pamazonbook );
	if ( RES_OK == result ){
		amazonbookToZval( pamazonbook,  zamazonbook );
		//freeAmazonbook( pamazonbook );
	}
	RETURN_LONG( result );
}


//ZEND_FUNCTION(xnp_uninitialize_db)
//{
//    RETURN_LONG( RES_ERROR );
//}


/**
 *
 * Х˥ƥɲä
 *
 * @param sid åID
 * @param binderid оݤΥХID
 * @param iid ХɲäƥID
 * @return RES_OK
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * @return RES_ERROR
 *
 */
ZEND_FUNCTION(xnp_register_binder_item)
{
	result_t result = RES_ERROR;
	long sid;
	long bid;
	long iid;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lll",
	  &sid, &bid, &iid) == FAILURE) {
		return;
	}

	result = registerBinderItem( (sessionid_t)sid, bid, iid );
	RETURN_LONG(result);
}


/**
 *
 * Х饢ƥ
 *
 * @param sid åID
 * @param binderid оݤΥХID
 * @param iid ХƥID
 * @return RES_OK
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * @return RES_ERROR
 *
 */
ZEND_FUNCTION(xnp_unregister_binder_item)
{
	result_t result = RES_ERROR;
	long sid;
	long bid;
	long iid;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lll",
	  &sid, &bid, &iid) == FAILURE) {
		return;
	}

	result = registerBinderItem( (sessionid_t)sid, bid, iid );
	RETURN_LONG(result);
}


/**
 *
 * ǥå˥ƥɲä
 *
 * @param sid åID
 * @param xid оݤΥǥåID
 * @param iid ǥåɲäƥID
 * @return RES_OK
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * @return RES_ERROR
 *
 */
ZEND_FUNCTION(xnp_register_item)
{
	result_t result = RES_ERROR;
	long sid;
	long xid;
	long iid;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lll",
	  &sid, &xid, &iid) == FAILURE) {
		return;
	}

	result = registerItem( (sessionid_t)sid, xid, iid );
	RETURN_LONG(result);
}


/**
 *
 * ǥå饢ƥ
 *
 * @param sid åID
 * @param xid оݤΥǥåID
 * @param iid ǥåƥID
 * @return RES_OK
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * @return RES_ERROR
 *
 */
ZEND_FUNCTION(xnp_unregister_item)
{
	result_t result = RES_ERROR;
	long sid;
	long xid;
	long iid;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lll",
	  &sid, &xid, &iid) == FAILURE) {
		return;
	}

	result = unregisterItem( (sessionid_t)sid, xid, iid );
	RETURN_LONG(result);
}


/**
 * 
 * ǧԤ֤ΥƥΤǧ¤Τ륢ƥIDϿ襤ǥåIDڥǼޤ.
 * ƥiids[i]xids[i]ؤϿξǧԤ֤ˤ뤳Ȥ֤ޤ
 * 
 * @param sid åID
 * @param xids ǧԤƥϿ륤ǥåID
 * @param iids ǧԤƥID
 * @param len iids,xids˳Ǽ줿Ŀ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 * 
 */
//result_t getUncertifiedLink( sessionid_t sid, const itemid_t** xids, const itemid_t** iids, int* len )
ZEND_FUNCTION(xnp_get_uncertified_link)
{
	long sid;
    zval* zxids;
    zval* ziids;
    
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "laa",
                              &sid, &zxids, &ziids) == FAILURE) {
		return;
	}
    
    const itemid_t *pxids;
    const itemid_t *piids;
    int len;
    result_t result = getUncertifiedLink( (sessionid_t)sid, &pxids, &piids, &len );
    if ( RES_OK == result ){
        indexidsToZval( pxids, len, &zxids );
        itemidsToZval( piids, len, &ziids );
        freeIndexID( pxids );
        freeItemID( piids );
    }
	RETURN_LONG( result );
}

/**
 * 
 * @param types 
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 * 
 */
ZEND_FUNCTION(xnp_get_item_types)
{
    zval* ztypes;
    
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "a",
                              &ztypes) == FAILURE) {
		return;
	}
    
    const itemtype_t *ptypes;
    int len;
    result_t result = getItemTypes( &ptypes, &len );
    if ( RES_OK == result ){

        zend_hash_clean( ztypes -> value.ht );
        for( int i = 0; i < len; i++ ){
            zval *new_array;
            MAKE_STD_ZVAL(new_array);
            if(array_init(new_array) != SUCCESS){
                result = RES_ERROR;
                break;
            }
            add_index_zval( ztypes, i, new_array );
            
            zend_hash_clean( new_array -> value.ht );
            add_assoc_long( new_array, "item_type_id", ptypes[ i ].getItemTypeID( ) );
            add_assoc_long( new_array, "mid", ptypes[ i ].getModuleID( ) );
            add_assoc_string( new_array, "name", ( char* )ptypes[ i ].getName( ), 1 );
            add_assoc_string( new_array, "display_name", ( char* )ptypes[ i ].getDisplayName( ), 1 );
            add_assoc_string( new_array, "viewphp", ( char* )ptypes[ i ].getViewphp( ), 1 );
        }
        result = RES_OK;
        freeItemType( ptypes );
    }
	RETURN_LONG( result );
}

ZEND_FUNCTION(xnp_get_index_id_by_item_id)
{
	result_t result;
	long sid;
	itemid_t iid;
	zval *zxids;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lla",
	  &sid, &iid, &zxids) == FAILURE) {
		return;
	}

    const indexid_t *pindexids;
    int indexidLen;
    result = getIndexIDByItemID( (sessionid_t)sid, iid, &pindexids, &indexidLen );
    if ( RES_OK == result ){
        indexidsToZval( pindexids, indexidLen, &zxids );
        freeIndexID( pindexids );
    }
	RETURN_LONG(result);
}

ZEND_FUNCTION(xnp_get_own_public_item_id)
{
	long sid;
	userid_t uid;
	zval* ziids;
	
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lla",
	                          &sid, &uid, &ziids) == FAILURE) {
		return;
	}
	
	const itemid_t *piids;
	int iidsLen;
	result_t result = getOwnPublicItemID( (sessionid_t)sid, uid, &piids, &iidsLen );
	if ( RES_OK == result ){
		itemidsToZval( piids, iidsLen, &ziids );
		freeItemID( piids );
	}
	
	RETURN_LONG( result );
}

ZEND_FUNCTION(xnp_zip_create)
{
	zval* zzipfile;
	zval* zfiles;
	result_t result = RES_ERROR;
	
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "za",
							  &zzipfile, &zfiles) == FAILURE) {
		return;
	}
	char* zipfile = getZvalString( &zzipfile );
	char** files = 0;
	int len;

	if ( Z_TYPE_P(zfiles) != IS_ARRAY ){
		result = RES_ERROR;
	}
	else {
		len = zend_hash_num_elements(Z_ARRVAL_P(zfiles));
		if(len > 0) {
			zval		 **tmp;
			HashPosition   pos;
			int i = 0;
			files = new char*[ len ];

			zend_hash_internal_pointer_reset_ex(Z_ARRVAL_P(zfiles), &pos);
			while (zend_hash_get_current_data_ex(Z_ARRVAL_P(zfiles), (void **) &tmp, &pos) == SUCCESS ) {
				SEPARATE_ZVAL(tmp); // zend.arguments.write-safety.html 
				convert_to_string_ex(tmp);
				
				if ( i < len )
					files[i++] = Z_STRVAL_PP(tmp);
				zend_hash_move_forward_ex(Z_ARRVAL_P(zfiles), &pos);
			}
			//len = i;
		}
	}
	if( files != 0 ){
		result = zipCreate( zipfile, files, len );
    }else{
		result = RES_ERROR;
	}
	
	RETURN_LONG( result );
}

/** Readǽʥƥο<br>
	int xnp_item_count( int xnp_session_id, int &count );
	@param xnp_session_id   XNPΥåID
	@param coutn ƥե
    @return RES_OK
    @return RES_DB_NOT_INITIALIZED
    @return RES_NO_SUCH_SESSION
    @return RES_DB_QUERY_ERROR
  */
ZEND_FUNCTION(xnp_get_item_count)
{
	long sid;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "l",
	  &sid) == FAILURE) {
		return;
	}

	int count = getItemCount( (sessionid_t)sid );

	RETURN_LONG(count);
}

/** ReadǽʥǥåΡľΥƥ<br>
	int xnp_item_count_group_by_index( int xnp_session_id, array counts );
	@param xnp_session_id   XNPΥåID
	@param counts ƥϢ󡥥index_idͤϥƥ
    @return RES_OK
    @return RES_DB_NOT_INITIALIZED
    @return RES_NO_SUCH_SESSION
    @return RES_DB_QUERY_ERROR
  */
ZEND_FUNCTION(xnp_get_item_count_group_by_index)
{
	long sid;
	zval *zcounts;
	
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "la",
	  &sid, &zcounts) == FAILURE) {
		return;
	}
	
	indexid_t *xids;
	int xidsLen;
	int *counts;
	result_t result = getItemCountGroupByIndex( (sessionid_t)sid, &xids, &xidsLen, &counts );
	if ( RES_OK == result ){
		zend_hash_clean( Z_ARRVAL_P(zcounts) );
		
		// add IDs
		for ( int i = 0; i < xidsLen; i++ ){
			add_index_long(zcounts, (uint)(xids[i]), (long)(counts[i]) );
		}
		freeIndexID( xids );
		freeInt( counts );
	}
	
	RETURN_LONG(result);
}

/**
 * ƥID椫顤ΤΤ.
 *
 * int xnp_extract_public_item_id( int sid, array iids, array public_iids )
 * @param sid åID
 * @param iids item_id
 * @param public_iids ̤
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 *
 */
ZEND_FUNCTION(xnp_extract_public_item_id)
{
	long sid;
	zval *ziids;
	zval *zpublic_iids;
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "laa",
							  &sid, &ziids, &zpublic_iids) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}

	zIIDs_t zIIDs(ziids);
	result = zIIDs.getResult();
	if ( RES_OK == result ){
		itemid_t *piids;
		int iidsLen;
		result = extractPublicItemId( (sessionid_t)sid,
			zIIDs.getPIID(), zIIDs.getLen(), &piids, &iidsLen );
		if ( RES_OK == result ){
			itemidsToZval( piids, iidsLen, &zpublic_iids );
			freeItemID( piids );
		}
	}

	RETURN_LONG( result );
}

/**
 * ƥID椫顤BinderǤʤΤ.
 *
 * int xnp_extract_nonbinder_item_id( int sid, array iids, array nonbinder_iids )
 * @param sid åID
 * @param iids item_id
 * @param iids ̤
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 *
 */
ZEND_FUNCTION(xnp_extract_nonbinder_item_id)
{
	long sid;
	zval *ziids;
	zval *znonbinder_iids;
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "laa",
							  &sid, &ziids, &znonbinder_iids) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}

	zIIDs_t zIIDs(ziids);
	result = zIIDs.getResult();
	if ( RES_OK == result ){
		itemid_t *piids;
		int iidsLen;
		result = extractNonbinderItemId( (sessionid_t)sid,
			zIIDs.getPIID(), zIIDs.getLen(), &piids, &iidsLen );
		if ( RES_OK == result ){
			itemidsToZval( piids, iidsLen, &znonbinder_iids );
			freeItemID( piids );
		}
	}

	RETURN_LONG( result );
}

/**
 * ٥ȤϿ
 *
 * int xnp_insert_event( int sid, int event_type_id, int timestamp, 
 *     int exec_uid, string remote_host, array params )
 * @param sid åID
 * @param event_type_id ٥ȥID
 * @param timestamp ٥ȯ time_t
 * @param exec_uid ٥ȯuid
 * @param remote_host remote host
 * @param params ʲΥϢ: index_id, item_id, file_id, uid, gid, search_keyword, login_name
 * @return RES_OK
 *
 */
ZEND_FUNCTION(xnp_insert_event)
{
	long sid;
	long eventTypeID;
	long timestamp;
	long execUID;
	char* remoteHost;
	int remoteHostLen;
	
	zval *zparams;
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "llllsa",
							  &sid, &eventTypeID, &timestamp, &execUID, &remoteHost, &remoteHostLen, &zparams ) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}
	
	long indexID=0, itemID=0, fileID=0, uid=0, gid=0;
	char* searchKeyword = 0;
	char* additionalInfo = 0;
	HashTable *h = Z_ARRVAL_P(zparams);
	hashGetLong( h, "index_id", &indexID );
	hashGetLong( h, "item_id" , &itemID  );
	hashGetLong( h, "file_id" , &fileID  );
	hashGetLong( h, "uid"     , &uid );
	hashGetLong( h, "gid"     , &gid );
	hashGetString( h, "search_keyword" , &searchKeyword );
	hashGetString( h, "additional_info", &additionalInfo );
	
	event_t ev;
	ev.setEventTypeID   ( eventTypeID    );
	ev.setTimestamp     ( timestamp      );
	ev.setExecUID       ( execUID        );
	ev.setIndexID       ( indexID        );
	ev.setItemID        ( itemID         );
	ev.setFileID        ( fileID         );
	ev.setUID           ( uid            );
	ev.setGID           ( gid            );
	ev.setRemoteHost    ( remoteHost     );
	ev.setSearchKeyword ( searchKeyword  );
	ev.setAdditionalInfo( additionalInfo );
	
	result = insertEvent( sid, &ev );
	
	RETURN_LONG( result );
}

/**
 * ٥Ȥ
 *
 * int xnp_get_events( int sid, array events, int starttime=0, int endtime=0 )
 * @param sid åID
 * @param events ٥Ȥѿ
 * @param starttime ϰ
 * @param endtime ϰ
 * @return RES_OK
 *
 */
ZEND_FUNCTION(xnp_get_events)
{
	zval **parameters[4];
	long sid;
	long startTime = 0;
	long endTime = 0;
	zval *zevents;
	result_t result = RES_ERROR;
	
	int argNum = ZEND_NUM_ARGS();
	if ( argNum < 2 || 4 < argNum )
		WRONG_PARAM_COUNT;
	
	if(zend_get_parameters_array_ex(argNum, parameters) != SUCCESS)
		WRONG_PARAM_COUNT;
	
	sid = getZvalInt( parameters[0] );
	zevents = *(parameters[1]);
	if ( Z_TYPE_P(zevents) != IS_ARRAY ){
		zend_error(E_WARNING, "2nd parameter wasn't an array");
		RETURN_LONG( RES_ERROR );
	}
	if ( argNum >= 3 ) startTime = getZvalInt( parameters[2] );
	if ( argNum >= 4 ) endTime = getZvalInt( parameters[3] );
	
	event *events = 0;
	int eventsLen = 0;
	result = getEvents( sid, &events, &eventsLen, startTime, endTime );
	if ( result == RES_OK ){
		result = eventsToZval( events, eventsLen, zevents );
		delete[] events;
	}
	
	RETURN_LONG( result );
}

/**
 * RSSɬפʥ٥Ȥ
 *
 * int xnp_get_events_for_rss( int sid, array events, int max )
 * @param sid åID
 * @param events ٥Ȥѿ
 * @param max 
 * @return RES_OK
 *
 */
ZEND_FUNCTION(xnp_get_events_for_rss)
{
	zval **parameters[3];
	long sid;
	long startTime = 0;
	long endTime = 0;
	zval *zevents;
	result_t result = RES_ERROR;
	
	int argNum = ZEND_NUM_ARGS();
	if ( argNum < 3 )
		WRONG_PARAM_COUNT;
	
	if(zend_get_parameters_array_ex(argNum, parameters) != SUCCESS)
		WRONG_PARAM_COUNT;
	
	sid = getZvalInt( parameters[0] );
	zevents = *(parameters[1]);
	if ( Z_TYPE_P(zevents) != IS_ARRAY ){
		zend_error(E_WARNING, "2nd parameter wasn't an array");
		RETURN_LONG( RES_ERROR );
	}
	int max = getZvalInt( parameters[2] );
	
	event_t *events = 0;
	int eventsLen = 0;
	result = getEventsForRSS( sid, &events, &eventsLen, max );
	if ( result == RES_OK ){
		result = eventsToZval( events, eventsLen, zevents );
		delete[] events;
	}
	
	RETURN_LONG( result );
}

/**
 * item_status̷
 *
 * int xnp_update_item_status()
 * @return RES_OK
 *
 */
ZEND_FUNCTION(xnp_update_item_status)
{
	result_t result = updateItemStatus();
	RETURN_LONG( result );
}

/**
 * item_status򥯥ꥢƤupdateItemStatusԤ
 *
 * int xnp_refresh_item_status()
 * @return RES_OK
 *
 */
ZEND_FUNCTION(xnp_refresh_item_status)
{
	result_t result = refreshItemStatus();
	RETURN_LONG( result );
}

/**
 * selective harvestingԤ
 *
 * int xnp_selective_harvesting( int from, int until, int start_iid, int limit, array iids )
 * @param from, until ϰ time_t  0ʤꤷʤäΤȤߤʤ
 * @param start_iid   
 * @param limit       ٤˼
 * @param iids        ̤
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 *
 */
ZEND_FUNCTION(xnp_selective_harvesting)
{
	long from, until, startIID, limit;
	zval *ziids;
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lllla",
							  &from, &until, &startIID, &limit, &ziids) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}

	int iidsLen = 0;
	char **piids;
	result = selectiveHarvesting( from, until, startIID, limit, &piids, &iidsLen );
	if ( RES_OK == result ){
		zend_hash_clean( Z_ARRVAL_PP(&ziids) );
		for( int i = 0; i < iidsLen; i++ ){
			add_index_string( ziids, i, piids[ i ], 1 );
		}
        freeStringArray( piids, iidsLen );
	}
	
	RETURN_LONG( result );
}

/**
 * item_status
 *
 * int xnp_get_item_status( int iid, array status )
 * @param iid  item ID
 * @param status  ֤Ϣ󡣰ʲΥޤࡣ created_timestamp, modified_timestamp, deleted_timestamp, is_deleted
 * @return RES_OK
 * @return RES_NO_SUCH_ITEM
 *
 */
ZEND_FUNCTION(xnp_get_item_status)
{
	long iid;
	zval *zstatus;
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "la",
							  &iid, &zstatus) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}

	itemstatus_t status;
	result = getMetadataEvent( iid, &status );
	if ( result == RES_OK ){
		zend_hash_clean( zstatus -> value.ht );
		add_assoc_long( zstatus, "created_timestamp"  , status.createdTimestamp  );
		add_assoc_long( zstatus, "modified_timestamp" , status.modifiedTimestamp );
		add_assoc_long( zstatus, "deleted_timestamp"  , status.deletedTimestamp  );
		add_assoc_long( zstatus, "is_deleted"         , status.isDeleted         );
	}
	
	RETURN_LONG( result );
}

/**
 * syslog
 *
 * void xnp_use_syslog( bool use_syslog_flag )
 * @param use_syslog_flag  trueʤϤ롣falseʤϤʤ
 *
 */
ZEND_FUNCTION(xnp_use_syslog)
{
	result_t result = RES_ERROR;
	zend_bool useSyslogFlag = 0;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "b",
							  &useSyslogFlag ) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}
	
	useSyslog( (bool)useSyslogFlag );
	
	RETURN_NULL();
}


/**
 * ƥ֥󥯤ɲä롥
 *
 * int xnp_insert_related_to( int sid, int parent_id, int item_id )
 * @param sid åID
 * @param parent_id 󥯸ΥƥID
 * @param item_id ΥƥID
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_WRITE_ACCESS_RIGHT parentidԽǤʤƥ򤵤Ƥ롤<br/>ޤitemidǤʤƥؤƤ롤<br/>ޤ XooNIps桼Ǥʤ(activateԤ)
 *
 */
ZEND_FUNCTION(xnp_insert_related_to)
{
	long sid, parent_id, item_id;
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lll",
							  &sid, &parent_id, &item_id) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}

	result = insertRelatedTo( sid, parent_id, item_id );
	
	RETURN_LONG( result );
}

/**
 * ƥ֥󥯤롥
 *
 * int xnp_delete_related_to( int sid, int parent_id, int item_id )
 * @param sid åID
 * @param parent_id 󥯸ΥƥID
 * @param item_id ΥƥID
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_WRITE_ACCESS_RIGHT parentidԽǤʤƥ򤵤Ƥ롤<br/>ޤitemidǤʤƥؤƤ롤<br/>ޤ XooNIps桼Ǥʤ(activateԤ)
 *
 */
ZEND_FUNCTION(xnp_delete_related_to)
{
	long sid, parent_id, item_id;
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lll",
							  &sid, &parent_id, &item_id) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}

	result = deleteRelatedTo( sid, parent_id, item_id );
	
	RETURN_LONG( result );
}

/**
 * ƥ֥󥯤롥
 * 襢ƥα¤̵硤Υ󥯾֤ʤ.
 *
 * int xnp_get_related_to( int sid, int parent_id, array &ids )
 * @param sid åID
 * @param parent_id 󥯸ΥƥID
 * @param ids ΥƥID
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_WRITE_ACCESS_RIGHT parent_idؤ˥̵, XooNIps桼Ǥʤ(activateԤ)
 *
 */
ZEND_FUNCTION(xnp_get_related_to)
{
	long sid, parent_id;
	zval *zids;
    itemid_t *ids = 0;
    int idsLen = 0;
	result_t result = RES_ERROR;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "lla",
							  &sid, &parent_id, &zids) == FAILURE) {
		fprintf( stderr, "error occured " );
		return;
	}
    
    result = getRelatedTo( sid, parent_id, &ids, &idsLen );
    itemidsToZval( ids, idsLen, &zids );
    freeItemID( ids );
	
	RETURN_LONG( result );
}

