<?php
//  $Revision: 1.1.2.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

global $xoopsConfig;
if ( file_exists( XOOPS_ROOT_PATH.'/modules/xnpconference/language/' . $xoopsConfig['language'] . '/main.php') ){
	include_once( XOOPS_ROOT_PATH.'/modules/xnpconference/language/' . $xoopsConfig['language'] . '/main.php' );
}
else {
	include_once( XOOPS_ROOT_PATH.'/modules/xnpconference/language/english/main.php' );
}

// convert \r to \n. trim each lines. delete empty lines. remove last \n.
function xnpconferenceTrimAuthorString( $author ){
	$author = str_replace("\r", "\n", $author);
	$ar = explode( "\n", $author );
	$ar2 = array();
	foreach ( $ar as  $val ){
		$val = trim($val);
		if ( $val != "" )
			$ar2[] = $val;
	}
	return implode( "\n", $ar2 );
}

function xnpconferenceGetTypes(){
  return array( 'powerpoint'=>'PowerPoint', 'pdf'=>'PDF', 'illustrator'=>'Illustrator', 'other'=>'Other' );
}

/** get DetailInformation by item_id
  * 
  */
function xnpconferenceGetDetailInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array(
			'presentation_type' =>'',
			'conference_title'  =>'',
			'place'             =>'',
			'author'            =>'',
			'abstract'          =>'',
			'conference_from_year'  =>'',
			'conference_from_month' =>'',
			'conference_from_mday'  =>'',
			'conference_to_year'  =>'',
			'conference_to_month' =>'',
			'conference_to_mday'  =>''
		);
	
	$sql = "select * from " . $xoopsDB->prefix("xnpconference_item_detail") . " where conference_id=$item_id";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	$types = xnpconferenceGetTypes();
	$detail = $xoopsDB->fetchArray($result);
	$detail['presentation_type_str'] = $types[$detail['presentation_type']];
	return $detail;
}

function xnpconferenceGetMetaInformation( $item_id ){
	$ret = array();
	$basic = xnpGetBasicInformationArray($item_id);
	$detail = xnpconferenceGetDetailInformation( $item_id );
	if ( !empty( $basic ) ){
		$ret[_MD_XNPCONFERENCE_PRESENTATION_TITLE_LABEL] = $basic['title'];
		$ret[_MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL] = $basic['contributor'];
		$ret[_MD_XOONIPS_ITEM_KEYWORDS_LABEL] = $basic['keywords'];
		$ret[_MD_XOONIPS_ITEM_DESCRIPTION_LABEL] = $basic['description'];
		$ret[_MD_XOONIPS_ITEM_DOI_LABEL] = $basic['doi'];
		$ret[_MD_XOONIPS_ITEM_CREATION_DATE_LABEL] = $basic['creation_date'];
		$ret[_MD_XOONIPS_ITEM_LAST_UPDATE_DATE_LABEL] = $basic['last_update_date'];
	}
	if ( !empty( $detail ) ){
		$ret[_MD_XNPCONFERENCE_PRESENTATION_TYPE_LABEL ] = $detail['presentation_type_str'];
		$ret[_MD_XNPCONFERENCE_CONFERENCE_TITLE_LABEL  ] = $detail['conference_title'];
		$ret[_MD_XNPCONFERENCE_PLACE_LABEL             ] = $detail['place'        ];
		$ret[_MD_XNPCONFERENCE_AUTHOR_LABEL            ] = $detail['author'      ];
		$ret[_MD_XOONIPS_ITEM_ABSTRACT_LABEL           ] = $detail['abstract'    ];
	}
	if ( !empty( $basic ) ){
		$publication_gmt = mktime(0,0,0,$basic['publication_month'],$basic['publication_mday'],$basic['publication_year']);
		$ret[_MD_XNPCONFERENCE_DATE_LABEL              ] = date( DATE_FORMAT, $publication_gmt );
	}
/*
	if ( !empty( $detail ) ){
		$ret[_MD_XOONIPS_ITEM_README_LABEL      ] = $detail['readme' ];
		$ret[_MD_XOONIPS_ITEM_LICENSE_LABEL     ] = $detail['license'];
		$ret[_MD_XOONIPS_ITEM_RIGHTS_LABEL      ] = $detail['rights' ];
	}
*/
	return $ret;
}

function xnpconferenceGetListBlock( $item_basic ){
	$item_id = $item_basic['item_id'];
	
	// get DetailInformation
	$item_detail = xnpconferenceGetDetailInformation( $item_id );
	$item_detail['author_str'] = str_replace( "\n", ", ", $item_detail['author']); // separate with ", "
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'item_basic', $item_basic );
	$tpl->assign( 'item_detail', $item_detail );
	if( xnpIsPending( $item_basic['item_id'] ) ) $tpl->assign( 'pending', 'true' );
	
	// return as HTML
	//return $tpl->fetch( XOOPS_ROOT_PATH . "/modules/xnpconference/templates/xnpconference_list_block.html" );
	return $tpl->fetch( "db:xnpconference_list_block.html" );
}

function xnpconferenceGetPrinterFriendlyListBlock( $item_basic ){
	return xnpconferenceGetListBlock( $item_basic );
}


function xnpconferenceGetDetailBlock( $item_id ){
	
	// get DetailInformation
	$item_detail = xnpconferenceGetDetailInformation( $item_id );
	$item_detail['author_str'] = str_replace( "\n", ", ", $item_detail['author']); // separate with ", "
	
	// get BasicInformation / Preview / IndexKeywords block
	$basic   = xnpGetBasicInformationDetailBlock( $item_id );
//	$preview = xnpGetPreviewDetailBlock( $item_id );
	$index   = xnpGetIndexDetailBlock( $item_id );
	$presentation_file = xnpGetAttachmentDetailBlock( $item_id, 'presentation_file' );
	$conference_paper = xnpGetAttachmentDetailBlock( $item_id, 'conference_paper' );
	if ( !empty($item_detail['conference_from_year']) ) {
		$conference_from = date( DATE_FORMAT, mktime(0,0,0,$item_detail['conference_from_month'],$item_detail['conference_from_mday'], $item_detail['conference_from_year']) );
		$conference_to = date( DATE_FORMAT, mktime(0,0,0,$item_detail['conference_to_month'],$item_detail['conference_to_mday'], $item_detail['conference_to_year']) );
	}
	else {
		$conference_from = date( DATE_FORMAT, mktime(0,0,0,$basic['publication_month']['value'],$basic['publication_mday']['value'], $basic['publication_year']['value']) );
		$conference_to = $conference_from;
	}
	$conference_date = "From:&nbsp;".$conference_from."&nbsp;&nbsp;&nbsp;To:&nbsp;".$conference_to;
/*
	$readme  = xnpGetTextFileDetailBlock( $item_id, 'readme' , $item_detail['readme' ] );
	$license = xnpGetTextFileDetailBlock( $item_id, 'license', $item_detail['license'] );
	$rights  = xnpGetTextFileDetailBlock( $item_id, 'rights' , $item_detail['rights' ] );
*/
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'basic', $basic );
//	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'presentation_file', $presentation_file );
	$tpl->assign( 'conference_paper', $conference_paper );
	$tpl->assign( 'detail', $item_detail );
	$tpl->assign( 'conference_date', array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_DATE_LABEL, 'value'=>$conference_date ) );
/*
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'license', $license );
	$tpl->assign( 'rights' , $rights );
*/
	
	
	// return as HTML
	return $tpl->fetch( "db:xnpconference_detail_block.html" );
}

// todo
function xnpconferenceGetPrinterFriendlyDetailBlock( $item_id )
{
	$myts =& MyTextsanitizer::getInstance();

	// get DetailInformation
	$item_detail = xnpconferenceGetDetailInformation( $item_id );
	$detail['author_str'] = str_replace( "\n", ", ", $detail['author']); // separate with ", "
	
	// get BasicInformation / Preview / IndexKeywords block
	$basic   = xnpGetBasicInformationDetailBlock( $item_id );
//	$preview = xnpGetPreviewPrinterFriendlyBlock( $item_id );
	$index   = xnpGetIndexPrinterFriendlyBlock( $item_id );
	$presentation_file = xnpGetAttachmentPrinterFriendlyBlock( $item_id, 'presentation_file' );
	$conference_paper = xnpGetAttachmentPrinterFriendlyBlock( $item_id, 'conference_paper' );
	if ( !empty($item_detail['conference_from_year']) ) {
		$conference_from = date( DATE_FORMAT, mktime(0,0,0,$item_detail['conference_from_month'],$item_detail['conference_from_mday'], $item_detail['conference_from_year']) );
		$conference_to = date( DATE_FORMAT, mktime(0,0,0,$item_detail['conference_to_month'],$item_detail['conference_to_mday'], $item_detail['conference_to_year']) );
	}
	else {
		$conference_from = date( DATE_FORMAT, mktime(0,0,0,$basic['publication_month']['value'],$basic['publication_mday']['value'], $basic['publication_year']['value']) );
		$conference_to = $conference_from;
	}
	$conference_date = "From:&nbsp;".$conference_from."&nbsp;&nbsp;&nbsp;To:&nbsp;".$conference_to;
/*
	$readme  = xnpGetTextFilePrinterFriendlyBlock( $item_id, 'readme',  $item_detail['readme']  );
	$license = xnpGetTextFilePrinterFriendlyBlock( $item_id, 'license', $item_detail['license'] );
	$rights  = xnpGetTextFilePrinterFriendlyBlock( $item_id, 'rights',  $item_detail['rights']  );
*/
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'basic', $basic );
//	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'presentation_file', $presentation_file );
	$tpl->assign( 'conference_paper', $conference_paper );
	$tpl->assign( 'detail', $item_detail );
	$tpl->assign( 'conference_date', array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_DATE_LABEL, 'value'=>$conference_date ) );
/*
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'license', $license );
	$tpl->assign( 'rights' , $rights );
*/
	
	
	// return as HTML
	return $tpl->fetch( "db:xnpconference_detail_block.html" );
}

function xnpconferenceGetRegisterBlock(){
	global $xoopsDB;
	$myts =& MyTextSanitizer::getInstance();
	
	// get DetailInformation
	$tpl = new xoopsTpl();
	if ( isset( $_POST['presentation_type'] ) ){
		if ( isset($_POST['conferenceFromYear']) )
			$tpl->assign('gmtimeFrom', mktime(0,0,0,xnpGetPostVarDef('conferenceFromMonth',1),xnpGetPostVarDef('conferenceFromDay',1),$_POST['conferenceFromYear']));
		if ( isset($_POST['conferenceToYear']) )
			$tpl->assign('gmtimeTo', mktime(0,0,0,xnpGetPostVarDef('conferenceToMonth',1),xnpGetPostVarDef('conferenceToDay',1),$_POST['conferenceToYear']));
		$detail = array(
			'presentation_type' => $myts->stripSlashesGPC($_POST['presentation_type']),
			'conference_title'  => $myts->stripSlashesGPC($_POST['conference_title' ]),
			'place'             => $myts->stripSlashesGPC($_POST['place' ]),
			'author'            => $myts->stripSlashesGPC($_POST['author' ]),
			'abstract'          => $myts->stripSlashesGPC($_POST['abstract' ]),
			'conference_date'   => array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_DATE_LABEL, 'value'=>$tpl->fetch( "db:xnpconference_date.html" ) )
		);
	}
	else {
		$tpl->assign('gmtimeFrom', time());
		$tpl->assign('gmtimeTo'  , time());
		$detail = array(
			'presentation_type' => 'other',
			'conference_date'   => array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_DATE_LABEL, 'value'=>$tpl->fetch( "db:xnpconference_date.html" ) ),
			'conference_year'   => array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_YEAR_LABEL, 'value'=>$tpl->fetch( "db:xnpconference_year.html" ) ),
			'conference_month'  => array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_MONTH_LABEL, 'value'=>$tpl->fetch( "db:xnpconference_month.html" ) ),
			'conference_mday'   => array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_MDAY_LABEL, 'value'=>$tpl->fetch( "db:xnpconference_mday.html" ) )
		);
	}
	
	// get BasicInformation / Preview / index block
	$basic = xnpGetBasicInformationRegisterBlock();
//	$preview = xnpGetPreviewRegisterBlock();
	$index = xnpGetIndexRegisterBlock();
	$presentation_file = xnpGetAttachmentRegisterBlock( 'presentation_file' );
	$conference_paper = xnpGetAttachmentRegisterBlock( 'conference_paper' );
/*
	$readme  = xnpGetTextFileRegisterBlock( 'readme'  );
	$license = xnpGetTextFileRegisterBlock( 'license' );
	$rights  = xnpGetTextFileRegisterBlock( 'rights'  );
*/
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'basic', $basic );
//	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'presentation_file', $presentation_file );
	$tpl->assign( 'conference_paper', $conference_paper );
//	$tpl->assign( 'attachment_dl_limit', xnpGetDownloadLimitationOptionRegisterBlock( 'xnpconference' ) );
	$tpl->assign( 'detail', $detail );
/*
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'license', $license );
	$tpl->assign( 'rights' , $rights );
*/
	$tpl->assign( 'presentation_type', xnpconferenceGetTypes() );
	$tpl->assign( 'presentation_type_selected', $detail['presentation_type'] );
	$tpl->assign( 'conference_date', $detail['conference_date'] );
	// return as HTML
	return $tpl->fetch( "db:xnpconference_register_block.html" );
}

function xnpconferenceGetEditBlock( $item_id ){
	global $xoopsDB;

	// get BasicInformation / Preview / index block
	$basic   = xnpGetBasicInformationEditBlock( $item_id );
//	$preview = xnpGetPreviewEditBlock( $item_id );
	$index = xnpGetIndexEditBlock( $item_id );
	$presentation_file = xnpGetAttachmentEditBlock( $item_id, 'presentation_file' );
	$conference_paper = xnpGetAttachmentEditBlock( $item_id, 'conference_paper' );
	
	// get DetailInformation
	if ( isset( $_POST['presentation_type'] ) ){
		$myts =& MyTextSanitizer::getInstance();
/*
		$detail = array(
			'presentation_type'=>$myts->stripSlashesGPC($_POST['presentation_type' ]),
			'conference_title' =>$myts->stripSlashesGPC($_POST['conference_title' ]),
			'place'            =>$myts->stripSlashesGPC($_POST['place' ]),
			'author'           =>$myts->stripSlashesGPC($_POST['author' ]),
			'abstract'         =>$myts->stripSlashesGPC($_POST['abstract' ]),
			'readme'   => '',
			'license'  => '',
			'rights'   => ''
		);
*/
		$detail = array(
			'presentation_type'=>$myts->stripSlashesGPC($_POST['presentation_type' ]),
			'conference_title' =>$myts->stripSlashesGPC($_POST['conference_title' ]),
			'place'            =>$myts->stripSlashesGPC($_POST['place' ]),
			'author'           =>$myts->stripSlashesGPC($_POST['author' ]),
			'abstract'         =>$myts->stripSlashesGPC($_POST['abstract' ]),
			'conference_from_year'  =>$myts->stripSlashesGPC($_POST['conference_year' ]),
			'conference_from_month' =>$myts->stripSlashesGPC($_POST['conference_month' ]),
			'conference_from_mday'  =>$myts->stripSlashesGPC($_POST['conference_mday' ])
		);
	}
	else if ( !empty( $item_id ) ){
		$detail = xnpconferenceGetDetailInformation( $item_id );
	}
	else
		$detail = array();
	$basic2   = xnpGetBasicInformationDetailBlock( $item_id );
	$tpl = new xoopsTpl();
	if ( !empty($detail['conference_from_year']) ) {
		$tpl->assign('gmtimeFrom', mktime(0,0,0,$detail['conference_from_month'],$detail['conference_from_mday'],$detail['conference_from_year']));
		$tpl->assign('gmtimeTo', mktime(0,0,0,$detail['conference_to_month'],$detail['conference_to_mday'],$detail['conference_to_year']));
	}
	else {
		$tpl->assign('gmtimeFrom', mktime(0,0,0,$basic2['publication_month']['value'],$basic2['publication_mday']['value'],$basic2['publication_year']['value']));
		$tpl->assign('gmtimeTo', mktime(0,0,0,$basic2['publication_month']['value'],$basic2['publication_mday']['value'],$basic2['publication_year']['value']));
	}
	$detail['conference_date'] = array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_DATE_LABEL, 'value'=>$tpl->fetch( "db:xnpconference_date.html" ) );
/*
	$readme  = xnpGetTextFileEditBlock( $item_id, 'readme' , isset( $detail['readme' ] ) ? $detail['readme' ] : '' );
	$license = xnpGetTextFileEditBlock( $item_id, 'license' , isset( $detail['license' ] ) ? $detail['license' ] : '' );
	$rights  = xnpGetTextFileEditBlock( $item_id, 'rights' , isset( $detail['rights' ] ) ? $detail['rights' ] : '' );
*/
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl

	$tpl->assign( 'basic', $basic );
//	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'presentation_file', $presentation_file );
	$tpl->assign( 'conference_paper', $conference_paper );
//	$tpl->assign( 'attachment_dl_limit', xnpGetDownloadLimitationOptionEditBlock( 'xnpconference', xnpconferenceGetAttachmentDownloadLimitOption( $item_id ) ) );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'conference_date', $detail['conference_date'] );
/*
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'license', $license );
	$tpl->assign( 'rights' , $rights );
*/
	$tpl->assign( 'presentation_type', xnpconferenceGetTypes() );
	$tpl->assign( 'presentation_type_selected', $detail['presentation_type'] );

	
	// return as HTML
	return $tpl->fetch( "db:xnpconference_register_block.html" );
}


function xnpconferenceGetConfirmBlock( $item_id ){


	// get BasicInformation / Preview / index block
	$basic   = xnpGetBasicInformationConfirmBlock( $item_id );
//	$preview = xnpGetPreviewConfirmBlock( $item_id );
	$index   = xnpGetIndexConfirmBlock( $item_id );
	$presentation_file = xnpGetAttachmentConfirmBlock( $item_id, 'presentation_file' );
	$conference_paper = xnpGetAttachmentConfirmBlock( $item_id, 'conference_paper' );
/*
	$readme  = xnpGetTextFileConfirmBlock( $item_id, 'readme' );
	$license = xnpGetTextFileConfirmBlock( $item_id, 'license');
	$rights  = xnpGetTextFileConfirmBlock( $item_id, 'rights' );
*/
	// get DetailInformation
	if ( isset( $_POST['conference_title'] ) ){
                $_POST['author'] = xnpconferenceTrimAuthorString($_POST['author']);
		$myts =& MyTextSanitizer::getInstance();
/*
		$detail = array(
			'presentation_type' =>$myts->stripSlashesGPC($_POST['presentation_type' ]),
			'conference_title'  =>$myts->stripSlashesGPC($_POST['conference_title'  ]),
			'place'             =>$myts->stripSlashesGPC($_POST['place'             ]),
			'author'            =>$myts->stripSlashesGPC($_POST['author'            ]),
			'abstract'          =>$myts->stripSlashesGPC($_POST['abstract'          ]),
			'conference_from_year'   =>$myts->stripSlashesGPC($_POST['conferenceFromYear' ]),
			'conference_from_month'  =>$myts->stripSlashesGPC($_POST['conferenceFromMonth' ]),
			'conference_from_mday'   =>$myts->stripSlashesGPC($_POST['conferenceFromDay' ]),
			'conference_to_year'   =>$myts->stripSlashesGPC($_POST['conferenceToYear' ]),
			'conference_to_month'  =>$myts->stripSlashesGPC($_POST['conferenceToMonth' ]),
			'conference_to_mday'   =>$myts->stripSlashesGPC($_POST['conferenceToDay' ])
		);
*/
		$detail = array(
			'presentation_type' =>$myts->stripSlashesGPC($_POST['presentation_type' ]),
			'conference_title'  =>$myts->stripSlashesGPC( xnpHtmlspecialchars( $_POST['conference_title'  ]) ),
			'place'             =>$myts->stripSlashesGPC( xnpHtmlspecialchars( $_POST['place'             ]) ),
			'author'            =>$myts->stripSlashesGPC( xnpHtmlspecialchars( $_POST['author'            ]) ),
			'abstract'          =>$myts->stripSlashesGPC( xnpHtmlspecialchars( $_POST['abstract'          ]) ),
			'conference_from_year'   =>$myts->stripSlashesGPC($_POST['conferenceFromYear' ]),
			'conference_from_month'  =>$myts->stripSlashesGPC($_POST['conferenceFromMonth' ]),
			'conference_from_mday'   =>$myts->stripSlashesGPC($_POST['conferenceFromDay' ]),
			'conference_to_year'   =>$myts->stripSlashesGPC($_POST['conferenceToYear' ]),
			'conference_to_month'  =>$myts->stripSlashesGPC($_POST['conferenceToMonth' ]),
			'conference_to_mday'   =>$myts->stripSlashesGPC($_POST['conferenceToDay' ])
		);
		$types = xnpconferenceGetTypes();
		$detail['presentation_type_str'] = $types[$detail['presentation_type']];
		$detail['author_str'] = str_replace( "\n", ", ", $detail['author']); // separate with ", "
		$conference_from = date( DATE_FORMAT, mktime(0,0,0,$detail['conference_from_month'],$detail['conference_from_mday'], $detail['conference_from_year']) );
		$conference_to = date( DATE_FORMAT, mktime(0,0,0,$detail['conference_to_month'],$detail['conference_to_mday'], $detail['conference_to_year']) );
		$conference_date = "From: ".$conference_from." To: ".$conference_to;
	}
	else if ( !empty( $item_id ) )
		$detail = xnpconferenceGetDetailInformation( $item_id );
	else
		$detail = array();
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	
	$tpl->assign( 'basic', $basic );
//	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'presentation_file', $presentation_file );
	$tpl->assign( 'conference_paper', $conference_paper );
//	$tpl->assign( 'attachment_dl_limit', xnpGetDownloadLimitationOptionConfirmBlock( 'xnpconference' ) );
	$tpl->assign( 'detail', $detail );
	$tpl->assign( 'conference_date', array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_DATE_LABEL, 'value'=>$conference_date ) );
/*
	$tpl->assign( 'readme' , $readme );
	$tpl->assign( 'license', $license );
	$tpl->assign( 'rights' , $rights );
*/
	// return as HTML
	return $tpl->fetch( "db:xnpconference_confirm_block.html" );
}

/** check DetailInformation input
 * called from confirm/registered page
 */
function xnpconferenceCheckRegisterParameters( &$message ){
	$xnpsid = $_SESSION['XNPSID'];
	$messages = array();
        $_POST['author'] = xnpconferenceTrimAuthorString($_POST['author']);
	if ( empty( $_POST['conference_title'] ) ) $messages[] = _MD_XNPCONFERENCE_CONFERENCE_TITLE_REQUIRED;
	if ( empty( $_POST['place'] ) ) $messages[] = _MD_XNPCONFERENCE_PLACE_REQUIRED;
	if ( empty( $_POST['author'] ) ) $messages[] = _MD_XNPCONFERENCE_AUTHOR_REQUIRED;
	if ( empty( $_POST['presentation_fileFileID'  ]) && empty( $_FILES['presentation_file']['name']) ) $messages[] = _MD_XNPCONFERENCE_PRESENTATION_FILE_REQUIRED;
	$conference_from = date( 'U', mktime(0,0,0,$_POST['conferenceFromMonth'],$_POST['conferenceFromDay'], $_POST['conferenceFromYear']) );
	$conference_to = date( 'U', mktime(0,0,0,$_POST['conferenceToMonth'],$_POST['conferenceToDay'], $_POST['conferenceToYear']) );
	if ( $conference_from > $conference_to) $messages[] = _MD_XNPCONFERENCE_DATE_ERROR;
	
	// require Readme, License and Rights if register to public indexes
	$xids = explode( ',', $_POST['xoonipsCheckedXID'] );
	$indexes = array( );
	if( $xids[0] != $_POST['xoonipsCheckedXID'] ) {
		foreach( $xids as $i ) {
			$index = array( );
			if( xnp_get_index( $xnpsid, $i, $index ) == RES_OK ) {
				$indexes[] = $index;
			} else {
				$messages[] = "<font color='#ff0000'>".xnp_get_last_error_string( )."</font>";
				$result = false;
				break;
			}
		}
	}
/*
	if( count( $indexes ) > 0 ) {
		foreach( $indexes as $i ) {
			if( $i['open_level'] <= OL_GROUP_ONLY ) {
				if( $_POST['readmeEncText'] == '' ) {
					//readme is not filled
					$messages[] = "<font color='#ff0000'>"._MD_XNPCONFERENCE_README_REQUIRED."</font>";
				}
				if( $_POST['licenseEncText'] == '' ) {
					//license is not filled
					$messages[] = "<font color='#ff0000'>"._MD_XNPCONFERENCE_LICENSE_REQUIRED."</font>";
				}
				if( $_POST['rightsEncText'] == '' ) {
					//rights is not filled
					$messages[] = "<font color='#ff0000'>"._MD_XNPCONFERENCE_RIGHTS_REQUIRED."</font>";
				}
				break;
			}
		}
	}
*/
	
	if ( count($messages) == 0 )
		return true;
	$message = "<br>\n" . implode( "<br>\n", $messages );
	return false;
}

/** check DetailInformation input
 */
function xnpconferenceCheckEditParameters( &$message ){
	return xnpconferenceCheckRegisterParameters( $message );
}

function xnpconferenceInsertItem(){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// register BasicInformation, Index, Attachment
	$item_id = 0;
	$myts =& MyTextSanitizer::getInstance();
	$_POST['publicationDateYear' ] = $myts->addSlashes($_POST['conferenceFromYear' ]);
	$_POST['publicationDateMonth' ] = $myts->addSlashes($_POST['conferenceFromMonth' ]);
	$_POST['publicationDateDay' ] = $myts->addSlashes($_POST['conferenceFromDay' ]);
	$result = xnpInsertBasicInformation( $item_id );
	if ( $result ){
		$result = xnpUpdateIndex( $item_id );
		if ( $result ){
			$result = xnpUpdatePreview( $item_id );
			if ( $result ){
				$result = xnpUpdateAttachment( $item_id, 'presentation_file' );
				if ( $result ){
					$result = xnpUpdateAttachment( $item_id, 'conference_paper' );
					if ( $result ){
					}
				}
			}
		}
		if ( !$result )
			xnpDeleteBasicInformation( $xnpsid, $item_id );
	}
	if ( !$result )
		return false;
	
        $_POST['author'] = xnpconferenceTrimAuthorString($_POST['author']);
//	$myts =& MyTextSanitizer::getInstance();
/*
	$keys = implode( ",", array(
		'presentation_type'     ,
		'conference_title',
		'place',
		'author',
		'abstract',
		'attachment_dl_limit'
	) );
*/
	$keys = implode( ",", array(
		'presentation_type'     ,
		'conference_title',
		'place',
		'author',
		'abstract',
		'conference_from_year',
		'conference_from_month',
		'conference_from_mday',
		'conference_to_year',
		'conference_to_month',
		'conference_to_mday'
	) );
/*
	$vals = implode( "','", array(
		$myts->addSlashes($_POST['presentation_type' ]),
		$myts->addSlashes($_POST['conference_title' ]),
		$myts->addSlashes($_POST['place' ]),
		$myts->addSlashes($_POST['author' ]),
		$myts->addSlashes($_POST['abstract' ]),
		$myts->addSlashes($_POST['attachment_dl_limit' ])
	) );
*/
	$vals = implode( "','", array(
		$myts->addSlashes($_POST['presentation_type' ]),
		$myts->addSlashes($_POST['conference_title' ]),
		$myts->addSlashes($_POST['place' ]),
		$myts->addSlashes($_POST['author' ]),
		$myts->addSlashes($_POST['abstract' ]),
		$myts->addSlashes($_POST['conferenceFromYear' ]),
		$myts->addSlashes($_POST['conferenceFromMonth' ]),
		$myts->addSlashes($_POST['conferenceFromDay' ]),
		$myts->addSlashes($_POST['conferenceToYear' ]),
		$myts->addSlashes($_POST['conferenceToMonth' ]),
		$myts->addSlashes($_POST['conferenceToDay' ])
	) );
	
	
	// register DetailInformation
	$myts =& MyTextSanitizer::getInstance();
/*
	$esc_readme  = addslashes( xnpGetTextFile( 'readme'  ) );
	$esc_license = addslashes( xnpGetTextFile( 'license' ) );
	$esc_rights  = addslashes( xnpGetTextFile( 'rights'  ) );
*/
/*
	$sql = "insert into " . $xoopsDB->prefix("xnpconference_item_detail") . " ( conference_id, readme, license, rights, $keys ) values ( $item_id, '$esc_readme', '$esc_license', '$esc_rights', '$vals' ) ";
*/
	$sql = "insert into " . $xoopsDB->prefix("xnpconference_item_detail") . " ( conference_id, $keys ) values ( $item_id, '$vals' ) ";
	$result = $xoopsDB->queryF( $sql );
	if ( $result == false ){
		echo "cannot insert item_detail";
		return false;
	}
	
	return true;
}

function xnpconferenceUpdateItem( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	$myts =& MyTextSanitizer::getInstance();
	
	// edit BasicInformation, Index, Preview, Attachment 
	$_POST['publicationDateYear' ] = $myts->addSlashes($_POST['conferenceFromYear' ]);
	$_POST['publicationDateMonth' ] = $myts->addSlashes($_POST['conferenceFromMonth' ]);
	$_POST['publicationDateDay' ] = $myts->addSlashes($_POST['conferenceFromDay' ]);
	$result = xnpUpdateBasicInformation( $item_id );
	if ( $result ){
		$result = xnpUpdateIndex( $item_id );
		if ( $result ){
			$result = xnpUpdatePreview( $item_id );
			if ( $result ){
				$result = xnpUpdateAttachment( $item_id, 'presentation_file' );
				if ( $result ){
					$result = xnpUpdateAttachment( $item_id, 'conference_paper' );
					if ( $result ){
						$result = xnp_insert_change_log( $xnpsid, $item_id, $myts->stripSlashesGPC( $_POST['change_log'] ) );
						$result = !$result;
						if( !$result )
							echo " xnp_insert_change_log failed.";
					}
				}
				else echo " xnpUpdateAttachment failed.";
			}
			else echo " xnpUpdatePreview failed.";
		}
		else echo " xnpUpdateIndex failed.";
	}
	else echo " xnpUpdateBasicInformation failed.";
	if ( !$result )
		return false;
	
	// register DetailInformation
/*
	$esc_readme  = addslashes( xnpGetTextFile( 'readme'  ) );
	$esc_license = addslashes( xnpGetTextFile( 'license' ) );
	$esc_rights  = addslashes( xnpGetTextFile( 'rights'  ) );
*/
        $_POST['author'] = xnpconferenceTrimAuthorString($_POST['author']);
/*
	$sql = implode( ',', array(
		'presentation_type'."='".$myts->addSlashes($_POST['presentation_type' ])."'",
		'conference_title' ."='".$myts->addSlashes($_POST['conference_title' ])."'",
		'place'            ."='".$myts->addSlashes($_POST['place' ])."'",
		'author'           ."='".$myts->addSlashes($_POST['author' ])."'",
		'abstract'         ."='".$myts->addSlashes($_POST['abstract' ])."'",
		'attachment_dl_limit'        ."='".$myts->addSlashes($_POST['attachment_dl_limit' ])."'"
	) );
*/
	$sql = implode( ',', array(
		'presentation_type'."='".$myts->addSlashes($_POST['presentation_type' ])."'",
		'conference_title' ."='".$myts->addSlashes($_POST['conference_title' ])."'",
		'place'            ."='".$myts->addSlashes($_POST['place' ])."'",
		'author'           ."='".$myts->addSlashes($_POST['author' ])."'",
		'abstract'         ."='".$myts->addSlashes($_POST['abstract' ])."'",
		'conference_from_year'  ."='".$myts->addSlashes($_POST['conferenceFromYear' ])."'",
		'conference_from_month' ."='".$myts->addSlashes($_POST['conferenceFromMonth' ])."'",
		'conference_from_mday'  ."='".$myts->addSlashes($_POST['conferenceFromDay' ])."'",
		'conference_to_year'  ."='".$myts->addSlashes($_POST['conferenceToYear' ])."'",
		'conference_to_month' ."='".$myts->addSlashes($_POST['conferenceToMonth' ])."'",
		'conference_to_mday'  ."='".$myts->addSlashes($_POST['conferenceToDay' ])."'"
	) );
/*
	$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnpconference_item_detail") . " set readme='$esc_readme', license='$esc_license', rights='$esc_rights', $sql where conference_id = $item_id " );
*/
	$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnpconference_item_detail") . " set $sql where conference_id = $item_id " );
	if ( $result == false )
		return false;
	
	return true;
}

function xnpconferenceDeleteItem( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// delete BasicInformation, Index, Preview, Attachment 
	if( !xnpDeleteBasicInformation( $item_id ) ){
		echo "cannot delete model item";
		return false;
	}
	
	// delete DetailInformation
	$sql = "delete from " . $xoopsDB->prefix("xnpconference_item_detail")
		. " where conference_id=$item_id";
	$xoopsDB->queryF( $sql );
	return true;
}




function xnpconferenceGetDetailInformationQuickSearchQuery(&$wheres, &$join, $keywords){
	global $xoopsDB;
	$conference_table = $xoopsDB->prefix('xnpconference_item_detail');
	$file_table  = $xoopsDB->prefix('xoonips_file');
	
	$join = "";
	$wheres = xnpGetKeywordsQueries( array("$conference_table.conference_title", "$conference_table.author", "$conference_table.place", "$file_table.caption"), $keywords );
	return true;
}



function xnpconferenceGetAdvancedSearchQuery(&$where, &$join){
	global $xoopsDB;
	$basic_table = $xoopsDB->prefix('xoonips_item_basic');
	$conference_table = $xoopsDB->prefix('xnpconference_item_detail');
	$file_table  = $xoopsDB->prefix('xoonips_file');
	
	$wheres = array();
	$joins = array();

	$w  = xnpGetBasicInformationAdvancedSearchQuery('xnpconference'); if ( $w ) $wheres[] = $w;
	if ( !empty($_POST['xnpconference_presentation_type']) ){
		$myts =& MyTextSanitizer::getInstance();
		$wheres[] = $conference_table.'.presentation_type = \'' . $myts->addSlashes($_POST['xnpconference_presentation_type']) . "'";
	}
	$w = xnpGetKeywordQuery($conference_table.'.conference_title' , 'xnpconference_conference_title'  ); if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($conference_table.'.place'     , 'xnpconference_place'  ); if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($conference_table.'.author'    , 'xnpconference_author'  ); if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($conference_table.'.abstract'  , 'xnpconference_abstract' ); if ( $w ) $wheres[] = $w;
	$w = "";
	if (!empty($_POST['xnpconference_publication_date_from' ])) $w .= xnpGetFromQuery($conference_table.'.'.'conference_from', 'xnpconference_publication_date_from');
	if (!empty($_POST['xnpconference_publication_date_to'   ])) {
		if ($w != "") $w .= ' or ';
		$w .= xnpGetToQuery  ($conference_table.'.'.'conference_to', 'xnpconference_publication_date_to');
	}
	if ($w != "") $wheres[] = $w;
	$w = xnpGetKeywordQuery($file_table. '.caption'        ,'xnpconference_caption');
	if ( $w ){
		$wheres[] = $w;
		$wheres[] = " $file_table.file_type_id = 1";
	}

	$where = implode( ' and ', $wheres );
	$join = ''; 
}

function xnpconferenceGetAdvancedSearchBlock(&$search_var){
	// get BasicInformation / Preview / IndexKeywords block
	$basic   = xnpGetBasicInformationAdvancedSearchBlock('xnpconference',$search_var);
	$search_var[] = 'xnpconference_presentation_type';
	$search_var[] = 'xnpconference_conference_title';
	$search_var[] = 'xnpconference_place';
	$search_var[] = 'xnpconference_author';
	$search_var[] = 'xnpconference_abstract';
	
	// set to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // copy variables in $xoopsTpl to $tpl
	

	$tpl->assign( 'presentation_type', array_merge( array(''=>'Any'), xnpconferenceGetTypes()) );
	$tpl->assign( 'presentation_type_selected', 'none' );
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'module_name', 'xnpconference' );
	$tpl->assign( 'module_display_name', 'Conference' ); // todo:get from DB
	
	// return as HTML
	return $tpl->fetch( "db:xnpconference_search_block.html" );
}

function xnpconferenceGetDetailInformationTotalSize($iids){
	return xnpGetTotalFileSize($iids);
}


function xnpconferenceGetLicenseRequired( $item_id )
{
	global $xoopsDB;

	// get DetailInformation
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpconference_item_detail" )." where conference_id=$item_id" );
	if( !$result ) return NULL;
    $detail = $xoopsDB->fetchArray( $result );
    return isset( $detail['license'] ) && $detail['license'] != '';
}

function xnpconferenceGetLicenseStatement( $item_id )
{
	global $xoopsDB;

	// get DetailInformation
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpconference_item_detail" )." where conference_id=$item_id" );
	if( !$result ) return NULL;
    $detail = $xoopsDB->fetchArray( $result );
    return isset( $detail['license'] ) ? $detail['license'] : '';
}

function xnpconferenceExportItem($item_id, $attachment )
{
	global $xoopsDB;

	// get DetailInformation
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpconference_item_detail" )." where conference_id=$item_id" );
	if( !$result ) return NULL;
    $detail = $xoopsDB->fetchArray( $result );
/*
	return "<detail id=\"${item_id}\">\n"
        ."<presentation_type>".htmlspecialchars( $detail['presentation_type'], ENT_QUOTES )."</presentation_type>\n"
        ."<conference_title>".htmlspecialchars( $detail['conference_title'], ENT_QUOTES )."</conference_title>\n"
        ."<place>".htmlspecialchars( $detail['place'], ENT_QUOTES )."</place>\n"
        ."<author>".htmlspecialchars( $detail['author'], ENT_QUOTES )."</author>\n"
        ."<abstract>".htmlspecialchars( $detail['abstract'], ENT_QUOTES )."</abstract>\n"
        ."<readme>".htmlspecialchars( $detail['readme'], ENT_QUOTES )."</readme>\n"
        ."<license>".htmlspecialchars( $detail['license'], ENT_QUOTES )."</license>\n"
        ."<rights>".htmlspecialchars( $detail['rights'], ENT_QUOTES )."</rights>\n"
        .( $attachment ? xnpExportFile( $item_id ) : '' )
        ."</detail>\n";
*/
	return "<detail id=\"${item_id}\">\n"
        ."<conference_from_year>".xnpHtmlspecialchars( $detail['conference_from_year'], ENT_QUOTES )."</conference_from_year>\n"
        ."<conference_from_month>".xnpHtmlspecialchars( $detail['conference_from_month'], ENT_QUOTES )."</conference_from_month>\n"
        ."<conference_from_mday>".xnpHtmlspecialchars( $detail['conference_from_mday'], ENT_QUOTES )."</conference_from_mday>\n"
        ."<conference_to_year>".xnpHtmlspecialchars( $detail['conference_to_year'], ENT_QUOTES )."</conference_to_year>\n"
        ."<conference_to_month>".xnpHtmlspecialchars( $detail['conference_to_month'], ENT_QUOTES )."</conference_to_month>\n"
        ."<conference_to_mday>".xnpHtmlspecialchars( $detail['conference_to_mday'], ENT_QUOTES )."</conference_to_mday>\n"
        ."<presentation_type>".xnpHtmlspecialchars( $detail['presentation_type'], ENT_QUOTES )."</presentation_type>\n"
        ."<conference_title>".xnpHtmlspecialchars( $detail['conference_title'], ENT_QUOTES )."</conference_title>\n"
        ."<place>".xnpHtmlspecialchars( $detail['place'], ENT_QUOTES )."</place>\n"
        ."<author>".xnpHtmlspecialchars( $detail['author'], ENT_QUOTES )."</author>\n"
        ."<abstract>".xnpHtmlspecialchars( $detail['abstract'], ENT_QUOTES )."</abstract>\n"
        .( $attachment ? xnpExportFile( $item_id ) : '' )
        ."</detail>\n";
}

function xnpconferenceStartElement($parser, $name, $attribs, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
        $parser_hash['detail'] = array();
        break;
    case "/ITEM/DETAIL/PRESENTATION_TYPE":
    case "/ITEM/DETAIL/CONFERENCE_TITLE": 
    case "/ITEM/DETAIL/PLACE": 
    case "/ITEM/DETAIL/AUTHOR": 
    case "/ITEM/DETAIL/ABSTRACT":
/* 
    case "/ITEM/DETAIL/README": 
    case "/ITEM/DETAIL/LICENSE": 
    case "/ITEM/DETAIL/RIGHTS": 
*/
        $parser_hash['detail'][end($parser_hash['tagstack'])] = '';
        break;
    }
//    echo("<b><font color=\"#0000ff\">&lt$name&gt</font></b><br>"); 
}
function xnpconferenceEndElement($parser, $name, &$parser_hash)
{
	global $xoopsDB;
    
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    $myts =& MyTextSanitizer::getInstance( );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
//        print_r( $parser_hash['detail'] );
//        $keys = implode( ",", array( 'presentation_type', 'conference_title', 'place', 'author', 'abstract', 'readme', 'license', 'rights' ) );
        $keys = implode( ",", array( 'presentation_type', 'conference_title', 'place', 'author', 'abstract', 'conference_from_year', 'conference_from_month', 'conference_from_mday', 'conference_to_year', 'conference_to_month', 'conference_to_mday' ) );
/*
        $vals = implode( "','", array( $myts->addSlashes( $parser_hash['detail']['PRESENTATION_TYPE'] ),
                                       $myts->addSlashes( $parser_hash['detail']['CONFERENCE_TITLE' ] ),
                                       $myts->addSlashes( $parser_hash['detail']['PLACE'            ] ),
                                       $myts->addSlashes( $parser_hash['detail']['AUTHOR'           ] ),
                                       $myts->addSlashes( $parser_hash['detail']['ABSTRACT'         ] ),
                                       addslashes( $parser_hash['detail']['README'] ),
                                       addslashes( $parser_hash['detail']['LICENSE'] ),
                                       addslashes( $parser_hash['detail']['RIGHTS'] )
            ) );
*/
        $vals = implode( "','", array( $myts->addSlashes( encodeClient2Server( $parser_hash['detail']['PRESENTATION_TYPE'] ) ),
                                       $myts->addSlashes( encodeClient2Server( $parser_hash['detail']['CONFERENCE_TITLE' ] ) ),
                                       $myts->addSlashes( encodeClient2Server( $parser_hash['detail']['PLACE'            ] ) ),
                                       $myts->addSlashes( encodeClient2Server( $parser_hash['detail']['AUTHOR'           ] ) ),
                                       $myts->addSlashes( encodeClient2Server( $parser_hash['detail']['ABSTRACT'         ] ) ),
                                       $myts->addSlashes( $parser_hash['detail']['CONFERENCE_FROM_YEAR'         ] ),
                                       $myts->addSlashes( $parser_hash['detail']['CONFERENCE_FROM_MONTH'         ] ),
                                       $myts->addSlashes( $parser_hash['detail']['CONFERENCE_FROM_MDAY'         ] ),
                                       $myts->addSlashes( $parser_hash['detail']['CONFERENCE_TO_YEAR'         ] ),
                                       $myts->addSlashes( $parser_hash['detail']['CONFERENCE_TO_MONTH'         ] ),
                                       $myts->addSlashes( $parser_hash['detail']['CONFERENCE_TO_MDAY'         ] )
            ) );
        
        // register DetailInformation
        $myts =& MyTextSanitizer::getInstance( );
        $sql = "insert into ".$xoopsDB->prefix( "xnpconference_item_detail" )." ( conference_id, $keys ) values ( ".$parser_hash['id_table'][$parser_hash['basic']['ID']].", '$vals' ) ";
        $result = $xoopsDB->queryF( $sql );
        if( $result == false ) {
            echo "cannot insert item_detail\n";
            return false;
        }
        break;
    }
//    echo("<br><b><font color=\"#0000ff\">&lt/$name&gt</font></b><br><br>"); 
}

function xnpconferenceCharacterData($parser, $data, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case "/ITEM/DETAIL/PRESENTATION_TYPE":
    case "/ITEM/DETAIL/CONFERENCE_TITLE": 
    case "/ITEM/DETAIL/PLACE": 
    case "/ITEM/DETAIL/AUTHOR": 
    case "/ITEM/DETAIL/ABSTRACT": 
/*
    case "/ITEM/DETAIL/README": 
    case "/ITEM/DETAIL/LICENSE": 
    case "/ITEM/DETAIL/RIGHTS": 
*/
        if( !array_key_exists( end($parser_hash['tagstack']), $parser_hash['detail'] ) ){
            $parser_hash['detail'][end($parser_hash['tagstack'])] = $data;
        }else{
            $parser_hash['detail'][end($parser_hash['tagstack'])] .= $data;
        }
        break; 
    } 
//    echo($data); 
}

function xnpconferenceGetImportHandler( )
{
    return array( '/ITEM/DETAIL' => array( "xnpconferenceStartElement", "xnpconferenceEndElement", "xnpconferenceCharacterData" ) );
}

function xnpconferenceGetModifiedFields( $item_id )
{
    $ret = array();
    $basic = xnpGetBasicInformationArray($item_id);
    if( $basic ){
        if( mktime(0,0,0,$basic['publication_month'],$basic['publication_mday'],$basic['publication_year'] )
            != mktime(0,0,0,$_POST['publicationDateMonth'],$_POST['publicationDateDay'],$_POST['publicationDateYear']) )
            array_push( $ret, _MD_XNPCONFERENCE_DATE_LABEL );
    }
    $detail = xnpconferenceGetDetailInformation( $item_id );
    if( $detail ){
        $myts =& MyTextSanitizer::getInstance( );
        foreach( array( 'presentation_type' => _MD_XNPCONFERENCE_PRESENTATION_TYPE_LABEL,
                        'conference_title'  => _MD_XNPCONFERENCE_CONFERENCE_TITLE_LABEL,
                        'place'             => _MD_XNPCONFERENCE_PLACE_LABEL,
                        'author'            => _MD_XNPCONFERENCE_AUTHOR_LABEL,
                        'abstract'          => _MD_XNPCONFERENCE_ABSTRACT_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) array_push( $ret, $v );
        }
/*
        foreach( array( 'readme' => _MD_XOONIPS_ITEM_README_LABEL,
                        'license'=> _MD_XOONIPS_ITEM_LICENSE_LABEL,
                        'rights' => _MD_XOONIPS_ITEM_RIGHTS_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( "${k}EncText", $_POST ) ) continue;
            if( urldecode($_POST[ "${k}EncText" ]) != $detail[ $k ] ) array_push( $ret, $v );
        }
*/
        
        // was data file modified?
        if( xnpIsAttachmentModified( 'presentation_file', $item_id ) ){
            array_push( $ret, _MD_XNPCONFERENCE_PRESENTATION_FILE_LABEL );
        }
        if( xnpIsAttachmentModified( 'conference_paper', $item_id ) ){
            array_push( $ret, _MD_XNPCONFERENCE_CONFERENCE_PAPER_LABEL );
        }
    }
    return $ret;
}

function xnpconferenceGetTopBlock( $itemtype ){
	return xnpGetTopBlock( $itemtype['name'], $itemtype['display_name'], 'images/icon_conference.gif', _MD_XNPCONFERENCE_EXPLANATION, 'xnpconference_presentation_type', xnpconferenceGetTypes() );
}

//return 1 if downloadable for login user only
//return 0 if downloadable for everyone
/*
function xnpconferenceGetAttachmentDownloadLimitOption( $item_id )
{
	global $xoopsDB;
    $sql = "select attachment_dl_limit from ".$xoopsDB->prefix( "xnpconference_item_detail" )." where conference_id=${item_id}";
    $result = $xoopsDB->query( $sql );
    if( $result ){
        list( $option ) = $xoopsDB->fetchRow( $result );
        return $option;
    }
    return 0;
}
*/

function xnpconferenceSupportMetadataFormat( $metadataPrefix, $item_id )
{
    if( $metadataPrefix == 'oai_dc' || $metadataPrefix == 'junii' ) return true;
    return false;
}

function xnpconferenceGetMetadata( $metadataPrefix, $item_id )
{
    $meta_basic = xnpGetBasicInformationMetadata( $metadataPrefix, $item_id );
    if( $meta_basic ){
		$basic = array();
		if( xnp_get_item( $_SESSION['XNPSID'], $item_id, $basic ) != RES_OK )
			return false;
		
        $detail = xnpconferenceGetDetailInformation( $item_id );
		$lines = array();
		if( $metadataPrefix == 'junii' ){
            $lines[] = "<metadata>";
            $lines[] = '<meta xmlns="http://metasv.nii.ac.jp/oai/"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:schemaLocation="http://metasv.nii.ac.jp/oai http://metasv.nii.ac.jp/oai/junii.xsd">';
            $lines[] = $meta_basic;

//            $lines[] = "<type xsi:type=\"NII\">&#65279;&#30740;&#31350;&#36039;&#28304;&#8722;&#35542;&#25991;&#20197;&#22806;</type>";
            $lines[] = "<type xsi:type=\"NII\">".xnpGetMetadataJunii(2)."</type>";
            $lines[] = "<type>presentationType:".xnpHtmlspecialchars($detail['presentation_type'])."</type>";
            foreach( explode( "\n", $detail['author'] ) as $author )
                $lines[] = "<creator>".xnpHtmlspecialchars($author)."</creator>";
//            $lines[] = "<title>".htmlspecialchars($detail['conference_title'])."</title>";
            $lines[] = "<description>place:".xnpHtmlspecialchars($detail['place'])."</description>";
            $lines[] = "<date xsi:type=\"ISO8601\">"
                .date( "Y-m-d", mktime( 0, 0, 0,
                                        $basic['publication_month'],
                                        $basic['publication_mday'],
                                        $basic['publication_year'] ) )
                ."</date>";
            $lines[] = "<description>abstract:".xnpHtmlspecialchars($detail['abstract'])."</description>";
/*
            $lines[] = "<description>readme:".htmlspecialchars($detail['readme'])."</description>";
            $lines[] = "<description>rights:".htmlspecialchars($detail['rights'])."</description>";
            $lines[] = "<description>license:".htmlspecialchars($detail['license'])."</description>";
*/
            $lines[] = "</meta>";
            $lines[] = "</metadata>";
        }
		else if ( $metadataPrefix == 'oai_dc' ) {
			$lines = array();
			$lines[] = "<metadata>";
			$lines[] = '<oai_dc:dc 
               xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/" 
               xmlns:dc="http://purl.org/dc/elements/1.1/" 
               xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
               xsi:schemaLocation="http://www.openarchives.org/OAI/2.0/oai_dc/ 
               http://www.openarchives.org/OAI/2.0/oai_dc.xsd">';
			$lines[] = $meta_basic;
			$lines[] = "<dc:type>presentationType:".xnpHtmlspecialchars($detail['presentation_type'])."</dc:type>";
                        foreach( explode( "\n", $detail['author'] ) as $author )
                          $lines[] = "<dc:creator>".xnpHtmlspecialchars($author)."</dc:creator>";
			$lines[] = "<dc:title>".xnpHtmlspecialchars($detail['conference_title'])."</dc:title>";
			$lines[] = "<dc:description>place:".xnpHtmlspecialchars($detail['place'])."</dc:description>";
			$lines[] = "<dc:date>"
			    .date( "Y-m-d", mktime( 0, 0, 0,
			                            $basic['publication_month'],
			                            $basic['publication_mday'],
			                            $basic['publication_year'] ) )
			    ."</dc:date>";
			$lines[] = "<dc:description>abstract:".xnpHtmlspecialchars($detail['abstract'])."</dc:description>";
/*
			$lines[] = "<dc:rights>".htmlspecialchars($detail['rights'])."</dc:rights>";
			$lines[] = "<dc:description>readme:".htmlspecialchars($detail['readme'])."</dc:description>";
			$lines[] = "<dc:description>license:".htmlspecialchars($detail['license'])."</dc:description>";
*/
			$lines[] = "</oai_dc:dc>";
			$lines[] = "</metadata>";
		}
		return implode( "\n", $lines )."\n";
    }
    return false;
}
?>
