<?php
//  $Revision: 1.37.2.3 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

global $xoopsConfig;
if ( file_exists( XOOPS_ROOT_PATH.'/modules/xnppaper/language/' . $xoopsConfig['language'] . '/main.php') ){
	include_once( XOOPS_ROOT_PATH.'/modules/xnppaper/language/' . $xoopsConfig['language'] . '/main.php' );
}
else {
	include_once( XOOPS_ROOT_PATH.'/modules/xnppaper/language/english/main.php' );
}

// converting \r to \n
// removing white spaces placed in head of or end of string
// removing empty lines
// removing new-line(\n) placed in the end of strings
function xnppaperTrimAuthorString( $author ){
	$author = str_replace("\r", "\n", $author);
	$ar = explode( "\n", $author );
	$ar2 = array();
	foreach ( $ar as  $val ){
		$val = trim($val);
		if ( $val != "" )
			$ar2[] = $val;
	}
	return implode( "\n", $ar2 );
}

/** retrieve Detail Information that specified by item_id
  * 
  */
function xnppaperGetDetailInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array(
			'author'              =>'',
			'journal'             =>'',
			'volume'              =>'',
			'number'              =>'',
			'page'                =>'',
			'abstract'            =>'',
			'pubmed_id'           =>''
		);
	
	$sql = "select * from " . $xoopsDB->prefix("xnppaper_item_detail") . " where paper_id=$item_id";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	return $xoopsDB->fetchArray($result);
}

function xnppaperGetMetaInformation( $item_id ){
	
	$ret = array();
	$basic = xnpGetBasicInformationArray($item_id);
	$detail = xnppaperGetDetailInformation( $item_id );
	if ( !empty( $basic ) ){
		$ret[_MD_XOONIPS_ITEM_TITLE_LABEL] = $basic['title'];
		$ret[_MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL] = $basic['contributor'];
		$ret[_MD_XOONIPS_ITEM_KEYWORDS_LABEL] = $basic['keywords'];
		$ret[_MD_XOONIPS_ITEM_DESCRIPTION_LABEL] = $basic['description'];
		$ret[_MD_XOONIPS_ITEM_DOI_LABEL] = $basic['doi'];
		$ret[_MD_XOONIPS_ITEM_CREATION_DATE_LABEL] = $basic['creation_date'];
		$ret[_MD_XOONIPS_ITEM_LAST_UPDATE_DATE_LABEL] = $basic['last_update_date'];
	}
	if ( !empty( $detail ) ){
		$ret[_MD_XNPPAPER_AUTHOR_LABEL             ] = $detail['author'    ];
		$ret[_MD_XNPPAPER_JOURNAL_LABEL            ] = $detail['journal'   ];
	}
	if ( !empty( $basic ) ){
		$ret[_MD_XNPPAPER_YEAR_OF_PUBLICATION_LABEL] = $basic['publication_year'];
	}
	if ( !empty( $detail ) ){
		$ret[_MD_XNPPAPER_VOLUME_LABEL             ] = $detail['volume'    ];
		$ret[_MD_XNPPAPER_NUMBER_LABEL             ] = $detail['number'    ];
		$ret[_MD_XNPPAPER_PAGE_LABEL               ] = $detail['page'      ];
		$ret[_MD_XNPPAPER_ABSTRACT_LABEL           ] = $detail['abstract'  ];
		$ret[_MD_XNPPAPER_PUBMED_ID_LABEL          ] = $detail['pubmed_id' ];
	}
	
	return $ret;
}

function xnppaperGetListBlock( $item_basic ){
	$item_id = $item_basic['item_id'];
	
	// retrieve detail information
	$item_detail = xnppaperGetDetailInformation( $item_id );
	$item_detail['author_str'] = str_replace( "\n", ", ", $item_detail['author']); // separated by comma
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to $tpl
	
	$tpl->assign( 'item_basic', $item_basic );
	$tpl->assign( 'item_detail', $item_detail );
	if( xnpIsPending( $item_basic['item_id'] ) ) $tpl->assign( 'pending', 'true' );
	
	// return HTML content
	return $tpl->fetch( "db:xnppaper_list_block.html" );
}

function xnppaperGetPrinterFriendlyListBlock( $item_basic ){
	return xnppaperGetListBlock( $item_basic );
}


function xnppaperGetDetailBlock( $item_id ){
	
	// retrieve detail information
	$detail = xnppaperGetDetailInformation( $item_id );
	$detail['author_str'] = str_replace( "\n", ", ", $detail['author']); // comma separated
	
	// retrieve blocks of BasicInformation / Preview / IndexKeywords
	$basic   = xnpGetBasicInformationDetailBlock( $item_id );
	$preview = xnpGetPreviewDetailBlock( $item_id );
	$index   = xnpGetIndexDetailBlock( $item_id );
	$paper_pdf_reprint = xnpGetAttachmentDetailBlock( $item_id, 'paper_pdf_reprint' );
	
	// retrieve publication_date
	$item = array();
	$result = xnp_get_item( $_SESSION['XNPSID'], $item_id, $item );
	$detail['publication_year'] = $item['publication_year'];
	
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to $tpl
	
	$tpl->assign( 'editable', xnp_get_item_permission( $_SESSION['XNPSID'], $item_id, OP_MODIFY ) );
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'paper_pdf_reprint', $paper_pdf_reprint );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'detail', $detail );
	
	// retrieve config of pdf and abstract
	$mhandler =& xoops_gethandler('module');
	$module = $mhandler->getByDirname( 'xnppaper' );
	$chandler = & xoops_gethandler('config');
	$assoc = $chandler->getConfigsByCat(false, $module->mid());
	$pdf_access_rights = $assoc['pdf_access_rights'];
	$abstract_access_rights = $assoc['abstract_access_rights'];
	
    // Make sure that this user access to item_id is permitted or not
	$access_rights = xnpGetAccessRights( $item_id );
	$tpl->assign( 'show_pdf',      ( $pdf_access_rights      <= $access_rights ) );
	$tpl->assign( 'show_abstract', ( $abstract_access_rights <= $access_rights ) );
	
	// return HTML
	return $tpl->fetch( "db:xnppaper_detail_block.html" );
}

// todo
function xnppaperGetPrinterFriendlyDetailBlock( $item_id )
{
	// retrieve detail information
	$detail = xnppaperGetDetailInformation( $item_id );
	$detail['author_str'] = str_replace( "\n", ", ", $detail['author']); // separated by comma
	
	// retrieve blocks of BasicInformation / Preview / IndexKeywords
	$basic   = xnpGetBasicInformationPrinterFriendlyBlock( $item_id );
	$preview = xnpGetPreviewPrinterFriendlyBlock( $item_id );
	$index   = xnpGetIndexPrinterFriendlyBlock( $item_id );
	$paper_pdf_reprint = xnpGetAttachmentPrinterFriendlyBlock( $item_id, 'paper_pdf_reprint' );
	
	// retrieve a publication_date
	$item = array();
	$result = xnp_get_item( $_SESSION['XNPSID'], $item_id, $item );
	$detail['publication_year'] = $item['publication_year'];
	
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to $tpl
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'paper_pdf_reprint', $paper_pdf_reprint );
	$tpl->assign( 'detail', $detail );
	
	// retrieve config of pdf and abstract
	$mhandler =& xoops_gethandler('module');
	$module = $mhandler->getByDirname( 'xnppaper' );
	$chandler = & xoops_gethandler('config');
	$assoc = $chandler->getConfigsByCat(false, $module->mid());
	$pdf_access_rights = $assoc['pdf_access_rights'];
	$abstract_access_rights = $assoc['abstract_access_rights'];
	
    // Make sure that this user access to item_id is permitted or not
	$access_rights = xnpGetAccessRights( $item_id );
	$tpl->assign( 'show_pdf',      ( $pdf_access_rights      <= $access_rights ) );
	$tpl->assign( 'show_abstract', ( $abstract_access_rights <= $access_rights ) );
	
	// return HTML
	return $tpl->fetch( "db:xnppaper_detail_block.html" );
}

function xnppaperGetRegisterBlock(){
	global $xoopsDB;
	$myts =& MyTextSanitizer::getInstance();
	
	// retrieve detail information
	if ( isset( $_POST['author'] ) ){
		$detail = array(
			'author'             =>$myts->stripSlashesGPC(xnpGetPostVarDef('author'             , '')),
			'journal'            =>$myts->stripSlashesGPC(xnpGetPostVarDef('journal'            , '')),
			'volume'             =>$myts->stripSlashesGPC(xnpGetPostVarDef('volume'             , '')),
			'number'             =>$myts->stripSlashesGPC(xnpGetPostVarDef('number'             , '')),
			'page'               =>$myts->stripSlashesGPC(xnpGetPostVarDef('page'               , '')),
			'abstract'           =>$myts->stripSlashesGPC(xnpGetPostVarDef('abstract'           , '')),
			'pubmed_id'          =>$myts->stripSlashesGPC(xnpGetPostVarDef('pubmed_id'          , '')),
			'publication_year'   =>$myts->stripSlashesGPC(xnpGetPostVarDef('publicationDateYear', ''))
		);
	}
	else 
		$detail = array();
	
	if ( !empty( $_POST['xnppaperCompleteFlag'] ) ){
		// complete using pubmed
		$xnpsid = $_SESSION['XNPSID'];
		$pubmed_id = $detail['pubmed_id'] = trim($detail['pubmed_id']);
		
		$paper = array();
		$result = xnp_pubmed_complete( $pubmed_id, $paper );
		foreach ( $paper as $key => $value ){
//			$detail[$key] = $value;
			$detail[$key] = encodeClient2Server($value);
		}
		
		// copy a completed title(of detail information) to title(of basic information)
		if ( get_magic_quotes_gpc() )
			$_POST['title'] = addslashes($detail['title']);
		else
			$_POST['title'] = $detail['title'];
		
		$detail['publication_year'] = $detail['year_of_publication'];
	}
	
	// retrieve blocks of BasicInformation / Preview / index block
	$basic = xnpGetBasicInformationRegisterBlock();
	$index = xnpGetIndexRegisterBlock();
	$paper_pdf_reprint = xnpGetAttachmentRegisterBlock( 'paper_pdf_reprint' );
	
	// assingn to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to $tpl
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'paper_pdf_reprint', $paper_pdf_reprint );
	$tpl->assign( 'detail', $detail );
	
	// return HTML
	return $tpl->fetch( "db:xnppaper_register_block.html" );
}

function xnppaperGetEditBlock( $item_id ){
	global $xoopsDB;

	// retrieve blocks of BasicInformation / Preview / index
	$basic   = xnpGetBasicInformationEditBlock( $item_id );
	$index = xnpGetIndexEditBlock( $item_id );
	$paper_pdf_reprint = xnpGetAttachmentEditBlock( $item_id, 'paper_pdf_reprint' );
	
	// retrieve DetailInformation
	if ( isset( $_POST['author'] ) ){
		$myts =& MyTextSanitizer::getInstance();
		$detail = array(
			'author'             =>$myts->stripSlashesGPC($_POST['author'             ]),
			'journal'            =>$myts->stripSlashesGPC($_POST['journal'            ]),
			'volume'             =>$myts->stripSlashesGPC($_POST['volume'             ]),
			'number'             =>$myts->stripSlashesGPC($_POST['number'             ]),
			'page'               =>$myts->stripSlashesGPC($_POST['page'               ]),
			'abstract'           =>$myts->stripSlashesGPC($_POST['abstract'           ]),
			'pubmed_id'          =>$myts->stripSlashesGPC($_POST['pubmed_id'          ]),
			'publication_year'   =>$myts->stripSlashesGPC($_POST['publicationDateYear'])
		);
	}
	else if ( !empty( $item_id ) ){
		$detail = xnppaperGetDetailInformation( $item_id );
		$item = array();
		$result = xnp_get_item( $_SESSION['XNPSID'], $item_id, $item );
		$detail['publication_year'] = $item['publication_year'];
	}
	else
		$detail = array();
	
	if ( !empty( $_POST['xnppaperCompleteFlag'] ) ){
		// complete using pubmed
		$xnpsid = $_SESSION['XNPSID'];
		$pubmed_id = $detail['pubmed_id'] = trim($detail['pubmed_id']);
		
		$paper = array();
		$result = xnp_pubmed_complete( $pubmed_id, $paper );
		foreach ( $paper as $key => $value ){
//			$detail[$key] = $value;
			$detail[$key] = encodeClient2Server($value);
		}
		
		// copy a completed title(of detail information) to title(of basic information)
		if ( get_magic_quotes_gpc() )
			$_POST['title'] = addslashes($detail['title']);
		else
			$_POST['title'] = $detail['title'];
		
		$detail['publication_year'] = $detail['year_of_publication'];
	}
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to $tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'paper_pdf_reprint', $paper_pdf_reprint );
	$tpl->assign( 'detail', $detail );

	
	// return HTML
	return $tpl->fetch( "db:xnppaper_register_block.html" );
}


function xnppaperGetConfirmBlock( $item_id ){
	// retrieve blocks of BasicInformation / Preview / index
	$basic   = xnpGetBasicInformationConfirmBlock( $item_id );
	$index   = xnpGetIndexConfirmBlock( $item_id );
	$paper_pdf_reprint = xnpGetAttachmentConfirmBlock( $item_id, 'paper_pdf_reprint' );
	
	// retrieve DetailInformation
	if ( isset( $_POST['author'] ) ){
		$_POST['author'] = xnppaperTrimAuthorString($_POST['author']);
		$myts =& MyTextSanitizer::getInstance();
		$detail = array(
			'author'             =>$myts->stripSlashesGPC( xnpHtmlspecialchars( $_POST['author'             ]) ),
			'journal'            =>$myts->stripSlashesGPC( xnpHtmlspecialchars( $_POST['journal'            ]) ),
			'volume'             =>$myts->stripSlashesGPC( xnpHtmlspecialchars( $_POST['volume'             ]) ),
			'number'             =>$myts->stripSlashesGPC( xnpHtmlspecialchars( $_POST['number'             ]) ),
			'page'               =>$myts->stripSlashesGPC( xnpHtmlspecialchars( $_POST['page'               ]) ),
			'abstract'           =>$myts->stripSlashesGPC( xnpHtmlspecialchars( $_POST['abstract'           ]) ),
			'pubmed_id'          =>$myts->stripSlashesGPC($_POST['pubmed_id'          ]),
			'publication_year'   =>$myts->stripSlashesGPC( xnpHtmlspecialchars( $_POST['publicationDateYear']) )
		);
		$detail['author_str'] = str_replace( "\n", ", ", $detail['author']); // separated by comma
	}
	else if ( !empty( $item_id ) )
		$detail = xnppaperGetDetailInformation( $item_id );
	else
		$detail = array();
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to $tpl
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'paper_pdf_reprint', $paper_pdf_reprint );
	$tpl->assign( 'detail', $detail );
	
	// return HTML
	return $tpl->fetch( "db:xnppaper_confirm_block.html" );
}

/** make sure that enterd detail information is correctly or not.
 * called from register confirmation and edit confirmation
 */
function xnppaperCheckRegisterParameters( &$message ){
	$messages = array();
	$_POST['author'] = xnppaperTrimAuthorString($_POST['author']);
	if ( empty( $_POST['author' ] ) )  $messages[] = "author required.";
	if ( empty( $_POST['journal'] ) )  $messages[] = "journal required.";
	if ( empty( $_POST['publicationDateYear'] ) )  $messages[] = "publication year required.";
	if ( count($messages) == 0 )
		return true;
	$message = implode( "", $messages );
	return false;
}

/** make sure that enterd detail information is correctly or not.
 */
function xnppaperCheckEditParameters( &$message ){
	return xnppaperCheckRegisterParameters( $message );
}

function xnppaperInsertItem(){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// register BasicInformation, Index, Attachment
	$item_id = 0;
	$result = xnpInsertBasicInformation( $item_id );
	if ( $result ){
		$result = xnpUpdateIndex( $item_id );
		if ( $result ){
			$result = xnpUpdateAttachment( $item_id, 'paper_pdf_reprint' );
			if ( $result ){
			}
		}
		if ( !$result )
			xnpDeleteBasicInformation( $xnpsid, $item_id );
	}
	if ( !$result )
		return false;
	
	$_POST['author'] = xnppaperTrimAuthorString($_POST['author']);
	$myts =& MyTextSanitizer::getInstance();
	$keys = implode( ",", array(
		'author'             ,
		'journal'            ,
		'volume'             ,
		'number'             ,
		'page'               ,
		'abstract'           ,
		'pubmed_id'          
	) );
	
	$vals = implode( ",", array(
		"'".$myts->addSlashes($_POST['author'   ])."'",
		"'".$myts->addSlashes($_POST['journal'  ])."'",
		strlen($_POST['volume'   ])==0 ? "null" : "'".$myts->addSlashes($_POST['volume'   ])."'",
		strlen($_POST['number'   ])==0 ? "null" : "'".$myts->addSlashes($_POST['number'   ])."'",
		strlen($_POST['page'     ])==0 ? "null" : "'".$myts->addSlashes($_POST['page'     ])."'",
		strlen($_POST['abstract' ])==0 ? "null" : "'".$myts->addSlashes($_POST['abstract' ])."'",
		strlen($_POST['pubmed_id'])==0 ? "null" : "'".$myts->addSlashes($_POST['pubmed_id'])."'"
	) );
	
	
	// register detail information
	$myts =& MyTextSanitizer::getInstance();
	$sql = "insert into " . $xoopsDB->prefix("xnppaper_item_detail") . " ( paper_id, $keys ) values ( $item_id, $vals ) ";
	$result = $xoopsDB->queryF( $sql );
	if ( $result == false ){
		echo "cannot insert item_detail";
		return false;
	}
	
	return true;
}

function xnppaperUpdateItem( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	$myts =& MyTextSanitizer::getInstance();
	
	// modify BasicInformation, Index, Preview, Attachment
	$result = xnpUpdateBasicInformation( $item_id );
	if ( $result ){
		$result = xnpUpdateIndex( $item_id );
		if ( $result ){
			$result = xnpUpdateAttachment( $item_id, 'paper_pdf_reprint' );
			if ( $result ){
				$result = xnp_insert_change_log( $xnpsid, $item_id, $myts->stripSlashesGPC( $_POST['change_log'] ) );
				$result = !$result;
				if( !$result )
					echo " xnp_insert_change_log failed.";
			}
			else echo " xnpUpdateAttachment failed.";
		}
		else echo " xnpUpdateIndex failed.";
	}
	else echo " xnpUpdateBasicInformation failed.";
	if ( !$result )
		return false;
	
	// register detail information
	$_POST['author'] = xnppaperTrimAuthorString($_POST['author']);
	$sql = implode( ',', array(
		'author'              ."='".$myts->addSlashes($_POST['author'              ])."'",
		'journal'             ."='".$myts->addSlashes($_POST['journal'             ])."'",
		'volume'              ."=".( strlen($_POST['volume'   ])==0 ? "null" : "'".$myts->addSlashes($_POST['volume'   ])."'" ),
		'number'              ."=".( strlen($_POST['number'   ])==0 ? "null" : "'".$myts->addSlashes($_POST['number'   ])."'" ),
		'page'                ."=".( strlen($_POST['page'     ])==0 ? "null" : "'".$myts->addSlashes($_POST['page'     ])."'" ),
		'abstract'            ."=".( strlen($_POST['abstract' ])==0 ? "null" : "'".$myts->addSlashes($_POST['abstract' ])."'" ),
		'pubmed_id'           ."=".( strlen($_POST['pubmed_id'])==0 ? "null" : "'".$myts->addSlashes($_POST['pubmed_id'])."'" )
	) );
	$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnppaper_item_detail") . " set $sql where paper_id = $item_id " );
	if ( $result == false )
		return false;
	
	return true;
}

function xnppaperDeleteItem( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// remove BasicInformation, Index, Preview, Attachment
	if( !xnpDeleteBasicInformation( $item_id ) ){
		echo "cannot delete model item";
		return false;
	}
	
	// remove Detail Information
	$sql = "delete from " . $xoopsDB->prefix("xnppaper_item_detail")
		. " where paper_id=$item_id";
	$xoopsDB->queryF( $sql );
	return true;
}



function xnppaperGetDetailInformationQuickSearchQuery(&$wheres, &$join, $keywords){
	global $xoopsDB;
	$paper_table = $xoopsDB->prefix('xnppaper_item_detail');
	$file_table  = $xoopsDB->prefix('xoonips_file');
	
	$join = "";
	$wheres = xnpGetKeywordsQueries( array("$paper_table.author", "$paper_table.journal", "$paper_table.pubmed_id"), $keywords );
	return true;
}



function xnppaperGetAdvancedSearchQuery(&$where, &$join){
	global $xoopsDB;
	$paper_table = $xoopsDB->prefix('xnppaper_item_detail');
	$file_table  = $xoopsDB->prefix('xoonips_file');
	
	$wheres = array();
	$w = xnpGetBasicInformationAdvancedSearchQuery('xnppaper');                  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($paper_table.'.author'      ,'xnppaper_author'   );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($paper_table.'.journal'     ,'xnppaper_journal'  );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($paper_table.'.volume'      ,'xnppaper_volume'   );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($paper_table.'.number'      ,'xnppaper_number'   );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($paper_table.'.page'        ,'xnppaper_page'     );  if ( $w ) $wheres[] = $w;
//	$w = xnpGetKeywordQuery($paper_table.'.abstract'    ,'xnppaper_abstract' );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($paper_table.'.pubmed_id'   ,'xnppaper_pubmed_id');  if ( $w ) $wheres[] = $w;
	
/*	if ( !empty($_POST['xnppaper_paper_pdf_reprint' ]) ){
		$wheres[] = xnpGetKeywordQuery($file_table. '.original_file_name' ,'xnppaper_paper_pdf_reprint');
		
		$file_type_table = $xoopsDB->prefix('xoonips_file_type');
		$result = $xoopsDB->query( "select file_type_id from $file_type_table where name='paper_pdf_reprint'" );
		list($file_type_id) = $xoopsDB->fetchRow($result);
		$wheres[] = " $file_table.file_type_id = $file_type_id";
	}
*/
	$where = implode( ' and ', $wheres );
	$join = "";
}

function xnppaperGetAdvancedSearchBlock(&$search_var){
	// retrieve blocs of BasicInformation / Preview / IndexKeywords 
	$basic   = xnpGetBasicInformationAdvancedSearchBlock('xnppaper',$search_var);
	$search_var[] = 'xnppaper_author'   ;
	$search_var[] = 'xnppaper_journal'  ;
	$search_var[] = 'xnppaper_volume'   ;
	$search_var[] = 'xnppaper_number'   ;
	$search_var[] = 'xnppaper_page'     ;
//	$search_var[] = 'xnppaper_abstract' ;
	$search_var[] = 'xnppaper_pubmed_id';
//	$search_var[] = 'xnppaper_paper_pdf_reprint';
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to $tpl
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'module_name', 'xnppaper' );
	$tpl->assign( 'module_display_name', 'Paper' ); // todo: retrieve from db
	
	// return HTML
	return $tpl->fetch( "db:xnppaper_search_block.html" );
}

function xnppaperGetDetailInformationTotalSize($iids){
	return xnpGetTotalFileSize($iids);
}

/**
 * 
 * generate XML of detail information for exporting.
 * 
 * @param fhdl file handle to write results
 * @param item_id item id that is exported
 * @param attachment true if exporting with attachments and images
 * @return true:succeed, false:failed
 */
function xnppaperExportItem($fhdl, $item_id, $attachment )
{
    if( !$fhdl ) return false;

    $detail = xnppaperGetDetailInformation( $item_id );
	if( !fwrite( $fhdl, "<detail id=\"${item_id}\">\n"
        ."<author>".xnpHtmlspecialchars( $detail['author'], ENT_QUOTES )."</author>\n"
        ."<journal>".xnpHtmlspecialchars( $detail['journal'], ENT_QUOTES )."</journal>\n"
        ."<volume>".xnpHtmlspecialchars( $detail['volume'], ENT_QUOTES )."</volume>\n"
        ."<number>".xnpHtmlspecialchars( $detail['number'], ENT_QUOTES )."</number>\n"
        ."<page>".xnpHtmlspecialchars( $detail['page'], ENT_QUOTES )."</page>\n"
        ."<abstract>".xnpHtmlspecialchars( $detail['abstract'], ENT_QUOTES )."</abstract>\n"
        ."<pubmed_id>".xnpHtmlspecialchars( $detail['pubmed_id'], ENT_QUOTES )."</pubmed_id>\n" ) ) return false;
    if( !( $attachment ? xnpExportFile( $fhdl, $item_id ) : true ) ) return false;
    if( !fwrite( $fhdl, "</detail>\n" ) ) return false;

    return true;
}

function xnppaperStartElement($parser, $name, $attribs, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
        $parser_hash['detail'] = array();
        break;
    }
    //echo("<b><font color=\"#0000ff\">&lt$name&gt</font></b><br>"); 
}
function xnppaperEndElement($parser, $name, &$parser_hash)
{
    global $xoopsDB;
    
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
        $myts =& MyTextSanitizer::getInstance();
        $keys = implode( ",", array(
            'paper_id'           , 
            'author'             ,
            'journal'            ,
            'volume'             ,
            'number'             ,
            'page'               ,
            'abstract'           ,
            'pubmed_id'          
            ) );

        $vals = implode( ",", array(
            $parser_hash['id_table'][encodeClient2Server( $parser_hash['basic']['ID'] )],
            "'".$myts->addSlashes( encodeClient2Server( $parser_hash['detail']['AUTHOR'              ]) )."'",
            "'".$myts->addSlashes( encodeClient2Server( $parser_hash['detail']['JOURNAL'             ]) )."'",
            strlen($parser_hash['detail']['VOLUME'   ])==0 ? "null" : "'".$myts->addSlashes( encodeClient2Server( $parser_hash['detail']['VOLUME'   ]) )."'",
            strlen($parser_hash['detail']['NUMBER'   ])==0
            || preg_match( "/^[0-9]+$/", $parser_hash['detail']['NUMBER'] ) == 0 ? "null" : "'".$myts->addSlashes( encodeClient2Server( $parser_hash['detail']['NUMBER'   ]) )."'",
            strlen($parser_hash['detail']['PAGE'     ])==0 ? "null" : "'".$myts->addSlashes( encodeClient2Server( $parser_hash['detail']['PAGE'     ]) )."'",
            strlen($parser_hash['detail']['ABSTRACT' ])==0 ? "null" : "'".$myts->addSlashes( encodeClient2Server( $parser_hash['detail']['ABSTRACT' ]) )."'",
            strlen($parser_hash['detail']['PUBMED_ID'])==0 ? "null" : "'".$myts->addSlashes( encodeClient2Server( $parser_hash['detail']['PUBMED_ID']) )."'"
            ) );

        // register detail information
        $sql = "insert into " . $xoopsDB->prefix("xnppaper_item_detail") . " ( $keys ) values ( $vals ) ";
        $result = $xoopsDB->queryF( $sql );
        if ( $result == false ){
            //echo "cannot insert item_detai ". $xoopsDB -> error();
            break;
        }
        break;
    }
    //echo("<br><b><font color=\"#0000ff\">&lt/$name&gt</font></b><br><br>"); 
}

function xnppaperCharacterData($parser, $data, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case "/ITEM/DETAIL/AUTHOR":
    case "/ITEM/DETAIL/JOURNAL": 
    case "/ITEM/DETAIL/VOLUME": 
    case "/ITEM/DETAIL/NUMBER": 
    case "/ITEM/DETAIL/PAGE": 
    case "/ITEM/DETAIL/ABSTRACT": 
    case "/ITEM/DETAIL/PUBMED_ID": 
        if( !array_key_exists( end($parser_hash['tagstack']), $parser_hash['detail'] ) ){
            $parser_hash['detail'][end($parser_hash['tagstack'])] = $data;
        }else{
            $parser_hash['detail'][end($parser_hash['tagstack'])] .= $data;
        }
        break; 
    } 
//    echo($data); 
}

function xnppaperGetImportHandler( )
{
    return array( '/ITEM/DETAIL' => array( "xnppaperStartElement", "xnppaperEndElement", "xnppaperCharacterData" ) );
}

/**
 * bool xnppaperGetLicenseRequired( int item_id )
 * 
 * 
 */
/*
function xnppaperGetLicenseRequired( $item_id )
{
    return false;
}
*/

/**
 * string xnppaperGetLicenseStatement( int item_id )
 * 
 * 
 */
/*
function xnppaperGetLicenseStatement( $item_id )
{
    return ''
}
*/

function xnppaperGetModifiedFields( $item_id )
{
    $ret = array();
    $basic = xnpGetBasicInformationArray($item_id);
    if( $basic ){
        if( mktime(0,0,0,$basic['publication_month'],$basic['publication_mday'],$basic['publication_year'] )
            != mktime(0,0,0,$_POST['publicationDateMonth'],$_POST['publicationDateDay'],$_POST['publicationDateYear']) )
            array_push( $ret, _MD_XNPPAPER_YEAR_OF_PUBLICATION_LABEL );
    }
    $detail = xnppaperGetDetailInformation( $item_id );
    if( $detail ){
        $myts =& MyTextSanitizer::getInstance( );
        foreach( array( 'author'   =>_MD_XNPPAPER_AUTHOR_LABEL,
                        'journal'  =>_MD_XNPPAPER_JOURNAL_LABEL,
                        'volume'   =>_MD_XNPPAPER_VOLUME_LABEL,
                        'number'   =>_MD_XNPPAPER_NUMBER_LABEL,
                        'page'     =>_MD_XNPPAPER_PAGE_LABEL,
                        'abstract' =>_MD_XNPPAPER_ABSTRACT_LABEL,
                        'pubmed_id'=>_MD_XNPPAPER_PUBMED_ID_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) array_push( $ret, $v );
        }
        
        // is modified pdf files?
        if( xnpIsAttachmentModified( 'paper_pdf_reprint', $item_id ) ){
            array_push( $ret, _MD_XNPPAPER_PDF_REPRINT_LABEL );
        }
    }
    return $ret;
}

function xnppaperGetTopBlock( $itemtype ){
	return xnpGetTopBlock( $itemtype['name'], $itemtype['display_name'], 'images/icon_paper.gif', _MD_XNPPAPER_EXPLANATION, false, false );
}

function xnppaperSupportMetadataFormat( $metadataPrefix, $item_id )
{
    if( $metadataPrefix == 'oai_dc' || $metadataPrefix == 'junii' ) return true;
    return false;
}

function xnppaperGetMetadata( $metadataPrefix, $item_id )
{
    $meta_basic = xnpGetBasicInformationMetadata( $metadataPrefix, $item_id );
    if( $meta_basic ){
		$basic = array();
		if( xnp_get_item( $_SESSION['XNPSID'], $item_id, $basic ) != RES_OK )
			return false;
		
        $detail = xnppaperGetDetailInformation( $item_id );
		$lines = array();
		if( $metadataPrefix == 'junii' ){
            $lines[] = "<metadata>";
            $lines[] = '<meta xmlns="http://metasv.nii.ac.jp/oai/"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:schemaLocation="http://metasv.nii.ac.jp/oai http://metasv.nii.ac.jp/oai/junii.xsd">';
            $lines[] = $meta_basic;
            $lines[] = "<type xsi:type=\"NII\">".xnpGetMetadataJunii(1)."</type>";
            foreach( explode( "\n", $detail['author'] ) as $author )
                $lines[] = "<creator>".xnpHtmlspecialchars($author)."</creator>";
            $lines[] = "<identifier>bibliographicCitation:".xnpHtmlspecialchars(
                sprintf( "%s %s(%s), %s. (%s)",
                         $detail['journal'], 
                         $detail['volume'], 
                         $detail['number'], 
                         $detail['page'], 
                         $basic['publication_year'] ) )."</identifier>";
//            $lines[] = "<date xsi:type=\"ISO8601\">".htmlspecialchars($basic['publication_year'])."</date>";
            $lines[] = "<date xsi:type=\"ISO8601\">".xnpHtmlspecialchars($basic['publication_year'])."</date>";
            if( isset( $detail['pubmed_id'] ) && $detail['pubmed_id'] != '' )
//                $lines[] = "<identifier>PMID:".htmlspecialchars($detail['pubmed_id'])."</identifier>";
                $lines[] = "<identifier>PMID:".xnpHtmlspecialchars($detail['pubmed_id'])."</identifier>";
            $lines[] = "</meta>";
            $lines[] = "</metadata>";
        }
		else if ( $metadataPrefix == 'oai_dc' ) {
			$lines = array();
			$lines[] = "<metadata>";
			$lines[] = '<oai_dc:dc 
               xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/" 
               xmlns:dc="http://purl.org/dc/elements/1.1/" 
               xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
               xsi:schemaLocation="http://www.openarchives.org/OAI/2.0/oai_dc/ 
               http://www.openarchives.org/OAI/2.0/oai_dc.xsd">';
			$lines[] = $meta_basic;
			foreach( explode( "\n", $detail['author'] ) as $author )
//				$lines[] = "<dc:creator>".htmlspecialchars($author)."</dc:creator>";
				$lines[] = "<dc:creator>".xnpHtmlspecialchars($author)."</dc:creator>";
//			$lines[] = "<dc:identifier>bibliographicCitation:".htmlspecialchars(
			$lines[] = "<dc:identifier>bibliographicCitation:".xnpHtmlspecialchars(
				sprintf( "%s %s(%s), %s. (%s)",
			             $detail['journal'], 
			             $detail['volume'], 
			             $detail['number'], 
			             $detail['page'], 
			             $basic['publication_year'] ) )."</dc:identifier>";
//			$lines[] = "<dc:date>".htmlspecialchars($basic['publication_year'])."</dc:date>";
			$lines[] = "<dc:date>".xnpHtmlspecialchars($basic['publication_year'])."</dc:date>";
			if( isset( $detail['pubmed_id'] ) && $detail['pubmed_id'] != '' )
//				$lines[] = "<dc:identifier>PMID:".htmlspecialchars($detail['pubmed_id'])."</dc:identifier>";
				$lines[] = "<dc:identifier>PMID:".xnpHtmlspecialchars($detail['pubmed_id'])."</dc:identifier>";
			$lines[] = "</oai_dc:dc>";
			$lines[] = "</metadata>";
		}
		return implode( "\n", $lines );
    }
    return false;
}
?>
