<?php
//  $Revision: 1.26.2.2 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

global $xoopsConfig;
if ( file_exists( XOOPS_ROOT_PATH.'/modules/xnpurl/language/' . $xoopsConfig['language'] . '/main.php') ){
	include_once( XOOPS_ROOT_PATH.'/modules/xnpurl/language/' . $xoopsConfig['language'] . '/main.php' );
}
else {
	include_once( XOOPS_ROOT_PATH.'/modules/xnpurl/language/english/main.php' );
}

/** retrieve Detail Information that specified by item_id
  * 
  */
function xnpurlGetDetailInformation( $item_id ){
	global $xoopsDB;
	if ( empty( $item_id ) )
		return array(
			'url'    =>''
		);
	
	$sql = "select * from " . $xoopsDB->prefix("xnpurl_item_detail") . " where url_id=$item_id";
	$result = $xoopsDB->query( $sql );
	if ( $result == FALSE ){
		echo " $sql " . mysql_error();
		return false;
	}
	return $xoopsDB->fetchArray($result);
}

function xnpurlGetMetaInformation( $item_id ){
	$metainfo = xnpurlGetDetailInformation( $item_id );
	if ( $metainfo == false )
		return array();
	return $metainfo;
}

function xnpurlGetListBlock( $item_basic ){
	$item_id = $item_basic['item_id'];
	
	// retrieve detail information
	$item_detail = xnpurlGetDetailInformation( $item_id );
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to tpl
	
	$tpl->assign( 'item_basic', $item_basic );
	$tpl->assign( 'item_detail', $item_detail );
	if( xnpIsPending( $item_basic['item_id'] ) ) $tpl->assign( 'pending', 'true' );
	
	// return HTML content
	//return $tpl->fetch( XOOPS_ROOT_PATH . "/modules/xnpurl/templates/xnpurl_list_block.html" );
	return $tpl->fetch( "db:xnpurl_list_block.html" );
}

function xnpurlGetPrinterFriendlyListBlock( $item_basic ){
	return xnpurlGetListBlock( $item_basic );
}

function xnpurlGetUrlBannerFileDetailBlock( $item_id, $url ){
	
	// retrieve file information that specified by item_id
	$files = xnpGetFileInfo( "t_file.file_id, t_file.caption", "t_file_type.name='url_banner_file' and sid is NULL ", $item_id );
	// generate html
	if ( count($files) != 0 ){
		reset( $files );
		list( $dummy, list( $fileID, $caption) ) = each( $files );
		$imageFileName = XOOPS_URL . "/modules/xoonips/image.php?file_id=$fileID";
		$html= "<a href='$url'><img src='$imageFileName' ></a>";
		$hidden = xnpCreateHidden('url_banner_fileFileID',$fileID);
	}
	else {
		$html = "";
		$hidden = "";
	}
	
	return array( 'name'=>'Banner', 'value'=> $html, 'hidden'=>$hidden );
}

function xnpurlGetDetailBlock( $item_id ){
	
	// retrieve detail information
	$item_detail = xnpurlGetDetailInformation( $item_id );
	
	// retrieve blocks of BasicInformation / Preview / IndexKeywords
	$basic   = xnpGetBasicInformationDetailBlock( $item_id );
	$preview = xnpGetPreviewDetailBlock( $item_id );
	$index   = xnpGetIndexDetailBlock( $item_id );
	$url_banner_file = xnpurlGetUrlBannerFileDetailBlock( $item_id, $item_detail['url'] );
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to tpl
	
	$tpl->assign( 'editable', xnp_get_item_permission( $_SESSION['XNPSID'], $item_id, OP_MODIFY ) );
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'url_banner_file', $url_banner_file );
	$tpl->assign( 'detail', $item_detail );
	
	
	// return HTML content
	return $tpl->fetch( "db:xnpurl_detail_block.html" );
}

function xnpurlGetPrinterFriendlyDetailBlock( $item_id )
{
	// retrieve detail information
	$item_detail = xnpurlGetDetailInformation( $item_id );
	
	// retrieve blocks of BasicInformation / Preview / IndexKeywords
	$basic   = xnpGetBasicInformationPrinterFriendlyBlock( $item_id );
	$preview = xnpGetPreviewPrinterFriendlyBlock( $item_id );
	$index   = xnpGetIndexPrinterFriendlyBlock( $item_id );
	$url_banner_file = xnpurlGetUrlBannerFileDetailBlock( $item_id, $item_detail['url'] );
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to tpl
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'url_banner_file', $url_banner_file );
	$tpl->assign( 'detail', $item_detail );
	
	
	// return HTML content
	return $tpl->fetch( "db:xnpurl_detail_block.html" );
}

function xnpurlGetRegisterBlock(){
	global $xoopsDB;
	$myts =& MyTextSanitizer::getInstance();
	
	// retrieve detail information
	if ( isset( $_POST['url'] ) ){
		$detail = array(
			'url'     =>$myts->stripSlashesGPC($_POST['url'])
		);
	}
	else if ( !empty( $item_id ) ){
		$detail = xnpurlGetDetailInformation( $item_id );
	}
	else
		$detail = array();
	
	// retrieve blocks of BasicInformation / Preview / index block
	$basic = xnpGetBasicInformationRegisterBlock();
	$preview = xnpGetPreviewRegisterBlock();
	$index = xnpGetIndexRegisterBlock();
	$url_banner_file = xnpGetAttachmentRegisterBlock( 'url_banner_file' );
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to tpl
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'url_banner_file', $url_banner_file );
	$tpl->assign( 'detail', $detail );
	// return HTML content
	return $tpl->fetch( "db:xnpurl_register_block.html" );
}

function xnpurlGetEditBlock( $item_id ){
	global $xoopsDB;

	// retrieve blocks of BasicInformation / Preview / index block
	$basic   = xnpGetBasicInformationEditBlock( $item_id );
	$preview = xnpGetPreviewEditBlock( $item_id );
	$index = xnpGetIndexEditBlock( $item_id );
	$url_banner_file = xnpGetAttachmentEditBlock( $item_id, 'url_banner_file' );
	
	// retrieve detail information
	if ( isset( $_POST['url'] ) ){
		$myts =& MyTextSanitizer::getInstance();
		$detail = array(
			'url'     =>$myts->stripSlashesGPC($_POST['url'])
		);
	}
	else if ( !empty( $item_id ) ){
		$detail = xnpurlGetDetailInformation( $item_id );
	}
	else
		$detail = array();
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to tpl

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'url_banner_file', $url_banner_file );
	$tpl->assign( 'detail', $detail );

	
	// return HTML content
	return $tpl->fetch( "db:xnpurl_register_block.html" );
}

// see also xnpGetAttachmentConfirmBlock
function xnpurlGetUrlBannerFileConfirmBlock( $item_id ){
	$name = 'url_banner_file';
	if ( !empty( $_FILES[$name]['name'] ) ){
		// file has been Uploaded
		list($fileID,$errorMessage) = xnpUploadFile( $name, false );
		if ( $fileID == false ){
			$errorHTML = "<font color='#ff0000'>" . htmlspecialchars($errorMessage) . "</font><br>";
			return array( 'name'=>'Attachment', 'value'=> $errorHTML );
		}
		else
			$sql = "t_file.file_id = $fileID";
	}
	else {
		$attachmentFileID = (int)$_POST[$name.'FileID'];
		if ( $attachmentFileID == 0 ){ // no files should be attached
			$sql = " 0 ";
		}
		else {
			$sql = "t_file.file_id = $attachmentFileID";
		}
	}
	
	$files = xnpGetFileInfo( "t_file.file_id, t_file.original_file_name, t_file.file_size", "t_file_type.name='$name' and $sql ", $item_id );
	
	if ( count( $files ) == 0 ){
		$html = "<input type='hidden' name='${name}FileID' value=''>";
	}
	else {
		// todo: to be downloadable
		list( list( $fileID, $fileName, $fileSize ) ) = $files;
		$imageFileName = XOOPS_URL . "/modules/xoonips/image.php?file_id=$fileID";
		$html = "<input type='hidden' name='${name}FileID' value='$fileID'><img src='$imageFileName'>";
	}
	
	
	// generate html
	return array( 'name'=>'Attachment', 'value'=> $html );
}

function xnpurlGetConfirmBlock( $item_id ){
	// retrieve blocks of BasicInformation / Preview / index block
	$basic   = xnpGetBasicInformationConfirmBlock( $item_id );
	$preview = xnpGetPreviewConfirmBlock( $item_id );
	$index   = xnpGetIndexConfirmBlock( $item_id );
	$url_banner_file = xnpurlGetUrlBannerFileConfirmBlock( $item_id, 'url_banner_file' );
	// retrieve detail information
	if ( isset( $_POST['url'] ) ){
		$myts =& MyTextSanitizer::getInstance();
/*
		$detail = array(
			'url'     =>$myts->stripSlashesGPC($_POST['url'     ])
		);
*/
		$detail = array(
			'url'     =>$myts->stripSlashesGPC( xnpHtmlspecialchars( $_POST['url'     ]) )
		);
	}
	else if ( !empty( $item_id ) )
		$detail = xnpurlGetDetailInformation( $item_id );
	else
		$detail = array();
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to tpl
	
	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'preview', $preview );
	$tpl->assign( 'index', $index );
	$tpl->assign( 'url_banner_file', $url_banner_file );
	$tpl->assign( 'detail', $detail );
	// return HTML content
	return $tpl->fetch( "db:xnpurl_confirm_block.html" );
}

/** make sure that enterd detail information is correctly or not.
 * called from register confirmation and edit confirmation
 */
function xnpurlCheckRegisterParameters( &$message ){
	$messages = array();
	if ( empty( $_POST['url'] ) )  $messages[] = "url required.";
	//if ( empty( $_POST['url_banner_fileFileID'  ]) && empty( $_FILES['url_banner_file']['name']) ) $messages[] = "banner file required.";
	if ( count($messages) == 0 )
		return true;
	$message = "<br>\n" . implode( "<br>\n", $messages );
	return false;
}

/** make sure that enterd detail information is correctly or not.
 */
function xnpurlCheckEditParameters( &$message ){
	return xnpurlCheckRegisterParameters( $message );
}

function xnpurlInsertItem(){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// retister BasicInformation, Index and Attachment
	$item_id = 0;
	$result = xnpInsertBasicInformation( $item_id );
	if ( $result ){
		$result = xnpUpdateIndex( $item_id );
		if ( $result ){
				$result = xnpUpdateAttachment( $item_id, 'url_banner_file' );
				if ( $result ){
				}
		}
		if ( !$result )
			xnpDeleteBasicInformation( $xnpsid, $item_id );
	}
	if ( !$result )
		return false;
	
	$myts =& MyTextSanitizer::getInstance();
	$escval = $myts->addSlashes($_POST['url'     ]);
	
	
	// register detail information
	$myts =& MyTextSanitizer::getInstance();
	$sql = "insert into " . $xoopsDB->prefix("xnpurl_item_detail") . " ( url_id, url ) values ( $item_id, '$escval' ) ";
	$result = $xoopsDB->queryF( $sql );
	if ( $result == false ){
		echo "cannot insert item_detail";
		return false;
	}
	
	return true;
}

function xnpurlUpdateItem( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	$myts =& MyTextSanitizer::getInstance();
	
	// modify BasicInformation, Index, Preview and Attachment.
	$result = xnpUpdateBasicInformation( $item_id );
	if ( $result ){
		$result = xnpUpdateIndex( $item_id );
		if ( $result ){
				$result = xnpUpdateAttachment( $item_id, 'url_banner_file' );
				if ( $result ){
					$result = xnp_insert_change_log( $xnpsid, $item_id, $myts->stripSlashesGPC( $_POST['change_log'] ) );
					$result = !$result;
					if( !$result )
						echo " xnp_insert_change_log failed.";
				}
				else echo " xnpUpdateAttachment failed.";
		}
		else echo " xnpUpdateIndex failed.";
	}
	else echo " xnpUpdateBasicInformation failed.";
	if ( !$result )
		return false;
	
	// register detail information
	$sql = implode( ',', array(
		'url'      ."='".$myts->addSlashes($_POST['url'     ])."'"
	) );
	$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix("xnpurl_item_detail") . " set $sql where url_id = $item_id " );
	if ( $result == false )
		return false;
	
	return true;
}

function xnpurlDeleteItem( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	
	// remove BasicInformation, Index, Preview and Attachment.
	if( !xnpDeleteBasicInformation( $item_id ) ){
		echo "cannot delete model item";
		return false;
	}
	
	// remove detail information
	$sql = "delete from " . $xoopsDB->prefix("xnpurl_item_detail")
		. " where url_id=$item_id";
	$xoopsDB->queryF( $sql );
	return true;
}



function xnpurlGetDetailInformationQuickSearchQuery(&$wheres, &$join, $keywords){
	global $xoopsDB;
	//$url_table = $xoopsDB->prefix('xnpurl_item_detail');
	//$file_table  = $xoopsDB->prefix('xoonips_file');
	
	$join = "";
	//$wheres = xnpGetKeywordsQueries( array("$url_table.url", "$file_table.original_file_name"), $keywords );
	return true;
}



function xnpurlGetAdvancedSearchQuery(&$where, &$join){
	global $xoopsDB;
	$url_table = $xoopsDB->prefix('xnpurl_item_detail');
	$file_table  = $xoopsDB->prefix('xoonips_file');
	
	$wheres = array();
	$w = xnpGetBasicInformationAdvancedSearchQuery('xnpurl'); if( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($url_table.'.url', 'xnpurl_url'); if( $w ) $wheres[] = $w;

	$where = implode( ' and ', $wheres );
	$join = "";
}

function xnpurlGetAdvancedSearchBlock(&$search_var){
	// retrieve blocks of BasicInformation / Preview / IndexKeywords
	$basic   = xnpGetBasicInformationAdvancedSearchBlock('xnpurl',$search_var);
	$search_var[] = 'xnpurl_url'   ;
	
	// assign to template
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // variables assigned to xoopsTpl are copied to tpl
	

	$tpl->assign( 'basic', $basic );
	$tpl->assign( 'module_name', 'xnpurl' );
	$tpl->assign( 'module_display_name', 'URL' ); // todo: retrieve from db
	
	// return HTML content
	return $tpl->fetch( "db:xnpurl_search_block.html" );
}

function xnpurlGetDetailInformationTotalSize($iids){
	return xnpGetTotalFileSize($iids);
}

/**
 * 
 * generate XML of detail information for exporting.
 * 
 * @param fhdl file handle to write results
 * @param item_id item id that is exported
 * @param attachment true if exporting with attachments and images
 * @return true:succeed, false:failed
 */
function xnpurlExportItem($fhdl, $item_id, $attachment )
{
	global $xoopsDB;

    if( !$fhdl ) return false;

	// retrieve detail information
	$result = $xoopsDB->query( "select * from ".$xoopsDB->prefix( "xnpurl_item_detail" )." where url_id=$item_id" );
	if( !$result ) return false;
    $detail = $xoopsDB->fetchArray( $result );
	if( !fwrite( $fhdl, "<detail id=\"${item_id}\">\n"
        ."<url>".xnpHtmlspecialchars( $detail['url'], ENT_QUOTES )."</url>\n" ) ) return false;
    if( !( $attachment ? xnpExportFile( $fhdl, $item_id ) : true ) ) return false;
    if( !fwrite( $fhdl, "</detail>\n" ) ) return false;

    return true;
}

function xnpurlGetImportHandler( )
{
    return array( '/ITEM/DETAIL' => array( "xnpurlStartElement", "xnpurlEndElement", "xnpurlCharacterData" ) );
}

/**
 * bool xnpurlGetLicenseRequired( int item_id )
 * 
 * 
 */
/*
function xnpurlGetLicenseRequired( $item_id )
{
    return false;
}
*/

/**
 * string xnpurlGetLicenseStatement( int item_id )
 * 
 * 
 */
/*
function xnpurlGetLicenseStatement( $item_id )
{
    return ''
}
*/

function xnpurlGetModifiedFields( $item_id )
{
    $ret = array();
    $detail = xnpurlGetDetailInformation( $item_id );
    if( $detail ){
        $myts =& MyTextSanitizer::getInstance( );
        foreach( array( 'url' => _MD_XNPURL_URL_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $detail )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( $detail[ $k ] != $_POST[ $k ] ) array_push( $ret, $v );
        }
        // is modified banner files ?
        if( xnpIsAttachmentModified( 'url_banner_file', $item_id ) ){
            array_push( $ret, _MD_XNPURL_URL_BANNER_FILE_LABEL );
        }
    }
    return $ret;
}

function xnpurlGetTopBlock( $itemtype ){
	return xnpGetTopBlock( $itemtype['name'], $itemtype['display_name'], 'images/icon_url.gif', _MD_XNPURL_EXPLANATION, false, false );
}

function xnpurlSupportMetadataFormat( $metadataPrefix, $item_id )
{
    if( $metadataPrefix == 'oai_dc' || $metadataPrefix == 'junii' ) return true;
    return false;
}

function xnpurlGetMetadata( $metadataPrefix, $item_id )
{
    $meta_basic = xnpGetBasicInformationMetadata( $metadataPrefix, $item_id );
    if( $meta_basic ){
		$basic = array();
		if( xnp_get_item( $_SESSION['XNPSID'], $item_id, $basic ) != RES_OK )
			return false;
		
		$lines = array();
		if( $metadataPrefix == 'junii' ){
            $lines[] = "<metadata>";
            $lines[] = '<meta xmlns="http://metasv.nii.ac.jp/oai/"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:schemaLocation="http://metasv.nii.ac.jp/oai http://metasv.nii.ac.jp/oai/junii.xsd">';
            $lines[] = $meta_basic;
			$metadatajunii = xnpGetMetadataJunii(70);
            $lines[] = "<type xsi:type=\"NII\">".$metadatajunii."</type>";
            $lines[] = "</meta>";
            $lines[] = "</metadata>";
        }
		else if ( $metadataPrefix == 'oai_dc' ){
			$detail =xnpurlGetDetailInformation($item_id);
			$lines[] = "<metadata>";
			$lines[] = '<oai_dc:dc 
                 xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/" 
                 xmlns:dc="http://purl.org/dc/elements/1.1/" 
                 xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
                 xsi:schemaLocation="http://www.openarchives.org/OAI/2.0/oai_dc/ 
                 http://www.openarchives.org/OAI/2.0/oai_dc.xsd">';
			$lines[] = $meta_basic;
//			$lines[] = "<dc:identifier>".htmlspecialchars($detail['url'])."</dc:identifier>";
			$lines[] = "<dc:identifier>".xnpHtmlspecialchars($detail['url'])."</dc:identifier>";
			$lines[] = "</oai_dc:dc>";
			$lines[] = "</metadata>";
		}
		return implode( "\n", $lines )."\n";
    }
    return false;
}

function xnpurlStartElement($parser, $name, $attribs, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
        $parser_hash['detail'] = array();
        break;
    case "/ITEM/DETAIL/URL":
        $parser_hash['detail'][end($parser_hash['tagstack'])] = '';
        break;
    }
}
function xnpurlEndElement($parser, $name, &$parser_hash)
{
	global $xoopsDB;
    
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    $myts =& MyTextSanitizer::getInstance( );
    
    switch( $tags ){
    case '/ITEM/DETAIL':
        $keys = implode( ",", array( 'url' ) );
        $vals = implode( "','", array( addslashes( encodeClient2Server( $parser_hash['detail']['URL'] ) ) ) );
        
        // register detail information
        $myts =& MyTextSanitizer::getInstance( );
        $sql = "insert into ".$xoopsDB->prefix( "xnpurl_item_detail" )." ( url_id, $keys ) values ( ".$parser_hash['id_table'][$parser_hash['basic']['ID']].", '$vals' ) ";
        $result = $xoopsDB->queryF( $sql );
        if( $result == false ) {
            echo "cannot insert item_detail\n";
            return false;
        }
        break;
    }
}

function xnpurlCharacterData($parser, $data, &$parser_hash)
{
    $tags = "/".implode( '/', $parser_hash['tagstack'] );
    
    switch( $tags ){
    case "/ITEM/DETAIL/URL": 
        if( !array_key_exists( end($parser_hash['tagstack']), $parser_hash['detail'] ) ){
            $parser_hash['detail'][end($parser_hash['tagstack'])] = $data;
        }else{
            $parser_hash['detail'][end($parser_hash['tagstack'])] .= $data;
        }
        break; 
    } 
}

?>
