<?php
//  advanced search                                                             //
//  $Revision: 1.4.2.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

session_cache_limiter( 'none' );
session_cache_expire( 5 );

$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';
include_once 'include/lib.php';
include_once 'condefs.php';

require_once 'include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

// If not a user, redirect
if( $xnpsid != 0 ){
    if ( !$xoopsUser ) {
        redirect_header( 'index.php',3,_MD_XOONIPS_ITEM_FORBIDDEN);
        exit();
    }

    $uid = $_SESSION['xoopsUserId'];
}
else {
    if( !xnp_is_valid_session_id($xnpsid) ){
        // Uncertified user can't access(except XOOPS administrator).
        redirect_header(XOOPS_URL.'/index.php',3,_MD_XOONIPS_ITEM_FORBIDDEN);
        exit();
    }
    $uid = 0;
}

$xoopsOption['template_main'] = 'xoonips_advanced_search.html';
include XOOPS_ROOT_PATH.'/header.php';

foreach( array( 'checkbox' => 'off',
                'add_to_index_id' => false,
                'jumpto_url' => '',
                'jumpto_var' => array() ) as $k => $v ){
    if( array_key_exists( $k, $_GET ) ){
        $$k = $_GET[$k];
    }else if( array_key_exists( $k, $_POST ) ){
        $$k = $_POST[$k];
    }else{
        $$k = $v;
    }
}


$itemtypes = array();
if( xnp_get_item_types( $itemtypes ) != RES_OK ){
	redirect_header('index.php', 3, "ERROR xnp_get_item_types [AbstractLayer]".xnp_get_last_error_string());
	break;
}

// making block, search_var
$search_blocks = array();
$search_var = array();
foreach ( $itemtypes as $itemtype_id => $itemtype ){
	if ( $itemtype['item_type_id'] == ITID_INDEX )
		continue;
	$modname = $itemtype['name'];
	include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
	$fname = $modname . "GetAdvancedSearchBlock";
	if ( function_exists($fname) ){
		$search_blocks[] = $fname($search_var);
	}
}
$result = array();
$moduleTable = $xoopsDB->prefix('modules');
$sql = "select weight,dirname from $moduleTable where dirname like 'xnp%' order by mid";
$result = $xoopsDB->query($sql);
while ( list($weight) = $xoopsDB->fetchRow($result) ){
        $order[] = $weight;
}
array_multisort($order,$search_blocks);

if( !isset( $itemselect_url ) ) $itemselect_url = 'itemselect.php';
if( !isset( $pankuzu ) ){
    $pankuzu = _MI_XOONIPS_ACCOUNT_PANKUZU_PLATFORM_USER
        ._MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR
        ._MI_XOONIPS_ITEM_PANKUZU_ADVANCED_SEARCH;
}

$xoopsTpl->assign('itemselect_url', $itemselect_url);
$xoopsTpl->assign('pankuzu', $pankuzu);
$xoopsTpl->assign('search_var', $search_var);
$xoopsTpl->assign('search_blocks', $search_blocks);
$xoopsTpl->assign('checkbox', $checkbox);
$xoopsTpl->assign('add_to_index_id', $add_to_index_id);
$xoopsTpl->assign('accept_charset', xnpGetMacSafariAcceptCharset() );

$xoopsTpl->assign('jumpto_url', $jumpto_url);
$xoopsTpl->assign('jumpto_var', $jumpto_var);
$jumpto_var_var = array();
foreach( $jumpto_var as $k ){
    if( array_key_exists( $k, $_GET ) ){
		if( is_array( $_GET[$k] ) ){
            foreach( $_GET[$k] as $key => $value ){
                $jumpto_var_var["${k}[${key}]"] = $_GET[$k][$key];
            }
        }else{
            $jumpto_var_var[$k] = $_GET[$k];
        }
    }else if( array_key_exists( $k, $_POST ) ){
		if( is_array( $_POST[$k] ) ){
            foreach( $_POST[$k] as $key => $value ){
                $jumpto_var_var["${k}[${key}]"] = $_POST[$k][$key];
            }
        }else{
            $jumpto_var_var[$k] = $_POST[$k];
        }
    }
}
$xoopsTpl->assign('jumpto_var_var', $jumpto_var_var);

include XOOPS_ROOT_PATH.'/footer.php';
?>
