<?php
/* functions to display blocks and edit blocks.
 * $Revision: 1.20.2.5 $
 */

/*
	http://wiki.xoops.org/wakka.php?wakka=ModuleNamingConventions says:
		Always prefix with b_yourmoduledirname_ 
		Use only lowercase characters 
		Separate words with underscores (_)
*/

include_once XOOPS_ROOT_PATH.'/mainfile.php';
include_once XOOPS_ROOT_PATH.'/modules/xoonips/condefs.php';

if( file_exists( XOOPS_ROOT_PATH.'/modules/system/language/'.$xoopsConfig['language'].'/blocks.php' ) ) {
        include_once( XOOPS_ROOT_PATH.'/modules/system/language/'.$xoopsConfig['language'].'/blocks.php' );
} else {
        include_once( XOOPS_ROOT_PATH.'/modules/system/language/english/blocks.php' );
}

require_once XOOPS_ROOT_PATH . '/modules/xoonips/include/create_session.php';
require_once XOOPS_ROOT_PATH . '/modules/xoonips/include/lib.php';

/// display xnp login block
function b_xoonips_login_show()
{
	global $xoopsUser, $xoopsConfig;

	if (!$xoopsUser) { // not display during login
		if ( xnp_load_init_create_session_silent() != 0 ) return false;
		$block = array();
		$block['lang_username'] = _MB_XOONIPS_ACCOUNT_USERNAME;
		$block['unamevalue'] = "";
		if (isset($_COOKIE[$xoopsConfig['usercookie']])) {
			$block['unamevalue'] = $_COOKIE[$xoopsConfig['usercookie']];
		}
		$block['lang_password'] = _MB_XOONIPS_ACCOUNT_PASSWORD;
		$block['lang_login'] = _MB_XOONIPS_ACCOUNT_LOGIN;
		$block['lang_lostpass'] = _MB_XOONIPS_ACCOUNT_LPASS;
		$block['lang_registernow'] = _MB_XOONIPS_ACCOUNT_RNOW;
		//$block['lang_rememberme'] = _MB_XOONIPS_ACCOUNT_REMEMBERME;
		if ($xoopsConfig['use_ssl'] == 1 && $xoopsConfig['sslloginlink'] != '') {
			$block['sslloginlink'] = "<a href=\"javascript:openWithSelfMain('".$xoopsConfig['sslloginlink']."', 'ssllogin', 300, 200);\">"._MB_SYSTEM_SECURE."</a>";
		}
    	return $block;
    }
	return false;
}

function b_xoonips_user_show()
{
	global $xoopsUser;
	if (is_object($xoopsUser)) {
		$block = array();
		$uid = $xoopsUser->getVar('uid');
		
		// Load AL and get private_index_id.
		if ( xnp_load_init_create_session_silent() != 0 ) return false;
		$xnpsid = $_SESSION['XNPSID'];
		$account = array();
		$ret = xnp_get_account( $xnpsid, $uid, $account );
		if ( $ret == RES_OK ){
			$block['private_index_id'] = $account['private_index_id'];
		}
		
		$pm_handler =& xoops_gethandler('privmessage');
		$block['lang_youraccount'] = _MB_XOONIPS_ACCOUNT_VIEW_ACCOUNT;
		$block['lang_editaccount'] = _MB_XOONIPS_ACCOUNT_EDIT_ACCOUNT;
		$block['lang_grouplist'] = _MB_XOONIPS_ACCOUNT_GROUP_LIST;
		$block['lang_notifications'] = _MB_SYSTEM_NOTIF;
		
		$block['lang_listing_item'] = _MB_XOONIPS_ACCOUNT_LISTING_ITEM;
		$block['lang_edit_index'] = _MB_XOONIPS_ACCOUNT_EDIT_PRIVATE_INDEX;
		$block['lang_advanced_search'] = _MB_XOONIPS_ACCOUNT_ADVANCED_SEARCH;
		$block['lang_register_item'] = _MB_XOONIPS_ACCOUNT_REGISTER_ITEM;
		$block['lang_metadata_search'] = _MB_XOONIPS_ACCOUNT_METADATA_SEARCH_LABEL;
		
		$block['uid'] = $uid;
		$block['lang_logout'] = _MB_SYSTEM_LOUT;
		$criteria = new CriteriaCompo(new Criteria('read_msg', 0));
		$criteria->add(new Criteria('to_userid', $xoopsUser->getVar('uid')));
		$block['new_messages'] = $pm_handler->getCount($criteria);
		$block['lang_inbox'] = _MB_SYSTEM_INBOX;
		if ($xoopsUser->isAdmin()) {
			$block['lang_adminmenu'] = _MB_SYSTEM_ADMENU;
		}
		$private_import_enabled = "";
		if( xnp_get_config_value( 'private_import_enabled', $private_import_enabled ) == RES_OK ){
			if( $private_import_enabled == 'on' ){
				$block['lang_import'] = _MB_XOONIPS_ACCOUNT_IMPORT;
			}
		}
		$block['lang_metadata_search'] = _MB_XOONIPS_ACCOUNT_METADATA_SEARCH_LABEL;
		return $block;
	}
	return false;
}

function b_xoonips_group_show()
{
	global $xoopsUser;
	if (is_object($xoopsUser)) {
		if ( xnp_load_init_create_session_silent() != 0 ) return false;
		$xnpsid = $_SESSION['XNPSID'];
		$uid = $_SESSION['xoopsUserId'];
		
		// The user who is not a member of group's admin can't see this menu.
		$gids = array();
		$criteria = array();
		$xid = false;
		
		if( 0 != xnp_get_groups_by_uid( $xnpsid, $uid, $criteria, $gids ) ){
			return false;
		}
		$adminGids = array();
		foreach( $gids as $gid ){
			if ( xnp_is_group_admin( $xnpsid, $gid, $uid ) )
				$adminGids[] = $gid;
		}
		
		if ( count( $adminGids ) != 0 ){
			// gid -> xid
			$group = array();
			if( 0 != xnp_get_group( $xnpsid, $adminGids[0], $group ) ){
				return false;
			}
			$xid = $group['group_index_id'];
		}
		else {
			// case of no groups to operate (= not group's admin)
			// display the menu if the user belongs to xoops admin.
			if( !$xoopsUser->isAdmin() ){
				return false;
			}
		}
		
		$block = array();
		$block['lang_edit_group'] = _MB_XOONIPS_ACCOUNT_EDIT_GROUPS;
		$block['lang_certify_group_items'] = _MB_XOONIPS_ACCOUNT_CERTIFY_GROUP_ITEMS;
		$block['lang_edit_group_index'] = _MB_XOONIPS_ACCOUNT_EDIT_GROUP_INDEX;
		$block['xid'] = $xid;
		return $block;
	}
	return false;
}

function b_xoonips_moderator_show()
{
	global $xoopsUser;
	if (is_object($xoopsUser)) {
		if ( xnp_load_init_create_session_silent() != 0 ) return false;
		$xnpsid = $_SESSION['XNPSID'];
		$uid = $_SESSION['xoopsUserId'];
		
		if ( xnp_is_moderator( $xnpsid, $uid ) ){
			$block = array();
			$block['lang_edit_group'] = _MB_XOONIPS_MODERATOR_EDIT_GROUPS;
			$block['lang_certify_users'] = _MB_XOONIPS_MODERATOR_CERTIFY_USERS;
			$block['lang_certify_items'] = _MB_XOONIPS_MODERATOR_CERTIFY_PUBLIC_ITEMS;
			$block['lang_edit_public_index'] = _MB_XOONIPS_MODERATOR_EDIT_PUBLIC_INDEX;
			$block['lang_event_log'] = _MB_XOONIPS_MODERATOR_EVENT_LOG;
			$block['lang_import'] = _MB_XOONIPS_MODERATOR_IMPORT;
			$block['xid'] = IID_PUBLIC;
			return $block;
		}
	}
	return false;
}


// display index tree block
function b_xoonips_tree_show()
{
	global $xoopsUser, $xoopsConfig, $xoonipsTreeCheckBox, $xoonipsSelectedTab,
		$xoonipsForm, $xoonipsURL, $xoonipsHideBinders, $xoonipsEditIndex, $xoonipsCheckPrivate, $xoonipsEditBinder, $xoopsDB;
	include_once XOOPS_ROOT_PATH . '/modules/xoonips/condefs.php';
	$query = array();
	if ( !empty( $xoonipsTreeCheckBox ) ) $query[] = 'checkbox=1';
	if ( !empty( $xoonipsForm ) )         $query[] = "form=$xoonipsForm";
	if ( !empty( $xoonipsHideBinders ) )  $query[] = "hide_binders=1";
	if ( !empty( $xoonipsEditIndex ) )    $query[] = "edit=1";
	if ( !empty( $xoonipsCheckPrivate ) ) $query[] = "check_private=$xoonipsCheckPrivate";
	if (  isset( $xoonipsURL ) )          $query[] = "url=" . urlencode($xoonipsURL);
	if ( !empty( $xoonipsSelectedTab ) )  $query[] = "selected_tab=$xoonipsSelectedTab";
	if ( !empty( $xoonipsEditBinder ) )   $query[] = "edit_binder=1";
	
	$block = array();
	$block['query'] = implode( '&', $query );

	// Load AL and get the selectable top_level_index.
	if ( xnp_load_init_create_session_silent() != 0 ) return false;
	$xnpsid = $_SESSION['XNPSID'];
	$indexes = array();
	if ( !empty($xoopsUser) ){
		$uid = $xoopsUser->getVar('uid');
	}
	else
		$uid = 0;
	
	$val = "";
	xnp_get_config_value( 'tree_frame_width', $val );
	$block['tree_frame_width'] = $val;
	xnp_get_config_value( 'tree_frame_height', $val );
	$block['tree_frame_height'] = $val;
	$block['isSafari'] = (bool)(stristr($_SERVER["HTTP_USER_AGENT"], "safari" ));
	$block['checkbox'] = !empty( $xoonipsTreeCheckBox );
	
	$guest_enabled = xnp_is_valid_session_id(XNPSID_GUEST);
	
	if ( $uid == UID_GUEST && !$guest_enabled ){
		// cannot xnp_get_index because guest is disabled. use SQL instead.
		$sql = "select title from ".$xoopsDB->prefix('xoonips_item_basic')." where item_id = " . IID_PUBLIC;
		$result = $xoopsDB->query( $sql );
		list( $title ) = $xoopsDB->fetchRow( $result );
		$block['indexes'] = array(
			array( 'item_id' => IID_PUBLIC, 'title' => $title )
		);
		return $block;
	}

	if ( !empty( $xoonipsEditBinder ) ){
		// edit binder : display only public and private index.
		$index = array();
		$result = xnp_get_index( $xnpsid, 3, $index );
		$indexes[] = $index;
		
		// private
		$account = array();
		$result = xnp_get_account( $xnpsid, $uid, $account );
		if ( $result == RES_OK ){
			$index = array();
			$result = xnp_get_index( $xnpsid, $account['private_index_id'], $index );
			$indexes[] = $index;
		}
	}
	else {
		if ( !empty( $xoonipsEditIndex ) ){
			$xids = array();
			
			// public
			if ( xnp_is_moderator( $xnpsid, $uid ) )
				$xids[] = IID_PUBLIC;
			
			// group
			$gids = array();
			$criteria = array();
			$result = xnp_get_groups_by_uid( $xnpsid, $uid, $criteria, $gids );
			if ( $result == RES_OK ){
				$groups = array();
				$result = xnp_get_groups( $xnpsid, $gids, $criteria, $groups );
				if ( $result == RES_OK ) {
					foreach( $groups as $group ){
						if ( xnp_is_group_admin( $xnpsid, (int)$group['gid'], $uid ) )
							$xids[] = $group['group_index_id']; // group
					}
				}
			}
			
			// private
			$account = array();
			$result = xnp_get_account( $xnpsid, $uid, $account );
			if ( $result == RES_OK ){
				$xids[] = $account['private_index_id']; // private
				
				// xids -> indexes
				foreach( $xids as $xid ){
					// The value of $indexes is strange, if "$index = array();" moves to outside of foreach sentence (reason is unknown).
					$index = array();
					$result = xnp_get_index( $xnpsid, $xid, $index );
					$indexes[] = $index;
				}
			}
		}
		else if ( xnp_is_moderator( $xnpsid, $uid ) ){
			// Get index which is related to oneself.
			$xids = array();
			
			// public
			$xids[] = IID_PUBLIC;
			
			// group
			$gids = array();
			$criteria = array();
			$result = xnp_get_groups_by_uid( $xnpsid, $uid, $criteria, $gids );
			if ( $result == RES_OK ){
				$groups = array();
				$result = xnp_get_groups( $xnpsid, $gids, $criteria, $groups );
				if ( $result == RES_OK ){
					foreach( $groups as $group ){
						$xids[] = $group['group_index_id']; // group
					}
				}
			}
			// private
			$account = array();
			$result = xnp_get_account( $xnpsid, $uid, $account );
			if ( $result == RES_OK ){
				$xids[] = $account['private_index_id']; // private
			}
			
			// xids -> indexes
			foreach( $xids as $xid ){
				// The value of $indexes is strange, if "$index = array();" moves to outside of foreach sentence (reason is unknown).
				$index = array();
				$result = xnp_get_index( $xnpsid, $xid, $index );
				$indexes[] = $index;
			}
		}
		else{
			$criteria = array( 'orders'=>array( array('name'=>'sort_number', 'order'=>'ASC' ) ) );
			$result = xnp_get_indexes( $xnpsid, 1, $criteria, $indexes );
		}
	}
	$block['indexes'] = $indexes;
	
    return $block;
}


/* Display block of QuickSearch
 todo: The right of access controls the display of a block.
       Return false in case user is guest and not to permit guest.
*/
function b_xoonips_quick_search_show(){
	$block = array();
	$search_itemtypes = array( 'all'=>_MB_XOONIPS_ITEM_ALL_LABEL, 'basic'=>_MB_XOONIPS_ITEM_TITLE_AND_KEYWORD_LABEL );
	
	// Load AL and get itemtypes.
	if ( xnp_load_init_create_session_silent() != 0 ) return false;
	
	$itemtypes = array();
	if( xnp_get_item_types( $itemtypes ) == RES_OK ){
		foreach ( $itemtypes as $itemtype ){
			if ( $itemtype['item_type_id'] > 2 )
				$search_itemtypes[$itemtype['name']] = $itemtype['display_name'];
		}
	}
	$block['search_itemtypes'] = $search_itemtypes;
	$block['lang_search'] = _MB_XOONIPS_ITEM_SEARCH_LABEL;
	$block['accept_charset'] = xnpGetMacSafariAcceptCharset();

    global $xoopsDB;
	$result = array();
	$order[] = "";
	$moduleTable = $xoopsDB->prefix('modules');
	$sql = "select weight from $moduleTable  where dirname like 'xnp%' or dirname like 'xoonips' order by mid";
	$result = $xoopsDB->query($sql);
	while ( list($weight) = $xoopsDB->fetchRow($result) ){
	        $order[] = $weight;
			}
    array_multisort($order, $block['search_itemtypes']);

	$myts =& MyTextsanitizer::getInstance();
	$block['keyword'] = '';
	if      ( isset($_POST['keyword']) ) $block['keyword'] = $myts->stripSlashesGPC($_POST['keyword']);
	else if ( isset($_GET ['keyword']) ) $block['keyword'] = $myts->stripSlashesGPC($_GET ['keyword']);
	if      ( isset($_POST['search_itemtype']) ) $block['search_itemtypes_selected'] = $myts->stripSlashesGPC($_POST['search_itemtype']);
	else if ( isset($_GET ['search_itemtype']) ) $block['search_itemtypes_selected'] = $myts->stripSlashesGPC($_GET ['search_itemtype']);
	$block['keyword'] = xnpHtmlspecialchars( $block['keyword'] );
	return $block;
}

?>
