<?php
//  $Revision: 1.4.4.5 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //
//$xoopsOption = array();
//$xoopsOption['nocommon'] = true;

include '../../mainfile.php';
include_once 'include/lib.php';
include_once XOOPS_ROOT_PATH.'/class/module.textsanitizer.php';
include_once XOOPS_ROOT_PATH.'/modules/system/constants.php';
include_once XOOPS_ROOT_PATH.'/language/'.$xoopsConfig['language'].'/user.php';

require_once 'include/create_session.php';
xnp_load_init_create_session(  );
$xnpsid = $_SESSION['XNPSID'];

if( !$xoopsUser ) {
	redirect_header( 'user.php', 3, _NOPERM );
	exit();
}
$uid = $xoopsUser->getVar('uid');

//Uncertified user can't access(except XOOPS administrator).
if( !$xoopsUser->isAdmin( $xoopsModule->getVar( 'mid' ) )
	&& !xnp_is_activated( $xnpsid, $uid ) ) {
	redirect_header( 'index.php', 3, _MD_XOONIPS_MODERATOR_NOT_ACTIVATED );
	exit(  );
}
//User(Not Moderater) can't control(except XOOPS administrator).
if( !$xoopsUser->isAdmin( $xoopsModule->getVar( 'mid' ) )
	&& !xnp_is_moderator( $xnpsid, $uid ) ) {
	redirect_header( 'index.php', 3, _MD_XOONIPS_MODERATOR_SHULD_BE_MODERATOR );
	exit(  );
}

foreach( array( 'op' => '',
                'certify_uid' => '' ) as $k => $v ){
    if( isset( $_GET[ $k ] ) ){
        $$k = $_GET[ $k ];
    }else if( isset( $_POST[ $k ] ) ){
        $$k = $_POST[ $k ];
    }else{
        if( isset( $v ) ){
            $$k = $v;
        }
    }
}

require( XOOPS_ROOT_PATH.'/header.php' );

if( !isset($op) )
	$op = '';

if( $op == 'certify' ) {
	//certify user
	$user = array(  );
	$result = xnp_get_account( $xnpsid, $certify_uid, $user );
	if( $result != 0 ) {
		redirect_header( 'certifyuser.php', 3, _MD_XOONIPS_MODERATOR_ERROR_SELECT_USER );
		exit(  );
	}
    if( $user['activate'] == 1 ){
		redirect_header( 'certifyuser.php', 3, _MD_XOONIPS_ACCOUNT_ALREADY_CERTIFIED."(".$user['uname'].")" );
    }
	$user['activate'] = 1;
	$result = xnp_update_account( $xnpsid, $user );
	if( $result != 0 ) {
		redirect_header( 'certifyuser.php', 3, _MD_XOONIPS_MODERATOR_ERROR_UPDATE_USER );
		exit(  );
	}
	// record events(certify account)
	xnp_insert_event( $xnpsid, ETID_CERTIFY_ACCOUNT, time(), $uid, xnpGetRemoteHost(), array( 'uid' => $user['uid'] ) );

	$xoopsTpl->assign( 'certified_user', $user );

	//
	// notify a completion of certification to the certified user by e-mail
	//
	$myts =& MyTextSanitizer::getInstance();
	$xoopsMailer =& getMailer();
	$xoopsMailer->useMail();
	$xoopsMailer->setTemplateDir(XOOPS_ROOT_PATH."/modules/xoonips/language/".$xoopsConfig['language']."/mail_template/" );
	$xoopsMailer->setTemplate('xoonips_account_certified.tpl');
	$xoopsMailer->assign('SITENAME', $xoopsConfig['sitename']);
	$xoopsMailer->assign('ADMINMAIL', $xoopsConfig['adminmail']);
	$xoopsMailer->assign('SITEURL', XOOPS_URL."/");
	$xoopsMailer->setToUsers(new XoopsUser( $user['uid'] ));
	$xoopsMailer->setFromEmail($xoopsConfig['adminmail']);
	$xoopsMailer->setFromName($xoopsConfig['sitename']);
	$xoopsMailer->setSubject(_MD_XOONIPS_ACCOUNT_CERTIFIED);
	if ( !$xoopsMailer->send() ) {
		redirect_header( 'certifyuser.php' , 3, sprintf( _US_ACTVMAILNG, $user['uname'] ) );
	}
	
}

$xoopsTpl->assign( 'op', $op );
$xoopsOption['template_main'] = 'xoonips_certifyuser.html';

$users = array(  );
$uids = array(  );
if( xnp_dump_uids( $xnpsid, array(  ), $uids ) != 0 ) {
	redirect_header( 'index.php', 3, _MD_XOONIPS_MODERATOR_ERROR_SELECT_USER );
	exit(  );
}
if( count( $uids ) > 0 ) {
	foreach( $uids as $i ) {
		$user = array(  );
		if( xnp_get_account( $xnpsid, $i, $user ) == 0 ) {
			if( $user['activate'] != 1 && $user['level'] != 0 ) { // list acitvated & uncertified users only
				$users[] = array( 'uid' => $user['uid'],
								  'uname' => $user['uname'],
								  'name' => $user['name'], 'email' => $user['email'] );
			}
		}
	}
	$xoopsTpl->assign( 'users', $users );
}
require( XOOPS_ROOT_PATH.'/footer.php' );
?>
