<?php
//  page for confirm to edit items                                              //
//  $Revision: 1.12.2.2 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //
$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';

include_once 'condefs.php';
include_once 'include/item_limit_check.php';
include_once 'include/lib.php';
include_once 'include/create_session.php';

xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];
$system_message = '';

if ( isset($_POST['add_to_index_id']) ){ // Processing when add button is pushed to public on detail page.
	if ( !in_array( $_POST['add_to_index_id'], explode( ',', $_POST['xoonipsCheckedXID'] ) ) )
	$_POST['xoonipsCheckedXID'] .= ',' . $_POST['add_to_index_id'];
}
if ( isset($_POST['delete_nonpublic_yes']) && isset($_POST['xoonips_item_id']) ){
	// delete non-public items in binder
	$xoonips_item_id = $_POST['xoonips_item_id'];
	$public_item_id = array();
	if ( xnp_extract_public_item_id( $xnpsid, $xoonips_item_id, $public_item_id ) == RES_OK ){
		$_POST['xoonips_item_id'] = $public_item_id;
	}
}
if ( isset($_POST['delete_nonpublic_no']) && isset($_POST['xoonipsCheckedXID']) ){
	// not to register in binders
	$xoonipsCheckedXID = array_diff( explode( ',', $_POST['xoonipsCheckedXID'] ), array(IID_BINDERS) );
	$_POST['xoonipsCheckedXID'] = implode( ',', $xoonipsCheckedXID );
}


foreach( array( 'item_id' => 0, 'op' => '' ) as $k => $v ){
    if( array_key_exists( $k, $_GET ) ){
        $$k = $_GET[$k];
    }else if( array_key_exists( $k, $_POST ) ){
        $$k = $_POST[$k];
    }else{
        $$k = $v;
    }
}

// If not a user, redirect
if ( !$xoopsUser ) {
	redirect_header(XOOPS_URL.'/index.php',3,_US_NOEDITRIGHT);
	exit();
}

$uid = $_SESSION['xoopsUserId'];

//Uncertified user can't access(except XOOPS administrator).
if( !$xoopsUser->isAdmin( $xoopsModule->getVar('mid') )
	&& !xnp_is_activated( $xnpsid, $uid ) ){
  	redirect_header(XOOPS_URL.'/index.php', 3, _MD_XOONIPS_MODERATOR_NOT_ACTIVATED);
  	exit();
}


//retrieve item detail and set item type id to $item_type_id;
$item = array();
if( xnp_get_item( $xnpsid, $item_id, $item ) != RES_OK ){
	redirect_header('index.php', 3, "ERROR xnp_get_item [AbstractLayer]".xnp_get_last_error_string());
	break;
}else{
	$item_type_id = $item['item_type_id'];
}

//retrive module name to $itemtype
$itemtypes = array();
if( xnp_get_item_types( $itemtypes ) != RES_OK ){
	redirect_header('index.php', 3, "ERROR xnp_get_item_types [AbstractLayer]".xnp_get_last_error_string());
	break;
}else{
	foreach( $itemtypes as $i){
		if( $i['item_type_id'] == $item_type_id ){
			$itemtype = $i;
			$modname = $itemtype['name'];
			break;
		}
	}
}

//include view.php
include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];

if( !isset( $_POST['title'] ) ){
    //title is not filled
    $op='';
    $system_message = "<font color='#ff0000'>"._MD_XOONIPS_ITEM_TITLE_REQUIRED."</font>";
}

//check private_item_number_limit
if( !check_private_item_number_limit( ) ){
	$op = '';
	$system_message .= "<font color='#ff0000'>"._MD_XOONIPS_ITEM_WARNING_ITEM_NUMBER_LIMIT."</font><br/>";
}

//check private_item_storage_limit
if( !check_private_item_storage_limit( ) ){
	$op = '';
	$system_message .= "<font color='#ff0000'>"._MD_XOONIPS_ITEM_WARNING_ITEM_STORAGE_LIMIT."</font><br/>";
}

//check group_item_number_limit
//check group_item_storage_limit
if ( $_POST['xoonipsCheckedXID'] != "" )
	$checked_xids = explode( ',', $_POST['xoonipsCheckedXID'] );
else
	$checked_xids = array();

$gids = array();
foreach( $checked_xids as $xid ){
	$index = array();
	$result = xnp_get_index( $xnpsid, $xid, $index );
	if( $index['open_level'] == OL_GROUP_ONLY ){
		$gids[] = $index['owner_gid'];
	}
}
foreach( array_unique( $gids ) as $gid ){
	if( !check_group_item_number_limit( $gid ) ){
		$op='';
		$group = array();
		if( xnp_get_group( $xnpsid, $gid, $group ) == RES_OK ){
			$system_message .= "<font color='#ff0000'>"._MD_XOONIPS_ITEM_WARNING_ITEM_NUMBER_LIMIT."(group=".$group['gname'].")</font><br/>";
		}else{
			$system_message .= "<font color='#ff0000'>"._MD_XOONIPS_ITEM_WARNING_ITEM_NUMBER_LIMIT."(gid=${gid})</font><br/>";
		}
	}
	if( !check_group_item_storage_limit( $gid ) ){
		$op='';
		$group = array();
		if( xnp_get_group( $xnpsid, $gid, $group ) == RES_OK ){
			$system_message .= "<font color='#ff0000'>"._MD_XOONIPS_ITEM_WARNING_ITEM_STORAGE_LIMIT."(group=".$group['gname'].")</font><br/>";
		}else{
			$system_message .= "<font color='#ff0000'>"._MD_XOONIPS_ITEM_WARNING_ITEM_STORAGE_LIMIT."(gid=${gid})</font><br/>";
		}
	}
}

//check registration to Private Index
//if there is no registration, registration of items are forbidden.
$user = array();
$private_index_flag = false;// true if private index is selected
$public_index_flag = false;// true if public index is selected
$group_index_flag = false;// true if group index is selected
foreach( $checked_xids as $xid ){
	$index = array();
	$result = xnp_get_index( $xnpsid, $xid, $index );
	if( $index['open_level'] == OL_PRIVATE ){
		$private_index_flag = true;
	}else if( $index['open_level'] == OL_GROUP_ONLY ){
		$group_index_flag = true;
	}else if( $index['open_level'] == OL_PUBLIC ){
		$public_index_flag = true;
	}
}
if( $item_type_id != ITID_INDEX && $item_type_id != ITID_BINDER && !$private_index_flag ){
    $op='';
	$system_message = $system_message."\n<br/><font color='#ff0000'>"._MD_XOONIPS_ITEM_SELECT_PRIVATE_INDEX."</font>";
}
    
//check required field(detail information)
$msg = "";
eval( "\$result = ".$modname."CheckEditParameters( \$msg );" );
if( !$result ){
    $op='';
    $system_message = $system_message.$msg;
}
if( $op=='update' ){
	//update item
	eval( "\$result = ".$modname."UpdateItem( \$item_id );" );
	if( !$result ){
		redirect_header('index.php',3,"ERROR in ".$modname."UpdateItem( )" );
	}else{
		$value = '';
		if( xnp_get_config_value( 'certify_item', $value ) != RES_OK ){
			$value = 'on';//
		}
		if( $item_type_id != ITID_INDEX && ( $public_index_flag || $group_index_flag ) && $value == 'on' ){
			redirect_header('index.php',5,"Succeed\n<br/>"._MD_XOONIPS_ITEM_NEED_TO_BE_CERTIFIED );
		}
		else
			redirect_header('index.php',3,"Succeed" );
	}
	exit();
}else{
	//confirm 
	xnpEncodeMacSafariPost();
	xnpEncodeMacSafariGet();
	
	// $_POST['related_to_check'] is an array(from edit.php) or string(from detail.php,confirm_edit.php).
	if ( isset($_POST['related_to_check']) && is_string($_POST['related_to_check']) )
		$_POST['related_to_check'] = preg_split( "/[\r\n]+/", $_POST['related_to_check'] ); // convert to array
	
	// If items register in Binder and Binders, check number of non-public items. display confirm page if there are non-public items.
	$check_xids = explode( ',', $_POST['xoonipsCheckedXID'] );
	if ( (int)$item_type_id == ITID_BINDER && in_array( (string)IID_BINDERS, $check_xids ) ){
		$xoonips_item_id = $_POST['xoonips_item_id'];
		$public_item_id = array();
		if( xnp_extract_public_item_id( $xnpsid, $xoonips_item_id, $public_item_id ) != RES_OK ){
			redirect_header(XOOPS_URL.'/register.php', 3, "ERROR xnp_get_public_item_id [AbstractLayer]".xnp_get_last_error_string());
			break;
		}
		$nonpublic_count = count($xoonips_item_id) - count($public_item_id); //number of non-pubic items in Binder
		if ( $nonpublic_count != 0 ){
			include XOOPS_ROOT_PATH.'/header.php';
			echo "<form action='confirm_edit.php' method='POST'>";
			foreach ( $_POST as $key => $val ){
				if ( is_array( $val ) ){
					foreach ($val as $dummy => $val2) {
						echo "<input type='hidden' name='$key" . "[]' value='" . htmlspecialchars($val2,ENT_QUOTES). "'>\n";
					}
				}
				else
					echo "<input type='hidden' name='$key' value='" . htmlspecialchars($val,ENT_QUOTES). "'>\n";
			}
			echo '<div class="confirmMsg"><h4>' . sprintf( _MD_XOONIPS_ITEM_DELETE_NONPUBLIC_ITEM, $nonpublic_count ) . "</h4><br/>\n";
			echo "<input type='submit' name='delete_nonpublic_yes' value='". _YES ."'> ";
			echo "<input type='submit' name='delete_nonpublic_no' value='". _NO ."'>";
			echo "</div>\n";
			echo "</form>";
			include XOOPS_ROOT_PATH.'/footer.php';
			exit;
		}
		
	}
	
	
	$select_item_type = array();
	$itemtypes = array();
	if( xnp_get_item_types( $itemtypes ) != RES_OK ){
		redirect_header(XOOPS_URL.'/register.php', 3, "ERROR xnp_get_item_types [AbstractLayer]".xnp_get_last_error_string());
		break;
	}else{
		foreach( $itemtypes as $i){
			if( $i['item_type_id'] > 2 ){
				if( !isset( $item_type_id ) ){
					// set default item type id
					$item_type_id = $i['item_type_id']; 
				}
				if( $i['item_type_id'] == $item_type_id ){
					$itemtype = $i;
					$modname = $i['name'];
				}
				$select_item_type[$i['display_name']]=$i['item_type_id'];
			}
		}
	}
	
	$xoopsOption['template_main'] = 'xoonips_confirm_edit.html';
	include XOOPS_ROOT_PATH.'/header.php';
	$xoopsTpl->assign('item_id', $_POST['item_id'] );
	include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];

	if( !isset( $_POST['change_log'] ) || $_POST['change_log'] == '' ){
        $fields = xnpGetModifiedFields( $_POST['item_id'] );
        $fname = $modname."GetModifiedFields";
        if( function_exists( $fname ) ){
            $fields = array_merge( $fields, $fname( $_POST['item_id'] ) );
        }
        if( count( $fields ) > 0 ){
            $_POST['change_log']
                = sprintf( _MD_XOONIPS_ITEM_CHANGE_LOG_AUTOFILL_TEXT, 
                           implode( _MD_XOONIPS_ITEM_CHANGE_LOG_AUTOFILL_DELIMITER, $fields ) );
                         
        }
    }
    
	eval( "\$body = ".$modname."GetConfirmBlock( ".$_POST['item_id']." );" );
	$xoopsTpl->assign('body', $body );
	$myts =& MyTextsanitizer::getInstance();
    //send basic information using hidden to next(before)page.
    $http_vars = array();
    foreach( array( 'item_type_id',
                    'title',
                    'keywords',
                    'description',
                    'doi',
                    'publicationDateYear',
                    'publicationDateMonth',
                    'publicationDateDay',
                    'change_log',
                    'xoonipsCheckedXID',
                    'lang',
                    'related_to' ) as $k ){
        if ( isset($_POST[$k]) )
            $http_vars[ $k ] = htmlspecialchars( $myts->stripSlashesGPC( $_POST[$k] ) );
        else
            $http_vars[ $k ] = '';
    }
    $http_vars['related_to_check'] = implode( "\n", ( isset( $_POST['related_to_check'] ) ? $_POST['related_to_check'] : array() ) );
    $xoopsTpl->assign('http_vars', $http_vars );
	$xoopsTpl->assign("item_id", $item_id );

    $xoopsTpl->assign('system_message', $system_message );
	
	include XOOPS_ROOT_PATH.'/footer.php';
}
?>
