<?php
//  page to display item's detail                                               //
//  $Revision: 1.15.2.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';
include_once 'condefs.php';
include_once 'include/lib.php';

require_once 'include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

// If not a user, redirect
if( $xnpsid != XNPSID_GUEST ){
    if ( !$xoopsUser ) {
		redirect_header( 'index.php',3,_MD_XOONIPS_ITEM_FORBIDDEN);
        exit();
    }

    $uid = $_SESSION['xoopsUserId'];

    //Uncertified user can't access(except XOOPS administrator).
    if( !$xoopsUser->isAdmin( $xoopsModule->getVar('mid') )
        && !xnp_is_activated( $xnpsid, $uid ) ){
        redirect_header( 'index.php', 3, _MD_XOONIPS_MODERATOR_NOT_ACTIVATED);
        exit();
    }
}
else {
    if( !xnp_is_valid_session_id($xnpsid) ){
        // User is guest group, and guest isn't admitted to access the page.
        redirect_header(XOOPS_URL.'/index.php',3,_MD_XOONIPS_ITEM_FORBIDDEN);
        exit();
    }
    $uid = UID_GUEST;
}
$config_handler =& xoops_gethandler('config');
$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);

foreach( array( 'item_id' => 0,
                'index_id' => 0,
                'op' => '' ) as $k => $v ){
    if( array_key_exists( $k, $_GET ) ){
        $$k = $_GET[$k];
    }else if( array_key_exists( $k, $_POST ) ){
        $$k = $_POST[$k];
    }else{
        $$k = $v;
    }
}

//retrieve item detail and set item type id to $item_type_id;
$item = array();
$result = xnp_get_item( $xnpsid, $item_id, $item );
if( $result != RES_OK ){
	if( $result == RES_NO_SUCH_ITEM )
		redirect_header( 'index.php',3,_MD_XOONIPS_ITEM_FORBIDDEN);
	else
		redirect_header('index.php', 3, "ERROR xnp_get_item [AbstractLayer]".xnp_get_last_error_string());
	exit;
}else{
	$item_type_id = $item['item_type_id'];
}

//retrieve module name to $modname
$tmp = array();
$itemtypes = array();
if( xnp_get_item_types( $tmp ) != RES_OK ){
	redirect_header('index.php', 3, "ERROR xnp_get_item_types [AbstractLayer]".xnp_get_last_error_string());
	break;
}else{
    foreach( $tmp as $i ){
        $itemtypes[ $i['item_type_id'] ] = $i;
    }
    
    $itemtype = $itemtypes[ $item_type_id ];
    $modname = $itemtype['name'];
}

if( $op == 'cancel_certify' || $op == 'accept_certify' ){
    //echo "xnp_set_certify_state( $xnpsid, $index_id, $item_id, NOT_CERTIFIED )";
    //$result = xnp_set_certify_state( $xnpsid, $index_id, $item_id, NOT_CERTIFIED );
	$user = array();
	xnp_get_account( $xnpsid, $item['uid'], $user );
    
    $state = NOT_CERTIFIED;
    $body_index = ''; // store index keyword paths
    $myts =& MyTextSanitizer::getInstance();
    foreach( explode( ',', $index_id ) as $xid ){
        if( xnp_get_certify_state( $xnpsid, $xid, $item_id, $state ) == RES_OK ){
            $index = array();
            if( xnp_get_index( $xnpsid, $xid, $index ) == RES_OK ){
                if( $op == 'cancel_certify' ){
                    $result = xnp_unregister_item( $xnpsid, $xid, $item_id );
                    if ( $result == RES_OK )
                        xnp_insert_event( $xnpsid, ETID_REJECT_ITEM, time(), $uid, xnpGetRemoteHost(), array( 'item_id' => $item_id, 'index_id' => $xid ) );
                }else if( $op == 'accept_certify' ){
                    $result = xnp_set_certify_state( $xnpsid, $xid, $item_id, CERTIFIED );
                    if ( $result == RES_OK ){
                        xnp_insert_event( $xnpsid, ETID_CERTIFY_ITEM, time(), $uid, xnpGetRemoteHost(), array( 'item_id' => $item_id, 'index_id' => $xid ) );
                        xnpGenerateRss( ); //update RSS
                    }
                }
                if( $result == RES_OK ){
                    $pathstr = xnpGetIndexPathString( $xnpsid, $xid );
                    $body_index .= $myts->undoHtmlSpecialChars($pathstr)."\n";
                }
            }
        }
    }
    if( $body_index != '' ){
        include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
        eval( "\$metaarray = ".$itemtype['name']."GetMetaInformation( \$item_id );" );
        $body_metadata = "";
        foreach( $metaarray as $k => $v ){ $body_metadata = $body_metadata."$k : $v\n"; }
        $xoopsMailer =& getMailer( );
        $xoopsMailer->useMail( );
        $xoopsMailer->setToEmails( $user['email'] );
        $xoopsMailer->setFromEmail( $xoopsConfig['adminmail'] );
        $xoopsMailer->setFromName( $xoopsConfig['sitename'] );
        if( $op == 'cancel_certify' ){
            $xoopsMailer->setSubject( _MD_XOONIPS_ITEM_CANCEL_CERTIFY_MAIL_SUBJECT );
            $xoopsMailer->setBody( _MD_XOONIPS_ITEM_CANCEL_CERTIFY_MAIL_BODY
                                   ."\n"
                                   ."\n"._MD_XOONIPS_ITEM_CANCEL_CERTIFY_INDEX_LABEL." : "
                                   .$body_index
                                   ."\n".$body_metadata
                                   ."\n"._MD_XOONIPS_ITEM_DETAIL_URL.": ".XOOPS_URL."/modules/xoonips/detail.php?item_id=$item_id\n" );
        }else if( $op == 'accept_certify' ){
            $xoopsMailer->setSubject( _MD_XOONIPS_ITEM_ACCEPT_CERTIFY_MAIL_SUBJECT );
            $xoopsMailer->setBody( _MD_XOONIPS_ITEM_ACCEPT_CERTIFY_MAIL_BODY
                                   ."\n"
                                   ."\n"._MD_XOONIPS_ITEM_ACCEPT_CERTIFY_INDEX_LABEL." : "
                                   .$body_index
                                   ."\n".$body_metadata
                                   ."\n"._MD_XOONIPS_ITEM_DETAIL_URL.": ".XOOPS_URL."/modules/xoonips/detail.php?item_id=$item_id\n" );
        }
        // send email to creator
        $xoopsMailer->send( );
    }
    
    $op = '';
}

if( $op == 'delete' ){
    include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
    eval( "\$result = ".$modname."DeleteItem( \$item_id );" );
    if( !$result ){
        redirect_header('index.php',3,"ERROR in delete item " );
    }else{
        redirect_header('index.php',3,"Succeed" );
    }
    exit();
}
if( $op == 'print' ){
    require_once XOOPS_ROOT_PATH.'/class/template.php';
    $xoopsTpl = new XoopsTpl();
    xoops_header(false);
    
    // get config of xoonips
    if ( !isset($xoopsConfigMetaFooter) )
        $xoopsConfigMetaFooter =& $config_handler->getConfigsByCat(XOOPS_CONF_METAFOOTER);
    //$xoopsTpl->assign('footer', $xoopsConfigMetaFooter['footer'] );
    $xoopsTpl->assign('meta_copyright', $xoopsConfigMetaFooter['meta_copyright'] );
    $xoopsTpl->assign('meta_author', $xoopsConfigMetaFooter['meta_author'] );
    $xoopsTpl->assign('sitename', $xoopsConfig['sitename'] );
    
    include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
    eval( "\$body = ".$modname."GetPrinterFriendlyDetailBlock( \$item_id );" );
    echo "</head><body onload='window.print();'>\n";
    $val = "";
    xnp_get_config_value( 'printer_friendly_header', $val );
    $xoopsTpl->assign('printer_friendly_header', $val );
    $xoopsTpl->assign('item_url', XOOPS_URL.'/modules/xoonips/detail.php?item_id=' . $item_id );
    $xoopsTpl->assign('body', $body );
    $xoopsTpl->display( "db:xoonips_detail_print.html" );
    xoops_footer();
    exit();
}

$config_handler =& xoops_gethandler('config');
$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
$xoopsOption['template_main'] = 'xoonips_detail.html';
include './header.php';

if( xnp_get_item_permission( $xnpsid, $item_id, OP_DELETE ) && $op != 'print' ){
    $xoopsTpl->assign('delete_button_visible', '1' );
}else{
    $xoopsTpl->assign('delete_button_visible', '0' );
}

if( xnp_get_item_permission( $xnpsid, $item_id, OP_MODIFY ) && $op != 'print' ){
    $xoopsTpl->assign('modify_button_visible', '1' );
}else{
    $xoopsTpl->assign('modify_button_visible', '0' );
}

if( $op != 'print' ){
    $xoopsTpl->assign('print_button_visible', '1' );
}else{
    $xoopsTpl->assign('print_button_visible', '0' );
}

$xoopsTpl->assign('item_id', $item_id );

$val = '';
if( xnp_is_moderator( $xnpsid, $uid )
    || xnp_get_config_value( 'export_enabled', $val ) == RES_OK && $val == 'on' ){
    // check this item can edit the index.
    
    // support export ?
    $func_export = $itemtypes[ $item['item_type_id'] ]['name']."ExportItem";
    include_once XOOPS_ROOT_PATH."/modules/".$itemtypes[ $item['item_type_id'] ]['viewphp'];
    if( function_exists( $func_export ) ){
        $xids = array();
        $result = xnp_get_index_id_by_item_id( $xnpsid, $item_id, $xids );
        if ( $result != RES_OK ){
            redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
        }
        foreach( $xids as $index_id ){
            $index = array();
            $result = xnp_get_index( $xnpsid, $index_id, $index );
            if( $result != RES_OK ) continue; // skip index if access forbidden(ex: other's index)
            if( $index['open_level'] == OL_PRIVATE && $index['owner_uid'] == $uid ||
                $index['open_level'] == OL_GROUP_ONLY && xnp_is_group_admin( $xnpsid, $index['owner_gid'], $uid ) ||
                $index['open_level'] == OL_PUBLIC && xnp_is_moderator( $xnpsid, $uid ) && $index['item_id'] != IID_BINDERS && $index['item_id'] != IID_ROOT ){
                $xoopsTpl->assign('export_enabled', 1 );
                break;
            }
        }
    }
}

function genSelectLabels( &$index ){
    $title = $index['title'];
    $indent_html = str_repeat( '&nbsp;&nbsp;', (int)($index['depth']));
    if ( isset( $index['child_count'] ) &&  $index['child_count'] != 0 )
        $childCount = '( ' . $index['child_count'] . ' )';
    else
        $childCount = '';
    $index['indent_html'] = $indent_html;
    $index['select_label'] = " $title $childCount";
}

// display of 'add to public'
if ( $op == '' ){
    // Display only 'Binder -> Binders'. Display 'Not Binder -> Public not Binders'.
    include_once 'include/gentree.php';
    $index = array( 'open_level' => OL_PUBLIC );
    $indexTree = genSameAreaIndexTree( $xnpsid, $uid, $index );
    $len = count( $indexTree );
    for ( $i = 0; $i < $len; $i++ ){
        if ( $item_type_id == ITID_BINDER && $indexTree[$i]['item_id'] != IID_BINDERS 
          || $item_type_id != ITID_BINDER && $indexTree[$i]['item_id'] == IID_BINDERS  )
            unset( $indexTree[$i] );
    }
    array_walk( $indexTree, 'genSelectLabels' );
    $xoopsTpl->assign( 'index_tree', $indexTree );
}

include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
eval( "\$body = ".$modname."GetDetailBlock( \$item_id );" );
$xoopsTpl->assign('body', $body );

// Record events(view item)
xnp_insert_event( $xnpsid, ETID_VIEW_ITEM, time(), $uid, xnpGetRemoteHost(), array( 'item_id' => $item_id ) );

include XOOPS_ROOT_PATH.'/footer.php';
?>
