<?php
//  page to edit items                                                          //
//  $Revision: 1.9.2.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //
session_cache_limiter( 'private' );
session_cache_expire( 5 );

$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';

include 'condefs.php';
include_once 'include/item_limit_check.php';
include_once 'include/lib.php';
include_once 'include/create_session.php';

xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

xnpEncodeMacSafariPost();
xnpEncodeMacSafariGet();
// if there is post_id, it restores $_POST.
if ( isset( $_GET['post_id'] ) && $_SERVER["REQUEST_METHOD"] == 'GET' ){
	$post_id = $_GET['post_id'];
	if ( isset( $_SESSION[$post_id] ) ){
		$_POST = unserialize( $_SESSION[$post_id] );
		//unset( $_SESSION[$post_id] );
	}
}


foreach( array( 'item_id' => 0 ) as $k => $v ){
    if( array_key_exists( $k, $_GET ) ){
        $$k = $_GET[$k];
    }else if( array_key_exists( $k, $_POST ) ){
        $$k = $_POST[$k];
    }else{
        $$k = $v;
    }
}

// If not a user, redirect
if ( !$xoopsUser ) {
	redirect_header(XOOPS_URL.'/modules/xoonips/index.php',3,_US_NOEDITRIGHT);
	exit();
}

$uid = $_SESSION['xoopsUserId'];

//Uncertified user can't access(except XOOPS administrator).
if( !$xoopsUser->isAdmin( $xoopsModule->getVar('mid') )
    && !xnp_is_activated( $xnpsid, $uid ) ){
  	redirect_header(XOOPS_URL.'/modules/xoonips/index.php', 3, _MD_XOONIPS_MODERATOR_NOT_ACTIVATED);
  	exit();
}
//User has no right to control items.
if( !xnp_get_item_permission( $xnpsid, $item_id, OP_MODIFY ) ){
  	redirect_header(XOOPS_URL.'/modules/xoonips/index.php', 3, _MD_XOONIPS_ITEM_FORBIDDEN );
  	exit();
}

$item = array();
if( xnp_get_item( $xnpsid, $item_id, $item ) != RES_OK ){
  	redirect_header(XOOPS_URL.'/modules/xoonips/index.php', 3, _MD_XOONIPS_ITEM_CANNOT_ACCESS_ITEM );
  	exit();
}
$item_type_id = $item['item_type_id'];

$select_item_type = array();
$itemtypes = array();
if( xnp_get_item_types( $itemtypes ) != RES_OK ){
    redirect_header(XOOPS_URL.'/modules/xoonips/index.php', 3, "ERROR xnp_get_item_types [AbstractLayer]".xnp_get_last_error_string());
    break;
}else{
    foreach( $itemtypes as $i){
        if( $i['item_type_id'] >= ITID_BINDER ){
            if( !isset( $item_type_id ) ){
                // set default item type id
                $item_type_id = $i['item_type_id'];
            }
            if( $i['item_type_id'] == $item_type_id ){
                $modname = $i['name'];
                $itemtype = $i;
            }
            $select_item_type[$i['display_name']]=$i['item_type_id'];
        }
    }
}

//index tree( checkbox enabled )
if ( $item_type_id == ITID_BINDER ){
	$xoonipsEditBinder = true;
}
$xoonipsTreeCheckBox = true;
$xoonipsURL = '';
$xoonipsCheckPrivate = 'nextButton';

$xoopsOption['template_main'] = 'xoonips_edit.html';
include XOOPS_ROOT_PATH.'/header.php';

$xoopsTpl->assign("next_url", "confirm_edit.php" );
//retrieve index ids
if( array_key_exists( 'xoonipsCheckedXID', $_POST ) ){
    $xoopsTpl->assign("xoonipsCheckedXID", $_POST['xoonipsCheckedXID']);
}else{
    $index_ids = array();
    xnp_get_index_id_by_item_id( $xnpsid, $item_id, $index_ids );
    $xoopsTpl->assign('xoonipsCheckedXID', implode( ',', $index_ids ) );
}
$xoopsTpl->assign("item_id", $item_id );

include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
eval( "\$body = ".$modname."GetEditBlock( \$item_id );" );

$xoopsTpl->assign('body', $body );

$account = array();
if( xnp_get_account( $xnpsid, $uid, $account ) == RES_OK ){
    $iids = array();
    if( xnp_get_private_item_id( $xnpsid, $uid, $iids ) == RES_OK ){
        $xoopsTpl->assign( 'num_of_items_current', count( $iids ) );
    }
    $xoopsTpl->assign( 'num_of_items_max', $account['item_number_limit'] );
    $xoopsTpl->assign( 'storage_of_items_max', sprintf( "%.02lf", $account['item_storage_limit'] / 1000 / 1000 ) );
    $xoopsTpl->assign( 'storage_of_items_current', sprintf( "%.02lf", filesize_private( ) / 1000 / 1000 ) );
	$xoopsTpl->assign('accept_charset', xnpGetMacSafariAcceptCharset() );
}

// If the page is made by POST, $_POST is made to save somewhere and page redirects.
if ( $_SERVER["REQUEST_METHOD"] == 'POST' ){
	$post_id = uniqid('postid');
	$_SESSION[$post_id] = serialize( $_POST );
	header( "HTTP/1.0 303 See Other" );
	header( "Location: " .  XOOPS_URL . "/modules/xoonips/edit.php?post_id=$post_id" );
	echo sprintf( _IFNOTRELOAD, XOOPS_URL . "/modules/xoonips/edit.php?post_id=$post_id" );
	//redirect_header("edit.php?post_id=$post_id", 5, "redirecting...");
	exit;
}

// The output( header("Cache-control: no-cache") etc ) is prevented by footer.php.
header('Content-Type:text/html; charset='._CHARSET);
echo "\r\n"; flush();

include XOOPS_ROOT_PATH.'/footer.php';
?>
