<?php
//  $Revision: 1.5.4.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

/* page to download event log (for moderators).
 * 
 * input:
 *    $_POST['StartDateYear' ]
 *    $_POST['StartDateMonth']
 *    $_POST['StartDateDay'  ]
 *    $_POST['EndDateYear'   ]
 *    $_POST['EndDateMonth'  ]
 *    $_POST['EndDateDay'    ]
 * 
 */

session_cache_limiter('none'); // Escape IE's Bug 1 -> http://jp2.php.net/header  Harry 10-Dec-2004 03:26

include '../../mainfile.php';
require_once 'include/create_session.php';
require_once 'include/lib.php';
require_once 'condefs.php';

function error($message){
	header("HTTP/1.0 500 Internal Server Error");
	echo "error:" . $message;
	exit;
}

function error403(){
	header("HTTP/1.0 403 Forbidden");
	echo "403 Forbidden";
	exit;
}

function error404(){
	header("HTTP/1.0 404 Not Found");
	echo "404 Not Found";
	exit;
}

xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

if( !$xoopsUser ) {
	redirect_header( 'index.php', 3, _NOPERM );
	exit();
}
$uid = $xoopsUser->getVar('uid');
if ( !xnp_is_moderator( $xnpsid, $uid ) ){
	redirect_header( 'index.php', 3, _MD_XOONIPS_MODERATOR_SHULD_BE_MODERATOR );
	exit();
}


if ( isset($_POST['StartDateYear']) ){
	// download CSV
	
	$StartDateYear  = (int)$_POST['StartDateYear' ];
	$StartDateMonth = (int)$_POST['StartDateMonth'];
	$StartDateDay   = (int)$_POST['StartDateDay'  ];
	$EndDateYear    = (int)$_POST['EndDateYear'   ];
	$EndDateMonth   = (int)$_POST['EndDateMonth'  ];
	$EndDateDay     = (int)$_POST['EndDateDay'    ];
	$filename = sprintf( '%04d%02d%02d-%04d%02d%02d.csv',$StartDateYear,$StartDateMonth,$StartDateDay,$EndDateYear,$EndDateMonth,$EndDateDay );
	$events = array();
	
	$startTime = mktime( 0, 0, 0, $StartDateMonth, $StartDateDay, $StartDateYear );
	$endTime   = mktime( 0, 0, 0, $EndDateMonth,   $EndDateDay,   $EndDateYear   ) + 60*60*24;
	$result = xnp_get_events( $xnpsid, $events, $startTime, $endTime );
	if ( $result != RES_OK ){
		error( "ERROR [AbstractLayer]".xnp_get_last_error_string() );
	}
	// If character's code changes automatic, it becomes invalid.
	if (function_exists('mb_http_output')){
		mb_http_output('pass');
	}

	header("Cache-Control: none");  // Escape IE's Bug 2
	//header("Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0"); // default cache-control's output
	header("Content-Type: text/csv");
	header("Content-Disposition: attachment; filename=\"$filename\"");
	//header("Content-Length: $size");

	function dquote($str)
	{
		return '"' . str_replace( '"', '""', $str ) . '"';
	}
	
	$event_types_str = explode( ',', _MI_XOONIPS_EVENT_LOG_EVENT_TYPES );
	
	$uid2uname = array( UID_GUEST => 'guest' );
	$result = $xoopsDB->query( "select uid, uname from " . $xoopsDB->prefix('users') );
	while ( list( $tmp_uid, $tmp_uname ) = $xoopsDB->fetchRow( $result ) ){
		$uid2uname[$tmp_uid] = $tmp_uname;
	}
	
	echo _MI_XOONIPS_EVENT_LOG_EVENT_COLUMNS . "\r\n"; // header
	//echo "<table border=1>\n";
	foreach ( $events as $event ){
		$event_type_str  = $event_types_str[$event['event_type_id']];
		$timestamp   = dquote( date( DATETIME_FORMAT, $event['timestamp']) );
		
		$exec_uid       = isset($event["exec_uid"       ]) ? $event["exec_uid"      ] : '';
		$index_id       = isset($event["index_id"       ]) ? $event["index_id"      ] : '';
		$item_id        = isset($event["item_id"        ]) ? $event["item_id"       ] : '';
		$file_id        = isset($event["file_id"        ]) ? $event["file_id"       ] : '';
		$tmp_uid        = isset($event["uid"            ]) ? $event["uid"           ] : '';
		$gid            = isset($event["gid"            ]) ? $event["gid"           ] : '';
		$remote_host    = isset($event["remote_host"    ]) ? dquote($event["remote_host"    ]) : '';
		$search_keyword = isset($event["search_keyword" ]) ? dquote($event["search_keyword" ]) : '';
		$additional_info= isset($event["additional_info"]) ? dquote($event["additional_info"]) : '';
		$login_name     = isset($event["exec_uid"       ]) ? $uid2uname[$exec_uid] : '';
		
		echo "$event_type_str,$timestamp,$exec_uid,$remote_host,$index_id,$item_id,$file_id,$tmp_uid,$gid,$search_keyword,$login_name,$additional_info\r\n";
		//echo "<tr><td>$event_type_str</td><td>$timestamp</td><td>$exec_uid</td><td>$remote_host</td><td>$index_id</td><td>$item_id</td><td>$file_id</td><td>$tmp_uid</td><td>$gid</td><td>$search_keyword</td><td>$login_name</td><td>$additional_info</td></tr>\r\n";
	}
	//echo "</table>\n";
	exit;
}

$xoopsOption['template_main'] = 'xoonips_event_log.html';
include XOOPS_ROOT_PATH.'/header.php';
$xoopsTpl->assign('time', time() );
$xoopsTpl->assign('start_year', 2005 );
$xoopsTpl->assign('end_year', date('Y') );
include XOOPS_ROOT_PATH.'/footer.php';

?>
