<?php
//  Process of Harvest in OAI-PMH
//  $Revision: 1.2.4.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

$xoopsOption['pagetype'] = 'user';
$xoopsOption['nocommon'] = '';
include_once "../../mainfile.php";
include_once XOOPS_ROOT_PATH.'/class/logger.php';
include_once XOOPS_ROOT_PATH.'/include/functions.php';

include_once XOOPS_ROOT_PATH.'/class/database/databasefactory.php';
$xoopsDB =& XoopsDatabaseFactory::getDatabaseConnection();

include_once XOOPS_ROOT_PATH.'/kernel/object.php';
include_once XOOPS_ROOT_PATH.'/class/criteria.php';
include_once XOOPS_ROOT_PATH."/class/module.textsanitizer.php";

$config_handler =& xoops_gethandler('config');
$xoopsConfig =& $config_handler->getConfigsByCat(XOOPS_CONF);

include_once 'oaiclass.php';

header( "Content-type: text/plain" );

global $xoopsDB;

$result = $xoopsDB -> query( "SELECT URL FROM ".$xoopsDB -> prefix( 'xoonips_oaipmh_repositories' )." WHERE enabled=1 AND deleted!=1 ORDER BY sort" );
set_time_limit( 0 );
while( list( $url ) = $xoopsDB -> fetchRow( $result ) ){
    echo "Trying\t$url\n";
    $h = new OAIPMHHarvester( $url );
    if( !$h -> harvest() ){
        echo 'ERROR:'.$h -> last_error( );
    }else{
        echo "Succeed\t${url}\n";
    }
    echo "\n";
}
?>
