<?php
//  $Revision: 1.11.2.5 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

/**
   
   op='upload' .... upload inport files
     $_FILE['zipfile'][...]: information of uploaded files
     $xoonipsCheckedXID: id of index to import (comma separated)
   
   op='import' .... import
     $zipfile: name of uploaded file
     $xids[]:  id of index to import
     $ids[]:   temporary id of item to import(temporary id in import file)
     
 */

$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';

include 'condefs.php';
include_once 'include/lib.php';
include_once 'include/imexport.php';
require_once 'include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];


if ( !$xoopsUser ) {
    redirect_header( XOOPS_URL.'/index.php',3,_MD_XOONIPS_ITEM_FORBIDDEN);
    exit();
}

$uid = $_SESSION['xoopsUserId'];

//Uncertified user can't access(except XOOPS administrator).
if( !$xoopsUser->isAdmin( $xoopsModule->getVar('mid') )
    && !xnp_is_activated( $xnpsid, $uid ) ){
    redirect_header( XOOPS_URL.'/index.php', 3, _MD_XOONIPS_MODERATOR_NOT_ACTIVATED);
    exit();
}
//User(Not Moderater) can't control(except XOOPS administrator).
$private_import_enabled = "";
if( !$xoopsUser->isAdmin( $xoopsModule->getVar( 'mid' ) )
	&& !xnp_is_moderator( $xnpsid, $uid ) ) {
	// If Xoonips user are forbidden to import files, returns error.
	if( xnp_get_config_value( 'private_import_enabled', $private_import_enabled ) != RES_OK
		|| $private_import_enabled != 'on' ){
		redirect_header( XOOPS_URL.'/index.php', 3, _MD_XOONIPS_MODERATOR_SHULD_BE_MODERATOR );
		exit(  );
	}
}

foreach( array( 'op' => '',
                'index_id' => '',
                'zipfile' => '',
                'xoonipsCheckedXID' => '',
                'xids' => array(),
                'ids' => array() ) as $k => $v ){
    if( isset( $_GET[ $k ] ) ){
        $$k = $_GET[ $k ];
    }else if( isset( $_POST[ $k ] ) ){
        $$k = $_POST[ $k ];
    }else{
        if( isset( $v ) ){
            $$k = $v;
        }
    }
}

require_once 'include/unzip.php';

$config_handler =& xoops_gethandler('config');
$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
if( $op == 'upload' && $_FILES['zipfile']['name'] != '' && $_FILES['zipfile']['size'] > 0 ){
    $itemtypes = array();
    $tmp = array();
    if( xnp_get_item_types( $tmp ) != RES_OK ){
        redirect_header(XOOPS_URL.'/index.php', 3, "ERROR xnp_get_item_types [AbstractLayer]".xnp_get_last_error_string());
        break;
    }else{
        foreach( $tmp as $i){
            $itemtypes[$i['item_type_id']]=$i;
        }
        foreach( $tmp as $i){
            $itemtypes[$i['name']]=$i;
        }
    }
    
    if( $private_import_enabled == 'on' ){
        // selected index_id is writable or not ?
        // XooNIps user import files:The index outside of Private area is excluded.
        $removed_xid = array(); // array of index_ids of not private indexes.
        $xids = array(); // array of index_ids of private indexes.
        if( strlen( trim( $xoonipsCheckedXID ) ) > 0 ){
            foreach( explode( ",", $xoonipsCheckedXID ) as $key => $xid ){
                $index = array();
                if( xnp_get_index( $xnpsid, $xid, $index ) != RES_OK ){
                    redirect_header(XOOPS_URL.'/index.php', 3, "ERROR xnp_get_index [AbstractLayer]".xnp_get_last_error_string());
                    break;
                }
                if( $index['open_level'] != OL_PRIVATE ){
                    $removed_xid[] = $xid;
                }else{
                    $xids[] = $xid;
                }
            }
        }
        $xoonipsCheckedXID = implode( ",", $xids );
        if( count( $removed_xid ) > 0 ){
            include XOOPS_ROOT_PATH.'/header.php';
            $errmsg = "<font color=\"#FF0000\">"._MD_XOONIPS_IMPORT_INDEX_CANNOT_WRITE;
            foreach( $removed_xid as $xid ){
                $errmsg = $errmsg."<br/>\n".xnpGetIndexPathString( $xnpsid, $xid );
            }
            $errmsg = $errmsg."</font>";
        }
    }

    $info = pathinfo( $_FILES['zipfile']['tmp_name'] );
    $uploadfile = tempnam( $info['dirname'], 'XNP' );
    unlink( $uploadfile );
    
    if( !move_uploaded_file($_FILES['zipfile']['tmp_name'], $uploadfile) ){
        die( "Possible file upload attack!\n" );
    }
    
    include XOOPS_ROOT_PATH.'/header.php';
        
    $hdl = fopen( $uploadfile, 'rb' );
    if( !$hdl ) exit( "can't open file ".$uploadfile );
    $item_htmls = array();
    fseek( $hdl, 0, SEEK_SET );
    $entries = unzip_all_entries( $hdl );
    foreach( $entries as $entry ){
        if( $entry['filename'] == 'index.xml' ){
            //index_limit check
            $import_indexes = array();
            $xml = unzip_read_data( $entry );
            xnpImportIndexCheck( $xml, $import_indexes );
            
            $indexes = array();
            $result = xnp_get_all_indexes( $xnpsid, array(), $indexes );
            if ( $result != RES_OK ){
                redirect_header(XOOPS_URL.'/modules/xoonips/import.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
                break;
            }
            $indexesLen = count($indexes);
            
            $indexCount = 0;
            for ( $i = 0; $i < $indexesLen; $i++ ){
                if ( $indexes[$i]['owner_uid'] == $uid )
                    $indexCount++;
            }
            
            $account = array();
            if( xnp_get_account( $xnpsid, $uid, $account ) != RES_OK ){
                redirect_header(XOOPS_URL.'/modules/xoonips/import.php',3, "ERROR xnp_get_account [AbstractLayer]".xnp_get_last_error_string());
                break;
            }
            $indexNumberLimit = $account['index_number_limit'];
            if( $indexCount + count( $import_indexes ) > $account['index_number_limit'] ){
                echo _MD_XOONIPS_IMPORT_INDEX_NUMBER_LIMIT_OVER_FLOW;
                echo "<p>\n<a href=\"".XOOPS_URL.'/modules/xoonips/import.php'."\">"._MD_XOONIPS_ITEM_BACK_BUTTON_LABEL."</a></p>\n";
                include XOOPS_ROOT_PATH.'/footer.php';
                exit();
            }
            
            continue;
        }
        $xml = unzip_read_data( $entry );
        xnpImportItemCheck( $xml, $basic, $ids );
        while( list( $key, $val ) = each( $basic ) ){
            //change into expression of multi byte characters for display
            $basic[ $key ] = encodeClient2Server( $val );
        }
        //this item type can be imported?
        if( !array_key_exists( $basic['itemtype'] , $itemtypes ) )
            continue; //the itemtype not installed.
        $itemtype = $itemtypes[ $basic['itemtype'] ];
        include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
        $func = "${itemtype['name']}GetImportHandler";
        if( !function_exists( $func ) )
            continue; // item type module doesn't support import
        
        if( count( $ids ) == 0 ){
            $item_htmls[] = array( 'import_item' => $basic );
            continue; // no conflict item
        }
        
        //update itemtype name -> itemtype display_name
        if( !array_key_exists( $basic['itemtype'] , $itemtypes ) ) continue; //the itemtype not installed.
        $basic['itemtype'] = $itemtypes[ $basic['itemtype'] ]['display_name'];

        $htmls = array();
        foreach( $ids as $id ){
            $i = array();
            if( xnp_get_item( $xnpsid, $id, $i ) != RES_OK ) next;
            if( array_key_exists( $i['item_type_id'], $itemtypes ) ){
                $itemtype = $itemtypes[ $i['item_type_id'] ];
                $modname = $itemtype['name'];
                include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
                $html = '';
                eval( "\$html = ".$modname."GetListBlock( \$i );" );
            }
            $htmls[] = array( 'html' => $html, 'item_id' => $i['item_id'] );
        }
        $item_htmls[] = array( 'import_item' => $basic,
                               'conflict_items' => $htmls );
    }
    
    $xoopsOption['template_main'] = 'xoonips_import_item.html';
	if( isset( $errmsg ) ) $xoopsTpl -> assign( 'message', $errmsg );
    $xoopsTpl->assign('zipfile', $uploadfile );
    $xoopsTpl->assign('items', $item_htmls );
    if( $xoonipsCheckedXID != '' ) 
        $xoopsTpl->assign('xoonipsCheckedXID', explode( ',', $xoonipsCheckedXID ) );
    include XOOPS_ROOT_PATH.'/footer.php';
    
    exit();
}

if( $op == 'import' ){
    if( count( $ids ) == 0 ){
        include XOOPS_ROOT_PATH.'/header.php';
        echo _MD_XOONIPS_IMPORT_NO_ITEMS_IMPORTED;
        include XOOPS_ROOT_PATH.'/footer.php';
        exit();
    }
    //item_limit check
    $item_ids = array();
    if( xnp_get_private_item_id( $xnpsid, $uid, $item_ids ) != RES_OK ){
        redirect_header(XOOPS_URL.'/modules/xoonips/import.php', 3, "ERROR xnp_get_private_item_id [AbstractLayer]".xnp_get_last_error_string());
        break;
    }
    $account = array();
    if( xnp_get_account( $xnpsid, $uid, $account ) != RES_OK ){
        redirect_header(XOOPS_URL.'/modules/xoonips/import.php', 3, "ERROR xnp_get_account [AbstractLayer]".xnp_get_last_error_string());
        break;
    }
    if( count( $ids ) + count( $item_ids ) > $account['item_number_limit'] ){
        include XOOPS_ROOT_PATH.'/header.php';
        echo _MD_XOONIPS_IMPORT_ITEM_NUMBER_LIMIT_OVER_FLOW;
        echo "<p>\n<a href=\"".XOOPS_URL.'/modules/xoonips/import.php'."\">"._MD_XOONIPS_ITEM_BACK_BUTTON_LABEL."</a></p>\n";
        include XOOPS_ROOT_PATH.'/footer.php';
        exit();
    }
    
    if( !isset( $zipfile ) ) die( "file not specified" );
    $hdl = fopen( $zipfile, 'rb' );
    if( !$hdl ) die( "can't open file ".$zipfile );
    $private_index_id = 0;
    
    //is private index given ?
    foreach( $xids as $index_id ){
        $index = array();
        if( xnp_get_index( $xnpsid, $index_id, $index ) != RES_OK ) next;
        if( $index['owner_uid'] == $uid && $index['open_level'] == OL_PRIVATE ){
            $private_index_id = $index_id;
            break;
        }
    }
    
    //create index named 'ImportedItems(...)' if no private indexes are given
    if( $private_index_id == 0 ){
        $account = array();
        $index = array();
        if( xnp_get_account( $xnpsid, $uid, $account ) != RES_OK )
            redirect_header( XOOPS_URL.'/modules/xoonips/import.php', 3, _MD_XOONIPS_IMPORT_ERROR );
        if( xnp_get_index( $xnpsid, $account['private_index_id'], $index ) != RES_OK )
            redirect_header( XOOPS_URL.'/modules/xoonips/import.php', 3, _MD_XOONIPS_IMPORT_ERROR );
        $index['parent_index_id'] = $account['private_index_id'];
        $index['title'] = strftime("ImportedItems(%Y%m%d%H%M%S)");
        if( xnp_insert_index( $xnpsid, $index, $private_index_id ) != RES_OK )
            redirect_header( XOOPS_URL.'/modules/xoonips/import.php', 3, _MD_XOONIPS_IMPORT_ERROR );
        $xids[] = $private_index_id;
    }
    
    //import item
    $id_table = array();
    fseek( $hdl, 0, SEEK_SET );
    $entries = unzip_all_entries( $hdl );
    foreach( $entries as $entry ){//while( $entry = unzip_next_entry( $hdl ) ){
        if( $entry['filename'] == 'index.xml' ) continue;
        $xml = unzip_read_data( $entry );
        if( !xnpImportItem( $xml, $id_table, $ids, $error ) ){
            echo "ERROR $error";
            echo "id_table="; print_r( $id_table );
        }
    }
    
    $has_index = false;
    foreach( $xids as $index_id ){
        //import indexes
        fseek( $hdl, 0, SEEK_SET );
        $entries = unzip_all_entries( $hdl );
        foreach( $entries as $entry ){//while( $entry = unzip_next_entry( $hdl ) ){
            if( $entry['filename'] == 'index.xml' ){
                $xml = unzip_read_data( $entry );
                if( !xnpImportIndex( $xml, $index_id, $id_table, $error ) ){
                    echo "ERROR $error";
                    echo "id_table="; print_r( $id_table );
                }
                $has_index = true;
                break;
            }
        }
        if( $has_index ){
            fseek( $hdl, 0, SEEK_SET );
            $entries = unzip_all_entries( $hdl );
            foreach( $entries as $entry ){//while( $entry = unzip_next_entry( $hdl ) ){
                if( $entry['filename'] != 'index.xml' ){
                    if( !xnpImportItemLink( unzip_read_data( $entry ), $id_table, $error ) ){
                        echo "ERROR $error";
                    }
                }
            }
        }
    }
    if( !$has_index ){
        //registration of index in import item(not contained index.xml)
        //register in index of 'ImportedItems' made automatic
        foreach( $xids as $index_id ){
            foreach( $id_table as $k => $item_id ){
                xnp_register_item( $xnpsid, $index_id, $item_id );
            }
        }
    }
    
    //import related_to
    fseek( $hdl, 0, SEEK_SET );
    xnp_use_syslog(true);
    $entries = unzip_all_entries( $hdl );
    foreach( $entries as $entry ){//while( $entry = unzip_next_entry( $hdl ) ){
        if( $entry['filename'] == 'index.xml' ) continue;
        $xml = unzip_read_data( $entry );
        if( !xnpImportRelatedTo( $xml, $id_table, $ids, $error ) ){
            echo "ERROR $error";
            echo "id_table="; print_r( $id_table );
        }
    }

    fclose( $hdl );
    unlink( $zipfile );
    
    ob_start();
    include XOOPS_ROOT_PATH.'/header.php';
    echo _MD_XOONIPS_IMPORT_IMPORT_SUCCESSFULLY;
    include XOOPS_ROOT_PATH.'/footer.php';
    ob_end_flush();

    exit();
}


$xoonipsTreeCheckBox = true;
$xoonipsHideBinders = true;
$xoonipsEditIndex = true; //only import into editable index
    
include XOOPS_ROOT_PATH.'/header.php';
include_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";
?>
<script type="text/javascript" 	src="treelib.js">
</script>
<script type="text/javascript">
<!--
function getCheckedIndexes( form1 ){
	xoonipsGetDocTreeView2();
	xoonipsSaveTreeState2(xoonipsDocTreeView2);
	form1.xoonipsCheckedXID.value = xoonipsCheckState2;
	return true;
}
//-->
</script>

<p>
<? echo _MD_XOONIPS_IMPORT_PANKUZU_IMPORT; ?>
<? echo _MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR; ?>
<? echo _MD_XOONIPS_IMPORT_PANKUZU_UPLOAD_FILE; ?>
</p>

<form enctype="multipart/form-data" action="import.php" method="POST" onSubmit="return getCheckedIndexes(this);">
<input type='hidden' name='op' value='upload'>
<input type='hidden' name='xoonipsCheckedXID' value='<? echo $xoonipsCheckedXID; ?>'>
<table class='outer'>
 <tr>
  <th colspan='2'><? echo _MD_XOONIPS_IMPORT_TITLE ?></th>
 </tr>
 <tr>
  <td class='odd' nowrap>
   <? echo _MD_XOONIPS_IMPORT_FILE; ?>
   <?
      if( !array_key_exists( 'zipfile', $_FILES )
          || !array_key_exists( 'name', $_FILES['zipfile'] )
          || $_FILES['zipfile']['tmp_name'] == '' 
          || $_FILES['zipfile']['size'] == 0 ){ print "<font color='#ff0000'>"._MD_XOONIPS_IMPORT_REQUIRED."</font>"; }
          ?>
  </td>
  <td class='odd' width='70%'>
   <input name="zipfile" type="file" size='40'/>
  </td>
 </tr>
 <tr>
  <td class='even' nowrap>
   <? echo _MD_XOONIPS_IMPORT_INDEX; ?>
        <?/* if( $xoonipsCheckedXID == '' ){ print "<font color='#ff0000'>"._MD_XOONIPS_IMPORT_REQUIRED."</font>"; }*/ ?>
  </td>
  <td class='even' width='70%'>
   <? echo _MD_XOONIPS_IMPORT_INDEX_TEXT; ?>
  </td>
 </tr>
 <tr>
  <td class='odd' colspan='2'><input type='submit' value='<? echo _MD_XOONIPS_IMPORT_UPLOAD_SUBMIT; ?>'/></td>
 </tr>
</table>

</form>

<?  
include XOOPS_ROOT_PATH.'/footer.php';
?>

