<?php

// include language definition for messages
if ( file_exists(XOOPS_ROOT_PATH."/modules/xoonips/language/".$xoopsConfig['language']."/main.php") ) {
    include_once XOOPS_ROOT_PATH."/modules/xoonips/language/".$xoopsConfig['language']."/main.php";
} else {
    if ( file_exists(XOOPS_ROOT_PATH."/modules/xoonips/language/english/main.php") ) {
        include_once XOOPS_ROOT_PATH."/modules/xoonips/language/english/main.php";
    }
}
include_once XOOPS_ROOT_PATH.'/modules/xoonips/condefs.php';
/* Functions to load AL, initialize AL, make session. 
 * $Revision: 1.9.2.2 $
 */
	
	/** Load and initialize AL
	 @return 0 succeess
	 @return 1 bad config
	 @return 2 cannot initialize
	 @return 3 cannot dl(); enable_dl is off
	 @return 4 cannot dl(); enable_dl is on
	 @return 5 dsn is empty
	 */
	function xnp_load_al_silent(){
		global $xoopsDB;
		
		static $last_result = null;
		if ( isset( $last_result ) )
			return $last_result;
		
		if (ini_get('enable_dl') == '') {
			return $last_result=3;
		}
		
		// get AL's path
		$path = 'XNPAL.so';

		// load AL
		if (!extension_loaded(basename($path, '.so'))) {
		  if (!dl($path)){
		    return $last_result=4;
		  }
		}

		// get DSN
		$mhandler =& xoops_gethandler('module');
		$module = $mhandler->getByDirname( 'xoonips' );
		$chandler = & xoops_gethandler('config');
		$assoc = $chandler->getConfigsByCat(false, $module->mid());
		$dsn = $assoc['dsn'];
		if (empty($dsn)) {
			return $last_result=5;
		}
		
		
		// initialize AL
		$result = xnp_initialize_db( $dsn, XOOPS_DB_USER, XOOPS_DB_PASS, XOOPS_DB_NAME, XOOPS_DB_PREFIX );
		if ($result != 0) {
			return $last_result=2;
		}
		return $last_result=0;
	}
	
	
	/** process the error code in xnp_load_al_silent()
		@param result  error code
		@return nothing
	 */
	function xnp_load_al_error( $result ){
		if ($result > 0) {
			if ($result == 1) {
				redirect_header(XOOPS_URL.'/index.php', 5, _MD_XOONIPS_ACCOUNT_BAD_CONFIG);
			}
			else if ($result == 2) {
				redirect_header(XOOPS_URL.'/index.php', 5, _MD_XOONIPS_ACCOUNT_CANNOT_INITIALIZE_AL);
			}
			else if ($result == 3) {
				redirect_header(XOOPS_URL.'/index.php', 5, "enable_dl off");
			}
			else if ($result == 4) {
				redirect_header(XOOPS_URL.'/index.php', 5, "cannot load");
			}
			else if ($result == 5) {
				redirect_header(XOOPS_URL.'/index.php', 5, _MD_XOONIPS_ACCOUNT_DSN_EMPTY);
			}
			else
				echo "ERROR: $result " . __FILE__ . "/" . __LINE__;
			exit;
		}
	}
	
	/** load and initialize AL. 
		If error occurs, display error messages and move to top page.
		@param nothing
		@return nothing
	 */
	function xnp_load_al(){
		global $xoopsConfig;
		if ( file_exists(XOOPS_ROOT_PATH.'/modules/xoonips/language/'.$xoopsConfig['language'].'/main.php') ) {
			require_once XOOPS_ROOT_PATH.'/modules/xoonips/language/'.$xoopsConfig['language'].'/main.php';
		} else {
			require_once XOOPS_ROOT_PATH.'/modules/xoonips/language/english/main.php';
		}
		
		$result = xnp_load_al_silent();
		if ($result > 0)
			xnp_load_al_error( $result );
	}
	
	/** load, initialize, and make sessions. 
	 *	Sessions are displayed to $_SESSION '[XNPSID]'.
	 */
	function xnp_load_init_create_session_silent(){
		global $xoopsDB;
		static $last_result = null;
		if ( isset( $last_result ) )
			return $last_result;
		
		$result = xnp_load_al_silent();
		if ( $result > 0 )
			return $last_result = $result;
		
		if ( !isset( $_SESSION['xoopsUserId'] ) || (int)($_SESSION['xoopsUserId']) == 0 ){
			// no uid => guest user
			$_SESSION['XNPSID'] = XNPSID_GUEST;
			// unset( $_SESSION['XNPSID'] ); // guest sid
		}
		else if ( !isset( $_SESSION['XNPSID'] ) || !xnp_is_valid_session_id( $_SESSION['XNPSID'] ) ){
			// uid exists and XNPSID is Invarid or 0.
			// => User is XOOPS user, or XooNIps user Uncertified, or XooNIps user immediately after login.
			
			// Need to record timeout event, before create_session deletes session timeout.
			$session_table = $xoopsDB->prefix('xoonips_session');
			$sql = "select sid, uid, unix_timestamp(timestamp) from $session_table where unix_timestamp(timestamp)+" . SESSION_TIMEOUT_SEC . " < unix_timestamp(now())";
			$result = $xoopsDB->query($sql);
			while ( list($sid_tmp, $uid_tmp, $timestamp) = $xoopsDB->fetchRow($result) ){
				xnp_insert_event( XNPSID_GUEST, ETID_LOGOUT, $timestamp+SESSION_TIMEOUT_SEC, $uid_tmp, '', array() );
			}
			$xoopsDB->queryF( "delete from $session_table where unix_timestamp(timestamp)+" . SESSION_TIMEOUT_SEC . " < unix_timestamp(now())" );
			
			$result = xnp_create_session( session_id(), (int)$_SESSION['xoopsUserId'], $XNPSID );
			if ( $result != 0 ){
				// When user is a XOOPS user but not a XooNIps user, user is locked out from XOOPS. 
				// Following, quote from user.php.
				$_SESSION = array();
				session_destroy();
				if ( isset($xoopsConfig) && $xoopsConfig['use_mysession'] && $xoopsConfig['session_name'] != '') {
				    setcookie($xoopsConfig['session_name'], '', time()- 3600, '/',  '', 0);
				}
				// clear entry from online users table
				if (isset($xoopsUser) && is_object($xoopsUser)) {
				    $online_handler =& xoops_gethandler('online');
				    $online_handler->destroy($xoopsUser->getVar('uid'));
				}
				redirect_header(XOOPS_URL.'/index.php', 3, _MD_XOONIPS_ACCOUNT_NOT_ACTIVATED);
			}
			else
				$_SESSION['XNPSID'] = $XNPSID; // XooNIps user immediately after login
		}
		else {
			// If XNPSID is valid, the user is XooNIps user.
			;
		}
		return $last_result = 0;
	}

	function xnp_load_init_create_session(){
		global $xoopsConfig;
		if ( file_exists(XOOPS_ROOT_PATH.'/modules/xoonips/language/'.$xoopsConfig['language'].'/main.php') ) {
			require_once XOOPS_ROOT_PATH.'/modules/xoonips/language/'.$xoopsConfig['language'].'/main.php';
		} else {
			require_once XOOPS_ROOT_PATH.'/modules/xoonips/language/english/main.php';
		}
		
		$result = xnp_load_init_create_session_silent();
		if ( $result > 0 )
			xnp_load_al_error( $result );
	}
?>
