<?php
//  Install script for moderator module                                         //
//  $Revision: 1.13.2.5 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

require_once XOOPS_ROOT_PATH . '/modules/xoonips/condefs.php';

function xoonips_get_default_configs(){
	$configs = array(
		'moderator_gid'                 => array( 'type' => 'i'  , 'value' => ''         ),
		'certify_user'                  => array( 'type' => 's'  , 'value' => 'on'       ),
		'certify_item'                  => array( 'type' => 's'  , 'value' => 'on'       ),
		'public_item_target_user'       => array( 'type' => 's'  , 'value' => 'all'      ),
		'upload_dir'                    => array( 'type' => 's'  , 'value' => ''         ),
		'account_realname_optional'     => array( 'type' => 's'  , 'value' => 'off'      ),
		'account_address_optional'      => array( 'type' => 's'  , 'value' => 'off'      ),
		'account_division_optional'     => array( 'type' => 's'  , 'value' => 'off'      ),
		'account_tel_optional'          => array( 'type' => 's'  , 'value' => 'off'      ),
		'account_company_name_optional' => array( 'type' => 's'  , 'value' => 'off'      ),
		'account_country_optional'      => array( 'type' => 's'  , 'value' => 'off'      ),
		'account_zipcode_optional'      => array( 'type' => 's'  , 'value' => 'off'      ),
		'account_fax_optional'          => array( 'type' => 's'  , 'value' => 'off'      ),
		'private_item_number_limit'     => array( 'type' => 'i'  , 'value' => '100'      ),
		'private_index_number_limit'    => array( 'type' => 'i'  , 'value' => '50'       ),
		'private_item_storage_limit'    => array( 'type' => 'dm' , 'value' => '50000000' ),
		'group_item_number_limit'       => array( 'type' => 'i'  , 'value' => '300'      ),
		'group_index_number_limit'      => array( 'type' => 'i'  , 'value' => '200'      ),
		'group_item_storage_limit'      => array( 'type' => 'dm' , 'value' => '100000000'),
		'amazon_associates_id'          => array( 'type' => 's'  , 'value' => ''         ),
		'export_attachment'             => array( 'type' => 's'  , 'value' => 'off'      ),
		'export_enabled'                => array( 'type' => 's'  , 'value' => 'off'      ),
		'rss_file_path'                 => array( 'type' => 's'  , 'value' => ''         ),
		'rss_item_max'                  => array( 'type' => 'i'  , 'value' => '10'       ),
		'tree_frame_width'              => array( 'type' => 's'  , 'value' => '100%'     ),
		'tree_frame_height'             => array( 'type' => 's'  , 'value' => '400'      ),
		'printer_friendly_header'       => array( 'type' => 's'  , 'value' => ''         ),
		'repository_institution'        => array( 'type' => 's'  , 'value' => 'meta_author' ),
		'repository_publisher'          => array( 'type' => 's'  , 'value' => 'meta_author' ),
		'repository_name'               => array( 'type' => 's'  , 'value' => ''         ),
		'repository_nijc_code'          => array( 'type' => 's'  , 'value' => ''         ),
		'repository_deletion_track'     => array( 'type' => 's'  , 'value' => '30'       ),
		'download_file_compression'     => array( 'type' => 's'  , 'value' => 'on'       ),
		'private_import_enabled'        => array( 'type' => 's'  , 'value' => 'off'      )
	);
	return $configs;
}

// Unset items in xoonips_config is set.
function xoonips_insert_default_configs(){
	$configs = xoonips_get_default_configs();
	global $xoopsDB;
	$table = $xoopsDB->prefix('xoonips_config');
	foreach ( $configs as $key => $ar ){
		$escKey = addslashes( $key );
		$escVal = addslashes( $ar['value'] );
		
		$result = $xoopsDB->query( "select value from $table where name='$escKey'" );
		if ( $xoopsDB->getRowsNum($result) == 0 ){
			$result = $xoopsDB->query( "insert into $table ( name, value ) values ('$escKey', '$escVal' )" );
		}
	}
}

function xoonips_query( $sql ){
	global $xoopsDB;
	$result = $xoopsDB->queryF( $sql );
	if ( $result == FALSE ){
		echo "ERROR: SQL=$sql<br>\n error=" . mysql_error() . "<br>\n";
	}
	return $result;
}

function xoonips_get_config( $name ){
	global $xoopsDB;
	$esc_name = addslashes($name);
	$table = $xoopsDB->prefix('xoonips_config');
	$result = xoonips_query( "select value from $table where name='$esc_name'" );
	list( $value ) = $xoopsDB->fetchRow( $result );
	return $value;
}

// display config in $bid blocks
function xoonips_set_block_visible( $bid, $visible ){
	$block = new XoopsBlock();
	$block->load( $bid );
	$block->setVar( 'visible', $visible ? 1 : 0 );
	$block->store();
	
	// set to display all pages
	// module_id = 0:all pages, -1:Top
	global $xoopsDB;
	if ( $visible )
		$xoopsDB->query( "insert into ".$xoopsDB->prefix('block_module_link')." (block_id, module_id) values ( $bid, 0 )" );
}



function xoops_module_install_xoonips( $xoopsMod ) {
	global $xoopsUser;
	$error = false; //!< true if error occured	
	
	$module_handler =& xoops_gethandler('module');
	$module =& $module_handler->getByDirname('xoonips');
	if( $module ){
		// make moderator group
		$member_handler =& xoops_gethandler('member');
		$group =& $member_handler->createGroup();
		$group->setVar("name", "moderator");
		$group->setVar("description", "platform moderator");
		if (!$member_handler->insertGroup($group)) {
			xoops_cp_header();
			echo $group->getHtmlErrors();
			xoops_cp_footer();
		} else {
			// config of access right and visible config (groups and modules, groups and blocks)
			$mid = $module->getVar('mid'); // $xoopsMod->getVar('mid');
			$groupid = $group->getVar('groupid');
			$groupid_registered = 2;
			$groupid_anonymous = 3;
			
			$block_objects =& XoopsBlock::getByModule( $mid );
			$bids = array();
			foreach( $block_objects as $o )
				$bids[$o -> getVar( 'show_func' )] = $o -> getVar( 'bid' ); // it is problem that user search by name when languages change.
			
			if ( !isset($bids['b_xoonips_login_show'    ]) ) $error = true;
			if ( !isset($bids['b_xoonips_user_show'     ]) ) $error = true;
			if ( !isset($bids['b_xoonips_group_show'    ]) ) $error = true;
			if ( !isset($bids['b_xoonips_moderator_show']) ) $error = true;
			if ( !isset($bids['b_xoonips_tree_show'     ]) ) $error = true;
			
			$gperm_handler =& xoops_gethandler('groupperm');
			$gperm_handler->addRight( 'module_read', $mid                             , $groupid_anonymous  );
			$gperm_handler->addRight( 'block_read' , $bids['b_xoonips_login_show'    ], $groupid_anonymous  );
			$gperm_handler->addRight( 'block_read' , $bids['b_xoonips_user_show'     ], $groupid_registered );
			$gperm_handler->addRight( 'block_read' , $bids['b_xoonips_group_show'    ], $groupid_registered );
			$gperm_handler->addRight( 'block_read' , $bids['b_xoonips_tree_show'     ], $groupid_anonymous  );
			$gperm_handler->addRight( 'block_read' , $bids['b_xoonips_moderator_show'], $groupid            );
			$gperm_handler->addRight( 'block_read' , $bids['b_xoonips_tree_show'     ], $groupid_anonymous  );
			
			xoonips_set_block_visible( $bids['b_xoonips_login_show'     ], true );
			xoonips_set_block_visible( $bids['b_xoonips_user_show'      ], true );
			xoonips_set_block_visible( $bids['b_xoonips_group_show'     ], true );
			xoonips_set_block_visible( $bids['b_xoonips_moderator_show' ], true );
			xoonips_set_block_visible( $bids['b_xoonips_tree_show'      ], true );
			
			$bid_login = 2; // login block's bid
			xoonips_set_block_visible( $bid_login                        , false );
			
			// Startpage of XOOPS is XooNIps.
			$config_handler =& xoops_gethandler('config');
			$criteria = new CriteriaCompo();
			$criteria->add(new Criteria('conf_modid', 0));
			$criteria->add(new Criteria('conf_catid', XOOPS_CONF/*1*/));
			$criteria->add(new Criteria('conf_name', 'startpage'));
			$configs =& $config_handler->getConfigs($criteria);
			$new_value = "xoonips";
			if ( count( $configs ) != 1 ){
				$error = true;
			}
			else {
				$config = $configs[0];
				$config->setConfValueForInput($new_value);
				$config_handler->insertConfig($config);
				
				// add read permission for the start module to all groups
				$groups =& $member_handler->getGroupList();
				foreach ($groups as $groupid2 => $groupname) {
					if (!$gperm_handler->checkRight('module_read', $mid, $groupid2)) {
						$gperm_handler->addRight('module_read', $mid, $groupid2);
					}
				}
			}
			
			// delete the right to access moderator block from registered user.
			$criteria = new CriteriaCompo();
			$criteria->add( new Criteria( 'gperm_groupid', $groupid_registered ) );
			$criteria->add( new Criteria( 'gperm_itemid', $bids['b_xoonips_moderator_show'] ) );
			$criteria->add( new Criteria( 'gperm_name', 'block_read' ) );
			
			$objects = $gperm_handler->getObjects($criteria);
			if ( count( $objects ) == 1 ){
				$gperm_handler->delete( $objects[0] );
			}
			
			// set moderator_gid
			global $xoopsDB;
			$result = $xoopsDB->query(sprintf("DELETE FROM %s WHERE name='moderator_gid'", $xoopsDB->prefix("xoonips_config")));
			$result = $xoopsDB->query(sprintf("INSERT INTO %s (name, value) VALUES ('moderator_gid', %s)", $xoopsDB->prefix("xoonips_config"), $groupid ));
			if( !$result ){
				$error = true; //database query error
			}
			
			// The user that installed XooNips module is set to be XooNIps moderator(to pickup user and to certify users).
			$private_item_number_limit  = (int)xoonips_get_config('private_item_number_limit');
			$private_index_number_limit = (int)xoonips_get_config('private_index_number_limit');
			$private_item_storage_limit = (int)xoonips_get_config('private_item_storage_limit');
			
			$uid = $xoopsUser->getVar('uid');
			$esc_uname = addslashes($xoopsUser->getVar('uname'));
			$max_int = 2147483647;
			$sort_number = $max_int-1;
			$xnp_users = $xoopsDB->prefix('xoonips_users');
			$xnp_item_basic = $xoopsDB->prefix('xoonips_item_basic');
			$xnp_index = $xoopsDB->prefix('xoonips_index');
			
			$result1 = xoonips_query( "insert into $xnp_users ( uid, activate, private_item_number_limit, private_index_number_limit, private_item_storage_limit ) values ( $uid, 1, $private_item_number_limit, $private_index_number_limit, $private_item_storage_limit )" );
			$result2 = xoonips_query( "insert into $xnp_item_basic (item_type_id, uid, title) values (".ITID_INDEX.",$uid,'$esc_uname')" );
			$xid = mysql_insert_id();
			$result3 = xoonips_query( "insert into $xnp_index (index_id, parent_index_id, uid, gid, open_level, sort_number) values ($xid,".IID_ROOT.",$uid,NULL,".OL_PRIVATE.",$sort_number)" );
			$result4 = xoonips_query( "update $xnp_users set private_index_id = $xid where uid = $uid " );
			if ( $result1 == false || $result2 == false || $result3 == false || $result4 == false )
				$error = true;
			
			$member_handler =& xoops_gethandler('member');
			$member_handler->addUserToGroup($groupid, $uid);
		}
	}else{
		$error = true; //xoonips is not installed
    }
    
	if( $error )
		return false;
	
	return true;
} 

function xoops_module_uninstall_xoonips( $xoopsMod ) {
	//if (everythingIsOK) {
		return true;
	//} else {
	//	return false;
	//}
}

function xoops_module_update_xoonips ( $xoopsMod, $oldversion) {

	global $xoopsDB;
	xoonips_insert_default_configs();
	
	switch ($oldversion) { //remember that version is multiplied with 100 to get an integer
	case 100: //perform actions to upgrade from version 1.00
		$sql = sprintf("ALTER TABLE %s ADD lang CHAR(3) default 'eng'", $xoopsDB->prefix("xoonips_item_basic"));
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: " . $xoopsDB->error();
			return false;
		}
	
	case 101:
		$sql = sprintf("CREATE TABLE %s (  item_id int(10) unsigned NOT NULL, timestamp timestamp(14), created_timestamp int(10) unsigned,  modified_timestamp int(10) unsigned,  deleted_timestamp int(10) unsigned,  is_deleted tinyint(3),  PRIMARY KEY  (item_id), KEY timestamp ( timestamp )) TYPE=MyISAM", $xoopsDB->prefix("xoonips_item_status") );
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: " . $xoopsDB->error();
			return false;
		}
		require_once XOOPS_ROOT_PATH . '/modules/xoonips/include/create_session.php';
		$result = xnp_load_al_silent();
		if ( $result != 0 ){
			echo "ERROR: cannot load AL(${result}).";
			return false;
		}
		
		$result = xnp_refresh_item_status();
        if ( RES_OK != $result ){
			echo "ERROR: cannot refresh item status(${result})";
			return false;
		}

        $sql = sprintf( "CREATE TABLE `%s` ("
                        ."`repository_id` int(11) unsigned NOT NULL auto_increment,"
                        ."`URL` varchar(255) default NULL,"
                        ."`last_access_date` int(11) unsigned default NULL,"
                        ."`last_success_date` int(11) unsigned default NULL,"
                        ."`last_access_result` text,"
                        ."`sort` int(10) unsigned NOT NULL default '0',"
                        ."`enabled` int(1) unsigned NOT NULL default '1',"
                        ."`deleted` int(1) unsigned NOT NULL default '0',"
                        ."PRIMARY KEY  (`repository_id`),"
                        ."UNIQUE KEY `url` (`URL`) )", $xoopsDB -> prefix( "xoonips_oaipmh_repositories" ) );
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: " . $xoopsDB->error();
			return false;
		}
        
        $sql = sprintf( "CREATE TABLE %s ( "
			."identifier CHAR(255) , "
			."repository_id INT(11) UNSIGNED NOT NULL , "
			."format CHAR(255) NOT NULL, "
			."metadata BLOB DEFAULT NULL, "
			."title TEXT DEFAULT NULL, "
			."search_text TEXT DEFAULT NULL, "
			."PRIMARY KEY(identifier), "
			."FULLTEXT INDEX search( search_text ) )", $xoopsDB -> prefix( "xoonips_oaipmh_metadata" ) );
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: " . $xoopsDB->error();
			return false;
		}
		
	    $sql = sprintf( "CREATE TABLE %s ( "
			."resumption_token CHAR(255), "
			."metadata_prefix CHAR(255), "
			."verb CHAR(32), "
			."args TEXT, "
			."last_item_id int, "
			."limit_row int, "
			."publish_date int, "
			."expire_date int, "
			."PRIMARY KEY(resumption_token) )", $xoopsDB -> prefix( "xoonips_oaipmh_resumption_token" ) );
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: " . $xoopsDB->error();
			return false;
		}

	case 102: //1.02 -> 1.03 support related_to
		$sql = sprintf( "CREATE TABLE %s ( "
						."parent_id int(11) NOT NULL default '0',"
						."item_id int(11) NOT NULL default '0',"
						."PRIMARY KEY  (parent_id,item_id)"
						.")", $xoopsDB -> prefix( "xoonips_related_to" ) );
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo "ERROR: " . $xoopsDB->error();
			return false;
		}
		
		return true;	
	case 103:
	case 110:
		// Bug: item_type_id of index becomes zero.
		$xoopsDB->query( "UPDATE " . $xoopsDB->prefix('xoonips_item_basic') . " SET item_type_id=1 WHERE item_type_id=0" );
		
		// removing items which lost the link to basic information
		$sql = "SELECT basic.item_id FROM ".$xoopsDB->prefix('xoonips_item_basic')." AS basic LEFT JOIN ".$xoopsDB->prefix('xoonips_item_type')." AS type on basic.item_type_id = type.item_type_id WHERE type.item_type_id IS NULL";
		$result = $xoopsDB->query($sql);
		if( !$result ){
			echo mysql_error();
			echo $sql;
			return false;
		}
		$delete = array( );
		while( list( $item_id ) = $xoopsDB->fetchRow($result) ){
			$delete[] = $item_id;
		}
		if( count( $delete ) > 0 ){
			$table = $xoopsDB->prefix('xoonips_item_basic');
			$sql = "DELETE FROM ${table} WHERE item_id in ( ".implode( ",", $delete ).")";
			if ( $xoopsDB->query($sql) == FALSE ){
				echo mysql_error();
				echo $sql;
				return false;
			}
			$table = $xoopsDB->prefix('xoonips_item_status');
			$sql = "UPDATE ${table} SET deleted_timestamp=UNIX_TIMESTAMP(NOW()), is_deleted=1 WHERE item_id in ( ".implode( ",", $delete ).")";
			if ( $xoopsDB->query($sql) == FALSE ){
				echo mysql_error();
				echo $sql;
				return false;
			}
		}
	case 111:
	case 112:
	case 113:
	case 114:
	case 200:
	default:
		return true;
	}
	
}

?>
