<?php
//  select items                                                                //
//  $Revision: 1.21.2.2 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

// This page can't be cached. Results of search(cached before login) don't display after login.
session_cache_limiter( 'none' ); 
$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';

require_once 'include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

include_once "include/lib.php";
include_once "condefs.php";

// include blocks.php to get "ALL" and "Title&Keyword" from quick search.
if( file_exists( XOOPS_ROOT_PATH.'/modules/xoonips/language/'.$xoopsConfig['language'].'/blocks.php' ) ) {
	include_once( XOOPS_ROOT_PATH.'/modules/xoonips/language/'.$xoopsConfig['language'].'/blocks.php' );
} else {
	include_once( XOOPS_ROOT_PATH.'/modules/xoonips/language/english/blocks.php' );
}

// If not a user, redirect
if( $xnpsid != 0 ){
    if ( !$xoopsUser ) {
        redirect_header('index.php',3,_MD_XOONIPS_ITEM_FORBIDDEN);
        exit();
    }

    $uid = $_SESSION['xoopsUserId'];

    //Uncertified user can't access(except XOOPS administrator).
    if( !$xoopsUser->isAdmin( $xoopsModule->getVar('mid') )
        && !xnp_is_activated( $xnpsid, $uid ) ){
        redirect_header('index.php', 3, _MD_XOONIPS_MODERATOR_NOT_ACTIVATED);
        exit();
    }
}
else {
    if( !xnp_is_valid_session_id($xnpsid) ){
        // User is guest group, and guest isn't admitted to access the page.
        // -> display login block.
        redirect_header(XOOPS_URL.'/modules/xoonips/user.php',3,_MD_XOONIPS_ITEM_FORBIDDEN);
        exit();
    }
    $uid = 0;
}

xnpEncodeMacSafariPost();
xnpEncodeMacSafariGet();

foreach( array(
                  'op' => '',
//                  'checkbox' => 'off',
//                  'add_to_index_id' => false,
//                  'creation_date_from' => NULL,
//                  'jumpto_url' => '',
//                  'jumpto_var' => array(),
//                  'search_var' => array(),
//                  'page' => 1,
//                  'itemcount' => 20,
//                  'orderby' => ( isset( $_SESSION['xoonips_orderby'] ) ? $_SESSION['xoonips_orderby'] : 'title' ),
//                  'order_dir' => ( isset( $_SESSION['xoonips_order_dir'] ) ? $_SESSION['xoonips_order_dir'] : ASC ),
//                  'item_id' => array(),
//                  'index_id' => false,
//                  'selected' => array(),
//                  'keyword' => '',
//                  'search_itemtype' => '',
                  'print' => false,
//                  'xoonipsForm' => ''
    ) as $k => $v ){
    if( array_key_exists( $k, $_GET ) ){
        $$k = $_GET[$k];
    }else if( array_key_exists( $k, $_POST ) ){
        $$k = $_POST[$k];
    }else{
        $$k = $v;
    }
}

if( $op == 'index' ){
    $xoonipsForm = 'itemselectform'; //defined in itemselect.html // It is necessary to write this from header.php forward. 
}


$config_handler =& xoops_gethandler('config');
$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
$xoopsOption['template_main'] = 'xoonips_itemselect.html';
if ( $print ){
	require_once XOOPS_ROOT_PATH.'/class/template.php';
	$xoopsTpl = new XoopsTpl();
	xoops_header(false);
    echo "</head><body onload='window.print();'>\n";
}
else {
	include './header.php';
}

include "itemselect_body.php";

if ( $op == 'quicksearch' )
    $xoopsTpl->assign('quick_search_keyword', $keyword );

if ( $print ){
    if ( !isset($xoopsConfigMetaFooter) )
        $xoopsConfigMetaFooter =& $config_handler->getConfigsByCat(XOOPS_CONF_METAFOOTER);
    //$xoopsTpl->assign('footer', $xoopsConfigMetaFooter['footer'] );
    $xoopsTpl->assign('meta_copyright', $xoopsConfigMetaFooter['meta_copyright'] );
    $xoopsTpl->assign('meta_author', $xoopsConfigMetaFooter['meta_author'] );
    $xoopsTpl->assign('sitename', $xoopsConfig['sitename'] );
    
    if ( $op == 'quicksearch' ){
        $search_itemtypes = array( 'all'=>_MB_XOONIPS_ITEM_ALL_LABEL, 'basic'=>_MB_XOONIPS_ITEM_TITLE_AND_KEYWORD_LABEL );
        
        $itemtypes = array();
        if( xnp_get_item_types( $itemtypes ) == RES_OK ){
            foreach ( $itemtypes as $itemtype ){
                if ( $itemtype['item_type_id'] > 2 )
                    $search_itemtypes[$itemtype['name']] = $itemtype['display_name'];
            }
        }
        
        $xoopsTpl->assign('quick_search_itemtype', $search_itemtypes[$search_itemtype] );
    }
    
    $val = "";
    xnp_get_config_value( 'printer_friendly_header', $val );
    $xoopsTpl->assign('printer_friendly_header', $val );
    $xoopsTpl->assign('title', _MD_XOONIPS_ITEM_SEARCH_RESULT );
    $xoopsTpl->assign('date', date(DATETIME_FORMAT, xoops_getUserTimestamp(time())) );
    $xoopsTpl->display( "db:xoonips_itemselect_print.html" );
    xoops_footer();
    exit();
}
else {
	include XOOPS_ROOT_PATH.'/footer.php';
}
?>
