<?php
//  $Revision: 1.13.2.5 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';

include 'condefs.php';
include_once 'include/lib.php';
require_once 'include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

// If not a user, redirect
if( $xnpsid != 0 ){
    if ( !$xoopsUser ) {
        redirect_header(XOOPS_URL.'/index.php',3,_MD_XOONIPS_ITEM_FORBIDDEN);
        exit();
    }

    $uid = $_SESSION['xoopsUserId'];

//Uncertified user can't access(except XOOPS administrator).
    if( !$xoopsUser->isAdmin( $xoopsModule->getVar('mid') )
        && !xnp_is_activated( $xnpsid, $uid ) ){
        redirect_header(XOOPS_URL.'/index.php', 3, _MD_XOONIPS_MODERATOR_NOT_ACTIVATED);
        exit();
    }
}
else {
    if( !xnp_is_valid_session_id($xnpsid) ){
        // User is guest group, and guest isn't admitted to access the page.
        redirect_header(XOOPS_URL.'/index.php',3,_MD_XOONIPS_ITEM_FORBIDDEN);
        exit();
    }
    $uid = UID_GUEST;
}
$config_handler =& xoops_gethandler('config');
$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);




if( isset( $_GET['num_of_items'] ) ){
    $num_of_items = $_GET['num_of_items'];
}else if( isset( $_POST['num_of_items'] ) ){
    $num_of_items = $_POST['num_of_items'];
}else{
    unset( $num_of_items );
}

if( isset( $_GET['index_id'] ) ){
    $index_id = $_GET['index_id'];
}else if( isset( $_POST['index_id'] ) ){
    $index_id = $_POST['index_id'];
}else{
    unset( $index_id );
}

foreach( array( 'page' => 1,
                'orderby' => ( isset( $_SESSION['xoonips_orderby'] ) ? $_SESSION['xoonips_orderby'] : 'title' ),
                'order_dir' => ( isset( $_SESSION['xoonips_order_dir'] ) ? $_SESSION['xoonips_order_dir'] : ASC ),
                'itemcount' => 20,
                'op' => '',
                'selected' => array(),
                'initially_selected' => array(),
                'print' => false,
                'add_to_index' => false ) as $k => $v ){
    if( array_key_exists( $k, $_GET ) ){
        $$k = $_GET[$k];
    }else if( array_key_exists( $k, $_POST ) ){
        $$k = $_POST[$k];
    }else{
        $$k = $v;
    }
}

$_SESSION['xoonips_orderby'  ] = $orderby;
$_SESSION['xoonips_order_dir'] = $order_dir;

if( $op == 'add_selected_item' ){
    list( $page, $itemcount, $orderby, $index_id ) = explode( ',', $add_to_index );
    
    $add_item_ids = array_diff( $selected, $initially_selected );
    $del_item_ids = array_diff( $initially_selected, $selected );
    
    $is_private = true;
    $index = array();
    $result = xnp_get_index( $xnpsid, $index_id, $index );
    if ( $result == RES_OK && $index['open_level'] != OL_PRIVATE )
        $is_private = false;
    
    $changelog = sprintf( _MD_XOONIPS_ITEM_CHANGE_LOG_AUTOFILL_TEXT, 
                           implode( _MD_XOONIPS_ITEM_CHANGE_LOG_AUTOFILL_DELIMITER, array(_MD_XOONIPS_ITEM_INDEX_LABEL) ) );
    
    $modified_item_ids = array();
    
    $certify_item = '';
    if( xnp_get_config_value( 'certify_item', $certify_item ) != RES_OK ){
        $certify_item = 'on';
    }
    
    $moderator_emails = xnpGetModeratorEmails( $xnpsid );
    
    // add selected item into index
    foreach ( $add_item_ids as $item_id ){
        // can't add items when the item is certified already or is in pending state.
        $state = false;
        $result = xnp_get_certify_state( $xnpsid, $index_id, $item_id, $state );
        if ( $result == RES_OK ){
            if ( $state == CERTIFY_REQUIRED || $state == CERTIFIED ){
                continue;
            }
        }
        
        // add
        $result = xnp_register_item( $xnpsid, $index_id, $item_id );
        if ( $result != RES_OK ){
            echo "cannot add item to index. item_id=$item_id, index_id=$index_id result=$result <br />\n";
            echo xnp_get_last_error_string();
            //redirect_header(XOOPS_URL.'/index.php', 3, "ERROR xnp_get_item_types [AbstractLayer]".xnp_get_last_error_string());
            break;
        }
        else {
            xnp_insert_change_log( $xnpsid, $item_id, $changelog );
            xnp_insert_event( $xnpsid, ETID_UPDATE_ITEM, time(), $uid, xnpGetRemoteHost(), array( 'item_id' => $item_id ) );
            
            if ( !$is_private ){
                xnpRequestCertifyNotify( $xnpsid, $index_id, $item_id, $certify_item, $moderator_emails );
            }
        }
    }
    
    // delete item removed selection from index
    foreach ( $del_item_ids as $item_id ){
        // can delete when the item is certified already or is in pending state.
        $state = false;
        $result = xnp_get_certify_state( $xnpsid, $index_id, $item_id, $state );
        if ( $result == RES_OK ){
            if ( $state == CERTIFY_REQUIRED || $state == CERTIFIED ){
                // delete
                if ( $is_private ){
                    $xids = array();
                    xnp_get_index_id_by_item_id( $xnpsid, $item_id, $xids );
                    $private_count = 0;
                    foreach ( $xids as $xid ){
                        $index = array();
                        $result = xnp_get_index( $xnpsid, $xid, $index );
                        if ( $index['open_level'] == OL_PRIVATE )
                            $private_count++;
                    }
                    if ( $private_count == 1 )
                        continue;  // cannot unregister from the last private index
                }
                
                $result = xnp_unregister_item( $xnpsid, $index_id, $item_id );
                if ( $result != RES_OK ){
                    echo "cannot del item from index. item_id=$item_id, index_id=$index_id result=$result <br />\n";
                    echo xnp_get_last_error_string();
                    //redirect_header(XOOPS_URL.'/index.php', 3, "ERROR xnp_get_item_types [AbstractLayer]".xnp_get_last_error_string());
                    break;
                }
                else {
                    xnp_insert_change_log( $xnpsid, $item_id, $changelog );
                    xnp_insert_event( $xnpsid, ETID_UPDATE_ITEM, time(), $uid, xnpGetRemoteHost(), array( 'item_id' => $item_id ) );
                }
            }
        }
    }
}



$itemtypes = array();
$tmp = array();
if( xnp_get_item_types( $tmp ) != RES_OK ){
    redirect_header(XOOPS_URL.'/index.php', 3, "ERROR xnp_get_item_types [AbstractLayer]".xnp_get_last_error_string());
    break;
}else{
    foreach( $tmp as $i){
        $itemtypes[$i['item_type_id']]=$i;
    }
}

$config_handler =& xoops_gethandler('config');
$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
$xoopsOption['template_main'] = 'xoonips_itemlist.html';
if ( $print ){
	require_once XOOPS_ROOT_PATH.'/class/template.php';
	$xoopsTpl = new XoopsTpl();
	xoops_header(false);
    echo "</head><body onload='window.print();'>\n";
}
else {
    include './header.php';
}
$xoopsTpl->assign('title_page', _MD_XOONIPS_ITEM_LISTING_ITEM );
$xoopsTpl->assign('order_by_label', _MD_XOONIPS_ITEM_ORDER_BY );
$xoopsTpl->assign('item_count_label', _MD_XOONIPS_ITEM_NUM_OF_ITEM_PER_PAGE );
//order_by_select: array( "variable name" => "name for view", ... )
$xoopsTpl->assign("order_by_select",
                  array( "title"=>"Title",
                         "last_update_date"=>"Modification Date",
                         "creation_date" => "Contribution Date",
                         "publication_date"=>"Date" ) );
$xoopsTpl->assign('item_count_select',
                  array( "20", "50", "100" ) );
if ( $op != 'add_selected_item' ){
    $xoopsTpl->assign('print_enabled', true );
}

$iids = array();
$items = array();
$cri=array();
if( $orderby == 'publication_date' ){
    $cri = array( 'start' => ( $page - 1 ) * $itemcount,
                  'rows' => $itemcount,
                  'orders'=>array( 
                      array('name'=>'publication_year','order'=>$order_dir), 
                      array('name'=>'publication_month','order'=>$order_dir),
                      array('name'=>'publication_mday','order'=>$order_dir) ) );
}else{
    $cri = array( 'start' => ( $page - 1 ) * $itemcount,
                  'rows' => $itemcount,
                  'orders'=>array( array('name'=>$orderby,'order'=>$order_dir) ) );
}
if( isset( $index_id ) ){
    if( !isset( $num_of_items ) ){
        if( xnp_get_item_id_by_index_id( $xnpsid, $index_id, array(), $iids ) != RES_OK ){
            redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
            break;
        }
        $num_of_items = count( $iids );
    }
    if( xnp_get_item_id_by_index_id( $xnpsid, $index_id, $cri, $iids ) != RES_OK ){
        redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
        break;
    }
}else{
    if( !isset( $num_of_items ) ){
        $num_of_items = xnp_get_item_count( $xnpsid );
    }

	$ret = xnp_dump_item_id( $xnpsid, $cri, $iids );
    if( $ret != RES_OK ){
        redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
        break;
    }
}

if( isset( $index_id ) ){
    // making character strings in display current place (Root/Private/Tools&Techniques etc)
    // -> index_path
    $dirArray = array();
    for ( $p_xid = $index_id; $p_xid != IID_ROOT; $p_xid = (int)($index['parent_index_id']) ){
        // get $index
        $index = array();
        $result = xnp_get_index( $xnpsid, $p_xid, $index );
        if ( $result != 0 ){
            redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
            break;
        }
        $dirArray[] = $index;
    }
    $xoopsTpl->assign('index_path', array_reverse($dirArray) );
    $xoopsTpl->assign('jumpto_var', array( 'index_id'=>$index_id, 'page'=>$page, 'itemcount'=>$itemcount, 'orderby'=>$orderby, 'op'=>'add_to_index' ) );
    
    // check that index is editable
    $index = array();
    $result = xnp_get_index( $xnpsid, $index_id, $index );
    if ( $result != RES_OK ){
        redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
        break;
    }
    if ( $index['open_level'] == OL_PRIVATE && $index['owner_uid'] == $uid ||
         $index['open_level'] == OL_GROUP_ONLY && xnp_is_group_admin( $xnpsid, $index['owner_gid'], $uid ) ||
         $index['open_level'] == OL_PUBLIC && xnp_is_moderator( $xnpsid, $uid ) && $index['item_id'] != IID_BINDERS && $index['item_id'] != IID_ROOT ){
        $xoopsTpl->assign( 'edit_index', true );
    }
}

//centering current page number(5th of $pages)
$pages = array( min( max( 1, $page - 4 ), max( 1, ceil( $num_of_items / $itemcount ) - 9 ) ) );
for( $i = $pages[0] + 1; $i <= min( 10, ceil( $num_of_items / $itemcount ) ); $i++ ){ $pages[] = $i; }

$xoopsTpl->assign('pages', $pages );

$xoopsTpl->assign('prevpage', $page - 1 );
$xoopsTpl->assign('nextpage', $page + 1 );
$xoopsTpl->assign('maxpage', ceil( $num_of_items / $itemcount ) );
$xoopsTpl->assign('orderby', $orderby);
$xoopsTpl->assign('order_dir', $order_dir);
$xoopsTpl->assign('page', $page);
$xoopsTpl->assign('itemcount', $itemcount);
$xoopsTpl->assign('num_of_items', $num_of_items);
$xoopsTpl->assign('page_no_label',
                  min( ( $page - 1 ) * $itemcount + 1, $num_of_items )
                  ." - ".min($page * $itemcount, $num_of_items )
                  ." of ".$num_of_items." Items" );

// retrieve items
// ignore 'start' and 'rows' of criteria because already truncated by dump_item_id
if( xnp_get_items( $xnpsid, $iids, array( 'orders' => $cri['orders'] ), $items ) != RES_OK ){
    redirect_header(XOOPS_URL.'/index.php', 3, "ERROR [AbstractLayer]".xnp_get_last_error_string());
    break;
}

$item_htmls = array();
foreach( $items as $i ){
    if( array_key_exists( $i['item_type_id'], $itemtypes ) ){
        $itemtype = $itemtypes[ $i['item_type_id'] ];
        $modname = $itemtype['name'];
        include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
        if ( $print && function_exists($modname."GetPrinterFriendlyListBlock") )
            eval( "\$html = ".$modname."GetPrinterFriendlyListBlock( \$i );" );
        else if ( function_exists($modname."GetListBlock") )
            eval( "\$html = ".$modname."GetListBlock( \$i );" );
        else
            $html = '';
        $item_htmls[] = array( 'html'=>$html );
    }
}

$xoopsTpl->assign('item_htmls', $item_htmls );

if( isset( $index_id ) ){
	$xoopsTpl->assign('index_id', $index_id );
}

// assign export_enable variable if permitted
$val = '';
if( xnp_is_moderator( $xnpsid, $uid ) ){
    $xoopsTpl->assign('export_enabled', 1 );
}else if( xnp_get_config_value( 'export_enabled', $val ) == RES_OK && $val == 'on' ){
    if( !isset( $index_id ) ){
        $xoopsTpl->assign('export_enabled', 1 );
    }else if( isset( $index_id ) ){
        // check that index is editable
        $index = array();
        $result = xnp_get_index( $xnpsid, $index_id, $index );
        if ( $result != RES_OK ){
            redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
            break;
        }
        if( $index['open_level'] == OL_PRIVATE && $index['owner_uid'] == $uid ||
            $index['open_level'] == OL_GROUP_ONLY && xnp_is_group_admin( $xnpsid, $index['owner_gid'], $uid ) ||
            $index['open_level'] == OL_PUBLIC && xnp_is_moderator( $xnpsid, $uid ) && $index['item_id'] != IID_BINDERS && $index['item_id'] != IID_ROOT ){
            $xoopsTpl->assign('export_enabled', 1 );
        }
    }
}


if ( $print ){
    if ( !isset($xoopsConfigMetaFooter) )
        $xoopsConfigMetaFooter =& $config_handler->getConfigsByCat(XOOPS_CONF_METAFOOTER);
    //$xoopsTpl->assign('footer', $xoopsConfigMetaFooter['footer'] );
    $xoopsTpl->assign('meta_copyright', $xoopsConfigMetaFooter['meta_copyright'] );
    $xoopsTpl->assign('meta_author', $xoopsConfigMetaFooter['meta_author'] );
    $xoopsTpl->assign('sitename', $xoopsConfig['sitename'] );
    
    if ( $op == 'quicksearch' ){
        $search_itemtypes = array( 'all'=>_MB_XOONIPS_ITEM_ALL_LABEL, 'basic'=>_MB_XOONIPS_ITEM_TITLE_AND_KEYWORD_LABEL );
        
        $itemtypes = array();
        if( xnp_get_item_types( $itemtypes ) == RES_OK ){
            foreach ( $itemtypes as $itemtype ){
                if ( $itemtype['item_type_id'] > 2 )
                    $search_itemtypes[$itemtype['name']] = $itemtype['display_name'];
            }
        }
        $xoopsTpl->assign('quick_search_keyword', $keyword );
        $xoopsTpl->assign('quick_search_itemtype', $search_itemtypes[$search_itemtype] );
    }
    
    $val = "";
    xnp_get_config_value( 'printer_friendly_header', $val );
    $xoopsTpl->assign('printer_friendly_header', $val );
    $xoopsTpl->assign('title', _MD_XOONIPS_ITEM_LISTING_ITEM );
    $xoopsTpl->assign('date', date(DATETIME_FORMAT, xoops_getUserTimestamp(time())) );
    $xoopsTpl->display( "db:xoonips_itemselect_print.html" );
    xoops_footer();
    exit();
}
else {
	include XOOPS_ROOT_PATH.'/footer.php';
}
?>
