#
# `xoonips_item_basic`
#

CREATE TABLE xoonips_item_basic (
  item_id int(10) unsigned NOT NULL auto_increment,
  item_type_id int(10) unsigned NOT NULL default '0',
  uid int(10) unsigned NOT NULL default '0',
  title varchar(255) default NULL,
  keywords text,
  description text,
  doi text,
  last_update_date int(10) unsigned NOT NULL default '0',
  creation_date int(10) unsigned NOT NULL default '0',
  publication_year int(10) default NULL,
  publication_month int(10) default NULL,
  publication_mday int(10) default NULL,
  lang char(3) default 'eng',
  PRIMARY KEY  (item_id),
  KEY title (title)
) TYPE=MyISAM;

#
# `xoonips_index_item_link`
#

CREATE TABLE xoonips_index_item_link (
  index_item_link_id int(10) unsigned NOT NULL auto_increment,
  index_id int(10) unsigned NOT NULL default '0',
  item_id int(10) unsigned NOT NULL default '0',
  certify_state tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (index_item_link_id),
  UNIQUE KEY index_id_2 (index_id,item_id),
  KEY index_id (index_id),
  KEY item_id (item_id)
) TYPE=MyISAM;

#
# `xoonips_index`
#

CREATE TABLE xoonips_index (
  index_id int(10) unsigned NOT NULL auto_increment,
  parent_index_id int(10) unsigned default NULL,
  uid int(10) unsigned default NULL,
  gid int(10) unsigned default NULL,
  open_level tinyint(3) NOT NULL default '0',
  sort_number int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (index_id),
  KEY parent_index_id (parent_index_id)
) TYPE=MyISAM;

#
# `xoonips_binder_item_link`
#

CREATE TABLE xoonips_binder_item_link (
  binder_item_link_id int(10) unsigned NOT NULL auto_increment,
  binder_id int(10) unsigned NOT NULL default '0',
  item_id int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (binder_item_link_id),
  UNIQUE KEY binder_id (binder_id,item_id),
  KEY index_id (binder_id),
  KEY item_id (item_id)
) TYPE=MyISAM;

#
# `xoonips_changelog`
#

CREATE TABLE xoonips_changelog (
  log_id int(10) unsigned NOT NULL auto_increment,
  uid int(10) unsigned NOT NULL default '0',
  item_id int(10) unsigned NOT NULL default '0',
  log_date int(10) unsigned NOT NULL default '0',
  log text,
  PRIMARY KEY  (log_id),
  KEY item_id (item_id),
  KEY log_date (log_date)
) TYPE=MyISAM;


#
# `xoonips_item_type`
#

CREATE TABLE `xoonips_item_type` (
  `item_type_id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(30) default NULL,
  `mid` int(10) unsigned,
  `display_name` varchar(30),
  `viewphp` varchar(255) default NULL,
  PRIMARY KEY  (`item_type_id`)
) TYPE=MyISAM;

CREATE TABLE `xoonips_file_type` (
  `file_type_id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(30) default NULL,
  `mid` int(10) unsigned,
  `display_name` varchar(30),
  PRIMARY KEY  (`file_type_id`)
) TYPE=MyISAM;

CREATE TABLE xoonips_file (
 `file_id` int(10) unsigned not null auto_increment,
 `item_id` int(10) unsigned,
 `original_file_name` varchar(255),
 `mime_type` varchar(255),
 `file_name` varchar(255),
 `file_size` int(10) unsigned not null,
 `thumbnail_file` blob,
 `caption` varchar(255),
 `sid` int(10) unsigned,
 `file_type_id` int(10) unsigned not null,
  PRIMARY KEY  (file_id),
  KEY item_id(item_id),
  KEY sid(sid)
) TYPE=MyISAM;

CREATE TABLE `xoonips_event_log` (
  `event_id` int(10) unsigned NOT NULL auto_increment,
  `event_type_id` int(10) unsigned NOT NULL default '0',
  `timestamp` int(10) unsigned NOT NULL default '0',
  `exec_uid` int(10) unsigned default NULL,
  `remote_host` varchar(255) default NULL,
  `index_id` int(10) unsigned default NULL,
  `item_id` int(10) unsigned default NULL,
  `file_id` int(10) unsigned default NULL,
  `uid` int(10) unsigned default NULL,
  `gid` int(10) unsigned default NULL,
  `search_keyword` blob,
  `additional_info` blob default NULL,
  PRIMARY KEY  (`event_id`),
  KEY `timestamp` (`timestamp`)
) TYPE=MyISAM;


INSERT INTO `xoonips_item_type` VALUES (1,'xoonips_index',NULL,'Index',NULL);
INSERT INTO `xoonips_item_type` VALUES (2,'xoonips_binder',NULL,'Binder','xoonips/include/binderview.php');

INSERT INTO `xoonips_index` VALUES (1,0,NULL,NULL,1,1);
INSERT INTO `xoonips_index` VALUES (2,3,NULL,NULL,1,1);
INSERT INTO `xoonips_index` VALUES (3,1,NULL,NULL,1,1);

INSERT INTO `xoonips_item_basic` VALUES (1,1,0,'Root',NULL,NULL,NULL,0,0,NULL,NULL,NULL,'eng');
INSERT INTO `xoonips_item_basic` VALUES (2,1,0,'Binders',NULL,NULL,NULL,0,0,NULL,NULL,NULL,'eng');
INSERT INTO `xoonips_item_basic` VALUES (3,1,0,'Public',NULL,NULL,NULL,0,0,NULL,NULL,NULL,'eng');

INSERT INTO `xoonips_file_type` VALUES (1,'preview',NULL,'Preview');
INSERT INTO `xoonips_file_type` VALUES (2,'readme',NULL,'ReadMe');
INSERT INTO `xoonips_file_type` VALUES (3,'license',NULL,'License');
INSERT INTO `xoonips_file_type` VALUES (4,'rights',NULL,'Rights');

#
# Table structure for table `xoonips_config`
#

CREATE TABLE xoonips_config (
  id int(10) unsigned NOT NULL auto_increment,
  name varchar(255) binary NOT NULL default '',
  value blob NOT NULL,
  PRIMARY KEY  (id),
  KEY name (name)
) TYPE=MyISAM;

#
# Table structure for table `xoonips_groups`
#

CREATE TABLE xoonips_groups (
  gid int(10) unsigned NOT NULL auto_increment,
  gname varchar(255) binary NOT NULL default '',
  gdesc varchar(255) binary NOT NULL default '',
  group_index_id int(10) unsigned NOT NULL default '0',
  group_item_number_limit int(10) unsigned,
  group_index_number_limit int(10) unsigned,
  group_item_storage_limit double,
  PRIMARY KEY  (gid)
) TYPE=MyISAM;

#
# Table structure for table `xoonips_groups_users_link`
#

CREATE TABLE xoonips_groups_users_link (
  gid int(10) unsigned NOT NULL default '0',
  uid int(10) unsigned NOT NULL default '0',
  is_admin tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (gid,uid)
) TYPE=MyISAM;

#
# Table structure for table `xoonips_session`
#

CREATE TABLE xoonips_session (
  sid int(10) unsigned NOT NULL auto_increment,
  uid int(10) unsigned NOT NULL default '0',
  timestamp timestamp(14) NOT NULL,
  remote_host int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (sid)
) TYPE=MyISAM;

#
# Table structure for table `xoonips_users`
#

CREATE TABLE xoonips_users (
  uid int(10) unsigned NOT NULL default '0',
  activate tinyint(1) unsigned NOT NULL default '0',
  address varchar(255) binary default NULL,
  division varchar(255) binary default NULL,
  tel varchar(32) binary NOT NULL default '',
  company_name varchar(255) binary default NULL,
  country varchar(255) binary NOT NULL default '',
  zipcode varchar(32) binary NOT NULL default '',
  fax varchar(32) binary NOT NULL default '',
  base_url varchar(255) binary default NULL,
  notice_mail int(10) unsigned default NULL,
  notice_mail_since int(10) unsigned default 0,
  private_index_id int(10) unsigned NOT NULL default '0',
  private_item_number_limit int(10) unsigned,
  private_index_number_limit int(10) unsigned,
  private_item_storage_limit double,
  PRIMARY KEY  (uid),
  KEY activate (activate)
) TYPE=MyISAM;

INSERT INTO `xoonips_groups` VALUES (1, 'default', 'default group', 0, NULL, NULL, NULL);


INSERT INTO `xoonips_config` VALUES (1, 'certify_user', 'on');
INSERT INTO `xoonips_config` VALUES (2, 'certify_item', 'on');
INSERT INTO `xoonips_config` VALUES (3, 'public_item_target_user', 'all');
INSERT INTO `xoonips_config` VALUES (4, 'upload_dir','/var/tmp');
INSERT INTO `xoonips_config` VALUES (5, 'account_address_optional','off');
INSERT INTO `xoonips_config` VALUES (6, 'account_division_optional','off');
INSERT INTO `xoonips_config` VALUES (7, 'account_tel_optional','off');
INSERT INTO `xoonips_config` VALUES (8, 'account_company_name_optional','off');
INSERT INTO `xoonips_config` VALUES (9, 'account_country_optional','off');
INSERT INTO `xoonips_config` VALUES (10, 'account_zipcode_optional','off');
INSERT INTO `xoonips_config` VALUES (11, 'account_fax_optional','off');
INSERT INTO `xoonips_config` VALUES (12, 'private_item_number_limit','100');
INSERT INTO `xoonips_config` VALUES (13, 'private_index_number_limit','50');
INSERT INTO `xoonips_config` VALUES (14, 'private_item_storage_limit','50000000');
INSERT INTO `xoonips_config` VALUES (15, 'group_item_number_limit','300');
INSERT INTO `xoonips_config` VALUES (16, 'group_index_number_limit','200');
INSERT INTO `xoonips_config` VALUES (17, 'group_item_storage_limit','100000000');
INSERT INTO `xoonips_config` VALUES (18, 'amazon_associates_id','');
INSERT INTO `xoonips_config` VALUES (19, 'tree_frame_width','100%');
INSERT INTO `xoonips_config` VALUES (20, 'tree_frame_height','400');
INSERT INTO `xoonips_config` VALUES (21, 'account_realname_optional','off'   );
INSERT INTO `xoonips_config` VALUES (22, 'export_attachment'        ,'off'   );
INSERT INTO `xoonips_config` VALUES (23, 'export_enabled'           ,'off'   );
INSERT INTO `xoonips_config` VALUES (24, 'rss_file_path'            ,''      );
INSERT INTO `xoonips_config` VALUES (25, 'rss_item_max'             ,'10'    );
INSERT INTO `xoonips_config` VALUES (26, 'printer_friendly_header'  ,''      );
INSERT INTO `xoonips_config` VALUES (27, 'repository_institution'   ,'meta_author');
INSERT INTO `xoonips_config` VALUES (28, 'repository_publisher'     ,'meta_author');
INSERT INTO `xoonips_config` VALUES (29, 'repository_name'          ,''      );
INSERT INTO `xoonips_config` VALUES (30, 'repository_nijc_code'     ,''      );
INSERT INTO `xoonips_config` VALUES (31, 'repository_deletion_track','30'    );
INSERT INTO `xoonips_config` VALUES (32, 'download_file_compression','on'    );


CREATE TABLE `xoonips_item_status` (
    `item_id` int(10) unsigned NOT NULL default '0',
    `timestamp` timestamp(14) NOT NULL,
    `created_timestamp` int(10) unsigned default NULL,
    `modified_timestamp` int(10) unsigned default NULL,
    `deleted_timestamp` int(10) unsigned default NULL,
    `is_deleted` tinyint(3) default NULL,
    PRIMARY KEY  (`item_id`),
    KEY `timestamp` (`timestamp`)
);


CREATE TABLE `xoonips_oaipmh_resumption_token` (
    `resumption_token` varchar(255) NOT NULL default '',
    `metadata_prefix` varchar(255) default NULL,
    `verb` varchar(32) default NULL,
    `args` text,
    `last_item_id` int(11) default NULL,
    `limit_row` int(11) default NULL,
    `publish_date` int(11) default NULL,
    `expire_date` int(11) default NULL,
    PRIMARY KEY  (`resumption_token`)
);


CREATE TABLE `xoonips_oaipmh_repositories` (
    `repository_id` int(11) unsigned NOT NULL auto_increment,
    `URL` varchar(255) default NULL,
    `last_access_date` int(11) unsigned default NULL,
    `last_success_date` int(11) unsigned default NULL,
    `last_access_result` text,
    `sort` int(10) unsigned NOT NULL default '0',
    `enabled` int(1) unsigned NOT NULL default '1',
    `deleted` int(1) unsigned NOT NULL default '0',
    PRIMARY KEY  (`repository_id`),
    UNIQUE KEY `url` (`URL`)
);

CREATE TABLE `xoonips_oaipmh_metadata` (
    `identifier` varchar(255) NOT NULL default '',
    `repository_id` int(11) unsigned NOT NULL default '0',
    `format` varchar(255) NOT NULL default '',
    `metadata` blob,
    `title` text,
    `search_text` text,
    PRIMARY KEY  (`identifier`),
    FULLTEXT KEY `search` (`search_text`)
);

    
CREATE TABLE xoonips_related_to (
  parent_id int(11) NOT NULL default '0',
  item_id int(11) NOT NULL default '0',
  PRIMARY KEY  (parent_id,item_id)
);
