<?php
//  $Revision: 1.23.2.6 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

/** display tree in iframe. Tree's state(open/close) and state checkbox are memorized in cookie.
 * input:
 *   $_GET['checkbox']
 *           0:no check in checkbox(default), 1:checked in checkbox
 *   $_GET['bcheckbox']
 *           0:no checkbox in binders(default), 1:checkboxes in binders
 *   $_GET['url']
 *           Page that user moves to when user clicks index.
 *           no $_GET{'url']: listeitem.php(default),  "": don't link
 *           not to contain since '?'
 *   $_GET['form']
 *           Name of form to submit when users click index.
 *           we can specify form in window.top.document.
 *           for xoonips/itemselect.php
 *           When the arguments of forms are given, 
 *           form.action, index_id in form, and op in form change and submit in clicked index change.
 *           And argument of url is invalid.
 *   $_GET['hide_binders']
 *           0:not hide Binders(default), 1:hide Binders
 *   $_GET['edit']
 *           0:display only readable index(default), 1:display only editable index
 *   $_GET['check_private']
 *           No specified: not control to enable/disable button(default)
 *           Specified: control to enable/disable button. Button:window.top.document.getElementById($_GET['check_private'])
 *           for page of edit to register item. Next button is disable when Private aren't selected.
 *   $_GET['selected_tab']
 *           No specified:Select tab that selected last time(default), specified:select the specified tab.
 *   $_GET['edit_binder']
 *           Specified:display Private and Public. Display only Binder's checkbox in Public tab.
 *   (If there is window.top.form[].xoonipsCheckedXID, get initial value in checkbox.)
 * 
 * output:
 *   nothing. Getting state of checkbox in onSubmit isn't work of 'tree.php'.
 */


/*
  Succession of information in Open/Close, Checked, and Tab.
  Save/Load information of Open/Close, Checked are done by onUnload, onLoad in tree.php.
  Information of select Tabs are restored byonLoad in tree.php
  Display only Public and Private, when making a Binder. State of Open/Close in group got lost in this case.
  Tab is selected Public's.
  
  Open/Close and Tab in iframe: (in)Initial value are succeeded. (out)When user clicks tab, tab is switched.
    if ( cookie has initial value. ){
      Open/Close = ( get from Cookie )
      select Tab = ( get from Open/Close )
    }
    else {
      Open/Close = ( open only first one )
      select Tab = first one
    }
    
    if ( mode of editting and making Binder ){
      open Public, PrivateTab
      select Tab = Public
    }
  
*/

/* 

opened and visible
	opened: state of open/close in tree
	visible: result of Externals of tree by parameter of opened
	
	node:
		n           : This parameter leads nodes[n].
		xid
		child
		isOpened    : open/close
		isVisible   : visible/invisible
		startOpened
		isLast      : last child node. 1/0  Need to change image in last.
		lastinfo    : ex."001010" it's ancestor's isLast tied.
	
	default
	  isOpened = false
	  isVisible = false
	  startOpened = ( isRoot ? true : false )
	
	mozilla) when node opens, can't drawn again in multiple structure of table. open->close->open->close:The table doesn't expand and contract well.
	IE) If checkboxes add in tree under document, the checks are cleared.
	IE) If checkbox.name is set, can't retrieve by getElementsByName. http://msdn.microsoft.com/library/default.asp?url=/workshop/author/dhtml/reference/properties/name_2.asp
	IE) there is the case that can't scroll right position in scrollTo. http://www.issociate.de/board/post/273978/Why_is_the_scrolling_function_not_working_with_Internet_Explorer.html
*/


	$times = array();
	$times[__LINE__] = posix_times();
	//$xoopsOption['pagetype'] = 'user';
	$xoopsOption['pagetype'] = "pmsg";
	include_once "../../mainfile.php";

	$times[__LINE__] = posix_times();
	include_once XOOPS_ROOT_PATH.'/class/module.textsanitizer.php';
	include_once XOOPS_ROOT_PATH . '/modules/system/constants.php';

	$config_handler =& xoops_gethandler('config');
	$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);

	require_once 'include/create_session.php';
	require_once 'include/encode.php';
	include_once 'condefs.php';
	xnp_load_init_create_session();
	$xnpsid = $_SESSION['XNPSID'];
	
	
	// tree node images
	define("T1_GIF", "images/t1.gif");
	define("T2_GIF", "images/t2.gif");
	define("T3_GIF", "images/t3.gif");
	define("T4_GIF", "images/t4.gif");
	define("T5_GIF", "images/t5.gif");
	define("T6_GIF", "images/t6.gif");
	define("T7_GIF", "images/t7.gif");
	define("T8_GIF", "images/t8.gif");
	define("T9_GIF", "images/t9.gif");
	
	
	
	if ( !empty($xoopsUser) ){
		$uid = $xoopsUser->getVar('uid');
	}
	else {
		$uid = UID_GUEST;
	}

	$guest_enabled = xnp_is_valid_session_id(XNPSID_GUEST);
	if ( $uid == UID_GUEST && !$guest_enabled ){
		xoops_header( false );
		echo "</head><body><div style='font-size: 10pt;'>";
		echo _MD_XOONIPS_INDEX_FORBIDDEN;
		echo "</div>";
		xoops_footer();
		exit;
	}

	include_once 'include/gentree.php';
	
	$edit_binder = !empty( $_GET['edit_binder'] );
	
	$indexes = genIndexTree0( $xnpsid );
	if ( $edit_binder )
		filterPublicPrivateIndex( $indexes, $uid );
	else if ( xnp_is_moderator( $xnpsid, $uid ) )
		filterMyIndex( $indexes, $xnpsid, $uid );
	else
		;
	if ( !empty( $_GET['edit'] ) )
		filterEditableIndex( $indexes, $xnpsid, $uid );
	
	if ( !empty( $_GET['hide_binders'] ) )
		filterNonbinderIndex( $indexes );
	
	$indexes = genIndexTree1( $indexes );
	

	$checkbox = !empty( $_GET['checkbox'] );
	$bcheckbox = !empty( $_GET['bcheckbox'] );
	$check_private = false;
	if ( !empty( $_GET['check_private'] ) )
		$check_private = $_GET['check_private'];
	
	// get number of items under nodes (by index).
	// use special function.
	$itemCounts = array();
	$result = xnp_get_item_count_group_by_index( $xnpsid, $itemCounts );
	$xid2n = array();
	
	$ct = count($indexes);
	for ( $i = 0; $i < $ct; $i++ ){ // can't change value in foreach
		$index = &$indexes[$i];
		$index_id = $index['item_id'];
		$index['n'] = $i;
		$index['checkPrivate'] = (int)( $check_private && $index['open_level'] == OL_PRIVATE );
		$index['hasCheckbox'] = (int)( $edit_binder ?
		     ($index_id == IID_BINDERS || $index['open_level'] != OL_PUBLIC) :
		     ($index_id == IID_BINDERS && $bcheckbox || $index_id != IID_BINDERS && $checkbox )
		);
		$xid2n[$index_id] = $i;
	}
	unset( $index );
	
?>
<<? echo "?"; ?>xml version="1.0" encoding="<?php echo _CHARSET;?>">
<?
	xoops_header( false );
?>
  <style type="text/css">
  <!--
  .directory { font-size: 10pt; font-weight: bold; }
  .directory p { margin: 0px; white-space: nowrap; line-height: 10pt; vertical-align: text-bottom; }
  .el { margin: 0px; white-space: nowrap; vertical-align: text-bottom; font-size: 10pt; font-weight: bold; }
  .directory div { margin: 0px; white-space: nowrap; }
  .directory img { vertical-align: text-bottom; }
  .directory table {  border-spacing: 0px; margin: 0px; border: 0px; padding: 0px; height: 19px;}
  -->
  </style>
<script type="text/javascript" src="treelib.js">
</script>
<script type="text/javascript">
<!-- // Hide script from old browsers

var scrollPositions = {};

function saveScrollPosition( xid ){
	if ( window.pageXOffset || window.pageYOffset ){
		scrollPositions['x'+xid] = window.pageXOffset;
		scrollPositions['y'+xid] = window.pageYOffset;
	}
	else if ( document.documentElement && 
	    ( document.documentElement.scrollLeft || document.documentElement.scrollTop ) ){
		scrollPositions['x'+xid] = document.documentElement.scrollLeft;
		scrollPositions['y'+xid] = document.documentElement.scrollTop;
	}
	else if ( document.body ){
		scrollPositions['x'+xid] = document.body.scrollLeft;
		scrollPositions['y'+xid] = document.body.scrollTop;
	}
	else
		return;
	
	var ar = new Array();
	for ( var key in scrollPositions )
		ar.push( key + "/" + scrollPositions[key] );
	document.cookie = "xoonipScroll=" + ar.join( ',' );
	//window.alert("saveScroll=" + ar.join( ',' ));
}

function restoreScrollPosition( xid ){
	var str = getCookie('xoonipScroll');
	if ( str ){
		var ar = str.split(',');
		for ( var i = 0; i < ar.length; i++ ){
			var keyval = ar[i].split('/');
			scrollPositions[keyval[0]] = keyval[1];
		}
		
		var x = Number(scrollPositions['x'+xid]);
		var y = Number(scrollPositions['y'+xid]);
		if ( x || y ){
			//window.scrollTo( x, y ); // IE fails ( only if y>height/2 ?? )
			setTimeout('window.scrollTo('+x+', '+y+')',1);
		}
	}
}


function onClickImg(){
	var n = this.n;
	setOpened( n, !Boolean(nodes[n].isOpened) );
}

function toggleCheckbox(){
	var xid = this.xid;
	var n = this.n;
	var checkbox = nodes[n].checkbox;
	if ( checkbox ){
		var b = checkbox.checked;
		checkbox.checked = !b;
		if ( checkbox.onclick )
			checkbox.onclick(); // onClickCheckbox();
	}
	return false;
}


var treeHere;
var url = "<? echo isset( $_GET['url'] ) ? htmlspecialchars($_GET['url']) : 'listitem.php'; ?>";
var linkIsCheckbox = <? echo (int)( $checkbox || $edit_binder ); ?>;
var formname = "<? echo empty($_GET['form']) ? '' : htmlspecialchars($_GET['form']); ?>";
var xid2n = {};
var checkedPrivateCount = 0;

function NodeInfo( n_, xid_, child_, hasCheckbox_, checkPrivate_, isLast_, title_ ){
	this.n = n_;
	this.xid = xid_;
	this.child = child_;
	this.hasCheckbox = hasCheckbox_;
	this.checkPrivate = checkPrivate_;
	this.isLast = isLast_;
	this.title = title_;
	this.isOpened = false;
	this.isVisible = false;
	this.onceOpened = false;
	xid2n['x'+xid_] = n_;
}

var nodes = [
<?php
	
	function xnpEntity2Ecma262sub( $str ){
		return sprintf( '\\u%04x', (int)$str[1] );
	}
	
	// \ -> \\
	// " -> \"
	// &#ddddd; => \uxxxx(ECMA262)
	// EUC characters in $str => unicode (in browser)
	function xnpEntity2Ecma262($str){
		return preg_replace_callback('/&#([0-9]+);/i', 'xnpEntity2Ecma262sub', 
		  str_replace(array('\\', '"'), array('\\\\', '\\"'), $str ));
	}
	
	$length = count($indexes);
	$sep = "";
	foreach( $indexes as $i => $index ){
		$xid         = $index['item_id'];
		$childCount  = $index['child_count'];
		$isLast      = $index['is_last'] ? 1 : 0;
		$hasCheckbox = $index['hasCheckbox'];
		$checkPrivate= $index['checkPrivate'];
		$htmlTitle   = xnpEntity2Ecma262($index['title']);
		$itemCount   = isset($itemCounts[$xid]) ? $itemCounts[$xid] : 0;
		if ( $itemCount )
			$htmlTitle .= "($itemCount)";
		
		if ( $childCount == 0 ){
			echo "$sep new NodeInfo( $i, $xid, null, $hasCheckbox, $checkPrivate, $isLast, \"$htmlTitle\" )\n";
		}
		else {
			$ar = array();
			foreach ( $index['child'] as $dummy => $child_xid )
				$ar[] = $xid2n[$child_xid];
			echo "$sep new NodeInfo( $i, $xid, [" . implode( ',', $ar ) . "], $hasCheckbox, $checkPrivate, $isLast, \"$htmlTitle\" )\n";
		}
		$sep = ",";
	}

?>
];

var treeRoots = [
<?
	$sep = "";
	foreach( $indexes as $i => $index ){
		if ( $index['depth'] == 1 ){
			echo $sep . $i;
			$sep = ",";
		}
	}
?>
];


function setVisible( n, visible ){
	var node = nodes[n];
	if ( node.isVisible == visible )
		return;
	
	var elem = document.getElementById('node' + n);
	if ( elem == null ) return;
	elem.style.display = ( visible ? 'block' : 'none' );
	node.isVisible = visible;
	
	if ( node.isOpened ){
		var child = node.child;
		if ( child ){
			var len = child.length;
			for ( var i = 0; i < len; i++ ){
				setVisible( child[i], visible );
			}
		}
	}
}

function setOpened( n, opened ){
//	window.alert( 'setopened:' + n );
	var node = nodes[n];
	if ( node.isOpened == opened )
		return;
	
	var child = node.child;
	if ( child == null ){
		return;
	}
	
	var len = child.length;
	
	if ( !node.onceOpened ){
		if ( opened ){
			// create child nodes
			//window.alert( 'creating : ' + n );
			var insertPoint = document.getElementById( 'node' + n ).nextSibling;
			var lastinfo = node.lastinfo;
			for ( var i = 0; i < len; i++ ){
				var child_n = child[i];
				var isLast = ( i == len-1 ) || ( lastinfo == "" );
				CreateClosedElem( child_n, node.isVisible, lastinfo, isLast, treeHere, insertPoint );
				
				if ( nodes[child_n].startOpened )
					setOpened( child_n, true );
			}
			node.onceOpened = true;
		}
	}
	else {
		if ( node.isVisible ){
			for ( var i = 0; i < len; i++ ){
				setVisible( child[i], opened );
			}
		}
	}
	node.isOpened = opened;
}

function openAll(){
	var len = nodes.length;
	for ( var i = 0; i < len; i++ ){
		setOpened( i, true );
	}
}

function closeAll(){
	var len = nodes.length;
	for ( var i = 0; i < len; i++ ){
		setOpened( i, false );
	}
}

var g_checkbox = null;

var g_img9 = null;
var g_img4 = null;
var g_img2 = null;

function CreateClosedElem( n, isVisible, lastinfo, isLast, parent, before ){
	var node = nodes[n];
	if ( node == null ) return false;
	
	node.isLast = isLast;
	node.lastinfo = lastinfo + ( isLast ? "1" : "0" );
	//node.lastinfo = lastinfo;
	
	var text = document.createTextNode( node.title );
	
	var div = document.createElement('DIV');
	parent.insertBefore( div, before );
	div.style.height = '19px';
	div.style.whiteSpace = 'nowrap';
	lastinfo = node.lastinfo;
	var len = lastinfo.length-1;
	
	if ( 0 < len ){
		for ( var i = 0; i < len; i++ ){
			var img = document.createElement('IMG');
			div.appendChild( img );
			if ( i == 0 )                         { img.width =  3; img.height = 19; img.src = '<? echo T9_GIF; ?>'; }
			else if ( lastinfo.charAt(i) == "1" ) { img.width = 10; img.height = 19; img.src = '<? echo T4_GIF; ?>'; }
			else                                  { img.width = 10; img.height = 19; img.src = '<? echo T2_GIF; ?>'; }
		}
/*
		span = document.createElement('span');
		span.width = len*10-7;
		span.height = 19;
		span.src = '<? echo T2_GIF; ?>';
		div.appendChild( span );
*/
	}
	
	var img = document.createElement('IMG');
	div.appendChild( img );
	if ( node.child == null ){
		if ( len == 0 )                         img.src = '<? echo T7_GIF; ?>';
		else if ( lastinfo.charAt(len) == "1" ) img.src = '<? echo T3_GIF; ?>';
		else                                    img.src = '<? echo T1_GIF; ?>';
	}
	else {
		if ( len == 0 )                         img.src = '<? echo T8_GIF; ?>';
		else if ( lastinfo.charAt(len) == "1" ) img.src = '<? echo T6_GIF; ?>';
		else                                    img.src = '<? echo T5_GIF; ?>';
		img.onclick = onClickImg;
		img.n = n;
	}

	
	var toBeChecked = false;
	if ( node.hasCheckbox ){
		var checkbox = document.createElement( 'INPUT' );
		checkbox.type = 'checkbox';
		div.appendChild( checkbox );
		
		if ( node.checkPrivate )
			checkbox.onclick = onClickCheckbox;
		var name = 'c' + node.xid;
		
		if ( node.hiddenCheckbox ){
			var cb = node.hiddenCheckbox;
			if ( cb.parentNode )
				cb.parentNode.removeChild(cb);
			node.hiddenCheckbox = null;
			
			/* avoid IE bug
			   http://www.quirksmode.org/bugreports/archives/2004/10/moving_checkbox.html  
			   If you move a checkbox through the document by W3C DOM methods, the checkbox returns to its default state (checked or unchecked). */
			toBeChecked = true; 
		}
		checkbox.n = n;
		checkbox.name = name;
		node.checkbox = checkbox;
	}
	
	if ( formname ){
		var a = document.createElement( 'A' );
		a.className = 'el';
		a.xid = node.xid;
		a.onclick = xoonipsSubmit;
		a.target = '_top';
		
		div.appendChild( a );
		a.appendChild( text );
	}
	else if ( linkIsCheckbox ){
		if ( node.hasCheckbox ){
			var a = document.createElement( 'A' );
			a.className = 'el';
			a.href = '';
			a.onclick = toggleCheckbox;
			a.xid = node.xid;
			a.n = n;
			a.target = '_top';
			
			div.appendChild( a );
			a.appendChild( text );
		}
		else {
			div.appendChild( text );
		}
	}
	else if ( url ){
		var a = document.createElement( 'A' );
		a.className = 'el';
		a.href = url + '?index_id=' + node.xid;
		a.target = '_top';
		
		div.appendChild( a );
		a.appendChild( text );
	}
	else {
		div.appendChild( text );
	}
	
	div.id = 'node' + n;
	
	if ( !isVisible )
		div.style.display = 'none';
	node.isVisible = isVisible;
	
	if ( toBeChecked )
		node.checkbox.checked = true;
	
	return div;
}


// scroll position save/restore



function selectTab( xid ){
	var selectedXid = getSelectedTab();
	if ( selectedXid != null ){
		saveScrollPosition( selectedXid );
	}
	
	for ( var i = 0; i < treeRoots.length; i++ ){
		var n = treeRoots[i];
		setVisible( n, nodes[n].xid == xid );
	}
	
	restoreScrollPosition( xid );
}

function getSelectedTab(){
	for ( var i = 0; i < treeRoots.length; i++ ){
		var n = treeRoots[i];
		if ( nodes[n].isVisible ){
			//window.alert( 'selectedTab:' + n + '/' + nodes[n].xid );
			return nodes[n].xid;
		}
	}
	return null;
}

function clearCheck(){
	var checkboxes = document.getElementsByTagName( 'input' );
	var len = checkboxes.length;
	
	for ( var i = 0; i < len; i++ )
		checkboxes[i].checked = false;
}

function getOpenState(){
	var len = nodes.length;
	var opens = new Array();
	var slen = 0;
	for ( var i = 0; i < len; i++ ){
		if ( nodes[i].isOpened )
			opens[slen++] = nodes[i].xid;
	}
	return opens.join(',');
}

function getCheckState(){
	var inputs = document.getElementsByTagName( 'input' );
	var len = inputs.length;
	var checks = new Array();
	var slen = 0;
	for ( var i = 0; i < len; i++ ){
		var name = inputs[i].name;
		var index_id = name.substr(1);
		if ( inputs[i].checked )
			checks[slen++] = index_id;
	}
	return checks.join( ',' );
}

function initializeTree( openXids ){
	var ar = openXids.split(',');
	var hash = new Object();
	
	// create xid -> isOpened table
	for ( var i = 0; i < ar.length; i++ )
		hash[ar[i]] = true;
	
	for ( var i = 0; i < nodes.length; i++ ){
		var node = nodes[i];
		var xid = node.xid;
		if ( hash[String(xid)] == true ){
			nodes[i].startOpened = true;
		}
	}
	
	var endmark = document.getElementById('xoonipsTreeEndmark');
	for ( var i = 0; i < treeRoots.length; i++ ){
		var n = treeRoots[i];
		var elem = CreateClosedElem( n, false, "", true, treeHere, endmark );
		setOpened( n, true ); // create top-level node(public/group/private)
		//setVisible( n, true );
	}
	
}

// get cookie value
function getCookie(Name) {
	var search = Name + "=";
	if (document.cookie.length > 0) { // if there are any cookies
		offset = document.cookie.indexOf(search);
		if (offset != -1) { // if cookie exists 
			offset += search.length;
			// set index of beginning of value
			end = document.cookie.indexOf(";", offset);
			// set index of end of cookie value
			if (end == -1) 
				end = document.cookie.length;
			return unescape(document.cookie.substring(offset, end));
		} 
	}
	return null;
}

function onLoad(){
	treeHere = document.getElementById('xoonipsTreeHere');
	treeHere.setOpened = setOpened;
	treeHere.setVisible= setVisible;
	treeHere.openAll   = openAll;
	treeHere.closeAll  = closeAll;
	treeHere.selectTab = selectTab;
	treeHere.getSelectedTab = getSelectedTab;
	treeHere.clearCheck     = clearCheck;
	treeHere.getOpenState   = getOpenState;
	treeHere.getCheckState  = getCheckState;
	
	var checkedInputs = window.top.document.getElementsByName( 'xoonipsCheckedXID' );
	if ( checkedInputs.length != 0 ){
		xoonipsCheckState2 = checkedInputs.item(0).value;
	}
	else {
		xoonipsCheckState2 = getCookie('xoonipsCheckState2');
	}
	
	xoonipsOpenState2 = getCookie('xoonipsOpenState2');
	initializeTree(String(xoonipsOpenState2));
	
	// select tab
	// tab selection priority: $_GET['selected_tab'] > xoonipsSelectedTab2 > min(xid)
	var f = selectTab;
	if ( window.top.document.xoonipsOpenTab )
		f = window.top.document.xoonipsOpenTab;
	xoonipsSelectedTab2 = <?php echo isset($_GET['selected_tab']) ? $_GET['selected_tab'] : 'null'; ?>;
	if ( !(xoonipsSelectedTab2) ) xoonipsSelectedTab2 = getCookie('xoonipsSelectedTab2');
	var xid = Number(xoonipsSelectedTab2);
	if ( xid > 0 && window.top.document.getElementById('xoonipsTab'+xid) ){
		f( xid );
	}
	else {
		f( nodes[treeRoots[0]].xid );
	}
	
	// restore check state
	if ( xoonipsCheckState2 ){
		var checks = xoonipsCheckState2.split( ',' );
		var hiddenCheckHere = document.getElementById('hiddenCheckHere');
		len = checks.length;
		
		for ( i = 0; i < len; i++ ){
			var xid = checks[i];
			var n = xid2n['x'+xid];
			
			if ( n == undefined ) // invalid xid
				continue;
			if ( nodes[n].checkbox ){
				nodes[n].checkbox.checked = true;
			}
			else {
				var cb = document.createElement('INPUT');
				cb.type = 'checkbox';
				cb.name = 'c' + xid;
				hiddenCheckHere.appendChild( cb );
				cb.checked = true;
				nodes[n].hiddenCheckbox = cb;
			}
			if ( nodes[n].checkPrivate )
				checkedPrivateCount++;
		}
	}
	
	onClickCheckbox();
}

// save tree state to cookie
function onUnload(){
	xoonipsOpenState2   = treeHere.getOpenState();
	xoonipsCheckState2  = treeHere.getCheckState();
	xoonipsSelectedTab2 = treeHere.getSelectedTab();
	
	document.cookie = "xoonipsOpenState2=" + xoonipsOpenState2;
	document.cookie = "xoonipsCheckState2=" + xoonipsCheckState2;
	document.cookie = "xoonipsSelectedTab2=" + xoonipsSelectedTab2;
	saveScrollPosition( xoonipsSelectedTab2 );
}

<?php
	if ( !empty( $_GET['form'] ) && 1 == preg_match( '/^([0-9A-Za-z_]+)$/', $_GET['form'] ) ){
	// submit form in click
?>
function xoonipsSubmit(){
	// 
	var index_id = this.xid;
	var formname = "<?php echo $_GET['form']; ?>";
	var form = window.top.document.getElementsByName(formname).item(0);
	if ( form == null ){
		window.alert( 'form element (' + formname + ') not found' );
		return false;
	}
	// 
	var objs = window.top.document.getElementsByName("index_id");
	var i;
	for ( i = 0; i < objs.length; i++ ){
		var obj = objs.item(i);
		if ( obj.form == form ){
			// send with index_id
			obj.value = index_id;
			break;
		}
	}
	if ( i == objs.length ){
		window.alert( 'index_id element not found' );
		return false;
	}
	
	objs = window.top.document.getElementsByName("op");
	for ( i = 0; i < objs.length; i++ ){
		var obj = objs.item(i);
		if ( obj.form == form ){
			// send with index_id
			obj.value = 'index';
			break;
		}
	}
	if ( i == objs.length ){
		window.alert( 'op element not found' );
		return false;
	}
	
	form.action = "<?php echo XOOPS_URL . '/modules/xoonips/itemselect_register.php'; ?>";
	form.submit();
	return false;
}
<?php
	}
?>

function isPrivateChecked(){
	return ( 0 < checkedPrivateCount );
}

function onClickCheckbox(){
	var id = '<?php if ( $check_private ) echo $check_private; ?>';
	if ( id != '' ){
		if ( this && this.n && nodes[this.n].checkPrivate ){
			if ( this.checked ) checkedPrivateCount++;
			else                checkedPrivateCount--;
		}
		//window.alert( 'checked=' + checkedPrivateCount );
		var button = window.top.document.getElementById(id);
		var message_label = window.top.document.getElementById('message_label');
		if ( button != null ){
			var b = isPrivateChecked();
			button.disabled = !b;
			if ( message_label )
				message_label.style.display = b ? 'none' : 'inline';
		}
	}
}

// End script hiding -->    
</script>
</head>

<body onLoad="onLoad();" onUnload="onUnload();">
<form action="#">
<div class="directory" id='xoonipsTreeHere'>
 <div id='xoonipsTreeEndmark'>
 </div>
 <div id='hiddenCheckHere' style='display: none;' >
 </div>
</div>
</form>
<?
/*	foreach ( $times as $key=>$val ){
		echo " $key " . $val['ticks'] . "<br>";
	}
*/
	xoops_footer();
?>
