<?php
include_once XOOPS_ROOT_PATH . "/modules/xoonips/class/item.php";
include_once XOOPS_ROOT_PATH . "/modules/xoonips/class/attachment.php";
include_once XOOPS_ROOT_PATH.'/modules/xnpfiles/include/view.php';

class XooNIpsFiles extends XooNIpsItem{

    function XooNIpsFiles(){
        parent::XooNIpsItem();
        
        $this->columnLengths = $lengths = $this->getColumnMaxLen( 'xnpfiles_item_detail' );
        $this->initVar('data_file_name'    , XOBJ_DTYPE_TXTBOX, null, false, $lengths['data_file_name'    ]);
        $this->initVar('data_file_mimetype', XOBJ_DTYPE_TXTBOX, null, false, $lengths['data_file_mimetype']);
        $this->initVar('data_file_filetype', XOBJ_DTYPE_TXTBOX, null, false, $lengths['data_file_filetype']);
        $this->initVar('files_file'        , XOBJ_DTYPE_ARRAY, serialize( array() ), true);
        $this->initVar('preview'        , XOBJ_DTYPE_ARRAY, serialize( array() ), true);
        $this->attachment_info = array(
            'files_file' => array( 'multiple' => false ),
            'preview'   => array( 'multiple' => true  ),
        );
    }

    function cleanVars()
    {
        if ( !parent::cleanVars() )
            return false;
        
        $vals = array(
            'data_file_name'    => $this->getVar('data_file_name'    ,'n'),
            'data_file_mimetype'=> $this->getVar('data_file_mimetype','n'),
            'data_file_filetype'=> $this->getVar('data_file_filetype','n'),
        );
        $ar = $this -> stripSurplusString( $this->columnLengths, $vals );
        foreach ( $vals as $key => $val ){
            if ( isset( $ar[$key] ) ){
                $this -> setErrors( E_XOONIPS_DATA_TOO_LONG, "detail $key is too long :" . $val . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                $this->cleanVars[$key] = $ar[$key];
                $retval = false;
            }
            else
                $this->cleanVars[$key] = $val;
        }
        
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            if ( !$info['multiple'] && count($attachments) > 1 ){
                $this -> setErrors( E_XOONIPS_ATTACHMENT_HAS_REDUNDANT, "multiple $name attachments is not allowed" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                $retval = false;
            }
            for ( $i = 0; $i < count($attachments); $i++ )
                if ( !$attachments[$i]->cleanVars() )
                    $retval = false;
            $this->setVar($name, serialize($attachments));
        }
        
        return true;
    }

    /**
     * 
     * for attachment file
     * 
     */
    var $file = null;
    var $attachment_info;
    
    // for column length check
    var $columnLengths;
    
    function startElement($parser, $name, $attribs){
        global $xoopsDB;
        
        parent::startElement($parser, $name, $attribs);

//            echo "\nS ".implode( '/', $this -> tagstack )."\tattributes=";print_r($attribs);
        switch( implode( '/', $this -> tagstack ) ){
        case "ITEM/DETAIL":
            foreach ( $this->attachment_info as $name => $info )
                $this->setVar( $name, serialize(array()), true );
            break;
        case "ITEM/DETAIL/FILE":
            $result = $xoopsDB -> query( "select value from " . $xoopsDB -> prefix( "xoonips_config" ) . " where name='upload_dir'" );
            if( $result ){
                list( $upload_dir ) = $xoopsDB -> fetchRow( $result );
                $this -> file = new XooNIpsAttachment( $this -> attachment_dir, $upload_dir );
            }else{
                $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getParserErrorAt( $parser ) );
            }
            break;
        }

        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> startElement( $parser, $name, $attribs );
        }
    }

    function endElement($parser, $name) { 
        global $xoopsDB;
        

        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> endElement( $parser, $name );
        }

        switch( implode( '/', $this -> tagstack ) ){
        case "ITEM/DETAIL":
            $keys = array(
                'data_file_name'    ,
                'data_file_mimetype',
                'data_file_filetype',
            );
            foreach ( $keys as $key )
                if ( is_null($this->getVar($key,'n')) )
                    $this -> setErrors( E_XOONIPS_TAG_NOT_FOUND, " no $key tag " . $this -> getParserErrorAt( $parser ) );
            break;
        case "ITEM/DETAIL/DATA_FILE_NAME":
        case "ITEM/DETAIL/DATA_FILE_MIMETYPE": 
        case "ITEM/DETAIL/DATA_FILE_FILETYPE": 
            $this -> setVar( strtolower( end( $this -> tagstack ) ) , encodeMeta2Server( end( $this -> cdata ) ), true );
            break;
        case "ITEM/DETAIL/FILE":
            if( isset( $this -> file ) ){
                $file_type_id = $this->file->getVar('file_type_id');
                if ( $file_type_id ){
                    $sql = "select name from " . $xoopsDB->prefix('xoonips_file_type') . " where file_type_id=$file_type_id";
                    $result = $xoopsDB->query( $sql );
                    if ( $result ){
                        if ( $xoopsDB->getRowsNum($result) ){
                            list( $name ) = $xoopsDB->fetchRow( $result );
                            if ( isset( $this->attachment_info[$name]) ){
                                $info = $this->attachment_info[$name];
                                $attachments = $this->getVar($name);
                                if ( count( $attachments ) && !$info['multiple'] )
                                    $this -> setErrors( E_XOONIPS_ATTACHMENT_HAS_REDUNDANT, "multiple $name attachments is not allowed" . $this -> getParserErrorAt( $parser ) );
                                $attachments[] = $this->file;
                                $this -> setVar( $name, serialize( $attachments ), true );
                                break;
                            }
                            else 
                                $this -> setErrors( E_XOONIPS_ATTR_INVALID_VALUE, "unknown file_type_name($name) " . $this -> getParserErrorAt( $parser ) );
                        }
                        else
                            $this -> setErrors( E_XOONIPS_ATTR_INVALID_VALUE, "unknown file_type_id($file_type_id) " . $this -> getParserErrorAt( $parser ) );
                    }
                    else
                        $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getParserErrorAt( $parser ) );
                }
                else
                    $this -> setErrors( E_XOONIPS_ATTR_NOT_FOUND, " no file_type_id " . $this -> getParserErrorAt( $parser ) );
                
                // include $this->file->_error, error_codes
                $errors = $this->file->getErrors();
                $codes = $this->file->getErrorCodes();
                for ( $i = 0; $i < count($errors); $i++ )
                    $this->setErrors( $codes[$i], $errors[$i] );
            }
            break;
        }

        parent::endElement($parser, $name);
    }
    
    function characterData($parser, $data) {
        
        parent::characterData($parser, $data);

//        echo "\nC ".implode( '/', $this -> tagstack )."\t${data}";
        switch( implode( '/', $this -> tagstack ) ){
/*
        case "ITEM/DETAIL/TAGNAME":
            ....... 
            break;
*/
        }
        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> characterData( $parser, $data );
        }
    }
    
    /** 
     */
    
    /**
     * insert/update object
     *   
     * @return false if failed, true if insert successfully or already exists and unchanged.
     *   
     */
    function insert()
    {
        global $xoopsDB;
        
        if ($this->isNew()) {
            if( !parent::insert() ) return false;

            $keys = implode( ",", array(
                'files_id'           ,
                'data_file_name'     ,
                'data_file_mimetype' ,
                'data_file_filetype' ,
            ) );
            $vals = implode( ",", array(
                $this -> getVar( 'item_id' ),
                is_null( $this -> cleanVars[ 'data_file_name'     ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'data_file_name'     ] ),
                is_null( $this -> cleanVars[ 'data_file_mimetype' ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'data_file_mimetype' ] ),
                is_null( $this -> cleanVars[ 'data_file_filetype' ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'data_file_filetype' ] ),
                ) );
            $sql = "INSERT INTO " . $xoopsDB->prefix("xnpfiles_item_detail") . " ( $keys ) VALUES ( $vals ) ";
        } else {
            if( !parent::insert() ) return false;
            $item_id = $this->getVar('item_id');
            $keyval = implode( ', ', array(
                 'data_file_name'     . '=' . ( is_null( $this -> cleanVars[ 'data_file_name'     ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'data_file_name'     ] ) ),
                 'data_file_mimetype' . '=' . ( is_null( $this -> cleanVars[ 'data_file_mimetype' ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'data_file_mimetype' ] ) ),
                 'data_file_filetype' . '=' . ( is_null( $this -> cleanVars[ 'data_file_filetype' ] ) ? 'null' : $xoopsDB -> quoteString( $this -> cleanVars[ 'data_file_filetype' ] ) ),
            ));
            $sql = "UPDATE " . $xoopsDB->prefix("xnpfiles_item_detail") . " set $keyval where files_id=$item_id";
        }
        $result = $xoopsDB->query($sql);
        if (!$result) {
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        // remove old attachment information 
        $item_id = $this->getVar('item_id');
        $sql = "select file_id from " . $xoopsDB->prefix('xoonips_file') . " where item_id=$item_id";
        $result = $xoopsDB->query($sql);
        if (!$result) {
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        while ( list($file_id) = $xoopsDB->fetchRow($result) ){
            $file = new XooNIpsAttachment(null,null);
            $file->setVar('item_id', $item_id);
            $file->setVar('file_id',$file_id);
            if ( !$file->delete() ){
                // include $file->_error, error_codes
                $errors = $file->getErrors();
                $codes = $file->getErrorCodes();
                for ( $i = 0; $i < count($errors); $i++ )
                    $this->setErrors( $codes[$i], $errors[$i] );
                return false;
            }
        }
        
        // register attachment files
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $attachments[$i] -> setVar( 'item_id', $this -> getVar( 'item_id' ) );
                if ( !$attachments[$i] -> insert() ){
                    @$this -> delete();
                    // 
                    // before return false, set attachments array to keep error message of attachment object
                    // 
                    $this->setVar( $name, serialize($attachments) );
                    return false;
                }
            }
            $this->setVar( $name, serialize($attachments) );
        }
        
        if( $this -> isNew() ){
            $this -> unsetNew();//item is not new because it was inserted
        }
        return true;
    }
    
    /**
     * delete an item from the database
     * 
     * @return false if failed, true if delete successfully
     *   
     */
    function delete(){
        global $xoopsDB;
        
        if( !parent::delete() ) return false;
        
        
        $sql = sprintf( "DELETE FROM %s WHERE files_id = %u", $xoopsDB->prefix( "xnpfiles_item_detail" ), $this -> getVar( 'files_id' ) );
        $result = $xoopsDB->query( $sql );
        if (!$result) {
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        
        // delete files
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $attachments[$i]->delete();
            }
        }
        
        return true;
    }
    
    function getErrors(){
        $ar = parent::getErrors();
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar = array_merge( $ar, $attachments[$i] -> getErrors() );
            }
        }
        return $ar;
    }
    
    function getErrorCodes(){
        $ar = parent::getErrorCodes();
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar = array_merge( $ar, $attachments[$i] -> getErrorCodes() );
            }
        }
        return $ar;
    }
    
    function toString( $htmlspecialchars = false ){
        $ar = array( parent::toString( $htmlspecialchars ) );
        
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar[] = $attachments[$i] -> toString($htmlspecialchars);
            }
        }
        
        foreach ( $this->columnLengths as $key => $dummy ){
            if ( $key == 'files_id' ) continue;
            $val = $this->getVar($key,'n');
            if( extension_loaded( 'mbstring' ) ){
                $val = mb_ereg_replace( '\n', '\n', mb_ereg_replace( '\\\\', '\\\\', $val ) );
            }else{
                $val = str_replace( array( "\\", "\n" ), array( "\\\\", "\\n" ), $val );
            }
            $ar[] = "detail.$key " . ( $htmlspecialchars ? htmlspecialchars($val) : $val );
        }
        
        return implode( "\n", $ar );
    }
    
}
?>
