<?php
include_once XOOPS_ROOT_PATH . "/modules/xoonips/class/item.php";
include_once XOOPS_ROOT_PATH . "/modules/xoonips/class/attachment.php";
include_once XOOPS_ROOT_PATH . "/modules/xnppaper/include/view.php";

class XooNIpsPaper extends XooNIpsItem{

    function XooNIpsPaper(){
        parent::XooNIpsItem();
        $this->columnLengths = $lengths = $this->getColumnMaxLen( 'xnppaper_item_detail' );
        $this->initVar('authors'    , XOBJ_DTYPE_ARRAY, serialize(null), true);
        $this->initVar('journal'    , XOBJ_DTYPE_TXTBOX, null, false, $lengths['journal'    ]);
        $this->initVar('volume'     , XOBJ_DTYPE_TXTBOX, null, false, $lengths['volume'     ]);
        $this->initVar('number'     , XOBJ_DTYPE_TXTBOX, null, false, $lengths['number'     ]);
        $this->initVar('page'       , XOBJ_DTYPE_TXTBOX, null, false, $lengths['page'       ]);
        $this->initVar('abstract'   , XOBJ_DTYPE_TXTBOX, null, false, $lengths['abstract'   ]);
        $this->initVar('pubmed_id'  , XOBJ_DTYPE_TXTBOX, null, false, $lengths['pubmed_id'  ]);
        $this->initVar('paper_pdf_reprint', XOBJ_DTYPE_ARRAY, serialize( array() ), true);
        $this->attachment_info = array(
            'paper_pdf_reprint' => array( 'multiple' => false ),
        );
    }

    function cleanVars()
    {
        if ( !parent::cleanVars() )
            return false;
        
        $vals = array(
            'author'   => implode( "\n", $this->getVar('authors'  ,'n') ),
            'journal'  => $this->getVar('journal'  ,'n'),
            'volume'   => $this->getVar('volume'   ,'n'),
            'number'   => $this->getVar('number'   ,'n'),
            'page'     => $this->getVar('page'     ,'n'),
            'abstract' => $this->getVar('abstract' ,'n'),
            'pubmed_id'=> $this->getVar('pubmed_id','n'),
        );
        $ar = $this -> stripSurplusString( $this->columnLengths, $vals );

        foreach ( $vals as $key => $val ){
            if ( isset( $ar[$key] ) ){
                $this -> setErrors( E_XOONIPS_DATA_TOO_LONG, "detail $key is too long :" . $val . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                $this->cleanVars[$key] = $ar[$key];
                $retval = false;
            }
            else
                $this->cleanVars[$key] = $val;
        }
        $this->cleanVars['authors'] = explode( "\n", $this->cleanVars['author']);
        
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            if ( !$info['multiple'] && count($attachments) > 1 ){
                $this -> setErrors( E_XOONIPS_ATTACHMENT_HAS_REDUNDANT, "multiple $name attachments is not allowed" . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                $retval = false;
            }
            for ( $i = 0; $i < count($attachments); $i++ )
                if ( !$attachments[$i]->cleanVars() )
                    $retval = false;
            $this->setVar($name, serialize($attachments));
        }
        
        return true;
    }

    /**
     * 
     * for attachments(PDF reprint)
     * 
     */
    var $file = null;
    var $attachment_info;
    
    // for column length check
    var $columnLengths;
    
    /**
     * 
     * override parse method
     * 
     * @param xml parsed xml text 
     * @param attachment_dir
     * @return bool false if failed
     * 
     */
/*
    function parse( $xml, $attachment_dir ){
        $this -> attachment_dir = $attachment_dir;
        return parent::parse( $xml );
    }
*/
    
    function startElement($parser, $name, $attribs){
        global $xoopsDB;
        
        parent::startElement($parser, $name, $attribs);

//        echo "\nS ".implode( '/', $this -> tagstack )."\tattributes=";print_r($attribs);
        switch( implode( '/', $this -> tagstack ) ){
        case "ITEM/DETAIL":
            foreach ( $this->attachment_info as $name => $info )
                $this->setVar( $name, serialize(array()), true );
            break;
        case "ITEM/DETAIL/AUTHORS":
            $this->setVar( 'authors', serialize(array()), true );
            break;
        case "ITEM/DETAIL/FILE":
            $result = $xoopsDB -> query( "select value from " . $xoopsDB -> prefix( "xoonips_config" ) . " where name='upload_dir'" );
            if( $result ){
                list( $upload_dir ) = $xoopsDB -> fetchRow( $result );
                $this -> file = new XooNIpsAttachment( $this -> attachment_dir, $upload_dir );
            }else{
                $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getParserErrorAt( $parser ) );
            }
            break;
        }
        
        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> startElement( $parser, $name, $attribs );
        }
    }

    function endElement($parser, $name) { 
        global $xoopsDB;
        
        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> endElement( $parser, $name );
        }
        
        switch( implode( '/', $this -> tagstack ) ){
        case "ITEM/DETAIL":
            $keys = array(
                'authors'    ,
                'journal'    ,
                'volume'     ,
                'number'     ,
                'page'       ,
                'abstract'   ,
                'pubmed_id'  ,
            );
            foreach ( $keys as $key )
                if ( is_null($this->getVar($key,'n')) )
                    $this -> setErrors( E_XOONIPS_TAG_NOT_FOUND, " no $key tag " . $this -> getParserErrorAt( $parser ) );
            break;
        case "ITEM/DETAIL/AUTHORS/AUTHOR":
//            echo "\nE ".implode( '/', $this -> tagstack );
            $authors = $this -> getVar( 'authors' );
            $authors[] = encodeMeta2Server( end( $this -> cdata ) );
            $this -> setVar( 'authors', serialize( $authors ), true );
            break;
        case "ITEM/DETAIL/JOURNAL": 
        case "ITEM/DETAIL/VOLUME": 
        case "ITEM/DETAIL/NUMBER": 
        case "ITEM/DETAIL/PAGE": 
        case "ITEM/DETAIL/ABSTRACT": 
        case "ITEM/DETAIL/PUBMED_ID": 
            $this -> setVar( strtolower( end( $this -> tagstack ) ) , encodeMeta2Server( end( $this -> cdata ) ), true );
            break;
        case "ITEM/DETAIL/FILE":
            if( isset( $this -> file ) ){
                $file_type_id = $this->file->getVar('file_type_id');
                if ( $file_type_id ){
                    $sql = "select name from " . $xoopsDB->prefix('xoonips_file_type') . " where file_type_id=$file_type_id";
                    $result = $xoopsDB->query( $sql );
                    if ( $result ){
                        if ( $xoopsDB->getRowsNum($result) ){
                            list( $name ) = $xoopsDB->fetchRow( $result );
                            if ( isset( $this->attachment_info[$name]) ){
                                $info = $this->attachment_info[$name];
                                $attachments = $this->getVar($name);
                                if ( count( $attachments ) && !$info['multiple'] )
                                    $this -> setErrors( E_XOONIPS_ATTACHMENT_HAS_REDUNDANT, "multiple $name attachments is not allowed" . $this -> getParserErrorAt( $parser ) );
                                $attachments[] = $this->file;
                                $this -> setVar( $name, serialize( $attachments ), true );
                                break;
                            }
                            else 
                                $this -> setErrors( E_XOONIPS_ATTR_INVALID_VALUE, "unknown file_type_name($name) " . $this -> getParserErrorAt( $parser ) );
                        }
                        else
                            $this -> setErrors( E_XOONIPS_ATTR_INVALID_VALUE, "unknown file_type_id($file_type_id) " . $this -> getParserErrorAt( $parser ) );
                    }
                    else
                        $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getParserErrorAt( $parser ) );
                }
                else
                    $this -> setErrors( E_XOONIPS_ATTR_NOT_FOUND, " no file_type_id " . $this -> getParserErrorAt( $parser ) );
                
                // include $this->file->_error, error_codes
                $errors = $this->file->getErrors();
                $codes = $this->file->getErrorCodes();
                for ( $i = 0; $i < count($errors); $i++ )
                    $this->setErrors( $codes[$i], $errors[$i] );
            }
            break;
        }

        parent::endElement($parser, $name);
    }
    
    function characterData($parser, $data) {
        parent::characterData($parser, $data);

//        echo "\nC ".implode( '/', $this -> tagstack )."\t${data}";
        switch( implode( '/', $this -> tagstack ) ){
        }
        if( isset( $this -> file )
            && count( $this -> tagstack ) >= 3
            && $this -> tagstack[ 0 ] == "ITEM"
            && $this -> tagstack[ 1 ] == "DETAIL"
            && $this -> tagstack[ 2 ] == "FILE" ){
            $this -> file -> characterData( $parser, $data );
        }
    }
    
    /**
     * insert/update object
     *
     * @param item $item
     */
    function insert()
    {
        global $xoopsDB;
        
        if ($this->isNew()) {
            if( !parent::insert() ) return false;
            $keys = implode( ",", array(
                'paper_id'           ,
                'author'             ,
                'journal'            ,
                'volume'             ,
                'number'             ,
                'page'               ,
                'abstract'           ,
                'pubmed_id'          
            ) );
            $vals = implode( ",", array(
                $this -> getVar( 'item_id' ),
                                                                   $xoopsDB -> quoteString( implode( "\n", $this -> cleanVars[ 'authors'   ] ) ),
                                                                   $xoopsDB -> quoteString(                $this -> cleanVars[ 'journal'   ] ),
                empty( $this -> cleanVars[ 'volume' ] ) ? 'null' : $xoopsDB -> quoteString(                $this -> cleanVars[ 'volume'    ] ),
                empty( $this -> cleanVars[ 'number' ] ) ? 'null' : $xoopsDB -> quoteString(                $this -> cleanVars[ 'number'    ] ),
                                                                   $xoopsDB -> quoteString(                $this -> cleanVars[ 'page'      ] ),
                                                                   $xoopsDB -> quoteString(                $this -> cleanVars[ 'abstract'  ] ),
                                                                   $xoopsDB -> quoteString(                $this -> cleanVars[ 'pubmed_id' ] )
                ) );
            $sql = "INSERT INTO " . $xoopsDB->prefix("xnppaper_item_detail") . " ( $keys ) VALUES ( $vals ) ";
        } else {
            if( !parent::insert() ) return false;
            $item_id = $this->getVar('item_id');
            $keyval = implode( ', ', array(
                 'author'    . '=' .                                                      $xoopsDB -> quoteString( implode( "\n", $this -> cleanVars[ 'authors'   ] ) ),
                 'journal'   . '=' .                                                      $xoopsDB -> quoteString(                $this -> cleanVars[ 'journal'   ] ),
                 'volume'    . '=' . ( empty( $this -> cleanVars[ 'volume' ] ) ? 'null' : $xoopsDB -> quoteString(                $this -> cleanVars[ 'volume'    ] ) ),
                 'number'    . '=' . ( empty( $this -> cleanVars[ 'number' ] ) ? 'null' : $xoopsDB -> quoteString(                $this -> cleanVars[ 'number'    ] ) ),
                 'page'      . '=' .                                                      $xoopsDB -> quoteString(                $this -> cleanVars[ 'page'      ] ),
                 'abstract'  . '=' .                                                      $xoopsDB -> quoteString(                $this -> cleanVars[ 'abstract'  ] ),
                 'pubmed_id' . '=' .                                                      $xoopsDB -> quoteString(                $this -> cleanVars[ 'pubmed_id' ] ),
            ));
            $sql = "UPDATE " . $xoopsDB->prefix("xnppaper_item_detail") . " set $keyval where paper_id=$item_id";
        }
        $result = $xoopsDB->query($sql);
        if (!$result) {
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        // remove old attachment information 
        $item_id = $this->getVar('item_id');
        $sql = "select file_id from " . $xoopsDB->prefix('xoonips_file') . " where item_id=$item_id";
        $result = $xoopsDB->query($sql);
        if (!$result) {
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        while ( list($file_id) = $xoopsDB->fetchRow($result) ){
            $file = new XooNIpsAttachment(null,null);
            $file->setVar('item_id', $item_id);
            $file->setVar('file_id',$file_id);
            if ( !$file->delete() ){
                // include $file->_error, error_codes
                $errors = $file->getErrors();
                $codes = $file->getErrorCodes();
                for ( $i = 0; $i < count($errors); $i++ )
                    $this->setErrors( $codes[$i], $errors[$i] );
                return false;
            }
        }
        
        // register attachment files
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $attachments[$i] -> setVar( 'item_id', $this -> getVar( 'item_id' ) );
                if ( !$attachments[$i] -> insert() ){
                    @$this -> delete();
                    // 
                    // before return false, set attachments array to keep error message of attachment object
                    // 
                    $this->setVar( $name, serialize($attachments) );
                    return false;
                }
            }
            $this->setVar( $name, serialize($attachments) );
        }
        
        if( $this -> isNew() ){
            $this -> unsetNew();//item is not new because it was inserted
        }
        return true;
    }
    
    /**
     * delete an item from the database
     * 
     * @param object $item reference to the item to delete
     * @return false if failed.
     */
    function delete(){
        global $xoopsDB;
        
        if( !parent::delete() ) return false;
        
        $sql = sprintf( "DELETE FROM %s WHERE paper_id = %u", $xoopsDB->prefix( "xnppaper_item_detail" ), $this -> getVar( 'paper_id' ) );
        $result = $xoopsDB->query( $sql );
        if (!$result) {
            $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            return false;
        }
        
        // delete files
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $attachments[$i]->delete();
            }
        }
        
        return true;
    }
    
    function getErrors(){
        $ar = parent::getErrors();
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar = array_merge( $ar, $attachments[$i] -> getErrors() );
            }
        }
        return $ar;
    }
    
    function getErrorCodes(){
        $ar = parent::getErrorCodes();
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar = array_merge( $ar, $attachments[$i] -> getErrorCodes() );
            }
        }
        return $ar;
    }
    
    function toString( $htmlspecialchars = false ){
        $ar = array( parent::toString( $htmlspecialchars ) );
        
        foreach ( $this->attachment_info as $name => $info ){
            $attachments = $this->getVar($name);
            for ( $i = 0; $i < count($attachments); $i++ ){
                $ar[] = $attachments[$i] -> toString($htmlspecialchars);
            }
        }
        
        foreach ( $this->columnLengths as $key => $dummy ){
            if ( $key == 'paper_id' ) continue;
            if ( $key == 'author' ){
                $authors = $this -> getVar( 'authors','n' );
                if ( is_null( $authors ) )
                    $authors = array();
                $val = implode( "\n", $authors );
            }
            else
                $val = $this->getVar($key,'n');
            if( extension_loaded( 'mbstring' ) ){
                $val = mb_ereg_replace( '\n', '\n', mb_ereg_replace( '\\\\', '\\\\', $val ) );
            }else{
                $val = str_replace( array( "\\", "\n" ), array( "\\\\", "\\n" ), $val );
            }
            $ar[] = "detail.$key " . ( $htmlspecialchars ? htmlspecialchars($val) : $val );
        }
        
        return implode( "\n", $ar );
    }
    
}
?>
