<?php
//  Install script for url module                                               //
//  $Revision: 1.9 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

function xoops_module_install_xnpurl( $xoopsMod ) {
	global $xoopsDB;
	
	// register itemtype
	$table = $xoopsDB->prefix('xoonips_item_type');
	$mid = $xoopsMod->getVar('mid');
	$sql = "INSERT INTO $table ( name, display_name, mid, viewphp ) VALUES ( 'xnpurl', 'Url', $mid, 'xnpurl/include/view.php' )";
	if ( $xoopsDB->query($sql) == FALSE ){
		// cannot register itemtype
		return false;
	}
	
	// register filetype
	$table = $xoopsDB->prefix('xoonips_file_type');
	$mid = $xoopsMod->getVar('mid');
	$sql = "INSERT INTO $table ( name, display_name, mid ) VALUES ( 'url_banner_file', 'Banner', $mid )";
	if ( $xoopsDB->query($sql) == FALSE ){
		// cannot register itemtype
		return false;
	}

	// Delete 'Module Access Rights' from all groups
	// This allows to remove redundant module name in Main Menu
	$member_handler =& xoops_gethandler('member');
	$gperm_handler =& xoops_gethandler('groupperm');
	$groups =& $member_handler->getGroupList();
	foreach ($groups as $groupid2 => $groupname) {
		if ($gperm_handler->checkRight('module_read', $mid, $groupid2)) {
			$criteria = new CriteriaCompo();
			$criteria->add( new Criteria( 'gperm_groupid', $groupid2 ) );
			$criteria->add( new Criteria( 'gperm_itemid', $mid ) );
			$criteria->add( new Criteria( 'gperm_name', 'module_read' ) );
			
			$objects = $gperm_handler->getObjects($criteria);
			if ( count( $objects ) == 1 ){
				$gperm_handler->delete( $objects[0] );
			}
		}
	}
	
	//$item_type_id = $xoopsDB->getInsertId();
	return true;
} 

function xoops_module_uninstall_xnpurl( $xoopsMod ) {
	global $xoopsDB;
	
	$item_type_id = -1;
	$table = $xoopsDB->prefix('xoonips_item_type');
	$mid = $xoopsMod->getVar('mid');
	$sql = "SELECT item_type_id FROM $table where mid = $mid";
	$result = $xoopsDB->query($sql);
	if ( $result ){
		list($item_type_id) = $xoopsDB->fetchRow($result);
	}else{
		echo mysql_error();
		echo $sql;
		return false;
	}
	
	//make item_status.is_deleted to be Deleted
	$table = $xoopsDB->prefix('xoonips_item_basic');
	$sql = "SELECT item_id from ${table} WHERE item_type_id = $item_type_id";
	$result = $xoopsDB->query($sql);
	if ( !$result ){
		echo mysql_error();
		echo $sql;
		return false;
	}
	$ids = array( );
	while( list( $item_id ) = $xoopsDB->fetchRow($result) ){
		$ids[] = $item_id;
	}
	if( count( $ids ) > 0 ){
		$table = $xoopsDB->prefix('xoonips_item_status');
		$sql = "UPDATE ${table} SET deleted_timestamp=UNIX_TIMESTAMP(NOW()), is_deleted=1 WHERE item_id in ( ".implode( ",", $ids ).")";
		if ( $xoopsDB->query($sql) == FALSE ){
			echo mysql_error();
			echo $sql;
			return false;
		}
	}
	
	// remove basic information
	$table = $xoopsDB->prefix('xoonips_item_basic');
	$sql = "DELETE FROM $table where item_type_id = $item_type_id";
	if ( $xoopsDB->query($sql) == FALSE ){
		echo mysql_error();
		echo $sql;
		return false;
	}

	// unregister itemtype
	$table = $xoopsDB->prefix('xoonips_item_type');
	$mid = $xoopsMod->getVar('mid');
	$sql = "DELETE FROM $table where mid = $mid";
	if ( $xoopsDB->query($sql) == FALSE ){
		// cannot unregister itemtype
		return false;
	}
	$table = $xoopsDB->prefix('xoonips_file_type');
	$sql = "DELETE FROM $table where mid = $mid";
	if ( $xoopsDB->query($sql) == FALSE ){
		// cannot unregister filetype
		return false;
	}
	return true;
}

function xoops_module_update_xnpurl ( $xoopsMod, $oldversion) {
	global $xoopsDB;
	switch ($oldversion) { //remember that version is multiplied with 100 to get an integer
	case 100: //perform actions to upgrade from version 1.00
		break;
	case 110: //perform actions to upgrade from version 1.10
		break;
	case 200:
	case 300:
	case 310:
		$sql = "ALTER TABLE " . $xoopsDB->prefix( 'xnpurl_item_detail' ) . " TYPE = innodb";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
		
	case 311:
		break;
	}
	return true;
}
?>
