<?php
//  $Revision: 1.2 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //



include '../../../include/cp_header.php';
if ( file_exists("../language/".$xoopsConfig['language']."/modinfo.php") ) {
	include_once "../language/".$xoopsConfig['language']."/modinfo.php";
} else {
	include_once "../language/english/modinfo.php";
}
if ( file_exists("../language/".$xoopsConfig['language']."/main.php") ) {
	include_once "../language/".$xoopsConfig['language']."/main.php";
} else {
	include_once "../language/english/main.php";
}

$language = $xoopsConfig['language'];
if ( file_exists(XOOPS_ROOT_PATH."/modules/system/language/$language/admin.php") ) {
	include XOOPS_ROOT_PATH."/modules/system/language/$language/admin.php";
} else {
	include XOOPS_ROOT_PATH."/modules/system/language/english/admin.php";
}

include_once XOOPS_ROOT_PATH . '/modules/xoonips/condefs.php';
include_once XOOPS_ROOT_PATH . '/modules/xoonips/include/lib.php';

include_once XOOPS_ROOT_PATH . '/modules/xoonips/oaiclass.php';
include_once XOOPS_ROOT_PATH . '/modules/xoonips/junii.php';

require_once XOOPS_ROOT_PATH . '/modules/xoonips/include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];


$myts =& MyTextSanitizer::getInstance();
if      ( isset($_POST['op']) ) $op = $_POST['op'];
else if ( isset($_GET ['op']) ) $op = $_GET ['op'];
else                            $op = 'main';


$modules = xnpGetFileSearchModules();


/*
 update x3j_xoonips_file set search_text = null, search_module_name = null, search_module_version = null;
*/
switch ($op) {
case 'rescan':
	// եƸ
	$file_table = $xoopsDB->prefix('xoonips_file');
	$sql = "select file_id from $file_table where file_type_id > 4 and item_id is not null"; // file_type_id<=4  preview, readme, license, rights ͽ󤵤ƤΤ
	$result = $xoopsDB->query( $sql );
	while ( list($file_id) = $xoopsDB->fetchRow($result) ){
		xnpExtractText( $file_id, $modules );
	}
	redirect_header('filesearch.php', 1, _MD_AM_DBUPDATED );
	exit;

default:
	
	xoops_cp_header();
	echo "<h4>"._MD_XOONIPS_FILESEARCH."</h4>";
	echo "
        <table width='100%' class='outer' cellpadding='4' cellspacing='1'>
		  <tr>
		    <th>"._MD_XOONIPS_FILESEARCH_NAME."</th>
		    <th>"._MD_XOONIPS_FILESEARCH_VERSION."</th>
		  </tr>";
	
	foreach ( $modules as $key => $module ){
		echo "<tr><td class='even'>".htmlspecialchars($module['display_name'])."</td><td class='even'>".htmlspecialchars($module['version'])."</td></tr>\n";
	}
	
	echo "</table>
		<br>
		<form action='' method='post'>
			<input type='hidden' name='op' value='rescan'>
		" . _MD_XOONIPS_FILESEARCH_RESCAN . "
			<input type='submit' value='"._SUBMIT."'>
		</form>";
	
	xoops_cp_footer();
	break;
}

$a = 0;

?>
