<?php
//  $Revision: 1.2 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

include '../../../include/cp_header.php';
$language = $xoopsConfig['language'];
if ( file_exists(XOOPS_ROOT_PATH."/language/$language/user.php") ) {
	include XOOPS_ROOT_PATH."/language/$language/user.php";
}

if ( file_exists("../language/$language/main.php") ) {
	include "../language/$language/main.php";
} else {
	include "../language/english/main.php";
}

if ( file_exists(XOOPS_ROOT_PATH."/modules/system/language/$language/admin.php") ) {
	include XOOPS_ROOT_PATH."/modules/system/language/$language/admin.php";
} else {
	include XOOPS_ROOT_PATH."/modules/system/language/english/admin.php";
}

include_once '../condefs.php';
include_once '../include/lib.php';
require_once '../include/create_session.php';
require_once XOOPS_ROOT_PATH.'/class/xoopsblock.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

include_once '../install_funcs.php'; // for xoonips_get_default_configs()

include_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";

$myts =& MyTextSanitizer::getInstance();

xoops_cp_header();

if( isset( $_POST['state'] ) && $_POST['state'] == "orderchange" ){
	foreach( $_POST['moor'] as $m_id => $m_order ) {
		if( $m_order != 0 ){
			$m_id4sql = intval( $m_id );
			$m_order4sql = intval( $m_order );
			$otab = $xoopsDB -> prefix( "modules" );
			$osql = "UPDATE $otab SET weight=".$m_order4sql." WHERE mid=".$m_id4sql."";
			$ores = $xoopsDB -> query( $osql );
		} else {
			// order != 0
			redirect_header("../../../admin.php",1,_MD_AM_DBUPDATED);
		}
	}
	 redirect_header("itemtype_order.php",1,_MD_AM_DBUPDATED);
}

echo "<h4>"._MD_XOONIPS_ITEMTYPE_CONFIGURATION_LABEL."</h4>
	<p>&nbsp;&nbsp;"._MD_XOONIPS_ITEMTYPE_ORDER_SELECT_EXPLAIN."</p>
	"._MD_XOONIPS_ITEMTYPE_ORDER_SELECT_LABEL."<br />";

echo "<form name='itemtype_order' id='itemtype_order' action='' method='post'><table width='100%' class='outer' cellpadding='4' cellspacing='1'>
      <tr>
      <th>"._MD_XOONIPS_ITEM_ITEM_TYPE_LABEL."</th>
      <th align='center' width='150'>"._MD_XOONIPS_POSIORDER_POSIORDER_SELECT_ORDER_LABEL."</th></tr>";
	  $tab = $xoopsDB->prefix("modules");
	  $sql = "SELECT name, weight, mid, dirname, hasadmin FROM $tab WHERE dirname LIKE 'xnp%' or name='XooNIps' ORDER BY weight ASC";
	  $res = $xoopsDB->query($sql);
	  $cnt = 0;
	  while( $row = $xoopsDB -> fetchArray( $res ) ) {
		$module_name = $myts -> htmlSpecialChars( $row['name'] );
		$full_module_name = str_replace(array(" "), ",", $module_name);
		$part_module_name = explode(",", $full_module_name);
		if( empty($part_module_name[1]) && $part_module_name[0] == 'XooNIps' ){
			$m_name = 'Binder';
			$has_admin = intval( $row['hasadmin'] );
			$dir = $myts -> htmlSpecialChars( $row['dirname'] );
			$module_id = intval( $row['mid'] );
			$module_order = intval( $row['weight'] );
			echo "<tr>
			<td class='head'><b>".$m_name."</b></td>
			<td class='even' align='center'><input type='text' name='moor[".$module_id."]' value='".$module_order."' size='4' maxlength='4' /></td></tr>";
		} else {
			$m_name = current(array_slice($part_module_name, 1, 1));
			$has_admin = intval( $row['hasadmin'] );
			$dir = $myts -> htmlSpecialChars( $row['dirname'] );
			$module_id = intval( $row['mid'] );
			$module_order = intval( $row['weight'] );
			if ( $has_admin == 1 ){
				echo "<tr>
				<td class='head'><a href=\"".XOOPS_URL."/modules/".$dir."/admin/index.php"."\"><b>".$m_name."</b></a></td>
				<td class='even' align='center'><input type='text' name='moor[".$module_id."]' value='".$module_order."' size='4' maxlength='4' /></td></tr>";
			} else {
			echo "<tr>
				<td class='head'><b>".$m_name."</b></td>
				<td class='even' align='center'><input type='text' name='moor[".$module_id."]' value='".$module_order."' size='4' maxlength='4' /></td></tr>";
			}
		}
		$cnt++;
	  }
	  echo "<tr><td class='head'> </td><td class='even' align='center'><input type='hidden' name='state' value='orderchange' /><button type='submit' value='Submit' onclick='itemtype_order.php'>Submit</button></td></tr>
	  </table></form>";


xoops_cp_footer();
?>
