<?php
/* functions to display blocks and edit blocks.
 * $Revision: 1.48.2.2 $
 */

/*
	http://wiki.xoops.org/wakka.php?wakka=ModuleNamingConventions says:
		Always prefix with b_yourmoduledirname_ 
		Use only lowercase characters 
		Separate words with underscores (_)
*/

include_once XOOPS_ROOT_PATH.'/mainfile.php';
include_once XOOPS_ROOT_PATH.'/modules/xoonips/condefs.php';

if( file_exists( XOOPS_ROOT_PATH.'/modules/system/language/'.$xoopsConfig['language'].'/blocks.php' ) ) {
        include_once( XOOPS_ROOT_PATH.'/modules/system/language/'.$xoopsConfig['language'].'/blocks.php' );
} else {
        include_once( XOOPS_ROOT_PATH.'/modules/system/language/english/blocks.php' );
}

require_once XOOPS_ROOT_PATH . '/modules/xoonips/include/create_session.php';
require_once XOOPS_ROOT_PATH . '/modules/xoonips/include/lib.php';

/// display xnp login block
function b_xoonips_login_show()
{
	global $xoopsUser, $xoopsConfig;

	if (!$xoopsUser) { // not display during login
		if ( xnp_load_init_create_session_silent() != 0 ) return false;
		$block = array();
		$block['lang_username'] = _MB_XOONIPS_ACCOUNT_USERNAME;
		$block['unamevalue'] = "";
		if (isset($_COOKIE[$xoopsConfig['usercookie']])) {
			$block['unamevalue'] = $_COOKIE[$xoopsConfig['usercookie']];
		}
		$block['lang_password'] = _MB_XOONIPS_ACCOUNT_PASSWORD;
		$block['lang_login'] = _MB_XOONIPS_ACCOUNT_LOGIN;
		$block['lang_lostpass'] = _MB_XOONIPS_ACCOUNT_LPASS;
		$block['lang_registernow'] = _MB_XOONIPS_ACCOUNT_RNOW;
		//$block['lang_rememberme'] = _MB_XOONIPS_ACCOUNT_REMEMBERME;
		if ($xoopsConfig['use_ssl'] == 1 && $xoopsConfig['sslloginlink'] != '') {
			$block['sslloginlink'] = "<a href=\"javascript:openWithSelfMain('".$xoopsConfig['sslloginlink']."', 'ssllogin', 300, 200);\">"._MB_SYSTEM_SECURE."</a>";
		}
		if ( isset($_SESSION["back_url"]) ){
			$back_url = $_SESSION["back_url"];
			$block['xoops_requesturi'] = htmlspecialchars(trim($back_url), ENT_QUOTES);
		}
    	return $block;
    }
	return false;
}

function b_xoonips_user_show()
{
	global $xoopsUser;
	if (is_object($xoopsUser)) {
		$block = array();
		$uid = $xoopsUser->getVar('uid');
		
		// Load AL and get private_index_id.
		if ( xnp_load_init_create_session_silent() != 0 ) return false;
		$xnpsid = $_SESSION['XNPSID'];
		$account = array();
		$ret = xnp_get_account( $xnpsid, $uid, $account );
		if ( $ret == RES_OK ){
			$block['private_index_id'] = $account['private_index_id'];
		}
		
		$pm_handler =& xoops_gethandler('privmessage');
		$block['lang_youraccount'] = _MB_XOONIPS_ACCOUNT_VIEW_ACCOUNT;
		$block['lang_editaccount'] = _MB_XOONIPS_ACCOUNT_EDIT_ACCOUNT;
		$block['lang_showusers'] = _MB_XOONIPS_ACCOUNT_SHOW_USERS;
		$block['lang_grouplist'] = _MB_XOONIPS_ACCOUNT_GROUP_LIST;
		$block['lang_notifications'] = _MB_SYSTEM_NOTIF;
		
		$block['lang_listing_item'] = _MB_XOONIPS_ACCOUNT_LISTING_ITEM;
		$block['lang_edit_index'] = _MB_XOONIPS_ACCOUNT_EDIT_PRIVATE_INDEX;
		$block['lang_advanced_search'] = _MB_XOONIPS_ACCOUNT_ADVANCED_SEARCH;
		$block['lang_register_item'] = _MB_XOONIPS_ACCOUNT_REGISTER_ITEM;
		$block['lang_metadata_search'] = _MB_XOONIPS_ACCOUNT_METADATA_SEARCH_LABEL;
		$block['lang_su_start'] = _MB_XOONIPS_SU_START;
		$block['lang_su_end'] = sprintf( _MB_XOONIPS_SU_END, $xoopsUser->getVar('uname') );
		$block['is_su'] = isset($_SESSION['xoonips_old_uid']);
		
		$block['uid'] = $uid;
		$block['lang_logout'] = _MB_SYSTEM_LOUT;
		$criteria = new CriteriaCompo(new Criteria('read_msg', 0));
		$criteria->add(new Criteria('to_userid', $xoopsUser->getVar('uid')));
		$block['new_messages'] = $pm_handler->getCount($criteria);
		$block['lang_inbox'] = _MB_SYSTEM_INBOX;
		
		$module_handler =& xoops_gethandler( 'module' );
		$module =& $module_handler->getByDirname( 'xoonips' );
		if( !is_object( $module ) ){
			exit("Access Denied");
		}
		$mid = $module->getVar( 'mid' );
		
		if ($xoopsUser->isAdmin( $mid )) {
			$block['lang_adminmenu'] = _MB_SYSTEM_ADMENU;
		}
		$private_import_enabled = "";
        // 
        // set to $block['lang_import'] if user is permitted to import.
        // - config of private_import_enabled is true
        // - or user is administrator
        // 
        if( $xoopsUser -> isAdmin( $mid ) ){
            $block['lang_import'] = _MB_XOONIPS_ACCOUNT_IMPORT;
        }else if( xnp_get_config_value( 'private_import_enabled', $private_import_enabled ) == RES_OK ){
			if( $private_import_enabled == 'on' ){
				$block['lang_import'] = _MB_XOONIPS_ACCOUNT_IMPORT;
			}
		}
		$block['lang_metadata_search'] = _MB_XOONIPS_ACCOUNT_METADATA_SEARCH_LABEL;
		return $block;
	}
	return false;
}

function b_xoonips_group_show()
{
	global $xoopsUser;
	if (is_object($xoopsUser)) {
		if ( xnp_load_init_create_session_silent() != 0 ) return false;
		$xnpsid = $_SESSION['XNPSID'];
		$uid = $_SESSION['xoopsUserId'];
		
		// The user who is not a member of group's admin can't see this menu.
		$gids = array();
		$criteria = array();
		$xid = false;
		
		if( 0 != xnp_get_groups_by_uid( $xnpsid, $uid, $criteria, $gids ) ){
			return false;
		}
		$adminGids = array();
		foreach( $gids as $gid ){
			if ( xnp_is_group_admin( $xnpsid, $gid, $uid ) )
				$adminGids[] = $gid;
		}
		
		if ( count( $adminGids ) != 0 ){
			// gid -> xid
			$group = array();
			if( 0 != xnp_get_group( $xnpsid, $adminGids[0], $group ) ){
				return false;
			}
			$xid = $group['group_index_id'];
		}
		else {
			// case of no groups to operate (= not group's admin)
			// display the menu if the user belongs to xoops admin.
			$module_handler =& xoops_gethandler( 'module' );
			$module =& $module_handler->getByDirname( 'xoonips' );
			if ( ! is_object( $module ) ) {
				exit("Access Denied");
			}
			$mid = $module->getVar( 'mid' );
			if( !$xoopsUser->isAdmin($mid) ){
				return false;
			}
		}
		
		$block = array();
		$block['lang_edit_group'] = _MB_XOONIPS_ACCOUNT_EDIT_GROUPS;
		$block['lang_certify_group_items'] = _MB_XOONIPS_ACCOUNT_CERTIFY_GROUP_ITEMS;
		$block['lang_edit_group_index'] = _MB_XOONIPS_ACCOUNT_EDIT_GROUP_INDEX;
		$block['xid'] = $xid;
		return $block;
	}
	return false;
}

function b_xoonips_moderator_show()
{
	global $xoopsUser;
	if (is_object($xoopsUser)) {
		if ( xnp_load_init_create_session_silent() != 0 ) return false;
		$xnpsid = $_SESSION['XNPSID'];
		$uid = $_SESSION['xoopsUserId'];
		
		if ( xnp_is_moderator( $xnpsid, $uid ) ){
			$block = array();
			$block['lang_edit_group'] = _MB_XOONIPS_MODERATOR_EDIT_GROUPS;
			$block['lang_certify_users'] = _MB_XOONIPS_MODERATOR_CERTIFY_USERS;
			$block['lang_certify_items'] = _MB_XOONIPS_MODERATOR_CERTIFY_PUBLIC_ITEMS;
			$block['lang_edit_public_index'] = _MB_XOONIPS_MODERATOR_EDIT_PUBLIC_INDEX;
			$block['lang_event_log'] = _MB_XOONIPS_MODERATOR_EVENT_LOG;
			$block['xid'] = IID_PUBLIC;
			return $block;
		}
	}
	return false;
}


// display index tree block
function b_xoonips_tree_show()
{
	global $xoopsUser, $xoopsConfig, $xoonipsTreeCheckBox, $xoonipsSelectedTab, $xoonipsTreePrivateUid,
		$xoonipsForm, $xoonipsURL, $xoonipsHideBinders, $xoonipsEditIndex, $xoonipsCheckPrivate, $xoonipsEditBinder, $xoonipsEditPublic, $xoopsDB;

	include_once XOOPS_ROOT_PATH . '/modules/xoonips/condefs.php';
	// Load AL and get the selectable top_level_index.
	if ( xnp_load_init_create_session_silent() != 0 ) return false;
	$xnpsid = $_SESSION['XNPSID'];
	$indexes = array();
	if ( !empty($xoopsUser) ){
		$uid = $xoopsUser->getVar('uid');
	}
	else
		$uid = UID_GUEST;
	$puid = $uid;
	
	$query = array();
	if ( !empty( $xoonipsTreeCheckBox ) ) $query[] = 'checkbox=1';
	if ( !empty( $xoonipsForm ) )         $query[] = "form=$xoonipsForm";
	if ( !empty( $xoonipsHideBinders ) )  $query[] = "hide_binders=1";
	if ( !empty( $xoonipsEditIndex ) )    $query[] = "edit=1";
	if ( !empty( $xoonipsCheckPrivate ) ) $query[] = "check_private=$xoonipsCheckPrivate";
	if (  isset( $xoonipsURL ) )          $query[] = "url=" . urlencode($xoonipsURL);
	if ( !empty( $xoonipsSelectedTab ) )  $query[] = "selected_tab=$xoonipsSelectedTab";
	if ( !empty( $xoonipsEditBinder ) )   $query[] = "edit_binder=1";
	if ( !empty( $xoonipsEditPublic ) )   $query[] = "edit_public=1";
	if ( !empty( $xoonipsTreePrivateUid ) ) { $query[] = "puid=$xoonipsTreePrivateUid"; $puid = $xoonipsTreePrivateUid; }
	
	$block = array();
	$block['query'] = implode( '&amp;', $query );
	
	$val = "";
	xnp_get_config_value( 'tree_frame_width', $val );
	$block['tree_frame_width'] = $val;
	xnp_get_config_value( 'tree_frame_height', $val );
	$block['tree_frame_height'] = $val;
	$block['isKHTML'] = (bool)(stristr($_SERVER["HTTP_USER_AGENT"], "khtml" ));
	$block['checkbox'] = !empty( $xoonipsTreeCheckBox );
	
	if ( $uid == UID_GUEST && !public_item_target_user_all() ){
		// cannot xnp_get_index because guest is disabled. use SQL instead.
		$sql = "select title from ".$xoopsDB->prefix('xoonips_item_basic')." where item_id = " . IID_PUBLIC;
		$result = $xoopsDB->query( $sql );
		list( $title ) = $xoopsDB->fetchRow( $result );
		$block['indexes'] = array(
			array( 'item_id' => IID_PUBLIC, 'title' => $title )
		);
		return $block;
	}

	if ( !empty( $xoonipsEditBinder ) ){
		// edit binder : display only public and private index.
		$index = array();
		$result = xnp_get_index( $xnpsid, IID_PUBLIC, $index );
		$indexes[] = $index;
		
		// private
		$account = array();
		$result = xnp_get_account( $xnpsid, $puid, $account );
		if ( $result == RES_OK ){
			$index = array();
			$result = xnp_get_index( $xnpsid, $account['private_index_id'], $index );
			$indexes[] = $index;
		}
	}
	else {
		if ( !empty( $xoonipsEditIndex ) ){
			$xids = array();
			
			// public
			if ( xnp_is_moderator( $xnpsid, $uid ) || !empty($xoonipsEditPublic) && !empty($_SESSION['xoonips_old_uid']) )
				$xids[] = IID_PUBLIC;
			
			// group
			$gids = array();
			$criteria = array();
			$result = xnp_get_groups_by_uid( $xnpsid, $puid, $criteria, $gids );
			if ( $result == RES_OK ){
				$groups = array();
				$result = xnp_get_groups( $xnpsid, $gids, $criteria, $groups );
				if ( $result == RES_OK ) {
					foreach( $groups as $group ){
						if ( xnp_is_group_admin( $xnpsid, (int)$group['gid'], $puid ) )
							$xids[] = $group['group_index_id']; // group
					}
				}
			}
			
			// private
			$account = array();
			$result = xnp_get_account( $xnpsid, $puid, $account );
			if ( $result == RES_OK ){
				$xids[] = $account['private_index_id']; // private
				
				// xids -> indexes
				foreach( $xids as $xid ){
					// The value of $indexes is strange, if "$index = array();" moves to outside of foreach sentence (reason is unknown).
					$index = array();
					$result = xnp_get_index( $xnpsid, $xid, $index );
					$indexes[] = $index;
				}
			}
		}
		else if ( xnp_is_moderator( $xnpsid, $uid ) ){
			// Get index which is related to oneself.
			$xids = array();
			
			// public
			$xids[] = IID_PUBLIC;
			
			// group
			$gids = array();
			$criteria = array();
			$result = xnp_get_groups_by_uid( $xnpsid, $puid, $criteria, $gids );
			if ( $result == RES_OK ){
				$groups = array();
				$result = xnp_get_groups( $xnpsid, $gids, $criteria, $groups );
				if ( $result == RES_OK ){
					foreach( $groups as $group ){
						$xids[] = $group['group_index_id']; // group
					}
				}
			}
			// private
			$account = array();
			$result = xnp_get_account( $xnpsid, $puid, $account );
			if ( $result == RES_OK ){
				$xids[] = $account['private_index_id']; // private
			}
			
			// xids -> indexes
			foreach( $xids as $xid ){
				// The value of $indexes is strange, if "$index = array();" moves to outside of foreach sentence (reason is unknown).
				$index = array();
				$result = xnp_get_index( $xnpsid, $xid, $index );
				$indexes[] = $index;
			}
		}
		else{
			$criteria = array( 'orders'=>array( array('name'=>'sort_number', 'order'=>'ASC' ) ) );
			$result = xnp_get_indexes( $xnpsid, 1, $criteria, $indexes );
		}
	}
	$block['indexes'] = $indexes;
	
    return $block;
}


/* Display block of QuickSearch
 todo: The right of access controls the display of a block.
       Return false in case user is guest and not to permit guest.
*/
function b_xoonips_quick_search_show(){
	$block = array();
	$search_itemtypes = array( 'all'=>_MB_XOONIPS_ITEM_ALL_LABEL, 'basic'=>_MB_XOONIPS_ITEM_TITLE_AND_KEYWORD_LABEL, 'metadata'=>_MB_XOONIPS_ITEM_METADATA_LABEL );
	//$search_itemtypes = array( 'all'=>_MB_XOONIPS_ITEM_ALL_LABEL, 'basic'=>_MB_XOONIPS_ITEM_TITLE_AND_KEYWORD_LABEL );
	
	// Load AL and get itemtypes.
	if ( xnp_load_init_create_session_silent() != 0 ) return false;

	$itemtypes = array();
	$ar = array();
	if( xnp_get_item_types( $itemtypes ) == RES_OK ){
		foreach ( $itemtypes as $itemtype ){
			if ( $itemtype['item_type_id'] > 2 )
				$ar[$itemtype['name']] = $itemtype['display_name'];
		}
	}
	$block['lang_search']          = _MB_XOONIPS_ITEM_SEARCH_LABEL;
	$block['lang_advanced_search'] = _MB_XOONIPS_ITEM_ADVANCED_SEARCH_LABEL;
	$block['accept_charset']       = xnpGetMacSafariAcceptCharset();

    global $xoopsDB;

	$result = array();
	$moduleTable = $xoopsDB->prefix('modules');
	$itemtypeTable = $xoopsDB->prefix('xoonips_item_type');
	$sql = "select dirname from $moduleTable,$itemtypeTable where $moduleTable.mid=$itemtypeTable.mid and dirname like 'xnp%' order by weight asc, $moduleTable.mid";
	$result = $xoopsDB->query($sql);
	while ( list($dirname) = $xoopsDB->fetchRow($result) )
		$search_itemtypes[$dirname] = $ar[$dirname];
	
	$block['search_itemtypes'] = $search_itemtypes;

	// Check the positon of the quick search block
	// If CENTER, <br> will be removed in the templete
	$blockTable = $xoopsDB->prefix('newblocks');
	$sql = "select side from $blockTable where show_func='b_xoonips_quick_search_show'";
	$result = $xoopsDB->query($sql);
	$blockSide = $xoopsDB -> fetchRow($result);
	if( $blockSide[0] == "0" || $blockSide[0] == "1" ){
		$block['block_center'] = FALSE;
	}else{
		$block['block_center'] = TRUE;
	}

	$myts =& MyTextsanitizer::getInstance();
	$block['keyword'] = '';
	if      ( isset($_POST['keyword']) ) $block['keyword'] = $myts->stripSlashesGPC($_POST['keyword']);
	else if ( isset($_GET ['keyword']) ) $block['keyword'] = $myts->stripSlashesGPC($_GET ['keyword']);
	if      ( isset($_POST['search_itemtype']) ) $block['search_itemtypes_selected'] = $myts->stripSlashesGPC($_POST['search_itemtype']);
	else if ( isset($_GET ['search_itemtype']) ) $block['search_itemtypes_selected'] = $myts->stripSlashesGPC($_GET ['search_itemtype']);
	$block['keyword'] = xnpHtmlspecialchars( $block['keyword'] );
	return $block;
}


// explanation of itemtypes
function b_xoonips_itemtypes_show(){
	global $xoopsDB;
	global $xoopsTpl;

	$itemtypes = array();
	if( xnp_get_item_types( $itemtypes ) != RES_OK ){
		redirect_header('index.php', 3, "ERROR xnp_get_item_types [AbstractLayer]".xnp_get_last_error_string());
		break;
	}
	$block = array();
	$order = array();
	$cnt = 0;
	foreach ( $itemtypes as $dummy => $itemtype ){
		$modname = $itemtype['name'];
		if ( $itemtype['viewphp'] == ''
		     || !file_exists( XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp']) )
			continue;
		include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
		$funcname = $modname."GetTopBlock";
		$tmp = '';
		if ( function_exists( $funcname ) ){
			$tmp = $funcname( $itemtype );
			if( strlen(trim($tmp)) !== 0 ){
				$block['explain'][] = $tmp;
				
				$moduleTable = $xoopsDB->prefix('modules'); 
				$itemtypeTable = $xoopsDB->prefix('xoonips_item_type');
				$sql = "select weight,dirname from $moduleTable where mid=".$itemtype['mid']; 
				$result = $xoopsDB->query($sql);
				if( $result ){
					list($weight) = $xoopsDB->fetchRow($result);
					$order[] = $weight; 
				}else{
					trigger_error($xoopsDB -> error());
				}
			}
		}
		$cnt++;
	}

	// sort itemtypes by weight in _modules table
	if ($cnt > 1)
		array_multisort($order,$block['explain']);

	return $block;
}


/** display ranking block / new arrival block
 * @param new_flag  true: new arrival block. false: ranking block
 */

function xoonips_ranking_show( $new_flag ){
	global $xoopsUser;
	
	include_once XOOPS_ROOT_PATH . '/modules/xoonips/condefs.php';
	if ( xnp_load_init_create_session_silent() != 0 ) return false;
	$xnpsid = $_SESSION['XNPSID'];
	
	if ( !empty($xoopsUser) )
		$uid = $xoopsUser->getVar('uid');
	else
		$uid = UID_GUEST;
	
	if ( !public_item_target_user_all() && ( $uid == UID_GUEST || !xnp_is_activated($xnpsid, $uid) ) )
		return false;
	
	global $xoopsDB, $xoopsblock;
	$new_str = ( $new_flag ? '_new' : '' );
	
	//var_dump( $xoopsblock );
	//$side = $xoopsblock->getVar('side'); // this method does not work. $xoopsblock is NULL.
	global $block_arr;
	foreach ( $block_arr as $b ){
		if ( $b->getVar('show_func') == ( $new_flag ? 'b_xoonips_ranking_new_show' : 'b_xoonips_ranking_show' ) ){
			$side = $b->getVar( 'side' );
		}
	}
	
	if ( $side == XOOPS_SIDEBLOCK_LEFT      || 
	     $side == XOOPS_SIDEBLOCK_RIGHT     )
		$maxlen = 16;
	else if (
	     $side == XOOPS_CENTERBLOCK_LEFT    || 
	     $side == XOOPS_CENTERBLOCK_RIGHT   )
		$maxlen = 24;
	else
		$maxlen = 56;
	
	if ( RES_OK != xnp_get_config_value( "ranking${new_str}_num_rows", $num_rows     ) ) $num_rows     = 5;
	if ( RES_OK != xnp_get_config_value( "ranking${new_str}_visible" , $visible      ) ) $visible      = "1,1,1,1,1";
	if ( RES_OK != xnp_get_config_value( "ranking${new_str}_order"   , $order        ) ) $order        = "0,1,2,3,4";
	
	$visible = explode( ',', $visible );
	$order = explode( ',', $order );

	xnpRecalcRanking( true );
	
	$log_table               = $xoopsDB->prefix('xoonips_event_log');
	$viewed_item_table       = $xoopsDB->prefix('xoonips_ranking_viewed_item');
	$downloaded_item_table   = $xoopsDB->prefix('xoonips_ranking_downloaded_item');
	$contributing_user_table = $xoopsDB->prefix('xoonips_ranking_contributing_user');
	$searched_keyword_table  = $xoopsDB->prefix('xoonips_ranking_searched_keyword');
	$active_group_table      = $xoopsDB->prefix('xoonips_ranking_active_group');
	$new_item_table          = $xoopsDB->prefix('xoonips_ranking_new_item');
	$new_group_table         = $xoopsDB->prefix('xoonips_ranking_new_group');
	
	
	$item_perm_sql = " tb.item_id is not null and tx.open_level = " . OL_PUBLIC . " and txil.certify_state = " . CERTIFIED;
/*	if ( $uid == UID_GUEST ){
		$item_perm_sql = " tb.item_id is not null and tx.open_level = " . OL_PUBLIC . " and txil.certify_state = " . CERTIFIED;
	}
	else {
		$gids = array();
		$sess_id = session_id();
		$is_moderator = (int)xnp_is_moderator( $sess_id, $uid );
		$item_perm_sql = " tb.item_id is not null and ( $is_moderator or (tx.open_level = ".OL_PUBLIC." and txil.certify_state = ".CERTIFIED." or tx.open_level = ".OL_GROUP_ONLY." and tgul.uid=$uid and ( txil.certify_state = ".CERTIFIED." or tgul.is_admin ) ) ) "; // omit OL_PRIVATE-only items
	}
*/
	
	$item_joins = "
		left join ".$xoopsDB->prefix('xoonips_item_basic')." as tb on t.item_id=tb.item_id 
		left join ".$xoopsDB->prefix('xoonips_item_title')." as tt on t.item_id=tt.item_id 
		left join ".$xoopsDB->prefix('xoonips_index_item_link')." as txil on tb.item_id = txil.item_id
		left join ".$xoopsDB->prefix('xoonips_index')." as tx on tx.index_id = txil.index_id ";
//		left join ".$xoopsDB->prefix('xoonips_groups_users_link')." as tgul on tx.gid=tgul.gid";
	
	if ( $new_flag ){
		$sqls = array( 
			"select t.item_id, tt.title, date_format(timestamp,'%m/%d') from $new_item_table  as t $item_joins where tt.title_id=0 and $item_perm_sql group by t.item_id ",
			"select t.gid,     tg.gname, date_format(timestamp,'%m/%d') from $new_group_table as t left join ".$xoopsDB->prefix('xoonips_groups')." as tg on t.gid=tg.gid ",
		);
		$urls = array(
			XOOPS_URL . '/modules/xoonips/detail.php?item_id=%d',
			XOOPS_URL . '/modules/xoonips/groups.php',
		);
		
		$ranking_names = array(
			_MB_XOONIPS_RANKING_NEW_ITEM,
			_MB_XOONIPS_RANKING_NEW_GROUP,
		);
		$orderby = " order by timestamp desc limit $num_rows";
	}
	else {
		$sqls = array( 
			"select distinct t.item_id, tt.title, count from $viewed_item_table as t     $item_joins where tt.title_id=0 and $item_perm_sql and count<>0 ",
			"select distinct t.item_id, tt.title, count from $downloaded_item_table as t $item_joins where tt.title_id=0 and $item_perm_sql and count<>0 ",
			"select distinct t.uid, tu.uname, count(*) as count from $contributing_user_table as t left join ".$xoopsDB->prefix('users')." as tu on t.uid=tu.uid where tu.uid is not null group by t.uid ",
			"select distinct t.keyword, t.keyword, count from $searched_keyword_table as t where count<>0 ",
			"select distinct t.gid, tg.gname, count from $active_group_table as t left join ".$xoopsDB->prefix('xoonips_groups')." as tg on tg.gid = t.gid where tg.gid is not null and count<>0 ",
		);
		$urls = array(
			XOOPS_URL . '/modules/xoonips/detail.php?item_id=%d',
			XOOPS_URL . '/modules/xoonips/detail.php?item_id=%d',
			XOOPS_URL . '/modules/xoonips/showusers.php?uid=%d',
			XOOPS_URL . '/modules/xoonips/itemselect.php?op=quicksearch&amp;search_itemtype=all&amp;keyword=%s',
			XOOPS_URL . '/modules/xoonips/groups.php',
		);
		
		$ranking_names = array(
			_MB_XOONIPS_RANKING_VIEWED_ITEM,
			_MB_XOONIPS_RANKING_DOWNLOADED_ITEM,
			_MB_XOONIPS_RANKING_CONTRIBUTING_USER,
			_MB_XOONIPS_RANKING_SEARCHED_KEYWORD,
			_MB_XOONIPS_RANKING_CONTRIBUTED_GROUP,
		);
		$orderby = " order by count desc limit $num_rows";
	}
	
	// display ranking 
	$block['rankings'] = array();
	$rank_strs = explode( ',', _MB_XOONIPS_RANKING_RANK_STR );
	for ( $i = 0; $i < count($sqls); $i++ ){
		if ( $visible[$i] ){
			$result = $xoopsDB->query( $sqls[$i] . $orderby );
			if ( $result == false ){ echo __LINE__ . $sqls[$i] . $orderby; exit; } //@@
			$items = array();
			$rank = 0;
			while ( list( $id, $title, $count ) = $xoopsDB->fetchRow( $result ) ){
				if ( strlen( $title ) > $maxlen ){
					list( $title, $dummy ) = xnpTrimString( $title, $maxlen - strlen($count) - 1, _CHARSET );
					$title .= "..";
				}
				$rank_str = ($rank+1) . $rank_strs[ min($rank, count($rank_strs)-1) ];
				$items[] = array('title'=>$title, 'url'=>sprintf( $urls[$i], urlencode($id) ), 'num'=>$count, 'rank_str' => $rank_str );
				$rank++;
			}
			$block['rankings'][$order[$i]] = array( 'items' => $items, 'title' => $ranking_names[$i] );
		}
	}
	ksort( $block['rankings'] );
	return $block;
}


function b_xoonips_ranking_show(){
	return xoonips_ranking_show( false );
}

function b_xoonips_ranking_new_show(){
	return xoonips_ranking_show( true );
}

// display userlist
function b_xoonips_userlist_show(){
	// get value of user from DB
	global $xoopsDB, $xoopsTpl;
	$myts =& MyTextSanitizer::getInstance();
	$sql  = "select i1.uid, i1.name, i1.uname, i2.posi_id, i2.posi_title ";
	$sql .= "from ".$xoopsDB->prefix("users")." as i1, ".$xoopsDB->prefix("xoonips_positions")." as i2, ".$xoopsDB->prefix("xoonips_users")." as i3 ";
	$sql .= "where i2.posi_id=i3.posi and not (i2.posi_order < 0) and i1.uid=i3.uid and not (i3.user_order < 0) and i3.activate=1 ";
	$sql .= "order by i2.posi_order ASC, i3.user_order ASC, i1.uid ASC";
	$res  = $xoopsDB->query( $sql );
	
	// make HTML of userlist
	$block['html_list'] = '<table border="0">';
	$otitle = '';
	while ( $myrow = $xoopsDB->fetchArray($res) ) {
		if( $otitle != $myrow['posi_id'] ) {
			$ptitle = $myts -> htmlSpecialChars( $myrow['posi_title'] );
			$block['html_list'] .= "<tr><td align=\"left\"><strong><u>".$ptitle."</u></strong></td></tr>";
		}
		$ruid = intval( $myrow['uid'] );
		if( strlen( trim ( $myrow['name'] ) ) !== 0 ){
			$rname = $myts -> htmlSpecialChars( $myrow['name'] );
			$block['html_list'] .= "<tr><td>&nbsp;&nbsp;<a href=\"".XOOPS_URL."/modules/xoonips/showusers.php?uid=".$ruid."\">".$rname."</a></td></tr>";
		} else {
			$rname = $myts -> htmlSpecialChars( $myrow['uname'] );
			$block['html_list'] .= "<tr><td>&nbsp;&nbsp;<a href=\"".XOOPS_URL."/modules/xoonips/showusers.php?uid=".$ruid."\">".$rname."</a></td></tr>";
		}
		$otitle = intval( $myrow['posi_id'] );
	}
	$block['html_list'] .= "</table>";
	return $block;
}

?>
