<?php
//  page for certify items                                                      //
//  $Revision: 1.16.2.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';
include_once 'condefs.php';
include_once 'include/lib.php';

require_once 'include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

if( file_exists( XOOPS_ROOT_PATH.'/modules/xoonips/language/'.$xoopsConfig['language'].'/main.php' ) ) {
	include_once( XOOPS_ROOT_PATH.'/modules/xoonips/language/'.$xoopsConfig['language'].'/main.php' );
} else {
	include_once( XOOPS_ROOT_PATH.'/modules/xoonips/language/english/main.php' );
}

// If not a user, redirect
if ( !$xoopsUser ) {
	$_SESSION["back_url"] = $_SERVER["REQUEST_URI"];
	xnpRedirectHeader( 'user.php', 3, _MD_XOONIPS_ITEM_FORBIDDEN );
	exit();
}

$uid = $_SESSION['xoopsUserId'];

//Only Moderator and Group administrator can access this page.
if( !xnp_is_moderator( $xnpsid, $uid ) ){
    if ( !xnp_is_activated( $xnpsid, $uid ) ){
        redirect_header('index.php', 3, _MD_XOONIPS_MODERATOR_NOT_ACTIVATED);
        exit();
    }
    
    $gids = array();
    $criteria = array();
    if( 0 != xnp_get_groups_by_uid( $xnpsid, $uid, $criteria, $gids ) ){
        redirect_header('index.php', 3, _MD_XOONIPS_ACCOUNT_QUERY_ERROR);
        exit();
    }
    for ( $i = 0; $i < count($gids); $i++ ){
        if ( xnp_is_group_admin( $xnpsid, $gids[$i], $uid ) )
            break;
    }
    if ( $i == count($gids) ){
        redirect_header('index.php', 3, _MD_XOONIPS_ITEM_FORBIDDEN);
        exit();
    }
}

foreach( array( 'op' => NULL, 'menu_id' => NULL, 'item_id' => NULL, 'index_ids' => NULL ) as $k => $v ){
    if( array_key_exists( $k, $_GET ) ){
        $$k = $_GET[$k];
    }else if( array_key_exists( $k, $_POST ) ){
        $$k = $_POST[$k];
    }else{
        $$k = $v;
    }
}


if( $menu_id == 1 ){
	//pankuzu for administrator
	$pankuzu = _MI_XOONIPS_ACCOUNT_PANKUZU_MODERATOR
	._MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR
	._MI_XOONIPS_ITEM_PANKUZU_CERTIFY_PUBLIC_ITEMS;
}else if( $menu_id == 2 ){
	//pankuzu for group administrator
	$pankuzu = _MI_XOONIPS_ACCOUNT_PANKUZU_GROUP_ADMINISTRATOR
	._MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR
	._MI_XOONIPS_ITEM_PANKUZU_CERTIFY_GROUP_ITEMS;
}else{
	$pankuzu = '';
}

// accept or reject certify,  send email
if( isset( $op ) && ( $op=='certify' || $op=='uncertify' ) ){
    $item = array();
    xnp_get_item( $xnpsid, $item_id, $item );
    
    //retrieve module name to $itemtype
    $itemtypes = array();
    if( xnp_get_item_types( $itemtypes ) != RES_OK ){
        redirect_header('index.php', 3, "ERROR xnp_get_item_types [AbstractLayer]".xnp_get_last_error_string());
        break;
    }else{
        foreach( $itemtypes as $i){
            if( $i['item_type_id'] == $item['item_type_id'] ){
                $itemtype = $i;
                break;
            }
        }
    }

	$user = array();
	xnp_get_account( $xnpsid, $item['uid'], $user );
    
    $state = NOT_CERTIFIED;
    $body_index = ''; // store index keyword paths
    $myts =& MyTextSanitizer::getInstance();
    foreach( $index_ids as $index_id ){
        if( xnp_get_certify_state( $xnpsid, $index_id, $item_id, $state ) == RES_OK ){
            $index = array();
            if( xnp_get_index( $xnpsid, $index_id, $index ) == RES_OK ){
                if( $op == 'uncertify' ){
                    $result = xnp_unregister_item( $xnpsid, $index_id, $item_id );
                    // record events(reject item)
                    if ( $result == RES_OK )
                        xnp_insert_event( $xnpsid, ETID_REJECT_ITEM, time(), $uid, xnpGetRemoteHost(), array( 'item_id' => $item_id, 'index_id' => $index_id ) );
                        // Delete record in table of xoonips_item_show
                        $tab_name = $xoopsDB->prefix('xoonips_item_show');
                        $sql = "DELETE FROM $tab_name WHERE item_id='".$item_id."' ";
                        $res = $xoopsDB->query($sql);
                }else if( $op == 'certify' ){
                    $result = xnp_set_certify_state( $xnpsid, $index_id, $item_id, CERTIFIED );
                    // record events(certify item)
                    if ( $result == RES_OK ){
                        xnp_insert_event( $xnpsid, ETID_CERTIFY_ITEM, time(), $uid, xnpGetRemoteHost(), array( 'item_id' => $item_id, 'index_id' => $index_id ) );
                        xnpGenerateRss( ); //update RSS
                    }
                }
                if( $result == RES_OK ){
                    $pathstr = xnpGetIndexPathString( $xnpsid, $index_id );
                    $body_index .= $myts->undoHtmlSpecialChars($pathstr)."\n";
                }
            }
        }
    }
    if( $body_index != '' ){
        include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
        eval( "\$metaarray = ".$itemtype['name']."GetMetaInformation( \$item_id );" );
        $body_metadata = "";
        foreach( $metaarray as $k => $v ){ $body_metadata = $body_metadata."$k : $v\n"; }
        if( xnp_get_index( $xnpsid, $index_id, $index ) == RES_OK ){
			global $xoopsModule;
			$tags = array();
			$tags['ITEM_URL'] = XOOPS_URL . '/modules/' . $xoopsModule->dirname() . "/detail.php?item_id=${item_id}";
            $tags['INDEX'] = $body_index;
            $tags['METADATA'] = $body_metadata;
			$notification_handler =& xoops_gethandler('notification');
            if( $op == 'uncertify' ){
    			$result = $notification_handler->triggerEvent('user', 0, 'item_rejected', $tags, array($user['uid']));
            }else if( $op == 'certify' ){
    			$result = $notification_handler->triggerEvent('user', 0, 'item_certified', $tags, array($user['uid']));
            }
        }
    }
}
    
$config_handler =& xoops_gethandler('config');
$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);

$itemtypes = array();
$tmp = array();
if( xnp_get_item_types( $tmp ) != RES_OK ){
    redirect_header('index.php', 3, "ERROR xnp_get_item_types [AbstractLayer]".xnp_get_last_error_string());
    break;
}else{
	foreach( $tmp as $i ){
        $itemtypes[$i['item_type_id']] = $i;
	}
}

$xoopsOption['template_main'] = 'xoonips_certify.html';
include XOOPS_ROOT_PATH.'/header.php';

$xids = array();
$iids = array();
$items = array();
if( xnp_get_uncertified_link( $xnpsid, $xids, $iids ) != RES_OK ){
    redirect_header('index.php', 3, "ERROR xnp_get_uncertified_link [AbstractLayer]".xnp_get_last_error_string());
    break;
}else{
	for( $i = 0; $i < count( $xids ); $i++ ){
        $item = array();
        if( xnp_get_item( $xnpsid, $iids[ $i ], $item ) == 0 ){//RES_OK ){
            if( array_key_exists( $item['item_type_id'], $itemtypes ) ){
                if( !array_key_exists( $iids[ $i ], $items ) ){
                    $itemtype = $itemtypes[$item['item_type_id'] ];
                    include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
                    eval( "\$body = ".$itemtype['name']."GetListBlock( \$item );" );
                    $items[ $iids[ $i ] ] = array( 'item_id' => $iids[ $i ],
                                                   'indexes' => array( ),
                                                   'item_body' => $body );
                }
                array_push( $items[ $iids[ $i ] ]['index_ids'], $xids[ $i ] );
                array_push( $items[ $iids[ $i ] ]['indexes'], array( 'id' => $xids[ $i ], 'path' => xnpGetIndexPathServerString( $xnpsid, $xids[ $i ] ) ) );
            }
        }
	}
}

if( isset( $menu_id ) ) $xoopsTpl->assign('menu_id', $menu_id);
$xoopsTpl->assign('pankuzu', $pankuzu);
$xoopsTpl->assign("certify_button_label", _MD_XOONIPS_ITEM_CERTIFY_BUTTON_LABEL );
$xoopsTpl->assign("uncertify_button_label", _MD_XOONIPS_ITEM_UNCERTIFY_BUTTON_LABEL );
$xoopsTpl->assign('item_label', _MD_XOONIPS_ITEM_ITEM_LABEL );
$xoopsTpl->assign('index_label', _MD_XOONIPS_ITEM_INDEX_LABEL );
if( count( $items ) > 0 ){
	$xoopsTpl->assign('items', $items );
}

$xoopsTpl->assign( 'xoonips_editprofile_url', XOOPS_URL . '/modules/xoonips/edituser.php?uid=' . $uid );

include XOOPS_ROOT_PATH.'/footer.php';


function getIndexBody( $index_id )
{
    $xnpsid = $_SESSION['XNPSID'];
    $index_path = array();
    for ( $p_xid = $index_id; $p_xid != IID_ROOT; $p_xid = (int)($index['parent_index_id']) ){
// get $index
        $index = array();
        $result = xnp_get_index( $xnpsid, $p_xid, $index );
        if ( $result != 0 ){
            redirect_header('index.php',3,"ERROR xnp_get_index[AbstractLayer]".xnp_get_last_error_string());
            break;
        }
        $index_path[] = $index['titles'][DEFAULT_INDEX_TITLE_OFFSET];
    }
    if( count( $index_path ) > 0 ){
        $index_path = array_reverse( $index_path );
        return "<a href=\"listitem.php?index_id=$index_id\">/".implode('/', $index_path)."</a>";
    }
    return "";
}
?>


