<?php
include_once "item.php";
include_once XOOPS_ROOT_PATH . "/modules/xoonips/include/encode.php";

class XooNIpsIndex extends XooNIpsItem
{
    /**
     * 
     * temporary variable for open_level attribute of <index> 
     * 
     * open_level= public|group|private|null
     * null if not specified.
     * 
     */
    var $open_level = null;
    
    function XooNIpsIndex(){
        parent::XooNIpsItem();
        
        $this->initVar('parent_index_id', XOBJ_DTYPE_INT, null, false);
        $this->initVar('uid', XOBJ_DTYPE_INT, null, false);
        $this->initVar('gid', XOBJ_DTYPE_INT, null, false);
        $this->initVar('open_level', XOBJ_DTYPE_INT, null, false);
        $this->initVar('sort_number', XOBJ_DTYPE_INT, null, false);
    }
    /**
     * retrieve item's basic information.
     * 
     * @param id item ID(need to be more than 0)
     * @return true if succeed. false if failed.
     */
    function get($id){
        global $xoopsDB;
        if (intval($id) > 0) {
            $sql = 'SELECT * FROM '.$xoopsDB -> prefix('xoonips_item_basic').' WHERE item_id='.$id;
            if (!$result = $xoopsDB -> query($sql)) {
                $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                return false;
            }
            if ($xoopsDB -> getRowsNum($result) == 1) {
                $this -> assignVars( $xoopsDB -> fetchArray($result) );
            }
            $sql = 'SELECT * FROM '.$xoopsDB -> prefix('xoonips_index').' WHERE index_id='.$id;
            if (!$result = $xoopsDB -> query($sql)) {
                $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                return false;
            }
            if ($xoopsDB -> getRowsNum($result) == 1) {
                $this -> assignVars( $xoopsDB -> fetchArray($result) );
            }
        }
        return true;
    }

    /**
     * 
     * return array ofindex path to the index specified by $index_id like a array( 'userA', 'books', ... ), arary( 'Public', 'Paper', 'Science' )
     * 
     */
    function getIndexPathArray( ){
        global $xoopsDB;
        $path = array();
        
        $index_id = $this -> getVar( 'item_id' );
        do{
            $sql = "select t.title as title, parent_index_id from " . $xoopsDB -> prefix( "xoonips_index" ) . ", "
                . $xoopsDB -> prefix( "xoonips_item_basic" ) . " as b, "
                . $xoopsDB -> prefix( "xoonips_item_title" ) . " as t "
                . "where index_id=b.item_id and b.item_id = t.item_id and t.title_id=0 and index_id=${index_id}";
            if (!$result = $xoopsDB -> query($sql)) {
                $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                return null;
            }
            if( $xoopsDB -> getRowsNum( $result ) == 1 ){
                $row = $xoopsDB -> fetchArray( $result );
                if( extension_loaded( 'mbstring' ) ){
                    $path[] = mb_ereg_replace( '/', '\\/', mb_ereg_replace( '\\\\', '\\\\', $row[ 'title' ] ) );
                }else{
                    $path[] = str_replace( array( "\\", "/" ), array( "\\\\", "\\/" ), $row[ 'title' ] );
                }
                $index_id = $row[ 'parent_index_id' ];
            }
        }while( $row[ 'parent_index_id' ] != 0 );
        array_pop( $path );//remove '/Root'
        return array_reverse( $path );
    }

    /**
     * 
     * return index path to the index specified by own index_id like a '/userA/books', '/Public/Paper/Science'
     * 
     */
    function getIndexPathStr( ){
        return '/' . implode( '/', getIndexPathArray() );
    }

    /**
     * 
     * return true if permitted to this index
     * 
     * @param uid uid who access to this index(if omitted, $xoopsUser is used)
     * @return true if permitted
     * 
     */
    function getPerm( $uid = null ){
        global $xoopsDB, $xoopsUser;
        if( is_null( $uid ) ){
            global $xoopsUser;
            $uid = $xoopsUser -> getVar( 'uid' );   
        }
        
        if( $this -> getVar( 'open_level' ) == OL_PUBLIC ){
            // 
            // OK if public index
            // 
            return true;
        }else if( $this -> getVar( 'open_level' ) == OL_PRIVATE
            && $this -> getVar( 'uid' ) == $uid ){
            //
            // OK if owner of the index == $uid
            //
            return true;
        }else if( $this -> getVar( 'open_level' ) == OL_GROUP_ONLY ){
            // 
            // query that is $uid belong to group of index
            // 
            $sql = "SELECT * FROM " . $xoopsDB -> prefix( "xoonips_groups_users_link" )
                . " WHERE gid = " . $this -> getVar( 'gid' )
                . " AND uid = " . $uid;
            $result = $xoopsDB -> query( $sql );
            if( !$result ){
                $this -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $this -> getParserErrorAt( $parser ) );
                return false;
            }else if( $xoopsDB -> getRowsNum( $result ) > 0 ){
                // 
                // OK if $uid is belongo to groups of this index.
                // 
                return true;
            }
            $this -> setErrors( E_XOONIPS_NOT_PERMITTED_ACCESS, 'not permitted access to index(' 
                                . $this -> index_id2index_str( $this -> getVar( 'item_id' ) ) . "/"
                                . end( $this -> cdata )
                                . ') by user(uid='
                                . $uid
                                . ')'
                                . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
        }else{
            $this -> setErrors( E_XOONIPS_NOT_PERMITTED_ACCESS, 'not permitted access to index(' 
                                . $this -> index_id2index_str( $this -> getVar( 'item_id' ) ) . "/"
                                . end( $this -> cdata )
                                . ') by user(uid='
                                . $uid
                                . ')'
                                . $this -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
        }
        return false;
    }
}
?>
