<?php
//  $Revision: 1.10 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //
$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';
include_once 'include/lib.php';
include_once XOOPS_ROOT_PATH.'/class/module.textsanitizer.php';
include_once XOOPS_ROOT_PATH.'/modules/system/constants.php';

$ts = &MyTextSanitizer::getInstance(  );
require_once 'include/create_session.php';
xnp_load_init_create_session(  );
$xnpsid = $_SESSION['XNPSID'];

if( !$xoopsUser ) {
	redirect_header( 'index.php', 3, _NOPERM );
	exit();
}
$uid = $xoopsUser->getVar('uid');

//Uncertified user can't access(except XOOPS administrator).
if( !$xoopsUser->isAdmin( $xoopsModule->getVar( 'mid' ) )
	&& !xnp_is_activated( $xnpsid, $uid ) ) {
	redirect_header( 'index.php', 3, _MD_XOONIPS_MODERATOR_NOT_ACTIVATED );
	exit(  );
}
//User(Not Moderater) can't control(except XOOPS administrator).
if( !$xoopsUser->isAdmin( $xoopsModule->getVar( 'mid' ) )
	&& !xnp_is_moderator( $xnpsid, $uid ) ) {
	redirect_header( 'index.php', 3, _MD_XOONIPS_MODERATOR_SHULD_BE_MODERATOR );
	exit(  );
}

require( XOOPS_ROOT_PATH.'/header.php' );

xnpEncodeMacSafariPost();
xnpEncodeMacSafariGet();

foreach( array( 'item_number_limit' => 0, 
                'index_number_limit' => 0, 
                'item_storage_limit' => 0, 
                'gname' => '', 
                'gdesc' => '', 
                'gid' => 0, 
                'gadmins' => array(),
                'op' => ''  ) as $k => $v ){
    if( array_key_exists( $k, $_GET ) ){
        $$k = $_GET[$k];
    }else if( array_key_exists( $k, $_POST ) ){
        $$k = $_POST[$k];
    }else{
        $$k = $v;
    }
}

$item_number_limit = max( 0, $ts->stripSlashesGPC( $item_number_limit ) );
$index_number_limit = max( 0, $ts->stripSlashesGPC( $index_number_limit ) );
$item_storage_limit = max( 0, $ts->stripSlashesGPC( $item_storage_limit ) );

switch ( $op ) {
case 'register':
	//make a group and register administorators
	$gid = 0;

	$result = xnp_insert_group( $xnpsid,
								array( 'gname' => $ts->stripSlashesGPC( $gname ),
									   'gdesc' => $ts->stripSlashesGPC( $gdesc ),
									   'item_number_limit' => $item_number_limit,
									   'index_number_limit' => $index_number_limit,
									   'item_storage_limit' => $item_storage_limit * 1000 * 1000 ),
								$gid );
	if( $result != RES_OK ) {
		if( $result == RES_GROUPNAME_ALREADY_EXISTS ){
			$xoopsTpl->assign( 'gname', $ts->stripSlashesGPC( $gname ) );
			$xoopsTpl->assign( 'gdesc', $ts->stripSlashesGPC( $gdesc ) );
			$xoopsTpl->assign( 'item_number_limit', $item_number_limit );
			$xoopsTpl->assign( 'index_number_limit', $index_number_limit );
			$xoopsTpl->assign( 'item_storage_limit', $item_storage_limit );
			$xoopsTpl->assign( 'gname_exists', true );
			$gadmin_uids = $gadmins;
			break;
		}else{
			redirect_header( 'editgroups.php', 3, _MD_XOONIPS_MODERATOR_ERROR_INSERT_GROUP );
			exit( );
		}
	}
	//set group's administrators
	//add members as group's administrators
	foreach( $gadmins as $i ) {
		xnp_delete_member( $xnpsid, $gid, $i );
		xnp_insert_member( $xnpsid, $gid, $i, 1 );
	}
	$op = '';
	
	// Record events(insert group)
	xnp_insert_event( $xnpsid, ETID_INSERT_GROUP, time(), $uid, xnpGetRemoteHost(), array( 'gid' => $gid ) );
	xnpGenerateRss( ); //update RSS
	break;
case 'edit':
	$group = array(  );
	$result = xnp_get_group( $xnpsid, $gid, $group );
	if( $result != 0 ) {
		redirect_header( 'editgroups.php', 3, _MD_XOONIPS_MODERATOR_ERROR_SELECT_GROUP );
		exit(  );
	}
	$item_storage_limit = sprintf( "%.2lf", $group['item_storage_limit'] / 1000 / 1000 );
	$xoopsTpl->assign( 'gid', $group['gid'] );
	$xoopsTpl->assign( 'gname', $group['gname'] );
	$xoopsTpl->assign( 'gdesc', $group['gdesc'] );
	$xoopsTpl->assign( 'item_number_limit', $group['item_number_limit'] );
	$xoopsTpl->assign( 'index_number_limit', $group['index_number_limit'] );
	$xoopsTpl->assign( 'item_storage_limit', $item_storage_limit );
	break;
case 'update':
	$group = array( 'gid' => $gid,
					'gname' => $ts->stripSlashesGPC( $gname ),
					'gdesc' => $ts->stripSlashesGPC( $gdesc ),
					'item_number_limit' => $item_number_limit,
					'index_number_limit' => $index_number_limit,
					'item_storage_limit' => $item_storage_limit * 1000 * 1000 );
	$result = xnp_update_group( $xnpsid, $group );
	if( $result != RES_OK ) {
		if( $result == RES_GROUPNAME_ALREADY_EXISTS ){
			$xoopsTpl->assign( 'gid', $gid );
			$xoopsTpl->assign( 'gname', $ts->stripSlashesGPC( $gname ) );
			$xoopsTpl->assign( 'gdesc', $ts->stripSlashesGPC( $gdesc ) );
			$xoopsTpl->assign( 'item_number_limit', $item_number_limit );
			$xoopsTpl->assign( 'index_number_limit', $index_number_limit );
			$xoopsTpl->assign( 'item_storage_limit', $item_storage_limit );
			$xoopsTpl->assign( 'gname_exists', true );
			$gadmin_uids = $gadmins;
			$op='edit';
			break;
		}else{
			redirect_header( 'editgroups.php', 3, _MD_XOONIPS_MODERATOR_ERROR_INSERT_GROUP );
			exit(  );
		}
	}
	$adminuids = array(  );
	if( xnp_dump_group_admins( $xnpsid, $gid, array(  ), $adminuids ) == 0 ) {
		foreach( $adminuids as $i ) {
			xnp_delete_member( $xnpsid, $gid, $i );
			xnp_insert_member( $xnpsid, $gid, $i, 0 );
		}
	}
	foreach( $gadmins as $i ) {
		xnp_delete_member( $xnpsid, $gid, $i );
		xnp_insert_member( $xnpsid, $gid, $i, 1 );
	}
	$op = '';
	
	// Record events(update group)
	xnp_insert_event( $xnpsid, ETID_UPDATE_GROUP, time(), $uid, xnpGetRemoteHost(), array( 'gid' => $gid ) );
	
	break;
case 'delete':
	$result = xnp_delete_group( $xnpsid, $gid );
	if( $result != 0 ) {
		redirect_header( 'editgroups.php', 3, _MD_XOONIPS_MODERATOR_ERROR_DELETE_GROUP );
		exit(  );
	}
	$op = '';
	
	// Record events(delete group)
	xnp_insert_event( $xnpsid, ETID_DELETE_GROUP, time(), $uid, xnpGetRemoteHost(), array( 'gid' => $gid ) );
	
	break;
default:
	break;
}

$xoopsTpl->assign( 'op', $op );
$xoopsOption['template_main'] = 'xoonips_editgroups.html';

//set limitation value(initial value)
if( $op == '' ) {
	$value = '';
	xnp_get_config_value( 'group_item_number_limit', $value );
	$xoopsTpl->assign( 'item_number_limit', $value );

	$value = '';
	xnp_get_config_value( 'group_item_storage_limit', $value );
	$xoopsTpl->assign( 'item_storage_limit', sprintf( "%.2lf", $value / 1000 / 1000 ) );

	$value = '';
	xnp_get_config_value( 'group_index_number_limit', $value );
	$xoopsTpl->assign( 'index_number_limit', $value );

}

$gids = array(  );
if( xnp_dump_gids( $xnpsid, array(  ), $gids ) != 0 ) {
	redirect_header( 'index.php', 3,
					 "ERROR [AbstractLayer]".xnp_get_last_error_string(  ) );
	exit(  );
}

$groups = array(  );
if( xnp_get_groups( $xnpsid, $gids, array(  ), $groups ) != 0 ) {
	redirect_header( 'index.php', 3,
					 "ERROR [AbstractLayer]".xnp_get_last_error_string(  ) );
	exit(  );
}
$xoopsTpl->assign( 'groups', $groups );

$uids = array(  );
if( xnp_dump_uids( $xnpsid, array(  ), $uids ) != 0 ) {
	redirect_header( 'index.php', 3,
					 "ERROR [AbstractLayer]".xnp_get_last_error_string(  ) );
	exit(  );
}

$users = array(  );
if( xnp_get_accounts( $xnpsid, $uids, array(  ), $users ) != 0 ) {
	redirect_header( 'index.php', 3,
					 "ERROR [AbstractLayer]".xnp_get_last_error_string(  ) );
	exit(  );
}


$gadmins = array(  );
foreach( $users as $i )
{
	$admin_flag = 0;
	if( ( $op == 'register' || $op == 'edit' ) && isset( $gadmin_uids ) ){
		$admin_flag = in_array( $i['uid'], $gadmin_uids );
	}else if( $op == 'edit' && isset( $gid ) ) {
		//if user is group's administrator
		if( xnp_is_group_admin( $xnpsid, $gid, $i['uid'] ) ) {
			$admin_flag = 1;
		}
	}
	if( $i['activate'] == 1 ) {	//add to gadmins if activated.
		$gadmins[] = array( 'uid' => $i['uid'],
							'uname' => $i['uname'], 'isadmin' => $admin_flag );
	}
}

$xoopsTpl->assign( 'gadmins', $gadmins );
$xoopsTpl->assign( 'accept_charset', xnpGetMacSafariAcceptCharset() );
$xoopsTpl->assign( 'xoonips_editprofile_url', XOOPS_URL . '/modules/xoonips/edituser.php?uid=' . $uid );

require( XOOPS_ROOT_PATH.'/footer.php' );
?>
