<?php
//  $Revision: 1.16.2.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //
/* index module
 * 
 * input:
 *   op                |open(default)|register|up|down|rename|delete|moveto|
 *  -------------------+-------------+--------+--+----+------+------+------+
 *   xid               |*            |*       |* |*   |*     |*     |*     | current
 *   new_index_name    |             |*       |  |    |      |      |      |
 *   updown_xid        |             |        |* |*   |      |      |      |
 *   step[$updown_xid] |             |        |* |*   |      |      |      |
 *   check[]           |             |        |  |    |*     |*     |*     | check[0], check[1], check[2] ... <- xid
 *   rename[]          |             |        |  |    |*     |      |      | rename[xid] <- title
 *   moveto            |             |        |  |    |      |      |*     |
 *   
 *   op_rename -> op=rename
 *   op_delete -> op=delete
 *   op_moveto -> op=moveto
 */

$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';
include_once 'include/lib.php';
include_once XOOPS_ROOT_PATH.'/class/module.textsanitizer.php';
include_once XOOPS_ROOT_PATH . '/modules/system/constants.php';

$config_handler =& xoops_gethandler('config');
$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
$myts =& MyTextSanitizer::getInstance();

require_once 'include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

require_once 'condefs.php'; // for OL_*  RES_OK

// If not a user, redirect
if ( !$xoopsUser ) {
	redirect_header(XOOPS_URL.'/index.php',3,_NOPERM);
	exit();
}

$op = 'open';
$xid = 0;

$accept_var_names = array( 'op', 'index_id', 'xid', 'new_index_name', 'updown_xid', 'steps', 'check', 'rename', 'moveto', 'op_rename', 'op_delete', 'op_moveto' );
foreach ( $_POST as $k => $v ) if ( in_array( $k, $accept_var_names ) ) $$k = $v;
foreach ( $_GET  as $k => $v ) if ( in_array( $k, $accept_var_names ) ) $$k = $v;
if( isset( $op_rename ) ) $op = 'rename';
if( isset( $op_delete ) ) $op = 'delete';
if( isset( $op_moveto ) ) $op = 'moveto';
if( empty($xid) && !empty($index_id) )
	$xid = $index_id;

// get current place
$uid=$xoopsUser->getVar('uid');
$account = array();

if ( RES_OK == xnp_get_account( $xnpsid, $uid, $account ) ){
	$privateXID = $account['private_index_id'];
}
else {
	// user has no PrivateIndex.
	redirect_header(XOOPS_URL.'/index.php',3,_NOPERM);
	exit();
}
if ( $xid == 0 ){
	$xid = $privateXID;
}

// check the right to access.
$index = array();
$result = xnp_get_index ( $xnpsid, $xid, $index );
if ( $result != RES_OK ){
	redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
	exit;
}
if ( $index['open_level'] == OL_PUBLIC && xnp_is_moderator($xnpsid,$uid) ||
     $index['open_level'] == OL_GROUP_ONLY && xnp_is_group_admin($xnpsid,$index['owner_gid'],$uid) ||
     $index['open_level'] == OL_PRIVATE && $index['owner_uid'] == $uid ){
	// User has the right to write.
}
else {
	// User doesn't have the right to write.
	redirect_header(XOOPS_URL.'/index.php',3,_NOPERM);
	exit;
}

// return index_id which is under IID_ROOT and has a node '$xid'. in error, return zero.
function xoonipsGetTopIndex( $xid ){
	global $xnpsid;
	
	$index = array();
	$result = xnp_get_index( $xnpsid, $xid, $index );
	if ( $result != RES_OK )
		return 0;
	
	$indexes = array();
	$criteria = array();
	$result = xnp_get_indexes( $xnpsid, IID_ROOT, $criteria, $indexes );
	if ( $result != RES_OK )
		return 0;
	
	foreach ( $indexes as $key => $val ){
		if ( $index['open_level'] == $val['open_level'] ){
			if (   $index['open_level'] == OL_PUBLIC 
				|| $index['open_level'] == OL_GROUP_ONLY && $index['owner_gid'] == $val['owner_gid']
				|| $index['open_level'] == OL_PRIVATE    && $index['owner_uid'] == $val['owner_uid'] ){
				return $val['item_id'];
			}
		}
	}
	
	return 0;
}


// Value that sends to tree-block put on header.php behind.
$xoonipsURL = 'editindex.php';
$xoonipsEditIndex = true;
$xoonipsSelectedTab = xoonipsGetTopIndex( $xid );

$xoopsOption['template_main'] = 'xoonips_editindex.html';
include XOOPS_ROOT_PATH.'/header.php';

$error_messages = array();


// sum of numbers index(private/group) that specified xid, maximum of numbers index.
function xoonipsGetIndexCountInfo( $xnpsid, $xid ){
	$index = array();
	$result = xnp_get_index( $xnpsid, $xid, $index );
	if ( $result != RES_OK ){
		redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
		break;
	}
	$openLevel = $index['open_level'];

	$indexes = array();
	$result = xnp_get_all_indexes( $xnpsid, array(), $indexes );
	if ( $result != RES_OK ){
		redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
		break;
	}
	$indexesLen = count($indexes);

	if ( $openLevel == OL_PRIVATE ){
		$indexUID = $index['owner_uid'];
		$indexCount = 0;
		for ( $i = 0; $i < $indexesLen; $i++ ){
			if ( $indexes[$i]['owner_uid'] == $indexUID )
				$indexCount++;
		}
		global $account;
		$indexNumberLimit = $account['index_number_limit'];
		$limitLabel = _MD_XOONIPS_INDEX_NUMBER_OF_PRIVATE_INDEX_LABEL;
	}
	else if ( $openLevel == OL_GROUP_ONLY ){
		$indexGID = $index['owner_gid'];
		$group = array();
		$result = xnp_get_group( $xnpsid, $indexGID, $group );
		
		$indexCount = 0;
		for ( $i = 0; $i < $indexesLen; $i++ ){
			if ( $indexes[$i]['owner_gid'] == $indexGID )
				$indexCount++;
		}
		$indexNumberLimit = $group['index_number_limit'];
		$limitLabel = _MD_XOONIPS_INDEX_NUMBER_OF_GROUP_INDEX_LABEL;
	}
	else
		return array( false, false, false );

	return array( $limitLabel, $indexCount, $indexNumberLimit );
}


/** get list of item's path(by user). (function of xoonipsTraverseTree)
 * @param xnpsid
 * @param index
 * @param context
   $context['dirArray'] path to index
   $context['uidItemNames']  list of item's path by user (calcurate now)
 * @param depth
 */
function xoonipsGetUidItemNames( $xnpsid, &$index, &$context, $depth ){
	$context['dirArray'][$depth] = $index;
	
	// generate pathString
	$ar = array();
	for ( $i = 0; $i <= $depth; $i++ )
		$ar[] = $context['dirArray'][$i]['titles'][DEFAULT_INDEX_TITLE_OFFSET];
	$pathString = implode( '/', $ar );
	
	// get child item by userid
	$iids = array();
	$result = xnp_get_item_id_by_index_id( $xnpsid, $index['item_id'], array(), $iids );
	if ( $result != RES_OK )
		return $result;
	
	$items = array();
	$result = xnp_get_items( $xnpsid, $iids, array(), $items );
	if ( $result != RES_OK )
		return $result;
	
	foreach ( $items as $key => $item ){
		//var_dump( $item );
		$uid = $item['uid'];
		if ( !isset( $context['uidItemNames'][$uid] ) )
			$context['uidItemNames'][$uid] = array();
		$context['uidItemNames'][$uid][] = $pathString . "/" . $item['titles'][DEFAULT_INDEX_TITLE_OFFSET];
	}
	return RES_OK;
}

/** call functions to each indexes from Indextree.
 *  process parent before child. Depth priority.
 * @param xnpsid    
 * @param index     association array of index
 * @param function  result_t function( xnpsid, index, context, depth )
 * @param context   context of function
 * @param depth     depth of argument 'index'. ROOT=0.
 * @return  result_t
 */
function xoonipsTraverseTree( $xnpsid, &$index, $func, &$context, $depth=0 ){
	$result = $func( $xnpsid, $index, $context, $depth );
	if ( $result != RES_OK )
		return $result;
	
	// The child is recurrently traced. 
	$indexes = array();
	$result = xnp_get_indexes( $xnpsid, $index['item_id'], array(), $indexes );
	if ( $result != RES_OK )
		return $result;
	
	foreach ( $indexes as $key=>$child_index ){
		$result = xoonipsTraverseTree( $xnpsid, $child_index, $func, $context, $depth+1 );
		if ( $result != RES_OK )
			return $result;
	}
	return RES_OK;
}

function xoonipsCountAllSubindexSub( $xnpsid, &$index, &$context, $depth ){ $context[0]++; }

// The number of all indexes of $index or less is recurrently counted. 
function xoonipsCountAllSubindex( $xnpsid, &$index, &$ct ){
	$context = array(0);
	$result = xoonipsTraverseTree( $xnpsid, $index, 'xoonipsCountAllSubindexSub', $context );
	$ct = $context[0];
	return $result;
}


unset($indexCount);
// operate
if ( $op == 'open' || $op == '' ){
	;
}
else if ( $op == 'register' ){

	$indexes = array();
	$result = xnp_get_indexes( $xnpsid, $xid, array(), $indexes );
	if ( $result != RES_OK ){
		redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
		exit;
	}
	do{
		list( $limitLabel, $indexCount, $indexNumberLimit ) = xoonipsGetIndexCountInfo( $xnpsid, $xid );
		if ( "$indexNumberLimit" != "" && $indexNumberLimit <= $indexCount ){
			$error_messages[] = _MD_XOONIPS_INDEX_TOO_MANY_INDEXES;
            break;
		}
		
		$lengths = xnpGetColumnLengths( 'xoonips_item_title' );
		list( $within, $without ) = xnpTrimString( $new_index_name, $lengths['title'] );
		
		// Ĺ¤˰äʤٹ𤹤
		if ( strlen($without) ){
			$error_messages[] = sprintf( _MD_XOONIPS_INDEX_TITLE_EXCEEDS, $new_index_name );
			break;
		}
		
		// ̾ϤƤʤʤٹ𤹤
		if ( strlen( $new_index_name ) == 0 ){
			$error_messages[] = _MD_XOONIPS_INDEX_TITLE_EMPTY;
			break;
		}
		
		// break if sibling has same name
		foreach ( $indexes as $index ){
			if ( $index['titles'][DEFAULT_INDEX_TITLE_OFFSET] == $new_index_name ){
				$error_messages[] = sprintf( _MD_XOONIPS_INDEX_TITLE_CONFLICT, $new_index_name );
				break 2;
			}
		}
		
		$index = array();
		$result = xnp_get_index( $xnpsid, $xid, $index );
		if ( $result != RES_OK ){
			redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
			exit;
		}
		
		// register index
		$index['parent_index_id'] = $xid;
		$index['titles'] = array( $myts->stripSlashesGPC( encodeMacSafari2Server( $new_index_name ) ) );
		$result = xnp_insert_index( $xnpsid, $index, $new_xid );
		if ( $result == RES_OK ){
			$indexCount++;
			// Record events(insert index)
			xnp_insert_event( $xnpsid, ETID_INSERT_INDEX, time(), $uid, xnpGetRemoteHost(), array( 'index_id' => $new_xid ) );
		}
	}while( false );
}
else if ( $op == 'up' || $op == 'down' ){
	$step = $steps[$updown_xid];
	
	if ( $op == 'up' ) $dir = -1;
	else $dir = 1;
	
	// get children
	$childIndexes = array();
	$criteria = array( 'orders'=>array( array('name'=>'sort_number', 'order'=>'ASC' ) ) );
	$result = xnp_get_indexes( $xnpsid, $xid, $criteria, $childIndexes );
	if ( $result == RES_OK ){
		$childIndexesLen = count($childIndexes);
		
		// get pos
		$pos = -1;
		for ( $i = 0; $i < $childIndexesLen; $i++ ){
			if ( $childIndexes[$i]['item_id'] == $updown_xid ){
				$pos = $i;
				break;
			}
		}
		//var_dump( $childIndexes );
		if ( $pos != -1 ){
			// change orders
			for ( $j = 0; $j < $step; $j++ ){
				$pos += $dir;
				if ( $pos < 0 || $childIndexesLen <= $pos )
					break;
				$updown_xid2 = $childIndexes[$pos]['item_id'];
				$result = xnp_swap_index_sort_number( $xnpsid, $updown_xid, $updown_xid2 );
				//echo "swap($updown_xid,$updown_xid2) result=$result";
				if ( $result != RES_OK )
					break;
			}
		}
	}
}
else if ( ($op == 'rename' || $op == 'delete' || $op == 'moveto') && isset($check) ){
	
	$xoopsMailer =& getMailer();
	$lengths = xnpGetColumnLengths( 'xoonips_item_title' );
	reset( $check );
	while ( list( $key, $index_id ) = each( $check ) ){
		$index_id = (int)$index_id;
		$index = array();
		$result = xnp_get_index ( $xnpsid, $index_id, $index );
		if ( $result != RES_OK ){
			redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
			exit;
		}
		
		// get items under $index by owners
		$uidItemNames = array();
		$oldPathString = xoonipsGetPathString( $xnpsid, $index_id );
		if ( $index['open_level'] != OL_PRIVATE ){
			$dirArray = xoonipsGetPathArray( $xnpsid, $index_id );
			$context = array( 'dirArray' => $dirArray, 'uidItemNames' => array() );
			$result = xoonipsTraverseTree( $xnpsid, $index, 'xoonipsGetUidItemNames', $context, count($dirArray)-1 );
			if ( $result != RES_OK ){
				redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
				exit;
			}
			$uidItemNames = $context['uidItemNames'];
		}
		
		if ( $op == 'rename' ){
			$new_index_name = $myts->stripSlashesGPC( encodeMacSafari2Server( $rename[$index_id] ) );
			list( $within, $without ) = xnpTrimString( $new_index_name, $lengths['title'] );
			
			// Ĺ¤˰äʤٹ𤹤
			if ( strlen($without) ){
				$error_messages[] = sprintf( _MD_XOONIPS_INDEX_TITLE_EXCEEDS, $new_index_name );
				continue;
			}
			
			// ̾ϤƤʤʤٹ𤹤
			if ( strlen( $new_index_name ) == 0 ){
				$error_messages[] = _MD_XOONIPS_INDEX_TITLE_EMPTY;
				continue;
			}
			
			// Warning, if there is the same name of index.
			$indexes = array();
			$result = xnp_get_indexes( $xnpsid, $xid, array(), $indexes );
			if ( $result != RES_OK ){
				redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
				exit;
			}
            
			foreach ( $indexes as $index2 ){
				if ( $index2['titles'][DEFAULT_INDEX_TITLE_OFFSET] == $within ){
    				$error_messages[] = sprintf( _MD_XOONIPS_INDEX_TITLE_CONFLICT, $within );
					continue 2;
				}
			}
			
			$old_index = $index;
			$index['titles'] = array( $within );
			$index['without'] = $without;
			
			$result = xnp_update_index( $xnpsid, $index );
			if ( $result == RES_OK ){
				// record events(update index)
				xnp_insert_event( $xnpsid, ETID_UPDATE_INDEX, time(), $uid, xnpGetRemoteHost(), array( 'index_id' => $index_id ) );
			}
			
			$newPathString = xoonipsGetPathString( $xnpsid, $index_id );
			$body = sprintf( _MD_XOONIPS_INDEX_RENAME_MESSAGE, $oldPathString, $newPathString );
			$subject = _MD_XOONIPS_INDEX_RENAME_MAIL_SUBJECT;
		}
		else if ( $op == 'delete' ){
			$result = xnp_delete_index( $xnpsid, $index_id );
			if ( $result == RES_OK ){
				// record events(delete index)
				xnp_insert_event( $xnpsid, ETID_DELETE_INDEX, time(), $uid, xnpGetRemoteHost(), array( 'index_id' => $index_id ) );
			}
			
			$body = sprintf( _MD_XOONIPS_INDEX_DELETE_MESSAGE, $oldPathString );
			$subject = _MD_XOONIPS_INDEX_DELETE_MAIL_SUBJECT;
		}
		else if ( $op == 'moveto' ){
			// Can't move to another area(Public/Group/Private)
			$destIndex = array();
			$result1 = xnp_get_index( $xnpsid, $moveto, $destIndex );
			$srcIndex = array();
			$result2 = xnp_get_index( $xnpsid, $index_id, $srcIndex );
			if ( $destIndex['open_level'] != $srcIndex['open_level'] ||
			     $destIndex['owner_uid']  != $srcIndex['owner_uid']  ||
			     $destIndex['owner_gid']  != $srcIndex['owner_gid']  ){
				$error_messages[] = _MD_XOONIPS_INDEX_BAD_MOVE;
				break;
			}
			
			// move
			$index['parent_index_id'] = $moveto;
			$result = xnp_update_index( $xnpsid, $index );
			if ( $result == RES_OK ){
				// record events(update index)
				xnp_insert_event( $xnpsid, ETID_UPDATE_INDEX, time(), $uid, xnpGetRemoteHost(), array( 'index_id' => $index_id ) );
			}
			
			$newPathString = xoonipsGetPathString( $xnpsid, $index_id );
			$body = sprintf( _MD_XOONIPS_INDEX_MOVETO_MESSAGE, $oldPathString, $newPathString );
			$subject = _MD_XOONIPS_INDEX_MOVETO_MAIL_SUBJECT;
		}
		else {
			;
		}
		
		if ( $result != RES_OK ){
			redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
			exit;
		}
		
		// notificate rename, delete, and move to item's owner
		if ( count($uidItemNames) != 0 ){
			foreach ( $uidItemNames as $to_uid => $itemNames ){
				$account = array();
				$result = xnp_get_account( $xnpsid, $to_uid, $account );
				if ( $result != RES_OK )
					continue;
				global $xoopsModule;
				$tags = array();
				$tags['AFFECTED_ITEM'] = implode( "\n  ", $itemNames );
				$notification_handler =& xoops_gethandler('notification');
				if( $op == 'rename' ){
                    $tags['INDEX_OLD'] = $oldPathString;
                    $tags['INDEX_NEW'] = $newPathString;
					$tags['INDEX_URL'] = XOOPS_URL . '/modules/' . $xoopsModule->dirname() . "/listitem.php?index_id=${index_id}";
                    $result = $notification_handler->triggerEvent('user', 0, 'index_renamed', $tags, array($account['uid']));
				}else if( $op == 'delete' ){
                    $tags['INDEX'] = $oldPathString;
                    $result = $notification_handler->triggerEvent('user', 0, 'index_deleted', $tags, array($account['uid']));
				}else if( $op == 'moveto' ){
                    $tags['INDEX_OLD'] = $oldPathString;
                    $tags['INDEX_NEW'] = $newPathString;
					$tags['INDEX_URL'] = XOOPS_URL . '/modules/' . $xoopsModule->dirname() . "/listitem.php?index_id=${index_id}";
                    $result = $notification_handler->triggerEvent('user', 0, 'index_moved', $tags, array($account['uid']));
                }
			}
		}
	}
}
else {
	;
}



//////////////////////// display
if ( !isset($indexCount) ){
	list( $limitLabel, $indexCount, $indexNumberLimit ) = xoonipsGetIndexCountInfo( $xnpsid, $xid );
}
$xoopsTpl->assign('limitLabel', $limitLabel );
$xoopsTpl->assign('indexCount', $indexCount );
$xoopsTpl->assign('indexNumberLimit', $indexNumberLimit );


function genIndexAnchor( $index ){
	$xid = $index['item_id'];
	$escTitle = xnpHtmlspecialchars($index['titles'][DEFAULT_INDEX_TITLE_OFFSET]);
	$anchor = "<a href='editindex.php?xid=$xid'>$escTitle</a>";
	return $anchor;
}

/** generate character strings from result of xoonipsGetPathArray()
 */
function xoonipsGetPathString( $xnpsid, $xid ){
	$dirArray = xoonipsGetPathArray( $xnpsid, $xid );
	$ar = array();
	foreach ( $dirArray as $key => $val )
		$ar[] = $val['titles'][DEFAULT_INDEX_TITLE_OFFSET];
	return '/' . implode( '/', $ar );
}

/** return array of indexes (path from ROOT to xid, Don't contain ROOT)
 */
function xoonipsGetPathArray( $xnpsid, $xid ){
	$dirArrayR = array();
	for ( $p_xid = $xid; $p_xid != IID_ROOT; $p_xid = (int)($index['parent_index_id']) ){
		// get $index
		$index = array();
		$result = xnp_get_index( $xnpsid, $p_xid, $index );
		if ( $result != RES_OK ){
			redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
			break;
		}
		
		$dirArrayR[] = $index;
	}
	$ct = count( $dirArrayR );
	$dirArray = array();
	for ( $i = 0; $i < $ct; $i++ ){
		$dirArray[] = $dirArrayR[ $ct-$i-1 ];
	}
	return $dirArray;
}

$dirArray = xoonipsGetPathArray( $xnpsid, $xid );


// get Children
// -> childIndexes
$childIndexes = array();
$criteria = array( 'orders'=>array( array('name'=>'sort_number', 'order'=>'ASC' ) ) );
$result = xnp_get_indexes( $xnpsid, $xid, $criteria, $childIndexes );
// prev_idnex_id, next_index_id are set
reset( $childIndexes );
/*
$prev_key = FALSE;
while ( list( $key ) = each( $childIndexes ) ){
	if ( $prev_key !== FALSE ){
		$childIndexes[$prev_key]['next_index_id'] = $childIndexes[$key     ]['item_id'];
		$childIndexes[$key     ]['prev_index_id'] = $childIndexes[$prev_key]['item_id'];
	}
	$prev_key = $key;
}
*/
//var_dump( $childIndexes );

// generate list about 'moveto'
require_once( 'include/gentree.php' );

function genSelectLabels( &$index ){
	$title = $index['titles'][DEFAULT_INDEX_TITLE_OFFSET];
	$indent_html = str_repeat( '&nbsp;&nbsp;', (int)($index['depth']));
	if ( isset( $index['child_count'] ) &&  $index['child_count'] != 0 )
		$childCount = '( ' . $index['child_count'] . ' )';
	else
		$childCount = '';
	$index['indent_html'] = $indent_html;
	$index['select_label'] = " $title $childCount";
}

$index = array();
xnp_get_index( $xnpsid, $xid, $index );

$indexTree = genSameAreaIndexTree( $xnpsid, $uid, $index );
array_walk( $indexTree, 'genSelectLabels' );


$xoopsTpl->assign('updown_options', array(1=>1,2=>2,3=>3,4=>4,5=>5,6=>6,7=>7,8=>8,9=>9,10=>10) );
$xoopsTpl->assign('error_message', $error_messages );
$xoopsTpl->assign('childCount', count($childIndexes) );
$xoopsTpl->assign('open_level', $index['open_level'] );
$xoopsTpl->assign('xid', $xid );
$xoopsTpl->assign('index_path', $dirArray ); // 
$xoopsTpl->assign('child_indexes', $childIndexes );
$xoopsTpl->assign('index_tree', $indexTree );
$xoopsTpl->assign('accept_charset', xnpGetMacSafariAcceptCharset() );
$xoopsTpl->assign( 'xoonips_editprofile_url', XOOPS_URL . '/modules/xoonips/edituser.php?uid=' . $uid );

require(XOOPS_ROOT_PATH.'/footer.php');

?>
