<?php
//  $Revision: 1.17.2.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //
// 
// $op
//   'export' .... Export and download
//   'list'   .... page of agreement licence(item to export)
//   'config' .... set condition to Export
// 
// $export_type
//   'index' .... Export strcuture of index tree specified by $index_id
//   'item'  .... Export items specified by $ids or registered to $index_id
// 
// $index_id
//   User wants to export specified index_id
// 
// $ids
//   array of item_id to be exported
// 
// $recursive_index
// $recursive_item
//   Do indexes export recursively?
//   refer $recursive_index if $export_type is 'index'
//   refer $recursive_item if $export_type is 'item'
//   1 .... Yes
//   0 .... No
//   Undefine .... No
//
// $attachment
//   Do attachment files export?
//   1 .... Yes
//   0 .... No
//   Undefine .... No
session_cache_limiter('none'); // Escape IE's Bug 1 -> http://jp2.php.net/header  Harry 10-Dec-2004 03:26
$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';

include 'condefs.php';
include_once 'include/lib.php';
include_once 'include/imexport.php';
require_once 'include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

if ( !$xoopsUser ) {
    redirect_header( 'index.php',3,_MD_XOONIPS_ITEM_FORBIDDEN);
    exit();
}

$uid = $_SESSION['xoopsUserId'];

    //Uncertified user can't access(except XOOPS administrator).
if( !$xoopsUser->isAdmin( $xoopsModule->getVar('mid') )
    && !xnp_is_activated( $xnpsid, $uid ) ){
    redirect_header( 'index.php', 3, _MD_XOONIPS_MODERATOR_NOT_ACTIVATED);
    exit();
}

foreach( array( 'op' => '',
                'index_id' => '',
                'export_type' => '',
                'recursive_item' => 0,
                'recursive_index' => 0,
                'attachment' => 0,
                'ids' => array() ) as $k => $v ){
    if( isset( $_GET[ $k ] ) ){
        $$k = $_GET[ $k ];
    }else if( isset( $_POST[ $k ] ) ){
        $$k = $_POST[ $k ];
    }else{
        if( isset( $v ) ){
            $$k = $v;
        }
    }
}

if( $op == 'export' )
{
    do{
        $zippedFiles = array(); // The filenames, that zipped.
        $removeFiles = array(); // The filenames, that should be removed.

        $tmpfile = tempnam("/tmp", "FOO");
        unlink( $tmpfile );
        $tmpdir = $tmpfile."D";//folder zipped files to be stored.
        if( !mkdir( $tmpdir ) ){
            xoonips_error( "can't make directory '${tmpdir}'\n" );
            $system_message = "can't make directory '${tmpdir}'";
            $op = 'list';
            break;
        }
        chdir($tmpdir);
        
        if( $export_type == '' ){
            die( '$export_type is not defined' );
        }else if( $export_type == 'index' ){
            // 
            // exprot index tree structure only
            // 
            $index = array();
            if( $index_id != '' ){
                $res = xnp_get_index( $xnpsid, $index_id, $index );
                if( $res == RES_OK ){
                    $tmpfile = tempnam("/tmp", "FOO");
                    $filename = "index.xml";
                    $fp = fopen($tmpfile, "w");
                    if( !$fp ){
                        xoonips_error( "can't open file '${tmpfile}' for write." );
                        $system_message = "can't open file '${tmpfile}' for write.";
                        $op = 'list';
                        break;
                    }

                    if( fwrite($fp, "<indexes>\n" )
                        && xnpExportIndex( $fp, $index_id, $recursive_index == 1 )
                        && fwrite($fp, "</indexes>\n" ) ){
                        fclose($fp);
                        // ݡȥեʸɤ򡤴Ķ˹碌Ѵ
                        $fp_r = fopen($tmpfile, "r");
                        $fp_w = fopen($filename, "w");
                        if( !$fp_r || !$fp_w ){
                            if( !$fp_r ){
                                xoonips_error( "can't open file '${tmpfile}' for read." );
                                $system_message = "can't open file '${tmpfile}' for read.";
                            }
                            if( !$fp_w ){
                                xoonips_error( "can't open file '${filename}' for write." );
                                $system_message = "can't open file '${filename}' for write.";
                            }
                            unlink( $tmpfile );
                            unlink( $filename );
                            if( $fp_r ) fclose( $fp_r );
                            if( $fp_w ) fclose( $fp_w );
                            $op = 'list';
                            break;
                        }
                        while( !feof( $fp_r ) ){
                            fputs( $fp_w, encodeServer2Client( fgets( $fp_r, 131072 ) ) );
                        }
                        fclose( $fp_r );
                        fclose( $fp_w );
                        unlink( $tmpfile );
                        
                        $zippedFiles[] = $filename;
                        $removeFiles[] = "${tmpdir}/${filename}";
                    }else{
                        xoonips_error( "error in writing to '${filename}'" );
                        $system_message = "error in writing to '${filename}'";
                        fclose($fp);
                        unlink( $filename );
                        $op = 'list';//return to previous page(list of export item)
                        break;
                    }                
                }
            }
        }else if( $export_type == 'item' ){
            // 
            // export items
            // 
            foreach( $ids as $item_id ){
                $result = xnpExportItem( $tmpdir, $item_id, $attachment == 1, false, $recursive_item ? $index_id : false );
                if( !$result ){
                    //error: can't export.
                    xoonips_error( "error in exporting items" );
                    $system_message="error in exporting items";
                    $op = 'list'; //return to previous page(list of export item)
                    break 2;//exit from foreach and outer while loop
                }else{
                    $zippedFiles[] = $result['xml'];
                    $removeFiles[] = "${tmpdir}/${result['xml']}";
                
                    if ( !empty($result['attachments']) ){
                        foreach( $result['attachments'] as $file ){
                            $zippedFiles[] = $file;
                            $removeFiles[] = "${result['path']}/${file}";
                        }
                    }
                }
            }
        }

        if( count( $zippedFiles ) == 0 ){
            xoonips_error( _MD_XOONIPS_EXPORT_EXPORT_ITEMS_EMPTY );
            $system_message = _MD_XOONIPS_EXPORT_EXPORT_ITEMS_EMPTY;
            $op = 'list'; //return to previous page(list of export item)
            break;
        }
        
        $zippedFiles = array();
        $removeFiles = array();
        if ( $dh = opendir($tmpdir) ){
            while (false !== ($f = readdir($dh))) {
                if( $f == "." || $f == ".." || $f == "files" ) continue;
                $zippedFiles[] = $f;
                $removeFiles[] = "${tmpdir}/${f}";
            }
            closedir( $dh );
        }
        if ( $dh = @opendir($tmpdir."/files") ){
            while (false !== ($f = readdir($dh))) {
                if( $f == "." || $f == ".." || $f == "files" ) continue;
                $zippedFiles[] = "files/${f}";
                $removeFiles[] = "${tmpdir}/files/${f}";
            }
            closedir( $dh );
        }
    // do ZIP
        if( $export_type == 'item' ) chdir($result['path']);
        $zipFile = tempnam("/tmp", "FOO");
        unlink($zipFile);
        $removeFiles[] = $zipFile.".zip";
        $result = xnp_zip_create($zipFile.".zip", $zippedFiles);
        if (0 != $result){
            var_dump( $zipFile );
            var_dump( $zippedFiles );
            passthru( "ls -al $tmpdir" );
            print_r (get_loaded_extensions());
            print_r (get_extension_funcs ("XooNIps Abstract Layer"));
            xoonips_error(_MD_XOONIPS_ITEM_CANNOT_CREATE_ZIP . "result=$result");
            $system_message = _MD_XOONIPS_ITEM_CANNOT_CREATE_ZIP;
            $op = 'list'; //return to previous page(list of export item)
            break;
        }
        $size = filesize($zipFile.".zip");

        header("Cache-Control: none");  // To escape a IE's BUG(2)

        header("Content-Disposition: attachment; filename=\"export.zip\"");
        header("Content-Type: application/zip");
        if( $size != false ) header("Content-Length: $size");

        readfile($zipFile.".zip");

        foreach( $removeFiles as $f ){ unlink( $f ); }
        @rmdir($tmpdir."/files");//remove files/ folder(xnpExportFile makes this dir. see also imexport.php.)
        rmdir($tmpdir);
        exit();
    }while( false );
}

else if( $op == 'list' )
{
    if( $export_type == 'index' ){
        $indexpath = xnpGetIndexPathString( $xnpsid, $index_id );
        $export_index = _MD_XOONIPS_ITEM_INDEX_LABEL;
        $yesno = ( $recursive_index == 1 ) ? _YES : _NO;
        $export_recursive  = _MD_XOONIPS_EXPORT_RECURSIVE;
        $submit = _MD_XOONIPS_EXPORT_LICENSE_AGREEMENT_SUBMIT;
        $pankuzu = _MD_XOONIPS_EXPORT_PANKUZU_EXPORT
            . _MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR
            . _MD_XOONIPS_EXPORT_PANKUZU_EXPORT_INDEX;
        $message = _MD_XOONIPS_EXPORT_EXPORT_INDEX;
        
        include XOOPS_ROOT_PATH.'/header.php';
        echo <<<EOT
            <p>
            $pankuzu
            </p>
            <p>
            $message
            </p>
            <form id='export_list' action='export.php' method='post'>
            $export_index : $indexpath <br />
            $export_recursive : $yesno <br />
            <p style='text-align:center;'>
            <input name="submit" type="submit" value="$submit" />
            </p>        
            <input type='hidden' name='op' value='export' />
            <input type='hidden' name='export_type' value='$export_type' />
            <input type='hidden' name='index_id' value='$index_id' />
            <input type='hidden' name='recursive_index' value='$recursive_index' />
            </form>
EOT;
        include XOOPS_ROOT_PATH.'/footer.php';
    }else if( $export_type == 'item' ){
        $xoopsOption['template_main'] = 'xoonips_export_license.html';

        include XOOPS_ROOT_PATH.'/header.php';
    
        if( $index_id != '' ){
            $tmp_idx = array( $index_id );
            while( count( $tmp_idx ) > 0 ){
                $i = array_shift( $tmp_idx );
            
                $tmp_ids = array();
                $res = xnp_get_item_id_by_index_id( $xnpsid, $i, array(), $tmp_ids );
                if( $res == RES_OK ){
                    $ids = array_merge( $ids, $tmp_ids );
                }
                
                if( !$recursive_item ) break;
            
                $child = array();
                $res = xnp_get_indexes( $xnpsid, $i, array(), $child );
                if( $res == RES_OK ){
                    foreach( $child as $c ){
                        array_push( $tmp_idx, $c['item_id'] );
                    }
                }
            }
        }
    
        $ids = array_unique( $ids );
        $tmp = array();
        $itemtypes = array();
        $res = xnp_get_item_types( $tmp );
        foreach( $tmp as $i ){ $itemtypes[ $i['item_type_id'] ] = $i; }
    
        //ݡȤˤꡤ饤󥹤ιդɬפʤΤפʤΤʬ
        //$items['export'] = array( 饤פʥƥ );
        //$items['license_required'] = array( 饤פʥƥ );
        $items = array( );
        foreach( $ids as $i ){
            $item_basic = array();
            $res = xnp_get_item( $xnpsid, $i, $item_basic );
            if( $res == RES_OK
                && array_key_exists( $item_basic['item_type_id'], $itemtypes ) ){
                $func_license_required = $itemtypes[ $item_basic['item_type_id'] ]['name']."GetLicenseRequired";
                $func_license = $itemtypes[ $item_basic['item_type_id'] ]['name']."GetLicenseStatement";
                $func_html = $itemtypes[ $item_basic['item_type_id'] ]['name']."GetListBlock";
                $func_export = $itemtypes[ $item_basic['item_type_id'] ]['name']."ExportItem";
                include_once XOOPS_ROOT_PATH."/modules/".$itemtypes[ $item_basic['item_type_id'] ]['viewphp'];
                $license_required = function_exists( $func_license_required ) ? $func_license_required( $i ) : false;
                list( $license, $use_cc ) = function_exists( $func_license ) ? $func_license( $i ) : array( '', false );
                $html = function_exists( $func_html ) ? $func_html( $item_basic ) : '';
                if( !function_exists( $func_export ) || !export_enable( $i ) ){ $key = 'not_export'; }
                else if( $license_required ){ $key = 'license_required'; }
                else { $key = 'export'; }
                if( !array_key_exists( $key, $items ) ){
                    $items[$key] = array();
                }
                $items[$key][] = array( 'item_id' => $i,
                                        //'license_required' => $license_required,
                                        'license' => $license,
                                        'use_cc' => $use_cc,
                                        'detail_html' => $html,
                                        //'export_flag' => function_exists( $func_export )
                                        );
            }
        }
        if( $index_id != '' ) $xoopsTpl->assign('index_id', $index_id );
        if( isset( $system_message ) ) $xoopsTpl->assign('system_message', "<font color='#ff0000'>".$system_message."</font>" );
    
        $xoopsTpl->assign('export_type', $export_type );
        $xoopsTpl->assign('item', $items );
        $xoopsTpl->assign('attachment', $attachment );
        if( $export_type == 'item' ) $xoopsTpl->assign('recursive', $recursive_item );
        else if( $export_type == 'index' ) $xoopsTpl->assign('recursive', $recursive_index );
        include XOOPS_ROOT_PATH.'/footer.php';
    }else{
        die( "unknown \$export_type(${export_type})" );
    }
}

else if( $op == 'config' )
{
    include XOOPS_ROOT_PATH.'/header.php';
    
    echo _MD_XOONIPS_EXPORT_PANKUZU_EXPORT;
    echo _MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR;
    echo _MD_XOONIPS_EXPORT_PANKUZU_EXPORT_CONFIG;
    
    $yes = _YES;
    $no  = _NO;
    $export_type_item_type = $index_id != '' ? 'radio' : 'hidden';
    $export_type_item  = _MD_XOONIPS_EXPORT_TYPE_ITEM;
    $export_type_index = _MD_XOONIPS_EXPORT_TYPE_INDEX;
    $export_recursive  = _MD_XOONIPS_EXPORT_RECURSIVE;
    $export_attachment = _MD_XOONIPS_EXPORT_ATTACHMENT;
    $submit = _SUBMIT;
    
    echo <<<EOT
        <form id='export_config' action='export.php' method='post'>
        <table id='export_config_table' class='outer'>
         <tr>
          <th style='text-align:left;' colspan='2'>
           <input id='export_type_item' type='$export_type_item_type' name='export_type' value='item' checked />$export_type_item
          </th>
         </tr>
EOT;
    if( $index_id != '' ){
        echo <<<EOT
         <tr class='odd'>
          <td>
           $export_recursive
          </td>
          <td>
           <input id='recursive' type='radio' name='recursive_item' value='1' checked />$yes
           <input id='recursive' type='radio' name='recursive_item' value='0' />$no
          </td>
         </tr>
EOT;
    }
    
    $value = '';
    if( xnp_get_config_value( 'export_attachment', $value ) != RES_OK ){
        $value = 'off';
    }
    if( $value == 'on' ){
        
        echo <<<EOT
        <tr class='even'>
         <td>
          $export_attachment
         </td>
         <td>
          <input id='attachment' type='radio' name='attachment' value='1' checked />$yes
          <input id='attachment' type='radio' name='attachment' value='0' />$no
         </td>
        </tr>
EOT;

    }else{

        echo <<<EOT
        <tr class='even'>
         <td>
          $export_attachment
         </td>
         <td>
          <input type='hidden' name='attachment' value='0' />$no
         </td>
        </tr>
EOT;

    }

    if( $index_id != '' ){
        echo <<<EOT
        <tr>
         <th style='text-align:left;' colspan='2'>
          <input id='export_type_item' type='radio' name='export_type' value='index' />$export_type_index
         </th>
        </tr>
         <tr class='odd'>
          <td>
           $export_recursive
          </td>
          <td>
           <input id='recursive_index' type='radio' name='recursive_index' value='1' checked />$yes
           <input id='recursive_index' type='radio' name='recursive_index' value='0' />$no
          </td>
         </tr>
EOT;
    }
    echo <<<EOT
        </table>
        
        <p style='text-align:center;'>
         <input name="submit" type="submit" value="$submit" />
        </p>        
EOT;
    
    if( $index_id != '' ){
        echo "<input type='hidden' name='index_id' value='${index_id}' />\n";
    }
    
    foreach( $ids as $i ){
        echo "<input type='hidden' name='ids[]' value='${i}' />\n";
    }

    echo <<<EOT
        <input type='hidden' name='op' value='list' />
        </form>
EOT;
    include XOOPS_ROOT_PATH.'/footer.php';
}

else{
    die( "unknown \$op(${op})" );
}

/**
 * 
 * check indexes belong to items
 * return true(condition to export is full) / false(condition to export isn't full)
 * 
 */
function export_enable( $item_id )
{
    global $xnpsid, $uid;
    
    $xids = array();
    $result = xnp_get_index_id_by_item_id( $xnpsid, $item_id, $xids );
    if ( $result != RES_OK ){
        redirect_header(XOOPS_URL.'/index.php',3,"ERROR [AbstractLayer]".xnp_get_last_error_string());
    }
    foreach( $xids as $index_id ){
        // check that index is editable
        $index = array();
        $result = xnp_get_index( $xnpsid, $index_id, $index );
        if( $result != RES_OK ) continue; // skip index if access forbidden(ex: other's index)
        if( $index['open_level'] == OL_PRIVATE && $index['owner_uid'] == $uid ||
            $index['open_level'] == OL_GROUP_ONLY && xnp_is_group_admin( $xnpsid, $index['owner_gid'], $uid ) ||
            $index['open_level'] == OL_PUBLIC && xnp_is_moderator( $xnpsid, $uid ) && $index['item_id'] != IID_BINDERS && $index['item_id'] != IID_ROOT ){
            return true;
        }
    }
    return false;
}
?>
