<?php
//  $Revision: 1.3.2.2 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005-2007 RIKEN, Japan. All rights reserved.                  //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

define( "READFILE_FAILED", "cannot read file" );

class XoonipsText extends XoonipsSearchText {
	function XoonipsText(){
	}
	
	var $encode = false;
	
	/** ե뤫ƥȤΰ
	 *   @return Фƥȡ󥳡ɤUTF8
	 */
	function fetch(){
		if ( $this->handle == false )
			return array( false, XOONIPS_SEARCH_TEXT_FAILED );
		
		if ( $this->encode != false ){ // encodeȽ̺Ѥ
			$line = fgets( $this->handle );
			if ( $line == false ){
				$this->close();
				
				return array( false, false );
			}
			if ( $this->encode == 'UTF-8' )
				return array( $line, false );
			else
				return array( mb_convert_encoding( $line, 'UTF-8', $this->encode ), false );
		}
		
		// encodeȽ
		$len = 0;
		$ar = array();
		while ( $len < 65536 ){
			// todo: 1Ԥ۾Ĺ礬ΤǡfgetsϻȤʤ٤
			$line = fgets( $this->handle );
			if ( $line == false ){
				if ( count($ar) == 0 ){
					$this->close();
					return array( false, false );
				}
				break;
			}
			$ar[] = $line;
			$len += strlen($line);
		}
		$text = implode( '', $ar );
		if ( !function_exists('mb_detect_encoding') ){
			$this->encode = 'UTF-8';
			return array( $text, false );
		}
		$encode = strtolower( mb_detect_encoding( $text ) );
		if ( $encode == 'ascii' )
			return array( $text, false );
		$this->encode = $encode;

		return array( mb_convert_encoding( $text, 'UTF-8', $this->encode ), false );
	}
	
	function to_utf8( $fi, $fo, $fi_enc = "ASCII" ){
		// utf8 Ѵ
		$enc = false;
		$buf = "ASCII";
		while ( !feof($fi) ){
			$buf .= fread( $fi, 4096 );
			if ( $enc == 'ASCII' )
				$enc = mb_detect_encoding( $buf );
			
			$len = mb_strlen( $buf );
			$a = mb_substr( $buf, 0, $len );
			$b = mb_convert_encoding( $a, 'UTF-8', $enc );
			fwrite( $fi, $b );
			$buf = substr( $buf, strlen($a) );
		}
	}
};

?>
