<?php
//  Process of Harvest in OAI-PMH
//  $Revision: 1.4 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';
include_once 'include/lib.php';
include_once 'condefs.php';
include_once 'include/item_limit_check.php';

require_once 'include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

$mode = 'text'; //̤HTMLǽϤ$mode='html'ƥȤξ'text'

include_once 'oaiclass.php';

// $xoopsUser̤ʤ桼̾ȥѥɤ׵
//   Ϥ줿桼̾ȥѥɤXoops˥󤹤
//   ǤʤϽλ
if ( !$xoopsUser ) {
    if (!isset($_SERVER['PHP_AUTH_USER'])) {
        header("WWW-Authenticate: Basic realm=\"XooNIps harvesting\"");
        header("HTTP/1.0 401 Unauthorized");
        echo "Unauthorized your access\n";
        exit;
    } else {
        $uname = $_SERVER['PHP_AUTH_USER'];
        $pass = $_SERVER['PHP_AUTH_PW'];
        $member_handler =& xoops_gethandler('member');
        $myts =& MyTextsanitizer::getInstance();
        $xoopsUser =& $member_handler->loginUser(addslashes($myts->stripSlashesGPC($uname)), addslashes($myts->stripSlashesGPC($pass)));
        if( !$xoopsUser ){
            echo "Unauthorized your account";
            exit;
        }
        $uid = $xoopsUser -> getVar( 'uid' );
    }
    $mode='text';
}else{
    $uid = $_SESSION['xoopsUserId'];
    $mode='html';
}

//ǥ졼ʤ桼Ǥʤ(XOOPSԤ)
if( !$xoopsUser->isAdmin( $xoopsModule->getVar( 'mid' ) )
	&& !xnp_is_moderator( $xnpsid, $uid ) ) {
    redirect_header( XOOPS_URL.'/index.php', 3, _MD_XOONIPS_MODERATOR_SHULD_BE_MODERATOR );
}


global $xoopsDB;

if( $mode == 'html' ){
    include './header.php';
    echo "<p>\n";
    echo "<h3>"._MD_XOONIPS_OAIPMH_HARVEST_RESULT."</h3>\n";
    echo "</p>\n";
    echo "<a href='admin/oaipmh.php'>"._MD_XOONIPS_BACK_TO_OAIPMH_CONFIGURATION."</a><br />";
    echo "<p>\n";
}else if( $mode == 'text' )
    header( "Content-type: text/plain" );

$result = $xoopsDB -> query( "SELECT URL FROM ".$xoopsDB -> prefix( 'xoonips_oaipmh_repositories' )." WHERE enabled=1 AND deleted!=1 ORDER BY sort" );
set_time_limit( 0 );
while( list( $url ) = $xoopsDB -> fetchRow( $result ) ){
    echo "Trying\t$url";
    if( $mode == 'html' ) echo "<br />\n";
    else if( $mode == 'text' ) echo "\n";    
    $h = new OAIPMHHarvester( $url );
    if( !$h -> harvest() ){
        echo 'ERROR:'.$h -> last_error( );
    }else{
        echo "Succeed\t${url}";
    }
    if( $mode == 'html' ) echo "<br />\n";
    else if( $mode == 'text' ) echo "\n";    
}

if( $mode == 'html' ){
    echo "</p>\n";
    echo "<a href='admin/oaipmh.php'>"._MD_XOONIPS_BACK_TO_OAIPMH_CONFIGURATION."</a><br />";
    include XOOPS_ROOT_PATH.'/footer.php';
}
?>
