<?php
//  $Revision: 1.4 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //
/*
 * display thumbnail
 * input:
 *    $_GET['file_id']
 *    $_GET['thumbnail'] 1: thumbnail image
 * 
 */

include '../../mainfile.php';
if ( file_exists( XOOPS_ROOT_PATH.'/modules/xoonips/language/' . $xoopsConfig['language'] . '/main.php') ){
	include_once( XOOPS_ROOT_PATH.'/modules/xoonips/language/' . $xoopsConfig['language'] . '/main.php' );
}
else {
	include_once( XOOPS_ROOT_PATH.'/modules/xoonips/language/english/main.php' );
}

require_once 'include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];
require_once 'include/lib.php';


// -> fileID
if (empty($_GET['file_id'])){
	header("HTTP/1.0 404 Not Found");
	exit;
}
$fileID = (int)$_GET['file_id'];


// fileID -> itemID, sid, mime_type.
$fileTable = $xoopsDB->prefix('xoonips_file');
$fileTypeTable = $xoopsDB->prefix('xoonips_file_type');
$moduleTable = $xoopsDB->prefix('modules');
$sql = "select tf.item_id, tf.sess_id, tf.mime_type from $fileTable as tf where file_id=$fileID";
$result = $xoopsDB->query($sql);
if ($result == false || $xoopsDB->getRowsNum($result) == 0){
	header("HTTP/1.0 404 Not Found");
	exit;
}
list($item_id, $sess_id, $mime_type) = $xoopsDB->fetchRow($result);


// check rights of access
$item = array();
if ($xnpsid == $sess_id){
	// same sid
}
else if (0 == xnp_get_item($xnpsid,$item_id,$item)){
	// Visible item
}
else {
	// user don't have rights of access.
	header("HTTP/1.0 403 Forbidden");
	exit;
}


// If character's code changes automatic, it becomes invalid.
if (function_exists('mb_http_output')){
	mb_http_output('pass');
}


// output image
if (isset($_GET['thumbnail'])){
	$sql = "select thumbnail_file, length(thumbnail_file) from $fileTable where file_id=$fileID";
	$result = $xoopsDB->query($sql);
	list($thumbnail_file,$size) = $xoopsDB->fetchRow($result);
	header("Content-Type: image/png");
	header("Content-Length: $size");

	echo $thumbnail_file;
}
else {
	require_once(XOOPS_ROOT_PATH.'/modules/xoonips/include/lib.php');
	$filename = xnpGetUploadFilePath($fileID);
	$size = filesize($filename);

	if (!empty($mime_type))
		header("Content-Type: $mime_type");
	header("Content-Length: $size");

	readfile($filename);
}
exit;

?>