<?php
//  $Revision: 1.40.2.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

/**
   
   op='upload' .... upload a import file
     $_FILES['zipfile'][...]: information of uploaded file
     $xoonipsCheckedXID: id of index to import (comma separated)

   op='check_length' .... checking for too long strings
     it has same arguments of $op='import'.

   op='import' .... import
 */
$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';

include 'condefs.php';
include_once 'include/lib.php';
include_once 'include/imexport.php';
require_once 'include/create_session.php';
require_once 'class/importmanager.php';

define( 'ITEMS_PER_PAGE', 10 );

xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

if ( !$xoopsUser ) {
    redirect_header( XOOPS_URL.'/index.php',3,_MD_XOONIPS_ITEM_FORBIDDEN);
    exit();
}

$uid = $_SESSION['xoopsUserId'];

//Uncertified user can't access(except XOOPS administrator).
if( !$xoopsUser->isAdmin( $xoopsModule->getVar('mid') )
    && !xnp_is_activated( $xnpsid, $uid ) ){
    redirect_header( XOOPS_URL.'/index.php', 3, _MD_XOONIPS_MODERATOR_NOT_ACTIVATED);
    exit();
}

//User(Not Moderater) can't access this page(except XOOPS administrator).
$private_import_enabled = "";
if( !$xoopsUser->isAdmin( $xoopsModule->getVar( 'mid' ) )
	&& !xnp_is_moderator( $xnpsid, $uid ) ) {
	// If XooNIps user is forbidden to import files, returns error.
	if( xnp_get_config_value( 'private_import_enabled', $private_import_enabled ) != RES_OK
		|| $private_import_enabled != 'on' ){
		redirect_header( XOOPS_URL.'/index.php', 3, _MD_XOONIPS_MODERATOR_SHULD_BE_MODERATOR );
		exit(  );
	}
}

foreach( array( 'op' => '', // undefined | upload | import
                'page' => 1, // num of page for listing conflict items
                'import_ids' => array(), // array of id of import items. 
                'index_id' => '',
                'error_check_only' => false, 
                'logging' => false, // must be true if log is shown
                'original_filename' => '', //original name of uploaded file
                'remotefile' => '', //filepath of remote file
                'uploadfile' => '',
                'filetype' => '', //'localfile' or 'remotefile'
                'import_as_new' => false, // 'on' if we regard import conflict item as new item
                'xoonipsCheckedXID' => '',
                'certify_auto' => false, // must be true to automatically certify items that are registered to /Public indexes.
                ) as $k => $v ){
    if( isset( $_POST[ $k ] ) ){
        $$k = $_POST[ $k ];
    }else{
        if( isset( $v ) ){
            $$k = $v;
        }else{
            $$k = null;
        }
    }
}

require_once 'include/unzip.php';

$config_handler =& xoops_gethandler('config');
$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
if( $op == 'upload' 
    && ( $filetype == 'localfile' && $_FILES['zipfile']['name'] != '' && $_FILES['zipfile']['size'] > 0
         || $filetype == 'remotefile' && !empty( $remotefile ) ) ){
    // 
    // - check that selected indexes(xoonipsCheckedXID) has at least one private index
    // - if index.xml is found in ziped files create index-tree structure and exit.
    // - extract and parse zip file
    // - parse extracted XML files(warn and exit if no items found)
    // - find conflict items 
    // - do only above if error_check_only is 'on' or some error has occured
    // - we show conflict items and require user to choose items of these.
    // 
    
    // 
    // Create XooNIpsImportManager object
    // 
    $mgr = new XooNIpsImportManager();
    
    // 
    // check that selected indexes(xoonipsCheckedXID) has at least one private index
    // 
    $indexobj = null;
    if( strlen( trim( $xoonipsCheckedXID ) ) > 0 ){
        foreach( explode( ',', $xoonipsCheckedXID ) as $index_id ){
            $indexobj = new XooNIpsIndex();
            if( !$indexobj -> get( $index_id ) ) continue;
            if( $indexobj -> getVar( 'open_level' ) == OL_PRIVATE ) break;
        }
    }
    if( !is_null( $indexobj ) && $indexobj -> getVar( 'open_level' ) != OL_PRIVATE ){
        // 
        // No private indexes are selected.
        // Add '/Private' to $xoonipsCheckedXID;
        // 
        $sql = 'SELECT private_index_id FROM ' . $xoopsDB -> prefix( 'xoonips_users' ) . ' WHERE uid=' . $uid;
        $result = $xoopsDB -> query( $sql );
        if( !$result ){
            $mgr -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $mgr -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
        }else if( $xoopsDB -> getRowsNum( $result ) > 0 ){
            list( $private_index_id ) = $xoopsDB->fetchRow( $result );
            if( empty( $xoonipsCheckedXID ) ){
                $xoonipsCheckedXID = $private_index_id;
            }else{
                $xoonipsCheckedXID .= "," . $private_index_id;
            }
        }
    }
    
    // 
    // set original file name
    // 
    if( $filetype == 'localfile' )
        $mgr -> setOriginalFilename( $_FILES['zipfile']['name'] );
    else
        $mgr -> setOriginalFilename( $remotefile );
    
    
    $itemtypes = array();
    $tmp = array();
    if( xnp_get_item_types( $tmp ) != RES_OK ){
        redirect_header(XOOPS_URL.'/index.php', 3, "ERROR xnp_get_item_types [AbstractLayer]".xnp_get_last_error_string());
        break;
    }else{
        foreach( $tmp as $i){
            $itemtypes[$i['item_type_id']]=$i;
        }
        foreach( $tmp as $i){
            $itemtypes[$i['name']]=$i;
        }
    }
    
    if( $private_import_enabled == 'on'
        && !isset( $_SESSION['xoonips_old_uid'] ) ){
        // selected index_id is writable or not ?
        // XooNIps user import files:The index outside of Private area is excluded.
        $removed_xid = array(); // array of index_ids of not private indexes.
        $xids = array(); // array of index_ids of private indexes.
        if( $xoonipsCheckedXID != '' ){
            foreach( explode( ",", $xoonipsCheckedXID ) as $xid ){
                if( !xnp_get_index_permission( $xnpsid, $xid, OP_REGISTER ) ){
                    $removed_xid[] = $xid;
                }else{
                    $xids[] = $xid;
                }
            }
        }
        $xoonipsCheckedXID = implode( ",", $xids );
        if( count( $removed_xid ) > 0 ){
            include XOOPS_ROOT_PATH.'/header.php';
            $errmsg = "<font color=\"#FF0000\">"._MD_XOONIPS_IMPORT_INDEX_CANNOT_WRITE;
            foreach( $removed_xid as $xid ){
                $errmsg = $errmsg."<br />\n".xnpGetIndexPathString( $xnpsid, $xid );
            }
            $errmsg = $errmsg."</font>";
            echo $errmsg;
            include XOOPS_ROOT_PATH.'/footer.php';
            exit();
        }
    }
    
    //set path to import file 
    if( $filetype == 'localfile' ){
        $info = pathinfo( $_FILES['zipfile']['tmp_name'] );
        $uploadfile = tempnam( $info['dirname'], 'XNP' );
        unlink( $uploadfile );

        if( !move_uploaded_file($_FILES['zipfile']['tmp_name'], $uploadfile) ){
            die( "Possible file upload attack!\n" );
        }
    }else{
        $uploadfile = $remotefile;
    }
    
    // 
    // Import index tree if uploaded file has index.xml.
    // In this case, other files are ignored.
    // 
    $hdl = @fopen( $uploadfile, 'rb' );
    if( !$hdl ){
        redirect_header( 'import.php', 3, _MD_XOONIPS_IMPORT_FILE_NOT_FOUND );
        exit();
    }
    $entries = unzip_all_entries( $hdl );
    foreach( $entries as $entry ){
        if( strtolower( $entry[ 'filename' ] ) == 'index.xml' ){
            $error = false; //true if error has occured.

            // 
            // start transaction
            // 
            $xoopsDB -> query( 'START TRANSACTION' );
            

            // 
            // check index tree structures
            // and show the structures
            // 
            $xml = unzip_read_data( $entry );
            $indexes = array();
            xnpImportIndexCheck( $xml, $indexes );//var_dump($indexes);exit();
                
            // To construct tree structure from given indexes by $indexes
            $c2p = array( );//associative array (child ID -> parent ID)
            $p2c = array( );//associative array (parent ID -> array of child ID)
            $index_by_id = array(); // $index_by_id[ index_id ] => index array;
            foreach( $indexes as $i ){
                if( empty( $i ) ) continue;
                $c2p[ $i['index_id'] ] = $i['parent_id'];
                if( !isset( $p2c[ $i['parent_id'] ] ) ) $p2c[ $i['parent_id'] ] = array();
                $p2c[ $i['parent_id'] ][] = $i['index_id'];
                $index_by_id[ $i['index_id'] ] = $i;
            }
                
            $str_indexes = '';
            $error = false; //true if cyclic reference
            foreach( $index_by_id as $index_id => $index ){
                if( $index[ 'index_id' ] == $index[ 'parent_id' ] ){
                    // 
                    // cyclic reference detected( refers itself )
                    // 
                    $error = true;
                    continue;
                }
                if( isset( $p2c[ $index[ 'index_id' ] ] ) ) continue;
                
                $visited = array( $index[ 'index_id' ] );//index_id already visited(to detect cyclic reference)
                
                // $index is not parent of all indexes
                $path = array();
                array_push( $path, $index[ 'titles' ][0] );
                while( isset( $index_by_id[ $index[ 'parent_id' ] ] ) ){
                    $parent = $index_by_id[ $index[ 'parent_id' ] ];
                    if( in_array( $parent[ 'index_id' ], $visited ) ){
                        // 
                        // cyclic reference detecetd( $index refers already visited index )
                        // 
                        $error = true;
                        break;
                    }
                    $visited[] = $parent[ 'index_id' ];
                    array_push( $path, encodeClient2Server( $parent[ 'titles' ][0] ) );
                    $index = $parent;
                }
                $str_indexes .= implode( '/', array_reverse( $path ) ) . "<br />\n";
            }

            include XOOPS_ROOT_PATH.'/header.php';
            if( $error ){
                $submit = _MD_XOONIPS_ITEM_BACK_BUTTON_LABEL;
                $message = _MD_XOONIPS_IMPORT_CIRCULAR_INDEX;
                echo <<<EOT
                    <p>
                    $message <br />
                    </p>
                    <form id='form_submit_back' action='import.php' method='post'>
                    <input id='submit_back' type='submit' value='$submit' />
                    </form>
EOT;
            }else if( $error_check_only == 'on' ){
                $submit = _MD_XOONIPS_ITEM_BACK_BUTTON_LABEL;
                $message = _MD_XOONIPS_IMPORT_ERROR_CKECK_DONE . "<br />\n" . _MD_XOONIPS_IMPORT_FOLLOWING_INDEX_TEST;
                echo <<<EOT
                    <p>
                    $message
                    </p>
                    <p>
                    $str_indexes
                    </p>
                    <form id='form_submit_back' action='import.php' method='post'>
                    <input id='submit_back' type='submit' value='$submit' />
                    </form>
EOT;
            }else{
                $submit = _MD_XOONIPS_IMPORT_UPLOAD_SUBMIT;
                $message = _MD_XOONIPS_IMPORT_FOLLOWING_INDEX;
                echo <<<EOT
                    <p>
                    $message
                    </p>
                    <p>
                    $str_indexes
                    </p>
                    <form id='form_import_index' action='import.php' method='post'>
                    <input type='hidden' name='op' value='import_index' />
                    <input type='hidden' name='uploadfile' value='$uploadfile' />
                    <input type='hidden' name='xoonipsCheckedXID' value='$xoonipsCheckedXID' />
                    <input id='submit_import_index' type='submit' value='$submit' />
                    </form>
EOT;
            }
            include XOOPS_ROOT_PATH.'/footer.php';
            
            fclose( $hdl );
            exit();
        }
    }
    fclose( $hdl );
    
    // 
    // extract zipped files and parse the xml files
    // 
    $importer_uid = $xoopsUser -> getVar( 'uid' ); // for parseFile(...)
    $base_index_id = empty( $xoonipsCheckedXID ) ? array() : explode( ",", $xoonipsCheckedXID );
    $mgr -> parseFile( $uploadfile, $importer_uid, $base_index_id );
    
    // 
    // warn no items found if no items parsed
    // 
    if( count( $mgr -> getItems() ) == 0 && count( $mgr -> getErrors() ) == 0 ){
        include XOOPS_ROOT_PATH.'/header.php';
        echo _MD_XOONIPS_IMPORT_NO_ITEMS_ARE_FOUND . "<br />";
        echo "<form id='form_submit_back' action='import.php' method='post'><input id='submit_back' type='submit' value='" . _MD_XOONIPS_ITEM_BACK_BUTTON_LABEL . "' /></form>\n";
        $mgr -> cleanFiles();
        include XOOPS_ROOT_PATH.'/footer.php';
        exit();
    }
    
    // 
    // confliction test
    // 
    if( !$mgr -> checkConflict() ){
        var_dump( $mgr );
        die( 'error in cheking conflict' );
    }
    // 
    // show log and exit if error_check_only is selected or some error has occured
    // 
    if( $error_check_only == 'on' || count( $mgr -> getErrors() ) > 0 ){
        // 
        // - print out error log form( error log and button to return top page of import )
        // - remove extracted files and directories using cleanFiles().
        // - exit this file
        // 
        include XOOPS_ROOT_PATH.'/header.php';
        
        if( $error_check_only == 'on' ){
            echo _MD_XOONIPS_IMPORT_ERROR_CKECK_DONE . "<br />";
        }
        $error = false; //true if error has occured
        $error = ( count( $mgr -> getErrors() ) > 0 );
        if( $error ){
            echo _MD_XOONIPS_IMPORT_ERROR . "<br />";
        }else{
            echo _MD_XOONIPS_IMPORT_NO_ERROR . "<br />";
        }
        echo _MD_XOONIPS_IMPORT_REVIEW_LOG . "<br />";
        print_error_log_form( $mgr );
        echo "<form id='form_submit_back' action='import.php' method='post'><input id='submit_back' type='submit' value='" . _MD_XOONIPS_ITEM_BACK_BUTTON_LABEL . "' /></form>\n";
        $mgr -> cleanFiles();
        include XOOPS_ROOT_PATH.'/footer.php';
        exit();
    }
    
    
    // 
    // serialize XooNIpsImportManager and store it to session
    // 
    $_SESSION[ 'XooNIpsImportManager' ] = serializeToFile( $mgr );
    
    // 
    // no conflict items
    // 
    // - show message
    // - show a button to import
    // - exit
    // 
    $conflict = $mgr -> getConflict();
    if( count( $conflict ) == 0 || $import_as_new == 'on' ){
        // 
        // no conflict then import all items.
        // 
        include XOOPS_ROOT_PATH.'/header.php';
        echo _MD_XOONIPS_IMPORT_NO_ERROR;
        echo _MD_XOONIPS_IMPORT_READY;
        echo "<form id='form_import' action='import.php' method='post'>\n";
        echo "<input type='hidden' name='op' value='import' />\n";
        if( $logging == 'on' ) echo "<input type='hidden' name='logging' value='on' />\n";
        if( $certify_auto == 'on' ) echo "<input type='hidden' name='certify_auto' value='on' />\n";
        if( $import_as_new == 'on' ) echo "<input type='hidden' name='import_as_new' value='on' />\n";
        foreach( $mgr -> getItems() as $item ){
            echo "<input type='hidden' name='import_ids[]' value='" . $item -> getVar( 'pseudo_id' ) . "' />\n";
        }
        echo "<input id='submit_import' type='submit' value='" . _MD_XOONIPS_IMPORT_TITLE . "' />\n";
        echo "</form>\n";
        include XOOPS_ROOT_PATH.'/footer.php';
        exit();
    }else{
        // go to next process
        $op = 'resolve_conflict';
    }
}else if( $op == 'upload' ){
    redirect_header( 'import.php', 3, _MD_XOONIPS_IMPORT_FILE_NOT_SPECIFIED );
}

if( $op == 'resolve_conflict' ){
    // 
    // unserialize XooNIpsImportManager
    // 
    if( isset( $_SESSION[ 'XooNIpsImportManager' ] ) ){
        include_itemtype_definition();
        $mgr = unserializeFromFile( $_SESSION[ 'XooNIpsImportManager' ] );
    }else{
        var_dump( $_SESSION );
        die( 'XooNIpsImportManager is not found in the session' );
    }
    // 
    // show conflict items
    // 
    $member_handler =& xoops_gethandler('member');
    $id2item = array();
    $items = $mgr -> getItems();
    foreach( $items as $idx => $item ){ $id2item[ $item -> getVar( 'pseudo_id' ) ] =& $items[ $idx ]; }
    // 
    // set information of conflict items to $conflict_items[$pseudo_id]
    // 
    $conflict = $mgr -> getConflict();
    $conflict_items = array();
    foreach( array_slice( array_keys( $conflict ), ITEMS_PER_PAGE * ( $page - 1 ), ITEMS_PER_PAGE ) as $pseudo_id ){
        $val = $conflict[ $pseudo_id ];

        $member = $member_handler -> getUser( $id2item[ $pseudo_id ] -> getVar( 'uid' ) );
        $conflict_items[ $pseudo_id ]
            = array( 'import_item' => array( 'pseudo_id' => $pseudo_id,
                                             'checked' => in_array( $pseudo_id, $import_ids ) ? 'checked' : '',
                                             'titles' => $id2item[ $pseudo_id ] -> getVar( 'titles' ),
                                             'contributor' => $member -> getVar( 'uname' ) ),
//                                             'contributor' => $member_handler -> getUser( $id2item[ $pseudo_id ] -> getVar( 'uid' ) ) -> getVar( 'uname' ) ),// import item
                     'conflict_updatable_item'   => array(), // exists    items what importing item conflict with in same indexes.
                     'conflict_unupdatable_item' => array(), // exists    items what importing item conflict with in other indexes.
                     'conflict_importing_item'   => array()  // importing items what importing item conflict with 
                );
        foreach( $val[ 'import_items' ] as $item_id ){
            $item = $id2item[ $item_id ];
            $member = $member_handler -> getUser( $id2item[ $item_id ] -> getVar( 'uid' ) );
            $index_strs = array();
            foreach( $item -> getVar('indexes') as $index_id )
                $index_strs[] = $item -> index_id2index_str( $index_id, true );
            $conflict_items[ $pseudo_id ][ 'conflict_importing_item' ][]
                = array( 'titles' => $item -> getVar( 'titles' ),
                         'contributor' => $member -> getVar( 'uname' ),
                         'index_strs' => $index_strs );
        }
        foreach( $val[ 'exists_items' ] as $item_id ){
            $item = new XooNIpsItem();
            if( !$item -> get( $item_id ) ){
                die( 'failed in XooNIpsItem::get' );
            }
            $member = $member_handler -> getUser( $item -> getVar( 'uid' ) );
            $is_indexes_conflict = in_array( $item_id, $val['exists_updatable_items'] );
            $index_strs = array();
            foreach( $item -> getVar('indexes') as $index_id )
                $index_strs[] = $item -> index_id2index_str( $index_id, true );
            $conflict_items[ $pseudo_id ][ $is_indexes_conflict ? 'conflict_updatable_item' : 'conflict_unupdatable_item' ][]
                = array( 'titles' => $item -> getVar( 'titles' ),
                         'contributor' => $member -> getVar( 'uname' ),
                         'index_strs' => $index_strs );
        }
    }
    
    // 
    // assigning item pseudo ID that to be imported to $import_ids array
    // $import_ids = (all item in given file) - (confilct updatable item) 
    //               or ($import_ids given by POST) - (pseudo ID(s) that are key of $conflict_items and updatable)
    // 
    if( empty( $import_ids ) ){
        $import_ids = array();
        foreach( array_keys( $id2item ) as $id ){
            if( !isset($conflict[$id]) || empty($conflict[$id]['exists_updatable_items']) ) $import_ids[] = $id;
        }
    }else{
        // 
        // remove displayed item ids from $import_ids(Items that is displayed is in $conflict_items).
        // 
        $newval = array();
        $conflict_ids = array_keys( $conflict_items );
        foreach( $import_ids as $id ){
            if( !in_array( $id, $conflict_ids ) || !isset($conflict[$id]) || empty($conflict[$id]['exists_updatable_items']) ) $newval[] = $id;
        }
        $import_ids = $newval;
    }
    
    include XOOPS_ROOT_PATH.'/header.php';
    $xoopsOption['template_main'] = 'xoonips_conflict_items.html';
    $xoopsTpl->assign('import_ids', $import_ids );
    $xoopsTpl->assign('conflict_items', $conflict_items );
    $xoopsTpl->assign('page', $page );
    $xoopsTpl->assign('page_max', ceil( count( $mgr -> getConflict() ) / ITEMS_PER_PAGE ) );
    $xoopsTpl->assign('num_of_all_items', count( $mgr -> getConflict() ) );
    if( $logging == 'on' ) $xoopsTpl->assign('logging', 'on' );
    if( $certify_auto == 'on' ) $xoopsTpl->assign('certify_auto', 'on' );
    include XOOPS_ROOT_PATH.'/footer.php';


    
    // 
    // serialize XooNIpsImportManager
    // 
    // no need to sotre $mgr to session because of no modificati
    //$_SESSION[ 'XooNIpsImportManager' ] = serializeToFile( $mgr );
    
    exit();
}

//importing index
if( $op == 'import_index' ){
    $hdl = @fopen( $uploadfile, 'rb' );
    if( !$hdl ){
        redirect_header( 'import.php', 3, _MD_XOONIPS_IMPORT_FILE_NOT_FOUND );
        exit();
    }

    include XOOPS_ROOT_PATH.'/header.php';
    
    // 
    // start transaction
    // 
    $xoopsDB -> query( 'START TRANSACTION' );
    
    $error = false; //true if error 
    $entries = unzip_all_entries( $hdl );
    $created_xids = array();
    foreach( $entries as $entry ){
        // 
        // import index tree and exit.
        // 
        include XOOPS_ROOT_PATH.'/header.php';
        $xml = unzip_read_data( $entry );
        foreach( explode( ',', $xoonipsCheckedXID ) as $index_id ){
            if( !ctype_digit( $index_id ) ) continue;
            $id_table = array();
            if( xnpImportIndex( $xml, $index_id, $id_table, $error_message ) ){
                $created_xids = array_merge( $created_xids, $id_table );
            }else{
                echo "ERROR $error_message";
                $error = true;
            }
        }
    }
    if( $error ){
        // 
        // rollback
        // 
        $xoopsDB -> query( 'ROLLBACK' );

        echo "<P>" . _MD_XOONIPS_IMPORT_INDEX_TREE_FAILED . "</P>";

    }else{
        // 
        // commit
        // 
        $xoopsDB -> query( 'COMMIT' );

        echo _MD_XOONIPS_IMPORT_INDEX_TREE_CREATED;

        $indexobj = new XooNIpsIndex();
        echo "<P>\n";
        foreach( $created_xids as $index_id ){
            $indexobj -> get( $index_id );
            $path_array = $indexobj -> getIndexPathArray( );
            if( $indexobj -> getVar( 'open_level' ) == OL_PRIVATE ){
                // 
                // replace /<uname> -> /Private
                // 
                $path_array[ 0 ] = 'Private';
            }
            echo "<a href='" . XOOPS_URL . '/modules/xoonips/listitem.php?index_id=' . $index_id . "'>"
                . '/' . implode( '/', $path_array ) . "</a><BR />\n";
        }
        echo "</P>\n";
    }
    include XOOPS_ROOT_PATH.'/footer.php';

    exit();
}

//importing items
if( $op == 'import' ){
    // 
    // set the time that import has started.
    // 
    $_SESSION['import_begin_time'] = time();

    // 
    // unserialize XooNIpsImportManager
    // 
    if( isset( $_SESSION[ 'XooNIpsImportManager' ] ) ){
        include_itemtype_definition();
        $mgr = unserializeFromFile( $_SESSION[ 'XooNIpsImportManager' ] );
    }else{
        var_dump( $_SESSION );
        die( 'XooNIpsImportManager is not found in the session' );
    }

    // 
    // get uid of importer to $uid
    // 
    global $xoopsUser;
    $uid = is_null( $mgr -> importer_uid ) ? $xoopsUser -> getVar( 'uid' ) : $mgr -> importer_uid;

    // 
    // item_limit check
    // 
    $item_ids = array();
    if( xnp_get_private_item_id( $xnpsid, $uid, $item_ids ) != RES_OK ){
        redirect_header(XOOPS_URL.'/modules/xoonips/import.php', 3, "ERROR xnp_get_private_item_id [AbstractLayer]".xnp_get_last_error_string());
        break;
    }
    $account = array();
    if( xnp_get_account( $xnpsid, $uid, $account ) != RES_OK ){
        redirect_header(XOOPS_URL.'/modules/xoonips/import.php', 3, "ERROR xnp_get_account [AbstractLayer]".xnp_get_last_error_string());
        break;
    }
    if( count( $import_ids ) + count( $item_ids ) > $account['item_number_limit'] ){
        include XOOPS_ROOT_PATH.'/header.php';
        echo _MD_XOONIPS_IMPORT_ITEM_NUMBER_LIMIT_OVER_FLOW;
        echo "<p>\n<a href=\"".XOOPS_URL.'/modules/xoonips/import.php'."\">"._MD_XOONIPS_ITEM_BACK_BUTTON_LABEL."</a></p>\n";
        include XOOPS_ROOT_PATH.'/footer.php';
        exit();
    }
    
    // 
    // start transaction
    // 
    $xoopsDB -> query( 'START TRANSACTION' );
    
    // 
    // import item
    // 
    $conflict_items = $mgr -> getConflict();
    $imported_items = array();// array of array( imported item object, boolean(true if inserted, false if updated) )
    $items = array();// array of items after imported
    $error = false;// true if error has occured in importing
    foreach( $mgr -> getItems( ) as $item ){
        // 
        // import items like following
        // 
        // - insert all items whether or no conflict if checked 'import_as_new'
        // - if not checked 'import_as_new' do following
        // - update if item has only one conflict item
        // - insert if item has no conflict items
        // 
        
        // 
        // import item
        // 
        if( $import_as_new == 'on' ){
            // 
            // import as new item
            // 
            if( $item -> import( $certify_auto == 'on' ) ){
                $imported_items[] = array( $item -> xoopsClone(), true );
            }else{
                $error = true;
            }
            $items[] = $item;
        }else if( in_array( $item -> getVar( 'pseudo_id' ), $import_ids ) ){
            if( isset( $conflict_items[ $item -> getVar( 'pseudo_id' ) ] )
                && count( $conflict_items[ $item -> getVar( 'pseudo_id' ) ][ 'exists_updatable_items' ] ) > 0 ){
                // 
                // update exisis item if selected item conflict with exists items.
                // 
                foreach( $conflict_items[ $item -> getVar( 'pseudo_id' ) ][ 'exists_updatable_items' ] as $i ){
                    // 
                    // create item object of import item
                    // 
                    $conflict_item = new XooNIpsItem();
                    if( !$conflict_item -> get( $i ) ){
                        $error = true;
                        continue;
                    }
                    
                    // 
                    // don't update if conflict item has not been registered to indexes that the item will be imported to
                    // 
                    if( count( array_intersect( $item -> getVar( 'indexes' ), // indexes that import item will be imported to.
                                                $conflict_item -> getVar( 'indexes' ) // indexes that conflict item has been registered to
                        ) ) == 0 ){
                        continue; // no need to update this conflict item(id=$i)
                    }
                    
                    
                    //
                    // update if item has only one conflict item.
                    // set item ID of conflict item to $item and unset new flag.
                    // 
                    $item -> setVar( 'item_id', $i );
                    $item -> unsetNew();
                    
                    if( $item -> import( $certify_auto == 'on' ) ){
                        $imported_items[] = array( $item -> xoopsClone(), false );
                    }else{
                        $error = true;
                    }
                    $items[] = $item -> xoopsClone();
                }
            }else{
                // 
                // import not conflict items
                // 
                if( $item -> import( $certify_auto == 'on' ) ){
                    $imported_items[] = array( $item -> xoopsClone(), true );
                }else{
                    $error = true;
                }
                $items[] = $item;
            }
        }else{
            $items[] = $item;
            continue; //skip unselected items
        }
    }
    
    // create conversion table from pseudo_id to item_id 
    $pseudo_id2item_id = array();
    foreach ( $imported_items as $ar )
        $pseudo_id2item_id[ $ar[0] -> getVar('pseudo_id') ] = $ar[0] -> getVar('item_id');
    
    // fix related_to
    for ( $i = 0; $i < count($items); $i++ ){
        // related_to pseudo_id -> item_id conversion
        $related_to = array();
        if ( !isset($pseudo_id2item_id[$items[$i]->getVar('pseudo_id')]) )
            continue; // not imported
        foreach ( $items[$i] -> getVar('related_to') as $pseudo_id )
            $related_to[] = $pseudo_id2item_id[ $pseudo_id ];
        if ( empty( $related_to ) )
            continue; // no need to fix
        
        // restore related_to and update
        $items[$i] -> setVar( 'related_to', serialize($related_to) );
        $items[$i] -> unsetNew();
        if ( false == $items[$i] -> insert() )
            $error = true;
    }
    
    // set items that are imported
    $mgr -> setItems( $items );
    
    if( $error ){
        // 
        // remove entries of xoonips_search_text
        // 
        $item_ids = array();
        foreach( $items as $i ){
            $id = $i -> getVar( 'item_id' );
            if( !empty( $id ) ){
                $item_ids[] = $i -> getVar( 'item_id' );
            }
        }
        if( count( $item_ids ) > 0 ){
            $file_table = $xoopsDB -> prefix( 'xoonips_file' );
            $search_table = $xoopsDB -> prefix( 'xoonips_search_text' );
            $sql = "select file_id from $file_table where item_id in ( " . implode( ', ', $item_ids ) . " )";
            $result = $xoopsDB -> query( $sql );
            if( !$result ){
                $mgr -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $mgr -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
            }else if( $xoopsDB -> getRowsNum( $result ) ){
                $file_ids = array();
                while( list( $file_id ) = $xoopsDB->fetchRow( $result ) ){
                    $file_ids[] = $file_id;
                }
                $sql = "delete from $search_table where file_id in ( " . implode( ', ', $file_ids ) . " )";
                $result = $xoopsDB -> query( $sql );
                if( !$result ){
                    $mgr -> setErrors( E_XOONIPS_DB_QUERY, $xoopsDB -> error() . $mgr -> getErrorAt( __LINE__, __FILE__, __FUNCTION__ ) );
                }
            }
        }
        
        // 
        // rollback
        // 
        $xoopsDB -> query( 'ROLLBACK' );
    }else{
        // 
        // commit
        // 
        $xoopsDB -> query( 'COMMIT' );
    }
    $mgr -> cleanFiles();
    
    // 
    // set the time that import has finished.
    // 
    $_SESSION['import_finish_time'] = time();
    
    // 
    // show result
    // 
    include XOOPS_ROOT_PATH.'/header.php';
    if( $error ){
        echo _MD_XOONIPS_IMPORT_ERROR;
        echo _MD_XOONIPS_IMPORT_REVIEW_LOG;
        print_error_log_form( $mgr, ( $import_as_new == 'on' ? null : $import_ids ) );
    }else{
        echo _MD_XOONIPS_IMPORT_IMPORT_SUCCESSFULLY;
        if( $logging ){
            echo _MD_XOONIPS_IMPORT_REVIEW_LOG;
            // 
            // print log about all items if $import_as_new is 'on' else print only items of $import_ids
            // 
            print_error_log_form( $mgr, ( $import_as_new == 'on' ? null : $import_ids ) );
        }
    }
    echo "<form id='form_submit_back' action='import.php' method='POST'><input id='submit_back' type='submit' value='" . _MD_XOONIPS_ITEM_BACK_BUTTON_LABEL . "' /></form>\n";
    include XOOPS_ROOT_PATH.'/footer.php';
    
    // 
    // remove XooNIpsImportManager from session
    // 
    unlink( $_SESSION[ 'XooNIpsImportManager' ] );
    unset( $_SESSION[ 'XooNIpsImportManager' ] );

    exit();
}


$xoonipsTreeCheckBox = true;
$xoonipsHideBinders = true;
$xoonipsEditIndex = true; //only import into editable index
//$xoonipsCheckPrivate = 'submit_import_upload'; // id of a button that state(disable/enable) is controled by selection of private index checkbox.
$xoonipsEditPublic = true; //

include XOOPS_ROOT_PATH.'/header.php';
include_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";
?>
<script type="text/javascript" 	src="treelib.js">
</script>
<script type="text/javascript">
<!--
function getCheckedIndexes( form1 ){
	xoonipsGetDocTreeView2();
	xoonipsSaveTreeState2(xoonipsDocTreeView2);
	form1.xoonipsCheckedXID.value = xoonipsCheckState2;
	return true;
}
/**
 * set enable/disable to the specified by given id
 * 
 * @param form of target component
 * @param id of target comopnent
 * @param true if set enabled.
 * 
 */
function setEnabled( id, enabled )
{
    var comp = document.getElementById( id );
    if ( comp != null ){
        comp.disabled = !enabled;
    }
}
//-->
</script>

<p>
<?php echo _MD_XOONIPS_IMPORT_PANKUZU_IMPORT; ?>
<?php echo _MI_XOONIPS_ACCOUNT_PANKUZU_SEPARATOR; ?>
<?php echo _MD_XOONIPS_IMPORT_PANKUZU_UPLOAD_FILE; ?>
</p>

<p>
<h3><?php echo _MD_XOONIPS_IMPORT_TITLE; ?></h3>
</p>

<form id='form_import_upload' enctype="multipart/form-data" action="import.php" method="post" onSubmit="return getCheckedIndexes(this);">
<input type="hidden" name="MAX_FILE_SIZE" value="<?php echo return_bytes( ini_get( 'upload_max_filesize' ) ); ?>" />
<input type='hidden' name='op' value='upload' />
<input type='hidden' name='xoonipsCheckedXID' value='<?php echo $xoonipsCheckedXID; ?>' />
<?php
    if( isset( $_FILES['zipfile'] ) && $_FILES['zipfile']['error'] != UPLOAD_ERR_OK ){
        echo "<font color='#ff0000'>".return_upload_file_error( $_FILES['zipfile']['error'] )."</font>\n";
    }
?> 
<table class='outer'>
 <tr>
  <th colspan='2'><?php echo _MD_XOONIPS_IMPORT_TITLE ?></th>
 </tr>
 <tr>
  <td class='odd' nowrap>
   <?php echo _MD_XOONIPS_IMPORT_FILE; ?>
   <?php
      if( !array_key_exists( 'zipfile', $_FILES )
          || !array_key_exists( 'name', $_FILES['zipfile'] )
          || $_FILES['zipfile']['tmp_name'] == '' 
          || $_FILES['zipfile']['size'] == 0 ){ print "<font color='#ff0000'>"._MD_XOONIPS_IMPORT_REQUIRED."</font>"; }
          ?>
   <br />
  </td>
  <td class='odd' width='70%'>
<?php
/*
   if( isset( $_SESSION[ 'xoonips_old_uid' ] ) ){
       $member_handler =& xoops_gethandler('member');
       $old_user = $member_handler -> getUser( $_SESSION[ 'xoonips_old_uid' ] );
   }
*/
   if( !isset( $_SESSION[ 'xoonips_old_uid' ] ) && !$xoopsUser -> isAdmin() ){
       // $xoopsUser is not XOOPS Admin && not su mode
?>
   <input type='hidden' name='filetype' value='localfile' />
   <input id='file_zipfile' name="zipfile" type="file" size='40' /><br />
<?php
   }else if( isset( $_SESSION[ 'xoonips_old_uid' ] ) || $xoopsUser -> isAdmin() ){
   // 
   // show the form of remote file path only for XOOPS administrator
   // ($xoopsUser is XOOPS Admin or su mode)
   // 
?>
   <input id='radio_localfile' type='radio' name='filetype' value='localfile' onclick='setEnabled("file_zipfile", true); setEnabled("text_remotefile", false);' checked /><?php echo _MD_XOONIPS_IMPORT_LOCAL_FILE; ?><br />
   <input id='file_zipfile' name="zipfile" type="file" size='40' /><br />
   <?php echo "("._MD_XOONIPS_UPLOAD_MAX_FILESIZE.ini_get( 'upload_max_filesize' ).")"; ?><br /><br />
   <input id='radio_remotefile' type='radio' name='filetype' value='remotefile' onclick='setEnabled("file_zipfile", false); setEnabled("text_remotefile", true);' /><?php echo _MD_XOONIPS_IMPORT_REMOTE_FILE; ?><br />
   <input id='text_remotefile' name="remotefile" type="text" size='40' disabled />(ex /path/to/import/file)<br /></td></tr>
 <tr>
  <td class='even' nowrap>
   <?php echo _MD_XOONIPS_IMPORT_CERTIFY_AUTO; ?>
  </td>
  <td class='odd' width='70%'>
   <input id='check_certify_auto' type='checkbox' name='certify_auto' />
  </td>
 </tr>
<?php
}
?>
 <tr>
  <td class='even' nowrap>
   <?php echo _MD_XOONIPS_IMPORT_INDEX; ?>
        <?php /* if( $xoonipsCheckedXID == '' ){ print "<font color='#ff0000'>"._MD_XOONIPS_IMPORT_REQUIRED."</font>"; }*/ ?>
  </td>
  <td class='even' width='70%'>
   <?php echo _MD_XOONIPS_IMPORT_INDEX_TEXT; ?>
  </td>
 </tr>
 <tr>
  <td class='odd' nowrap>
   <?php echo _MD_XOONIPS_IMPORT_ERROR_CHECK_ONLY; ?>
  </td>
  <td class='odd' width='70%'>
   <input id='check_error_ckeck_only' type='checkbox' name='error_check_only' />
  </td>
 </tr>
 <tr>
  <td class='even' nowrap>
   <?php echo _MD_XOONIPS_IMPORT_LOGGING; ?>
  </td>
  <td class='odd' width='70%'>
   <input id='check_logging' type='checkbox' name='logging' checked />
  </td>
 </tr>
 <tr>
  <td class='even' colspan='2'>
   <input id='submit_import_upload' type='submit' value='<?php echo _MD_XOONIPS_IMPORT_UPLOAD_SUBMIT; ?>' />
<?php /*   <span id='message_label' style='display: none; color: red;'><?php echo _MD_XOONIPS_ITEM_SELECT_PRIVATE_INDEX; ?></span>*/ ?>
  </td>
 </tr>
</table>

</form>

<?php  
include XOOPS_ROOT_PATH.'/footer.php';


function print_error_log_form( $mgr, $import_ids = null ){
    global $xoopsUser;

    $html = "<form>\n<textarea id='textarea_import_log' readonly cols=\"80\" rows=\"30\">\n";

    if( !is_object( $mgr ) ){
        $html .= "bad argument";
    }else{
        $html .= "[version]\n";
        $html .= "1.00\n";
        $html .= "\n";
     
        $html .= "[begin]\n";
        $html .= ( isset( $_SESSION['import_begin_time'] ) ? date( "Y-m-d H:i:s", $_SESSION['import_begin_time'] ) : 'unknown' ) . "\n";
        $html .= "\n";
     
        $html .= "[finish]\n";
        $html .= ( isset( $_SESSION['import_finish_time'] ) ? date( "Y-m-d H:i:s", $_SESSION['import_finish_time'] ) : 'unknown' ) . "\n";
        $html .= "\n";
     
        $html .= "[executor]\n";
        $html .= $xoopsUser -> getVar( 'uname' ) . "\n";
        $html .= "\n";
     
        $html .= "[number_of_items]\n";
        $html .= count( is_null( $import_ids ) ? $mgr -> getItems() : $import_ids ) . "\n";
        $html .= "\n";
        
        $html .= "[filename]\n";
        $html .= $mgr -> getOriginalFilename() . "\n";
        $html .= "\n";
        
        $conflict = $mgr -> getConflict();
        $items = $mgr -> getItems();
        $id2item = array();
        foreach( $items as $idx => $item ){
            $id2item[ $item -> getVar( 'pseudo_id' ) ] =& $items[ $idx ];
        }
        // 
        // print [item] sessions
        // 
        $error = false;// true if error has occured
        foreach( $items as $i ){
            if( !is_null( $import_ids ) && !in_array( $i -> getVar( 'pseudo_id' ), $import_ids ) ) continue;
            $html .= "\n\n[item]\n";
            $html .= $i -> toString(true);
            $html .= "\nfilename " . $i -> getFilename();
            $codes = $i -> getErrorCodes();
            $errors = $i -> getErrors();
            foreach( $errors as $e ){
                $html .= "\nerror " . $e;
            }
            // 
            // print conflict items
            // 
            if( array_key_exists( $i -> getVar( 'pseudo_id' ), $conflict ) ){
                $c = $conflict[ $i -> getVar( 'pseudo_id' ) ];
                foreach( $c[ 'import_items' ] as $j ){
                    $html .= "\nwarning conflict with " . $id2item[ $j ] -> getFilename();
                }
                foreach( $c[ 'exists_items' ] as $j ){
                    $html .= "\nwarning conflict with " . XOOPS_URL . "/modules/xoonips/detail.php?item_id=" . $j;
                }
            }
            if( !$error && count( $i -> getErrors() ) > 0 ) $error = true;
        }
        // 
        // print [error] section
        // 
        $html .= "\n\n[error]";
        foreach( $mgr -> getNonItemErrors() as $error )
            $html .= "\nerror $error";
        // 
        // print [result] section
        // 
        $html .= "\n\n[result]";
        $html .= "\nresult " . ( $error ? "failure" : "success" );
        foreach( $mgr -> getNonItemErrorCodes() as $code )
            $html .= "\nerror " . $code;
        foreach( $items as $i ){
            if( !is_null( $import_ids ) && !in_array( $i -> getVar( 'pseudo_id' ), $import_ids ) ) continue;
            $item_id = $i -> getVar( 'item_id' );
            if( !empty( $item_id ) && count( $i -> getErrors() ) == 0 ){ //no error in importing
                $html .= "\nitem " . $i -> getVar( 'pseudo_id' ) . " " . XOOPS_URL . "/modules/xoonips/detail.php?item_id=" . $i -> getVar( 'item_id' );
            }else{ // error in importing
                foreach( array_unique( $i -> getErrorCodes() ) as $code ){
                    $html .= "\nerror " . $code . " " . $i -> getVar( 'pseudo_id' );
                }
            }
        }
    }
    $html .= "</textarea>\n</form>\n";
    print $html;
}

/**
 * 
 * include class definition of each item types
 * (call me before unserializing XooNIpsItemManager)
 * 
 */
function include_itemtype_definition(){
    global $xoopsDB;
    // 
    // include class definition of all item_types
    //  for XooNIpsImportManager::getItems
    // 
    $result = $xoopsDB -> query( 'select name,viewphp from ' . $xoopsDB -> prefix( 'xoonips_item_type' ) );
    while( $itemtype = $xoopsDB -> fetchArray( $result ) ){
        if( empty( $itemtype['viewphp'] ) ) continue;
        // 
        // include class definition
        // 
        include_once( XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'] );
    }
}


/**
 * 
 * serialize given objects to temporary file
 * and return a path of the file.
 * @param obj reference of an object to be serialized
 * @return file path of serialized object or null if error.
 */
function serializeToFile( $obj )
{
    $path = tempnam( "/tmp", "IMP" );
    $hdl = fopen( $path, "w" );
    if( $hdl ){
        fwrite( $hdl, serialize( $obj ) );
        fclose( $hdl );
        return $path;
    }
    return null;
}

/**
 * 
 * unserialize given file path of serialized object and returns object.
 * @param path file path of serialized object
 * @return reference of object or null if error.
 */
function unserializeFromFile( $path )
{
    $hdl = fopen( $path, "r" );
    if( $hdl ){
        return unserialize( file_get_contents( $path ) );
    }
    return null;
}

?>

