<?php
//  $Revision: 1.42.2.4 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005-2007 RIKEN, Japan. All rights reserved.                  //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

include_once XOOPS_ROOT_PATH.'/modules/xoonips/condefs.php';

function xnp_initialize_db( $a, $b, $c, $d, $e )
{
  setLastErrorString("");
  return RES_OK;
}

$xnp_last_error_string = "";
function setLastErrorString( $str ){
	global $xnp_last_error_string;
	$xnp_last_error_string = $str;
}

function xnp_get_current_uid(){
	if ( isset($_SESSION['xoopsUserId']) )
		return $_SESSION['xoopsUserId'];
	return UID_GUEST;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
// functions used from only AbstractLayer
// 
// 
// 
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

// shown by event functions
// this array specify what fields are used by each events
// 1:use the field, 0: don't use the field
// each field correspond to timestamp, exec_uid, remote_host, index_id, item_id, file_id, uid, gid, search_keyword, additional_info
static $eventValidFields=array(
    array( 0,0,0,0,0,0,0,0,0,0 ), //(dummy)
    array( 1,1,1,0,0,0,0,0,0,1 ), //LOGIN_FAILURE         
    array( 1,1,1,0,0,0,0,0,0,0 ), //LOGIN_SUCCESS         
    array( 1,1,1,0,0,0,0,0,0,0 ), //LOGOUT                
    array( 1,1,1,0,1,0,0,0,0,0 ), //INSERT_ITEM           
    array( 1,1,1,0,1,0,0,0,0,0 ), //UPDATE_ITEM           
    array( 1,1,1,0,1,0,0,0,0,0 ), //DELETE_ITEM           
    array( 1,1,1,0,1,0,0,0,0,0 ), //VIEW_ITEM             
    array( 1,1,1,0,1,1,0,0,0,0 ), //DOWNLOAD_FILE         
    array( 1,1,1,1,1,0,0,0,0,0 ), //REQUEST_CERTIFY_ITEM  
    array( 1,1,1,1,0,0,0,0,0,0 ), //INSERT_INDEX          
    array( 1,1,1,1,0,0,0,0,0,0 ), //UPDATE_INDEX          
    array( 1,1,1,1,0,0,0,0,0,0 ), //DELETE_INDEX          
    array( 1,1,1,1,1,0,0,0,0,0 ), //CERTIFY_ITEM          
    array( 1,1,1,1,1,0,0,0,0,0 ), //REJECT_ITEM           
    array( 1,0,1,0,0,0,1,0,0,0 ), //REQUEST_INSERT_ACCOUNT
    array( 1,1,1,0,0,0,1,0,0,0 ), //CERTIFY_ACCOUNT       
    array( 1,1,1,0,0,0,0,1,0,0 ), //INSERT_GROUP          
    array( 1,1,1,0,0,0,0,1,0,0 ), //UPDATE_GROUP          
    array( 1,1,1,0,0,0,0,1,0,0 ), //DELETE_GROUP          
    array( 1,1,1,0,0,0,1,1,0,0 ), //INSERT_GROUP_MEMBER   
    array( 1,1,1,0,0,0,1,1,0,0 ), //DELETE_GROUP_MEMBER   
    array( 1,1,1,0,0,0,0,0,0,0 ), //VIEW_TOP_PAGE         
    array( 1,1,1,0,0,0,0,0,1,0 ), //QUICK_SEARCH          
    array( 1,1,1,0,0,0,0,0,1,0 ), //ADVANCED_SEARCH       
    array( 1,1,1,0,0,0,1,0,0,0 ), //ETID_START_SU         
    array( 1,1,1,0,0,0,1,0,0,0 ), //ETID_END_SU           
    );

/**
 * 
 * ǥåϿƥ๹ԤʤäȤξǧ֤νͤ
 * ƥˤä֤ޤ
 * 
 */
function getInitialCertifyStateFromConfig( )
{
    $certify_item_val='';
    $ret = NOT_CERTIFIED;
    
    if( xnp_get_config_value( XNP_CONFIG_CERTIFY_ITEM_KEY, $certify_item_val ) == RES_OK ){
        if( $certify_item_val == XNP_CONFIG_CERTIFY_ITEM_AUTO ){
            //certify automatic
            $ret = CERTIFIED;
        }else if( $certify_item_val == XNP_CONFIG_CERTIFY_ITEM_ON ){
            //certify by moderator or group admin
            $ret = CERTIFY_REQUIRED;
        }
    }
    return $ret;
}

/**
 * 
 * pubmedXMLϤ
 * 
 * 
 * 
 */
class PubmedEfetch{
    
    var $parser;
    
    var $pubmed = array();
    
    /** stack for tag */
    var $tags = array();
    
    /** buffer of CDATA */
    var $cdata = "";
    
    // variables for pubmed information
    var $pmid;
    var $title;
    var $author;
    var $journal;
    var $pub_year;
    var $volume;
    var $number;
    var $page;
    var $abstracttext;
    
    /**
     * 
     * constructor
     * @param pubmedid PUBMEDID what you want to get
     * 
     */
	function PubmedEfetch( ) {
		/* constructer for PHP3, PHP4 */
        $this -> init();
	}
    function __construct( ) {
		/* constructer for PHP5 */
		PubmedEfetch::PubmedEfetch( );
        $this -> init();
	}
	function __destruct(  ) {
        xml_parser_free( $this -> parser );
	}
    
    function init(){
        $this -> parser = xml_parser_create();
        xml_set_object( $this -> parser, $this );
        xml_set_character_data_handler( $this -> parser, 'character_data_handler' );
        xml_set_element_handler( $this -> parser, 'start_element_handler', 'end_element_handler' );
    }

    /**
     *
     * parse XML
     *
     * see xml_parse for detail of arguments and return value
     *
     */
    function parse( $data, $flag ) {
        $ret = xml_parse( $this -> parser, $data, $flag );
        if( $ret ){
            $url = PUBMED_ESEARCH_URL_BASE.urlencode( $this -> journal );
            $p = new PubmedEsearch( );
            $p -> parse( file_get_contents( $url ), true );
            $docid_list = $p -> result();
            if( $docid_list ){
                foreach( $docid_list as $id ){
                    $url = PUBMED_ESUMMARY_URL_BASE.$id;
                    $q = new PubmedEsummary( );
                    $q -> parse( file_get_contents( $url ), true );
                    $summary = $q -> result();
                    if( $summary ){
                        if( $summary['medabbr'] == $this -> journal ){
                            //replace abbreviation of title to complete title.
                            $this -> journal = $summary['title'];
                            break;
                        }
                    }
                }
            }else{
                $ret = FALSE;
            }
        }
        return $ret;
    }

    function start_element_handler ( $parser, $name, $attribs ){
        array_push( $this -> tags, $name );
        $this -> cdata = "";
    }

    function end_element_handler ( $parser, $name ){
        array_pop( $this -> tags );
        if( $name == 'PMID' ){
            $this -> pmid = $this -> cdata;
        }else if( $name == 'ARTICLETITLE' ){
            $this -> title = $this -> cdata;
        }else if( $name == 'FORENAME' || $name == 'FIRSTNAME' ){
            $this -> author = $this -> author." ".$this -> cdata;
        }else if( $name == 'LASTNAME' ){
            $this -> author = $this -> author."\n".$this -> cdata;
        }else if( $name == 'MEDLINETA' ){
            $this -> journal = $this -> cdata;
        }else if( $name == 'YEAR' ){
            $this -> pub_year = $this -> cdata;
        }else if( $name == 'VOLUME' ){
            $this -> volume = $this -> cdata;
        }else if( $name == 'ISSUE' ){
            $this -> number = $this -> cdata;
        }else if( $name == 'MEDLINEPGN' ){
            $this -> page = $this -> cdata;
        }else if( $name == 'ABSTRACTTEXT' ){
            $this -> abstracttext = $this -> cdata;
        }
        $this -> cdata = "";
    }

    function character_data_handler ( $parser, $data ){
        $this -> cdata = $this -> cdata.$data;
    }

    /**
     * 
     * ϤpubmedϢ
     * 
     * @return array( 'pmid' => PubMedID, 'title' => ʸȥ, 'author' => ̾, 'journal' => 㡼ʥ̾, 'year_of_publication' => ȯǯ, 'volume' => Volume, 'number' => Number, 'page' => ڡ, 'abst' => ֥ȥ饯ȤΥƥ)
     * ޤϡϤ˼ԤFALSE
     */
    function result( ){
        return array( "pmid" => $this -> pmid,
                      "title" => $this -> title,
                      "author" => $this -> author,
                      "journal" => $this -> journal,
                      "year_of_publication" => $this -> pub_year,
                      "volume" => $this -> volume,
                      "number" => $this -> number,
                      "page" => $this -> page,
                      "abstract" => $this -> abstracttext );
    }
    
}


/**
 * 
 * 㡼ʥ̾(ά)˥ޥå른㡼ʥ򸡺ID
 * 
 */
class PubmedEsearch{
    
    var $parser;
    
    /** stack for tag */
    var $tags = array();
    
    /** buffer of CDATA */
    var $cdata = "";
    
    // list of DocID of candidatss for abbreviation of journal name
    var $docid_list = array();
    
    /**
     * 
     * constructor
     * @param pubmedid PUBMEDID what you want to get
     * 
     */
	function PubmedEsearch( ) {
		/* constructer for PHP3, PHP4 */
        $this -> init();
	}
    function __construct( ) {
		/* constructer for PHP5 */
		PubmedEsearch::PubmedEsearch( );
        $this -> init();
	}
	function __destruct(  ) {
        xml_parser_free( $this -> parser );
	}
    
    function init(){
        $this -> parser = xml_parser_create();
        xml_set_object( $this -> parser, $this );
        xml_set_character_data_handler( $this -> parser, 'character_data_handler' );
        xml_set_element_handler( $this -> parser, 'start_element_handler', 'end_element_handler' );
    }

    /**
     *
     * parse XML
     *
     * see xml_parse for detail of arguments and return value
     *
     */
    function parse( $data, $flag ) {
        $ret = xml_parse( $this -> parser, $data, $flag );
        return $ret;
    }

    function start_element_handler ( $parser, $name, $attribs ){
        array_push( $this -> tags, $name );
        $this -> cdata = "";
    }

    function end_element_handler ( $parser, $name ){
        if( $name == 'ID' ){
            array_push( $this -> docid_list, $this -> cdata );
        }
        $this -> cdata = "";
        array_pop( $this -> tags );
    }

    function character_data_handler ( $parser, $data ){
        $this -> cdata = $this -> cdata.$data;
    }

    /**
     * 
     * get array of candidates ID of jornal name
     * 
     * @return array( journal ID1, jounrnal ID2, .... )
     * false if failed in parsing
     */
    function result( ){
        return $this -> docid_list;
    }
}



/**
 * 
 * get Journal Title, Journal Title Abbreviation
 * 
 */
class PubmedEsummary{
    
    var $parser;
    
    /** array of result */
    var $esummary = array();
    
    /** stack for tags */
    var $tags = array();
    
    /** buffer of CDATA */
    var $cdata = "";
    
    /** buffer of Attributes */
    var $attr = array();
    
    // list of DocID of candidatss for abbreviation of journal name
    var $docid_list = array();
    
    /**
     * 
     * constructor
     * @param pubmedid PUBMEDID what you want to get
     * 
     */
	function PubmedEsummary( ) {
		/* constructer for PHP3, PHP4 */
        $this -> init();
	}
    function __construct( ) {
		/* constructer for PHP5 */
		PubmedEsummary::PubmedEsummary( );
        $this -> init();
	}
	function __destruct(  ) {
        xml_parser_free( $this -> parser );
	}
    
    function init(){
        $this -> parser = xml_parser_create();
        xml_set_object( $this -> parser, $this );
        xml_set_character_data_handler( $this -> parser, 'character_data_handler' );
        xml_set_element_handler( $this -> parser, 'start_element_handler', 'end_element_handler' );
    }

    /**
     *
     * parse XML
     *
     * see xml_parse for detail of arguments and return value
     *
     */
    function parse( $data, $flag ) {
        $ret = xml_parse( $this -> parser, $data, $flag );
        return $ret;
    }

    function start_element_handler ( $parser, $name, $attribs ){
        array_push( $this -> tags, $name );
        $this -> attr = $attribs;
        $this -> cdata = "";
    }

    function end_element_handler ( $parser, $name ){
        if( $name == 'ITEM' && $this->attr['NAME'] == 'MedAbbr' ){
            $this -> esummary['medabbr'] = $this -> cdata;
        }else if( $name == 'ITEM' && $this->attr['NAME'] == 'Title' ){
            $this -> esummary['title'] = $this -> cdata;
        }
        $this -> cdata = "";
        array_pop( $this -> tags );
    }

    function character_data_handler ( $parser, $data ){
        $this -> cdata = $this -> cdata.$data;
    }

    /**
     * 
     * get assosiative array of information of parsed journal
     * 
     * @return array( 'title' => complete jornal title, 'medabbr' => abbreviation of journal title )
     * false if failed
     */
    function result( ){
        return $this -> esummary;
    }
}

/**
 * update last_update_date of the binder.
 * and it makes certify_required the binder is registerd in /Public
 * 
 * @param functionName function name that call touchBinder
 * @param binderid binder's id that you want to update
 * 
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_DB_QUERY_ERROR
 * 
 */
function touchBinder( $functionName, $binderid ){
    global $xoopsDB;

    // update binder's last update date
    $sql = "UPDATE ".$xoopsDB->prefix("xoonips_item_basic")." SET last_update_date=UNIX_TIMESTAMP(NOW())"
        ." WHERE item_id=${binderid}";
    $ret = querySimple( $functionName, $sql );
    
    if ( $ret == RES_OK ){
        // it makes certify_required the binder if it was already certified and items should be certified manually
        $certify_state = getInitialCertifyStateFromConfig();
        if ( $certify_state == CERTIFY_REQUIRED ){
            $sql = "update ".$xoopsDB->prefix("xoonips_index_item_link")
                ." set certify_state=${certify_state}"
                ." where index_id=".IID_BINDERS
                ."  and item_id=${binderid}"
                ."  and certify_state=".CERTIFIED;
            $ret = querySimple( $functionName, $sql );
        }
    }
    return $ret;
}

/** parentXIDľΥǥåsort_numberκ+1 . parentXIDͤͭɤȽǤʤ
  * ROOTľsort_numberۤʤΤǡδؿǤϽǤʤ
  * @param parentXID  index_id
  * @param sortNumber max(sort_number)+1 ѿΥե
  * @return RES_OK 
  */
function getNewSortNumber( $parentXID, &$sortNumber ){
	global $xoopsDB;
	
	$sql =  "SELECT max(sort_number) FROM ".$xoopsDB->prefix("xoonips_index")." WHERE parent_index_id=$parentXID";
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "Error in getNewSortNumber"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	list( $sortNumber ) = $xoopsDB->fetchRow( $result );
	$sortNumber = (int)$sortNumber;
	if ( (int)$sortNumber == 0 ){ // NULLäĤޤparentXIDleaf node Ǥ롣
		$sortNumber = 1; // sort_number=0ͽѤߤʤΤ1Ϥޤ
	}
	else {
		$sortNumber = $sortNumber+1;
	}
	return RES_OK;
}

/**
 * 
 * criteria  SQLѴ
 * 
 * @param cri criteriaϥå
 * @return SQLWHERE˻Ȥ뼰
 * 
 */
function criteria2str( $cri )
{
    $sql = "";
    if( isset( $cri['orders'] ) && count( $cri['orders'] ) > 0 ){
        $orders = array();
        foreach( $cri['orders'] as $o ){
            if( isset( $o['order'] ) && isset( $o['name'] ) && $o['order'] == 0 ) $orders[] = $o['name']." ASC";
            else if( isset( $o['order'] ) && isset( $o['name'] ) && $o['order'] == 1 ) $orders[] = $o['name']." DESC";
        }
        if( count( $orders ) > 0 ){
            $sql .= " ORDER BY ".implode( ', ', $orders );
        }
    }
    if( isset( $cri['rows'] ) && $cri['rows'] > 0 ){
        $sql .= " LIMIT ";
        if( isset( $cri['start'] ) && $cri['start'] > 0 ) $sql .= $cri['start'].", ";
        $sql .= $cri['rows'];
    }
    return $sql;
}

/** Binderƥޤʤtrue֤ : binder_idХǤʤưݾڤʤ
 * 
 */
function isBinderContainsNonpublicItem( $sid, $binder_id ){
    global $xoopsDB;
    
    $ret = false;
    $sql = 
      " select tbil.item_id , count(tx.index_id)"
      ."  from "     .$xoopsDB->prefix("xoonips_binder_item_link")." as tbil "
      ."  left join ".$xoopsDB->prefix("xoonips_index_item_link")." as txil on tbil.item_id=txil.item_id and txil.certify_state = ".CERTIFIED
      ."  left join ".$xoopsDB->prefix("xoonips_index")."           as tx   on txil.index_id=tx.index_id and tx.open_level = ".OL_PUBLIC
      ."  where "
      ."    tbil.binder_id = ${binder_id}"
      ."  group by tbil.item_id ";
    if( $result = $xoopsDB -> query( $sql ) ){
        while( list( $item_id, $ct ) = $xoopsDB -> fetchRow( $result ) ){
            if ( $ct == 0 ){
                $ret = true;
                break;
            }
        }
    }else {
        setLastErrorString( "error in isBinderContainsNonpublicItem( $sid, $binder_id ), sql=${sql}"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = false;
    }
    return $ret;
}

/** ǥå롣ΥåϹԤʤ
  */
function insertIndexInternal( $sid, $index, &$xid ){
    global $xoopsDB;
    
    //1.basic information񤭹(ƥȤʤǡ¤)
    //2.indexξ񤭹(1줿ƥID򥤥ǥåID˻Ѥ)

    $iid = 0;
    $result = RES_ERROR;
    
    //1.
    $index['item_type_id'] = ITID_INDEX;
    $index['uid'] = $index['contributor_uid'];
    $result = xnp_insert_item( $sid, $index, $iid );
    if ( $result == RES_OK ){
        //2.
        $sql = "INSERT INTO ".$xoopsDB->prefix("xoonips_index")." ( index_id, parent_index_id, uid, gid, open_level, sort_number ) values ( "
            . $iid . ","
            . $index['parent_index_id'] . "," 
            . ( $index['open_level'] == OL_PRIVATE    ? $index['owner_uid'] : 'NULL' ) . "," 
            . ( $index['open_level'] == OL_GROUP_ONLY ? $index['owner_gid'] : 'NULL' ) . "," 
            . $index['open_level'] . "," 
            . $index['sort_number'] . ")";
        if( $result = $xoopsDB -> queryF( $sql ) ){
            //ƥID򥤥ǥåIDȤƥåȤ
            $xid = $iid;
            setLastErrorString("");
            $result = RES_OK;
        }else {
            xnp_delete_item( $sid, $iid );
            setLastErrorString( "error in insertIndexInternal: sql=${sql}"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
            $result = RES_ERROR; // 顼: insert˼Ԥ
        }
    }else {
        setLastErrorString( "error result=${result} in insertIndexInternal: can't insert basic information"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $result = RES_ERROR;
    }
    return $result;
}

/**
 * 
 * get titles of an item.
 * 
 * @param caller name of caller function
 * @param item_id ID of the item that get titles of
 * @return array of titles(if succeed) or false(if failed)
 * 
 */
function getTitles( $caller, $item_id )
{
    global $xoopsDB;

    $sql = "SELECT title FROM " . $xoopsDB->prefix( "xoonips_item_title" )
        . " WHERE item_id=${item_id} ORDER BY title_id ASC";
    $result = $xoopsDB->query( $sql );
    if ( !$result ){
        setLastErrorString( "error in getTitles ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        return false;
    }
    $ret = array();
    while ( $row = $xoopsDB->fetchArray( $result ) ){
        $ret[] = $row['title'];
    }
    return $ret;
}

/**
 * 
 * get keywords of an item.
 * 
 * @param caller name of caller function
 * @param item_id ID of the item that get keywords of
 * @return array of keywords(if succeed) or false(if failed)
 * 
 */
function getKeywords( $caller, $item_id )
{
    global $xoopsDB;

    $sql = "SELECT keyword FROM " . $xoopsDB->prefix( "xoonips_item_keyword" )
        . " WHERE item_id=${item_id} ORDER BY keyword_id ASC";
    $result = $xoopsDB->query( $sql );
    if ( !$result ){
        setLastErrorString( "error in getKeywords ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        return false;
    }
    $ret = array();
    while ( $row = $xoopsDB->fetchArray( $result ) ){
        $ret[] = $row['keyword'];
    }
    return $ret;
}

/**
 * 
 * update titles.
 * 
 * 1.remove surples title entries more than given titles
 * 2.update titles 
 * 3.insert new titles
 * 
 * @param caller name of caller function
 * @param item_id ID of the item that be updated
 * @param titles string of new title or array of new titles(no need to be addslashes)
 * @return true:succeed, false: failed
 * 
 */
function updateTitles( $caller, $item_id, $titles )
{
    global $xoopsDB;

    if( !is_array( $titles ) ){
        $titles = array( $titles );
    }
    
    //1. remove titles
    $sql = "DELETE FROM ".$xoopsDB->prefix("xoonips_item_title")." WHERE item_id=${item_id} and title_id >= ".count( $titles );
    $result = $xoopsDB -> queryF( $sql );
    if( !$result ){
        setLastErrorString( "can't remove surplus titles in updateTitles(called by ${caller}) ".$xoopsDB->error()." sql=$sql at ".__LINE__." in ".__FILE__."\n" );
        return false;
    }
    //3. update title and insert new title
    $i = 0;
    foreach( $titles as $title ){
        $sql = "INSERT INTO ".$xoopsDB->prefix("xoonips_item_title")." values ( ${item_id}, ${i}, '".addslashes( $title )."' )";
        $result = $xoopsDB -> queryF( $sql );
        if( !$result ){
            $sql = "UPDATE ".$xoopsDB->prefix("xoonips_item_title")." SET title='".addslashes( $title )."'"
                ." WHERE item_id=${item_id} AND title_id=${i}";
            $result = $xoopsDB -> queryF( $sql );
            if( !$result ){
                setLastErrorString( "can't update title in updateTitles(called by ${caller}) ".$xoopsDB->error()." sql=$sql at ".__LINE__." in ".__FILE__."\n" );
                return false;
            }
        }
        $i++;
    }
    
    return true;
}

/**
 * 
 * update keywords.
 * 
 * 1.remove surples keyword entries more than given keywords
 * 2.update keywords 
 * 3.insert new keywords
 * 4.update xoonips_item_basic.title
 * 
 * @param caller name of caller function
 * @param item_id ID of the item that be updated
 * @param keywords string of new keyword or array of new keywords.(no need to be addslashes)
 * @return true:succeed, false: failed
 * 
 */
function updateKeywords( $caller, $item_id, $keywords )
{
    global $xoopsDB;

    if( !is_array( $keywords ) ){
        $keywords = array( $keywords );
    }
    
    //1. remove keywords
    $sql = "DELETE FROM ".$xoopsDB->prefix("xoonips_item_keyword")." WHERE item_id=${item_id} and keyword_id >= ".count( $keywords );
    $result = $xoopsDB -> queryF( $sql );
    if( !$result ){
        setLastErrorString( "can't remove surplus keywords in updateKeywords(called by ${caller}) ".$xoopsDB->error()." sql=$sql at ".__LINE__." in ".__FILE__."\n" );
        return false;
    }
    // update keyword and insert new keyword
    $i = 0;
    foreach( $keywords as $keyword ){
        $sql = "INSERT INTO ".$xoopsDB->prefix("xoonips_item_keyword")." values ( ${item_id}, ${i}, '".addslashes( $keyword )."' )";
        $result = $xoopsDB -> queryF( $sql );
        if( !$result ){
            $sql = "UPDATE ".$xoopsDB->prefix("xoonips_item_keyword")." SET keyword='".addslashes( $keyword )."'"
                ." WHERE item_id=${item_id} AND keyword_id=${i}";
            $result = $xoopsDB -> queryF( $sql );
            if( !$result ){
                setLastErrorString( "can't update keyword in updateKeywords(called by ${caller}) ".$xoopsDB->error()." sql=$sql at ".__LINE__." in ".__FILE__."\n" );
                return false;
            }
        }
        $i++;
    }
    //4.update xoonips_item_basic.keywords
    $sql = "UPDATE ".$xoopsDB->prefix("xoonips_item_basic")." SET keywords='".addslashes( implode( "\n", $keywords ) )."'"
        ." WHERE item_id=${item_id}";
    $result = $xoopsDB -> queryF( $sql );
    if( !$result ){
        setLastErrorString( "can't update " . $xoopsDB->prefix('xoonips_item_basic') . ".keywords in updateKeywords(called by ${caller}) ".$xoopsDB->error()." sql=$sql at ".__LINE__." in ".__FILE__."\n" );
        return false;
    }
    
    return true;
}



// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
// AbstractLayer API
// 
// 
// 
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

/**
 * 
 * ǸΥ顼å
 * 
 * @return 顼åʸ
 * 
 */
function xnp_get_last_error_string(){
	global $xnp_last_error_string;
	return $xnp_last_error_string;
}

/**
 * 
 * 롼׽°桼.
 * 륰롼פν°Ƥ桼Υ桼ID
 * 
 * @param sid åID
 * @param gid ɤΥ롼פν°桼䤤碌뤫򥰥롼פIDǻ
 * @param cri ̤ϰϻꡤȾ
 * @param uids °桼UIDݥ
 * @return RES_OK
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_SUCH_GROUP
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR 
 * 
 */
function xnp_get_members( $sid, $gid, $cri, &$uids )
{
	global $xoopsDB;
    
    $uids = array();

    if( !xnp_is_valid_session_id( $sid ) ) return RES_NO_SUCH_SESSION;
    if( !gidExists( $gid ) ) return RES_NO_SUCH_GROUP; //gid¸ߤå
    
    $ret = RES_ERROR;
    
    //retrieve member's IDs
    $sql = "SELECT uid, gid, is_admin FROM ".$xoopsDB->prefix('xoonips_groups_users_link')
        ." WHERE gid=${gid} ".criteria2str( $cri );
    $result = $xoopsDB->query($sql);

    if( $result ){
        while ( list($uid) = $xoopsDB->fetchRow($result) ){
            $uids[] = $uid;
        }
        setLastErrorString("");
        $ret = RES_OK;
    }else{
        setLastErrorString( "error in xnp_get_members"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = RES_DB_QUERY_ERROR;
    }
    return $ret;
}

/**
 * 
 * 桼κƥǡ̸Ƥ륢ƥIDޤ.
 * ̥桼ϼʬʳΥƥǤʤ
 * 
 * @param sid åID
 * @param uid оݥ桼ID
 * @param iids Ͽ줿ƥID
 * @return RES_OK
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 * 
 */
function xnp_get_own_public_item_id( $sid, $uid, &$iids )
{
	global $xoopsDB;
    
    $iids = array();

    if( !xnp_is_valid_session_id( $sid ) ) return RES_NO_SUCH_SESSION;
    
    $ret = RES_ERROR;

    if( ( $ret = sessionID2UID( $sid, $sess_uid ) ) != RES_OK ) return $ret;
    if( $sess_uid != $uid && !isModeratorBySession( $sid ) )
        return RES_NO_READ_ACCESS_RIGHT;//no permissions to access these items
    
    $sql = "SELECT DISTINCT tlink.item_id"
        ." FROM ".$xoopsDB->prefix("xoonips_index_item_link")." AS tlink"
        ." LEFT JOIN ".$xoopsDB->prefix("xoonips_index")." AS tx ON tlink.index_id=tx.index_id"
        ." LEFT JOIN ".$xoopsDB->prefix("xoonips_item_basic")." AS ti ON tlink.item_id=ti.item_id"
        ." LEFT JOIN ".$xoopsDB->prefix("xoonips_groups_users_link")." AS tgulink ON ( tgulink.gid = tx.gid AND tx.open_level = ".OL_GROUP_ONLY
        .") OR tx.open_level= ".OL_PUBLIC
        ." WHERE open_level= ".OL_PUBLIC
        ." AND certify_state= ".CERTIFIED
        ." AND item_type_id != ".ITID_INDEX
        ." AND ( ti.uid=${sess_uid}"
        ." OR is_admin=1 AND tgulink.uid=${sess_uid}"
        .")";
    
    if( $result = $xoopsDB -> query( $sql ) ){
        while ( list($iid) = $xoopsDB->fetchRow($result) ){
            $iids[] = $iid;
        }
        setLastErrorString("");
        $ret = RES_OK;
    }else{
        setLastErrorString( "error in xnp_get_own_public_item_id"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = RES_ERROR;
    }
    
    return $ret;
}

/**
 * 
 * ĿͤƥIDޤ.
 * ǥåϿǧ줿ΤϷ̤˴ޤߤޤ
 * 
 * @param sid åID
 * @param uid оݥ桼ID
 * @param iids Ͽ줿ƥID
 * @return RES_OK
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 * 
 */
function xnp_get_private_item_id( $sid, $uid, &$iids )
{
	global $xoopsDB;
    
    $iids = array();
    
    if( !xnp_is_valid_session_id( $sid ) ) return RES_NO_SUCH_SESSION;
    
    $ret = RES_ERROR;
    
    if( ( $ret = sessionID2UID( $sid, $sess_uid ) ) != RES_OK ) return $ret;
    
    //SELECT ƥ NOT IN ( ǧ줿ƥ )
    
    //ǧ줿ƥIDSELECTʸ
    $sql = "SELECT DISTINCT tlink.item_id"
        ." FROM ".$xoopsDB->prefix("xoonips_index_item_link")." AS tlink"
        ." LEFT JOIN ".$xoopsDB->prefix("xoonips_index")." AS tx ON tlink.index_id=tx.index_id"
        ." LEFT JOIN ".$xoopsDB->prefix("xoonips_item_basic")." AS ti ON tlink.item_id=ti.item_id"
        ." LEFT JOIN ".$xoopsDB->prefix("xoonips_groups_users_link")." AS tgulink ON tgulink.gid = tx.gid"
        ." WHERE open_level<=".OL_GROUP_ONLY
        ." AND certify_state=".CERTIFIED
        ." AND item_type_id !=".ITID_INDEX
        ." AND item_type_id !=".ITID_BINDER
        ." AND ( ti.uid=${sess_uid}"
        ." OR is_admin=1 AND tgulink.uid=${sess_uid} )";
    
    if( $result = $xoopsDB->query($sql) ){
        $notin = array();
        while( list( $iid ) = $xoopsDB->fetchRow($result) ){
            $notin[] = $iid;
        }
        
        //ƥ NOT IN (ǧ줿ƥ) SELECTʸ
        $sql = "SELECT item_id FROM ".$xoopsDB->prefix("xoonips_item_basic")
            ." WHERE item_type_id !=" . ITID_INDEX
            ." AND item_type_id !=" . ITID_BINDER
            ." AND uid=" . $sess_uid;
        if( count( $notin ) > 0 ) $sql .= " AND item_id NOT IN ( " . implode( ", ", $notin ) . " )";
        if( $result = $xoopsDB->query($sql) ){
            while( list( $iid ) = $xoopsDB->fetchRow($result) ){
                //privateʥƥID
                $iids[] = $iid;
            }
        }else{
            setLastErrorString( "error in xnp_get_private_item_id sql=${sql} "." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
            $ret = RES_DB_QUERY_ERROR;
        }
        setLastErrorString("");
        $ret = RES_OK;
    }else{
        setLastErrorString( "error in xnp_get_private_item_id "
                            ."sql=${sql} "." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = RES_DB_QUERY_ERROR;
    }
    
    return $ret;
}

/**
 * 
 * ƥ֥󥯾.
 * 襢ƥα¤̵硤Υ󥯾֤ʤ.
 * 
 * @param sid åID
 * @param parentid 󥯸ƥID
 * @param itemids ̤(paerntid󥯤Ƥ륢ƥID)
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_WRITE_ACCESS_RIGHT parentidؤ˥̵, XooNIps桼Ǥʤ(activateԤ)
 */
function xnp_get_related_to( $sid, $parentid, &$itemids )
{
	global $xoopsDB;
    
    $itemids = array();
    
    if( !xnp_is_valid_session_id( $sid ) ) return RES_NO_SUCH_SESSION;
    if( !xnp_get_item_permission( $sid, $parentid, OP_READ ) ) return RES_NO_READ_ACCESS_RIGHT;
    
    $ret = RES_ERROR;
    
    $sql = "SELECT item_id FROM ".$xoopsDB->prefix("xoonips_related_to")
        ." WHERE parent_id=${parentid}";
    if( $result = $xoopsDB -> query( $sql ) ){
        while( list( $iid ) = $xoopsDB->fetchRow($result) ){
            if( xnp_get_item_permission( $sid, $iid, OP_READ ) ){
                $itemids[] = $iid;
            }
        }
        setLastErrorString("");
        $ret = RES_OK;
    }else{
        setLastErrorString( "error in xnp_get_related_to"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = RES_DB_QUERY_ERROR;
    }
    
    return $ret;
}

/**
 * 
 * 桼ID
 * 
 * @param uname ID桼̾
 * @param uid IDѿΥݥ
 * @return RES_ERROR
 * @return RES_OK 
 * 
 */
function xnp_get_uid( $uname, &$uid )
{
    global $xoopsDB;
    
    if( $uname == NULL ) return RES_ERROR;
    
    $ret = RES_ERROR;
    
    $sql = "SELECT uid FROM ".$xoopsDB->prefix("users")." WHERE uname='".addSlashes( $uname )."';";
    if( $result = $xoopsDB -> query( $sql ) ){
        list($uid) = $xoopsDB->fetchRow($result);
        if( $uid ){
            setLastErrorString("");
            $ret = RES_OK;
        }else{
            setLastErrorString( "error in xnp_get_uid sql=${sql}"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
            $ret = RES_NO_SUCH_USER;
        }
    }else{
        setLastErrorString( "error in xnp_get_uid sql=${sql}"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = RES_NO_SUCH_USER;
    }
    
    return $ret;
}

/**
 * 
 * ǧԤ֤ΥƥΤǧ¤Τ륢ƥIDϿ襤ǥåIDڥǼޤ.
 * ƥiids[i]xids[i]ؤϿξǧԤ֤ˤ뤳Ȥ֤ޤ
 * 
 * @param sid åID
 * @param xids ǧԤƥϿ襤ǥåIDΥե
 * @param iids ǧԤƥIDΥե
 * @return RES_OK
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 * 
 */
function xnp_get_uncertified_link( $sid, &$xids, &$iids )
{
    global $xoopsDB;
    
    $iids = array();
    
    if( !xnp_is_valid_session_id( $sid ) ) return RES_NO_SUCH_SESSION;
    
    $ret = RES_ERROR;
    
    if( ( $ret = sessionID2UID( $sid, $sess_uid ) ) != RES_OK ) return $ret;
    
    $is_moderator = xnp_is_moderator( $sid, $sess_uid );
	$sql = "SELECT DISTINCT tlink.index_id, tlink.item_id"
        ." FROM ".$xoopsDB->prefix("xoonips_index_item_link")." AS tlink"
        ." LEFT JOIN ".$xoopsDB->prefix("xoonips_index")." AS tx ON tlink.index_id = tx.index_id"
        ." LEFT JOIN ".$xoopsDB->prefix("xoonips_item_basic")." AS ti ON tlink.item_id = ti.item_id"
        .( $is_moderator ? "" : " LEFT JOIN ".$xoopsDB->prefix("xoonips_groups_users_link")." AS tgulink ON tgulink.gid = tx.gid" )
        ." WHERE open_level<=".OL_GROUP_ONLY
        ." AND certify_state=".CERTIFY_REQUIRED
        ." AND item_type_id !=".ITID_INDEX
        .( $is_moderator ? "" : " AND is_admin=1 AND tgulink.uid=${sess_uid}" );

    if( $result = $xoopsDB -> query( $sql ) ){
        while( list( $xid, $iid ) = $xoopsDB -> fetchRow( $result ) ){
            if ( $xid == IID_BINDERS ){
                // Binderƥޤʤ顤åפ롥
                if ( isBinderContainsNonpublicItem( $sid, $iid ) )
                    continue;
                }
                
            $xids[] = $xid;
            $iids[] = $iid;
        }
        setLastErrorString("");
        $ret = RES_OK;
    }else {
        setLastErrorString( "error in xnp_get_uncertified_link , sql=${sql}"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = RES_DB_QUERY_ERROR;
    }
    
    return $ret;
}

/**
 * 
 * Ͽ
 * 
 * 桼ǡ١Ͽޤ
 * Ͽ桼б桼IDuid˳Ǽޤ
 * 
 * @param sid å
 * @param account Ͽ륢Ⱦ
 * @param uid ϿȾб桼IDѿΥե
 * @return RES_OK
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * 
 */
function xnp_insert_account( $sid, $account, &$uid )
{
    global $xoopsDB;

    if( !xnp_is_valid_session_id( $sid ) ) return RES_NO_SUCH_SESSION;
    
    $ret = RES_ERROR;
    
    /*
      1. insert user profile into xoops_users
      2. insert platform user profile into xoonips_users
      3. add user to default platform group
      4. create private index
      5. update account set private_index_id=...
     */
    
    //1.xoopsΥ桼ơ֥˽񤭹
    $columns = array();
    $values = array();
    foreach( array( 'uname', 'name', 'email', 'url', 'user_avatar', 'user_icq', 'user_from', 'user_sig', 'actkey', 'user_aim', 'user_yim', 'user_msnm', 'pass', 'theme', 'umode', 'user_occ', 'bio', 'user_intrest' ) as $k ){
        if( isset( $account[$k] ) ){
            $columns[] = $k;
            $values[] = "'".addSlashes( $account[$k] )."'";
        }
    }
    foreach( array( 'user_regdate', 'user_viewemail', 'posts', 'attachsig', 'rank', 'level', 'timezone_offset', 'last_login', 'uorder', 'notify_method', 'notify_mode', 'user_mailok' ) as $k ){
        if( isset( $account[$k] ) ){
            if( isset( $account[$k] ) ){
                $columns[] = $k;
                $values[] = $account[$k];
            }
        }
    }
    $sql = "INSERT INTO ".$xoopsDB->prefix("users")." (".implode( ', ', $columns ).") VALUES (".implode( ", ", $values ).")";
    if( $result = $xoopsDB -> queryF( $sql ) ){
        $count = 0;
        //桼ID
        $uid = $xoopsDB -> getInsertID();
        setLastErrorString("");
        $ret = RES_OK;
    }else{
        setLastErrorString( "error in xnp_insert_account(phase 1)"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
    }
    
    if( $ret == RES_OK ){
        //2.xoonipsΥ桼ơ֥˻Ĥξ񤭹
        $columns = array( 'uid', 'activate', 'address', 'division', 'tel', 'company_name', 'country', 'zipcode', 'fax', 'notice_mail', 'notice_mail_since', 'private_item_number_limit', 'private_index_number_limit', 'private_item_storage_limit' );
        $values = array(
            $uid,
            ( isset( $account['activate'] ) && $account['activate'] ) ? 1 : 0,
            addSlashes( $account['address'] ),
            addSlashes( $account['division'] ),
            addSlashes( $account['tel'] ),
            addSlashes( $account['company_name'] ),
            addSlashes( $account['country'] ),
            addSlashes( $account['zipcode'] ),
            addSlashes( $account['fax'] ),
            $account['notice_mail'],
            time(),
            $account['item_number_limit'],
            $account['index_number_limit'],
            $account['item_storage_limit'] );
        $sql = "INSERT INTO ".$xoopsDB->prefix("xoonips_users")." (".implode( ', ', $columns ).") VALUES ('".implode( "', '", $values )."')";
        if( $result = $xoopsDB -> queryF( $sql ) ){
            setLastErrorString("");
            $ret = RES_OK;
            //3.add new user to default group(not a group admin)
            $ret = xnp_insert_member( $sid, GID_DEFAULT, $uid, false );
            if( $ret != RES_OK ){
                //xoops_usersinsert쥳ɤ
                $sql = "DELETE FROM ".$xoopsDB->prefix("users")." where uid=${uid}";
                $xoopsDB -> queryF( $sql );
                setLastErrorString( "error xnp_insert_member in xnp_insert_account"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
                $ret = RES_DB_QUERY_ERROR;
            }
        }else{
            //xoops_usersinsert쥳ɤ
            setLastErrorString( "error in xnp_insert_account(phase 2) sql=${sql}"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
            $sql = "DELETE FROM ".$xoopsDB->prefix("users")." where uid=${uid}";
            $xoopsDB -> queryF( $sql );
            $ret = RES_DB_QUERY_ERROR;
        }
    }
    
    if ( $ret == RES_OK ){
        //4.private index
        
        // private indexѤsort_number
        $sql = "select min(sort_number) from "
            .$xoopsDB->prefix("xoonips_index")." where parent_index_id=".IID_ROOT
            ." and open_level=".OL_PRIVATE;
        
        if( $result = $xoopsDB -> query( $sql ) ){
            list( $sortNumber ) = $xoopsDB -> fetchRow( $result );
            //ľ˺privateǥåΥȥʥСǥȤΤ
            //Ǻ륤ǥåΥȥʥС
            //privateǥåΥȥʥСϹ߽Ϳ뤿ᡥ
            $sortNumber--;
            
            // private index
            $index = array();
            $index['item_type_id'] = ITID_INDEX;
            $index['contributor_uid'] = $uid;
            $index['parent_index_id'] = IID_ROOT;
            $index['owner_uid'] = $uid;
            $index['open_level'] = OL_PRIVATE;
            $index['sort_number'] = $sortNumber;
            $index['titles'] = array( $account['uname'] );
            
            $privateXID = 0;
            $ret = insertIndexInternal( $sid, $index, $privateXID );
            if( $ret == RES_OK ){
                // xnpaccuont_usersprivate_index_idν񤭴
                $sql = "UPDATE ".$xoopsDB->prefix("xoonips_users")." SET private_index_id=${privateXID}" 
                    ." WHERE uid=${uid}";
                $xoopsDB -> queryF( $sql );
            }
        }
    }
    
    return $ret;
}

/**
 * 
 * ѹϿ롥
 * 
 * @param sid åID
 * @param itemid ѹϿ륢ƥID
 * @param log 
 * @return RES_OK 
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * @return RES_ERROR
 * 
 */
function xnp_insert_change_log( $sid, $itemid, $log )
{
    global $xoopsDB;

    if( !xnp_is_valid_session_id( $sid ) ) return RES_NO_SUCH_SESSION;
    if( !xnp_get_item_permission( $sid, $itemid, OP_MODIFY ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    
    $ret = RES_ERROR;
    
    $now = time( );
    // insert change log
    $sql = "INSERT INTO ".$xoopsDB->prefix("xoonips_changelog")." (item_id, log_date, log) VALUES (${itemid}, UNIX_TIMESTAMP(NOW()), '".addSlashes( $log )."' )";
    if( $result = $xoopsDB -> queryF( $sql ) ){
        // update last update date
        $sql = "UPDATE ".$xoopsDB->prefix("xoonips_item_basic")." SET last_update_date=UNIX_TIMESTAMP(NOW())"
            ." WHERE item_id=${itemid}";
        $xoopsDB -> queryF( $sql );
        setLastErrorString("");
        $ret = RES_OK;
    }else{
        setLastErrorString( "error in xnp_insert_change_log "." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = RES_DB_QUERY_ERROR;
    }
    return $ret;
}

/**
 * 
 * ٥ȥ˥٥ȾϿ
 * 
 * @param sid åID
 * @param event_type_id ٥ȥID
 * @param timestamp ٥ȯ time_t
 * @param exec_uid ٥ȯuid
 * @param remote_host remote host
 * @param params ʲΥϢ: index_id, item_id, file_id, uid, gid, search_keyword, login_name
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_DB_QUERY_ERROR;
 * 
 */
function xnp_insert_event( $sid, $event_type_id, $timestamp, $exec_uid, $remote_host, $params )
{
    global $xoopsDB;
    global $eventValidFields;

    if ( $event_type_id < 1 || ETID_MAX < $event_type_id ){
        setLastErrorString( "invalid event_type_id(${event_type_id}) in xnp_insert_event"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        return RES_ERROR;
    }
    
    $ret = RES_ERROR;
    
    $sql = "insert into ".$xoopsDB->prefix("xoonips_event_log")
        ." ( event_type_id, timestamp, exec_uid, index_id, item_id, file_id, uid, gid, remote_host, search_keyword, additional_info ) "
        ." values ( "
        .$event_type_id . ","
        .( $eventValidFields[ $event_type_id ][0] ? $timestamp : "NULL" ) . ","
        .( $eventValidFields[ $event_type_id ][1] ? $exec_uid  : "NULL" ) . ","
        .( $eventValidFields[ $event_type_id ][3] && isset( $params['index_id'] ) ? $params['index_id'] : "NULL" ) . ","
        .( $eventValidFields[ $event_type_id ][4] && isset( $params['item_id' ] ) ? $params['item_id' ] : "NULL" ) . ","
        .( $eventValidFields[ $event_type_id ][5] && isset( $params['file_id' ] ) ? $params['file_id' ] : "NULL" ) . ","
        .( $eventValidFields[ $event_type_id ][6] && isset( $params['uid'     ] ) ? $params['uid'     ] : "NULL" ) . ","
        .( $eventValidFields[ $event_type_id ][7] && isset( $params['gid'     ] ) ? $params['gid'     ] : "NULL" ) . ","
        .( $eventValidFields[ $event_type_id ][2] ? "'".addSlashes( $remote_host )."'" : "NULL" ) . ","
        .( $eventValidFields[ $event_type_id ][8] && isset( $params['search_keyword'] )  ? "'".addSlashes( $params['search_keyword' ] )."'" : "NULL" ) . ","
        .( $eventValidFields[ $event_type_id ][9] && isset( $params['additional_info'] ) ? "'".addSlashes( $params['additional_info'] )."'" : "NULL" ) . ")";
    
    if( $result = $xoopsDB -> queryF( $sql ) ){
        setLastErrorString("");
        $ret = RES_OK;
    }else{
        setLastErrorString( "error in xnp_insert_event "." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = RES_DB_QUERY_ERROR;
    }
    return $ret;
}


/**
 * 
 * 롼Ͽ. 
 * 롼פξǡ١˵Ͽ롥
 * Ͽ롼פб륰롼IDgid˳Ǽ롥
 * 
 * @param sid åID
 * @param group Ͽ롼פξ
 * @param gid Ͽ롼פб륰롼IDѿΥե
 * @return RES_OK
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_GROUPNAME_ALREADY_EXISTS
 */
function xnp_insert_group( $sid, $group, &$gid )
{
    global $xoopsDB;

    if( !xnp_is_valid_session_id( $sid ) ) return RES_NO_SUCH_SESSION;
    
    $group['gname'             ] = isset($group['gname'             ]) ? (string)$group['gname'             ] : "";
    $group['gdesc'             ] = isset($group['gdesc'             ]) ? (string)$group['gdesc'             ] : "";
    $group['item_number_limit' ] = isset($group['item_number_limit' ]) ? (int   )$group['item_number_limit' ] : 0;
    $group['index_number_limit'] = isset($group['index_number_limit']) ? (int   )$group['index_number_limit'] : 0;
    $group['item_storage_limit'] = isset($group['item_storage_limit']) ? (int   )$group['item_storage_limit'] : 0;
    
    $ret = RES_ERROR;
    
    // examine whether there is already a group name
    $sql = "SELECT gid FROM ".$xoopsDB->prefix("xoonips_groups")
        ." WHERE gname='".addSlashes( $group['gname'] )."' AND gid != ".GID_DEFAULT;
    if( $result = $xoopsDB -> query( $sql ) ){
        if( $xoopsDB -> getRowsNum( $result ) > 0 ){
            // already exists
            return RES_GROUPNAME_ALREADY_EXISTS;
        }else{
            setLastErrorString("");
            $ret = RES_OK;
        }
    }else{
        setLastErrorString( "error in query of xnp_insert_group "." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        return RES_ERROR;
    }
    
    //롼׾insert
    $sql = "INSERT INTO ".$xoopsDB->prefix("xoonips_groups")
        ." ( gname, gdesc, group_item_number_limit, group_index_number_limit, group_item_storage_limit ) VALUES ( "
        .implode( ", ", array( 
            "'".addSlashes( $group['gname'] )."'",
            "'".addSlashes( $group['gdesc'] )."'",
            $group['item_number_limit'],
            $group['index_number_limit'],
            $group['item_storage_limit'] ) )
        .")";
    if( $result = $xoopsDB -> queryF( $sql ) ){
        //롼ID
        $gid = $xoopsDB -> getInsertID();
        setLastErrorString("");
        $ret = RES_OK;
    }else{
        //롼׺˼Ԥ
        setLastErrorString( "error can't insert group in xnp_insert_group"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        return RES_ERROR;
    }
    
    //group index
    //group indexѤsort_num
    $sql = "SELECT MAX(sort_number) FROM "
        .$xoopsDB->prefix("xoonips_index")." WHERE parent_index_id=".IID_ROOT
        ." AND (open_level=".OL_GROUP_ONLY
        ." OR open_level=".OL_PUBLIC.")";
    $sortNumber = 0;
    if( $result = $xoopsDB -> query( $sql ) ){
        list( $sortNumber ) = $xoopsDB->fetchRow( $result );
        $sortNumber++;
    }
        
    // group index
    $ret = sessionID2UID( $sid, $uid );
    if ( $ret == RES_OK ){
        $index = array();
        $index['item_type_id']     = ITID_INDEX;
        $index['contributor_uid']  = $uid;
        $index['parent_index_id']  = IID_ROOT;
        $index['owner_gid']        = $gid;
        $index['open_level']       = OL_GROUP_ONLY;
        $index['sort_number']      = $sortNumber;
        $index['titles']           = array( $group['gname'] );
        $index['description']      = '';
        $index['doi']              = '';
        $index['keywords']         = '';
        $index['lang']             = 'eng';
            
        $ret = insertIndexInternal( $sid, $index, $groupXID );
        if ( $ret == RES_OK ){
            // xoonips_groupsgroup_index_idν񤭴
            $sql = "UPDATE ".$xoopsDB->prefix("xoonips_groups")." SET group_index_id=${groupXID} WHERE gid=${gid}";
            if( $result = $xoopsDB->queryF( $sql ) ){
                setLastErrorString("");
                return RES_OK;
            }else{
                //ǥåκ˼Ԥ顤롼פΥǡ
                setLastErrorString( "error can't update group index id in xnp_insert_group"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
                xnp_delete_group( $sid, $gid );
                return RES_ERROR;
            }
        }else{
            //ǥåκ˼Ԥ顤롼פΥǡ
            setLastErrorString( "error can't create group index in xnp_insert_group"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
            xnp_delete_group( $sid, $gid );
            return RES_ERROR;
        }
    }
    return RES_OK;
}

/**
 * 
 * ǥåɤϿ
 * 
 * @param sid åID
 * @param index Ͽ륤ǥåɾ(ϥå)
 * @param xid ϿǥåItemIDѿΥե
 * @return RES_OK 
 *
 */
function xnp_insert_index( $sid, $index, &$xid )
{
    global $xoopsDB;

    $result = RES_ERROR;
    
    $result = sessionID2UID( $sid, $uid ); // sid  uid 
    if( $result != RES_OK ) return $result;
    
    if( $index['parent_index_id'] == IID_ROOT ||
        $index['parent_index_id'] == IID_BINDERS ){
        setLastErrorString( "error in xnp_insert_index: parentXID must not Root/Binders "." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        return RES_ERROR; // 顼: Root/BindersľˤϺǤʤ
    }
    
    // parentXID ΥĴ٤
    $parentIndex = array();
    $result = xnp_get_index( $sid, $index['parent_index_id'], $parentIndex );
    if ( $result == RES_OK ){
        if ( !isWritableInternal( $sid, $uid, $parentIndex ) ){
            setLastErrorString( "in xnp_insert_index: cannot write to parentindex"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
            $result = RES_ERROR;  // 顼: ƥǥåؤν񤭹߸¤̵
        }
        else {
            if ( !isset( $index['titles'][DEFAULT_INDEX_TITLE_OFFSET] ) || trim( $index['titles'][DEFAULT_INDEX_TITLE_OFFSET] ) == '' ){
                // titleʸˤǤʤ
                setLastErrorString( "error in xnp_insert_index: empty title"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
                $result = RES_ERROR;
            }else {
                $sortNumber = 0;
                $result = getNewSortNumber( $index['parent_index_id'], $sortNumber );
                if ( $result == RES_OK ){
                    $index['open_level'] = $parentIndex['open_level'];
                    $index['owner_gid']  = $parentIndex['owner_gid'];
                    $index['owner_uid']  = $parentIndex['owner_uid'];
                    $index['contributor_uid'] = $uid;
                    $index['sort_number'] = $sortNumber;
                    // ǥå롣
                    $result = insertIndexInternal( $sid, $index, $xid );
                }else{
                    ; // error: getNewSortNumber failed.
                    $result = RES_ERROR;
                }
            }
        }
    }
    else {
        setLastErrorString( "error in xnp_insert_index: get_index failed"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $result = RES_ERROR;
    }
    return $result;
}

/**
 * 
 * ƥ(Basic Information)Ͽ.
 * Platform桼ʾθ¤ɬ.
 * 
 * @param sid åID
 * @param item Ͽƥξ
 * @param itemid ϿƥIDΥե
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * 
 */
function xnp_insert_item_direct( $sid, $item, &$itemid )
{
    return _xnp_insert_item( $sid, $item, $itemid, true );
}

function xnp_insert_item( $sid, $item, &$itemid )
{
    return _xnp_insert_item( $sid, $item, $itemid, false );
}

/**
 * 
 * ƥ(Basic Information)Ͽ.
 * Platform桼ʾθ¤ɬ.
 * 
 * @param sid åID
 * @param item Ͽƥξ
 * @param itemid ϿƥIDΥե
 * @param direct last_update_date, creation_dateitemƤ˽ʤtrue
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * 
 */
function _xnp_insert_item( $sid, $item, &$itemid, $direct )
{
    global $xoopsDB;

    if( !xnp_is_valid_session_id( $sid ) ) return RES_NO_SUCH_SESSION;
    if( !isActivatedBySession( $sid ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    
    $ret = RES_ERROR;
    
    $sql = "INSERT INTO ".$xoopsDB->prefix("xoonips_item_basic")
        ." (item_type_id, description, doi, uid, creation_date, last_update_date, publication_year, publication_month, publication_mday, lang) VALUES ("
        .implode( ", ",
                  array( isset( $item['item_type_id'] ) ? (int)$item['item_type_id'] : 0,
                         "'".addSlashes( isset($item['description']) ? $item['description'] : "")."'",
                         "'".addSlashes( isset($item['doi'        ]) ? $item['doi'        ] : "")."'",
                         $item['uid'],
                         ( $direct ? $item['creation_date'] : 'UNIX_TIMESTAMP(NOW())' ),
                         ( $direct ? $item['last_update_date'] : 'UNIX_TIMESTAMP(NOW())' ),
                         isset( $item['publication_year' ] ) ? (int)$item['publication_year' ] : 0,
                         isset( $item['publication_month'] ) ? (int)$item['publication_month'] : 0,
                         isset( $item['publication_mday' ] ) ? (int)$item['publication_mday' ] : 0,
                         "'".addSlashes( isset($item['lang']) ? $item['lang'] : "" )."'" ) )
        .")";
    $result = $xoopsDB -> queryF( $sql );
    if( $result ){
        //ƥID
        $itemid = $xoopsDB -> getInsertID();
        //insert titles and keywords
        if( isset( $item['titles'] ) ){
            if( !is_array( $item['titles'] ) ) $item['titles'] = array( $item['titles'] );
            if( count( $item['titles'] ) > 0 ){
                if( !updateTitles( __FUNCTION__, $itemid, $item['titles'] ) ){
                    setLastErrorString( "can't insert title in ".__FUNCTION__." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
                    xnp_delete_item( $sid, $itemid );
                    return RES_DB_QUERY_ERROR;
                }
            }
//              $titles = array();
//              foreach( $item['titles'] as $title ){ $titles[] = "( ${itemid}, '".addslashes( $title )."'"; }
//              $sql = "INSERT INTO ".$xoopsDB->prefix("xoonips_item_title")
//                  ." (item_id, title) VALUES ".implode( ",", $values );
//              $result = $xoopsDB -> queryF( $sql );
//              if( !$result ){
//                  setLastErrorString( "can't insert titles. ".$xoopsDB->error()." sql='$sql'" );
//                  $ret = RES_DB_QUERY_ERROR;
//              }
        }
        if( isset( $item['keywords'] ) ){
            if( !is_array( $item['keywords'] ) ) $item['keywords'] = array( $item['keywords'] );
            if( count( $item['keywords'] ) > 0 ){
                if( !updateKeywords( __FUNCTION__, $itemid, $item['keywords'] ) ){
                    setLastErrorString( "can't insert keyword in ".__FUNCTION__." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
                    xnp_delete_item( $sid, $itemid );
                    return RES_DB_QUERY_ERROR;
                }
            }
//              $keywords = array();
//              foreach( $item['keywords'] as $keyword ){ $keywords[] = "( ${itemid}, '".addslashes( $keyword )."'"; }
//              $sql = "INSERT INTO ".$xoopsDB->prefix("xoonips_item_keyword")
//                  ." (item_id, keyword) VALUES ".implode( ",", $values );
//              $result = $xoopsDB -> queryF( $sql );
//              if( !$result ){
//                  setLastErrorString( "can't insert keywords. ".$xoopsDB->error()." sql='$sql'" );
//                  $ret = RES_DB_QUERY_ERROR;
//              }
        }
        //
        if( $item['item_type_id'] == ITID_INDEX ){
            //nothing to do if index.
            setLastErrorString( "" );
            $ret = RES_OK;
        }else{
            //insert into private index
            $sql = "SELECT private_index_id FROM ".$xoopsDB->prefix("xoonips_users")
                ." WHERE uid=".$item['uid'];
            if( $result = $xoopsDB -> query( $sql ) ){
                list( $private_xid ) = $xoopsDB->fetchRow( $result );
                $ret = xnp_register_item( $sid, $private_xid, $itemid );
            }else{
                setLastErrorString( "error can't retrieve private_index_id in xnp_insert_item "." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
                xnp_delete_item( $sid, $itemid );
                return RES_ERROR;
            }
        }
    }else{
        setLastErrorString( "error can't insert item in xnp_insert_item ${sql} ".$xoopsDB->error()." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = RES_DB_QUERY_ERROR;
    }
    
    return $ret;
}    

/**
 * 
 * 롼׽°桼ɲ.
 * 롼פΥС˥桼ɲä.
 * 
 * @param sid åID
 * @param gid °襰롼פID
 * @param uid °桼ID
 * @param admin Ը¤Ϳʤtrue
 * @return RES_OK
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_SUCH_USER
 * @return RES_NO_SUCH_GROUP
 * @return RES_DB_QUERY_ERROR
 * 
 */
function xnp_insert_member( $sid, $gid, $uid, $admin )
{
    global $xoopsDB;

    if( !xnp_is_valid_session_id( $sid ) ) return RES_NO_SUCH_SESSION;
    if( !uidExists( $uid ) ) return RES_NO_SUCH_USER; //uid¸ߤå
    if( !gidExists( $gid ) ) return RES_NO_SUCH_GROUP; //gid¸ߤå
    
    $ret = RES_ERROR;
    
    //Сɲ
    $sql = "INSERT INTO ".$xoopsDB->prefix("xoonips_groups_users_link")
        ." ( gid, uid, is_admin ) VALUES ( ${gid}, ${uid}, ".( $admin ? "1" : "0" )." )";
    if( $result = $xoopsDB -> queryF( $sql ) ){
        setLastErrorString( "" );
        $ret = RES_OK;
    }else{
        setLastErrorString( "SQLRowCount in xnp_insert_member ${sql}"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = RES_DB_QUERY_ERROR;
    }
    return $ret;
}

/**
 * 
 * ƥ֥󥯾ɲä롥
 * Platform桼ʾθ¤ɬ.
 * 
 * TODO itemidǤʤƥ򤵤Ƥ硤ɲäǤʤ
 * TODO parentiditemidβ줫ޤϰؤƥब¸ߤʤȤɲäǤʤ
 * 
 * @param sid åID
 * @param parentid 󥯸ƥID
 * @param itemid ()ƥID
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_WRITE_ACCESS_RIGHT parentidԽǤʤƥ򤵤Ƥ롤<br/>ޤitemidǤʤƥؤƤ롤<br/>ޤ XooNIps桼Ǥʤ(activateԤ)
 * 
 */
function xnp_insert_related_to( $sid, $parentid, $itemid )
{
    global $xoopsDB;
    
    if( !xnp_is_valid_session_id( $sid ) ) return RES_NO_SUCH_SESSION;
    if( !isActivatedBySession( $sid ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    if( !xnp_get_item_permission( $sid, $parentid, OP_MODIFY ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    if( !xnp_get_item_permission( $sid, $itemid, OP_READ ) ) return RES_NO_READ_ACCESS_RIGHT;
    
    $ret = RES_ERROR;
    
    $sql = "INSERT IGNORE INTO ".$xoopsDB->prefix("xoonips_related_to")." (parent_id, item_id) VALUES ( ${parentid}, ${itemid} )";
    if( $result = $xoopsDB -> queryF( $sql ) ){
        setLastErrorString( "" );
        $ret = RES_OK;
    }else{
        setLastErrorString( "error in xnp_insert_related_to"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = RES_DB_QUERY_ERROR;
    }
    
    return $ret;
}    


/**
 * 
 * Platform桼ǧּ
 * 
 * XOOPSδԤϾtrue֤.
 *
 * @param sid åID
 * @param uid ֤桼UID
 * @return true ǧѤ
 * @return false ̤ǧ
 * 
 */
function xnp_is_activated( $sid, $uid )
{
    global $xoopsDB;
    global $xoopsUser;
    
    //XOOPSδԤϾtrue֤.
    //if( isset( $xoopsUser ) && $xoopsUser != null && $xoopsUser->isAdmin() ) return true;
    $sql = "select uid from ".$xoopsDB->prefix("groups_users_link")." where groupid=".XOOPS_GROUP_ADMIN." and uid=$uid";
    $result = $xoopsDB->query( $sql );
    if ( $result == false ) return false;
    if ( $xoopsDB -> getRowsNum( $result ) )
        return true;
    
    $ret = false;
    
    $sql = "SELECT * FROM ".$xoopsDB->prefix("xoonips_users")
        ." WHERE activate=1 and uid=${uid}";
    $result = 0;
    if( $result = $xoopsDB -> query( $sql ) ){
        if( $xoopsDB -> getRowsNum($result) > 0 ){
            $ret = true;
        }else{
            $ret = false;
        }
    }else{
        setLastErrorString( "error in xnp_is_activated. ${sql}"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = false;
    }
    
    return $ret;
}

/**
 * 
 * 롼״礻.
 * 桼˥롼פδ¤뤫(롼״ԤǤ뤫)䤤碌.
 * 桼䥰롼פ¸ߤʤʤɤΰ۾ξ硤false֤.
 * 
 * @param sid åID
 * @param gid 롼פUID
 * @param uid 桼UID
 * @return true ¤
 * @return false ¤ʤޤ
 * @see 
 */
function xnp_is_group_admin( $sid, $gid, $uid )
{
    global $xoopsDB;

    if( !xnp_is_valid_session_id( $sid ) ) return false;
    if( !uidExists( $uid ) ) return false;
    if( !gidExists( $gid ) ) return false;
    
    $ret = false;
    
    $sql = "SELECT * FROM ".$xoopsDB->prefix("xoonips_groups_users_link")
        ." WHERE gid=${gid} AND uid=${uid} AND is_admin=1";
    if( ($result = $xoopsDB -> query( $sql ))
        && $xoopsDB -> getRowsNum($result) > 0 ){
        $ret = true;
    }else{
        setLastErrorString( "SQLFetch in xnp_is_group_admin. ${sql}"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = false;
    }

    return $ret;
}


/**
 * 
 * ǥåɤؤɤ߹߸Ĵ٤
 * 
 * @param sid åID
 * @param xid ǥåɤXID
 * @return 
 *
 */
function xnp_is_index_readable( $sid, $xid )
{
    global $xoopsDB;

    $result = sessionID2UID( $sid, $uid ); // sid  uid 
    if( $result == RES_OK ){
        $criteria = array();
        $cond = "tx.index_id = ${xid}";
        $indexes = array();
        // todo: ٤褦ʤ¾ˡˤ
        $result = getIndexesInternal( $sid, $cond, $uid, $indexes, criteria2str($criteria) );
        if ( $result == RES_OK ){
            if( count( $indexes ) > 0 ){
                return true;
            }
            else ; // xid
        }
    }
    return false;
}

/**
 * 
 * ǥåɤؤν񤭹߸Ĵ٤
 * 
 * @param sid åID
 * @param xid ǥåɤXID
 * @return 
 *
 */
function xnp_is_index_writable( $sid, $xid )
{
    global $xoopsDB;

    $result = sessionID2UID( $sid, $uid ); // sid  uid 
    if( $result == RES_OK ){
        $criteria = array();
        $cond = "tx.index_id = ${xid}";
        $indexes = array();
        // todo: ٤褦ʤ¾ˡˤ
        $result = getIndexesInternal( $sid, $cond, $uid, $indexes, criteria2str($criteria) );
        if ( $result == RES_OK ){
            $writable = false;
            if( count( $indexes ) > 0 ){
                $writable = isWritableInternal( $sid, $uid, $indexes[0] );
            }
            return $writable;
        }
    }
    return false;
}


/**
 * 
 * ǥ졼¤̵֤ͭ
 * 
 * @param sid åID
 * @param uid 䤤碌桼UID
 * @return true ¤
 * @return false ¤ʤ
 * 
 */
function xnp_is_moderator( $sid, $uid )
{
    global $xoopsDB;

    if( !xnp_is_valid_session_id( $sid ) ) return false;
    if( !uidExists( $uid ) ) return false;
    
    $ret = false;
    
    $sql = "SELECT value FROM ".$xoopsDB->prefix("xoonips_config")
        ." WHERE name='moderator_gid'";
    if( $result = $xoopsDB -> query( $sql ) ){
        list( $moderator_gid ) = $xoopsDB->fetchRow( $result );
        $sql = "SELECT * from ".$xoopsDB->prefix("groups_users_link")
            ." WHERE groupid=${moderator_gid}"
            ." AND uid=${uid}";
        
        if( ( $result = $xoopsDB -> query( $sql ) )
            && $xoopsDB -> getRowsNum($result) > 0 ){
            $ret = true;
        }else{
            $ret = false;
        }
    }else{
        $ret = false;
    }
    
    return $ret;
}


/**
 * 
 * validate a session id.
 * return false if given session id is not found in database
 * 
 * @param sid session id that is validated
 * @return true valid
 * @return false invalid
 *
 */
function xnp_is_valid_session_id( $sid )
{
    global $xoopsDB;
    
    //XOOPSΥåơ֥ˡsidȲ񤹤
    //sess_dataեxoopsUserId̵ͭȽ̤
    $sql = "SELECT sess_data FROM ".$xoopsDB->prefix("session")." WHERE sess_id='".addSlashes( $sid )."'";
    if( $sid == SID_GUEST && public_item_target_user_all() ) return true;
    if( $result = $xoopsDB -> query( $sql ) ){
        if( $xoopsDB -> getRowsNum( $result ) > 0 ){
            //sess_dataunserialize
            $session_old = array();
            foreach( array_keys($_SESSION) as $key ) // avoid bug http://bugs.php.net/bug.php?id=37926
              $session_old[$key] = $_SESSION[$key];
            list( $sess_data ) = $xoopsDB->fetchRow( $result );
            if( !session_decode( $sess_data ) ){
                $_SESSION = array();
                foreach( array_keys($session_old) as $key )  // avoid bug http://bugs.php.net/bug.php?id=36239
                  $_SESSION[$key] = $session_old[$key];
                //ǥɤ˼ԤΤǡ̵Ƚ
                setLastErrorString( "error can't decode session in xnp_is_valid_session" );
                return false;
            }

            //Ȥݤ
            if( array_key_exists( 'xoopsUserId', $_SESSION ) ){
                //桼Ǥ->valid
                $_SESSION = array();
                foreach( array_keys($session_old) as $key )
                  $_SESSION[$key] = $session_old[$key];
                return true;
            }else{
                //ǥȤOK
                $_SESSION = array();
                foreach( array_keys($session_old) as $key )
                  $_SESSION[$key] = $session_old[$key];
                return public_item_target_user_all();
            }
        }else{
            //åDB̤Ͽ
            //ʥå
            return false;
        }
    }
    return false;
}

/**
 * 
 * ǧڤȥå
 * XOOPSΥƱDBԤ
 * 
 * @param uname ̾
 * @param passwd ѥ(md5)
 * @param session session id뤿ѿΥե
 * @return RES_OK sessionsessionid_t񤭹<br>
 * @return RES_LOGIN_FAILURE 桼activeޤϡunameޤpasswd۾<br>
 * @return RES_DB_QUERY_ERROR DB䤤碌Υ顼
 * 
 */
function xnp_login_user( $uname, $passwd, &$session )
{
	global $xoopsDB;
	global $xoopsUser;
    global $_SESSION;

    $ret = RES_ERROR;
    
    $member_handler =& xoops_gethandler('member');
    $user =& $member_handler->loginUserMD5(addslashes($uname), addslashes($passwd));
    if( $user != false ){
        $session = session_id();
        if( $user->getVar('level') == 0 ){
            $xoopsUser = false;
            $ret = RES_LOGIN_FAILURE;
            unset( $_SESSION['xoopsUserId'] );
        }else if( !xnp_is_activated( $session, $user->getVar('uid') ) ){
            $xoopsUser = false;
            $ret = RES_LOGIN_FAILURE;
            unset( $_SESSION['xoopsUserId'] );
        }else{
            $_SESSION['xoopsUserId'] = $user->getVar('uid');
            $_SESSION['xoopsUserGroups'] = $user->getGroups();
            
            $sess_handler =& xoops_gethandler('session');
            if( $sess_handler -> write( $session, session_encode( ) ) ){
                setLastErrorString( "" );
                $xoopsUser = $user;
                $ret = RES_OK;
            }else{
                setLastErrorString( "error can't write session in xnp_login_user"." at ".__LINE__." in ".__FILE__."\n" );
                $ret = RES_ERROR;
            }
        }
    }else{
        unset( $_SESSION['xoopsUserId'] );
        $ret = RES_LOGIN_FAILURE;
    }
    return $ret;
}


/**
 * 
 * Ȥȥåλ
 * XOOPSΥƱDBԤ
 * 
 * @param sid session id
 * @return ʤ
 * 
 */
function xnp_logout_user( $sid )
{
	global $xoopsDB;
    global $_SESSION;
    
    unset( $_SESSION['xoopsUserId'] );
    $sess_handler =& xoops_gethandler('session');
    if( $sess_handler -> write( $sid, session_encode( ) ) ){
        setLastErrorString( "" );
        $ret = RES_OK;
    }else{
        setLastErrorString( "error can't write session in xnp_logout_user"." at ".__LINE__." in ".__FILE__."\n" );
        $ret = RES_ERROR;
    }
    
/*
    //sess_dataxoopsUserIdξ
    
    $sql = "SELECT sess_data FROM ".$xoopsDB->prefix("session")." WHERE sid=${sid}";
    if( ( $result = $xoopsDB -> query( $sql ) )
        && $xoopsDB -> getRowsNum( $result ) > 0 ){
        //sess_dataunserialize
        list( $sess_data ) = $xoopsDB->fetchRow( $result );
        $data = unserialize( $sess_data );
        unset( $data['xoopsUserID'] );
    }
*/
}


/**
 * 
 * 
 * @param pmid PUBMEDID
 * @param pubmed ̤񤭹Υե
 * 
 */
function xnp_pubmed_complete( $pmid, &$pubmed )
{
    $url = PUBMED_EFETCH_URL_BASE.$pmid;
    $p = new PubmedEfetch( );
    $p -> parse( file_get_contents( $url ), true );
    $pubmed = $p -> result();
    return ( $pubmed !== FALSE ) ? RES_OK : RES_ERROR;
}


/**
 *
 * item_statusơ֥򥯥ꥢxnp_update_item_status¹Ԥ
 *
 */
function xnp_refresh_item_status()
{
	global $xoopsDB;

    $sql = "delete from ".$xoopsDB->prefix("xoonips_item_status")."";
    if( $result = $xoopsDB -> queryF( $sql ) ){
        return xnp_update_item_status();
    }else{
        setLastErrorString( "error in xnp_refresh_item_status"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        return RES_QUERY_ERROR;
    }
}

/**
 * 
 * Х˥ƥɲä
 * 
 * @param sid åID
 * @param binderid оݤΥХID
 * @param iid ХɲäƥID
 * @return RES_OK
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * @return RES_ERROR
 * 
 */
function xnp_register_binder_item( $sid, $binderid, $iid )
{
	global $xoopsDB;

    if( !xnp_is_valid_session_id( $sid ) ) return RES_NO_SUCH_SESSION;
    
    $ret = RES_ERROR;
    
    if( !xnp_get_item_permission( $sid, $binderid, OP_MODIFY ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    
    // register the item.
    $sql = "INSERT IGNORE INTO ".$xoopsDB->prefix("xoonips_binder_item_link")." (binder_id, item_id) values (${binderid}, ${iid})";
    if( $result = $xoopsDB -> queryF( $sql ) ){
        $ret = touchBinder("xnp_register_binder_item", $binderid);
    }else{
        setLastErrorString( "error in xnp_register_binder_item"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = RES_DB_QUERY_ERROR;
    }
    return $ret;
}


/**
 * 
 * ǥå˥ƥɲä.
 * ƥ˽ǧưͭǤɲäƱ˾ǧԤʤ.
 * 
 * @param sid åID
 * @param xid оݤΥǥåID
 * @param iid ǥåɲäƥID
 * @return RES_OK
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * @return RES_ERROR
 * 
 */
function xnp_register_item( $sid, $xid, $iid )
{
	global $xoopsDB;

    if( !xnp_is_valid_session_id( $sid ) ) return RES_NO_SUCH_SESSION;
    
    $ret = RES_ERROR;
    
    if( !xnp_get_index_permission( $sid, $xid, OP_REGISTER ) ){
        return RES_NO_WRITE_ACCESS_RIGHT;
    }
        
    
    // register the item.
    $sql = "INSERT IGNORE INTO ".$xoopsDB->prefix("xoonips_index_item_link")
        ." (index_id, item_id, certify_state) values ( ${xid}, ${iid}, ".getInitialCertifyStateFromConfig( ).")";
    if( $result = $xoopsDB -> queryF( $sql ) ){
        if( $xoopsDB -> getAffectedRows() > 0 ){
            // ƶ줿쥳ɤINSERTʥƥ򥤥ǥå˿ϿˤȤȤʤΤǡlast_update_date򹹿
            // update last update date
            $sql = "UPDATE ".$xoopsDB->prefix("xoonips_item_basic")." SET last_update_date=UNIX_TIMESTAMP(NOW())"
                ." WHERE item_id=${xid}";
            $result = $xoopsDB -> queryF( $sql );
            if ( $result ){
                setLastErrorString( "" );
                $ret = insertMetadataEventAuto( $iid );
                if( $ret != RES_OK ){
                    setLastErrorString( "error in xnp_register_item at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
                }
            }else{
                setLastErrorString( "error can't update last_update_date in xnp_register_item ".$xoopsDB->error()." at ".__LINE__." in ".__FILE__ );
                $ret = RES_DB_QUERY_ERROR;
            }
        }else{
            //ƶ줿Կᥢƥब˥ǥåϿƤΤǡlast_update_dateι⤷ʤ
            $ret = RES_OK;
        }
    }else{
        setLastErrorString( "error can't insert index-item link in xnp_register_item ${sql}".$xoopsDB->error()." at ".__LINE__." in ".__FILE__ );
        $ret = RES_DB_QUERY_ERROR;
    }
    return $ret;
}

/** 
 * 
 * ॹפϰˤ᥿ǡID(OAI-PMHidentifierΤ)֤
 * 
 * @param from, until  ϰ(1970/1/1ηвÿ)  from=0ʤǤŤ狼 until=0ʤ鸽ߤޤ
 * @param startIID     startIID<=item_idǤ褦item_idΤߤ
 * @param limit        ֤item_idθĿξ
 * @param iids         item_id֤Υե(item_idξΤ)
 */
function xnp_selective_harvesting( $from, $until, $startIID, $limit, &$iids )
{
	global $xoopsDB;
    
    $iids = array();
    
    $ret = RES_ERROR;
    
    if ( $limit < 0 ) return RES_ERROR;
    
    $nijc_code = null;
    if( xnp_get_config_value( XNP_CONFIG_REPOSITORY_NIJC_CODE, $nijc_code ) != RES_OK ){
        return RES_ERROR;
    }
    
    $sql = "SELECT stat.item_id, item_type_id FROM ".$xoopsDB->prefix("xoonips_item_status")." AS stat, "
        .$xoopsDB->prefix("xoonips_item_basic")." AS basic WHERE basic.item_id=stat.item_id AND ";
    if( $from  != 0 ) $sql .= "${from} <= unix_timestamp(timestamp) AND ";
    if( $until != 0 ) $sql .= " unix_timestamp(timestamp) <= ${until} AND ";
    $sql .= 
        " stat.item_id >= ${startIID}" 
        ." order by stat.item_id "
        ." limit ${limit}";
    if( $result = $xoopsDB -> query( $sql ) ){
        $iids = array();
        while( list( $iid, $itid ) = $xoopsDB->fetchRow( $result ) ){
            array_push( $iids, "${nijc_code}/${itid}.${iid}" );
        }
        setLastErrorString( "" );
        $ret = RES_OK;
    }
    return $ret;
}


/**
 * 
 * ƥξǧ֤ѹޤ
 * 
 * @param sid åID
 * @param xid ѹоݥƥबϿƤ륤ǥåID
 * @param iid ѹоݥƥID
 * @param state ѹǧ
 * @return RES_OK
 * @return RES_NO_SUCH_ITEM
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * 
 */
function xnp_set_certify_state( $sid, $xid, $iid, $state )
{
	global $xoopsDB;

    if( !xnp_get_certify_permission( $sid, $xid, $iid, $state ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    
    $sql = "UPDATE ".$xoopsDB->prefix("xoonips_index_item_link")
        ." SET certify_state=${state}"
        ." WHERE index_id=${xid} AND item_id=${iid}";
    $result = $xoopsDB -> queryF( $sql );
    if( !$result  ){
        setLastErrorString( "error ".$xoopsDB->error()." in xnp_set_certify_state at ".__LINE__." in ".__FILE__ );
        return RES_DB_QUERY_ERROR;
    }
    return insertMetadataEventAuto( $iid );
}


/**
 * 
 * ̾keyͤvauleꤹ
 * 
 * @param key ꥭ̾
 * @param value 
 * 
 * @return RES_OK
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 */
function xnp_set_config_value( $key, $value )
{
	global $xoopsDB;

    $ret = RES_ERROR;
    
    // nijc_code  guestON/OFF 񤭴Ȥϡitem_statusꥻåȤ롥
    $isNijcOrGuest = ( $key == XNP_CONFIG_REPOSITORY_NIJC_CODE || $key == XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_KEY );
    $oldValue = "";
    if ( $isNijcOrGuest )
        xnp_get_config_value( $key, $oldValue ); //񤭴ͤ¸
    
    $sql = "SELECT * FROM ".$xoopsDB->prefix("xoonips_config")." WHERE name='".addSlashes( $key )."'";
    if( $result = $xoopsDB -> query( $sql ) ){
        if( $xoopsDB -> getRowsNum( $result ) > 0 ){
            //Ʊ̾˥ơ֥¸ߤ
            $sql = " UPDATE ".$xoopsDB->prefix("xoonips_config")." SET value='".addSlashes($value)."' WHERE name='".addSlashes( $key )."'";
            if( $result = $xoopsDB -> queryF( $sql ) ){
                setLastErrorString( "" );
                $ret = RES_OK;
            }else{
                setLastErrorString( "error can't update configuration in xnp_set_config_value"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
                $ret = RES_ERROR;
            }
        }else{
            $sql = "INSERT INTO ".$xoopsDB->prefix("xoonips_config")." (name,value) VALUES ('".addSlashes( $key )."', '".addSlashes( $value )."')";
            if( $result = $xoopsDB -> queryF( $sql ) ){
                setLastErrorString( "" );
                $ret = RES_OK;
            }else{
                setLastErrorString( "error can't insert configuration in xnp_set_config_value"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
                $ret = RES_ERROR;
            }
        }
    }else{
        setLastErrorString( "error in xnp_set_config_value"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = RES_ERROR;
    }
    
    // nijc_code  guestON/OFF 񤭴Ȥϡitem_statusꥻåȤ롥
    if ( $ret == RES_OK && $isNijcOrGuest && ( $oldValue == 0 || $value != $oldValue ) )
        xnp_refresh_item_status();
    
    return $ret;
}

/**
 * 
 * ǥåɤν֤ؤ
 * 
 * @param sid åID
 * @param xid1 ؤǥåɤXID
 * @param xid2 ؤǥåɤXID
 * @return RES_OK 
 *
 */
function xnp_swap_index_sort_number( $sid, $xid1, $xid2 )
{
	global $xoopsDB;
	$xid1 = (int)$xid1;
	$xid2 = (int)$xid2;

    $functionName = "xnp_swap_index_sort_number";
    
    $result = sessionID2UID( $sid, $uid ); // sid  uid 
    if( $result == RES_OK ){
        /*
          xid1, xid2 οƤۤʤʤ顢顼
          xid1, xid2 ξ˽񤭹߸¤뤳Ȥǧ
          ϡ
            tmp1 = x1.sort_number; 
            tmp2 = x2.sort_number; 
            x1.sort_number = 0; // (parent_index_id,sort_number)uniqueʤΤǡö1ѹ롣
            x2.sort_number = tmp1; 
            x1.sort_number = tmp2;
        */
        $index1 = array();
        $index2 = array();
        $result = xnp_get_index( $sid, $xid1, $index1 );
        if ( $result == RES_OK ){
            $result = xnp_get_index( $sid, $xid2, $index2 );
            if ( $result == RES_OK ){
                if ( $index1['parent_index_id'] == $index2['parent_index_id'] ){
                    if ( isWritableInternal( $sid, $uid, $index1 ) && isWritableInternal( $sid, $uid, $index2 ) ){
                        $indexTable = $xoopsDB->prefix("xoonips_index");
                        $sql1 = "UPDATE ".$indexTable." set sort_number=0 WHERE index_id=${xid1}";
                        $sql2 = "UPDATE ".$indexTable." set sort_number=".$index1['sort_number']." WHERE index_id={$xid2}";
                        $sql3 = "UPDATE ".$indexTable." set sort_number=".$index2['sort_number']." WHERE index_id={$xid1}";
                        
                        if( $result = $xoopsDB -> queryF( $sql1 ) ){
                            if( $result = $xoopsDB -> queryF( $sql2 ) ){
                                if( $result = $xoopsDB -> queryF( $sql3 ) ){
                                    ;
                                }
                            }
                        }
                        if ( $result )
                            $result = RES_OK;
                        else
                            $result = RES_DB_QUERY_ERROR;
                    }
                    else {
                        setLastErrorString( "swapIndexSortNumber: not writable"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
                        $result = RES_ERROR;
                    }
                }
                else {
                    setLastErrorString( "swapIndexSortNumber: not brother"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
                    $result = RES_ERROR;
                }
            }
            else {
            }
        }
        else {
        }
    }
    return $result;
}


/**
 * 
 * Х饢ƥ
 * 
 * @param sid åID
 * @param binderid оݤΥХID
 * @param iid ХƥID
 * @return RES_OK
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * @return RES_ERROR
 * 
 */
function xnp_unregister_binder_item( $sid, $binderid, $iid )
{
	global $xoopsDB;
	$binderid = (int)$binderid;
	$iid = (int)$iid;

    if( !xnp_is_valid_session_id( $sid ) ) return RES_NO_SUCH_SESSION;
    
    $ret = RES_OK;
    
    if( !xnp_get_item_permission( $sid, $binderid, OP_MODIFY ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    
    // unregister the item.
    $sql = "DELETE FROM ".$xoopsDB->prefix("xoonips_binder_item_link")
        ." WHERE binder_id=${binderid} AND item_id=${iid}";
    if( $result = $xoopsDB -> queryF( $sql3 ) ){
        $ret = touchBinder("xnp_unregister_binder_item", $binderid);
    }else{
        setLastErrorString( "error in xnp_unregister_binder_item"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = RES_DB_QUERY_ERROR;
    }
    
    if( $ret == RES_OK ) setLastErrorString( "" );
    return $ret;
}

/**
 * 
 * ǥå饢ƥ
 * 
 * @param sid åID
 * @param xid оݤΥǥåID
 * @param iid ǥåƥID
 * @return RES_OK
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_WRITE_ACCESS_RIGHT
 * @return RES_ERROR
 * 
 */
function xnp_unregister_item( $sid, $xid, $iid )
{
	global $xoopsDB;
	$xid = (int)$xid;
	$iid = (int)$iid;

    if( !xnp_is_valid_session_id( $sid ) ) return RES_NO_SUCH_SESSION;
    
    $ret = RES_ERROR;
    
    if( !xnp_get_index_permission( $sid, $xid, OP_UNREGISTER ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    
    // unregister the item.
    $sql = "DELETE FROM ".$xoopsDB->prefix("xoonips_index_item_link")
        ." WHERE index_id=${xid} AND item_id=${iid}";
    if( $result = $xoopsDB -> queryF( $sql ) ){
        // update last update date
        $sql = "UPDATE ".$xoopsDB->prefix("xoonips_item_basic")." SET last_update_date=UNIX_TIMESTAMP(NOW())"
            ." WHERE item_id=${xid}";
        if( $result = $xoopsDB -> queryF( $sql ) ){
            setLastErrorString( "" );
            $ret = RES_OK;
        }else{
            setLastErrorString( "error can't update last_updated_date in xnp_unregister_item"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
            $ret = RES_DB_QUERY_ERROR;
        }
    }
    if ( $ret == RES_OK ){
        $ret = insertMetadataEventAuto( $iid );
        if ( $ret == RES_OK ) setLastErrorString( "" );
    }
    return $ret;
}

/**
 * 
 * Ⱦѹ.
 * $account['uid']ѹоݥ桼ID򥻥åȤƤ
 * 
 * @param sid åID
 * @param account ѹȾ
 * @return RES_OK
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_SUCH_USER
 * @return RES_ERROR
 * 
 */
function xnp_update_account( $sid, $account )
{
    global $xoopsDB;
    
    $account["uid"] = isset($account["uid"]) ? (int)$account["uid"] : 0;
    
    if( !xnp_is_valid_session_id( $sid ) ) return RES_NO_SUCH_SESSION;
    if( !uidExists( $account['uid'] ) ) return RES_NO_SUCH_USER;

    $ret = RES_ERROR;

    $keys = array( "uname",                  "name",                  "email",                  "url",
                   "user_avatar",            "user_regdate",          "user_icq",               "user_from",
                   "user_sig",               "user_viewemail",        "actkey",                 "user_aim",
                   "user_yim",               "user_msnm",             "pass",                   "posts",
                   "attachsig",              "rank",                  "level",                  "theme",
                   "timezone_offset",        "last_login",            "umode",                  "uorder",
                   "notify_method",          "notify_mode",           "user_occ",               "bio",
                   "user_intrest",           "user_mailok" );

    $sets = array();
    foreach( $keys as $k ){
        if( array_key_exists( $k, $account ) ){
            $sets[]= $k."='".addSlashes( $account[$k] )."'";
        }
    }
    $sql = "UPDATE ".$xoopsDB->prefix("users")." SET ".implode(',', $sets)
        ." WHERE uid = ".$account['uid'];
    
    //xoopsΥ桼ơ֥˽񤭹
    if( $result = $xoopsDB -> queryF( $sql ) ){
        setLastErrorString( "" );
        $ret = RES_OK;
    }else{
        setLastErrorString( "error can't update users in xnp_update_account sql=${sql}"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        return $ret;
    }
    
    //xoonipsΥ桼ơ֥˻Ĥξ񤭤
    $keys = array( "activate"     => "activate"     ,"address"           => "address"            ,"division" => "division"  ,"tel" => "tel" ,
                   "company_name" => "company_name" ,"country"           => "country"            ,"zipcode"  => "zipcode"   ,"fax" => "fax" ,
                   "notice_mail"  => "notice_mail"  ,"notice_mail_since" => "notice_mail_since"  ,
                   "private_item_number_limit" => "item_number_limit", "private_index_number_limit" => "index_number_limit", "private_item_storage_limit" => "item_storage_limit" );
    $sets = array();
    foreach( $keys as $col => $k ){
        if( array_key_exists( $k, $account ) ){
            $sets[]= $col."='".addSlashes( $account[$k] )."'";
        }
    }
    $sql = "UPDATE ".$xoopsDB->prefix("xoonips_users")." SET ".implode(',', $sets)
        ." WHERE uid = ".$account['uid'];
    if( $result = $xoopsDB -> queryF( $sql ) ){
        setLastErrorString( "" );
        $ret = RES_OK;
    }else{
        setLastErrorString( "error can't update xoonips_users in xnp_update_account"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = RES_DB_QUERY_ERROR;
    }
    return $ret;
}


/**
 * 
 * 롼׾ѹ
 * 
 * @param sid åID
 * @param group 롼׾
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_SUCH_GROUP
 * @return RES_DB_QUERY_ERROR
 * 
 */
function xnp_update_group( $sid, $group )
{
    global $xoopsDB;
    
    $group["gid"] = isset($group["gid"]) ? (int)$group["gid"] : 0;
    
    if( !xnp_is_valid_session_id( $sid ) ) return RES_NO_SUCH_SESSION;
    if( !gidExists( $group['gid'] ) ) return RES_NO_SUCH_GROUP;
    
    $ret = RES_ERROR;
    
    // examine whether there is already a group name
    $sql = "SELECT gid FROM ".$xoopsDB->prefix("xoonips_groups")." WHERE gname='".addSlashes( $group['gname'] )."' AND gid!=".$group['gid']." AND gid != ".GID_DEFAULT;
    if( $result = $xoopsDB -> query( $sql ) ){
        if( $xoopsDB -> getRowsNum( $result ) > 0 ){
            // already exists
            return RES_GROUPNAME_ALREADY_EXISTS;
        }
    }else{
        setLastErrorString( "error select xoonips_groups in xnp_update_group ".$xoopsDB->error()." sql=${sql}  at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        return RES_DB_QUERY_ERROR;
    }
    
    $keys = array( "gname"=>"gname", "gdesc"=>"gdesc", "group_item_number_limit"=>"item_number_limit", 
        "group_index_number_limit"=>"index_number_limit", "group_item_storage_limit"=>"item_storage_limit" );
    $sets = array();
    foreach( $keys as $col => $k ){
        if( array_key_exists( $k, $group ) ){
            $sets[] = $col."='".addSlashes( $group[$k] )."'";
        }
    }
    $sql = "UPDATE ".$xoopsDB->prefix("xoonips_groups")." SET ".implode(',', $sets)
        ." WHERE gid=".$group['gid'];
    if( $result = $xoopsDB -> queryF( $sql ) ){
        setLastErrorString( "" );
        $ret = RES_OK;
    }else{
        setLastErrorString( "error can't update xoonips_groups in xnp_update_group"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = RES_ERROR;
    }
    
    if( $ret == RES_OK ){
        // update٤index_id
        $sql = "SELECT group_index_id from ".$xoopsDB->prefix("xoonips_groups")." as tg "
            ." left join ".$xoopsDB->prefix("xoonips_item_basic")." as ti on tg.group_index_id = ti.item_id "
            ." left join ".$xoopsDB->prefix("xoonips_index")." as tx on ti.item_id = tx.index_id "
            ." where tg.gid=".$group['gid']
            ."  and ti.item_type_id=".ITID_INDEX
            ."  and tx.parent_index_id=".IID_ROOT;
        if( ($result = $xoopsDB -> query( $sql ))
            && $xoopsDB -> getRowsNum( $result ) > 0 ){
            list( $xid ) = $xoopsDB->fetchRow( $result );
            
            updateTitles( __FUNCTION__, $xid, array( addslashes($group['gname']) ) );
        }else{
            setLastErrorString( "error can't update xoonips_item_basic in xnp_update_group"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
            $ret = RES_DB_QUERY_ERROR;
        }
    }
    return $ret;
}

/**
 * 
 * ǥåɤѹ
 * 
 * @param sid åID
 * @param index ѹ륤ǥå
 * @return RES_OK 
 *
 */
/*
XID񤭴Ȥϡʲա
ƥǥåؤν񤭹߸¤ɬס

ʬޤϤλ¹XIDXIDȤꤹ뤳ȤϤǤʤ
Ƥθΰ褬ѤϡΥǥåȤλ¹θΰѤ롣
*/
function xnp_update_index( $sid, $newIndex )
{
    global $xoopsDB;
    
    $result = RES_ERROR;
    
    $result = sessionID2UID( $sid, $uid ); // sid  uid 
    if( $result != RES_OK ) return $result;
    
    $oldIndex = array();;
    $result = xnp_get_index( $sid, $newIndex['item_id'], $oldIndex );
    if ( $result == RES_OK ){
        $newParentIndex = array();
        $result = xnp_get_index( $sid, $newIndex['parent_index_id'], $newParentIndex );
        if ( $result == RES_OK ){
            $oldParentIndex = array();
            $result = xnp_get_index( $sid, $oldIndex['parent_index_id'], $oldParentIndex );
            if ( $result == RES_OK ){
                $newIndex["item_id"         ] = isset($newIndex["item_id"         ]) ? (int)$newIndex["item_id"         ] : 0;
                $newIndex["item_type_id"    ] = isset($newIndex["item_type_id"    ]) ? (int)$newIndex["item_type_id"    ] : 0;
                $newIndex["contributor_uid" ] = isset($newIndex["contributor_uid" ]) ? (int)$newIndex["contributor_uid" ] : 0;
                $newIndex["title"           ] = isset($newIndex["title"           ]) ? (string)$newIndex["title"           ] : "";
                $newIndex["keywords"        ] = isset($newIndex["keywords"        ]) ? (string)$newIndex["keywords"        ] : "";
                $newIndex["description"     ] = isset($newIndex["description"     ]) ? (string)$newIndex["description"     ] : "";
                $newIndex["last_update_date"] = isset($newIndex["last_update_date"]) ? (int)$newIndex["last_update_date"] : 0;
                $newIndex["creation_date"   ] = isset($newIndex["creation_date"   ]) ? (int)$newIndex["creation_date"   ] : 0;
                $newIndex["parent_index_id" ] = isset($newIndex["parent_index_id" ]) ? (int)$newIndex["parent_index_id" ] : 0;
                $newIndex["owner_uid"       ] = isset($newIndex["owner_uid"       ]) ? (int)$newIndex["owner_uid"       ] : 0;
                $newIndex["owner_gid"       ] = isset($newIndex["owner_gid"       ]) ? (int)$newIndex["owner_gid"       ] : 0;
                $newIndex["open_level"      ] = isset($newIndex["open_level"      ]) ? (int)$newIndex["open_level"      ] : 0;
                $newIndex["sort_number"     ] = isset($newIndex["sort_number"     ]) ? (int)$newIndex["sort_number"     ] : 0;
                $result = updateIndexInternal( $sid, $uid, $newIndex, $oldIndex, $newParentIndex, $oldParentIndex );
            }
            else {
                ;
            }
        }
        else {
            ;
        }
    }
    else {
        ;
    }
    if( $result == RES_OK ){
        setLastErrorString( "" );
    }
    return $result;
}

function updateIndexInternal( $sess_id, $uid, $newIndex, $oldIndex, $newParentIndex, $oldParentIndex ){
	global $xoopsDB;
	$move = ( $newIndex['parent_index_id'] != $oldIndex['parent_index_id'] );
	
	$result = RES_ERROR;
	
	// parent_index_id񤭴Ϲݤʥ顼åԤ
	if ( $move ){
		if ( $oldIndex['item_id'] == IID_ROOT || $oldIndex['parent_index_id'] == IID_ROOT ){
			setLastErrorString( "in updateIndex: cannot change parent_index_id of system-created-index" );
			return RES_ERROR; //ʬRoot뤤ϿƤRootξϡXIDѹǤʤ
		}
		else if ( $newIndex['parent_index_id'] == IID_BINDERS ){
			setLastErrorString( "in updateIndex: parent_index_id must not be BINDERS" );
			return RES_ERROR; // ƤBindersˤ뤳ȤϤǤʤ
		}
		else if ( $newIndex['parent_index_id'] == IID_ROOT ){
			setLastErrorString( "in updateIndex: cannot change parent_index_id to ROOT" );
			return RES_ERROR; // ƤRootǤʤʤ顢ƤRootˤ뤳ȤϤǤʤ
		}
		else if ( $oldIndex['item_id'] == IID_BINDERS && $newParentIndex['open_level'] != OL_PUBLIC ){
			setLastErrorString( "in updateIndex: BINDERS must be public" );
			return RES_ERROR; // BINDERSɬΰ֤ɬפ롣
		}
	}
	
	// ƥǥ쥯ȥ˽񤭹뤫ɤå
	if ( !isWritableInternal( $sess_id, $uid, $newParentIndex ) ){
		setLastErrorString( "in updateIndex: no access right. cannot move." );
		return RES_ERROR; // ưؤν񤭹߸¤ɬס
	}
	
	// sort_numberѹϽʣ̵ɤåưϼưsort_numberΤǥåʤ
	if ( !$move && $newIndex['sort_number'] != $oldIndex['sort_number'] ){
		$conflictIndexes = array();
		$cond = "tx.sort_number=" . $newIndex['sort_number'];
		$result = getIndexesInternal( $sess_id, $cond, $uid, $conflictIndexes, "" );
		if ( $result == RES_OK ){
			if ( count($conflictIndexes) ){
				setLastErrorString( "in updateIndex: sort_number conflicts" );
				return RES_ERROR; // sortNumberνʣ
			}
			else {
				;// sortNumberνʣ̵
			}
		}
		else {
			return $result; // cannot getIndexesInternal()
		}
	}
	
	// ͡titleʸʤ顢͡Ǥʤ
	if ( $newIndex['titles'][DEFAULT_INDEX_TITLE_OFFSET] == '' ){
		setLastErrorString( "in updateIndexInternal: empty title." );
		return RES_ERROR;
	}
	
	if ( $move ){
		$descXID = array();
		
		// ¹xid󡣽۴ĤΥåԤ
		$result = getDescendantIndexID( $oldIndex['item_id'], $descXID );
		if ( $result != RES_OK ){
			setLastErrorString( "in updateIndexInternal: getDescendantIndexID failed" );
			return RES_ERROR;
		}
		
		$descXIDLen = count($descXID);
		for ( $i = 0; $i < $descXIDLen; $i++ ){
			if ( $descXID[$i] == $newIndex['parent_index_id'] ){
				// ¹IndexƤˤ褦Ȥ
				setLastErrorString( "in updateIndexInternal: circular parent" );
				return RES_ERROR;
			}
		}
		
		// sort_number롣
		$result = getNewSortNumber($newParentIndex['item_id'], $sortNumber);
		if ( $result != RES_OK ){
            setLastErrorString( "" );
            return $result;
		}
		$newIndex['sort_number'] = $sortNumber;
	}
	
	$ownerOpenLevelString = ( $newParentIndex['open_level'] );
	$ownerUIDString = ( $newParentIndex['open_level'] == OL_PRIVATE    ? $newParentIndex['owner_uid'] : "NULL" );
	$ownerGIDString = ( $newParentIndex['open_level'] == OL_GROUP_ONLY ? $newParentIndex['owner_gid'] : "NULL" );

	$sql = "UPDATE " . $xoopsDB->prefix( "xoonips_index set" ) .
		" parent_index_id = " . ($newIndex['parent_index_id']) .
		", uid = " . $ownerUIDString .
		", gid = " . $ownerGIDString .
		", open_level = " . $ownerOpenLevelString .
		", sort_number = " . $newIndex['sort_number'] .
		" where index_id = " . $newIndex['item_id'];
	
	if( $xoopsDB->queryF($sql) ){
		$sql = "UPDATE " .  $xoopsDB->prefix( "xoonips_item_basic" ) . " set" .
			" item_type_id = " . $newIndex['item_type_id'] .
			", uid = " . $uid .
			", last_update_date = " . $newIndex['last_update_date'] .
			", creation_date = " . $newIndex['creation_date'] .
			", description = '". addslashes($newIndex['description']) . "'" .
			" where item_id = " . $newIndex['item_id'] ;
			
			
		if( $xoopsDB->queryF( $sql ) ){
			if( !updateTitles( __FUNCTION__, $newIndex['item_id'], $newIndex['titles'] ) ){
				setLastErrorString( "can't update titles. update index incompletely in ".__FUNCTION__." at ".__LINE__." in ".__FILE__ );
				$ret = RES_DB_QUERY_ERROR;
			}else if( !updateKeywords( __FUNCTION__, $newIndex['item_id'], $newIndex['keywords'] ) ){
				setLastErrorString( "can't insert keywords. update index incompletely  in ".__FUNCTION__." at ".__LINE__." in ".__FILE__ );
				$ret = RES_DB_QUERY_ERROR;
			}else{
				setLastErrorString( "" );
        	    $result = RES_OK;
			}
		}
		else {
			setLastErrorString( "error in updateIndexInternal: sql=${sql}"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
			$result = RES_ERROR;
		}
	}
	else {
		setLastErrorString( "error in updateIndexInternal: sql=${sql}"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		$result = RES_ERROR;
	}
	
	if ( $result == RES_OK ){
		if ( $newParentIndex['owner_uid'] != $oldParentIndex['owner_uid'] 
		  || $newParentIndex['owner_gid'] != $oldParentIndex['owner_gid'] 
		  || $newParentIndex['open_level'] != $oldParentIndex['open_level'] ){
			//  Ƥθΰ褬ѤϡΥǥåȤλ¹θΰѤ롣
			$descXID = array();
			$result = getDescendantIndexID( $oldIndex['item_id'], $descXID );
			if ( $result != RES_OK ){
				setLastErrorString( "in updateIndexInternal: getDescendantIndexID failed" );
				return RES_ERROR;
			}
			$descXIDLen = count($descXID);
			for ( $i = 0; $i < $descXIDLen; $i++ ){
				$sql = "UPDATE " . $xoopsDB->prefix( "xoonips_index" ) . " set ".
				  " uid=" . $ownerUIDString .
				  ", gid=" . $ownerGIDString .
				  ", open_level=" . $ownerOpenLevelString .
				  " WHERE index_id=" . ($descXID[$i]);
				querySimple( "updateIndex", $sql );
			}
		}
	}
	
	if ( $newIndex['open_level'] == OL_PUBLIC ){
		// newIndexʲξǧѤߥƥˤĤ insertMetadataEventAuto Ԥ
		$descXID = array();
		$result = getDescendantIndexID( $newIndex['item_id'], $descXID );
		if ( $result != RES_OK ){
			setLastErrorString( "in updateIndex: getDescendantIndexID failed" );
			return RES_ERROR; 
		}
		
		$xid_str = getCsvStr( $descXID );
		if ( count( $descXID ) == 0 )
			return RES_OK;
		
		$sql = 
		  "select distinct item_id from " . $xoopsDB->prefix( "xoonips_index_item_link " ) .
		  " where certify_state = " . CERTIFIED .
		  "  and index_id in ( $xid_str )";
		$result2 = $xoopsDB->query( $sql );
		if ( $result2 ){
			$result = RES_OK;
			while ( list( $iid ) = $xoopsDB->fetchRow($result2) ){
				$result = insertMetadataEventAuto( $iid );
				if ( $result != RES_OK )
					break;
			}
		}
		else {
			setLastErrorString( "error in updateIndexInternal: sql=${sql}"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
			return RES_DB_QUERY_ERROR;
		}
	}
	
    if( $result == RES_OK ) setLastErrorString( "" );
	return $result;
}



/**
 * 
 * ƥ(Basic Information)򹹿.
 * ˤϥƥԤǥ졼¤ɬס
 * itemitem_idåȤ뤳.
 * 
 * @param sid åID
 * @param item ƥξ
 * @param update_certify falseʤcertify_stateѹʤtrueʤѹ
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_NO_WRITE_ACCESS_RIGHT
 */
function xnp_update_item( $sid, $item, $update_certify = true )
{
    global $xoopsDB;
    
    $item['item_id'] = (int)$item['item_id'];
    
    if( !xnp_is_valid_session_id( $sid ) ) return RES_NO_SUCH_SESSION;
    if( !isActivatedBySession( $sid ) ) return RES_NO_WRITE_ACCESS_RIGHT;
    
    $ret = RES_ERROR;
    
    $sess_uid = 0;
    if( sessionID2UID( $sid, $sess_uid ) == RES_OK ){
        if( $sess_uid != $item['uid'] && !isModeratorBySession( $sid ) )
            return RES_NO_WRITE_ACCESS_RIGHT;//no permissions to delete this item
    }else{
        return RES_ERROR;
    }
    
    $keys = array( "item_type_id", "description", "doi", "uid",
                   "last_update_date", "publication_year", "publication_month", "publication_mday", "lang" );
    $sets = array();
    foreach( $keys as $k ){
        if( array_key_exists( $k, $item ) ){
            $sets[] = $k."='".addSlashes( $item[$k] )."'";
        }
    }
    $sql = "UPDATE ".$xoopsDB->prefix("xoonips_item_basic")." SET ".implode( ', ', $sets )
        ." WHERE item_id=".$item['item_id'];
    $result = $xoopsDB -> queryF( $sql );
    if( !$result ){
        setLastErrorString( "error can't update xoonips_item_basic in xnp_update_item"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = RES_DB_QUERY_ERROR;
    }
    //
    // update title and insert new title
    if( !updateTitles( __FUNCTION__, $item['item_id'], $item['titles'] ) ){
        setLastErrorString( "can't insert titles in ".__FUNCTION__." at ".__LINE__." in ".__FILE__ );
        $ret = RES_DB_QUERY_ERROR;
    }
//      $i = 0;
//      foreach( $item['titles'] as $title ){
//          $sql = "INSERT INTO ".$xoopsDB->prefix("xoonips_item_title")." ( ${item['item_id']}, ${i}, '".addslashes( $title )."'";
//          $result = $xoopsDB -> queryF( $sql );
//          if( !$result ){
//              $sql = "UPDATE ".$xoopsDB->prefix("xoonips_item_title")." SET title='".addslashes( $title )
//                  ." WHERE item_id=${item['item_id']} AND title_id=${i}";
//              $result = $xoopsDB -> queryF( $sql );
//              setLastErrorString( "error can't update xoonips_item_title in xnp_update_item"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
//              $ret = RES_DB_QUERY_ERROR;
//          }
//          $i++;
//      }
//      //delete removed titles
//      $sql = "DELETE FROM ".$xoopsDB->prefix("xoonips_item_title")." WHERE item_id=${item['item_id']} and title_id >= ${i}";
//      $result = $xoopsDB -> queryF( $sql );
//      if( !$result ){
//          setLastErrorString( "error can't delete removed title in xoonips_item_title in xnp_update_item"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
//          $ret = RES_DB_QUERY_ERROR;
//      }
    //
    // update keyword and insert new keyword
    if( !updateKeywords( __FUNCTION__, $item['item_id'], $item['keywords'] ) ){
        setLastErrorString( "can't insert keywords in ".__FUNCTION__." at ".__LINE__." in ".__FILE__ );
        $ret = RES_DB_QUERY_ERROR;
    }
//      $i = 0;
//      foreach( $item['keywords'] as $keyword ){
//          $sql = "UPDATE ".$xoopsDB->prefix("xoonips_item_keyword")." SET keyword='".addslashes( $keyword )
//              ." WHERE item_id=${item['item_id']} AND keyword_id=${i}";
//          $result = $xoopsDB -> queryF( $sql );
//          if( !$result ){
//              $sql = "INSERT INTO ".$xoopsDB->prefix("xoonips_item_keyword")." ( ${item['item_id']}, ${i}, '".addslashes( $keyword )."'";
//              $result = $xoopsDB -> queryF( $sql );
//              setLastErrorString( "error can't insert into xoonips_item_keyword in xnp_update_item"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
//              $ret = RES_DB_QUERY_ERROR;
//          }
//          $i++;
//      }
//      //delete removed keywords
//      $sql = "DELETE FROM ".$xoopsDB->prefix("xoonips_item_keyword")." WHERE item_id=${item['item_id']} and keyword_id >= ${i}";
//      $result = $xoopsDB -> queryF( $sql );
//      if( !$result ){
//          setLastErrorString( "error can't delete removed keyword in xoonips_item_keyword in xnp_update_item"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
//          $ret = RES_DB_QUERY_ERROR;
//      }
    
    $certify_item_val = '';
    if ( $update_certify == false ){
        $ret = RES_OK;
    }
    else if( xnp_get_config_value( XNP_CONFIG_CERTIFY_ITEM_KEY, $certify_item_val ) == RES_OK ){
        $certify_state = getInitialCertifyStateFromConfig( );
        //update certify state
        $sql = "SELECT index_item_link_id "
            ." FROM ".$xoopsDB->prefix("xoonips_index_item_link")." as tlink "
            ." LEFT JOIN ".$xoopsDB->prefix("xoonips_index")." as tx ON tlink.index_id=tx.index_id "
            ." LEFT JOIN ".$xoopsDB->prefix("xoonips_item_basic")." as ti ON tlink.item_id=ti.item_id "
            ." WHERE (tx.open_level=".OL_PUBLIC
            ." OR tx.open_level=".OL_GROUP_ONLY
            .") AND tlink.item_id=".$item['item_id'];
        if( ( $result = $xoopsDB -> query( $sql ) )
            && $xoopsDB -> getRowsNum( $result ) > 0 ){
            while( list( $registered_index_id ) = $xoopsDB->fetchRow( $result ) ){
                $sql = "UPDATE ".$xoopsDB->prefix("xoonips_index_item_link")
                    ." SET certify_state=${certify_state}"
                    ." WHERE index_item_link_id=${registered_index_id}";
                $xoopsDB -> queryF( $sql );
            }
        }
        $ret = insertMetadataEventAuto( $item['item_id'], true );
    }else{
        setLastErrorString( "error xnp_get_config_value in xnp_update_item"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        $ret = RES_ERROR;
    }
    
    return $ret;
}


/**
 * 
 * OAI-PMHǸ뤿Υ᥿ǡξ(ǽե饰ʤ)ǿξ˹
 * 
 */
function xnp_update_item_status()
{
    global $xoopsDB;
    
    $ret = RES_ERROR;
    
    if ( public_item_target_user_all() ){
        // ƥबѤߤǡitem_statusޤ¸ߤΤΤ
        //  select distinct txil.item_id, tis.is_deleted from x_xoonips_index as tx,x_xoonips_index_item_link as txil left join x_xoonips_item_status as tis on txil.item_id = tis.item_id  where  tx.index_id=txil.index_id and  txil.certify_state = 2 and  tx.open_level = 1;
        $sql = "select distinct txil.item_id, tis.is_deleted "
            ." from ".$xoopsDB->prefix("xoonips_index")." as tx, "
            . $xoopsDB->prefix("xoonips_index_item_link")." as txil "
            ." left join ".$xoopsDB->prefix("xoonips_item_status")." as tis on txil.item_id = tis.item_id "
            ." where  tx.index_id=txil.index_id "
            ." and  txil.certify_state = ".CERTIFIED
            ." and  tx.open_level = ".OL_PUBLIC;
        if( $result = $xoopsDB -> query( $sql ) ){
            while( list( $iid, $isDeleted ) = $xoopsDB->fetchRow( $result ) ){
                if ( $isDeleted == null )
                    $sql = "insert into ".$xoopsDB->prefix("xoonips_item_status")
                        ."( item_id, created_timestamp, is_deleted ) values "
                        ."( ${iid}, unix_timestamp(now()), 0 )";
                else
                    $sql = "update ".$xoopsDB->prefix("xoonips_item_status")
                        ." set created_timestamp=unix_timestamp(now()), is_deleted=0 "
                        ." where item_id=${iid}";
                if( $result2 = $xoopsDB -> queryF( $sql ) ){
                    setLastErrorString( "" );
                    $ret = RES_OK;
                }else{
                    return RES_DB_QUERY_ERROR;
                }
            }
        }
        else{
            return RES_DB_QUERY_ERROR;
        }
        
        // ƥबǡitem_status.is_deleted=0ΤΤ
        // select tis.item_id, count(tx.index_id) as public_count from x_xoonips_item_status as tis  left join x_xoonips_index_item_link as tl on tl.item_id = tis.item_id and certify_state = 2 left join x_xoonips_index           as tx on tx.index_id =tl.index_id and tx.open_level = 1 where is_deleted=0 group by tis.item_id having pubilc_count=0 ;
        $sql = "select tis.item_id, count(tx.index_id) as public_count "
            ." from ".$xoopsDB->prefix("xoonips_item_status")." as tis  "
            ." left join ".$xoopsDB->prefix("xoonips_index_item_link")." as tl on tl.item_id = tis.item_id and certify_state = ".CERTIFIED
            ." left join ".$xoopsDB->prefix("xoonips_index")."           as tx on tx.index_id =tl.index_id and tx.open_level = ".OL_PUBLIC
            ." where is_deleted=0 group by tis.item_id having public_count=0 ";
        if( $result = $xoopsDB -> query( $sql ) ){
            while( list( $iid ) = $xoopsDB->fetchRow( $result ) ){
                $sql = "update ".$xoopsDB->prefix("xoonips_item_status")." "
                    ." set is_deleted=1, deleted_timestamp=unix_timestamp(now()) "
                    ." where item_id=${iid}";
                if( $result2 = $xoopsDB -> queryF( $sql ) ){
                    setLastErrorString( "" );
                    $ret = RES_OK;
                }else{
                    $ret = RES_DB_QUERY_ERROR;
                    berak;
                }
            }
        }
        else{
            $ret = RES_DB_QUERY_ERROR;
        }
    }
    else {
        $sql = "delete from ".$xoopsDB->prefix("xoonips_item_status");
        if( $result = $xoopsDB -> queryF( $sql ) ){
            setLastErrorString( "" );
            $ret = RES_OK;
        }else{
            $ret = RES_DB_QUERY_ERROR;
        }
    }
    return $ret;
}




/** SQL¹Ԥ롣̤ϼΤƤ롣
  * @param sql sql
  * @return result_t
  */
function querySimple( $functionName, $sql )
{
	global $xoopsDB;
	$result = $xoopsDB->queryF( $sql );
	if ( !$result ){
		setLastErrorString( "error in $functionName, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	setLastErrorString( "" );
	return RES_OK;
}

/** SQL¹Ԥ1ܤκǽ(NULLʤ0Ȥߤʤ)Τ߼롣
  * @param sql sql
  * @param uint   ͤѿ
  * @return result_t
  */
function queryGetUnsignedInt( $functionName, $sql, &$uint )
{
	global $xoopsDB;
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in $functionName, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	if ( $xoopsDB->getRowsNum( $result ) == 0 )
		return RES_ERROR;
	list( $uint ) = $xoopsDB->fetchRow( $result );
	setLastErrorString( "" );
	return RES_OK;
}


/** ǻѡxidλ¹(xidޤ)ΥǥåIDƼ.
 * @param xid о
 * @param descXID ¹
 */
function getDescendantIndexID( $xid, &$descXID )
{
	global $xoopsDB;
	
	/* 
		descXID[0]  descXID[i-1] : õѤߥΡ
		descXID[i]  descXID[iFill-1] : ̤õΡɡ줬ˤʤõλ
	*/
	$descXID = array( $xid );
	$i = 0;
	$iFill = 1;
	
	while ( $i < $iFill ){
		$xid = $descXID[$i++];// ̤õΡɤ1ļФ
		
		// Ҥ󤷤̤õΡɤȤɲá
		$sql = "SELECT index_id FROM " . $xoopsDB->prefix( "xoonips_index" ) . " WHERE parent_index_id=$xid" ;
		$result = $xoopsDB->query( $sql );
		if ( !$result ){
			setLastErrorString( "error in getDescendantIndexID, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
			return RES_DB_QUERY_ERROR;
		}
		
		while ( list( $xid ) = $xoopsDB->fetchRow( $result ) ){
			$descXID[$iFill++] = $xid;
		}
	}
	
	setLastErrorString( "" );
	return RES_OK;
}

/**  implode( ',', descXID ) ηʸ롣
 * @param descXID   int. intintȤߤʤ
 */
function getCsvStr( $descXID )
{
	if ( count( $descXID ) ){
		$ar = array();
		foreach ( $descXID as $val )
			$ar[] = (int)$val;
		return implode( ',', $ar );
	}
	return '';
}

/**
 * 
 * Platform桼uid¸ߤ뤫å.
 * DBΥԤʤɤfalseȤʤ롥
 * 
 * @param uid åUID
 * @return true ¸ߤ
 * @return false ¸ߤʤ
 * 
 */
function uidExists( $uid )
{
	global $xoopsDB;
	$sql = "SELECT uid FROM " . $xoopsDB->prefix( "xoonips_users" ) . " WHERE uid=$uid";
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in uidExists, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return false;
	}
	return ( $xoopsDB->getRowsNum($result) != 0 );
}

/**
 * 
 * gid¸ߤå.
 * DBΥԤʤɤfalseȤʤ롥
 * 
 * @param gid åGID
 * @return true ¸ߤ
 * @return false ¸ߤʤ
 * 
 */
function gidExists( $gid )
{
	global $xoopsDB;
	
	$sql = "SELECT gid FROM " . $xoopsDB->prefix( "xoonips_groups" ) . " WHERE gid=$gid";
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in uidExists, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return false;
	}
	return ( $xoopsDB->getRowsNum($result) != 0 );
}

/**
 * 
 * uidοͤ(ownerUID,ownerGID,openLevel)Υǥå˽񤭹ย¤뤫ɤĴ٤롣
 * 
 * @param uid åID
 * @param ownerUID indexͭ
 * @param ownerGID indexͭ롼
 * @param openLevel 
 * @return RES_OK 
 *
 */
function isWritableInternal2( $sess_id, $uid, $ownerUID, $ownerGID, $openLevel ){
	// todo: ٤褦ʤisGroupAdmin,isModeratorȤ鷺ˤʤȤ
	if ( $openLevel == OL_PUBLIC ){
	}
	else if ( $openLevel == OL_GROUP_ONLY ){
		if ( xnp_is_group_admin( $sess_id, $ownerGID, $uid ) )
			return true;
	}
	else if ( $openLevel == OL_PRIVATE ){
		if ( $uid == $ownerUID )
			return true;
	}
	if ( xnp_is_moderator($sess_id, $uid) )
		return true;
	
	return false;
}

function isWritableInternal( $sess_id, $uid, $index )
{
	return isWritableInternal2( $sess_id, $uid, $index['owner_uid'], $index['owner_gid'], $index['open_level'] );
}

function insertMetadataEvent( $me, $iid )
{
    global $xoopsDB;
    
	if ( $me == ME_CREATED ){
		$sql = "replace " . $xoopsDB->prefix( "xoonips_item_status " ) . 
		 " ( item_id, created_timestamp, modified_timestamp, deleted_timestamp, is_deleted ) values " .
		 " ( $iid, unix_timestamp(now()), NULL, NULL, 0 )";
	}
	else if ( $me == ME_MODIFIED ){
		$sql = "update " . $xoopsDB->prefix( "xoonips_item_status " ) . 
		 " set modified_timestamp=unix_timestamp(now()), is_deleted=0 where item_id=$iid";
	}
	else if ( $me == ME_DELETED ){
		$sql = "update " . $xoopsDB->prefix( "xoonips_item_status " ) . 
		 " set deleted_timestamp=unix_timestamp(now()), is_deleted=1 where item_id=$iid";
	}
	else {
		return RES_ERROR;
	}
	return querySimple( "insertMetadataEvent", $sql );
}

/** ŬڤinsertMeatadataEventԤ
 * repository		 item
 * is_deleted==0  &&  public	: isCreate ? ME_CREATED : ME_MODIFIED;
 * is_deleted==0  &&  nonpublic : ME_DELETED
 * is_deleted!=0  &&  public	: ME_CREATED
 * is_deleted!=0  &&  nonpubic  : -
 * 
 */
function insertMetadataEventAuto( $iid, $isCreate = false )
{
	global $xoopsDB;
	
	$status = array();
	$res = xnp_get_item_status( $iid, $status );
	if ( $res != RES_OK ){
		if ( $res == RES_NO_SUCH_ITEM )
			$status['is_deleted'] = 1;
		else
			return $res;
	}
	//guest饢Ǥ뤫(/Public򥲥Ȥ˸꤬ͭ/Public°륢ƥफ)
	//$isPublic = xnp_get_item_permission( SID_GUEST, $iid, OP_READ );
	$value = '';
	if( ( $res = xnp_get_config_value( XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_KEY, $value ) ) != RES_OK ){
		return $res;
	}
	if( $value != XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_ALL ){
		$isPublic = false;
	}else{
		$sql = "SELECT * FROM ". $xoopsDB->prefix( "xoonips_index" )." AS tx, "
			.$xoopsDB->prefix( "xoonips_index_item_link" ) . " AS tlink"
			." WHERE tlink.item_id=${iid}"
			." AND tlink.index_id=tx.index_id"
			." AND tlink.certify_state=".CERTIFIED
			." AND tx.open_level=".OL_PUBLIC;
		$result = $xoopsDB->query( $sql );
		if ( $result ){
			$isPublic = ( $xoopsDB->getRowsNum( $result ) > 0 );
		}else{
			$isPublic = false;
		}
	}

	if ( $status['is_deleted'] == 0 ){
		if ( $isPublic )
			$me = $isCreate ? ME_CREATED : ME_MODIFIED;
		else
			$me = ME_DELETED;
	}
	else {
		if ( $isPublic )
			$me = ME_CREATED;
		else{
        	setLastErrorString( "" );
			return RES_OK;
        }
	}
	
    $res = insertMetadataEvent( $me, $iid );
    if( $res == RES_OK ){
        setLastErrorString( "" );
    }
    return $res;
}

/**
 * 
 * åбդ줿桼ǥ졼Ǥ뤫
 * 
 * 
 * @param sess_id åID
 * @return true ǥ졼
 * @return false ǥ졼Ǥʤޤϥ顼
 *
 */
function isModeratorBySession( $sess_id )
{
	if( sessionID2UID( $sess_id, $sess_uid ) == RES_OK ){
		return xnp_is_moderator( $sess_id, $sess_uid );
	}
	return false;
}

/**
 * SQL¹Ԥ̤ιԿ֤
 */
function countResultRows( $sql, &$count )
{
	global $xoopsDB;
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in uidExists, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	$count = $xoopsDB->getRowsNum($result);
	setLastErrorString( "" );
	return RES_OK;
}

/**
 * 
 * åбդ줿桼Platform桼ȤActivate
 * Ƥ뤫֤.
 *
 * XOOPSδԤϾtrue֤.
 *
 * @param sess_id åID
 * @return true ActivateƤ
 * @return false ActivateƤ롤ޤϥ顼
 *
 */
function isActivatedBySession( $sess_id )
{
	if( sessionID2UID( $sess_id, $sess_uid ) == RES_OK ){
		return xnp_is_activated( $sess_id, $sess_uid );
	}
    setLastErrorString( "error can't get uid from session id in isActivatedBySession"." at ".__LINE__." in ".__FILE__."\n" );
	return false;
}

/** siduid롣
  * @param sess_id  xoops session id 
  * @param sess_uid uidѿ
  * @return RES_OK  
  *   sess_idͭsessionidǤ롣ξsess_uidˤͭuid롣
  *   뤤ϡGuestͭ sess_id̵Ǥ롣ξ硢sess_uidˤUID_GUEST(=0)롣
  * @return ¾			顼
  */
function sessionID2UID( $sess_id, &$sess_uid )
{
	global $xoopsDB;
	
	if ( $sess_id == session_id() ){ // sessionUID褦ȤƤ
		if ( isset($_SESSION['xoopsUserId']) ){
			$sess_uid = $_SESSION['xoopsUserId'];
			setLastErrorString( "" );
			return RES_OK;
		}
	}
	else { // ¾sessionUID褦ȤƤ
		$esc_sess_id = addslashes( session_id() );
		$sql = "select sess_data from " . $xoopsDB->prefix('session') . " where sess_id='$esc_sess_id'";
		$result = $xoopsDB->query( $sql );
		
		if ( !$result )
			return RES_DB_QUERY_ERROR;
		if ( $xoopsDB->getRowsNum($result) ){
			list( $sess_data ) = $xoopsDB->fetchRow( $result );
			$bak = $_SESSION;
			session_decode( $sess_data );
			$s = $_SESSION;
			$_SESSION = $bak;
			if ( isset($s['xoopsUserId']) ){
				$sess_uid = $s['xoopsUserId'];
				setLastErrorString( "" );
				return RES_OK;
			}
		}
	}
	
	// session_id()̵ޤ$_SESSION['xoopsUserId']̵餯GuestǤ롥
	if ( public_item_target_user_all() ){
		$sess_uid = UID_GUEST;
        setLastErrorString( "" );
        return RES_OK;
	}
	return RES_NO_SUCH_SESSION;
}

/**
 * 
 * public_item_target_userͤ'all'ʤtrue򤫤
 * ͤμ˼Ԥ硤'all'ʳξfalse򤫤
 * 
 */
function public_item_target_user_all( ){
	$public_item_target_user_all = false;
	if( xnp_get_config_value( XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_KEY, $value ) == RES_OK ){
		$public_item_target_user_all = ( strcmp( $value, XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_ALL ) == 0 );
	}
	return $public_item_target_user_all;
}




/** activate롣<br>
	bool xnp_activate( string sess_id, int user_id, bool activated )
	@param sess_id   xoops  session id
	@param user_id   xoops_users.uid
	@param activated  true:activate, false:inactivate
	@return RES_OK success
  */
function xnp_activate( $sess_id, $uid, $activated )
{
	global $xoopsDB;
	
    if( $sess_id != SID_GUEST && !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;

	// allow guest to activate account if account is certified automatically
	$certify_user = XNP_CONFIG_CERTIFY_USER_ON;
	$result = xnp_get_config_value( XNP_CONFIG_CERTIFY_USER_KEY, $certify_user );
	if( $result != RES_OK ) return $result;
	if( $sess_id == SID_GUEST 
		&& $certify_user != XNP_CONFIG_CERTIFY_USER_AUTO ) return RES_NO_SUCH_SESSION;
	else if( $sess_id != SID_GUEST && !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	
	$uid = (int)$uid;
	$sql = "UPDATE " . $xoopsDB->prefix("xoonips_users") . 
	  " SET activate=" . ( $activated ? "1" : "0" ) .
	  " WHERE uid=${uid}";
	$result = $xoopsDB->queryF( $sql );
	if ( !$result ){
		setLastErrorString( "error in activate, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__ );
		return RES_DB_QUERY_ERROR;
	}
	
	queryGetUnsignedInt( "xnp_activate", "select count(*) from " . $xoopsDB->prefix("xoonips_users") . " where uid=$uid", $n );
	if ( $n == 0 ){
		setLastErrorString( "error in activate, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__ );
		return RES_NO_SUCH_USER;
	}
	setLastErrorString( "" );
	return RES_OK;
}


$amazon_ctx = array();

function amazonStartElement($parser, $name, $attribs)
{
	global $amazon_ctx;
	$amazon_ctx['tagstack'][] = $name;
}

function amazonEndElement($parser, $name)
{
	global $amazon_ctx;
	$tags = "/".implode( '/', $amazon_ctx['tagstack'] );
	switch ( $tags ){
	case '/ITEMLOOKUPRESPONSE/ITEMS/ITEM/ITEMATTRIBUTES/AUTHOR': 
		$amazon_ctx['authors'][] = $amazon_ctx[$tags];
		$amazon_ctx[$tags] = '';
	}
	
	array_pop( $amazon_ctx['tagstack'] );
}

function amazonCharacterData($parser, $data)
{
	global $amazon_ctx;
	$tags = "/".implode( '/', $amazon_ctx['tagstack'] );
	switch ( $tags ){
	case '/ITEMLOOKUPRESPONSE/ITEMS/ITEM/ITEMATTRIBUTES/PUBLICATIONDATE':
	case '/ITEMLOOKUPRESPONSE/ITEMS/ITEM/ITEMATTRIBUTES/AUTHOR':
	case '/ITEMLOOKUPRESPONSE/ITEMS/ITEM/ITEMATTRIBUTES/TITLE':
	case '/ITEMLOOKUPRESPONSE/ITEMS/ITEM/ITEMATTRIBUTES/PUBLISHER':
	case '/ITEMLOOKUPRESPONSE/ITEMS/ITEM/DETAILPAGEURL':
	case '/ITEMLOOKUPRESPONSE/ITEMS/ITEM/ASIN':
		$amazon_ctx[$tags] .= $data;
	}
}



/**
 * request attributes of book to amazon.
 *
 * @param url url of item lookup request of Amazon ECS4.0
 * @param amazonbook reference of associative array to get item attributes.
 *
 * url like 'http://webservices.amazon.com/onca/xml?Service=AWSECommerceService&AWSAccessKeyId=0H8BRF5MB0Z590ZPWA82&Operation=ItemLookup&IdType=ASIN&ItemId=0553212788&MerchantId=All&ResponseGroup=Medium'
 *
 */
function xnp_amazon_complete( $url, &$amazonbook )
{
	$amazonbook = array();
	
	$parser = xml_parser_create( "UTF-8" );
	if( !$parser )
		return RES_ERROR;
	xml_set_element_handler($parser, "amazonStartElement", "amazonEndElement"); 
	xml_set_character_data_handler($parser, "amazonCharacterData"); 
	global $amazon_ctx;
	$amazon_ctx = array(
		'/ITEMLOOKUPRESPONSE/ITEMS/ITEM/ITEMATTRIBUTES/TITLE'              => '',
		'/ITEMLOOKUPRESPONSE/ITEMS/ITEM/ITEMATTRIBUTES/AUTHOR'             => '',
		'/ITEMLOOKUPRESPONSE/ITEMS/ITEM/ITEMATTRIBUTES/PUBLICATIONDATE'    => '',
		'/ITEMLOOKUPRESPONSE/ITEMS/ITEM/ITEMATTRIBUTES/PUBLISHER'          => '',
		'/ITEMLOOKUPRESPONSE/ITEMS/ITEM/ASIN'                              => '',
		'/ITEMLOOKUPRESPONSE/ITEMS/ITEM/DETAILPAGEURL'                     => '',
		'authors' => array()
	);
	
	$h = fopen( $url, 'rb' );
	if ( !$h ){
		setLastErrorString( "can't open $url" );
		return RES_ERROR;
	}
	$result = RES_OK;
	while ( !feof( $h ) ){
		$buf = fread( $h, 4096 );
		if ( !xml_parse( $parser, $buf, feof($h) ) ){
			setLastErrorString( xml_error_string( xml_get_error_code( $parser ) ) );
			$result = RES_ERROR;
			break;
		}
	}
	
	if ( $result == RES_OK ){
		$amazonbook = array(
			'title'     => $amazon_ctx['/ITEMLOOKUPRESPONSE/ITEMS/ITEM/ITEMATTRIBUTES/TITLE'        ],
			'publisher' => $amazon_ctx['/ITEMLOOKUPRESPONSE/ITEMS/ITEM/ITEMATTRIBUTES/PUBLISHER'    ],
			'isbn'      => $amazon_ctx['/ITEMLOOKUPRESPONSE/ITEMS/ITEM/ASIN'         ],
			'author'    => implode( ", ", $amazon_ctx['authors'] ),
			'url'       => $amazon_ctx['/ITEMLOOKUPRESPONSE/ITEMS/ITEM/DETAILPAGEURL']
		);
		
		if( !empty( $amazon_ctx['/ITEMLOOKUPRESPONSE/ITEMS/ITEM/ITEMATTRIBUTES/PUBLICATIONDATE'] ) ){
			$ar = explode( '-', $amazon_ctx['/ITEMLOOKUPRESPONSE/ITEMS/ITEM/ITEMATTRIBUTES/PUBLICATIONDATE'] );
            // yyyy-mm-dd or yyyy-mm form
			if ( count( $ar ) == 2 || count( $ar ) == 3 ){
				list( $amazonbook['year_of_publication'] ) = sscanf( $ar[0], '%d' );
			}else{
				$amazonbook['year_of_publication'] = '';
			}
		}else{
			$amazonbook['year_of_publication'] = '';
		}
	}
	
	fclose( $h );
	xml_parser_free( $parser );
	if( $result == RES_OK ) setLastErrorString( "" );
	return $result;
}
/*
$ar = array();
xnp_amazon_complete( "http://xml.amazon.co.jp/onca/xml3?t=neuroinfbasep-22&dev-t=0H8BRF5MB0Z590ZPWA82&type=lite&f=xml&AsinSearch=4938455285&locale=jp", $ar );
var_dump( $ar );
*/


/** XOOPSΥåID <br>
	int xnp_create_session( string xoops_sess_id, int uid, int &session )
	@param xoops_sess_id  xoopsΥåID
	@param uid  xoops  uid (xoops_users.uid)
	@param session  xoopsΥåID
	@return 0 
	
	ext_search.php ξϤɤ뤫 
		
  */
function xnp_create_session( $sess_id, $uid, &$session )
{
	$session = $sess_id;
	setLastErrorString( "" );
	return RES_OK;
}

/** Ȥ롣<br>
	bool xnp_delete_account( string sess_id, int uid )
	@param sess_id   XOOPSΥåID
	@param uid   xoops_users.uid
	@return RES_OK success
  */
function xnp_delete_account( $sess_id, $uid )
{
	$uid = (int)$uid;

	global $xoopsDB;
	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	
	$ret1 = RES_OK;
	$ret2 = RES_OK;
	
	/*
	  1. delete user from default platform group
	  2. delete user profile from xoops_users
	  3. delete platform user from xoonips_users
	 */
	
	//1. delete user from platform groups
	$sql = "delete from " . $xoopsDB->prefix("xoonips_groups") . " where uid=$uid";
	$xoopsDB->queryF( $sql );
	
	//2. delete user profile from xoops_users
	$sql = "delete from " . $xoopsDB->prefix("users") . " where uid=$uid";
	$result = $xoopsDB->queryF( $sql );
	if ( !$result ){
		setLastErrorString( "error in deleteAccount, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		$ret1 = RES_DB_QUERY_ERROR;
	}
	else if ( $xoopsDB->getAffectedRows() == 0 ){
		setLastErrorString( "error in deleteAccount, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		$ret1 = RES_NO_SUCH_USER;
	}
	
	//3. delete platform user from xoonips_users
	$sql = "delete from ".$xoopsDB->prefix("xoonips_users") . " where uid = $uid";
	$result = $xoopsDB->queryF( $sql );
	if ( !$result ){
		setLastErrorString( "error in deleteAccount, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		$ret2 = RES_DB_QUERY_ERROR;
	}
	else if ( $xoopsDB->getAffectedRows() == 0 ){
		setLastErrorString( "error in deleteAccount, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		$ret2 = RES_NO_SUCH_USER;
	}
	
	//Ǥ⥨顼ʤ饨顼֤
    if( $ret1 == RES_OK && $ret2 == RES_OK ) setLastErrorString( "" );
    return $ret1 != RES_OK ? $ret1 : $ret2;
}

/** 롼׾롣<br>
	int xnp_delete_group( string sess_id, int gid )
	@param sess_id      XOOPSΥåID
	@param gid      롼פID
	@return RES_OK
	@return RES_DB_QUERY_ERROR
	@return RES_NO_SUCH_SESSION
	@return RES_DB_NOT_INITIALIZED
  */
function xnp_delete_group( $sess_id, $gid )
{
	$gid = (int)$gid;

	global $xoopsDB;
	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	
	//delete group
	$sql = "delete from " . $xoopsDB->prefix("xoonips_groups") . " where gid=$gid";
	$result = $xoopsDB->queryF( $sql );
	if ( !$result ){
		setLastErrorString( "error in xnp_delete_group, ".$xoopsDB->error()." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	
	//delete members
	$sql = "delete from " . $xoopsDB->prefix("xoonips_groups_users_link") . " where gid=$gid";
	$result = $xoopsDB->queryF( $sql );
	if ( !$result ){
		setLastErrorString( "error in xnp_delete_group, ".$xoopsDB->error()." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	//delete ranking data
	$sql = "delete from " . $xoopsDB->prefix("xoonips_ranking_new_group") . " where gid=$gid";
	$result = $xoopsDB->queryF( $sql );
	if ( !$result ){
		setLastErrorString( "error in xnp_delete_group, ".$xoopsDB->error()." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	$sql = "delete from " . $xoopsDB->prefix("xoonips_ranking_sum_new_group") . " where gid=$gid";
	$result = $xoopsDB->queryF( $sql );
	if ( !$result ){
		setLastErrorString( "error in xnp_delete_group, ".$xoopsDB->error()." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	$sql = "delete from " . $xoopsDB->prefix("xoonips_ranking_sum_active_group") . " where gid=$gid";		
	$result = $xoopsDB->queryF( $sql );
	if ( !$result ){
		setLastErrorString( "error in xnp_delete_group, ".$xoopsDB->error()." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	$sql = "delete from " . $xoopsDB->prefix("xoonips_ranking_active_group") . " where gid=$gid";
	$result = $xoopsDB->queryF( $sql );
	if ( !$result ){
		setLastErrorString( "error in xnp_delete_group, ".$xoopsDB->error()." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}

	// 
	// delete group indexes
	// 
	$sql = "select index_id from " . $xoopsDB->prefix("xoonips_index") . " where gid=$gid";
	$result = $xoopsDB->queryF( $sql );
	if ( $xoopsDB->getRowsNum($result) ){
		$index_ids = array();
		while( list( $id ) = $xoopsDB->fetchRow( $result ) ){
			$index_ids[] = $id;
		}
	}
	if ( !$result ){
		setLastErrorString( "error in xnp_delete_group, ".$xoopsDB->error()." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	if( count( $index_ids ) > 0 ){
		//delete group related data(index, item_basic, title, keyword, index_item_link)
		$sql = "delete from " . $xoopsDB->prefix("xoonips_index") . " where index_id in ( " . implode( ", ", $index_ids ) . " )";
		$result = $xoopsDB->queryF( $sql );
		if ( !$result ){
			setLastErrorString( "error in xnp_delete_group, ".$xoopsDB->error()." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
			return RES_DB_QUERY_ERROR;
		}

		$sql = "delete from " . $xoopsDB->prefix("xoonips_item_basic") . " where item_id in ( " . implode( ", ", $index_ids ) . " )";
		$result = $xoopsDB->queryF( $sql );
		if ( !$result ){
			setLastErrorString( "error in xnp_delete_group, ".$xoopsDB->error()." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
			return RES_DB_QUERY_ERROR;
		}

		$sql = "delete from " . $xoopsDB->prefix("xoonips_item_title") . " where item_id in ( " . implode( ", ", $index_ids ) . " )";
		$result = $xoopsDB->queryF( $sql );
		if ( !$result ){
			setLastErrorString( "error in xnp_delete_group, ".$xoopsDB->error()." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
			return RES_DB_QUERY_ERROR;
		}

		$sql = "delete from " . $xoopsDB->prefix("xoonips_item_keyword") . " where item_id in ( " . implode( ", ", $index_ids ) . " )";
		$result = $xoopsDB->queryF( $sql );
		if ( !$result ){
			setLastErrorString( "error in xnp_delete_group, ".$xoopsDB->error()." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
			return RES_DB_QUERY_ERROR;
		}

		$sql = "delete from " . $xoopsDB->prefix("xoonips_index_item_link") . " where item_id in ( " . implode( ", ", $index_ids ) . " )";
		$result = $xoopsDB->queryF( $sql );
		if ( !$result ){
			setLastErrorString( "error in xnp_delete_group, ".$xoopsDB->error()." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
			return RES_DB_QUERY_ERROR;
		}
	}
	
	setLastErrorString( "" );
	return RES_OK;
}

function deleteIndexInternal( $sess_id, $xid, &$index, &$descXID, &$affectedIIDs )
{
	$functionName = "deleteIndex";
	global $xoopsDB;
	$uid = $_SESSION['xoopsUserId'];
	
	$affectedIIDs = array();
	$index = array();
	$result = xnp_get_index( $sess_id, $xid, $index );
	if ( $result != RES_OK )
		return $result;
	
	$parentXid = $index['parent_index_id'];
	
	if ( $index['item_id'] == IID_ROOT || $parentXid == IID_ROOT ){
		setLastErrorString( "in deleteIndex: cannot delete system-created-index."." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_ERROR;
	}
	
	if ( !isWritableInternal( $sess_id, $uid, $index ) ){
		setLastErrorString( "in deleteIndex: no write access right."." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_NO_WRITE_ACCESS_RIGHT;
	}
	
	// оݤ
	$result = getDescendantIndexID( $xid, $descXID );
	if ( $result != RES_OK ){
		setLastErrorString( "in deleteIndex: getDescendantIndexID failed"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_ERROR; 
	}
	
	// оݤBindersäƤϡǤʤ
	if ( in_array( IID_BINDERS, $descXID ) ){
		setLastErrorString( "in deleteIndex: target index contains Binders."." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_ERROR;
	}
	
	$affectedIIDs = array();
	if ( $index['open_level'] == OL_PUBLIC ){
		// newIndexʲξǧѤߥƥ򵭲Ƥ Ȥ insertMetadataEventAuto Ԥ
		$sql = "select count(*) from " . $xoopsDB->prefix("xoonips_item_basic");
		$iidsLen = 0;
		$result = queryGetUnsignedInt( $functionName, $sql, $iidsLen );
		if ( $result != RES_OK )
			return $result;
		if ( count( $descXID ) ){
			$xid_str = getCsvStr( $descXID );
			$sql = "select item_id from " . $xoopsDB->prefix("xoonips_index_item_link") . 
			  " where certify_state=" . CERTIFIED . 
			  " and index_id in ( $xid_str ) ";
			
			$result = $xoopsDB->query( $sql );
			if ( !$result )
				return RES_DB_QUERY_ERROR;
			
			while ( list ( $iid ) = $xoopsDB->fetchRow( $result ) )
				$affectedIIDs[] = $iid;
		}
	}
	
	
	for ( $i = count($descXID)-1; $i >= 0; $i-- ){ // ˤơǼԤλɤdescXIDͥõ¤ǤΤǡ
		$xid = $descXID[$i];
		$linkTable = $xoopsDB->prefix( "xoonips_index_item_link" );
		$indexTable = $xoopsDB->prefix( "xoonips_index" );
		
		// descXID[i]Privateʲ && descXID[i]ΥƥI򻲾ȤPrivateindex1Ĥʤ  I»Ҥˤʤʤ褦˿Ƥ˰ư
		if ( $index['open_level'] == OL_PRIVATE ){
			$sql = "SELECT t1.index_item_link_id, t1.item_id, count(*) ".
				" FROM $linkTable  AS t1 ".
				" LEFT JOIN $linkTable AS t2 ON t1.item_id = t2.item_id ".
				" LEFT JOIN $indexTable AS tx2 on t2.index_id = tx2.index_id ".
				" WHERE t1.index_id=$xid ". 
				  " and tx2.open_level = " . OL_PRIVATE .
				  " group by t1.item_id ";
			$result = $xoopsDB->query( $sql );
			if ( !$result ){
				setLastErrorString( "in deleteIndex: target index contains Binders." ." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
				return RES_ERROR;
			}
			
			while ( list( $link_id, $item_id, $count) = $xoopsDB->fetchRow( $result ) ){
				if ( $count == 1 ){
					$sql2 = "UPDATE $linkTable set index_id= $parentXid where index_item_link_id = $link_id";
					$result2 = querySimple( "deleteIndex", $sql2 );
					if( $result2 != RES_OK )
						break;
				}
			}
		}
		
		// descXID[i] Υƥƺ
		$sql = "DELETE from $linkTable where index_id=$xid";
		$result = querySimple( $functionName, $sql );
		if ( $result == RES_OK ){
			// descXID[i] 
			$sql = "DELETE from " . $xoopsDB->prefix("xoonips_item_basic") . " where item_id = $xid";
			$result = querySimple( $functionName, $sql );
			if ( $result == RES_OK ){
				$sql = "DELETE from " . $xoopsDB->prefix("xoonips_index") . " where index_id = $xid";
				$result = querySimple( $functionName, $sql );
			}
			// delete title
			$sql = "DELETE from " . $xoopsDB->prefix("xoonips_item_title") . " where item_id = $xid";
			$result = querySimple( $functionName, $sql );
			// delete keyword
			$sql = "DELETE from " . $xoopsDB->prefix("xoonips_item_keyword") . " where item_id = $xid";
			$result = querySimple( $functionName, $sql );
		}
	}
	
	// ƶϤΥƥ insertMetadataEventAuto
	$len = count($affectedIIDs);
	for ( $i = 0; $i < $len; $i++ )
		insertMetadataEventAuto( $affectedIIDs[$i] );

	if( $result == RES_OK ) setLastErrorString( "" );
	return $result;
}


/** ǥå<br>
 *   int xnp_delete_index( string sess_id, int index_id );
 * @param sess_id XOOPSΥåID
 * @param index_id 륤ǥå
 * @return RES_OK
 */
function xnp_delete_index( $sess_id, $index_id )
{
	$index = array();
	$descXID = array();
	$affectedIIDs = array();
	
	return deleteIndexInternal( $sess_id, (int)$index_id, $index, $descXID, $affectedIIDs );
}

/**
 *
 * ƥ(Basic Information).
 *
 * @param sess_id åID
 * @param item_id ƥitem_id
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_WRITE_ACCESS_RIGHT
 */
function xnp_delete_item( $sess_id, $item_id )
{
	$item_id = (int)$item_id;

	global $xoopsDB;
	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	if( !isActivatedBySession( $sess_id ) ) return RES_NO_WRITE_ACCESS_RIGHT;
	
	// retrieve an item's owner uid
	$item = array();
	if( xnp_get_item( $sess_id, $item_id, $item ) != RES_OK )
		return RES_NO_WRITE_ACCESS_RIGHT;//no permissions to delete this item
	$item_uid = $item['uid'];
	
	$sess_uid = false;
	if( sessionID2UID( $sess_id, $sess_uid ) == RES_OK ){
		if( $sess_uid != $item_uid && !isModeratorBySession( $sess_id ) )
			return RES_NO_WRITE_ACCESS_RIGHT;//no permissions to delete this item
	}else{
		return RES_ERROR;
	}

	/*
	  1. delete item from index keywords
	  2. delete item from binders
	  3. delete item 
	  4. delete title
	  5. delete keyword
	  6. delete item from related_to 
	  7. delete item changelog
	*/
	
	//1. delete item from index keywords
	$sql = "DELETE FROM " . $xoopsDB->prefix("xoonips_index_item_link") .
	   " WHERE item_id = $item_id ";
	$result = $xoopsDB->queryF( $sql );
	if ( !$result ){
		setLastErrorString( "error in xnp_delete_item, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	else if ( $xoopsDB->getAffectedRows() == 0 ){
		return RES_NO_SUCH_ITEM;
	}
	
	//2. delete item from binders
	// unregisterBinderItemȤȤϤǤʤʤʤunregisterBinderItemBinderlast_update_date񤭴Ƥޤ顥
	$sql = "DELETE FROM " . $xoopsDB->prefix( "xoonips_binder_item_link") . " WHERE item_id = $item_id";
	$result = $xoopsDB->queryF( $sql );
	if ( !$result ){
		setLastErrorString( "error in xnp_delete_item, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}

	// 3. delete item 
	$sql = "DELETE FROM " . $xoopsDB->prefix( "xoonips_item_basic") . " WHERE item_id = $item_id ";
	$result = $xoopsDB->queryF( $sql );
	if ( !$result ){
		setLastErrorString( "error in xnp_delete_item, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	else if ( $xoopsDB->getAffectedRows() == 0 ){
		return RES_NO_SUCH_ITEM;
	}
	
	// 4. delete title
	$sql = "DELETE FROM " . $xoopsDB->prefix( "xoonips_item_title") . " WHERE item_id = $item_id ";
	$result = $xoopsDB->queryF( $sql );
	if ( !$result ){
		setLastErrorString( "error in xnp_delete_item, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	
	// 5. delete keyword
	$sql = "DELETE FROM " . $xoopsDB->prefix( "xoonips_item_keyword") . " WHERE item_id = $item_id ";
	$result = $xoopsDB->queryF( $sql );
	if ( !$result ){
		setLastErrorString( "error in xnp_delete_item, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	
	// 6. delete records from related_to
	$sql = "DELETE FROM " . $xoopsDB->prefix("xoonips_related_to") . " WHERE parent_id = $item_id";
	$result = $xoopsDB->queryF( $sql );
	if ( !$result ){
        setLastErrorString( "error can't delete related to in xnp_delete_item, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        return RES_DB_QUERY_ERROR;
    }

	// 7. delete changelog
	$sql = "DELETE FROM " . $xoopsDB->prefix("xoonips_changelog") . " WHERE item_id = $item_id";
	$result = $xoopsDB->queryF( $sql );
	if ( $result ){
		insertMetadataEventAuto( $item_id );
	}else{
        setLastErrorString( "error can't delete related to in xnp_delete_item, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
        return RES_DB_QUERY_ERROR;
    }

	setLastErrorString( "" );
	return RES_OK;
}

/** 롼פС롣<br>
	int xnp_delete_member(string sess_id, int gid, int uid )
	@param sess_id      XOOPSΥåID
	@param gid XNPΥ롼ID
	@param uid  桼ID
	@return RES_OK success
  */

function xnp_delete_member( $sess_id, $gid, $uid )
{
	$gid = (int)$gid;
	$uid = (int)$uid;

	global $xoopsDB;
	if( $gid == GID_DEFAULT ) return RES_ERROR;

	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	if( !uidExists( $uid ) ) return RES_NO_SUCH_USER; //uid¸ߤå
	if( !gidExists( $gid ) ) return RES_NO_SUCH_GROUP; //gid¸ߤå
	
	$sql = "DELETE FROM " . $xoopsDB->prefix("xoonips_groups_users_link") . " WHERE gid=$gid AND uid=$uid";
	$result = $xoopsDB->queryF( $sql );
	if ( !$result ){
		setLastErrorString( "error in deleteMember, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	else if ( $xoopsDB->getAffectedRows() == 0 ){
		setLastErrorString( "error in deleteMember, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_NO_SUCH_USER;
	}
	setLastErrorString( "" );
	return RES_OK;
}

/**
 * ƥ֥󥯤롥
 *
 * int xnp_delete_related_to( string sess_id, int parent_id, int item_id )
 * @param sess_id åID
 * @param parent_id 󥯸ΥƥID
 * @param item_id ΥƥID
 * @return RES_OK
 * @return RES_ERROR
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_WRITE_ACCESS_RIGHT parentidԽǤʤƥ򤵤Ƥ롤<br/>ޤitemidǤʤƥؤƤ롤<br/>ޤ XooNIps桼Ǥʤ(activateԤ)
 *
 */
function xnp_delete_related_to( $sess_id, $parent_id, $item_id )
{
	global $xoopsDB;
    
	$parent_id = (int)$parent_id;
	$item_id = (int)$item_id;

	global $xoopsDB;
	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	if( !isActivatedBySession( $sess_id ) ) return RES_NO_WRITE_ACCESS_RIGHT;
	if( !xnp_get_item_permission( $sess_id, $parent_id, OP_MODIFY ) ) return RES_NO_WRITE_ACCESS_RIGHT;
	
	$sql = "DELETE FROM " . $xoopsDB->prefix("xoonips_related_to") . " WHERE parent_id=$parent_id AND item_id = $item_id";
    $result = $xoopsDB -> queryF( $sql );
	if ( !$result ){
		setLastErrorString( "error in deleteRelatedTo, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	setLastErrorString( "" );
	return RES_OK;
}

/** ˰פ륰롼פgidΰ롣<br>
	int xnp_dump_gids( string sess_id, array criteria, array gids );
	@param sess_id   XOOPSΥåID
	@param criteria  ϰϡȽɽ
	@param gids gid
	@return RES_OK success
  */
function xnp_dump_gids( $sess_id, $criteria, &$gids )
{
	global $xoopsDB;
	$gids = array();

	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	$sql = "SELECT gid FROM " . $xoopsDB->prefix( "xoonips_groups" ) .  " WHERE gid != " . GID_DEFAULT . ' ' . criteria2str( $criteria );
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in xnp_dump_gids, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	
	while ( list( $gid ) = $xoopsDB->fetchRow( $result ) ){
		$gids[] = $gid;
	}
	setLastErrorString( "" );
	return RES_OK;
}

/** gidǻꤷ롼פδԤǡľ˰פ륰롼״Ԥuidΰ롣<br>
	int xnp_dump_group_admins(string sess_id, int group_id, array criteria, array uids )
	@param sess_id      XOOPSΥåID
	@param group_id XNPΥ롼ID
	@param criteria 
	@param uids     uidΰ
	@return RES_OK success
  */

function xnp_dump_group_admins( $sess_id, $gid, $criteria, &$uids )
{
	$gid = (int)$gid;
	$uids = array();
	global $xoopsDB;
    
	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	
	$sql = "SELECT uid FROM " . $xoopsDB->prefix( "xoonips_groups_users_link" ) . " WHERE is_admin=1 and gid=$gid" . criteria2str( $criteria );
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in xnp_dump_group_admins, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	$uids = array();
	while ( list( $uid ) = $xoopsDB->fetchRow( $result ) ){
		$uids[] = $uid;
	}
	setLastErrorString( "" );
	return RES_OK;
}

/**
 * 
 * ƥIDΰ.
 * ǽʥƥID֤.
 * 
 * @param sess_id åID
 * @param criteria ̤ϰϻꡤȾ
 * @param iids ̤񤭹
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * 
 */
function xnp_dump_item_id( $sess_id, $criteria, &$iids )
{
	global $xoopsDB;

	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	$ret = sessionID2UID( $sess_id, $uid );
	if( $ret != RES_OK ) return $ret;

	$sql = "SELECT DISTINCT ti.item_id as item_id, tt.title as title";
	$sql.= " FROM ";
	$sql.= $xoopsDB->prefix( "xoonips_index_item_link" ) . " AS tlink ";
	$sql.= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_index" ) . " AS tx ON tlink.index_id = tx.index_id";
	$sql.= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_item_basic" ) . " AS ti ON tlink.item_id = ti.item_id";
	$sql.= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_item_title" ) . " AS tt ON tt.item_id=ti.item_id";
	$sql.= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_groups_users_link" ) . " as tgulink ON tx.gid=tgulink.gid";
	$sql.= " WHERE ( " . ( public_item_target_user_all( ) ? "1" : "0" );
	$sql.=       " AND tx.open_level=" . OL_PUBLIC . " AND ".( !isset( $_SESSION['xoopsUserId'] ) ? '1' : '0' );
	$sql.=       " AND certify_state=" . CERTIFIED ;
	$sql.=    " OR " . ( !public_item_target_user_all( ) ? "1" : "0" );
	$sql.=       " AND tx.open_level=" . OL_PUBLIC . " AND ".( isset( $_SESSION['xoopsUserId'] ) ? '1' : '0' );
	$sql.=       " AND certify_state=" . CERTIFIED ;
	$sql.=    " OR tx.open_level=" . OL_GROUP_ONLY ;
	$sql.=      " AND tgulink.uid=$uid";
	$sql.=      " AND ( certify_state=" . CERTIFIED;
	$sql.=           ( xnp_is_moderator( $sess_id, $uid ) ? " OR 1" : " OR 0" ); //ǥ졼ʤOR 1ʳ OR 0
	$sql.=           " OR tgulink.is_admin=1 )"; //롼״Ԥ
	if( $uid != UID_GUEST ) $sql.= " AND tgulink.uid=$uid";
	$sql.=    " OR tx.open_level=" . OL_PRIVATE ;
	$sql.=       " AND tx.uid=$uid";
	$sql.=    " OR tx.uid IS NULL ";
	$sql.=      " AND tx.open_level=" . OL_PUBLIC ;
	$sql.=      " AND ( certify_state=" . CERTIFIED ;
	$sql.=           ( xnp_is_moderator( $sess_id, $uid ) ? " OR 1 )" : " OR 0 )" ); //ǥ졼ʤOR 1ʳ OR 0
	$sql.= ( xnp_is_moderator( $sess_id, $uid ) ? " OR 1" : " OR 0" ); //ǥ졼ʤOR 1ʳ OR 0
	$sql.=    ") ";
	$sql.= " AND ti.item_type_id != " . ITID_INDEX ; //
	$sql.= " AND tt.title_id=".DEFAULT_ORDER_TITLE_OFFSET;
	$sql.= criteria2str( $criteria );
	//	
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in dumpItemID, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	
	$iids = array();
	while ( list( $iid ) = $xoopsDB->fetchRow( $result ) ){
		$iids[] = $iid;
	}
	
	setLastErrorString( "" );
	return RES_OK;
}

/**
 * 
 * criteria_tǻꤵ줿ϰϤΥ桼ID֤.
 * uids˥桼IDݤƤ˽񤭹.
 * 
 * @param sess_id åID
 * @param criteria ̤ϰϻꡤȾ
 * @param uids 桼UIDν
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @see freeUID
 */
function xnp_dump_uids( $sess_id, $criteria, &$uids )
{
	global $xoopsDB;
	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	
	$sql = "SELECT uid FROM " . $xoopsDB->prefix( "xoonips_users" );
	$sql .= " ".criteria2str( $criteria );
	$result = $xoopsDB->query( $sql );
	if( $result ){
        $uids = array();
        while ( list( $uid ) = $xoopsDB->fetchRow( $result ) ){
            $uids[] = $uid;
        }
        setLastErrorString( "" );
        return RES_OK;
    }else{
		setLastErrorString( "error in xnp_dump_uids, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
}

/**
 * ƥID椫顤BinderǤʤΤ.
 *
 * int xnp_extract_nonbinder_item_id( string sess_id, array iids, array nonbinder_iids )
 * @param sess_id åID
 * @param iids item_id
 * @param nonbinder_iids ̤
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 *
 */
function xnp_extract_nonbinder_item_id( $sess_id, $iids, &$nonbinder_iids )
{
	global $xoopsDB;
	$nonbinder_iids = array();
    
	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	
	$ret = sessionID2UID( $sess_id, $uid );
	if( $ret != RES_OK ) return $ret;
	$iids_str = getCsvStr( $iids );
	
	$nonbinder_iids = array();
	if ( count( $iids ) == 0 )
		return RES_OK;
	$sql = 
	  "select ti.item_id " .
	  "  from  " . $xoopsDB->prefix( "xoonips_item_basic") . " as ti where " .
	  "  ti.item_id in ( $iids_str ) and ti.item_type_id <> " . ITID_BINDER;
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in xnp_extract_nonbinder_item_id, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	while ( list( $iid ) = $xoopsDB->fetchRow( $result ) ){
		$nonbinder_iids[] = $iid;
	}
	setLastErrorString( "" );
	return RES_OK;
}

/**
 * ƥID椫顤ΤΤ.
 *
 * int xnp_extract_public_item_id( string sess_id, array iids, array public_iids )
 * @param sess_id åID
 * @param iids item_id
 * @param public_iids ̤
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 *
 */
function xnp_extract_public_item_id( $sess_id, $iids, &$public_iids )
{
	global $xoopsDB;
	$public_iids = array();
    
	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	
	$ret = sessionID2UID( $sess_id, $uid );
	if( $ret != RES_OK ) return $ret;
	$iids_str = getCsvStr( $iids );
	
	$public_iids = array();
	if ( count( $iids ) == 0 )
		return RES_OK;
	$sql = 
	  "select ti.item_id, count(tx.index_id) ".
	  "  from      " . $xoopsDB->prefix( "xoonips_item_basic" ) . "      as ti   ".
	  "  left join " . $xoopsDB->prefix( "xoonips_index_item_link" ) . " as txil on ti.item_id=txil.item_id and txil.certify_state = " . CERTIFIED .
	  "  left join " . $xoopsDB->prefix( "xoonips_index" ) . "           as tx   on txil.index_id=tx.index_id and tx.open_level = "  . OL_PUBLIC .
	  "  where " .
	  " ti.item_id in ( $iids_str )" .
	  "  group by ti.item_id ";

	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in xnp_extract_nonbinder_item_id, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	while ( list( $iid, $ct ) = $xoopsDB->fetchRow( $result ) ){
		if ( $ct != 0 )
			$public_iids[] = $iid;
	}
	return RES_OK;
}

/** Ⱦ롣<br>
	int xnp_get_account( string sess_id, int uid, array account )
	@param sess_id   XOOPSΥåID
	@param uid   xoops_users.uid
	@param account ȾϢ
	@return RES_OK success
  */
function xnp_get_account( $sess_id, $uid, &$account )
{
	$accounts = array();
	$account = array();
	$result = xnp_get_accounts( $sess_id, array((int)$uid), array(), $accounts );
	if ( isset( $accounts[0] ) )
		$account = $accounts[0];
	return $result;
}


/** XNPΥȿ롣<br>
	int xnp_get_account_count( int sess_id )
	@param sess_id   XOOPSΥåID
	@return RES_OK success
  */
function xnp_get_account_count( $sess_id )
{
	global $xoopsDB;
	if( !xnp_is_valid_session_id( $sess_id ) ) return 0;
	
	//ȿ
	$sql = "SELECT COUNT(*) FROM " . $xoopsDB->prefix( "xoonips_users" );
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in getAccountCount, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return 0;
	}
	list( $count ) = $xoopsDB->fetchRow( $result );
	return $count;
}

/** ˰פ륢Ȥξ롣<br>
	int xnp_get_accoutns( string sess_id, array uids, array criteria, array accounts );
	@param sess_id   XOOPSΥåID
	@param uids      uiduidsǤʤʤ餳ˤuidΤ߼롥uidsʤuid롥
	@param criteria  ϰϡȽɽ
	@param accounts ȾϢ
	@return RES_OK success
  */
function xnp_get_accounts( $sess_id, $uids, $criteria, &$accounts )
{
	global $xoopsDB;
    $accounts = array();
	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	
	$accounts = array();
	if ( count($uids) == 0 )
		return RES_OK;
	
	$sql = "SELECT u1.uid, u1.name, u1.uname, u1.email, u1.url, u1.user_avatar, u1.user_regdate, u1.user_icq, u1.user_from, u1.user_sig, u1.user_viewemail, u1.actkey, u1.user_aim, u1.user_yim, u1.user_msnm, u1.pass, u1.posts, u1.attachsig, u1.rank, u1.level, u1.theme, u1.timezone_offset, u1.last_login, u1.umode, u1.uorder, u1.notify_method, u1.notify_mode, u1.user_occ, u1.bio, u1.user_intrest, u1.user_mailok, u2.activate, u2.address, u2.division, u2.tel, u2.company_name, u2.country, u2.zipcode, u2.fax, u2.notice_mail, u2.notice_mail_since, u2.private_index_id, u2.private_item_number_limit, u2.private_index_number_limit, u2.private_item_storage_limit ".
	 " FROM " . $xoopsDB->prefix("users") . " AS u1, " . $xoopsDB->prefix("xoonips_users") . " AS u2 ".
	 " WHERE u1.uid = u2.uid ";
	if( count($uids) ){
		$sql .= " AND u1.uid in ( " . getCsvStr($uids) . " ) ";
	}
	$sql .= criteria2str( $criteria );
	//	
	//	
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in getAccounts, ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	
	while ( $row = $xoopsDB->fetchRow( $result ) ){
		$account = array();
		$account['uid'               ] = $row[ 0];
		$account['name'              ] = $row[ 1];
		$account['uname'             ] = $row[ 2];
		$account['email'             ] = $row[ 3];
		$account['url'               ] = $row[ 4];
		$account['user_avatar'       ] = $row[ 5];
		$account['user_regdate'      ] = $row[ 6];
		$account['user_icq'          ] = $row[ 7];
		$account['user_from'         ] = $row[ 8];
		$account['user_sig'          ] = $row[ 9];
		$account['user_viewemail'    ] = $row[10];
		$account['actkey'            ] = $row[11];
		$account['user_aim'          ] = $row[12];
		$account['user_yim'          ] = $row[13];
		$account['user_msnm'         ] = $row[14];
		$account['pass'              ] = $row[15];
		$account['posts'             ] = $row[16];
		$account['attachsig'         ] = $row[17];
		$account['rank'              ] = $row[18];
		$account['level'             ] = $row[19];
		$account['theme'             ] = $row[20];
		$account['timezone_offset'   ] = $row[21];
		$account['last_login'        ] = $row[22];
		$account['umode'             ] = $row[23];
		$account['uorder'            ] = $row[24];
		$account['notify_method'     ] = $row[25];
		$account['notify_mode'       ] = $row[26];
		$account['user_occ'          ] = $row[27];
		$account['bio'               ] = $row[28];
		$account['user_interest'     ] = $row[29];
		$account['user_mailok'       ] = $row[30];
		$account['activate'          ] = $row[31];
		$account['address'           ] = $row[32];
		$account['division'          ] = $row[33];
		$account['tel'               ] = $row[34];
		$account['company_name'      ] = $row[35];
		$account['country'           ] = $row[36];
		$account['zipcode'           ] = $row[37];
		$account['fax'               ] = $row[38];
		$account['notice_mail'       ] = $row[39];
		$account['notice_mail_since' ] = $row[40];
		$account['private_index_id'  ] = $row[41];
		$account['item_number_limit' ] = $row[42];
		$account['index_number_limit'] = $row[43];
		$account['item_storage_limit'] = $row[44];
		$accounts[] = $account;
	}
	setLastErrorString( "" );
	return RES_OK;
}


/**
 * 
 * ˰פ륤ǥåΰ롣
 * 
 * @param cond SQLξＰά0 Ｐtx(index), ti(item), tlink(group_user_link) Ѳǽ
 * @param uid  uidɤ߹߸¤Ĥ褦ʥǥåΤ߼롣
 * @param indexes ǥåΰ֤
 * @param criteriaString SQLorder,limit
 * @return RES_OK 
 *
 */
function getIndexesInternal( $sess_id, $cond, $uid, &$indexes, $criteriaString )
{
	global $xoopsDB;
	
	$groupTable = $xoopsDB->prefix( "xoonips_groups" );
	$groupUserLinkTable = $xoopsDB->prefix( "xoonips_groups_users_link" );
	$indexTable = $xoopsDB->prefix( "xoonips_index" );
	$itemTable = $xoopsDB->prefix( "xoonips_item_basic" );
	$titleTable = $xoopsDB->prefix( "xoonips_item_title" );
	if ( $cond == false )
		$cond = " 1 ";
	
	$accessRightCond = "1";
	if ( !xnp_is_moderator( $sess_id, $uid ) )
		$accessRightCond =
			" (  tx.open_level=1 " .
			" OR tx.open_level=2 AND tlink.uid is not NULL AND tx.gid != " . GID_DEFAULT .
			" OR tx.open_level=3 AND tx.uid = $uid )"; // ɽSQL
	
	$sql = "SELECT tx.index_id as item_id, tx.parent_index_id, tx.uid, tx.gid, tx.open_level, tx.sort_number ".
		" , ti.item_type_id, ti.creation_date, ti.uid, ti.description, ti.last_update_date, tt.title as title ".
		" FROM      $titleTable as tt, " .
		" $indexTable  AS tx " .
		" LEFT JOIN $itemTable   AS ti on tx.index_id = ti.item_id " .
		" LEFT JOIN $groupUserLinkTable  AS tlink on tlink.gid = tx.gid and tlink.uid = $uid " .
		" LEFT JOIN $groupTable  AS tg on tx.gid = tg.gid " .
		" WHERE $accessRightCond AND ( tx.open_level != 2 OR tx.open_level = 2 AND tg.gid IS NOT NULL ) ".
		" AND tt.title_id=".DEFAULT_ORDER_TITLE_OFFSET." AND tt.item_id=ti.item_id" .
		" AND $cond $criteriaString";

	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in getIndexesInternal ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	
	$index_buf = array();
	$orderd_ids = array(); //array of sorted item_id(s) to sort $index_buf in the end of this function
	while ( list( $index_id, $parent_index_id, $owner_uid, $gid, $open_level, $sort_number, 
		$item_type_id, $creation_date, $contributor_uid, $description, $last_update_date ) = $xoopsDB->fetchRow( $result ) ){
		$index = array(
			'item_id'          => $index_id        ,
			'parent_index_id'  => $parent_index_id ,
			'owner_uid'        => ( $owner_uid == NULL ) ? 0 : $owner_uid ,
			'owner_gid'        => ( $gid == NULL ) ? 0 : $gid ,
			'open_level'       => $open_level      ,
			'sort_number'      => $sort_number     ,
			'item_type_id'     => $item_type_id    ,
			'creation_date'    => $creation_date   ,
			'contributor_uid'  => $contributor_uid ,
			'titles'           => array()          ,
			'keywords'         => array()          ,
			'description'      => $description     ,
			'last_update_date' => $last_update_date,
		);
		$index_buf[$index_id] = $index;
		$orderd_ids[] = $index_id;
	}

	if( count( $index_buf ) > 0 ){
		//get titles of selected item
		$sql = "SELECT item_id, title FROM " . $xoopsDB->prefix( "xoonips_item_title" )
			. " WHERE item_id IN ( " . implode( ",", array_keys( $index_buf ) ) . " ) ORDER BY item_id ASC, title_id ASC";
		$result = $xoopsDB->query( $sql );
		if ( !$result ){
			setLastErrorString( "error in getIndexesInternal ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
			return RES_DB_QUERY_ERROR;
		}
		while ( $row = $xoopsDB->fetchArray( $result ) ){
			$index_buf[ $row['item_id'] ]['titles'][] = $row['title'];
		}
//  		foreach( $index_buf as &$index ){
//  			$tmp = getTitles( __FUNCTION__, $index['item_id'] );
//  			if( !$tmp ){
//  				setLastErrorString( "error getTitles(item_id=${index['item_id']}) in ".__FUNCTION__." at ".__LINE__." in ".__FILE__ );
//  				return RES_DB_QUERY_ERROR;
//  			}
//  			$index['titles'] = $tmp;
//  		}
		foreach( $index_buf as $k => $index ){// rename to "Private" if owwner_uid of index == $uid
			if ( $index['parent_index_id'] == IID_ROOT && $index['open_level'] == OL_PRIVATE && $index['owner_uid'] == $uid )
				$index_buf[$k]['titles'][DEFAULT_INDEX_TITLE_OFFSET] = XNP_PRIVATE_INDEX_TITLE; 
		}

		//get keywords of selected item
		$sql = "SELECT item_id, keyword FROM " . $xoopsDB->prefix( "xoonips_item_keyword" )
			. " WHERE item_id IN ( " . implode( ",", array_keys( $index_buf ) ) . " ) ORDER BY item_id ASC, keyword_id ASC";
		$result = $xoopsDB->query( $sql );
		if ( !$result ){
			setLastErrorString( "error in getIndexesInternal ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
			return RES_DB_QUERY_ERROR;
		}
		while ( $row = $xoopsDB->fetchArray( $result ) ){
			$index_buf[ $row['item_id'] ]['keywords'][] = $row['keyword'];
		}
//  		foreach( $index_buf as &$index ){
//  			$tmp = getKeywords( __FUNCTION__, $index['item_id'] );
//  			if( !$tmp ){
//  				setLastErrorString( "error getKeywords(item_id=${index['item_id']}) in ".__FUNCTION__." at ".__LINE__." in ".__FILE__ );
//  				return RES_DB_QUERY_ERROR;
//  			}
//  			$index['keywords'] = $tmp;
//  		}
	}
	
	// convert the associative array(index_buf) to the array(indexes) (keep order specified by criteriaString)
	foreach( $orderd_ids as $id ){
		$indexes[] = $index_buf[$id];
	}

	setLastErrorString( "" );
	return RES_OK;
}


/** ƤΥǥå<br>
 *   int xnp_get_all_indexes( string sess_id, array criteria, array indexes );
 * @param sid XOOPSΥåID
 * @param criteria ̤ϰϻꡤȾ
 * @param indexes ǥåΰ֤
 * @return RES_OK
 */
function xnp_get_all_indexes( $sess_id, $criteria, &$indexes )
{
	$indexes = array();
    
	$result = sessionID2UID( $sess_id, $uid ); // sid  uid 
	if( $result == RES_OK ){
		$result = getIndexesInternal( $sess_id, false, $uid, $indexes, criteria2str( $criteria ) );
	}
	return $result;
}

/**
 *
 * ƥξǧ֤ѹ븢¤̵ͭĴ٤ޤ
 * @refer certify_t
 * @param sess_id åID
 * @param xid ѹоݥƥबϿƤ륤ǥåID
 * @param iid ѹоݥƥID
 * @param state ѹǧ
 * @return true ¤
 * @return false ¤ʤ
 *
 */
function xnp_get_certify_permission( $sess_id, $xid, $iid, $state )
{
	$xid = (int)$xid;
	$iid = (int)$iid;

	global $xoopsDB;
	global $xoopsUser;
	if( !xnp_is_valid_session_id( $sess_id ) ) return false;
	if( !isset( $xoopsUser ) || $xoopsUser == null )return false;
	
	if( ( $ret = sessionID2UID( $sess_id, $sess_uid ) ) != RES_OK ) return false;
	if ( $sess_uid == UID_GUEST ) return false;
	
	$sql = "SELECT DISTINCT tlink.index_id, tlink.item_id".
	  " FROM " . $xoopsDB->prefix( "xoonips_index_item_link" ) . " AS tlink".
	  " LEFT JOIN " . $xoopsDB->prefix( "xoonips_index" ) . " AS tx ON tlink.index_id = tx.index_id".
	  " LEFT JOIN " . $xoopsDB->prefix( "xoonips_item_basic" ) . " AS ti ON tlink.item_id = ti.item_id".
	  " LEFT JOIN " . $xoopsDB->prefix( "xoonips_groups_users_link" ) . " AS tgulink ON tgulink.gid = tx.gid".
	  " WHERE open_level<=" . OL_GROUP_ONLY .
	  " AND item_type_id !=" . ITID_INDEX .
	  " AND ti.item_id=$iid".
	  " AND tx.index_id=$xid".
	  " AND ( is_admin=1 AND tgulink.uid=$sess_uid".
	  " OR item_type_id=" . ITID_BINDER; //٤ƤΥХǧ
	if( $state == NOT_CERTIFIED )
		$sql .= " OR ti.uid=$sess_uid";
	$sql .= ( xnp_is_moderator( $sess_id, $sess_uid ) ? " OR 1)" : " OR 0)" ); //ǥ졼ʤOR 1ʳ OR 0
	//
	if( countResultRows( $sql, $count ) != RES_OK ){
		return false;
	}
	return $count > 0;
}

/**
 *
 * ƥξǧ֤ޤ
 * @refer certify_t
 * @param sid åID
 * @param xid оݥƥबϿƤ륤ǥåID
 * @param iid оݥƥID
 * @param state ǧ֤
 * @return RES_OK
 * @return RES_NO_WRITE_ACCESS_RIGHT
 *
 */
function xnp_get_certify_state( $sess_id, $xid, $iid, &$state )
{
	$xid = (int)$xid;
	$iid = (int)$iid;

	global $xoopsDB;
	$sql = "SELECT certify_state".
	  " FROM " . $xoopsDB->prefix( "xoonips_index_item_link" ) .
	  " WHERE item_id = $iid ".
        " AND index_id = $xid ";
	$ret = queryGetUnsignedInt( "xnp_get_certify_state", $sql, $state );
    return $ret;
}

/**
 *
 * ƥѹ롥
 *
 * @param sess_id åID
 * @param itemid ѹ륢ƥID
 * @param logs Ƥ
 * @return RES_OK
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_READ_ACCESS_RIGHT
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_ERROR
 *
 */
function xnp_get_change_logs( $sess_id, $item_id, &$logs )
{
	global $xoopsDB;
	$logs = array();
    
	$item_id = (int)$item_id;

	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	if( !xnp_get_item_permission( $sess_id, $item_id, OP_READ ) ) return RES_NO_READ_ACCESS_RIGHT;
	
	$sql = "SELECT log_date, log FROM " . $xoopsDB->prefix("xoonips_changelog").
		" WHERE item_id=$item_id ORDER BY log_date DESC, log_id DESC";
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in getChangeLogs ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	
	$logs = array();
	while ( $row = $xoopsDB->fetchArray( $result ) ){
		$logs[] = $row;
	}
	
	setLastErrorString( "" );
	return RES_OK;
}

/**
 *
 * ̾keyбͤvaule˼롥
 * @param key ꥭ̾
 * @param value ͤѿ
 *
 * @return RES_OK
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 */
function xnp_get_config_value( $key, &$value )
{
	global $xoopsDB;
	$esckey = addslashes( $key );
	$sql = "select value from " . $xoopsDB->prefix( "xoonips_config" ) . " where name = '$esckey' ";
	
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in xnp_get_config_value ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	$value = null;
	if ( $xoopsDB->getRowsNum($result) > 0 ){
		list( $value ) = $xoopsDB->fetchRow( $result );
		setLastErrorString( "" );
		return RES_OK;
	}
	else {
		setLastErrorString( "error in xnp_get_config_value, no such key '$key'"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_ERROR;
	}
}


function getEvents( $sess_id, &$events, $condition )
{
    global $eventValidFields;
	global $xoopsDB;
	
    static $key = array( 'timestamp', 'exec_uid', 'remote_host', 'index_id', 'item_id', 'file_id', 'uid', 'gid', 'search_keyword', 'additional_info' );

	// get
	$sql = "select event_id, event_type_id, timestamp, exec_uid, index_id, item_id, ".
		" file_id, uid, gid, remote_host, search_keyword, additional_info from " . $xoopsDB->prefix( "xoonips_event_log ") . $condition;
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in deleteMember ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	
	$events = array();
	while ( $row = $xoopsDB->fetchArray( $result ) ){
        $event_type_id = $row['event_type_id'];
        $ar = array( "event_id" => $row["event_id"], "event_type_id" => $row["event_type_id"] );
        for( $i = 0; $i < count( $key ); $i++ ){
            if( $eventValidFields[ $event_type_id ][$i] ) $ar[$key[$i]] = $row[$key[$i]];
        }
		$events[] = $ar;
	}
	setLastErrorString( "" );
	return RES_OK;
}



/**
 * ٥Ȥ
 *
 * int xnp_get_events( string sess_id, array events, int starttime=0, int endtime=0 )
 * @param sess_id åID
 * @param events ٥Ȥѿ
 * @param starttime ϰ
 * @param endtime ϰ
 * @return RES_OK
 *
 */
function xnp_get_events( $sess_id, &$events, $start_time=0, $end_time=0 )
{
	$start_time = (int)$start_time;
	$end_time = (int)$end_time;
	$events = array();

	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	if( !isModeratorBySession( $sess_id ) ) return RES_NO_READ_ACCESS_RIGHT;
	
	// time condition
	$condition = " where ";
	if ( $start_time != 0 ) $condition .= "${start_time} <= timestamp and ";
	if ( $end_time != 0 )   $condition .= " timestamp < ${end_time} and ";
	$condition .= "1";
	$condition .= " order by timestamp asc";
	
	return getEvents( $sess_id, $events, $condition );
}

function isAdmin( $uid )
{
	global $xoopsDB;
	$sql = "SELECT count(*)>0 FROM " . $xoopsDB->prefix('groups')  . " as tg," . $xoopsDB->prefix('groups_users_link' ) . " as tgul " .
	  "  WHERE tg.groupid = tgul.groupid and group_type='Admin' and tgul.uid=$uid";
	
	$result = $xoopsDB->query( $sql );
	if ( $result ){
		list( $isAdmin ) = $xoopsDB->fetchRow( $result );
		return $isAdmin;
	}
	setLastErrorString( "error in isAdmin ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
	return false;
}


/**
 * RSSɬפʥ٥Ȥ
 *
 * int xnp_get_events_for_rss( string sess_id, array events, int max )
 * @param sess_id åID
 * @param events ٥Ȥѿ
 * @param max 
 * @return RES_OK
 *
 */
function xnp_get_events_for_rss( $sess_id, &$events, $max )
{
	$max = (int)$max;

	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	$sess_uid = null;
	if( sessionID2UID( $sess_id, $sess_uid ) != RES_OK ){
		return RES_ERROR;
	}
	
	if( isAdmin( $sess_uid ) );
	else if( isModeratorBySession( $sess_id ) );
	else {
		$uid = $sess_uid;
		
		//retrieve all group id
		$gids = array();
		$ret = xnp_dump_gids( $sess_id, array(), $gids );
		if( $ret != RES_OK ) return $ret;
		
		//is uid a group admin ?
		$gidsLen = count( $gids );
		for( $i = 0 ; $i < $gidsLen; $i++ ){
			if( xnp_is_group_admin( $sess_id, $gids[ $i ], $sess_uid ) ) break;
		}
	}
	
	//retrieve events
	$condition = " where event_type_id in ( " . ETID_CERTIFY_ITEM . ", " . ETID_INSERT_GROUP . " )" .
	  " order by timestamp desc limit $max";
	
	return getEvents( $sess_id, $events, $condition );
}

/** ꤷ롼פξ<br>
	int xnp_get_group( string sess_id, int gid, array group );
	@param sess_id    XOOPSΥåID
	@param gid    XNP  group_id
	@param group  ̤
	@return RES_OK success <br>
  */
function xnp_get_group( $sess_id, $gid, &$group )
{
	$groups = array();
	$group = array();
	$result = xnp_get_groups( $sess_id, array( (int)$gid ), array(), $groups );
	if ( $result != RES_OK )
		return $result;
	if ( !isset( $groups[0] ) )
		return RES_NO_SUCH_GROUP;
	$group = $groups[0];
	setLastErrorString( "" );
	return RES_OK;
}

/** XNPΥ롼פο<br>
	int xnp_get_group_count( int sess_id );
	@param sess_id   XOOPSΥåID
	@return 롼׿
  */
function xnp_get_group_count( $sess_id )
{
	global $xoopsDB;
	if( !xnp_is_valid_session_id( $sess_id ) ) return 0;
	
	//롼׿
	$sql = "SELECT COUNT(*) FROM " . $xoopsDB->prefix( "xoonips_groups" ) . " WHERE gid != " . GID_DEFAULT;
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in getGroupCount ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	
	list( $count ) = $xoopsDB->fetchRow( $result );
	return $count;
}

/**
 * 
 * 롼ץǥåϿ줿ƥIDޤ
 * 
 * @param sess_id åID
 * @param gid оݥ롼פID
 * @param iids Ͽ줿ƥID
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 * 
 */
function xnp_get_group_item_id( $sess_id, $gid, &$iids )
{
	$gid = (int)$gid;
	$iids = array();
    
	global $xoopsDB;
	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	
	if( ( $ret = sessionID2UID( $sess_id, $sess_uid ) ) != RES_OK ) return $ret;
	
	$sql = "SELECT DISTINCT tlink.item_id";
	$sql .= " FROM "      . $xoopsDB->prefix( "xoonips_index_item_link" ) . " AS tlink";
	$sql .= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_index" ) . " AS tx ON tlink.index_id=tx.index_id";
	$sql .= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_item_basic" ) . " AS ti ON tlink.item_id=ti.item_id";
	$sql .= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_groups_users_link" ) . " AS tgulink ON tgulink.gid = tx.gid";
	$sql .= " WHERE open_level=" . OL_GROUP_ONLY;
	$sql .= " AND certify_state=" . CERTIFIED;
	$sql .= " AND item_type_id !=" . ITID_INDEX;
	$sql .= " AND item_type_id !=" . ITID_BINDER;
	$sql .= " AND tx.gid=$gid";
	
	//	
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in getGroupItemID ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	
	while ( list( $iid ) = $xoopsDB->fetchRow( $result ) ){
		$iids[] = $iid;
	}
	setLastErrorString( "" );
	return RES_OK;
}

/** ꤷ롼(ʣ)ξ<br>
	xnp_get_groups( string sess_id, array gids, array criteria, array groups );
	@param sess_id      XOOPSΥåID
	@param gids     XNP  group_id 
	@param criteria 
	@param groups   ̤
	@return RES_OK success <br>
  */
function xnp_get_groups( $sess_id, $gids, $criteria, &$groups )
{
	global $xoopsDB;
	$groups = array();
    
	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	
	$sql = "SELECT gid, gname, gdesc, group_index_id, group_item_number_limit as item_number_limit, group_index_number_limit as index_number_limit, group_item_storage_limit as item_storage_limit ";
	$sql .= " FROM " . $xoopsDB->prefix( "xoonips_groups ");
	if( count($gids) )
		$sql .= " WHERE gid in ( " . getCsvStr( $gids ) . ") and gid <> " . GID_DEFAULT;
	else
		$sql .= " WHERE gid <> " . GID_DEFAULT;
	
	$sql .= criteria2str( $criteria );
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in getGroups ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	
	$groups = array();
	while ( $group = $xoopsDB->fetchArray( $result ) ){
		$groups[] = $group;
	}
	setLastErrorString( "" );
	return RES_OK;
}

/** uidǻꤷ桼°롼פǡľ˰פ륰롼פgid<br>
	int xnp_get_group_by_uid( string sess_id, int uid, array criteria, array gids );
	@param sess_id   XOOPSΥåID
	@param uid   xoops_users.uid
	@param criteria  ϰϡȽɽ
	@param gids gid
	@return RES_OK success
  */
function xnp_get_groups_by_uid( $sess_id, $uid, $criteria, &$gids )
{
	$uid = (int)$uid;
	$gids = array();
    
	global $xoopsDB;
	
	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	if( !uidExists( $uid ) ) return RES_NO_SUCH_USER; //uid¸ߤå
	
	$sql = "SELECT gid FROM " . $xoopsDB->prefix( "xoonips_groups_users_link" );
	$sql .= " WHERE uid=$uid";
	$sql .= " AND gid != " . GID_DEFAULT;
	$sql .= criteria2str( $criteria );
	
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in getGroupsByUid ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	$gids = array();
	while ( list( $gid ) = $xoopsDB->fetchRow( $result ) ){
		$gids[] = $gid;
	}
	setLastErrorString( "" );
	return RES_OK;
}

/** ǥå<br>
 *   int xnp_get_index( string sess_id, int index_id, array index );
 * @param sess_id XOOPSΥåID
 * @param index_id 륤ǥåID
 * @param index ̤Ϣ
 * @return RES_OK
 */
function xnp_get_index( $sess_id, $index_id, &$index )
{
	$index_id = (int)$index_id;
	$index = array();
    
	$result = sessionID2UID( $sess_id, $uid ); // sid  uid 
	if( $result == RES_OK ){
		$cond = " index_id = $index_id " ;
		$indexes = array();
		$result = getIndexesInternal( $sess_id, $cond, $uid, $indexes, "" );
		if ( $result == RES_OK && !isset( $indexes[0] ) ){
            setLastErrorString( "error can't found index(id=${index_id}) in xnp_get_index" );
			$result = RES_ERROR;
		}else{
            $index = $indexes[0];
        }
	}
	return $result;
}

function xnp_get_index_id_by_item_id( $sess_id, $item_id, &$xids )
{
	$item_id = (int)$item_id;
	$xids = array();
    
	global $xoopsDB;
	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	if( !xnp_get_item_permission( $sess_id, $item_id, OP_READ ) ) return RES_NO_READ_ACCESS_RIGHT;
	
	$sql = "SELECT index_id FROM " . $xoopsDB->prefix( "xoonips_index_item_link" ) . 
		" WHERE item_id=$item_id";
	
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in getIndexIDByItemID ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	while ( list( $xid ) = $xoopsDB->fetchRow( $result ) ){
		$xids[] = $xid;
	}
	setLastErrorString( "" );
	return RES_OK;
}

/** 륤ǥåƤλҥǥå<br>
 *   int xnp_get_indexes( string sess_id, int parent_xid, array criteria, array indexes );
 * @param sess_id XOOPSΥåID
 * @param parent_xid ƤindexID
 * @param criteria ̤ϰϻꡤȾ
 * @param indexes ̤
 * @return RES_OK
 */
function xnp_get_indexes( $sess_id, $parent_xid, $criteria, &$indexes )
{
	$parent_xid = (int)$parent_xid;
	$indexes = array();
    
	$result = sessionID2UID( $sess_id, $uid ); // sid  uid 
	if( $result == RES_OK ){
		$cond = "parent_index_id = $parent_xid";
		$result = getIndexesInternal( $sess_id, $cond, $uid, $indexes, criteria2str( $criteria ) );
	}
	setLastErrorString( "" );
	return $result;
}

/**
 *
 * ƥ.
 *
 * @param sess_id åID
 * @param iid ƥID
 * @param item ̤ΥƥϢ
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_NO_SUCH_ITEM
 * @return RES_DB_QUERY_ERROR
 *
 */
function xnp_get_item( $sess_id, $iid, &$item )
{
	$items = array();
	$item = array();
	$result = xnp_get_items( $sess_id, array((int)$iid), array(), $items );
	
	if( count($items) == 0 ){
		return RES_NO_SUCH_ITEM;
	}
	$item = $items[0];
	return $result;
}


/** Readǽʥƥο<br>
	int xnp_get_item_count( string sess_id, int &count );
	@param sess_id   XOOPSΥåID
	@return ƥ
  */
function xnp_get_item_count( $sess_id )
{
	global $xoopsDB;
	if( !xnp_is_valid_session_id( $sess_id ) ) return 0;
	
	$ret = sessionID2UID( $sess_id, $uid );
	if( $ret != RES_OK ) return 0;
	
	$sql = "SELECT count(DISTINCT ti.item_id)";
	$sql.= " FROM " . $xoopsDB->prefix( "xoonips_index_item_link AS tlink" );
	$sql.= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_index AS" ) . " tx ON tlink.index_id = tx.index_id";
	$sql.= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_item_basic" ) . " AS ti ON tlink.item_id = ti.item_id";
	$sql.= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_groups_users_link" ) . " as tgulink ON tx.gid=tgulink.gid";
	$sql.= " WHERE ( " . ( public_item_target_user_all( ) ? "1" : "0" );
	$sql.=   " AND tx.open_level=" .OL_PUBLIC. " AND $uid=" . UID_GUEST;
	$sql.=   " AND certify_state=" .CERTIFIED ;
	$sql.=       " OR " . ( !public_item_target_user_all( ) ? "1" : "0" );
	$sql.=          " AND tx.open_level=" .OL_PUBLIC. " AND $uid <> " . UID_GUEST;
	$sql.=          " AND certify_state=" .CERTIFIED ;
	$sql.=       " OR tgulink.uid=$uid";
	$sql.=         " AND ( certify_state=" .CERTIFIED ;
	$sql.=               ( xnp_is_moderator( $sess_id, $uid ) ? " OR 1" : " OR 0" ); //ǥ졼ʤOR 1ʳ OR 0
	$sql.=               " OR tgulink.is_admin=1 )"; //롼״Ԥ
	if( $uid != UID_GUEST ) $sql.= " AND tgulink.uid=$uid";
	$sql.=   " OR tx.open_level=" .OL_PRIVATE ;
	$sql.=      " AND tx.uid=$uid";
	$sql.=   " OR tx.uid IS NULL ";
	$sql.=     " AND tx.open_level=" .OL_PUBLIC;
	$sql.=     " AND ( certify_state=" .CERTIFIED;
	$sql.=           ( xnp_is_moderator( $sess_id, $uid ) ? " OR 1 )" : " OR 0 )" ); //ǥ졼ʤOR 1ʳ OR 0
	$sql.= ( xnp_is_moderator( $sess_id, $uid ) ? " OR 1" : " OR 0" ); //ǥ졼ʤOR 1ʳ OR 0
	$sql.=    ") ";
	$ret = queryGetUnsignedInt( "getItemCount", $sql, $count );
	
	if( $ret != RES_OK ) return 0;
	
	return $count;
}

/** ReadǽʥǥåΡľΥƥ<br>
	int xnp_item_count_group_by_index( string sess_id, array counts );
	@param sess_id   XOOPSΥåID
	@param counts ƥϢ󡥥index_idͤϥƥ
    @return RES_OK
    @return RES_DB_NOT_INITIALIZED
    @return RES_NO_SUCH_SESSION
    @return RES_DB_QUERY_ERROR
  */
function xnp_get_item_count_group_by_index( $sess_id, &$counts )
{
	global $xoopsDB;
	$counts = array();
    
	$ret = sessionID2UID( $sess_id, $uid );
	if( $ret != RES_OK ) return $ret;
	
	$indexItemLinkTable = $xoopsDB->prefix( "xoonips_index_item_link" );
	$indexTable = $xoopsDB->prefix( "xoonips_index" );
	$itemTable = $xoopsDB->prefix( "xoonips_item_basic" );
	$groupsUsersLinkTable = $xoopsDB->prefix( "xoonips_groups_users_link" );
	
	// todo: item_type_idΥå򳰤
	if ( xnp_is_moderator($sess_id, $uid) ) {
		$sql = "SELECT index_id, COUNT(*) from $indexItemLinkTable AS tl " .
			" LEFT JOIN $itemTable AS ti on ti.item_id=tl.item_id " .
			" WHERE ti.item_type_id <> " . ITID_INDEX .
			" GROUP BY index_id";
	}
	else {
		$certified = " tl.certify_state=" . CERTIFIED;
		$sql = "SELECT  tx.index_id, COUNT(tl.index_id) " .
			"  FROM      $indexTable AS tx" .
			"  LEFT JOIN $groupsUsersLinkTable AS tgl ON tx.gid=tgl.gid AND tgl.uid=$uid" .
			"  LEFT JOIN $indexItemLinkTable AS tl ON tx.index_id=tl.index_id " .
			"  LEFT JOIN $itemTable AS ti ON ti.item_id=tl.item_id " .
			"  WHERE " .
			"   (tx.open_level=" .OL_PUBLIC . " AND " .
					 "($certified OR ti.uid=$uid )" .
			" OR tx.open_level=" .OL_GROUP_ONLY . " AND tgl.uid IS NOT NULL AND " .
					 "($certified OR ti.uid=$uid OR tgl.is_admin=1 )" .
			" OR tx.open_level=" .OL_PRIVATE . " AND tx.uid=$uid" .
			"  ) AND ti.item_type_id <> " .ITID_INDEX .
			"  GROUP BY tx.index_id";
	}
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in getItemCountGroupByIndex ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	$counts = array();
	while ( list( $xid, $count ) = $xoopsDB->fetchRow( $result ) ){
		$counts[$xid] = $count;
	}
	setLastErrorString( "" );
	return RES_OK;
}

/**
 *
 * ХϿ줿ƥIDޤ
 * @param sess_id åID
 * @param binder_id оݥХID
 * @param cri ̤ϰϻꡤȾ
 * @param iids Ͽ줿ƥID
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 *
 */
function xnp_get_item_id_by_binder_id( $sess_id, $binder_id, $cri, &$iids )
{
	$binder_id = (int)$binder_id;
	$iids = array();
    
	global $xoopsDB;
	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	
	$sql = "SELECT t1.item_id FROM " . $xoopsDB->prefix( "xoonips_item_basic" ) . " as t1, "
		. $xoopsDB->prefix( "xoonips_binder_item_link" ) . " as t2, "
		. $xoopsDB->prefix( "xoonips_item_title" ) . " as t3 ";
	$sql .= " WHERE t1.item_id = t2.item_id";
	$sql .= " AND t2.binder_id=$binder_id";
	$sql .= " AND t3.title_id=".DEFAULT_ORDER_TITLE_OFFSET." AND t3.item_id=t1.item_id";
	$sql .= criteria2str( $cri );
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in deleteMember ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	while ( list( $iid ) = $xoopsDB->fetchRow( $result ) ){
		$iids[] = $iid;
	}
	
	setLastErrorString( "" );
	return RES_OK;
}

/**
 *
 * ǥåϿ줿ƥIDޤ
 * ¤̵ɤʤΤϷ̤˴ޤߤޤ
 * ̤ǧɤʤΤ̤˴ޤߤޤ
 *
 * @param sess_id åID
 * @param xid оݥǥåID
 * @param cri ̤ϰϻꡤȾ
 * @param iids Ͽ줿ƥID
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 *
 */
function xnp_get_item_id_by_index_id( $sess_id, $xid, $cri, &$iids )
{
	global $xoopsDB;
	$xid = (int)$xid;
	$iids = array();

	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	
	if( ( $ret = sessionID2UID( $sess_id, $uid ) ) != RES_OK ) return $ret;

	$sql = "SELECT DISTINCT tlink.item_id AS item_id, tt.title as title FROM " . $xoopsDB->prefix( "xoonips_index_item_link" ) . " AS tlink ";
	$sql.= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_index" ) . " AS tx ON tlink.index_id = tx.index_id";
	$sql.= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_item_basic" ) . " AS ti ON tlink.item_id = ti.item_id";
	$sql.= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_item_title" ) . " AS tt ON tt.item_id=ti.item_id";
	$sql.= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_groups_users_link" ) . " as tgulink ON tx.gid=tgulink.gid";
	$sql.= " WHERE ( " . ( public_item_target_user_all( ) ? "1" : "0" );
	$sql.=       " AND tx.open_level=" .OL_PUBLIC . " AND $uid=" . UID_GUEST;
	$sql.=       " AND certify_state=" .CERTIFIED ;
	$sql.=    " OR " . ( !public_item_target_user_all( ) ? "1" : "0" );
	$sql.=       " AND tx.open_level=" .OL_PUBLIC . " AND $uid <> " . UID_GUEST;
	$sql.=       " AND ( certify_state=" .CERTIFIED  ;
	$sql.=         " OR ti.uid=$uid)";
	$sql.=    " OR tx.open_level=" .OL_PRIVATE ;
	$sql.=       " AND tx.uid=$uid";
	$sql.=    " OR ".( xnp_is_moderator( $sess_id, $uid ) ? "1" : "0" );
	$sql.=    " OR tx.open_level=" .OL_GROUP_ONLY ;
	$sql.=    " AND ( certify_state=" .CERTIFIED ;
	$sql.=        " OR ti.uid=$uid";
	$sql.=        ( xnp_is_moderator( $sess_id, $uid ) ? " OR 1" : " OR 0" ); //ǥ졼ʤOR 1ʳ OR 0
	$sql.=        " OR tgulink.is_admin=1 )"; //롼״Ԥ
	if( $uid != UID_GUEST ) $sql.= " AND tgulink.uid=$uid";
	$sql.=    " OR tx.uid IS NULL ";
	$sql.=    " AND tx.open_level=" .OL_PUBLIC ;
	$sql.=    " AND ( certify_state=" .CERTIFIED ;
	$sql.=        " OR ti.uid=$uid";
	$sql.=        ( xnp_is_moderator( $sess_id, $uid ) ? " OR 1 )" : " OR 0 )" ); //ǥ졼ʤOR 1ʳ OR 0
	$sql.=    ") AND ti.item_type_id!=" .ITID_INDEX ;
	$sql.= " AND tx.index_id=$xid";
	$sql.= " AND tt.title_id=".DEFAULT_ORDER_TITLE_OFFSET;
	$sql.= criteria2str( $cri );
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in xnp_get_item_id_by_index_id ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	$iids = array();
	while ( list( $iid ) = $xoopsDB->fetchRow( $result ) ){
		$iids[] = $iid;
	}
	setLastErrorString( "" );
	return RES_OK;
}

/**
 *
 * ƥؤΥ¤å
 *
 * @refer itemop_t
 * @param sess_id åID
 * @param iid åоݤȤʤ륢ƥID
 * @param op μ
 * @return true ¤
 * @return false ¤ʤ
 *
 */
function xnp_get_item_permission( $sess_id, $iid, $op )
{
	$iid = (int)$iid;

	global $xoopsDB;
	$uid = 0;
	if( sessionID2UID( $sess_id, $uid ) != RES_OK ) return false;
	if( $op == OP_READ ){
		$sql = "SELECT DISTINCT tlink.item_id FROM " . $xoopsDB->prefix( "xoonips_index_item_link" ) . " AS tlink";
		$sql.= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_index" ) . " AS tx ON tlink.index_id = tx.index_id";
		$sql.= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_item_basic" ) . " AS ti ON tlink.item_id = ti.item_id";
		$sql.= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_groups_users_link" ) . " as tgulink ON tx.gid=tgulink.gid";
		$sql.= " WHERE ( " . ( public_item_target_user_all( ) ? "1" : "0" );
		$sql.=       " AND tx.open_level=" . OL_PUBLIC . " AND $uid=" . UID_GUEST;
		$sql.=       " AND certify_state=" . CERTIFIED ;
		$sql.=    " OR " . ( !public_item_target_user_all( ) ? "1" : "0" );
		$sql.=       " AND tx.open_level=" . OL_PUBLIC  . " AND $uid<>" . UID_GUEST;
		$sql.=       " AND certify_state=" . CERTIFIED ;
		$sql.=    " OR tx.open_level=" . OL_GROUP_ONLY ;
		$sql.=      " AND tgulink.uid=$uid";
		$sql.=      " AND ( certify_state=" . CERTIFIED ;
		$sql.=          ( xnp_is_moderator( $sess_id, $uid ) ? " OR 1" : " OR 0" ); //ǥ졼ʤOR 1ʳ OR 0
		$sql.=          " OR tgulink.is_admin=1 )"; //롼״Ԥ
		if( $uid != UID_GUEST ) $sql.= " AND tgulink.uid=$uid";
		$sql.=    " OR tx.open_level=" . OL_PRIVATE ;
		$sql.=       " AND tx.uid=$uid";
		$sql.=    " OR " . ( xnp_is_moderator( $sess_id, $uid ) ? "1" : "0" );
		$sql.=    " OR tx.uid IS NULL ";
		$sql.=    " AND tx.open_level=" . OL_PUBLIC ;
		$sql.=    " AND ( certify_state=" . CERTIFIED ;
		$sql.=          ( xnp_is_moderator( $sess_id, $uid ) ? " OR 1 )" : " OR 0 )" ); //ǥ졼ʤOR 1ʳ OR 0
		$sql .= ( xnp_is_moderator( $sess_id, $uid ) ? " OR 1" : " OR 0" ); //ǥ졼ʤOR 1ʳ OR 0
		$sql.=    ") AND tlink.item_id=$iid ";
		if( queryGetUnsignedInt( "getItemPermission", $sql, $item_id ) == RES_OK ){
			return $item_id == $iid;
		}
	}else if( $op == OP_MODIFY || $op == OP_DELETE ){
		// modifying items by moderator is permitted then returns true;
		if( $op == OP_MODIFY && xnp_is_moderator( $sess_id, $uid )
            && xnp_get_config_value( 'moderator_modify_any_items', $val ) == RES_OK && $val == 'on' )
			return true;
		//TODO ɲátodoʬΥƥǤ⾵ǧԤ֤ʤԽǤʤ
		$sql = "SELECT item_id FROM " . $xoopsDB->prefix( "xoonips_item_basic" );
		$sql .= " WHERE uid=$uid";
		$sql .= " AND item_id=$iid";
		if( queryGetUnsignedInt( "getItemPermission", $sql, $item_id ) == RES_OK ){
			return $item_id == $iid;
		}
	}
	return false;
}

/**
 * 
 * ǥåؤΥ¤å
 * 
 * @see indexop_t
 * @param sid åID
 * @param xid åоݤȤʤ륤ǥåID
 * @param op μ
 * @return true ¤
 * @return false ¤ʤ
 * 
 */
function xnp_get_index_permission( $sess_id, $xid, $op )
{
	global $xoopsDB;
	$xid = (int)$xid;

	if( $xid == IID_ROOT ) return false;
	
	if( isModeratorBySession( $sess_id ) );
	else if( $xid == IID_BINDERS );
	else if( sessionID2UID( $sess_id, $uid ) == RES_OK ){
		$sql = "SELECT index_id FROM " . $xoopsDB->prefix( "xoonips_index as tx" );
		$sql .= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_users" ) . " AS tuser ON tx.uid=tuser.uid";
		$sql .= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_groups" ) . " AS tgroup ON tx.gid=tgroup.gid";
		$sql .= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_groups_users_link" ) . " AS tlink ON tx.gid=tlink.gid";
		$sql .= " WHERE ( tx.open_level=1";
		$sql .= " OR tx.open_level=2 AND tlink.uid=$uid";
		$sql .= " OR tx.open_level=3 AND tx.uid=$uid )";
		$sql .= " AND index_id=$xid";
		if( queryGetUnsignedInt( "getIndexPermission", $sql, $tmp ) == RES_OK
			&& $tmp == $xid );
		else return false;
	}
	else return false;
	return true;
}

/**
 * item_status
 *
 * int xnp_get_item_status( int iid, array status )
 * @param iid  item ID
 * @param status  ֤Ϣ󡣰ʲΥޤࡣ created_timestamp, modified_timestamp, deleted_timestamp, is_deleted
 * @return RES_OK
 * @return RES_NO_SUCH_ITEM
 *
 */
function xnp_get_item_status( $iid, &$status )
{
	$iid = (int)$iid;

	global $xoopsDB;
	$sql = "select created_timestamp, modified_timestamp, deleted_timestamp, is_deleted from " 
	 . $xoopsDB->prefix( "xoonips_item_status" ) . " where item_id=$iid";
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in getMetadataEvent ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	else if ( $xoopsDB->getRowsNum($result) == 0 ){
		return RES_NO_SUCH_ITEM;
	}
	
	list( $status["created_timestamp"], 
	      $status["modified_timestamp"], 
	      $status["deleted_timestamp"], 
	      $status["is_deleted"] ) = $xoopsDB->fetchRow( $result );
	setLastErrorString( "" );
	return RES_OK;
}

/**
 * 
 * @param types 
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 * @return RES_ERROR
 * 
 */
function xnp_get_item_types( &$types )
{
	global $xoopsDB;
	$sql = "SELECT item_type_id, name, mid, display_name, viewphp ";
	$sql .= " FROM " . $xoopsDB->prefix( "xoonips_item_type" ) . " order by item_type_id";
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in getItemType ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	$types = array();
	while ( $row = $xoopsDB->fetchArray( $result ) ){
		$types[] = $row;
	}
	setLastErrorString( "" );
	return RES_OK;
}

/**
 *
 * ƥ.
 *
 * @param sid åID
 * @param iids ƥID
 * @param criteria ̤ϰϻꡤȾ
 * @param items ̤Τ񤭹
 * @return RES_OK
 * @return RES_DB_NOT_INITIALIZED
 * @return RES_NO_SUCH_SESSION
 * @return RES_DB_QUERY_ERROR
 *
 */
function xnp_get_items( $sess_id, $iids, $criteria, &$items )
{
	global $xoopsDB;
	$items = array();
	
	if( !xnp_is_valid_session_id( $sess_id ) ) return RES_NO_SUCH_SESSION;
	
	$ret = sessionID2UID( $sess_id, $uid );
	if( $ret != RES_OK ) return $ret;
	
	$items = array();
	if( !isset( $iids ) || count( $iids ) == 0 ){
		return RES_OK;
	}
	
	$sql = "SELECT DISTINCT ti.item_id as item_id, item_type_id, tt.title as title, description, doi, ti.uid as uid, creation_date, last_update_date, publication_year, publication_month, publication_mday, lang ";
	$sql.= " FROM " ;
	$sql .= $xoopsDB->prefix( "xoonips_index_item_link" ) . " AS tlink";
	$sql.= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_index" ) . " AS tx ON tlink.index_id = tx.index_id";
	$sql.= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_item_basic" ) . " AS ti ON tlink.item_id = ti.item_id";
	$sql.= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_item_title" ) . " AS tt ON tt.item_id=ti.item_id";
	$sql.= " LEFT JOIN " . $xoopsDB->prefix( "xoonips_groups_users_link" ) . " as tgulink ON tx.gid=tgulink.gid";
	$sql.= " WHERE ( " . ( public_item_target_user_all( ) ? "1" : "0" );
	$sql.=       " AND tx.open_level=" . OL_PUBLIC . " AND $uid=" . UID_GUEST;
	$sql.=       " AND certify_state=" . CERTIFIED ;
	$sql.=    " OR " . ( !public_item_target_user_all( ) ? "1" : "0" );
	$sql.=       " AND tx.open_level=" . OL_PUBLIC  . " AND $uid<>" . UID_GUEST;
	$sql.=       " AND certify_state=" . CERTIFIED ;
	$sql.=    " OR tx.open_level=" . OL_GROUP_ONLY ;
	$sql.=      " AND tgulink.uid=$uid";
	$sql.=      " AND ( certify_state=" . CERTIFIED ;
	$sql.=          ( xnp_is_moderator( $sess_id, $uid ) ? " OR 1" : " OR 0" ); //ǥ졼ʤOR 1ʳ OR 0
	$sql.=          " OR tgulink.is_admin=1 )"; //롼״Ԥ
	if( $uid != UID_GUEST ) $sql.= " AND tgulink.uid=$uid";
	$sql.=    " OR tx.open_level=" . OL_PRIVATE ;
	$sql.=      " AND tx.uid=$uid";
	$sql.=    " OR tx.uid IS NULL ";
	$sql.=      " AND tx.open_level=" . OL_PUBLIC ;
	$sql.=      " AND ( certify_state=" . CERTIFIED ;
	$sql.=          ( xnp_is_moderator( $sess_id, $uid ) ? " OR 1 )" : " OR 0 )" ); //ǥ졼ʤOR 1ʳ OR 0
	$sql.= ( xnp_is_moderator( $sess_id, $uid ) ? " OR 1" : " OR 0" ); //ǥ졼ʤOR 1ʳ OR 0
	$sql.=    ") AND tlink.item_id IN ( ".getCsvStr( $iids )." )";
	$sql.= " AND title_id=".DEFAULT_ORDER_TITLE_OFFSET;
	$sql .= criteria2str( $criteria );
	$result = $xoopsDB->query( $sql );
	if ( !$result ){
		setLastErrorString( "error in xnp_get_items ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
		return RES_DB_QUERY_ERROR;
	}
	$items_buf = array();
	$ordered_ids = array(); //array of sorted item_id(s) to sort $items_buf in the end of this function
   	while ( $row = $xoopsDB->fetchArray( $result ) ){
		$items_buf[ $row['item_id'] ] = $row;
		$items_buf[ $row['item_id'] ]['titles'] = array();
		$items_buf[ $row['item_id'] ]['keywords'] = array();
		$ordered_ids[] = $row['item_id'];
	}
	
	//get titles of selected item
	if( count( $items_buf ) > 0 ){
		$sql = "SELECT item_id, title FROM " . $xoopsDB->prefix( "xoonips_item_title" )
			. " WHERE item_id IN ( " . implode( ",", array_keys( $items_buf ) ) . " ) ORDER BY item_id ASC, title_id ASC";
		$result = $xoopsDB->query( $sql );
		if ( !$result ){
			setLastErrorString( "error in xnp_get_items ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
			return RES_DB_QUERY_ERROR;
		}
		while ( $row = $xoopsDB->fetchArray( $result ) ){
			$items_buf[ $row['item_id'] ]['titles'][] = $row['title'];
		}
		//get keywords of selected item
		$sql = "SELECT item_id, keyword FROM " . $xoopsDB->prefix( "xoonips_item_keyword" )
			. " WHERE item_id IN ( " . implode( ",", array_keys( $items_buf ) ) . " ) ORDER BY item_id ASC, keyword_id ASC";
		$result = $xoopsDB->query( $sql );
		if ( !$result ){
			setLastErrorString( "error in xnp_get_items ".$xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__."\n".xnp_get_last_error_string() );
			return RES_DB_QUERY_ERROR;
		}
		while ( $row = $xoopsDB->fetchArray( $result ) ){
			$items_buf[ $row['item_id'] ]['keywords'][] = $row['keyword'];
		}
	}
	
	// convert the associative array(index_buf) to the array(indexes) (keep order specified by criteriaString)
	foreach( $ordered_ids as $id ){
		$items[] = $items_buf[$id];
	}
	
	setLastErrorString( "" );
	return RES_OK;
}

/**
 * 
 * zipեޤ
 * 
 * @param zippath zipեΥѥ
 * @param files zipե줿ե̾
 * @return 0 
 * @return 0ʳ 
 * 
 */
/**
 *
 * Based on :
 *
 *  zip.lib.php (phpMyAdmin)
 *
 *  http://www.zend.com/codex.php?id=535&single=1
 *  By Eric Mueller <eric@themepark.com>
 *
 *  http://www.zend.com/codex.php?id=470&single=1
 *  by Denis125 <webmaster@atlant.ru>
 *
 *  a patch from Peter Listiak <mlady@users.sourceforge.net> for last modified
 *  date and time of the compressed file
 *
 * Official ZIP file format: http://www.pkware.com/appnote.txt
 *
 */


function unix2DosTime($unixtime = 0) {
    $timearray = ($unixtime == 0) ? getdate() : getdate($unixtime);

    if ($timearray['year'] < 1980) {
        $timearray['year']    = 1980;
        $timearray['mon']     = 1;
        $timearray['mday']    = 1;
        $timearray['hours']   = 0;
        $timearray['minutes'] = 0;
        $timearray['seconds'] = 0;
    } // end if

    return (($timearray['year'] - 1980) << 25) | ($timearray['mon'] << 21) | ($timearray['mday'] << 16) |
            ($timearray['hours'] << 11) | ($timearray['minutes'] << 5) | ($timearray['seconds'] >> 1);
} // end of the 'unix2DosTime()' method

function xnp_zip_create( $zippath, $files )
{
	$hzip = fopen( $zippath, 'wb' );
	$tmpdir = '/tmp/'; // windowstempnam()Ϥΰ̵뤹餷
	
	/*
	 * Central directory
	 *
	 * @var  array    $ctrl_dir
	 */
	$ctrl_dir     = array();

	/**
	 * End of central directory record
	 *
	 * @var  string   $eof_ctrl_dir
	 */
	$eof_ctrl_dir = "\x50\x4b\x05\x06\x00\x00\x00\x00";

	/**
	 * Last offset position
	 *
	 * @var  integer  $old_offset
	 */
	$old_offset   = 0;
	
	foreach ( $files as $file ){
		$tmpfile = tempnam( $tmpdir, 'ziptest' );
		
		// $file 򰵽̤$tmpfile
		$hgz = gzopen( $tmpfile, 'wb' );
		$h = fopen( $file, 'rb' );
		if ( $h == false ){
			setLastErrorString( "cannot open $file " );
			return RES_ERROR;
		}
		while ( !feof($h) ){
			$buf = fread( $h, 65536 );
			gzwrite( $hgz, $buf );
		}
		fclose( $h );
		gzclose( $hgz );
		
		//$name = basename(str_replace('\\', '/', $file)); // basename, str_replaceȤȡܸե̾
		$name = $file;

		$dtime    = dechex(unix2DosTime(time()));
		$hexdtime = '\x' . $dtime[6] . $dtime[7]
		          . '\x' . $dtime[4] . $dtime[5]
		          . '\x' . $dtime[2] . $dtime[3]
		          . '\x' . $dtime[0] . $dtime[1];
		eval('$hexdtime = "' . $hexdtime . '";');

		$fr   = "\x50\x4b\x03\x04";
		$fr   .= "\x14\x00";            // ver needed to extract
		$fr   .= "\x00\x00";            // gen purpose bit flag
		$fr   .= "\x08\x00";            // compression method
		$fr   .= $hexdtime;             // last mod time and date

		$htmp = fopen( $tmpfile, 'rb' );
		fseek( $htmp, -8, SEEK_END );
		$ar = unpack( 'Vcrc', fread( $htmp, 4 ) );
		$crc = $ar['crc'];
		fseek( $htmp, 10, SEEK_SET );
		
		// "local file header" segment
		$unc_len = filesize($file);
		$c_len   = filesize($tmpfile) - 18; // 10 for header, 4 for crc, 4 for isize
		$fr      .= pack('V', $crc);             // crc32
		$fr      .= pack('V', $c_len);           // compressed filesize
		$fr      .= pack('V', $unc_len);         // uncompressed filesize
		$fr      .= pack('v', strlen($name));    // length of filename
		$fr      .= pack('v', 0);                // extra field length
		$fr      .= $name;
		fwrite( $hzip, $fr );

		$remain = $c_len;
		while ( $remain && !feof($htmp) ){
			$buf = fread( $htmp, min( $remain, 65536 ) );
			fwrite( $hzip, $buf );
			$remain -= strlen($buf);
		}
		fclose( $htmp );
		unlink( $tmpfile );
		$fr_len = strlen($fr) + $c_len;
		
		
		// now add to central directory record
		$cdrec = "\x50\x4b\x01\x02";
		$cdrec .= "\x00\x00";                // version made by
		$cdrec .= "\x14\x00";                // version needed to extract
		$cdrec .= "\x00\x00";                // gen purpose bit flag
		$cdrec .= "\x08\x00";                // compression method
		$cdrec .= $hexdtime;                 // last mod time & date
		$cdrec .= pack('V', $crc);           // crc32
		$cdrec .= pack('V', $c_len);         // compressed filesize
		$cdrec .= pack('V', $unc_len);       // uncompressed filesize
		$cdrec .= pack('v', strlen($name) ); // length of filename
		$cdrec .= pack('v', 0 );             // extra field length
		$cdrec .= pack('v', 0 );             // file comment length
		$cdrec .= pack('v', 0 );             // disk number start
		$cdrec .= pack('v', 0 );             // internal file attributes
		$cdrec .= pack('V', 32 );            // external file attributes - 'archive' bit set

		$cdrec .= pack('V', $old_offset ); // relative offset of local header
		$old_offset += $fr_len;

		$cdrec .= $name;

		// optional extra field, file comment goes here
		// save to central directory
		$ctrl_dir[] = $cdrec;
	}
	
	$datasec_len = ftell( $hzip );
	$ctrldir = implode('', $ctrl_dir);

	fwrite( $hzip, 
	    $ctrldir .
	    $eof_ctrl_dir .
	    pack('v', sizeof($ctrl_dir)) .  // total # of entries "on this disk"
	    pack('v', sizeof($ctrl_dir)) .  // total # of entries overall
	    pack('V', strlen($ctrldir)) .           // size of central dir
	    pack('V', $datasec_len) .              // offset to start of central dir
	    "\x00\x00"                              // .zip file comment length
	);
	fclose( $hzip );
	setLastErrorString( "" );
	return RES_OK;
}

?>
