<?php
//  functions called from ItemTypeModules                                       //
//  $Revision: 1.142.2.5 $                                                           //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

include_once XOOPS_ROOT_PATH.'/modules/xoonips/condefs.php';
include_once XOOPS_ROOT_PATH.'/modules/xoonips/include/imexport.php';
include_once XOOPS_ROOT_PATH.'/modules/xoonips/include/encode.php';



/*
 * compare function for usort.
 * order indexes by open_level, owner_gid, certified, item_id
 */
function indexcmp ($a, $b) {
    if ($a['open_level'] == $b['open_level'])
        if ($a['owner_gid'] == $b['owner_gid'])
            if ($a['certified'] == $b['certified']) 
                return ($a['item_id'] < $b['item_id']) ? -1 : 1;
            else
                return ($a['certified'] < $b['certified']) ? -1 : 1;
        else
            return ($a['owner_gid'] < $b['owner_gid']) ? -1 : 1;
    else
        return ($a['open_level'] < $b['open_level']) ? -1 : 1;
}

/**
 * 
 * return array of ListBlock's HTML from array of item_id.
 * result doesn't contain array data on item_id not existing or item_id not accessible.
 * 
 * @param $itemid ID of item or array of item id
 * @return array( itemid => array of HTML made by "name of itemtype>GetListBlock", ...Repeat... )
 * 
 */
function itemid2ListBlock( $itemid )
{
	$xnpsid = $_SESSION['XNPSID'];
    
    if( !is_array( $itemid ) ){
        $itemid = array( $itemid );
    }
    
    $itemtypes = array();
    $tmp = array();
    if( xnp_get_item_types( $tmp ) != RES_OK ){
        redirect_header(XOOPS_URL.'/index.php', 3, "ERROR xnp_get_item_types [AbstractLayer]".xnp_get_last_error_string());
        break;
    }else{
        foreach( $tmp as $i){
            $itemtypes[$i['item_type_id']]=$i;
        }
    }
    
    $item_htmls = array();
    foreach( $itemid as $id ){
        $item = array();
        if( xnp_get_item( $xnpsid, (int)$id, $item ) != RES_OK ){
            continue;
        }
        if( array_key_exists( $item['item_type_id'], $itemtypes ) ){
            $itemtype = $itemtypes[ $item['item_type_id'] ];
            $modname = $itemtype['name'];
            include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
            if ( function_exists($modname."GetListBlock") ){
                $html = '';
                eval( "\$html = ".$modname."GetListBlock( \$item );" );
                $item_htmls[$id] = $html;
            }
        }
    }
    return $item_htmls;
}

// return Value from $_POST. If the value isn't set, function returns $default_value.
function xnpGetPostVarDef( $key, $default_value ){
	if ( isset( $_POST[$key] ) )
		return $_POST[$key];
	return $default_value;
}

/** delete files not related to any sessions and any items.
 */
function xnpCleanup(){
	global $xoopsDB;
	$fileTable           = $xoopsDB->prefix('xoonips_file');
	$sessionTable        = $xoopsDB->prefix('session');
	$searchTextTable     = $xoopsDB->prefix('xoonips_search_text');
	$cacheTable          = $xoopsDB->prefix('xoonips_search_cache');
	$cacheItemTable      = $xoopsDB->prefix('xoonips_search_cache_item');
	$cacheMetadataTable  = $xoopsDB->prefix('xoonips_search_cache_metadata');
	$cacheFileTable      = $xoopsDB->prefix('xoonips_search_cache_file');
	
	// ɤΥåȤɤΥƥȤϢʤե
	$sql = "select file_id from $fileTable as tf left join $sessionTable as ts on tf.sess_id=ts.sess_id where tf.item_id is NULL and ts.sess_id is NULL";
	$result = $xoopsDB->query($sql);
	while ( list($file_id) = $xoopsDB->fetchRow($result) ){
		$path = xnpGetUploadFilePath($file_id);
		//echo " $file_id  $path <br />\n";
		if( is_file( $path ) ){
			unlink($path);
		}
		$xoopsDB->queryF("delete from $searchTextTable where file_id=$file_id");
		$xoopsDB->queryF("delete from $fileTable where file_id=$file_id");
	}
	
	// פsession_id  פsearch_cache_id 
	// פȤ  ( sessiontimeout )
	$scids = array();
	$sql = "select search_cache_id from $cacheTable as tc left join $sessionTable as ts on ts.sess_id=tc.sess_id where ts.sess_id is NULL )";
	$result = $xoopsDB->query( $sql );
	while ( list( $scid ) = $xoopsDB->fetchRow( $result ) )
		$scids[] = $scid;
	
	$tmp = implode( ",", $scids );
	$xoopsDB->queryF( "delete low_priority from $cacheTable         where search_cache_id in (" . $tmp . ")" );
	$xoopsDB->queryF( "delete low_priority from $cacheItemTable     where search_cache_id in (" . $tmp . ")" );
	$xoopsDB->queryF( "delete low_priority from $cacheMetadataTable where search_cache_id in (" . $tmp . ")" );
	$xoopsDB->queryF( "delete low_priority from $cacheFileTable     where search_cache_id in (" . $tmp . ")" );
}

/** make thumbnail images.
 * @param $file['tmp_name']  path to image file
 * @param $file['name']  original file name of image
 * @param $file['type'] mime-type of image
 * @return array(thumbnail,errorMessage)
 *   thumbnail: binary data of thumnailed image(PNG format). false if error.
 *   errorMessage: error messege if error. false if succeed.
 */
function xnpCreateThumbnail( $file ){
	$fileName = $file['tmp_name'];
	$type = $file['type'];
	
	// load gd
	if (!extension_loaded('gd')) {
		if (!dl('gd.so')) {
			echo "Error:  cannot load gd.so.  cannot create thumbnail.";
			exit;
		}
	}
	
	// The file type is judged from extensions.
	$ar = pathinfo($file['name']);
	$ext = strtolower($ar['extension']);
	if ( $type == 'image/jpeg' || $ext == 'jpg' || $ext == 'jpeg' || $ext == 'jpe'){ // In image/jp2, or image/jpm, How do we judge it?
		$imageID = @imagecreatefromjpeg($fileName);
	}
	else if ( $type == 'image/gif' || $ext == 'gif'){
		$imageID = @imagecreatefromgif($fileName);
	}
	else if ( $type == 'image/png' || $ext == 'png'){
		$imageID = @imagecreatefrompng($fileName);
	}
	else {
		// unknown image formats
		return array(false,_MD_XOONIPS_ITEM_THUMBNAIL_BAD_FILETYPE);
	}
	
	if (!$imageID){
		// failure in loading images.
		return array(false,_MD_XOONIPS_ITEM_THUMBNAIL_BAD_FILETYPE);
	}
	$width = imagesx($imageID);
	$height = imagesy($imageID);
	
	$maxWidth = 100; // maximum file size in thumbnail
	$maxHeight = 100;
	
	if ( $maxWidth < $width || $maxHeight < $height ){ // If size of image file is too large, need to reduce it.
		$scaleX = $maxWidth/$width;
		$scaleY = $maxHeight/$height;
		$scale = min($scaleX,$scaleY);
		$newWidth = round($width*$scale);
		$newHeight = round($height*$scale);
		
		// resize
		$newImageID = imagecreatetruecolor($newWidth, $newHeight);
		$result = imagecopyresized( $newImageID, $imageID, 0, 0, 0, 0, 
			$newWidth, $newHeight, $width, $height );
		
		$imageID = $newImageID;
		$width = $newWidth;
		$height = $newHeight;
	}
	$xnpsid = $_SESSION['XNPSID'];
	$tmpfile = "/tmp/XooNIpsThumbnail_${xnpsid}_". md5(uniqid(rand(),1)); // make a unique filename.
	$result = imagepng( $imageID, $tmpfile );
	if ( $result == false ){
		return array(false,"xnpCreateThumbnail: imagepng() failed.");
	}
	$result = file_get_contents( $tmpfile );
	unlink( $tmpfile );
	return array($result,false);
}


function xnpIsCommaSeparatedNumber( $str )
{
	$ar = array();
	return ( 1 == preg_match( '/^([0-9,]+)$/', $str, $ar ) );
}


/** get directory name stored attachment files that related to items.
 *  not contain '/' in end of character strings.
 */
function xnpGetUploadDir(){
	$uploadDir = '';
	xnp_get_config_value( "upload_dir" , $uploadDir  );
	
	if ( empty($uploadDir) ){
		echo "error: upload_dir is not configured.";
		return false;
	}
	
	if ( substr($uploadDir,-1) == "/" )
		return substr($uploadDir,0,-1);
	return $uploadDir;
}

/** make path stored files from file_id.
  * @param file_id file_id
  */
function xnpGetUploadFilePath( $file_id ){
	return xnpGetUploadDir() . '/' . (int)$file_id;
}

/** get corresponding culumns to condition from 'prefix("xoonips_file")' table.
  * @param columns acquired culumns
  * @param condition query of SQL. t_file and t_file_type are possible to use for tablename.
  * ex.  $files = xnpGetFileInfo( "t_file.file_id, t_file.", "t_file_type.name='preview' and ( item_id=$item_id or sid = $sid )" );
  * @return array( array( colum1, column2, ... ), ...);
  */
function xnpGetFileInfo( $columns, $condition, $item_id ){
	global $xoopsDB;
	
	$xnpsid = $_SESSION['XNPSID'];
	$esc_sess_id = addslashes( session_id() );
	$item_id = (int)$item_id;
	//$condition2 = " ( item_id is NULL and sid = $xnpsid or item_id = $item_id )";
	$condition2 = " ( item_id is NULL and sess_id = '$esc_sess_id' or item_id = $item_id )";
	
	$sql = "select $columns from " .
		$xoopsDB->prefix("xoonips_file") . " as t_file, " .
		$xoopsDB->prefix("xoonips_file_type") . " as t_file_type " .
		" where t_file.file_type_id = t_file_type.file_type_id and $condition and $condition2 ";
	$result = $xoopsDB->query( $sql );
	if ( $result == false ){
		echo "xnpGetFileInfo: $sql " . mysql_error();
		return false;
	}
	
	$files = array();
	while ( false != ( $row = $xoopsDB->fetchRow($result) ) )
		$files[] = $row;
	return $files;
}


/** 
 * 
 * get details of all indexes registered item_id.
 * 
 * @param SID
 * @param item_id item id of examined object
 * @param indexes return details of each index.
 * @return RES_OK
 * @return RES_ERROR
 * 
 */
function xnpGetIndexes( $xnpsid, $item_id, &$indexes ){
	$xids = array();
	$result = xnp_get_index_id_by_item_id( $xnpsid, $item_id, $xids );
	if ( $result == 0 ){
		$len = count( $xids );
		$indexes = array();
		for ( $i = 0; $i < $len; $i++ ){
			$xid = $xids[$i];
			$index = array();
			$result = xnp_get_index( $xnpsid, $xid, $index );
			if ( $result == 0 ){
				$indexes[] = $index;
			}
		}
		return RES_OK;
	}
	return RES_ERROR;
}


// make charater strings in current location (ex. /Private/Tools&Techniques ). from xoonips/edit.php
function xnpGetIndexPathString( $xnpsid, $xid ){
	return xnpHtmlspecialchars( xnpGetIndexPathServerString( $xnpsid, $xid ) );
}

function xnpGetIndexPathServerString( $xnpsid, $xid ){
	$dirArray = array();
	$dirArrayR = array();
	
	for ( $p_xid = $xid; $p_xid != IID_ROOT; $p_xid = (int)($index['parent_index_id']) ){
		// get $index
		$index = array();
		$result = xnp_get_index( $xnpsid, $p_xid, $index );
		if ( $result != 0 ){
			break;
		}
		
		$dirArray[] = $index;
	}
	$ct = count( $dirArray );
	for ( $i = 0; $i < $ct; $i++ ){
		$dirArrayR[] = $dirArray[ $ct-$i-1 ]['titles'][DEFAULT_INDEX_TITLE_OFFSET];
	}
	return '/ ' . implode( ' / ', $dirArrayR );
}



function xnpCreateHidden( $key, $val ){
//	return "<input type='hidden' name='$key' value='" . htmlspecialchars($val) . "'>";
	return "<input type='hidden' name='$key' value='" . xnpHtmlspecialchars($val) . "' />";
}

function xnpGetBasicInformationDetailBlock( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
    $item = array();
	if( xnp_get_item( $xnpsid, $item_id, $item ) != RES_OK ){
		return array();
	}
    $account = array();
	if( xnp_get_account( $xnpsid, $item['uid'], $account ) == RES_OK ){
		$contributor = $account['name']."(".$account['uname'].")";
		$item['uid'] = intval($item['uid']);
	}
    
	$tmparray = array();
	if( xnp_get_item_types( $tmparray ) == RES_OK ){
		foreach( $tmparray as $i ){
			if( $i['item_type_id'] == $item['item_type_id'] ){
				$itemtype = $i;
				$item_type = $itemtype['display_name'];
				break;
			}
		}
	}

	// ISO 639-2 3 letter code => Display name
//	$language_map = array_combine( explode( ',', _MD_XOONIPS_ITEM_LANG_OPTION_IDS ), explode( ',', _MD_XOONIPS_ITEM_LANG_OPTION_NAMES)n );
	$language_map = array( $item['lang'] => '' );
	$keys = explode( ',', _MD_XOONIPS_ITEM_LANG_OPTION_IDS );
	$values = explode( ',', _MD_XOONIPS_ITEM_LANG_OPTION_NAMES );
	while( count( $keys ) > 0 )
		$language_map[ array_pop( $keys ) ] = array_pop( $values );
	
    //make HTML of 'related to'
    $tpl = new xoopsTpl();
    $related_to = array();
    if( xnp_get_related_to( $xnpsid, $item['item_id'], $related_to ) == RES_OK ){
        $tpl->assign('item_htmls', itemid2ListBlock( $related_to ) );
    }

    $myts =& MyTextSanitizer::getInstance();
	return array(
	  'uid'				=> array( 'name'=>_MD_XOONIPS_ITEM_UID_LABEL		, 'value'=>$item['uid'] ),
	  'contributor'		=> array( 'name'=>_MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL, 'value'=>xnpHtmlspecialchars($contributor) ),
	  'title'			=> array( 'name'=>_MD_XOONIPS_ITEM_TITLE_LABEL			, 'value'=>xnpHtmlspecialchars(implode("\n", $item['titles'] ))),
	  'keywords'		=> array( 'name'=>_MD_XOONIPS_ITEM_KEYWORDS_LABEL		, 'value'=>xnpHtmlspecialchars(implode(",", $item['keywords'] ))),
	  'description'		=> array( 'name'=>_MD_XOONIPS_ITEM_DESCRIPTION_LABEL		, 'value'=>ereg_replace( "[\r\n]{1,2}", "<br />", xnpHtmlspecialchars( $item['description'] ) ) ),
	  'doi'				=> array( 'name'=>_MD_XOONIPS_ITEM_DOI_LABEL				, 'value'=>xnpHtmlspecialchars($item['doi'] ) ),
	  'last_update_date'=> array( 'name'=>_MD_XOONIPS_ITEM_LAST_UPDATE_DATE_LABEL, 'value'=>date( DATETIME_FORMAT, xoops_getUserTimestamp($item['last_update_date']) ) ),
	  'creation_date'	=> array( 'name'=>_MD_XOONIPS_ITEM_CREATION_DATE_LABEL	, 'value'=>date( DATETIME_FORMAT, xoops_getUserTimestamp($item['creation_date']) ) ),
	  'item_type'		=> array( 'name'=>_MD_XOONIPS_ITEM_ITEM_TYPE_LABEL		, 'value'=>xnpHtmlspecialchars($item_type ) ),
	  'change_logs'		=> array( 'name'=>_MD_XOONIPS_ITEM_CHANGELOGS_LABEL		, 'value'=>get_changelog_html( $xnpsid, $item_id ) ),
	  'publication_date'=> array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_DATE_LABEL,'value'=>xnpDate($item['publication_year'],$item['publication_month'],$item['publication_mday']) ),
	  'publication_year'=> array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_YEAR_LABEL,'value'=>$item['publication_year'] ),
	  'publication_month'=> array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_MONTH_LABEL,'value'=>$item['publication_month'] ),
	  'publication_mday'=> array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_MDAY_LABEL,'value'=>$item['publication_mday'] ),
	  'lang'=> array( 'name'=>_MD_XOONIPS_ITEM_LANG_LABEL,'value'=>$language_map[$item['lang']] ),
	  'related_to'=> array( 'name'=>_MD_XOONIPS_ITEM_RELATED_TO_LABEL, 'value'=>$tpl->fetch( "db:xoonips_detail_related_to.html" ) ),
	  'hidden' => 
	    xnpCreateHidden( 'title'               , implode( "\n",$item['titles'] ) ) . 
	    xnpCreateHidden( 'keywords'            , implode( ",",$item['keywords'         ] ) ) . 
	    xnpCreateHidden( 'description'         , $item['description'      ] ) . 
	    xnpCreateHidden( 'doi'                 , $item['doi'              ] ) . 
	    xnpCreateHidden( 'publicationDateYear' , $item['publication_year' ] ) . 
	    xnpCreateHidden( 'publicationDateMonth', $item['publication_month'] ) . 
	    xnpCreateHidden( 'publicationDateDay'  , $item['publication_mday' ] ) . 
	    xnpCreateHidden( 'lang'                , $item['lang'             ] ) . 
	    xnpCreateHidden( 'item_type_id'        , $item['item_type_id'     ] ) . 
	    ( count($related_to) ? xnpCreateHidden( 'related_to_check'    , implode( "\r\n", $related_to ) ) : "" )
	);
}

/* array of HTML named '$in' is table of '$col' rows.
	ex)
	$in = array( array(a0,a1,a2,a3,a4...), array(b0,b1,b2,...), array(c0,c1,c2,...) );
	$col = 2;
	array($in) becomes a table like the figure below.
		a0 a1
		b0 b1
		c0 c1
		a2 a3
		b2 b3
		c2 c3
		a4 a5
		...
*/

function xnpMakeTable( $in, $col ){
	$inLen = count($in);
	
	
	$maxLens = array();
	for ( $i = 0; $i < $inLen; $i++ )
		$maxLens[] = count($in[$i]);
	$maxLen = max($maxLens);
	
	// make table
	$out = array( "<table>\n" );
	for ( $i = 0; $i < $maxLen; $i += $col ){
		for ( $j = 0; $j < $inLen; $j++ ){
			$out[] = "<tr>\n";
			for ( $k = 0; $k < $col; $k++ ){
				$out[] = "<td align='center' valign='middle'>";
				if ( isset($in[$j][$i+$k]) )
					$out[] = $in[$j][$i+$k];
				$out[] = "</td>\n";
			}
			$out[] = "</tr>\n";
		}
	}
	$out[] = "</table>\n";
	return implode( '', $out );
}

/** get PreviewBlock for detail page.
  */
function xnpGetPreviewDetailBlock( $item_id ){
	
	// get file's information specified by item_id
	$files = xnpGetFileInfo( "t_file.file_id, t_file.caption", "t_file_type.name='preview' and sess_id is NULL ", $item_id );
	// generate HTML
	reset( $files );
	$imageHtml1 = array();
	$imageHtml2 = array();
	$fileIDs = array();
	while ( list( $dummy, list( $fileID, $caption) ) = each( $files ) ){
		$thumbnailFileName = XOOPS_URL . "/modules/xoonips/image.php?file_id=$fileID&thumbnail=1";
		$imageFileName = XOOPS_URL . "/modules/xoonips/image.php?file_id=$fileID";
//		$htmlCaption = htmlspecialchars( $caption );
		$htmlCaption = xnpHtmlspecialchars( $caption );
		$imageHtml1[] = "<a href='$imageFileName' target='_blank'><img src='$thumbnailFileName' ></a>";
		$imageHtml2[] = "$htmlCaption";
		$fileIDs[] = $fileID;
	}
	
	// make a table of three rows in side.
	$html = xnpMakeTable( array($imageHtml1,$imageHtml2), 3 );
	
	
	return array( 'name'=>_MD_XOONIPS_ITEM_PREVIEW_LABEL, 'value'=> $html, 
	  'hidden'=>xnpCreateHidden('previewFileID',implode(',',$fileIDs)) );
}

/** get AttachmentBlock for detail page.
  * display a warning dialog if link clicked( the case which download of the attachment file has been permitted ).
  * @param item_id item_id
  * @param name name of file type
  */
function xnpGetAttachmentDetailBlock( $item_id, $name ){
	// get attachment file
	// generate html
	$uid = UID_GUEST;
	if ( isset($_SESSION['xoopsUserId']) )
		$uid = $_SESSION['xoopsUserId'];
	
	$files = xnpGetFileInfo( "t_file.file_id, t_file.original_file_name, t_file.file_size, t_file.mime_type, unix_timestamp(t_file.timestamp)", "t_file_type.name='$name' and sess_id is NULL ", $item_id );
	if ( count( $files ) == 0 ){
		$html = "";
		$hidden = "";
	}
	else {
		list( list( $fileID, $fileName, $fileSize, $mimeType, $timestamp ) ) = $files;
//		$htmlFileName = htmlspecialchars($fileName);
		$htmlFileName = xnpHtmlspecialchars($fileName);
		$url = XOOPS_URL . "/modules/xoonips/download.php?file_id=$fileID";
		//$html = "<a href='$url' onClick='return confirm(\""._MD_XOONIPS_ITEM_DOWNLOAD_CONFIRMATION."\")'>$htmlFileName</a>  $fileSize bytes";
		
		$html = 
		  " $htmlFileName<br />
		    <table>
		     <tr>
		      <td>"._MD_XOONIPS_ITEM_TYPE_LABEL."</td>
		      <td>: $mimeType</td>
		      <td rowspan='4' valign='middle'>
		        <form method='get' action='download.php'>
		          <input type='hidden' name='file_id' value='$fileID' />
		          <input onclick='return confirm(\""._MD_XOONIPS_ITEM_DOWNLOAD_CONFIRMATION."\"); ' type='submit' value='"._MD_XOONIPS_ITEM_DOWNLOAD_LABEL."' />
		        </form>
		      </td>
		     </tr>
		     <tr>
		      <td>"._MD_XOONIPS_ITEM_SIZE_LABEL."</td>
		      <td>: $fileSize bytes</td>
		     </tr>
		     <tr>
		      <td>"._MD_XOONIPS_ITEM_LAST_UPDATED_LABEL."</td>
		      <td>: ".date(DATE_FORMAT, $timestamp)."</td>
		     </tr>
		    </table>";
		$hidden = xnpCreateHidden($name.'FileID',$fileID);
		$item = array();
		if( ( $res = xnp_get_item( $_SESSION['XNPSID'], $item_id, $item ) ) == RES_OK ){
			$itemtypes = array();
			if( ( $res = xnp_get_item_types( $itemtypes ) ) == RES_OK ){
				// don't require license agreement if download forbidden
				foreach( $itemtypes as $itemtype ){
					if ( $itemtype['item_type_id'] != $item['item_type_id'] ) continue;
					$module_name = $itemtype['name'];
					include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
					$fname_dllimit = "${module_name}GetAttachmentDownloadLimitOption";
					if( function_exists( $fname_dllimit ) && $fname_dllimit( $item_id ) == 1 ){
						if( $uid == UID_GUEST ){
							$html = "<a href='$url'>$htmlFileName</a>  $fileSize bytes";
						}
						$html .= " &nbsp;&nbsp;("._MD_XOONIPS_ITEM_ATTACHMENT_DL_LIMIT_LOGINUSER_ONLY_LABEL.")";
					}
				}
			}
		}
	}
	return array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=> $html, 'hidden' => $hidden );
}

/** get FilenameBlock of attachment
  * display a warning dialog if link clicked( the case which download of the attachment file has been permitted ).
  * @param item_id item_id
  * @param name name of file type
  */
function xnpGetAttachmentFilenameBlock( $item_id, $name ){
	// get attachment file
	// generate html
	$files = xnpGetFileInfo( "t_file.file_id, t_file.original_file_name", "t_file_type.name='$name' and sess_id is NULL ", $item_id );
	if ( count( $files ) == 0 ){
		$html = "";
	}
	else {
		list( list( $fileID, $fileName ) ) = $files;
		if (xnpChkServerLang()) {
			if (mb_substr_count( $fileName, "." ) > 0 ) {
				$fileName = mb_substr( $fileName, 0, mb_strrpos( $fileName, "." ) );
			}
		}
		else {
			if (substr_count( $fileName, "." ) > 0 ) {
				$fileName = substr($fileName,0,strlen($fileName) - strlen(strrchr($fileName,".")));
			}
		}
		$htmlFileName = xnpHtmlspecialchars($fileName);
		$html = "$htmlFileName";
	}
	return array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=> $html );
}
/** get MimetypeBlock of Attachment
  * display a warning dialog if link clicked( the case which download of the attachment file has been permitted ).
  * @param item_id item_id
  * @param name name of file type
  */
function xnpGetAttachmentMimetypeBlock( $item_id, $name ){
	// get attachment file
	// generate html
	$files = xnpGetFileInfo( "t_file.file_id, t_file.mime_type", "t_file_type.name='$name' and sess_id is NULL ", $item_id );
	if ( count( $files ) == 0 ){
		$html = "";
	}
	else {
		list( list( $fileID, $mimetype ) ) = $files;
		$html = "$mimetype";
	}
	return array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=> $html );
}
/** get FiletypeBlock of Attachment
  * display a warning dialog if link clicked( the case which download of the attachment file has been permitted ).
  * @param item_id item_id
  * @param name name of file type
  */
function xnpGetAttachmentFiletypeBlock( $item_id, $name ){
	// get attachment file
	// generate html
	$files = xnpGetFileInfo( "t_file.file_id, t_file.original_file_name", "t_file_type.name='$name' and sess_id is NULL ", $item_id );
	if ( count( $files ) == 0 ){
		$html = "";
	}
	else {
		list( list( $fileID, $fileType ) ) = $files;
		if (xnpChkServerLang()) {
			if (mb_substr_count( $fileType, "." ) == 0 ) {
				$fileType = "";
			}
			else {
				$fileType = mb_substr( $fileType, mb_strrpos( $fileType, "." ) + 1 );
			}
		}
		else {
			if (substr_count( $fileType, "." ) == 0 ) {
				$fileType = "";
			}
			else {
				$fileType = substr($fileType,strrpos($fileType,".")+1);
			}
		}
		$htmlFileType = xnpHtmlspecialchars($fileType);
		$html = "$htmlFileType";
	}
	return array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=> $html );
}

/** get TextFileBlock for detail page
 * @param item_id item_id
 * @param name name of file type
 */
function xnpGetTextFileDetailBlock( $item_id, $name, $text ){
	$myts =& MyTextSanitizer::getInstance();
	return array( 'name'=>_MD_XOONIPS_ITEM_TEXTFILE_LABEL, 'value'=> "<textarea readonly rows='5' cols='40'>".xnpHtmlspecialchars($text)."</textarea>",
		'hidden'=>xnpCreateHidden($name.'EncText',$text) );
}



/** 
  * $item_id ID of item to display index
  * $button_flag if certify button, uncertify button, withdraw button are displayed, flag is set to true. (default=true)
  * return array( 'name'=>(html), 'value'=>(html) )
  */
function xnpGetIndexDetailBlock( $item_id, $button_flag = true ){
	$xnpsid = $_SESSION['XNPSID'];
	
	$uid = 0;
	if ( isset($_SESSION['xoopsUserId']) )
		$uid = $_SESSION['xoopsUserId'];
	
	$indexes = array();
	$result = xnpGetIndexes( $xnpsid, $item_id, $indexes );
	if ( $result == 0 ){
		$len = count( $indexes );
		$xids = array();
		$ar = array(
			"<form method='post' action='#'>\n".
			"<input type='hidden' name='op' value='' />\n".
			"<table>\n" );
		for ( $i = 0; $i < $len; $i++ ){
			$xid = $indexes[$i]['item_id'];
			$str = xnpGetIndexPathString( $xnpsid, $xid );
			$state = NOT_CERTIFIED;
			if( xnp_get_certify_state( $xnpsid, $xid, $item_id, $state ) == RES_OK ){
				$indexes[$i]['certified'] = $state;
			}
			$xids[] = $xid;
		}
		usort( $indexes, "indexcmp" );
		$groupby = array();
		for ( $i = 0; $i < $len; $i++ ){
			$open_level = $indexes[$i]['open_level'];
			$owner_gid = $indexes[$i]['owner_gid'];
			$certified = $indexes[$i]['certified'];
			if( !array_key_exists( $open_level, $groupby ) )
				$groupby[$open_level] = array();
			if( !array_key_exists( $owner_gid, $groupby[$open_level] ) )
				$groupby[$open_level][$owner_gid] = array();
			if( !array_key_exists( $certified, $groupby[$open_level][$owner_gid] ) )
				$groupby[$open_level][$owner_gid][$certified] = array();
			array_push( $groupby[$open_level][$owner_gid][$certified], $i );
		}
		
		$classes = array( 'odd', 'even' );
		foreach( $groupby as $open_level => $i ){
			foreach( $i as $owner_gid => $j ){
				foreach( $j as $certified => $k ){
					$xid_array = array();
					$html = '<tr class="'.$classes[0].'">';
					$classes = array_reverse( $classes );
					$html .= "<td style='vertical-align:middle;'>";
					foreach( $k as $id ){
						$xid = $indexes[$id]['item_id'];
						$html .= "<a href='listitem.php?index_id=$xid'>".xnpGetIndexPathString( $xnpsid, $xid )."</a>";
						$html .= '<br />';
						array_push( $xid_array, $xid );
					}
					$html .= '</td>';
					if( $button_flag && $certified == CERTIFIED
						&& ( $open_level == OL_PUBLIC || $open_level == OL_GROUP_ONLY )
						&& xnp_get_certify_permission( $xnpsid, $xid, $item_id, NOT_CERTIFIED ) ){
						$button_label = _MD_XOONIPS_ITEM_UNCERTIFY_BUTTON_LABEL;
						if( xnp_get_item_permission( $xnpsid, $item_id, OP_MODIFY ) ){
							$button_label = _MD_XOONIPS_ITEM_WITHDRAW_BUTTON_LABEL;
						}
						$button = "<input type='button' value='${button_label}' onclick='withdraw_confirm( \"".implode( ',', $xid_array )."\", $item_id);' />";
					}else if( $button_flag && $certified == CERTIFY_REQUIRED
						&& ( $open_level == OL_PUBLIC || $open_level == OL_GROUP_ONLY ) ){
						if( xnp_get_certify_permission( $xnpsid, $xid, $item_id, CERTIFIED ) ){
							$button = "<input type='button' value='"._MD_XOONIPS_ITEM_CERTIFY_BUTTON_LABEL."' onclick='accept_certify_confirm( \"".implode( ',', $xid_array )."\", $item_id);' />&nbsp;"
								."<input type='button' value='"._MD_XOONIPS_ITEM_UNCERTIFY_BUTTON_LABEL."' onclick='cancel_certify_confirm( \"".implode( ',', $xid_array )."\", $item_id);' />";
						}else{
							$button = _MI_XOONIPS_ITEM_PENDING_NOW;
						}
					}else{
						$button = "";
					}
					$html .= "<td style='vertical-align:middle; text-align:left;'>$button</td>";
					$html .= "</tr>\n";
					$ar[] .= $html;
				}
			}
		}
		$ar[] = "</table></form>\n";
		
		$block = array();
		$block['name'] = 'Index';
		$block['value'] = implode( '', $ar );
		$block['hidden'] = xnpCreateHidden('xoonipsCheckedXID', implode( ',', $xids ) );
		return $block;
	}
	// todo
	return false;
}


function xnpGetBasicInformationEditBlock( $item_id ){
	//1.get item information (and change log) using item_id.
	//2.If item information is set to $_POST, Result of 1. is overwrited in the value of $_POST. 
    //  (only for title, description, keywords, doi, publication_year/month/day)
	//3.Last, Result of 2 is set to associate_array.
	$xnpsid = $_SESSION['XNPSID'];
	$item = array();
	$itemtype = array();
	$account = array();
	$tmparray = array();
	$uid = $_SESSION['xoopsUserId'];
	if( xnp_get_item( $xnpsid, $item_id, $item ) != RES_OK ){
		return array();
	}else{
        $title = implode( "\n", $item['titles'] );
        $keywords = implode( ",", $item['keywords'] );
        $description = $item['description'];
        $doi = $item['doi'];
        $publication_year  = $item['publication_year'];
        $publication_month = $item['publication_month'];
        $publication_mday  = $item['publication_mday'];
        $lang  = $item['lang'];
        $change_log = "";
    }
    
	if( xnp_get_item_types( $tmparray ) != RES_OK ){
		return array();
	}else{
		foreach( $tmparray as $i ){
			if( $i['item_type_id'] == $item['item_type_id'] ){
				$itemtype = $i;
				$item_type = $itemtype['display_name'];
				break;
			}
		}
	}
	if( xnp_get_account( $xnpsid, $uid, $account ) == RES_OK ){
		$contributor = $account['name']."(".$account['uname'].")";
	}
    $log = get_changelog_html( $xnpsid, $item_id );
    
    //Basic information which gets from database is overwrited by the value of $_POST.
    $myts =& MyTextSanitizer::getInstance();
    foreach( array( 'title', 'keywords', 'description', 'doi', 'change_log', 'lang', 'related_to' ) as $k ){
        if( array_key_exists( $k, $_POST ) ){ $$k = $myts->stripSlashesGPC( $_POST[$k] ); }
    }
    
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	if ( isset($_POST['publicationDateYear' ]) ) $publication_year  = $_POST['publicationDateYear' ];
	if ( isset($_POST['publicationDateMonth']) ) $publication_month = $_POST['publicationDateMonth'];
	if ( isset($_POST['publicationDateDay'  ]) ) $publication_mday  = $_POST['publicationDateDay'  ];
	$tpl->assign('gmtime', xnpMktime($publication_year, $publication_month, $publication_mday));
	$tpl->assign('lang_option_ids', explode( ',', _MD_XOONIPS_ITEM_LANG_OPTION_IDS) );
	$tpl->assign('lang_option_names', explode( ',', _MD_XOONIPS_ITEM_LANG_OPTION_NAMES) );
	$tpl->assign('lang_option_default_id', isset( $_POST['lang'] ) ? $_POST['lang'] : $item['lang'] );

	$tpl_related = new xoopsTpl();
    $related_ids = array();
    if( xnp_get_related_to( $xnpsid, $item_id, $related_ids ) == RES_OK ){
        $item_htmls = array();
        //get state of checkbox from the value of 'related_to_check'
        //Item information is acquired with 'itemid2ListBlock'. And it is set to '$html_htmls'.
        if( isset( $_POST['related_to_check'] ) ){
            $related_to_check = $_POST['related_to_check'];
            if( is_array( $_POST['related_to_check'] ) )
                $related_to_check = $_POST['related_to_check'];
            else
                $related_to_check = preg_split( "/[\r\n]+/", $_POST['related_to_check'] );
        }
        foreach( itemid2ListBlock( $related_ids ) as $id=>$html ){
            $item_htmls[$id]=array( 'html' => $html,
                                    'check' => !isset( $related_to_check )
                                    || in_array( $id, $related_to_check ) );
        }
        $tpl_related -> assign('item_htmls', $item_htmls );
    }
    $tpl_related ->assign('related_to', isset( $_POST['related_to'] ) ? $_POST['related_to'] : '' );
    
    $ret = array();
    $ret['item_type']        = array( 'name'=>_MD_XOONIPS_ITEM_ITEM_TYPE_LABEL		, 'value'=>$item_type );
	$ret['contributor']      = array( 'name'=>_MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL		, 'value'=>xnpHtmlspecialchars($contributor) );
	$ret['title']            = array( 'name'=>_MD_XOONIPS_ITEM_TITLE_LABEL._MD_XOONIPS_ITEM_REQUIRED_MARK, 'value'=>"<textarea name='title' rows='3' cols='50'>".xnpHtmlspecialchars($title,ENT_QUOTES)."</textarea>" );
	$ret['keywords']         = array( 'name'=>_MD_XOONIPS_ITEM_KEYWORDS_LABEL		, 'value'=>"<input size=50 type='text' name='keywords' value='".xnpHtmlspecialchars($keywords,ENT_QUOTES)."' /> <br />".
	                                                                                       " Separate the words or phrases with commas." );
	$ret['description']      = array( 'name'=>_MD_XOONIPS_ITEM_DESCRIPTION_LABEL		, 'value'=>"<textarea rows=5 cols=50 name='description'>".xnpHtmlspecialchars($description,ENT_QUOTES)."</textarea>" );
	$ret['doi']              = array( 'name'=>_MD_XOONIPS_ITEM_DOI_LABEL				, 'value'=>"<input type='text' name='doi' value='".xnpHtmlspecialchars($doi,ENT_QUOTES)."' />" );
	$ret['last_update_date'] = array( 'name'=>_MD_XOONIPS_ITEM_LAST_UPDATE_DATE_LABEL, 'value'=>date( DATETIME_FORMAT, xoops_getUserTimestamp($item['last_update_date']) ) );
	$ret['creation_date']    = array( 'name'=>_MD_XOONIPS_ITEM_CREATION_DATE_LABEL	, 'value'=>date( DATETIME_FORMAT, xoops_getUserTimestamp($item['creation_date']) ) );
	$ret['change_log']       = array( 'name'=>_MD_XOONIPS_ITEM_CHANGELOG_LABEL	    , 'value'=>"<input size=50 type='text' name='change_log' value='".xnpHtmlspecialchars($change_log,ENT_QUOTES)."' />" );
	if( $log != '' )
        $ret['change_logs']  = array( 'name'=>_MD_XOONIPS_ITEM_CHANGELOGS_LABEL		, 'value'=>$log );
	$ret['publication_date'] = array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_DATE_LABEL, 'value'=>$tpl->fetch( "db:xoonips_publication_date.html" ) );
	$ret['publication_year'] = array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_YEAR_LABEL, 'value'=>$tpl->fetch( "db:xoonips_publication_year.html" ) );
	$ret['publication_month'] = array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_MONTH_LABEL, 'value'=>$tpl->fetch( "db:xoonips_publication_month.html" ) );
	$ret['publication_mday'] = array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_MDAY_LABEL, 'value'=>$tpl->fetch( "db:xoonips_publication_mday.html" ) );
	$ret['lang'] = array( 'name'=>_MD_XOONIPS_ITEM_LANG_LABEL, 'value'=>$tpl->fetch( "db:xoonips_lang.html" ) );
	$ret['related_to'] = array( 'name'=>_MD_XOONIPS_ITEM_RELATED_TO_LABEL, 'value'=>$tpl_related->fetch( "db:xoonips_edit_related_to.html" ) );
    return $ret;
}

/** upload file inserts into database. and file is moved at hand.
  * todo: Should I check the authority of the item_id?
  * @param name input tag name used in upload
  * @param item_id  item_id. false (in register)
  * @param escKeyVal column which need to add Insert sentence of SQL
  * @return return array(file_id,errorMessage) normal array:errorMessage=false, error array:file_id=false.
  */
function xnpUploadFile( $name, $keyval ){
	global $xoopsDB;
	$ts =& MyTextSanitizer::getInstance();
	
	$esc_sess_id = addslashes($_SESSION['XNPSID']);
	
	// get file_type_id
	$sql = "select file_type_id from " . $xoopsDB->prefix('xoonips_file_type') . " where name='$name' ";
	$result = $xoopsDB->query( $sql );
	if ( $result == false ){
		return array(false,"xnpUploadFile: bad sql $sql " . mysql_error());
	}
	list( $fileTypeID ) = $xoopsDB->fetchRow($result);
	if ( empty( $fileTypeID ) ){
		return array(false,"xnpUploadFile: no filetype '$name' ");
	}
	
	// fileơ֥˵Ͽ
	$ar = array(
		'original_file_name'   =>  $ts->stripSlashesGPC( $_FILES[$name]['name'    ] ),
		'mime_type'            =>  $ts->stripSlashesGPC( $_FILES[$name]['type'    ] ),
	);
	xnpTrimColumn( $ar, 'xoonips_file', array_keys( $ar ), _CHARSET );
	
	// record in file table
	$escOriginalFileName = addslashes( $ar['original_file_name'] );
	$escMimeType         = addslashes( $ar['mime_type'         ] );
	$fileSize         = (int)$_FILES[$name]['size'];
	$escKeys = "";
	$escVals = "";
	if ( is_array( $keyval ) && count($keyval) != 0 ){
		reset( $keyval );
		while ( list($key,$val) = each($keyval) ){
			$escKeys .= "," . addslashes($key);
			$escVals .= ",'" . addslashes($val) . "'";
		}
	}
	$error = (int)$_FILES[$name]['error'];
	if ( $error != 0 ){
		if ( $error == UPLOAD_ERR_INI_SIZE )
			$errorMessage = _MD_XOONIPS_ITEM_UPLOAD_FILE_TOO_LARGE;
		else
			$errorMessage = _MD_XOONIPS_ITEM_UPLOAD_FILE_FAILED;
		return array(false,$errorMessage);
	}
	$sql = "insert into " . $xoopsDB->prefix('xoonips_file') . 
		" ( original_file_name, mime_type, file_size, sess_id, item_id, file_type_id  $escKeys ) ".
		" values ( '$escOriginalFileName', '$escMimeType', $fileSize, '$esc_sess_id', NULL, $fileTypeID  $escVals) ";
	$result = $xoopsDB->queryF( $sql );
	if ( $result == false ){
		return array(false,"xnpUploadFile: bad sql $sql " . mysql_error());
	}
	
	// file is moved at hand.
	$fileID = $xoopsDB->getInsertId();
	$filePath = xnpGetUploadFilePath($fileID);
	$escFilePath = addslashes( $filePath );
	$uploadTmpDirPath = $ts->stripSlashesGPC( ini_get("upload_tmp_dir") );
	if( !empty($uploadTmpDirPath) ){
		if( !is_writable($uploadTmpDirPath) ){
			return array(false, "xnpUploadFile: cannot write. in " . $uploadTmpDirPath);
		}
	}
	if( !is_writable(xnpGetUploadDir()) ){
		return array(false, "xnpUploadFile: cannot write. in " . xnpGetUploadDir());
	} else {
		$result = move_uploaded_file( $_FILES[$name]['tmp_name'], $filePath );
		if ( $result == false ){
			return array(false,"xnpUploadFile: cannot move_uploaded_file. \n $name " . $_FILES[$name]['tmp_name'] . " to " . $filePath);
		}
	}
	
	// file -> search_text, header, search_module_name, search_module_version 
	$modules = xnpGetFileSearchModules();
	list( $result, $errorMessage ) = xnpExtractText( $fileID, $modules );
	//if ( $result == false )
	//	return array( $fileID, $errorMessage );
	
	return array($fileID,false);
}

/** generate PreviewBlock HTML in edit page
  * @param item_id false(no HTML)
  */
function xnpGetPreviewEditBlock( $item_id ){
	global $xoopsDB;
	$myts =& MyTextSanitizer::getInstance();;
	$errorHTML = $errorMessage = $errorMessage1 = $errorMessage2 = '';
	
	$files = array();
	if ( isset( $_POST['previewFileID'] ) ){ // User comes from some edit pages.
		if ( $_POST['previewFileID'] == "" )
			$previewFileIDs = array();
		else {
			// illegal inputs are removed.
			if ( !xnpIsCommaSeparatedNumber( $_POST['previewFileID'] ) ){
				echo "Error: bad previewFileID";
				return false;
			}
			$previewFileIDs = explode( ',', $_POST['previewFileID'] );
		}
		// process of upload/delete
		if ( empty($_POST['mode']) ){
		}
		else if ( $_POST['mode'] == 'Upload' ){
			// upload something
			if ( !empty( $_FILES['preview']['name'] ) ){
				$keyval = array();
				$keyval['caption'] = $myts->stripSlashesGPC($_POST['previewCaption']);
				xnpTrimColumn( $keyval, 'xoonips_file', array_keys( $keyval ), _CHARSET );
				if ( !is_uploaded_file( $_FILES['preview']['tmp_name'] ) ){
					$errorMessage = "Unexpected file(not uploaded file?). '".$_FILES['preview']['name']."'";
				}else{
					list($keyval['thumbnail_file'],$errorMessage) = xnpCreateThumbnail( $_FILES['preview'] );
					if ( $keyval['thumbnail_file'] ) {
						list($fileID,$errorMessage2) = xnpUploadFile( 'preview', $keyval );
						if ( $fileID )
							$previewFileIDs[] = $fileID;
						if ($errorMessage2)
							$errorMessage = $errorMessage2;
					}
				}
				$_SESSION['xoonips_preview_message'] = $errorMessage;
			}
			// error message is set to $_SESSION, and it is acquired in GET
			// ( POST is converted into GET at edit.php, and register.php ).
			else if ( isset($_SESSION['xoonips_preview_message']) ) 
				$errorMessage = $_SESSION['xoonips_preview_message'];
		}
		else if ( $_POST['mode'] == 'Delete' ){
			// $_POST['file_id'] delete from $previewFileID.
			$ar = array();
			foreach( $previewFileIDs as $value ){
				if ( $value != $_POST['fileID'] )
					$ar[] = $value;
			}
			$previewFileIDs = $ar;
		}
		
		// previewFileID -> files
		if ( count($previewFileIDs) ){
			$sql = "t_file.file_id in (" . implode( ',', $previewFileIDs ) . ")";
			$files = xnpGetFileInfo( "t_file.file_id, t_file.caption", 
				"t_file_type.name='preview' and $sql ", $item_id );
		}
		// Value of previewFileID are returned to $_POST ( Value of $_POST is saved and restored on register.php ).
		$_POST['previewFileID'] = implode( ',', $previewFileIDs );
	}
	// user comes from non-editing pages.
	else {
		// get default value from database.
		if ( !empty($item_id) ){
			$files = xnpGetFileInfo( "t_file.file_id, t_file.caption", "t_file_type.name='preview' and item_id=$item_id ", $item_id );
			//echo "xnpGetPreviewEditBlock: item_id = $item_id "; var_dump( $files );
		}
	}

/*
	function xnpSubmitFileUpload( name ){
		document.getElementsByName('mode').item(0).value = 'Upload';
		return true;
	}
	function xnpSubmitFileDelete( name, fileID ){
		document.getElementsByName('mode').item(0).value = 'Delete';
		document.getElementsByName('mode').item(0).value = fileID;
		return true;
	}

*/
	// display files in HTML format.
	$ar = array();
	reset( $files );
	while ( list( $key, list( $fileID, $caption ) ) = each( $files ) ){
		$ar[] = $fileID;
	}
	$previewFileID = implode( ',', $ar );
	if ( $errorMessage )
		$errorHTML = "<font color='#ff0000'>" . htmlspecialchars($errorMessage) . "</font><br />";
/*
	$uploadHtml = "
		<input type='hidden' name='previewFileID' value='$previewFileID' />
		$errorHTML
		<table>
			<tr>
				<td>File: </td>
				<td><input type='file' name='preview' />
				<input type='button' name='' value='Upload' onclick=\"xnpSubmitFileUpload(this,'preview')\" /></td>
			</tr>
			<tr>
				<td>Caption:</td>
				<td><input type='text' name='previewCaption' /></td>
			</tr>
		</table>\n";
*/
	$uploadHtml = "
		<input type='hidden' name='previewFileID' value='$previewFileID' />
		$errorHTML
		<table>
			<tr>
				<td width='100'>"._MD_XOONIPS_ITEM_FILE_HEAD_LABEL."</td>
				<td><input size=30 type='file' name='preview' />
				<input type='button' name='#' value='"._MD_XOONIPS_ITEM_UPLOAD_LABEL."' onclick=\"xnpSubmitFileUpload(this,'preview')\" /></td>
			</tr>
			<tr>
				<td width='100'>"._MD_XOONIPS_ITEM_CAPTION_HEAD_LABEL."</td>
				<td><input size=30 type='text' name='previewCaption' /></td>
			</tr>
		</table>\n";
	
	$imageHtml1 = array();
	$imageHtml2 = array();
	$imageHtml3 = array();
	reset( $files );
	while ( list( $dummy, list( $fileID, $caption) ) = each( $files ) ){
		$thumbnailFileName = XOOPS_URL . "/modules/xoonips/image.php?file_id=$fileID&thumbnail=1";
		$imageFileName = XOOPS_URL . "/modules/xoonips/image.php?file_id=$fileID";
//		$htmlCaption = htmlspecialchars( $caption );
		$htmlCaption = xnpHtmlspecialchars( $caption );
		$imageHtml1[] = "<a href='$imageFileName' target='_blank'><img src='$thumbnailFileName' alt='thumbnail'></a>";
		$imageHtml2[] = "$htmlCaption";
//		$imageHtml3[] = "<input type='button' name='' value='Delete' onclick=\"xnpSubmitFileDelete(this,'preview', $fileID )\" />";
		$imageHtml3[] = "<input type='button' name='#' value='"._MD_XOONIPS_ITEM_DELETE_BUTTON_LABEL."' onclick=\"xnpSubmitFileDelete(this,'preview', $fileID )\" />";
	}
	$html = xnpMakeTable( array($imageHtml1,$imageHtml2,$imageHtml3), 3 );
	
	return array( 'name'=>_MD_XOONIPS_ITEM_PREVIEW_LABEL, 'value'=>$uploadHtml . $html );
}

function xnpGetAttachmentEditBlock( $item_id, $name )
{
	$sql = "t_file.file_id, t_file.original_file_name, t_file.file_size";
	// get file information.
	if ( isset( $_POST[$name.'FileID'] )  ){ 
		$fileID = (int)$_POST[$name.'FileID'];// user comes from Confirm/Edit/Register page.
		if ( $fileID )
			$fileInfo = xnpGetFileInfo( $sql, "t_file.file_id = $fileID", $item_id );
		// there is a deletion demand of a file
		if ( xnpGetPostVarDef('mode','') == 'Delete' && $fileID == $_POST['fileID'] ){
			$fileInfo = false;
		}
	}
	else if ( !empty($item_id) ){ // get default value from database.
		$fileInfo = xnpGetFileInfo( $sql, "t_file_type.name='$name' and sess_id is NULL", $item_id );
	}
	
	
	// generate html
	if ( empty( $fileInfo ) ){
		$fileID = false;
		$fileInfoLine = "";
	}
	else {
		list( list( $fileID, $fileName, $fileSize ) ) = $fileInfo;
		$fileName = encodeMacSafari2Server($fileName);
//		$fileInfoLine = "$fileName  ($fileSize Bytes) <input type='button' name='' value='Delete' onclick=\"xnpSubmitFileDelete(this,'$name', $fileID )\" />";
		$fileInfoLine = "$fileName  ($fileSize Bytes) <input type='button' name='' value='"._MD_XOONIPS_ITEM_DELETE_BUTTON_LABEL."' onclick=\"xnpSubmitFileDelete(this,'$name', $fileID )\" />";
	}
	$html = "
		<input type='hidden' name='${name}FileID' value='$fileID' />
		<input type='file' name='$name' size='50' /><br />
		$fileInfoLine";

	return array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=>$html);
}

/**
 * 
 * @param dirname module dirname
 * @param option download limit option(0:everyone, 1:login user only)
 */
function xnpGetDownloadLimitationOptionEditBlock( $dirname, $option )
{
    return xnpGetDownloadLimitationOptionRegisterBlock( $dirname, $option );
}
function xnpGetDownloadLimitationOptionRegisterBlock( $dirname, $option = 0 )
{
	global $xoopsDB;
    $mhandler =& xoops_gethandler('module');
    $module = $mhandler->getByDirname( $dirname );
    $chandler = & xoops_gethandler('config');
    $assoc = $chandler->getConfigsByCat(false, $module->mid());
    $enable_dl_limit = 0;
    if( isset( $assoc['enable_dl_limit'] ) && $assoc['enable_dl_limit'] == '1' ) $enable_dl_limit = 1;
    
    if( $enable_dl_limit == 1 ){
        if( isset( $_POST['attachment_dl_limit'] ) ) $option = $_POST['attachment_dl_limit'];
        $html = "<input type='radio' name='attachment_dl_limit' value='1'";
        if( $option == 1 ) $html .= ' checked';

        // $html .= ">"._MD_XOONIPS_ITEM_ATTACHMENT_DL_LIMIT_LOGINUSER_LABEL."</input>"
        $html .= " />"._MD_XOONIPS_ITEM_ATTACHMENT_DL_LIMIT_LOGINUSER_LABEL
            ."<input type='radio' name='attachment_dl_limit' value='0'";
        if( $option != 1 ) $html .= ' checked';
        // $html .= ">"._MD_XOONIPS_ITEM_ATTACHMENT_DL_LIMIT_EVERYONE_LABEL."</input>";
        $html .= " />"._MD_XOONIPS_ITEM_ATTACHMENT_DL_LIMIT_EVERYONE_LABEL;
    }else{
        $html = _MD_XOONIPS_ITEM_ATTACHMENT_DL_LIMIT_EVERYONE_LABEL
            ."<input type='hidden' name='attachment_dl_limit' value='0'/>";
    }
    return array( 'name' => _MD_XOONIPS_DOWNLOAD_LIMITATION_OPTION_LABEL, 'value' => $html );
}
function xnpGetDownloadLimitationOptionConfirmBlock( $dirname )
{
	global $xoopsDB;
    $mhandler =& xoops_gethandler('module');
    $module = $mhandler->getByDirname( $dirname );
    $chandler = & xoops_gethandler('config');
    $assoc = $chandler->getConfigsByCat(false, $module->mid());
    $enable_dl_limit = 0;
    if( isset( $assoc['enable_dl_limit'] ) && $assoc['enable_dl_limit'] == '1' ) $enable_dl_limit = 1;
    $html = '';
    if( $enable_dl_limit == 1 ){
        if( isset( $_POST['attachment_dl_limit'] ) && $_POST['attachment_dl_limit'] == 1 )
            $html .= _MD_XOONIPS_ITEM_ATTACHMENT_DL_LIMIT_LOGINUSER_LABEL
                ."<input type='hidden' name='attachment_dl_limit' value='1'/>";
        else
            $html .= _MD_XOONIPS_ITEM_ATTACHMENT_DL_LIMIT_EVERYONE_LABEL
                ."<input type='hidden' name='attachment_dl_limit' value='0'/>";
    }else{
        $html = _MD_XOONIPS_ITEM_ATTACHMENT_DL_LIMIT_EVERYONE_LABEL
            ."<input type='hidden' name='attachment_dl_limit' value='0'/>";
    }
    return array( 'name' => _MD_XOONIPS_DOWNLOAD_LIMITATION_OPTION_LABEL, 'value' => $html );
}
    
function xnpHeadText( $text ){
	$text = str_replace( "\r\n", "\n", $text );
	$text = str_replace( "\r", "\n", $text );
	$ar = preg_split( "/[\r\n]+/", $text );
	if ( count($ar) > 4 || count($ar) == 4 && $ar[3] != "" ){
		$text = $ar[0]."\n".$ar[1]."\n".$ar[2]." ...";
	}
	return $text;
}

function xnpGetTextFileEditBlock( $item_id, $name, $defaultText )
{
	$myts =& MyTextSanitizer::getInstance();
	// select, text, fileInfo
	$item_id = (int)$item_id;
	
	if ( isset( $_POST[$name.'EncText'] ) ){ // There is initial value specification by POST.
		$text = $myts->stripSlashesGPC($_POST[$name.'EncText']);
	}
	else { // There is no initial value specification by POST. use the value of $defaultText.
		$text = $defaultText;
	}
	
	$showText = xnpHeadText( $text );
	$encText = xnpHtmlspecialchars($text);
	$htmlShowText = nl2br(xnpHtmlspecialchars($showText));
	if ( $htmlShowText == "" ){
		$htmlShowText = "&nbsp;"; // div.firstChild is prevented being set to null.
	}
	$html = "
		<table width='100%'><tr>
		<td>
			<div id='${name}ShowText'>$htmlShowText</div>
		</td>\n
		<td style='vertical-align: text-bottom; text-align:right'><a href='#' onclick=\"return xnpOpenTextFileInputWindow('$name',$item_id)\">" . _MD_XOONIPS_ITEM_TEXT_FILE_EDIT_LABEL . "</a></td>\n
		</table>\n
		<input type='hidden' name='${name}EncText' value='$encText'  id='${name}EncText' />";
	
	return array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=>$html );
}

function xnpGetIndexEditBlock( $item_id ){
	$xnpsid = $_SESSION['XNPSID'];
    if( !array_key_exists( 'xoonipsCheckedXID', $_POST ) ){
		$indexes = array();
		$result = xnpGetIndexes( $xnpsid, $item_id, $indexes );
		if ( $result == 0 ){
	        $xids = array();
			foreach( $indexes as $x ){
				$xids[] = $x['item_id'];
			}
			$_POST['xoonipsCheckedXID'] = implode( ',', $xids );
		}
    }
    //generate html to display index from $_POST
    return xnpGetIndexRegisterBlock( $item_id );
}





function xnpGetBasicInformationPrinterFriendlyBlock( $item_id ){
	return xnpGetBasicInformationDetailBlock( $item_id );
}

function xnpGetPreviewPrinterFriendlyBlock( $item_id ){
	return xnpGetPreviewDetailBlock( $item_id );
}

function xnpGetAttachmentPrinterFriendlyBlock( $item_id, $name ){
	return xnpGetAttachmentDetailBlock( $item_id, $name );
}

function xnpGetTextFilePrinterFriendlyBlock( $item_id, $name, $text ){
	$myts =& MyTextSanitizer::getInstance();
	return array( 'name'=>_MD_XOONIPS_ITEM_TEXTFILE_LABEL, 'value'=> $myts->nl2Br(xnpHtmlspecialchars($text)) );
}

function xnpGetIndexPrinterFriendlyBlock( $item_id ){
	return xnpGetIndexDetailBlock( $item_id, false );
}

function xnpWithinWithoutHtml( $within, $without ){
	if ( $without )
		return xnpHtmlspecialchars($within) . "<font color='red'>" . xnpHtmlspecialchars($without) . "</font>";
	else
		return xnpHtmlspecialchars($within);
}


function xnpGetBasicInformationConfirmBlock( $item_id ){
	$account = array();
	$item = array();
	$tmparray = array();
	$xnpsid = $_SESSION['XNPSID'];
	$tpl = new xoopsTpl();
    
	if( xnp_get_item( $xnpsid, $item_id, $item ) == RES_OK ){
		$last_update_date = date( DATETIME_FORMAT, xoops_getUserTimestamp($item['last_update_date']) );
		$creation_date = date( DATETIME_FORMAT, xoops_getUserTimestamp($item['creation_date']) );
		
		if( xnp_get_account( $xnpsid, $item['uid'], $account ) == RES_OK ){
			$contributor = $account['name']."(".$account['uname'].")";
	    }
		
		if( xnp_get_item_types( $tmparray ) == RES_OK ){
			foreach( $tmparray as $i ){
				if( $i['item_type_id'] == $item['item_type_id'] ){
					$itemtype = $i;
					$item_type = $itemtype['display_name'];
					break;
				}
			}
		}
	}
	else {
		// todo
		$last_update_date = false;
		$creation_date = false;
		$contributor = false;
		$item_type = false;
	}
	$change_log = xnpGetPostVarDef( 'change_log', '' );

	// ISO 639-2 3 letter code => Display name
//	$language_map = array_combine( explode( ',', _MD_XOONIPS_ITEM_LANG_OPTION_IDS ), explode( ',', _MD_XOONIPS_ITEM_LANG_OPTION_NAMES) );
	$language_map = array( );
	$keys = explode( ',', _MD_XOONIPS_ITEM_LANG_OPTION_IDS );
	$values = explode( ',', _MD_XOONIPS_ITEM_LANG_OPTION_NAMES );
	while( count( $keys ) > 0 )
		$language_map[ array_pop( $keys ) ] = array_pop( $values );
    
	$tpl->assign('related_to', xnpGetPostVarDef( 'related_to', '' ) );
    $rel = array_merge( xnpGetPostVarDef( 'related_to_check', array() ),
                        preg_split( "/[\r\n]+/", xnpGetPostVarDef( 'related_to', '' ) ) );
    
    $tpl->assign('item_htmls', itemid2ListBlock( $rel ) );
    
	$publicationDateYear  = xnpGetPostVarDef('publicationDateYear'  , 0 );
	$publicationDateMonth = xnpGetPostVarDef('publicationDateMonth' , 0 );
	$publicationDateDay   = xnpGetPostVarDef('publicationDateDay'   , 0 );
//	$publication_date = date( DATE_FORMAT, mktime(0,0,0,$publicationDateMonth,$publicationDateDay, $publicationDateYear) );
	$publication_date = xnpDate($publicationDateYear, $publicationDateMonth, $publicationDateDay);
	$myts =& MyTextsanitizer::getInstance();
	$lang_array = explode( ',', _MD_XOONIPS_ITEM_LANG_OPTION_IDS);

	$ret = array(
		'item_type'     => array( 'name'=>_MD_XOONIPS_ITEM_ITEM_TYPE_LABEL  , 'value'=>xnpHtmlspecialchars($item_type ) ),
		'contributor'   => array( 'name'=>_MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL, 'value'=>xnpHtmlspecialchars($contributor) ),
		'last_update_date'	=> array( 'name'=>_MD_XOONIPS_ITEM_LAST_UPDATE_DATE_LABEL, 'value'=>$last_update_date ),
		'creation_date' => array( 'name'=>_MD_XOONIPS_ITEM_CREATION_DATE_LABEL	, 'value'=>$creation_date ),
		'change_log'    => array( 'name'=>_MD_XOONIPS_ITEM_CHANGELOG_LABEL		, 'value'=>xnpHtmlspecialchars($myts->stripSlashesGPC( $change_log )) ),
		'change_logs'   => array( 'name'=>_MD_XOONIPS_ITEM_CHANGELOGS_LABEL		, 'value'=>get_changelog_html( $xnpsid, $item_id ) ),
		'publication_date'	=> array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_DATE_LABEL, 'value'=>$publication_date ),
		'publication_year'	=> array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_YEAR_LABEL, 'value'=>$publicationDateYear ),
		'publication_month'	=> array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_MONTH_LABEL,'value'=>$publicationDateMonth ),
		'publication_mday'	=> array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_MDAY_LABEL ,'value'=>$publicationDateDay ),
		'lang'	=> array( 'name'=>_MD_XOONIPS_ITEM_LANG_LABEL ,'value'=>$language_map[xnpGetPostVarDef('lang', reset( $lang_array ) )] ),
		'related_to'	=> array( 'name'=>_MD_XOONIPS_ITEM_RELATED_TO_LABEL ,'value'=>$tpl->fetch( "db:xoonips_confirm_related_to.html" ) )
	);
	
	// ʸ
	$ar = array(
		//see bellow for 'title' & 'keywords'
		'description'=>array('name'=>_MD_XOONIPS_ITEM_DESCRIPTION_LABEL, 'value'=>$myts->stripSlashesGPC(xnpGetPostVarDef('description',''))),
		'doi'        =>array('name'=>_MD_XOONIPS_ITEM_DOI_LABEL        , 'value'=>$myts->stripSlashesGPC(xnpGetPostVarDef('doi'        ,'')))
	);
	xnpConfirmHtml( $ar, 'xoonips_item_basic', null, _CHARSET );
	
	$ar['title'] = array( 'name'=>_MD_XOONIPS_ITEM_TITLE_LABEL );
	foreach( preg_split( "/[\r\n]+/", $myts->stripSlashesGPC(xnpGetPostVarDef('title', '')) ) as $title ){
		$tmp = array( 'title' => array( 'name'=>_MD_XOONIPS_ITEM_TITLE_LABEL, 'value'=>$title ) );
		xnpConfirmHtml( $tmp, 'xoonips_item_title', null, _CHARSET );
		foreach( $tmp['title'] as $k => $v ){
			if( $k == 'name' ) continue;
			if( $k == 'without' && $v == "" ) continue;
			if( !isset( $ar['title'][ $k ] ) ) $ar['title'][ $k ] = $v;
			else $ar['title'][ $k ] .= "\n".$v;
		}
	}

	$ar['keywords'] = array( 'name'=>_MD_XOONIPS_ITEM_KEYWORDS_LABEL );
	foreach( explode( ",", $myts->stripSlashesGPC(xnpGetPostVarDef('keywords', '')) ) as $keyword ){
		$tmp = array( 'keyword' => array( 'name'=>_MD_XOONIPS_ITEM_KEYWORDS_LABEL, 'value'=>$keyword ) );
		xnpConfirmHtml( $tmp, 'xoonips_item_keyword', null, _CHARSET );
		foreach( $tmp['keyword'] as $k => $v ){
			if( $k == 'name' ) continue;
			if( $k == 'without' && $v == "" ) continue;
			if( !isset( $ar['keywords'][ $k ] ) ) $ar['keywords'][ $k ] = $v;
			else $ar['keywords'][ $k ] .= ",".$v;
		}
	}
	
	
	return $ret + $ar;
}

function xnpGetPreviewConfirmBlock( $item_id ){
	if ( empty($_POST['previewFileID']) ){
		$html = "";
	}
	else {
		$previewFileID = $_POST['previewFileID'];
		// illegal inputs are removed.
		if ( !xnpIsCommaSeparatedNumber( $previewFileID ) ){
			echo "Error: bad previewFileID";
			return false;
		}
		
		// get preview file
		$files = xnpGetFileInfo( "t_file.file_id, t_file.caption", "t_file_type.name='preview' and t_file.file_id in ($previewFileID)", $item_id );
		
		// generate html
		reset( $files );
		$imageHtml1 = array();
		$imageHtml2 = array();
		while ( list( $dummy, list( $fileID, $caption) ) = each( $files ) ){
			$thumbnailFileName = XOOPS_URL . "/modules/xoonips/image.php?file_id=$fileID&thumbnail=1";
			$imageFileName = XOOPS_URL . "/modules/xoonips/image.php?file_id=$fileID";
//			$htmlCaption = htmlspecialchars( $caption );
			$htmlCaption = xnpHtmlspecialchars( $caption );
			$imageHtml1[] = "<a href='$imageFileName' target='_blank'><img src='$thumbnailFileName' ></a>";
			$imageHtml2[] = "$htmlCaption";
		}
		$html = xnpMakeTable( array($imageHtml1,$imageHtml2), 3 ) . "<input type='hidden' name='previewFileID' value='$previewFileID' />";
	}
	
	return array( 'name'=>_MD_XOONIPS_ITEM_PREVIEW_LABEL, 'value'=> $html );
}

function xnpGetAttachmentConfirmBlock( $item_id, $name ){
	if ( !empty( $_FILES[$name]['name'] ) ){
		xnpEncodeMacSafariFiles($name);
		// Upload file
		list($fileID,$errorMessage) = xnpUploadFile( $name, false );
		if ( $fileID == false ){
			global $system_message;
			$system_message = $system_message."\n<br /><font color='#ff0000'>" . htmlspecialchars($errorMessage) . "</font><br />";
			return false;
		}
		else
			$sql = "t_file.file_id = $fileID";
	}
	else {
		$attachmentFileID = (int)xnpGetPostVarDef($name.'FileID', 0);
		if ( $attachmentFileID == 0 ){ // no attachment file.
			$sql = " 0 ";
		}
		else {
			$sql = "t_file.file_id = $attachmentFileID";
		}
	}
	
	$files = xnpGetFileInfo( "t_file.file_id, t_file.original_file_name, t_file.file_size, t_file.mime_type, unix_timestamp(t_file.timestamp)", "t_file_type.name='$name' and $sql ", $item_id );
	
	if ( count( $files ) == 0 ){
		$html = "<input type='hidden' name='${name}FileID' value='' />";
	}
	else {
		list( list( $fileID, $fileName, $fileSize, $mimeType, $timestamp ) ) = $files;
		$html = 
		  "<input type='hidden' name='${name}FileID' value='$fileID' /> $fileName<br />
		    <table>
		     <tr>
		      <td>"._MD_XOONIPS_ITEM_TYPE_LABEL."</td>
		      <td>: $mimeType</td>
		     </tr>
		     <tr>
		      <td>"._MD_XOONIPS_ITEM_SIZE_LABEL."</td>
		      <td>: $fileSize bytes</td>
		     </tr>
		     <tr>
		      <td>"._MD_XOONIPS_ITEM_LAST_UPDATED_LABEL."</td>
		      <td>: ".date(DATE_FORMAT, $timestamp)."</td>
		     </tr>
		    </table>";
	}
	
	// get attachment file
	// generate html
	return array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=> $html );
}

function xnpGetAttachmentFilenameConfirmBlock( $item_id, $name ){
	// get attachment file
	// generate html
	if ( !empty( $_FILES[$name]['name'] ) ){
		$fileName = $_FILES[$name]['name'];
		if (xnpChkServerLang()) {
			if (mb_substr_count( $fileName, "." ) > 0 ) {
				$fileName = mb_substr( $fileName, 0, mb_strrpos( $fileName, "." ) );
			}
		}
		else {
			if (substr_count( $fileName, "." ) > 0 ) {
				$fileName = substr($fileName,0,strlen($fileName) - strlen(strrchr($fileName,".")));
			}
		}
		$htmlFileName = xnpHtmlspecialchars($fileName);
		$html = "$htmlFileName";
	}
	else {
		return xnpGetAttachmentFilenameBlock( $item_id, $name );
	}
	return array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=> $html );
}

function xnpGetAttachmentMimetypeConfirmBlock( $item_id, $name ){
	// get attachment file
	// generate html
	if ( !empty( $_FILES[$name]['type'] ) ){
		$mimetype = $_FILES[$name]['type'];
		$html = "$mimetype";
	}
	else {
		return xnpGetAttachmentMimetypeBlock( $item_id, $name );
	}
	return array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=> $html );
}

function xnpGetAttachmentFiletypeConfirmBlock( $item_id, $name ){
	// get attachment file
	// generate html
	if ( !empty( $_FILES[$name]['name'] ) ){
		$fileType = $_FILES[$name]['name'];
		if (xnpChkServerLang()) {
			if (mb_substr_count( $fileType, "." ) == 0 ) {
				$fileType = "";
			}
			else {
				$fileType = mb_substr( $fileType, mb_strrpos( $fileType, "." ) + 1 );
			}
		}
		else {
			if (substr_count( $fileType, "." ) == 0 ) {
				$fileType = "";
			}
			else {
				$fileType = substr($fileType,strrpos($fileType,".")+1);
			}
		}
		$htmlFileType = xnpHtmlspecialchars($fileType);
		$html = "$htmlFileType";
	}
	else {
		return xnpGetAttachmentFiletypeBlock( $item_id, $name );
	}
	return array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=> $html );
}

function xnpGetTextFileConfirmBlock( $item_id, $name, $maxlen=65535 ){
	$myts =& MyTextSanitizer::getInstance();
	
	$text = $myts->stripSlashesGPC($_POST[$name.'EncText']);
	list( $within, $without ) = xnpTrimString( $text, $maxlen, _CHARSET );
	
	$htmlShowWithin  = nl2br(xnpHtmlspecialchars($within,ENT_QUOTES));
	$htmlShowWithout = nl2br(xnpHtmlspecialchars($without,ENT_QUOTES));
	
	if (( substr_count( $_SERVER["HTTP_USER_AGENT"], "Mac" ) > 0 ) && ( substr_count( $_SERVER["HTTP_USER_AGENT"], "Safari" ) > 0 )) {
		$html = $htmlShowWithin . "<font color='red'>" . $htmlShowWithout . "</font>" .
			"<input type='hidden' name='${name}EncText' value='".htmlspecialchars($within.$without)."' />";
	}
	else {
		$html = $htmlShowWithin . "<font color='red'>" . $htmlShowWithout . "</font>" .
			"<input type='hidden' name='${name}EncText' value='".xnpHtmlspecialchars($within.$without)."' />";
	}

	return array( 'name'=>_MD_XOONIPS_ITEM_TEXTFILE_LABEL, 'value'=> $html, 'within'=>$within, 'without'=>$without );
}

function xnpGetIndexConfirmBlock( $item_id ){
	$xnpsid = $_SESSION['XNPSID'];
	$index_ids = explode( ',', $_POST['xoonipsCheckedXID'] );
	$indexes = array();
	foreach( $index_ids as $xid ){
        $str = xnpGetIndexPathString( $xnpsid, $xid );
		$indexes[$xid]="$str";
	}
	return array( 'name'=>_MD_XOONIPS_ITEM_INDEX_LABEL, 'value'=>implode( '<br />', array_values( $indexes ) ) );
}

function xnpGetBasicInformationRegisterBlock(){
	$tpl = new xoopsTpl();
	if ( isset($_POST['publicationDateYear']) && !empty( $_POST['publicationDateYear'] ) ){
		$tpl->assign('gmtime', xnpMktime($_POST['publicationDateYear'], xnpGetPostVarDef('publicationDateMonth',0), xnpGetPostVarDef('publicationDateDay',0)));
    }
	$tpl->assign('lang_option_ids', explode( ',', _MD_XOONIPS_ITEM_LANG_OPTION_IDS) );
	$tpl->assign('lang_option_names', explode( ',', _MD_XOONIPS_ITEM_LANG_OPTION_NAMES) );
	$tmp_array = explode( ',', _MD_XOONIPS_ITEM_LANG_OPTION_IDS);
	$tpl->assign('lang_option_default_id', isset( $_POST['lang'] ) ? $_POST['lang'] : reset( $tmp_array ) );
	$tpl->assign('related_to', isset( $_POST['related_to'] ) ? $_POST['related_to'] : '' );
	
	$myts =& MyTextsanitizer::getInstance();

	$ret = array(
	  'contributor'		=> array( 'name'=>'contributor'		, 'value'=>"" ),
	  'title'			=> array( 'name'=>_MD_XOONIPS_ITEM_TITLE_LABEL._MD_XOONIPS_ITEM_REQUIRED_MARK, 'value'=>"<textarea name='title' rows='3' cols='50'>".xnpHtmlspecialchars($myts->stripSlashesGPC( xnpGetPostVarDef('title', '') ),ENT_QUOTES)."</textarea>" ),
	  'keywords'		=> array( 'name'=>_MD_XOONIPS_ITEM_KEYWORDS_LABEL	, 'value'=>"<input size=50 type='text' name='keywords' value='".xnpHtmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('keywords', '')),ENT_QUOTES)."' /><br />".
	                                                                                       " Separate the words or phrases with commas." ),
	  'description'		=> array( 'name'=>_MD_XOONIPS_ITEM_DESCRIPTION_LABEL	, 'value'=>"<textarea rows=5 cols=50 name='description'>".xnpHtmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('description', '')),ENT_QUOTES)."</textarea>" ),
	  'doi'				=> array( 'name'=>_MD_XOONIPS_ITEM_DOI_LABEL		, 'value'=>"<input type='text' name='doi' value='".xnpHtmlspecialchars($myts->stripSlashesGPC(xnpGetPostVarDef('doi', '')),ENT_QUOTES)."' />" ),
	  'last_update_date'=> array( 'name'=>_MD_XOONIPS_ITEM_LAST_UPDATE_DATE_LABEL, 'value'=>"" ),
	  'creation_date'	=> array( 'name'=>_MD_XOONIPS_ITEM_CREATION_DATE_LABEL	, 'value'=>"" ),
	  'change_log'		=> array( 'name'=>_MD_XOONIPS_ITEM_CHANGELOG_LABEL	, 'value'=>"" ),
	  'change_logs'		=> array( 'name'=>_MD_XOONIPS_ITEM_CHANGELOGS_LABEL	, 'value'=>'' ),
	  'publication_date'=> array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_DATE_LABEL, 'value'=>$tpl->fetch( "db:xoonips_publication_date.html" ) ),
	  'publication_year'=> array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_YEAR_LABEL, 'value'=>$tpl->fetch( "db:xoonips_publication_year.html" ) ),
	  'publication_month'=> array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_MONTH_LABEL, 'value'=>$tpl->fetch( "db:xoonips_publication_month.html" ) ),
	  'publication_mday'=> array( 'name'=>_MD_XOONIPS_ITEM_PUBLICATION_MDAY_LABEL, 'value'=>$tpl->fetch( "db:xoonips_publication_mday.html" ) ),
	  'lang'=> array( 'name'=>_MD_XOONIPS_ITEM_LANG_LABEL, 'value'=>$tpl->fetch( "db:xoonips_lang.html" ) ),
	  'related_to'=> array( 'name'=>_MD_XOONIPS_ITEM_RELATED_TO_LABEL, 'value'=>$tpl->fetch( "db:xoonips_register_related_to.html" ) )
	);
	return $ret;
}

function xnpGetPreviewRegisterBlock(){
	return xnpGetPreviewEditBlock( false );
}

function xnpGetAttachmentRegisterBlock( $name ){
	return xnpGetAttachmentEditBlock( false, $name );
}

function xnpGetTextFileRegisterBlock( $name ){
	return xnpGetTextFileEditBlock( false, $name, '' );
}

function xnpGetIndexRegisterBlock(){
	$xnpsid = $_SESSION['XNPSID'];
	$indexes = array();
	if ( isset($_POST['xoonipsCheckedXID']) ){
		$index_ids = explode( ',', $_POST['xoonipsCheckedXID'] );
		foreach( $index_ids as $xid ){
			if( $xid > 0 ){
		        $str = xnpGetIndexPathString( $xnpsid, $xid );
				$indexes[$xid]="$str";
			}
		}
	}
	if( count( $indexes ) == 0 ){
		return array( 'name'=>_MD_XOONIPS_ITEM_INDEX_LABEL._MD_XOONIPS_ITEM_REQUIRED_MARK );
	}else{
		return array( 'name'=>_MD_XOONIPS_ITEM_INDEX_LABEL._MD_XOONIPS_ITEM_REQUIRED_MARK, 'value'=>implode( '<br />', array_values( $indexes ) ) );
	}
}






function xnpInsertBasicInformation( &$item_id ){
	$xnpsid = $_SESSION['XNPSID'];
	$uid = $_SESSION['xoopsUserId'];
	
    $myts =& MyTextsanitizer::getInstance();
	$item = array(
		'item_type_id'		=>$myts->stripSlashesGPC( $_POST['item_type_id'	] ),
		'uid'				=>$myts->stripSlashesGPC( $uid ),
		'description'		=>str_replace( "\r\n", "\r", $myts->stripSlashesGPC( xnpHtmlspecialchars( $_POST['description'] ) ) ),
		'doi'				=>$myts->stripSlashesGPC( $_POST['doi'			] ),
		'publication_year'	=>$myts->stripSlashesGPC( $_POST['publicationDateYear' ] ),
		'publication_month'	=>$myts->stripSlashesGPC( $_POST['publicationDateMonth'] ),
		'publication_mday'	=>$myts->stripSlashesGPC( $_POST['publicationDateDay'  ] ),
		'lang'	=>$myts->stripSlashesGPC( $_POST['lang'  ] ),
	);
	xnpTrimColumn( $item, 'xoonips_item_basic', array_keys( $item ), _CHARSET );

	//set titles & keywords
	$item['titles']			= array();
	foreach( preg_split( "/[\r\n]+/", $_POST['title'] ) as $title ){
		if( trim( $title ) != '' ) $item['titles'][] = $myts->stripSlashesGPC( xnpHtmlspecialchars( $title ) );
	}
	$item['keywords']		= array();
	foreach( explode( ",", $_POST['keywords'] ) as $keyword ){
		if( empty( $keyword ) ) continue;
		$item['keywords'][] = $myts->stripSlashesGPC( xnpHtmlspecialchars( $keyword ) );
	}

	//trim title
	$lengths = xnpGetColumnLengths( 'xoonips_item_title' );
	if( $lengths ){
		foreach( $item['titles'] as $k => $title ){
			list( $within, $without ) = xnpTrimString( $title, $lengths[ 'title' ], _CHARSET );
			$item[ 'titles' ][ $k ] = $within;
		}
	}else{
		setLastErrorString( "xnpGetColumnLengths( 'xoonips_item_title' ) returns false" );
	}
	//trim keyword
	$lengths = xnpGetColumnLengths( 'xoonips_item_keyword' );
	if( $lengths ){
		foreach( $item['keywords'] as $k => $keyword ){
			list( $within, $without ) = xnpTrimString( $keyword, $lengths[ 'keyword' ], _CHARSET );
			$item[ 'keywords' ][ $k ] = $within;
		}
	}else{
		setLastErrorString( "xnpGetColumnLengths( 'xoonips_item_keyword' ) returns false" );
	}
	$result = xnp_insert_item( $xnpsid, $item, $item_id );
	if( $result == RES_OK ){
		$related_to = preg_split( "/[\r\n]+/", $myts->stripSlashesGPC( $_POST['related_to'  ] ) );
		foreach( $related_to as $i ){
			if( is_numeric($i) ) xnp_insert_related_to( $xnpsid, $item_id, (int)$i );
		}
	}
	// Record events(insert item)
	if ( $result == RES_OK )
		xnp_insert_event( $xnpsid, ETID_INSERT_ITEM, time(), $uid, xnpGetRemoteHost(), array( 'item_id'=>$item_id ) );
	return ($result == RES_OK);
}

function xnpUpdateBasicInformation( $item_id ){
	global $xoopsDB;
    $xnpsid = $_SESSION['XNPSID'];
	$uid = $_SESSION['xoopsUserId'];
	
	$sql = "select tt.name from " . $xoopsDB->prefix('xoonips_item_type') . " as tt ".
	  " left join " . $xoopsDB->prefix('xoonips_item_basic') . " as tb on tb.item_type_id = tt.item_type_id ".
	  " where tb.item_id=" . (int)$item_id; // item_id -> module_name
	$result = $xoopsDB->query( $sql );
	list( $modname ) = $xoopsDB->fetchRow( $result );
	$f = $modname.'GetModifiedFields';
	$modified = xnpGetModifiedFields( $item_id ) + ( function_exists($f) ? $f( $item_id ) : array() );
	
	$update_certify = true;
	if ( count( $modified ) == 0 ){
		$update_certify = false; // no modified field.
	}
	else if ( count( $modified ) == 1 && $modified[0] == _MD_XOONIPS_ITEM_INDEX_LABEL ){ // only indexes are modified
		$xids_new = explode( ',', $_POST['xoonipsCheckedXID'] );
		$xids_now = array();
		if( xnp_get_index_id_by_item_id( $xnpsid, $item_id, $xids_now ) == RES_OK ){
			$xids_diff = array_diff( $xids_new, $xids_now ) + array_diff( $xids_now, $xids_new );
			if ( count($xids_diff) == 0 )
				$update_certify = false;
			else {
				$sql = "select sum(open_level <> ".OL_PRIVATE.") from ".$xoopsDB->prefix('xoonips_index')." where index_id in (".implode(',',$xids_diff).")";
				$result = $xoopsDB->query( $sql );
				if ( $result && $xoopsDB->getRowsNum( $result ) ){
					list( $c ) = $xoopsDB->fetchRow( $result );
					if ( $c == 0 )
						$update_certify = false; // no public/group indexes are modified
				}
			}
		}
	}
	
	//retrieve item detail and set item type id to $item_type_id;
    $item = array();
    if( xnp_get_item( $xnpsid, $item_id, $item ) != RES_OK ){
        redirect_header('index.php', 3, "ERROR xnp_get_item [AbstractLayer]".xnp_get_last_error_string());
        return false;
    }else{
        $item_type_id = $item['item_type_id'];
    }

    $myts =& MyTextSanitizer::getInstance();

	//split title by \n
	$titles = array();
	foreach( preg_split( "/[\r\n]+/", $_POST['title'] ) as $title ){
		if( trim( $title ) != '' ) $titles[] = $myts->stripSlashesGPC( $title );
	}
	//split keyword by ','
	$keywords = array();
	foreach( explode( ",", $_POST['keywords'] ) as $keyword ){
		if( empty( $keyword ) ) continue;
		$keywords[] = $myts->stripSlashesGPC( $keyword );
	}
	
	$update_item = array(
		'item_id'			=>$item_id,
		'item_type_id'		=>$item['item_type_id'],
		'uid'				=>$myts->stripSlashesGPC( $item['uid'] ),
		'titles'			=>$titles,
		'keywords'			=>$keywords,
		'description'		=>str_replace( "\r\n", "\r", $myts->stripSlashesGPC( $_POST['description'] ) ),
		'doi'				=>$myts->stripSlashesGPC( $_POST['doi'] ),
		'last_update_date'  =>time(),
		'creation_date'     =>$item['creation_date'],
		'publication_year'	=>$myts->stripSlashesGPC( $_POST['publicationDateYear' ] ),
		'publication_month'	=>$myts->stripSlashesGPC( $_POST['publicationDateMonth'] ),
		'publication_mday'	=>$myts->stripSlashesGPC( $_POST['publicationDateDay'  ] ),
		'lang'	            =>$myts->stripSlashesGPC( $_POST['lang'] ),
	);
	xnpTrimColumn( $update_item, 'xoonips_item_basic', array(/*'title', 'keywords', */'description', 'doi'), _CHARSET );
	
	$result = xnp_update_item( $xnpsid, $update_item, $update_certify );
	
	$related_to = $myts->stripSlashesGPC( $_POST['related_to'] );
	$related_to_check = preg_split( "/[\r\n]/", $_POST['related_to_check'] );
	
	//delete related to if ID is not exist in related_to_check
	$tmp = array();
	if( xnp_get_related_to( $xnpsid, $item_id, $tmp ) == RES_OK ){
		foreach( $tmp as $i ){
			if( !in_array( $i, $related_to_check ) ){
				xnp_delete_related_to( $xnpsid, $item_id, $i );
			}
		}
	}
	
	//insert new relation
	if( !empty( $related_to ) ){
		foreach( preg_split( "/[\r\n]+/", $related_to ) as $i ){
			if( is_numeric($i) ) xnp_insert_related_to( $xnpsid, $item_id, (int)$i );
		}
	}
	
	// record events(update item)
	if ( $result == RES_OK )
		xnp_insert_event( $xnpsid, ETID_UPDATE_ITEM, time(), $uid, xnpGetRemoteHost(), array( 'item_id'=>$item_id ) );
	return ($result == RES_OK);
}

function xnpSendMailToModerator( $subject, $body ){
	$xnpsid = $_SESSION['XNPSID'];
	
	// get mail address of moderator
	$moderator_emails = array();
	$uids = array();
	if( xnp_dump_uids( $xnpsid, array(), $uids ) == RES_OK ){
		foreach( $uids as $uid ){
			if( xnp_is_moderator( $xnpsid, $uid ) ){
				$user = array();
				$result = xnp_get_account( $xnpsid, $uid, $user );
				if( $result == RES_OK ){
					$moderator_emails[] = $user['email'];
				}
			}
		}
	}
	
	$myts =& MyTextSanitizer::getInstance();
	$xoopsMailer =& getMailer( );
	$xoopsMailer->useMail( );
	$xoopsMailer->setToEmails( $moderator_emails );
	global $xoopsConfig;
	$xoopsMailer->setFromEmail( $xoopsConfig['adminmail'] );
	$xoopsMailer->setFromName( $xoopsConfig['sitename'] );
	$xoopsMailer->setSubject( $subject );
	$xoopsMailer->setBody( $body );
	$xoopsMailer->send( );
}

function xnpDeleteBasicInformation( $item_id ){
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
	$uid = $_SESSION['xoopsUserId'];
	// retrieve Binder that contains this item and doesn't contain other items.
	$bi_table = $xoopsDB->prefix("xoonips_binder_item_link");
	$result = $xoopsDB->query( "select t1.binder_id ".
	 " from $bi_table as t1 ".
	 " left join $bi_table as t2 on t1.binder_id=t2.binder_id and t1.item_id <> t2.item_id ".
	 " where t1.item_id=$item_id and t2.item_id is NULL " );
	if ( $result ){
		// get bid of binders which opened to the public.
		$cri = array();
		$xids = array();
		$public_xids = array();
		if ( xnp_get_item_id_by_index_id( $xnpsid, IID_BINDERS, $cri, $xids ) == RES_OK ){
			xnp_extract_public_item_id( $xnpsid, $xids, $public_xids );
		}
		
		while( list($bid) = $xoopsDB->fetchRow($result) ){
			// If this binder is opened and certified, it notifies moderator.
			if ( in_array( (int)$bid, $public_xids ) ){
				$item = array();
				xnp_get_item( $xnpsid, $bid, $item );
				global $xoopsModule;
				$notification_handler =& xoops_gethandler('notification');
				//define tags here for notification message
				$tags = array();
				$tags['URL'] = XOOPS_URL . '/modules/' . $xoopsModule->dirname() . "/detail.php?item_id=${bid}";
				$tags['TITLE'] = $item['title'];
				$notification_handler =& xoops_gethandler('notification');
				$result = $notification_handler->triggerEvent('administrator', 0, 'binder_content_empty', $tags);
			}
		}
	}
	
	
	
	// delete Preview, Attachment, TextFile
	global $xoopsDB;
	$fileTable = $xoopsDB->prefix('xoonips_file');
	$sql = "select file_id from $fileTable where item_id=$item_id";
	$result = $xoopsDB->query($sql);
	if ( $result == false ){
		echo "$sql error." . mysql_error();
		return false;
	}
	while ( list($file_id) = $xoopsDB->fetchRow($result) ){
		$fileName = xnpGetUploadFilePath($file_id);
		unlink($fileName);
		$xoopsDB->queryF("delete from ".$xoopsDB->prefix('xoonips_search_text')." where file_id=$file_id");
	}
	$xoopsDB->queryF("delete from $fileTable where item_id=$item_id");
	
	// delete from prefix("xoonips_item_show")
	// $xoopsDB =& Database::getInstance();
	$sql = "DELETE FROM ".$xoopsDB->prefix("xoonips_item_show")." WHERE item_id=".$item_id." ";
	$res = $xoopsDB->query($sql);

	// delete BasicInformation
	$result = xnp_delete_item( $xnpsid, $item_id );

	// record events(delete item)
	if ( $result == RES_OK )
		xnp_insert_event( $xnpsid, ETID_DELETE_ITEM, time(), $uid, xnpGetRemoteHost(), array( 'item_id'=>$item_id ) );
	return ($result == RES_OK);
}


function xnpUpdateIndex( $item_id ){
    //1. get $_POST['xoonipsCheckedXID'].
    //2. get registered index (before change index) using item_id.
    //3. function 'unregisterItem' is executed for index (2-(1 and 2)) deleted by change.
    //4. function 'registerItem' is executed for index (1-(1 and 2)) added by change.
    $xnpsid = $_SESSION['XNPSID'];
    if( !array_key_exists( 'xoonipsCheckedXID', $_POST ) ) return true;
    $xids_new = explode( ',', $_POST['xoonipsCheckedXID'] );
    
    $item = array();
    $xids_now = array();
    if( ($result = xnp_get_item( $xnpsid, $item_id, $item )) == RES_OK ){
        //retrieve index id if item exists
        if( xnp_get_index_id_by_item_id( $xnpsid, $item_id, $xids_now ) != RES_OK ){
            return false;
        }
    }
    
	//retrieve module name to $modname
	$tmparray = array();
	if( xnp_get_item_types( $tmparray ) == RES_OK ){
		foreach( $tmparray as $i ){
			if( $i['item_type_id'] == $item['item_type_id'] ){
				$itemtype = $i;
				$modname = $itemtype['name'];
				break;
			}
		}
	}

    $intersect = array_intersect( $xids_new, $xids_now );
    $del = array_diff( $xids_now, $intersect ); // index id shuld be removed
    $add = array_diff( $xids_new, $intersect ); // index id shuld be inserted
    foreach( $del as $i ){
        xnp_unregister_item( $xnpsid, $i, $item_id );
    }
    foreach( $add as $i ){
		xnp_register_item( $xnpsid, $i, $item_id );
    }
	
	$certify_item = '';
	if( xnp_get_config_value( 'certify_item', $certify_item ) != RES_OK ){
		$certify_item = 'on';
	}

	$moderator_uid_list = array();
	$uids = array();
	if( xnp_dump_uids( $xnpsid, array(), $uids ) == RES_OK ){
		foreach( $uids as $uid ){
			if( xnp_is_moderator( $xnpsid, $uid ) ){
				$user = array();
				$result = xnp_get_account( $xnpsid, $uid, $user );
				if( $result == RES_OK ){
					$moderator_uid_list[] = $user['uid'];
				}
			}
		}
	}
	
	foreach( $add as $i ){
		$uid_list = array();// uid to send
		$index = array();
		$result = xnp_get_index( $xnpsid, $i, $index );
		if( $result == RES_OK ){
			if( $index['open_level'] == OL_GROUP_ONLY ){
				$uids = array();
				$result = xnp_dump_group_admins( $xnpsid, $index['owner_gid'], array(), $uids );
				if( $result == RES_OK ){
                    foreach( $uids as $id ){
                        $user = array();
                        $result = xnp_get_account( $xnpsid, $id, $user );
                        if( $result == RES_OK ){
                            $uid_list[] = $user['uid'];
                        }
                    }
                }
			}else if( $index['open_level'] == OL_PUBLIC ){
				$uid_list = $moderator_uid_list;
			}else{
				continue;
			}
			
			// record events(request certify item)
			xnp_insert_event( $xnpsid, ETID_REQUEST_CERTIFY_ITEM, time(), $_SESSION['xoopsUserId'], xnpGetRemoteHost(), array( 'item_id' => $item_id, 'index_id'=>$i ) );
			
			if ( $certify_item == 'auto' ){
				// record events(certify item)
				xnp_insert_event( $xnpsid, ETID_CERTIFY_ITEM, time(), $_SESSION['xoopsUserId'], xnpGetRemoteHost(), array( 'item_id' => $item_id, 'index_id'=>$i ) );
				xnpGenerateRss( ); //update RSS
			}
			else if ( $certify_item == 'on' ){
				global $xoopsModule;
				$notification_handler =& xoops_gethandler('notification');
				//define tags here for notification message
				$tags = array();
				$tags['ITEM_URL'] = XOOPS_URL . '/modules/' . $xoopsModule->dirname() . "/detail.php?item_id=${item_id}";
				$tags['CERTIFY_URL'] = XOOPS_URL . '/modules/' . $xoopsModule->dirname() . "/certify.php";
				$tags['INDEX'] = xnpGetIndexPathString( $xnpsid, $i );
				$notification_handler =& xoops_gethandler('notification');
				$result = $notification_handler->triggerEvent('administrator', 0, 'item_certify_request', $tags, $uid_list);
			}
		}
	}
	
	return true;
}

function xnpUpdatePreview( $item_id ){
	global $xoopsDB;
	// File under registration relates to this item.
	$previewFileID = xnpGetPostVarDef( 'previewFileID', '' );
	$table = $xoopsDB->prefix('xoonips_file');
	$xnpsid = $_SESSION['XNPSID'];
	$esc_sess_id = addslashes($xnpsid);
	$file_type_id = 1;
	
	if ( empty( $previewFileID ) ){
		$sql = "update $table set sess_id='$esc_sess_id', item_id=NULL where item_id=$item_id and file_type_id=$file_type_id";
		$result = $xoopsDB->queryF( $sql );
	}
	else {
		if ( !xnpIsCommaSeparatedNumber( $previewFileID ) ){
			echo "Error: bad previewFileID";
			return false;
		}
		$sql =  "update $table set sess_id='$esc_sess_id', item_id=NULL where item_id=$item_id and file_id not in ($previewFileID) and file_type_id=$file_type_id";
		$result  = $xoopsDB->queryF( $sql );
		if ( $result != false ){
			$sql =  "update $table set sess_id=NULL, item_id=$item_id where sess_id='$esc_sess_id' and file_id in ($previewFileID) and file_type_id=$file_type_id";
			$result &= $xoopsDB->queryF( $sql );
		}
	}
	if ( $result == false ){
		echo "Error: cannot update xoonips_file $sql " . mysql_error();
		return false;
	}
	
	return true;
}

function xnpUpdateAttachment( $item_id, $name ){
	global $xoopsDB;
	// File under registration relates to this item.
	$fileID = xnpGetPostVarDef("${name}FileID",0);
	$table = $xoopsDB->prefix('xoonips_file');
	$xnpsid = $_SESSION['XNPSID'];
	$esc_sess_id = addslashes($xnpsid);
	
	// name -> file_type_id
	$sql = "select file_type_id from " . $xoopsDB->prefix('xoonips_file_type') . " where name='$name'";
	$result = $xoopsDB->query( $sql );
	if ( $result == false ){
		echo "xnpUpdateAttachment: bad file_type_name $name ";
		return false;
	}
	list( $file_type_id ) = $xoopsDB->fetchRow( $result );
	
	if ( empty( $fileID ) ){
		// No Attachments
		$sql = "update $table set sess_id='$esc_sess_id', item_id=NULL where item_id=$item_id and file_type_id=$file_type_id";
		$result = $xoopsDB->queryF( $sql );
	}
	else {
		$sql =  "update $table set sess_id='$esc_sess_id', item_id=NULL where item_id=$item_id and file_id<>$fileID and file_type_id=$file_type_id";
		$result  = $xoopsDB->queryF( $sql );
		if ( $result != false ){
			$sql =  "update $table set sess_id=NULL, item_id=$item_id where sess_id='$esc_sess_id' and file_id=$fileID and file_type_id=$file_type_id";
			$result &= $xoopsDB->queryF( $sql );
		}
	}
	if ( $result == false ){
		echo "Error: cannot update xoonips_file $sql " . mysql_error();
		return false;
	}
	
	return true;
}

/** function of getting readme/rights contents on the following page of confirm.
 * @param name  readme/rights
 * @return contents empty character strings in error.
 */
function xnpGetTextFile( $name ){
	$myts =& MyTextSanitizer::getInstance();
	return $myts->stripSlashesGPC($_POST[$name.'EncText']);
}


/**
 * 
 * return changelog html text
 * 
 * @param xnpsid
 * @param item_id 
 * 
 */
function get_changelog_html( $xnpsid, $item_id ){
	$changelogs = array();
    $myts =& MyTextSanitizer::getInstance();
    $log = "";
	if( xnp_get_change_logs( $xnpsid, $item_id, $changelogs ) == RES_OK ){
		if( count( $changelogs ) > 0 ){
	        $log = "<table>\n";
	        foreach( $changelogs as $l ){
//	            $log = $log."<tr><td nowrap>".date( DATE_FORMAT, $l['log_date'] )."&nbsp;</td><td>".nl2br( htmlspecialchars($l['log'] ))."</td></tr>\n";
	            $log = $log."<tr><td nowrap>".date( DATE_FORMAT, $l['log_date'] )."&nbsp;</td><td>".nl2br( xnpHtmlspecialchars($l['log'] ))."</td></tr>\n";
	        }
	        $log = $log."</table>\n";
	    }
	}
    return $log;
}

function xnpGetBasicInformationArray( $item_id )
{
	global $xoopsDB;
	$xnpsid = $_SESSION['XNPSID'];
    $item = array();
	if( xnp_get_item( $xnpsid, $item_id, $item ) != RES_OK ){
		return array();
	}
    $account = array();
	if( xnp_get_account( $xnpsid, $item['uid'], $account ) == RES_OK ){
		$contributor = $account['name']."(".$account['uname'].")";
	}
    
	$tmparray = array();
	if( xnp_get_item_types( $tmparray ) == RES_OK ){
		foreach( $tmparray as $i ){
			if( $i['item_type_id'] == $item['item_type_id'] ){
				$itemtype = $i;
				$item_type = $itemtype['display_name'];
				break;
			}
		}
	}
	
	return array(
		'item_type'			=> $item_type ,
		'titles'			=> $item['titles'] ,
		'contributor'		=> $contributor,
		'keywords'			=> $item['keywords'] ,
		'description'		=> $item['description'] ,
		'doi'				=> $item['doi'] ,
		'last_update_date'	=> date( DATETIME_FORMAT, xoops_getUserTimestamp($item['last_update_date']) ),
		'creation_date'		=> date( DATETIME_FORMAT, xoops_getUserTimestamp($item['creation_date']) ),
		'publication_year'	=> $item['publication_year'],
		'publication_month'	=> $item['publication_month'],
		'publication_mday'	=> $item['publication_mday'],
		'lang'	=> $item['lang']
		);

/*
	$item = xnpGetBasicInformationDetailBlock( $item_id );
	
	foreach( array( 'title', 'contributor', 'keywords', 'description', 'doi', 'last_update_date', 'creation_date' ) as $k ){
		$ret[$k] = $item[$k]['value'];
	}

	$xnpsid = $_SESSION['XNPSID'];
	$item = array();
	if( xnp_get_item( $xnpsid, $item_id, $item ) == RES_OK ){
		foreach( array( 'publication_year', 'publication_month', 'publication_mday' ) as $k ){
			$ret[$k] = $item[$k];
		}
	}
	return $ret;
*/
}

function xnpGetBasicInformationAdvancedSearchBlock($moduleName,& $search_var){
	global $xoopsTpl;
	$tpl = new xoopsTpl();
	$tpl->assign('prefixFrom', $moduleName.'_publication_date_from');
	$tpl->assign('prefixTo'  , $moduleName.'_publication_date_to');
	$tpl->assign('gmtimeFrom', time());
	$tpl->assign('gmtimeTo'  , time());
	
	$search_var[] = $moduleName;
	$search_var[] = $moduleName . '_title';
	$search_var[] = $moduleName . '_keywords';
	$search_var[] = $moduleName . '_description';
	$search_var[] = $moduleName . '_doi';
	$search_var[] = $moduleName . '_publication_date_from';
	$search_var[] = $moduleName . '_publication_date_fromYear';
	$search_var[] = $moduleName . '_publication_date_fromMonth';
	$search_var[] = $moduleName . '_publication_date_fromDay';
	$search_var[] = $moduleName . '_publication_date_to';
	$search_var[] = $moduleName . '_publication_date_toYear';
	$search_var[] = $moduleName . '_publication_date_toMonth';
	$search_var[] = $moduleName . '_publication_date_toDay';
	
	return array(
		'title'            => array('name'=>_MD_XOONIPS_ITEM_TITLE_LABEL,        'value'=>"<input type='text' name='${moduleName}_title'       value='' />"),
		'keywords'         => array('name'=>_MD_XOONIPS_ITEM_KEYWORDS_LABEL,     'value'=>"<input type='text' name='${moduleName}_keywords'    value='' />"),
		'description'      => array('name'=>_MD_XOONIPS_ITEM_DESCRIPTION_LABEL,  'value'=>"<input type='text' name='${moduleName}_description' value='' />"),
		'doi'              => array('name'=>_MD_XOONIPS_ITEM_DOI_LABEL,          'value'=>"<input type='text' name='${moduleName}_doi'         value='' />"),
		'publication_date' => array('name'=>_MD_XOONIPS_ITEM_PUBLICATION_DATE_LABEL,  'value'=>$tpl->fetch( "db:xoonips_search_date.html" )),
		'publication_year' => array('name'=>_MD_XOONIPS_ITEM_PUBLICATION_YEAR_LABEL,  'value'=>$tpl->fetch( "db:xoonips_search_year.html" )),
		'publication_month'=> array('name'=>_MD_XOONIPS_ITEM_PUBLICATION_MONTH_LABEL, 'value'=>$tpl->fetch( "db:xoonips_search_month.html")),
		'publication_mday' => array('name'=>_MD_XOONIPS_ITEM_PUBLICATION_MDAY_LABEL,  'value'=>$tpl->fetch( "db:xoonips_search_mday.html" ))
	);
}

/** Input keyword is divided into the unit of the retrieval. 
 *  the unit of the retrieval: character strings enclosed with delimitation by blank or double-quote
 * @param keywords Input keyword
 * @return result divided into the unit of the retrieval. ex) 'foo "bar fobar"' -> array('foo', 'bar fobar')
 */
function xnpSplitKeywords( $keywords ){
	$match = array();
	preg_match_all('/(([^ "]+)|"([^"]+)")/', $keywords, $match, PREG_PATTERN_ORDER );
	
	/*
		input a% b% "hoge huga", the content of $match:
		array(
			array( "a%", "b%", '"hoge huga"' ),
			array( "a%", "b%", '"hoge huga"' ),
			array( "a%", "b%", "" ),
			array( "",    "",  "hoge huga" )
		)
	*/
	
	$ar = array();
	for ( $j = 2; $j <= 3; $j++ ){
		$len = count($match[$j]);
		for ( $i = 0; $i < $len; $i++ ){
			$word = $match[$j][$i];
			if ( $word == "" )
				continue;
			$ar[] = $word;
		}
	}
	return $ar;
}

/* memo:
    
    :
      ѸǤ 
        m&#252;ller -> "m&#252;ller"
        m &#252;ller -> m "&#252;ller" 
        ñ춭϶Ȥ롥&#ޤñϥե졼롥
        
      ܸʤ  
        ۤ&#252;դ -> ɥ򤫤 "ۤ  &#252;  դ"
        ۤ&#252;huga -> ɥ򤫤 "ۤ  &#252;huga"
            &#252;huga -> ɥ򤫤         "&#252;huga"
        &#sbȤߤʤ&#ޤsbʸϥե졼
      
      numericasciiñ줬ڤƤޤΤϻ̵
      252&#252;˥ҥåȤΤϻ̵
*/


/** Ϥ줿ɤmatchǻѤʸ롣fulltextѡ
 * keywordʸޤ˽ɬפ롣\Ȥ+Ȥ-Ȥ&#...;ϵĤɬפ롥
 * ʸɤѴԤ _CHARSET+numeric -> UTF8 -> _CHARSET+numeric.  öUTF8ˤΤ ɽ줹뤿ᡥ
 * valid_word := "[^"]+" | [A-Za-z0-9_'&#;\x80-\xff]+ 
 *  ""ǰϤޤƤ뢪ե졼ʳ Ȥ٤
 * multibyteʸޤ xnpWordSeparationʬ䤵뢪ե졼ʳ ȤʤHITʤ
 * @param keyword Ϥ줿ɡ
 * @return array( expression, errorMessage )
 *  expression ϡΤޤ " select .... match ( ... ) against ( '$expression' in boolean mode )" Ȥդ˻Ѳǽ
 *  errorMessage  顼å
 *
 *  _CHARSET -> UTF -> _CHARSET  
 *    ܸĶϿ ѸĶǸǤʤդޤ
 *  
 *  xnpSplitKeywords2ƱȤ򤷤Ƥ褦ǤϤʤ
 *    xnpSplitKeywords2 : like黻Ҥ ʣΥĴ٤Ȥ˻Ȥ
 *    xnpKeywordsToFulltextSql : match-against  1ĤfulltextĴ٤Ȥ˻Ȥ
 * 
 * ( ( a b c or d ) e or f g )  ->  +((+((+a +b +c) d) +e) (+f +g))
 *
 * : keyword  = '( ( a b c or d ) e or f g )' Ȥ
 *  -> expression = '+(( +(( a b c ) ( d ) ) e ) ( f g ) )'
 *  -> errorMessage = false
 */
function xnpKeywordsToFulltextSql( $keyword ){
	
	/* keywordsearch_textΥ󥳡ɤפ롥
	   ѸĶ   numeric     -> utf8 -> latin1+numeric
	   ܸĶ euc+numeric -> utf8 -> euc+numeric */
	if (xnpChkServerLang()){
		$utf8_keyword = mb_convert_encoding( $keyword, 'UTF-8', mb_detect_encoding( $keyword ) );
		$utf8_keyword = xnpEntity2Utf8($utf8_keyword);
		$keyword = encodeMeta2Server( $utf8_keyword );
	}
	else {
		// ѸĶlatin1ɽǽnumeric/entitylatin1Ѵ
		$keyword = xnpChar2NumEntities( $keyword ); // ʸ΢ʸ
		$keyword = xnpNumeric2ISO_8859_1( $keyword ); // ʸlatin1
	}
	$match = array();
	preg_match_all('/([A-Za-z0-9_\'&#;\x80-\xff]+)|(\()|(\))|"([^"]+)"/', $keyword, $match, PREG_SET_ORDER );
	$ar = array( '(' );
	
	$nest = 0; // ̤ο
	$expectTerm = true; // stringޤ(뤳ȤԤ
	
	foreach ( $match as $match1 ){
		$str = $match1[0];
		$lowerstr = strtolower( $str );
		if      ( $str == '(' ){
			$nest++;
			$expectTerm = true;
			$ar[] = '+( (';
		}
		else if ( $str == ')' ){
			$nest--;
			if ( $expectTerm || $nest < 0 )
				return array( false, _MD_XOONIPS_ITEM_SEARCH_SYNTAX_ERROR);
			$expectTerm = false;
			$ar[] = ') )';
		}
		else if ( $lowerstr == 'and' ){
			if ( $expectTerm )
				return array( false, _MD_XOONIPS_ITEM_SEARCH_SYNTAX_ERROR);
			$expectTerm = true;
		}
		else if ( $lowerstr == 'or' ){
			if ( $expectTerm )
				return array( false, _MD_XOONIPS_ITEM_SEARCH_SYNTAX_ERROR);
			$expectTerm = true;
			$ar[] = ') (';
		}
		else {
			//echo " xnpKeywordsToFulltextSql: [ $str ] <br>\n";
			
			$is_phrase = ( substr( $str, 0, 1 ) == '"' );
			if ( $is_phrase ) // "" ǰϤޤ줿ʸ
				$str = substr( $str, 1, -1 );  // ξüdouble-quote
			
			$is_mb = preg_match( '/[\x80-\xff]+/', $str );
			$is_num = preg_match( '/[&#;]+/', $str );
			
			if ( !XOOPS_USE_MULTIBYTES && $is_num || 
			      XOOPS_USE_MULTIBYTES && ( $is_num || $is_mb ) ){ // multibyteʸʸȤޤࡥե졼ˤɬפ롥
				$separated = xnpWordSeparation($str, false, false);
				if ( count( $separated ) == 1 && $is_mb && !$is_num ){
					// ñmultibyteξ硥ξphraseǤhitʤΤǡ׸Ԥ
					// : keyword=""  ǡsearch_text    "     " 
					$ar[] = '+'.$separated[0].'*';
				}
				else {
					// ʣθޤ : keyword="    "
					// ñɿʸȤޤ : keyword="m&#252;ller"
					$ar[] = '+"' . addslashes( implode( ' ', $separated ) ) . '"';
				}
			}
			else if ( $is_phrase ){
				$ar[] = '+"' . addslashes( $str ) . '"';
			}
			else {
				// ʸޤʤ顤롥ѸĶΥ饦Ȥ̤ɬפ롥
				if (  XOOPS_USE_MULTIBYTES && preg_match( '/[^A-Za-z0-9_\']+/'         , $str ) || 
				     !XOOPS_USE_MULTIBYTES && preg_match( '/[^A-Za-z0-9_\'\x80-\xff]+/', $str ) )
					return array( false, _MD_XOONIPS_ITEM_SEARCH_SYNTAX_ERROR); // Ⱦѵ椬ʸˡ顼.
				$ar[] = '+'.$str.'*';
			}
			$expectTerm = false;
		}
	}
	if ( $nest != 0 )
		return array( false, _MD_XOONIPS_ITEM_SEARCH_SYNTAX_ERROR);
	$ar[] = ')';
	return array( implode( ' ', $ar ), false );
}


/** ɤSQLWHERE˻Ȥ뼰
 * @param elements ʸxnpSplitKeywords3ʬ򤷤
 * @param wheres ɤγƸʸSQLѴ
 */
function xnpUnsplitKeywords3( $elements, $wheres ){
    $ar = array();
    $len = count($elements);
    
    if ( $len == 0 )
        return " ";
    
    reset( $wheres );
    for ( $i = 0; $i < $len; $i++ ){
        $op = $elements[$i];
        if ( $op == 'string' ){
            list( $key, $val ) = each( $wheres );
            $ar[] = " +$val ";
        }
        else {
            $ar[] = $op;
        }
    }
    return implode( ' ', $ar );
}




/** the unit of the retrieval and syntax are pulled out from input keyword.
 * the unit of the retrieval: 1.character strings don't contain blank and parentheses, and double-quote.
 *                            2.character strings enclosed with double-quote.
 * syntax: the unit of the retrieval in input keyword change 'string', and 'and' operator is supplemented to the 'string'.
 * @param keyword input keyword
 * @return array( elements, keywords, errorMessage )
 *  elements => syntax
 *  keywords => array of the unit of the retrieval
 *  errorMessage => error message
 * 
 * ex: keyword  = '(a or b) "c(d or e)"'
 *  -> keywords = array('a', 'b', '"c(d or e)"')
 *  -> elements = array( '(', 'string', 'or', 'string', ')', 'and', 'string' )
 *  -> errorMessage = false
 * 
 * WHERE of SQL is character strings that user inputs in Quick Search.
 *   list( keywords, elements, errorMessage ) = xnpSplitKeywords2( keyword ); // divide into the unit of the retrieval and syntax.
 *   wheres = xnpGetKeywordsQueries( array(...), keywords ); // the unit of the retrieval is converted into SQL.
 *   where = xnpUnsplitKeyword2( elements, wheres ); // SQL is applied to syntax.
 */
function xnpSplitKeywords2( $keyword ){
	$match = array();
	preg_match_all('/([^ "()]+)|(\()|(\))|"([^"]+)"/', $keyword, $match, PREG_SET_ORDER );
	$keywords = array();
	$elements = array();
	
	$nest = 0; // Depth of parentheses
	$expectTerm = true; // string or '(' is expected to get next time. 
	
	foreach ( $match as $match1 ){
		$str = $match1[0];
		$lowerstr = strtolower( $str );
		if      ( $str == '(' ){
			$nest++;
			if ( !$expectTerm )
				$elements[] = 'and';
			$expectTerm = true;
			$elements[] = $lowerstr;
		}
		else if ( $str == ')' ){
			$nest--;
			if ( $expectTerm || $nest < 0 )
				return array( array(), array(), _MD_XOONIPS_ITEM_SEARCH_SYNTAX_ERROR);
			$expectTerm = false;
			$elements[] = $lowerstr;
		}
		else if ( $lowerstr == 'and' || $lowerstr == 'or' ){
			if ( $expectTerm )
				return array( array(), array(), _MD_XOONIPS_ITEM_SEARCH_SYNTAX_ERROR);
			$expectTerm = true;
			$elements[] = $lowerstr;
		}
		else {
			if ( substr( $str, 0, 1 ) == '"' )
				$str = substr( $str, 1, -1 );  // remove double-quote at both ends
			if ( !$expectTerm )
				$elements[] = 'and';
			$expectTerm = false;
			$elements[] = 'string';
			
			$separated = xnpWordSeparation( $str, false, false );
			$keywords[] = $str;
		}
	}
	if ( $nest != 0 || $expectTerm )
		return array( array(), array(), _MD_XOONIPS_ITEM_SEARCH_SYNTAX_ERROR);
	return array( $elements, $keywords, false );
}


/** generate a sentense from retrieval keyword (sentense is used in WHERE of SQL)
 * @param elements input keyword is resolved with xnpSplitKeywords2.
 * @param wheres character strings in retrieval keyword is converted into SQL sentense.
 */
function xnpUnsplitKeywords2( $elements, $wheres ){
    $ar = array();
    $len = count($elements);
    
    if ( $len == 0 )
        return " 1 ";
    
    reset( $wheres );
    for ( $i = 0; $i < $len; $i++ ){
        $op = $elements[$i];
        if ( $op == 'string' ){
            list( $key, $val ) = each( $wheres );
            $ar[] = "( $val )";
        }
        else {
            $ar[] = $op;
        }
    }
    return "(" . implode( ' ', $ar ) . ")";
}


/** return query of SQL generated from input keywords. If there is no condition, return "".
 * @param dbVarName    table name, and column name in database
 * @param postVarName  Name of variables posted
 */
function xnpGetKeywordQuery( $dbVarName, $postVarName ){
	if ( empty($_POST[$postVarName]) )
		return "";
	$myts =& MyTextSanitizer::getInstance();
	$keywords = xnpSplitKeywords( $myts->stripSlashesGPC($_POST[$postVarName]) );
	if ( count($keywords) == 0 )
		return "";
	
	$ar = array();
	foreach ( $keywords as $keyword ){
		$escKeyword = addslashes(str_replace("_", "\\_", str_replace("%", "\\%", str_replace("\\", "\\\\", $keyword))));
//		$ar[] = "$dbVarName like '%$escKeyword%'";
		$ar[] = xnpGetKeywordQueryEntity( $dbVarName, $escKeyword );
	}
	return implode( ' and ', $ar );
}

/** return query of SQL generated from the keywords input.
 * @param dbVarNames    array of table name and column name in database.
 * @param keywords      array of keywords
 * @return array of query ([n]: $keywords[n] is contained in one column in array of $dbVarNames at least.)
 */
function xnpGetKeywordsQueries( $dbVarNames, $keywords ){
	$wheres = array();
	foreach ( $keywords as $keyword ){
		$escKeyword = addslashes(str_replace("_", "\\_", str_replace("%", "\\%", str_replace("\\", "\\\\", $keyword))));
		$ar = array(' 0 ');
		foreach ( $dbVarNames as $dbVarName ){
//			$ar[] = "$dbVarName like '%$escKeyword%'";
			$ar[] = xnpGetKeywordQueryEntity( $dbVarName, $escKeyword );
		}
		$wheres[] = implode( ' or ', $ar );
	}
	return $wheres;
}

function xnpGetKeywordQueryEntity( $dbVarName, $escKeyword ){
	if (preg_match("/\d{1,8}/", $escKeyword)) {
		if (preg_match("/&#\d{1,8};/", $escKeyword)) {
			$wk = "$dbVarName like '%$escKeyword%'";
		}
		else {
			$num = sprintf("%d", $escKeyword);
			if ($num <= 0x10FFFF) {
				$digit = 7 - strlen($num);
				$wk = "";
				$wk = "$dbVarName = '$escKeyword'";
				$wk .= " or $dbVarName like '$escKeyword%'";
				$wk .= " or $dbVarName rlike '$escKeyword"."[0-9]{0,$digit}[ -/:<-~]'";
				$wk .= " or $dbVarName rlike '$escKeyword"."[0-9]{1,$digit}$'";
				$wk .= " or $dbVarName like '%$escKeyword'";
				$wk .= " or $dbVarName rlike '[ -".'"'."$-/:-~][0-9]{0,$digit}$escKeyword'";
				$wk .= " or $dbVarName rlike ".'"'."[ -%'-/:-~]#[0-9]{0,$digit}$escKeyword".'"';
				$wk .= " or $dbVarName rlike '^[0-9]{1,$digit}$escKeyword'";
			}
			else {
				$wk = "$dbVarName like '%$escKeyword%'";
			}
		}
	}
	else {
		$wk = "$dbVarName like '%$escKeyword%'";
	}
	return $wk;
}


/** generate query of SQL
  @param dbVarName
  @param postVarName  
  $_POST[$postVarName.'Year' ]
  $_POST[$postVarName.'Month']
  $_POST[$postVarName.'Day'  ]
  ${dbVarName}_year
  ${dbVarName}_month
  ${dbVarName}_mday
  
  "ifnull(y,0)*10000+ifnull(m,0)*100+ifnull(d,0)" is compared.
  from 2005/0/0  -> 20050000 <= yyyymmdd
  to   2005/0/0  -> 20059999 >= yyyymmdd
 */
function xnpGetFromQuery( $dbVarName, $postVarName ){
	$y = (int)xnpGetPostVarDef($postVarName.'Year' , 0);
	$m = (int)xnpGetPostVarDef($postVarName.'Month', 0);
	$d = (int)xnpGetPostVarDef($postVarName.'Day'  , 0);
	if ( $m == 0 ) $d = 0;
	$yyyymmdd = $y*10000 + $m*100 + $d;
	$yyyymm = $y*10000 + $m*100;
	$yyyy = $y*10000;
	
//	return " $yyyymmdd <= IFNULL(${dbVarName}_year,0)*10000 + IFNULL(${dbVarName}_month,0)*100 + IFNULL(${dbVarName}_mday,0)";
	return " ($yyyymmdd <= IFNULL(${dbVarName}_year,0)*10000 + IFNULL(${dbVarName}_month,0)*100 + IFNULL(${dbVarName}_mday,0)) OR (${dbVarName}_mday = 0 AND $yyyymm <= IFNULL(${dbVarName}_year,0)*10000 + IFNULL(${dbVarName}_month,0)*100) OR (${dbVarName}_month = 0 AND ${dbVarName}_mday = 0 AND $yyyy <= IFNULL(${dbVarName}_year,0)*10000)";
}

function xnpGetToQuery( $dbVarName, $postVarName ){
	$y = (int)xnpGetPostVarDef($postVarName.'Year' , 0);
	$m = (int)xnpGetPostVarDef($postVarName.'Month', 0);
	$d = (int)xnpGetPostVarDef($postVarName.'Day'  , 0);
	if ( $y == 0 ) $y = 9999;
	if ( $m == 0 ) {
		$m = 99;
		$d = 0;
	}
	if ( $d == 0 ) $d = 99;
	$yyyymmdd = $y*10000 + $m*100 + $d;
	$yyyymm = $y*10000 + $m*100;
	$yyyy = $y*10000;
	
//	return " $yyyymmdd >= IFNULL(${dbVarName}_year,0)*10000 + IFNULL(${dbVarName}_month,0)*100 + IFNULL(${dbVarName}_mday,0)";
	return " ($yyyymmdd >= IFNULL(${dbVarName}_year,0)*10000 + IFNULL(${dbVarName}_month,0)*100 + IFNULL(${dbVarName}_mday,0)) OR (${dbVarName}_mday = 0 AND $yyyymm >= IFNULL(${dbVarName}_year,0)*10000 + IFNULL(${dbVarName}_month,0)*100) OR (${dbVarName}_month = 0 AND ${dbVarName}_mday = 0 AND $yyyy >= IFNULL(${dbVarName}_year,0)*10000)";
}

/** return query of SQL for retrieve Basic Information in Advanced Search. If there is no condition in input, return empty character strings.
 * @param moduleName name of module
 * @return query of SQL
 */
function xnpGetBasicInformationAdvancedSearchQuery($moduleName){
	$wheres = array();
	global $xoopsDB;
	$basic_table = $xoopsDB->prefix('xoonips_item_basic');
	$title_table = $xoopsDB->prefix('xoonips_item_title');
	$keyword_table = $xoopsDB->prefix('xoonips_item_keyword');
	$w = xnpGetKeywordQuery($title_table.'.title'        ,$moduleName.'_title'      );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($keyword_table.'.keyword'   ,$moduleName.'_keywords'   );  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($basic_table.'.description',$moduleName.'_description');  if ( $w ) $wheres[] = $w;
	$w = xnpGetKeywordQuery($basic_table.'.doi'        ,$moduleName.'_doi'        );  if ( $w ) $wheres[] = $w;
	if (!empty($_POST[$moduleName.'_publication_date_from' ])) $wheres[] = xnpGetFromQuery($basic_table.'.'.'publication', $moduleName.'_publication_date_from');
	if (!empty($_POST[$moduleName.'_publication_date_to'   ])) $wheres[] = xnpGetToQuery  ($basic_table.'.'.'publication', $moduleName.'_publication_date_to');
	if (!empty($_POST[$moduleName.'_creation_date_from'    ])) $wheres[] = $basic_table. '.' .'creation_date >= ' . $_POST[$moduleName.'_creation_date_from' ];
	
	return implode( ' and ',$wheres );
}

/** sum of file size in items specified with iids
 * @param iids  array of item_id
 * @return  sum of file size
 */
function xnpGetTotalFileSize( $iids ){
	if ( count($iids) == 0 )
		return 0.0;
	
	global $xoopsDB;
	$file_table  = $xoopsDB->prefix('xoonips_file');
	$iids_str = implode( ',', $iids );
	
	// calculate amount of use file_table and file
	$sql = "select sum(file_size) from $file_table where item_id in ($iids_str)";
	$result = $xoopsDB->query($sql);
	list( $file_size ) = $xoopsDB->fetchRow($result);
	
	return  (double)$file_size;
}

/**
 * check that item is pending now, return ture.
 * Pending: when item has as much as one index waiting for certified.
 * 
 * @param item_id ID of retrieval item
 * @return true item has index waiting for certified(Pending).
 * @return false item has no index waiting for certified
 * 
 */
function xnpIsPending( $item_id )
{
	$xnpsid = $_SESSION['XNPSID'];
	$indexes = array();
	$result = xnpGetIndexes( $xnpsid, $item_id, $indexes );
	if ( $result == 0 ){
		foreach( $indexes as $index ){
			if( $index['open_level'] != OL_PUBLIC && $index['open_level'] != OL_GROUP_ONLY ) continue;
			$xid = $index['item_id'];
			$state = NOT_CERTIFIED;
			if( xnp_get_certify_state( $xnpsid, $xid, $item_id, $state ) == RES_OK ){
				if( $state == CERTIFY_REQUIRED ) return true;
			}
		}
	}
	return false;
}

/** get remote_host to use xnp_insert_event().
 */
function xnpGetRemoteHost()
{
	return ( isset($_SERVER['REMOTE_HOST']) ? $_SERVER['REMOTE_HOST'] : $_SERVER['REMOTE_ADDR'] );
}

function xnpCacheWrite( $cachable, $cache_field, $search_cache_id, $iids ){
    global $xoopsDB;
    if ( $cachable && $cache_field ){
         // todo:  insert...select ǽ񤭹Ǥ٤? 
         if ( count( $iids ) ){
           if ( $cache_field == 'metadata' )
             $sql = "insert ignore into ${table_cache}_${cache_field} ( search_cache_id, identifier ) values ( $search_cache_id, '" . implode( "'), ( $search_cache_id, '", $iids ) . "') ";
           else
             $sql = "insert ignore into ${table_cache}_${cache_field} ( search_cache_id, ${cache_field}_id ) values ( $search_cache_id, " . implode( "), ( $search_cache_id, ", $iids ) . ") ";
         }
         $xoopsDB->query( $sql );
         $item_count = count($iids);
         $sql = "update $table_cache set ${cache_field}_count=$item_count where search_cache_id=$search_cache_id";
         $xoopsDB->query( $sql );
    }
}

/**
 * 
 * @param op 'quicksearch' 'advancedsearch' 'itemsubtypesearch' 'itemtypesearch'
 * @param keyword search keyword
 * @param search_itemtype how to search ('all', 'basic' or name of itemtype (ex.xnppaper) )
 * @param private_flag true if search private indexes.
 * @param msg reference to variables that receive  error message
 * @param iids reference to array that receive item id that match query condition
 * @param search_cache_id search cache id(in/out)
 * @return true search succeed.
 * @return false search failed. make sure $msg for detail.
 * this function needs $xoopsDB, $xoopsUser, $xoopsConfig, $_SESSION.
 * 
 */
function xnpSearchExec( $op, $keyword, $search_itemtype, $private_flag,  &$msg, &$iids, &$search_var, &$search_cache_id, $search_tab )
{
    global $xoopsDB, $xoopsUser, $xoopsConfig;
    $myts =& MyTextSanitizer::getInstance();
    
    $xnpsid = $_SESSION['XNPSID'];
    $esc_sess_id = addslashes( $_SESSION['XNPSID'] );
    if( !xnp_is_valid_session_id($xnpsid) ){
        // guest access is forbidden
        return array();
    }else if( $xoopsUser ){
        // identified user
        $uid=$xoopsUser->getVar('uid');
    }else{
        // guest access is permitted
        $uid = 0;
    }
    
    $cache_table      = $xoopsDB->prefix('xoonips_search_cache');
    $cache_item_table = $xoopsDB->prefix('xoonips_search_cache_item');
    $cache_file_table = $xoopsDB->prefix('xoonips_search_cache_file');
    $cache_meta_table = $xoopsDB->prefix('xoonips_search_cache_metadata');
    $meta_table       = $xoopsDB->prefix('xoonips_oaipmh_metadata');
    $repo_table       = $xoopsDB->prefix('xoonips_oaipmh_repositories');
    $basic_table      = $xoopsDB->prefix('xoonips_item_basic');
    $title_table      = $xoopsDB->prefix('xoonips_item_title');
    $keyword_table    = $xoopsDB->prefix('xoonips_item_keyword');
    $file_table       = $xoopsDB->prefix('xoonips_file');
    $xlink_table      = $xoopsDB->prefix('xoonips_index_item_link');
    $index_table      = $xoopsDB->prefix('xoonips_index');
    $glink_table      = $xoopsDB->prefix('xoonips_groups_users_link');
    $search_text_table= $xoopsDB->prefix('xoonips_search_text');
    $user_table       = $xoopsDB->prefix('users');
    
    // search_cache_idʤ顢search_cache
    if ( $search_cache_id ){
        $search_cache_id = (int)$search_cache_id;
        $sql =  "select * from $cache_table where search_cache_id=$search_cache_id and sess_id='$esc_sess_id'";
        $result = $xoopsDB->query( $sql );
        if ( $xoopsDB->getRowsNum( $result ) == 0 ){
             //todo: session timeoutΤsearch_cacheä줿Τ⤷ʤ(̤ϵʤΤ)ɤΤ褦ʥåФ٤? 
            $msg = _MD_XOONIPS_ITEM_SEARCH_ERROR;
            return false; // bad search_cache_id
        }
        //echo $sql;
        if      ( $search_tab == 'metadata' ) $sql = "select identifier from $cache_meta_table where search_cache_id=$search_cache_id";
        else if ( $search_tab == 'file' )
            $sql = "select tf.item_id    from $cache_file_table as tcf
              left join $file_table as tf on tcf.file_id = tf.file_id 
              left join $basic_table as tb on tb.item_id = tf.item_id 
              left join $search_text_table as tst on tf.file_id=tst.file_id
              where search_cache_id=$search_cache_id and tb.item_id is not null and tf.file_id is not null";
        else
            $sql = "select tci.item_id    from $cache_item_table as tci
              left join $basic_table as tb on tb.item_id = tci.item_id 
              where search_cache_id=$search_cache_id and tb.item_id is not null";
        $result = $xoopsDB->query( $sql );
        while ( list( $iid ) = $xoopsDB->fetchRow($result) )
            $iids[] = $iid;
        return true;
    }
    
    $cachable = ( $op == 'quicksearch' || $op == 'advancedsearch' );
    $search_cache_id = 0;
    if ( $cachable ) {
        // search_cache_idȯԤ
        $sql =  "insert into $cache_table ( sess_id ) values ( '$esc_sess_id' )";
        $result = $xoopsDB->queryF( $sql );
        if ( $result == false ){
            $msg = _MD_XOONIPS_ITEM_SEARCH_ERROR;
            return false;
        }
        $search_cache_id = $xoopsDB->getInsertId();
    }
    
    $itemtypes = array();
    $itemtype_names = array();
    $tmp = array();
    if( ( $res = xnp_get_item_types( $tmp ) ) != RES_OK ){
        $msg = _MD_XOONIPS_ITEM_SEARCH_ERROR;
        return false;
    }else{
        foreach( $tmp as $i){
            $itemtypes[$i['item_type_id']]=$i;
            $itemtype_names[$i['name']] = $i;
        }
    }
    $join1 =
      " left join $xlink_table on $xlink_table.item_id  = $basic_table.item_id ".
      " left join $index_table on $index_table.index_id = $xlink_table.index_id ".
      " left join $glink_table on $glink_table.gid      = $index_table.gid ".
      " left join $user_table  on $user_table.uid       = $basic_table.uid ";
    $iids = array();
    
    if ( $private_flag ){ // operation to add item into index. search for only the user's item.
        $privilege = "( $index_table.open_level = " . OL_PRIVATE . " and $index_table.uid=$uid )";
    }
    else { // search for readable items.
        if ( xnp_is_moderator( $xnpsid, $uid ) ){
            $privilege = " 1 ";
        }
        else {
            $privilege =
                " ($index_table.open_level = ".OL_PUBLIC." or \n".
                "  $index_table.open_level = ".OL_PRIVATE." and $index_table.uid=$uid or \n".
                "  $index_table.open_level = ".OL_GROUP_ONLY." and $glink_table.uid=$uid ) \n";
        }
    }
    
    if ( $op == 'advancedsearch' || $op == 'itemsubtypesearch' ){
        // advanced Ǥϡ̤򥿥ɽʤ$search_tab ̵뤹롣
        // advanced ǤϡfileҥåȤǤ search_cache_fileǤϤʤsearch_cache_itemΤۤ˽
        foreach ( $itemtypes as $itemtype_id => $itemtype ){
            $wheres = array(' 0 ');
            $module_name = $itemtype['name'];
            if ( !empty($_POST[$module_name]) ){
                include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
                $f = $module_name . 'GetAdvancedSearchQuery';
                $table = $xoopsDB->prefix("${module_name}_item_detail");
                $key_name = "${table}.".substr($module_name, 3) . '_id'; // xnppaper -> paper_id
                
                $where = "";
                $join = "";
                $f($where,$join); // require retrieve additional query string to item type module
                if ( $where != "" ){
                    $sql = "select $basic_table.item_id, $search_cache_id from $basic_table ".
                       $join1. 
                       " left join $file_table    on $file_table.item_id    = $basic_table.item_id ".
                       " left join $title_table   on $title_table.item_id   = $basic_table.item_id ".
                       " left join $keyword_table on $keyword_table.item_id = $basic_table.item_id ".
                       " left join $table on $key_name = $basic_table.item_id ".
                       $join.
                       " where  $key_name is not NULL and ( $where ) and $privilege \n".
                       " group by $basic_table.item_id  \n";
                    //echo "<!--  $sql \n -->";
                    
                    if ( $cachable ){ // write to cache at once
                        $result = $xoopsDB->queryF("insert ignore into $cache_item_table ( item_id, search_cache_id ) ".$sql);
                        $sql = "select item_id from $cache_item_table where search_cache_id = $search_cache_id";
                    }
                    
                    $result = $xoopsDB->query($sql);
                    if ( $result == false ){
                        $msg = _MD_XOONIPS_ITEM_SEARCH_ERROR;
                        xoonips_error( $xoopsDB->error()." sql=$sql"." at ".__LINE__." in ".__FILE__ );
                        return false;
                    }
                    while ( list( $iid ) = $xoopsDB->fetchRow($result) )
                        $iids[] = $iid;
                }
            }
        }
    }
    else if ( $op == 'itemtypesearch' ){ // top̤顣$search_itemtype˰פ륢ƥ
        $itemtype_id = $itemtype_names[$search_itemtype]['item_type_id'];
        $sql = "select $basic_table.item_id, $search_cache_id from $basic_table \n" .
            $join1. 
            " where $privilege and $basic_table.item_type_id=$itemtype_id \n".
            " group by $basic_table.item_id  ";
        $result = $xoopsDB->query($sql);
        while ( list( $iid ) = $xoopsDB->fetchRow($result) )
            $iids[] = $iid;
    }
    else if ( $op == 'quicksearch' && trim($keyword) != '' ){
        $keyword = $myts->stripSlashesGPC($keyword);
        $search_var[] = 'keyword';
        $search_var[] = 'search_itemtype';
        if ( $op == 'quicksearch' )
            list( $elements, $keywords, $errorMessage ) = xnpSplitKeywords2( $keyword );
        else
            list( $elements, $keywords, $errorMessage ) = array( array(), array(), false );
        $keywordsLen = count($keywords);
        if ( $errorMessage ){
            $msg = $errorMessage;
            return false;
        }
        
        if ( $search_itemtype == 'basic' ){ // search titles and keywords
            $wheres_title_keyword = xnpGetKeywordsQueries( array($title_table.'.title', $keyword_table.'.keyword'), $keywords );
            $where = " $basic_table.item_type_id != " . ITID_INDEX . " and  " . xnpUnsplitKeywords2( $elements, $wheres_title_keyword );
            $sql = "select $basic_table.item_id, $search_cache_id from $basic_table \n" .
                $join1. 
                " left join $title_table   on $basic_table.item_id = $title_table.item_id ".
                " left join $keyword_table on $basic_table.item_id = $keyword_table.item_id ".
                " where $where and $privilege \n".
                " group by $basic_table.item_id  \n";
            
            // inserting results to cache
            $result = $xoopsDB->queryF("insert ignore into $cache_item_table ( item_id, search_cache_id ) ".$sql);
            $sql = "select item_id from $cache_item_table where search_cache_id = $search_cache_id";
            
            $result = $xoopsDB->query($sql);
            if ( $result == false ){
                $msg = _MD_XOONIPS_ITEM_SEARCH_ERROR;
                return false;
            }
            while ( list( $iid ) = $xoopsDB->fetchRow($result) )
                $iids[] = $iid;
        }
        
        if ( $search_itemtype == 'metadata' || $search_itemtype == 'all' ){
            // if 'metadata' then set result of search to cache and $iids
            // if 'all' then write to cache
            
            list( $fulltextSql, $errorMessage ) = xnpKeywordsToFulltextSql( $keyword );
            if ( $errorMessage ){
                $msg = $errorMessage;
                return false;
            }
            $sql = "select identifier, $search_cache_id 
             from ${meta_table} as data, ${repo_table} as repo 
             where repo.enabled=1 AND repo.deleted!=1 AND repo.repository_id=data.repository_id 
              AND match( search_text ) against ('$fulltextSql' IN BOOLEAN MODE) 
             order by identifier, data.repository_id";
            
            //echo "<hr>\n $sql<hr>\n";
            // inserting results to cache
            $result = $xoopsDB->queryF("insert into $cache_meta_table ( identifier, search_cache_id ) ".$sql);
            $sql = "select item_id from $cache_item_table where search_cache_id = $search_cache_id";
            
            $result = $xoopsDB->query($sql);
            if ( $result == false ){
                $msg = _MD_XOONIPS_ITEM_SEARCH_ERROR;
                return false;
            }
            while ( list( $iid ) = $xoopsDB->fetchRow($result) )
                $iids[] = $iid;
        }
        
        if ( isset($itemtype_names[$search_itemtype]) || $search_itemtype == 'all' ) {
            /* where_condition[item_type] = "item_type_id=$itemtype_id and " ( query that combines 'wheres2' and 'and or ( )' ).
               wheres2[keyword] = ( where_basic[keyword] or where_detail[keyword] )
            */
            // search_itemtype == (itemtype)ξե򸡺ɬפ롥
            // ǥե븡Ԥäơ̤ xoonips_search_cache_file ˽
            
            list( $fulltextSql, $errorMessage ) = xnpKeywordsToFulltextSql( $keyword );
            if ( $errorMessage ){
                $msg = $errorMessage;
                return false;
            }
            
            $wheres_basic = xnpGetKeywordsQueries( array($title_table.'.title', $keyword_table.'.keyword', $basic_table.'.description', $basic_table.'.doi', $user_table.'.uname', $user_table.'.name'), $keywords );
            foreach ( $itemtypes as $itemtype_id => $itemtype ){
                if ( $itemtype['item_type_id'] == ITID_INDEX )
                    continue;
                $module_name = $itemtype['name'];
                //echo "$search_itemtype / $module_name <br>\n";
                if ( $search_itemtype == $module_name || $search_itemtype == 'all' ){
                    $itemtype_id = $itemtype['item_type_id'];
                    
                    include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
                    $f = $module_name . 'GetDetailInformationQuickSearchQuery';
                    if ( !function_exists( $f ) )
                        continue;
                    
                    $table = $xoopsDB->prefix("${module_name}_item_detail");
                    $wheres_detail = array();
                    $f($wheres_detail,$join,$keywords);
                    
                    $wheres2 = array();
                    for ( $i = 0; $i < $keywordsLen; $i++ ){
                        if ( empty( $wheres_detail[$i] ) )
                            $wheres_detail[$i] = '0';
                        $wheres2[] = $wheres_basic[$i] . ' or ' . $wheres_detail[$i];
                    }
                    
                    $where = " $basic_table.item_type_id=$itemtype_id and " . xnpUnsplitKeywords2( $elements, $wheres2 );
                    $key_name = "${table}.".substr($module_name, 3) . '_id'; // xnppaper -> paper_id
                    $sql = "select $basic_table.item_id, $search_cache_id from $basic_table " .
                        $join1. 
                        " left join $file_table  on $file_table.item_id   = $basic_table.item_id ".
                        " left join $title_table   on $basic_table.item_id = $title_table.item_id ".
                        " left join $keyword_table on $basic_table.item_id = $keyword_table.item_id ".
                        " left join $table on $key_name = $basic_table.item_id ".
                        $join.
                        " where $where and $privilege \n".
                        " group by $basic_table.item_id  \n";
                    
                    // echo "<hr>\n $sql<hr>\n";
                    if ( $cachable ){ // write to cache at once
                        $result = $xoopsDB->queryF("insert ignore into $cache_item_table ( item_id, search_cache_id ) ".$sql);
                        $sql = "select item_id from $cache_item_table where search_cache_id = $search_cache_id";
                    }
                    
                    $result = $xoopsDB->query($sql);
                    if ( $result == false ){
                        $msg = _MD_XOONIPS_ITEM_SEARCH_ERROR;
                        return false;
                    }
                    
                    // search inside files
                    $sql = "insert ignore into $cache_file_table ( file_id, search_cache_id ) 
                      select $file_table.file_id, $search_cache_id from $file_table 
                      left join $basic_table on $file_table.item_id=$basic_table.item_id  
                      left join $search_text_table on $file_table.file_id = $search_text_table.file_id 
                      where item_type_id=$itemtype_id and match( search_text ) against ('$fulltextSql' IN BOOLEAN MODE)";
                    
                    // write to cache at once
                    $result = $xoopsDB->queryF($sql);
                    if ( $result == false ){
                        $msg = _MD_XOONIPS_ITEM_SEARCH_ERROR;
                        return false;
                    }
                    $sql = "select item_id from $cache_item_table where search_cache_id = $search_cache_id";
                    
                    $result = $xoopsDB->query($sql);
                    if ( $result == false ){
                        $msg = _MD_XOONIPS_ITEM_SEARCH_ERROR;
                        return false;
                    }
                }
            }
            $result = $xoopsDB->query("select item_id from $cache_item_table where search_cache_id=$search_cache_id");
            while ( list( $iid ) = $xoopsDB->fetchRow($result) )
                $iids[] = $iid;
        }
    }
    return true;
}

/** get relative path string of $xid to $base_index_id
 * @param $xid 
 * @param $base_index_id
 */
function xnpGetExportPathString( $xid, $base_index_id )
{
    $xnpsid = $_SESSION['XNPSID'];
    $ar = array();
    while ( true ){
        if ( $xid == $base_index_id )
            return implode( '/', array_reverse( $ar ) );
        else if ( $xid == IID_ROOT )
            return false;
        
        $index = array();
        $res = xnp_get_index( $xnpsid, $xid, $index );
        if ( $res != RES_OK )
            return false;
        $ar[] = addcslashes( $index['titles'][0], "\\/" );
        $xid = $index['parent_index_id'];
    }
}

/**
 * 
 * function returns XML that is converted into Basic Information of items
 * 
 * When item_id is unknown or error occurs in database, function returns NULL.
 * 
 * @param fhdl file handle writes outputs
 * @param item item information to make XML
 * @param is_absolute  true:index tags are absolute path. false: index tags are relative path to base_index_id.
 * @param base_index_id  is_absolute == false && base_index_id == false: outputs only 1 empty index tag "<index></index>"
 *                       is_absolute == false && base_index_id != false: outputs only descendants of base_index_id
 *                       is_absolute == true: ignored
 * @return true:success, false:failure
 */
function xnpBasicInformation2XML( $fhdl, $item, $is_absolute, $base_index_id = false )
{
    if( !$fhdl ) return false;
    
	$xnpsid = $_SESSION['XNPSID'];
    $account = array();

    $res = xnp_get_account( $xnpsid, $item['uid'], $account );
	if( $res != RES_OK ){
        return false;
    }else{
		$contributor = $account['name']."(".$account['uname'].")";
	}

    $itemtypes = array();
    $res = xnp_get_item_types( $itemtypes );
    if( $res != RES_OK ){
        return false;
    }else{
        foreach( $itemtypes as $i){
            if( $i['item_type_id'] == $item['item_type_id'] ){
                $itemtype = $i['name'];
                break;
            }
        }
    }
    if( !isset( $itemtype ) ){ return false; }
    
    $last_update_date = gmdate( 'Y-m-d\TH:i:s\Z', $item['last_update_date'] );
    $creation_date    = gmdate( 'Y-m-d\TH:i:s\Z', $item['creation_date'] );
    
    $index_id = array();
    $res = xnp_get_index_id_by_item_id( $xnpsid, $item['item_id'], $index_id );
    if( $res != RES_OK ){
        return false;
    }
	
	//generate <title>xxx</title> for each title
	$titles = "";
	foreach( $item['titles'] as $title ){
		$titles .= "<title>".xnpHtmlspecialchars( $title )."</title>\n";
	}
	$keywords = "";
	foreach( $item['keywords'] as $keyword ){
		$keywords .= "<keyword>".xnpHtmlspecialchars( $keyword )."</keyword>\n";
	}
	
    if( !fwrite( $fhdl, "<basic id=\"${item['item_id']}\">\n"
                ."<itemtype>${itemtype}</itemtype>\n"
                ."<titles>".$titles."</titles>\n"
                ."<contributor uname='".xnpHtmlspecialchars($account['uname'])."'>".xnpHtmlspecialchars($contributor)."</contributor>\n"
                ."<keywords>".$keywords."</keywords>\n"
                ."<description>".xnpHtmlspecialchars($item['description'])."</description>\n"
                ."<doi>".xnpHtmlspecialchars($item['doi'])."</doi>\n"
                ."<last_update_date>$last_update_date</last_update_date>\n"
                ."<creation_date>$creation_date</creation_date>\n"
                ."<publication_year>${item['publication_year']}</publication_year>\n"
                ."<publication_month>${item['publication_month']}</publication_month>\n"
                ."<publication_mday>${item['publication_mday']}</publication_mday>\n"
                ."<lang>${item['lang']}</lang>\n"
                ."<url>".XOOPS_URL."/modules/xoonips/detail.php?item_id=${item['item_id']}</url>\n" ) ) return false;
    if( !xnpExportChangeLog( $fhdl, $item['item_id'] ) ) return false;
    $ar = array();
    
    $open_level_str = array( OL_PUBLIC => 'public', OL_GROUP_ONLY => 'group', OL_PRIVATE => 'private' );
    
    if ( $is_absolute ){
        $base_index_id = IID_ROOT;
        $head = '/';
    }
    else 
        $head = '';
    
    if ( $base_index_id ){
        foreach( $index_id as $i ){
            $str = xnpGetExportPathString( $i, $base_index_id );
            if ( $str === false )
                continue;
            $index = array();
            if ( RES_OK != xnp_get_index( $xnpsid, $i, $index ) )
                continue;
            if( !fwrite( $fhdl, "<index open_level='".$open_level_str[$index['open_level']]."'>".xnpHtmlspecialchars($head.$str)."</index>\n" ) ) return false;
        }
    }
    else {
        if( !fwrite( $fhdl, "<index></index>\n" ) ) return false;
    }
    if( !fwrite( $fhdl, "</basic>\n" ) ) return false;
    return true;
}
/**
 * 
 * generate RSS based on event log, the RSS saves in file.
 * 
 * @param filename saved file path
 * @param max maximum number of event written in RSS
 * @return true success
 * @return false failure
 *
 */
function xnpGenerateRss( $filename = null, $max = null )
{
    global $xoopsConfig;
    
	$xnpsid = $_SESSION['XNPSID'];
    
    if( !isset( $filename ) ){
        if( xnp_get_config_value( 'rss_file_path', $filename ) != RES_OK ) return false;
        $filename = XOOPS_ROOT_PATH.'/'.$filename;
    }

    if( !isset( $max ) ){
        if( xnp_get_config_value( 'rss_item_max', $max ) != RES_OK ) return false;
    }
    
    $events = array();
    $result = xnp_get_events_for_rss( $xnpsid, $events, $max );
    if( $result != RES_OK ){
        echo $result;
        echo xnp_get_last_error_string();
        return false;
    }
    
    $rdfseq = array();
    $items = array();
    
    foreach( $events as $e ){
        $date = gmdate( "Y-m-d\TH:i+00:00", $e['timestamp'] );
        if( $e['event_type_id'] == ETID_CERTIFY_ITEM ){
            $item = array();
            $url = XOOPS_URL."/modules/xoonips/detail.php?item_id=${e['item_id']}";
            if( xnp_get_item( $xnpsid, $e['item_id'], $item ) != RES_OK ) continue;
            $indexpath = xnpGetIndexPathString( $xnpsid, $e['index_id'] );
            $items[] = "<item rdf:about=\"${url}\">";
//            $items[] = "<title>".htmlspecialchars($item['title'])."</title>";
            $items[] = "<title>".xnpHtmlspecialchars($item['title'])."</title>";
            $items[] = "<link>${url}</link>";
//            $items[] = "<description>"._MD_XOONIPS_EVENT_ITEM_IS_SHOWN_IN. " : ".htmlspecialchars($indexpath) ."</description>";
            $items[] = "<description>"._MD_XOONIPS_EVENT_ITEM_IS_SHOWN_IN. " : ".xnpHtmlspecialchars($indexpath) ."</description>";
            $items[] = "<dc:date>". $date ."</dc:date>";
            $items[] = "</item>";
        }else if( $e['event_type_id'] == ETID_INSERT_GROUP ){
            $url = XOOPS_URL."/modules/xoonips/groups.php";
            $group = array();
            if( xnp_get_group( $xnpsid, $e['gid'], $group ) != RES_OK ) continue;
            $items[] = "<item rdf:about=\"${url}\">";
//            $items[] = "<title>"._MD_XOONIPS_EVENT_NEW_GROUP. " : ".htmlspecialchars($group['gname'])."</title>";
            $items[] = "<title>"._MD_XOONIPS_EVENT_NEW_GROUP. " : ".xnpHtmlspecialchars($group['gname'])."</title>";
            $items[] = "<link>${url}</link>";
//            $items[] = "<description>".htmlspecialchars($group['gdesc'])."</description>";
            $items[] = "<description>".xnpHtmlspecialchars($group['gdesc'])."</description>";
            $items[] = "<dc:date>". $date ."</dc:date>";
            $items[] = "</item>";
        }else{
            continue;
        }
        $rdfseq[] = "<rdf:li rdf:resource=\"${url}\"/>";
    }

    $rss = array();
    
    $rss[] = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
    $rss[] = "<rdf:RDF ";
    $rss[] = "  xmlns=\"http://purl.org/rss/1.0/\"";
    $rss[] = "  xmlns:dc=\"http://purl.org/dc/elements/1.1/\"";
    $rss[] = "  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" ";
    $rss[] = "  xml:lang=\"ja\">";
    $rss[] = "<channel rdf:about=\"".XOOPS_URL."\">";
    $rss[] = "<title>${xoopsConfig['sitename']}</title>";
    $rss[] = "<link>".XOOPS_URL."</link>";
    $rss[] = "<description>${xoopsConfig['slogan']}</description>";
    $rss[] = "<items>";
    $rss[] = "<rdf:Seq>";
    $rss = array_merge( $rss, $rdfseq );
    $rss[] = "</rdf:Seq>";
    $rss[] = "</items>";
    $rss[] = "</channel>";
    $rss = array_merge( $rss, $items );
    $rss[] = "</rdf:RDF>";
    
/*
    if( function_exists( 'mb_convert_encoding' ) ){
        $xml = mb_convert_encoding(implode( "\n", $rss ), "UTF-8");
    }else{
        $xml = utf8_encode( implode( "\n", $rss ) );
    }
*/
	$xml = implode( "\n", $rss );
	if (xnpChkServerLang()) {
		if ( mb_detect_encoding( $xml ) != 'UTF-8' ){
			$xml = mb_convert_encoding( $xml, 'UTF-8', mb_detect_encoding( $xml ) );
		}
	}
	$xml = xnpEntity2Utf8($xml);

	if( !is_writable( $filename.'/index.xml' ) ) {
		return false;
	}else{
	    $handle = fopen( $filename.'/index.xml', "w" );
    	if( $handle ){
        	fwrite( $handle, $xml );
        	fclose( $handle );
        	return true;
    	}else{
        	return false;
    	}
	}
 }

function xnpGetTopBlock( $moduleName, $displayName, $iconPath, $explanation, $subtypeVarName, $subtypes  ){
	// variables are set to template
	global $xoopsTpl;
	
	$tpl = new xoopsTpl();
	$tpl->assign( $xoopsTpl->get_template_vars() ); // Variables set to $xoopsTpl is copied to $tpl.
	
	$tpl->assign( 'icon', XOOPS_URL . "/modules/$moduleName/" . $iconPath );
	$tpl->assign( 'explanation', $explanation ); //**
	
	$tpl->assign( 'moduleName', $moduleName );
	$tpl->assign( 'displayName', $displayName );
	$tpl->assign( 'formName', $moduleName . "_form" );
	$tpl->assign( 'subtypeVarName', $subtypeVarName );
	
	if ( !empty( $subtypes ) ){
		$searchURLs = array();
		foreach ( $subtypes as $subtypeName => $subtypeDisplayName ){
			$searchURLs[] = array(
				'subtypeDisplayName'=>$subtypeDisplayName,
				'subtypeName' => $subtypeName
			);
		}
		$tpl->assign( 'searchURLs', $searchURLs );
	}
	// Output in HTML.
	return $tpl->fetch( "db:xoonips_top_itemtype_block.html" );
}

function xnpGetModifiedFields( $item_id )
{
	$myts =& MyTextSanitizer::getInstance( );
	$xnpsid = $_SESSION['XNPSID'];

	$ret = array();
	$item = array();
	if( xnp_get_item( $xnpsid, $item_id, $item ) == RES_OK ){
        foreach( array( 'contributor' => _MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL,
                        'description' => _MD_XOONIPS_ITEM_DESCRIPTION_LABEL,
                        'doi' => _MD_XOONIPS_ITEM_DOI_LABEL,
                        'last_update_date' => _MD_XOONIPS_ITEM_LAST_UPDATE_DATE_LABEL,
                        'creation_date' => _MD_XOONIPS_ITEM_CREATION_DATE_LABEL,
                        'item_type' => _MD_XOONIPS_ITEM_ITEM_TYPE_LABEL,
                        'change_logs' => _MD_XOONIPS_ITEM_CHANGELOGS_LABEL,
                        'lang' => _MD_XOONIPS_ITEM_LANG_LABEL ) as $k => $v ){
            if( !array_key_exists( $k, $item )
                || !array_key_exists( $k, $_POST ) ) continue;
            if( str_replace( "\r\n", "\r", $item[ $k ] ) != str_replace( "\r\n", "\r", $myts->stripSlashesGPC( urldecode($_POST[ $k ] ) ) ) ) array_push( $ret, $v );
        }
    }
    
	//has been title modified ?
    $titles = array();
    foreach( preg_split( "/[\r\n]+/", $myts->stripSlashesGPC( $_POST['title'] ) ) as $title ){
        if( trim( $title ) != '' ) $titles[] = $title;
    }
    $diff = array_diff( $titles, $item['titles'] );
    if( !empty( $diff ) ){//modified
        array_push( $ret, _MD_XOONIPS_ITEM_TITLE_LABEL );
    }

	//has been keyword modified ?
    $keywords = !empty($_POST['keywords']) ? explode( ",", $myts->stripSlashesGPC( $_POST['keywords'] ) ) : array();
    $diff = array_diff( $keywords, $item['keywords'] );
    if( count( $keywords ) != count( $item['keywords'] ) || !empty( $diff ) ){//modified
        array_push( $ret, _MD_XOONIPS_ITEM_KEYWORDS_LABEL );
    }

    //is indexes modified ?
    if( isset( $_POST['xoonipsCheckedXID'] ) ){
        $new_index = explode( ',', $_POST['xoonipsCheckedXID'] );
        $old_index = array();
        $res = xnp_get_index_id_by_item_id( $xnpsid, $item['item_id'], $old_index );
        if( $res == RES_OK ){
            if( count( array_diff( $old_index, $new_index ) ) > 0
                || count( array_diff( $new_index, $old_index ) ) > 0 ){
                array_push( $ret, _MD_XOONIPS_ITEM_INDEX_LABEL ); // if you change this label, don't forget to modify xnpUpdateBasicInformation() 
            }
        }
    }
    
	//is related to modified ?
	$new_related_to = 
		(!isset( $_POST['related_to_check']) || $_POST['related_to_check'] === "" ) ? array() :
		(is_string($_POST['related_to_check']) ? preg_split( "/[\r\n]+/", $_POST['related_to_check'] ) : 
		$_POST['related_to_check']);
	$related_to = ( isset( $_POST['related_to'] ) ? $_POST['related_to'] : "" );
	foreach( preg_split( "/[\r\n]+/", $related_to ) as $id ){
        $tmp_item = array();
        if( xnp_get_item( $xnpsid, (int)$id, $tmp_item ) != RES_OK ){
            continue;
        }
        $new_related_to[] = $id;
    }
	$old_related_to = array();
	$res = xnp_get_related_to( $xnpsid, $item['item_id'], $old_related_to );
	
	if( $res == RES_OK ){
		if( count( array_diff( $old_related_to, $new_related_to ) ) > 0
			|| count( array_diff( $new_related_to, $old_related_to ) ) > 0 ){
			array_push( $ret, _MD_XOONIPS_ITEM_RELATED_TO_LABEL );
		}
	}

	// get file_id of preview file before change
    $tmp = xnpGetFileInfo( "t_file.file_id", "t_file_type.name='preview' and sess_id is NULL ", $item_id );
    $old_files = array();
    foreach( $tmp as $i ) $old_files[] = $i[0];
    $new_files = array();
    if( isset( $_POST['previewFileID'] ) && $_POST['previewFileID'] != '' ) $new_files = explode( ',', $_POST['previewFileID'] );
    if( count( array_diff( $old_files, $new_files ) ) > 0
        || count( array_diff( $new_files, $old_files ) ) > 0 ){
        //preview is modified
        array_push( $ret, _MD_XOONIPS_ITEM_PREVIEW_LABEL );
    }
    return $ret;
}

function xnpIsAttachmentModified( $file_type, $item_id )
{
    //return true if uploaded successfully
    if( isset( $_FILES[$file_type] ) && $_FILES[$file_type]['error'] == 0 ) return true;
    
	// get file_id of preview file before change
    $tmp = xnpGetFileInfo( "t_file.file_id", "t_file_type.name='${file_type}' and sess_id is NULL ", $item_id );
    $old_files = array();
    $new_files = array();
    foreach( $tmp as $i ) $old_files[] = $i[0];
    if( isset( $_POST["${file_type}FileID"] ) && $_POST["${file_type}FileID"] != '' )
        $new_files = explode( ',', $_POST["${file_type}FileID"] );
    return count( array_diff( $old_files, $new_files ) ) > 0
        || count( array_diff( $new_files, $old_files ) ) > 0;
}

function xnpGetBasicInformationMetadata( $metadataPrefix, $item_id )
{
	$basic = array();
	xnp_get_item( $_SESSION['XNPSID'], $item_id, $basic );

	$tmparray = array();
	if( xnp_get_item_types( $tmparray ) == RES_OK ){
		foreach( $tmparray as $i ){
			if( $i['item_type_id'] == $basic['item_type_id'] ){
				$itemtype = $i;
				break;
			}
		}
	}
	$nijc_code = '';
	xnp_get_config_value( 'repository_nijc_code', $nijc_code );
	$identifier = $nijc_code . '/' . $basic['item_type_id'] . '.' . $basic['item_id'];
	if( $metadataPrefix == 'junii' || $metadataPrefix == 'junii2' ){
		$lines = array();
		
		xnp_get_config_value( 'repository_publisher', $publisher );
		xnp_get_config_value( 'repository_institution', $institution );
		// get config in XooNIps
		if( !isset( $xoopsConfigMetaFooter ) ){
			$config_handler =& xoops_gethandler('config');
			$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
			$xoopsConfigMetaFooter =& $config_handler->getConfigsByCat(XOOPS_CONF_METAFOOTER);
		}
		$meta_author = $xoopsConfigMetaFooter['meta_author'];
		
		if( strcasecmp( $publisher, 'meta_author' ) == 0){
			$publisher = $meta_author;
		}else if( strcasecmp( $publisher, 'creator' )== 0){
			$publisher = _MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL;
		}else if( strcasecmp( $publisher, 'none' ) == 0){
			$publisher = null;
		}
		if( strcasecmp( $institution, 'meta_author' ) == 0){
			$institution = $meta_author;
		}else if( strcasecmp( $institution, 'creator' ) == 0){
			$institution = _MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL;
		}else if( strcasecmp( $institution, 'none' ) == 0){
			$institution = null;
		}
		
		$lines[] = "<title>".xnpHtmlspecialchars( reset( $basic['titles'] ) )."</title>";
		while( next($basic['titles'] ) ){
			$lines[] = "<title>".xnpHtmlspecialchars( current( $basic['titles'] ) )."</title>";
//			$lines[] = "<title.Alternative>".xnpHtmlspecialchars( current( $basic['titles'] ) )."</title.Alternative>";
		}
		$lines[] = "<identifier>".xnpHtmlspecialchars( $identifier )."</identifier>";
		$lines[] = "<identifier xsi:type=\"URL\">".XOOPS_URL."/modules/xoonips/detail.php?item_id=".xnpHtmlspecialchars($basic['item_id'])."</identifier>";
		$lines[] = "<type>itemType:".xnpHtmlspecialchars($itemtype['name'])."</type>";
		$lines[] = "<language xsi:type=\"ISO639-2\">".xnpHtmlspecialchars($basic['lang'])."</language>";
		if( $institution != null ) $lines[] = "<institution>".xnpHtmlspecialchars($institution)."</institution>";
		if( $publisher != null ) $lines[] = "<publisher>".xnpHtmlspecialchars($publisher)."</publisher>";
		
		$subject = array();
		$index_ids = array();
		$res = xnp_get_index_id_by_item_id( $_SESSION['XNPSID'], $item_id, $index_ids );
		if( $res == RES_OK ){
			foreach( $index_ids as $xid ){
				if( $xid > 0 ){
					$index = array();
					$result = xnp_get_index( $_SESSION['XNPSID'], $xid, $index );
					if ( $result == 0 ){
						$str = xnpGetIndexPathServerString( $_SESSION['XNPSID'], $xid );
						$subject[]="$str";
					}
				}
			}
		}
		if( !empty( $basic['keywords'] ) ) $subject = array_merge( $subject, $basic['keywords'] );
		$lines[] = "<subject>".xnpHtmlspecialchars(implode( ', ', $subject ))."</subject>";
		$lines[] = "<description>comment:".xnpHtmlspecialchars($basic['description'])."</description>";
		
		return implode( "\n", $lines );
	}
	else if ( $metadataPrefix =='oai_dc'){
		/* title, identifier, type, language, subject, description */
		$lines = array();
		
		xnp_get_config_value( 'repository_publisher', $publisher );
		// get config in XooNIps
		if( !isset( $xoopsConfigMetaFooter ) ){
			$config_handler =& xoops_gethandler('config');
			$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
			$xoopsConfigMetaFooter =& $config_handler->getConfigsByCat(XOOPS_CONF_METAFOOTER);
		}
		 $meta_author = $xoopsConfigMetaFooter['meta_author'];
		
		if( strcasecmp( $publisher, 'meta_author' ) == 0){
			$publisher = $meta_author;
		}else if( strcasecmp( $publisher, 'creator' )== 0){
			$publisher = _MD_XOONIPS_ITEM_CONTRIBUTOR_LABEL;
		}else if( strcasecmp( $publisher, 'none' ) == 0){
			$publisher = null;
		}
		
		$lines[] = "<dc:title>".xnpHtmlspecialchars($basic['title'])."</dc:title>";
		$lines[] = "<dc:identifier>".xnpHtmlspecialchars($identifier)."</dc:identifier>";
		$lines[] = "<dc:identifier>".XOOPS_URL."/modules/xoonips/detail.php?item_id=".xnpHtmlspecialchars($basic['item_id'])."</dc:identifier>";
		$lines[] = "<dc:type>itemType:".xnpHtmlspecialchars($itemtype['name'])."</dc:type>";
		$lines[] = "<dc:language>".xnpHtmlspecialchars($basic['lang'])."</dc:language>";
		if( $publisher != null ) $lines[] = "<dc:publisher>".xnpHtmlspecialchars($publisher)."</dc:publisher>";
		
		$subject = array();
		$index_ids = array();
		$res = xnp_get_index_id_by_item_id( $_SESSION['XNPSID'], $item_id, $index_ids );
		if( $res == RES_OK ){
			foreach( $index_ids as $xid ){
				if( $xid > 0 ){
					$index = array();
					$result = xnp_get_index( $_SESSION['XNPSID'], $xid, $index );
					if ( $result == 0 ){
						$str = xnpGetIndexPathServerString( $_SESSION['XNPSID'], $xid );
						$subject[]="$str";
					}
				}
			}
		}
		if( !empty( $basic['keywords'] ) ) $subject = array_merge( $subject,  $basic['keywords'] );
		foreach ( $subject as $str )
			$lines[] = "<dc:subject>".xnpHtmlspecialchars($str)."</dc:subject>";
		$lines[] = "<dc:description>comment:".xnpHtmlspecialchars($basic['description'])."</dc:description>";
		
		return implode( "\n", $lines )."\n";
	}
	return false;
}

/** get Rights in detail page
 * @param item_id item_id
 * @param text Rights text or html
 */
function xnpGetRightsDetailBlock( $item_id, $use_cc=1, $text='', $cc_commercial_use=1, $cc_modification=2 )
{
	$myts =& MyTextSanitizer::getInstance();
	
	$hidden = 
	  xnpCreateHidden( 'rightsUseCC'           , $use_cc            ).
	  xnpCreateHidden( 'rightsEncText'         , $text              ).
	  xnpCreateHidden( 'rightsCCCommercialUse' , $cc_commercial_use ).
	  xnpCreateHidden( 'rightsCCModification'  , $cc_modification   );
	
	if ( $use_cc )
		return
			array( 
				'name'=>_MD_XOONIPS_ITEM_TEXTFILE_LABEL, 
				'value'=> "$text",
				'hidden'=> $hidden );
	else
		return
			array( 
				'name'=>_MD_XOONIPS_ITEM_TEXTFILE_LABEL, 
				'value'=> "<textarea readonly rows='5' cols='40'>".xnpHtmlspecialchars($text)."</textarea>",
				'hidden'=>$hidden );
}
// input(POST): rightsEncText, rightsUseCC, rightsCCCommercialUse, rightsCCModification
// output(POST): rightsEncText, rightsUseCC, rightsCCCommercialUse, rightsCCModification
function xnpGetRightsEditBlock( $item_id, $use_cc=1, $text='', $cc_commercial_use=1, $cc_modification=2 ){
	$myts =& MyTextSanitizer::getInstance();
	// select, text, fileInfo
	$item_id = (int)$item_id;
	
	if ( isset( $_POST['rightsUseCC'] ) ){ // There is initial value specification by POST.
		$text = $myts->stripSlashesGPC($_POST['rightsEncText']);
		$use_cc = (int)$_POST['rightsUseCC'];
		$cc_commercial_use = (int)$_POST['rightsCCCommercialUse'];
		$cc_modification = (int)$_POST['rightsCCModification'];
	}
	else { // There is no initial value specification by POST. use the value of Argument.
	}
	
	$check_cc  = array( '', '' );     $check_cc [$use_cc]            = "checked='checked'";
	$check_com = array( '', '' );     $check_com[$cc_commercial_use] = "checked='checked'";
	$check_mod = array( '', '', '' ); $check_mod[$cc_modification]  = "checked='checked'";
	
	if ( $use_cc ){
		$encText = '';
		$htmlShowText = "&nbsp;"; // div.firstChild is prevented being set to null.
	}
	else {
		$encText = xnpHtmlspecialchars($text);
		$htmlShowText = nl2br(xnpHtmlspecialchars(xnpHeadText( $text )));
		if ( $htmlShowText == "" ){
			$htmlShowText = "&nbsp;"; // div.firstChild is prevented being set to null.
		}
	}
	$html = "
		<table>
		 <tr>
		  <td><input type='radio' name='rightsUseCC' value='1' {$check_cc[1]} /></td>
		  <td>"._MD_XOONIPS_RIGHTS_SOME_RIGHTS_RESERVED."</td>
		 </tr>
		 <tr>
		  <td></td>
		  <td>
			<ul>
			<li>"._MD_XOONIPS_RIGHTS_ALLOW_COMMERCIAL_USE."<br />
				<div style='padding-left: 20px;'>
				<input type='radio' name='rightsCCCommercialUse' value='1' {$check_com[1]} />"._YES."<br />
				<input type='radio' name='rightsCCCommercialUse' value='0' {$check_com[0]} />"._NO."<br />
				</div>
			<li>"._MD_XOONIPS_RIGHTS_ALLOW_MODIFICATIONS."<br />
				<div style='padding-left: 20px;'>
				<input type='radio' name='rightsCCModification' value='2' {$check_mod[2]} />"._YES."<br />
				<input type='radio' name='rightsCCModification' value='1' {$check_mod[1]} />"._MD_XOONIPS_RIGHTS_YES_SA."<br />
				<input type='radio' name='rightsCCModification' value='0' {$check_mod[0]} />"._NO."<br />
				</div>
			</ul>
		  </td>
		 </tr>
		 <tr>
		  <td><input type='radio' name='rightsUseCC' value='0' {$check_cc[0]} /></td>
		  <td>"._MD_XOONIPS_RIGHTS_ALL_RIGHTS_RESERVED."</td>
		 </tr>
		 <tr>
		  <td></td>
		  <td>
				<div id='rightsShowText' style='width: 100%;'>$htmlShowText</div>
				<div style='vertical-align: text-bottom; text-align:right'>
				 <a href='#' onclick=\"return xnpOpenTextFileInputWindow('rights',$item_id)\">" . _MD_XOONIPS_ITEM_TEXT_FILE_EDIT_LABEL . "</a>
				</div>
				<input type='hidden' name='rightsEncText' value='$encText'  id='rightsEncText' />
		  </td>
		 </tr>
		</table>
	";
	
	return array( 'name'=>_MD_XOONIPS_ITEM_ATTACHMENT_LABEL, 'value'=>$html );

}
function xnpGetRightsPrinterFriendlyBlock( $item_id, $use_cc, $text ){
	$myts =& MyTextSanitizer::getInstance();
	
	if ( $use_cc )
		return
			array( 
				'name'=>_MD_XOONIPS_ITEM_TEXTFILE_LABEL, 
				'value'=> "$text" );
	else
		return
			array( 
				'name'=>_MD_XOONIPS_ITEM_TEXTFILE_LABEL, 
				'value'=> nl2br(xnpHtmlspecialchars($text)) );
}

$xnp_cc_licenses = array(
    "12"=>'<!--Creative Commons License--><table><tr><td><a rel="license" href="http://creativecommons.org/licenses/by/2.5/"><img alt="Creative Commons License" border="0" src="http://creativecommons.org/images/public/somerights20.png"/></a><br/>\n'
    .'</td><td>This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by/2.5/">Creative Commons Attribution 2.5 License</a>.\n'
    .'</td></tr></table><!--/Creative Commons License--><!-- <rdf:RDF xmlns="http://web.resource.org/cc/" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">\n'
    .'<Work rdf:about="">\n'
    .'<license rdf:resource="http://creativecommons.org/licenses/by/2.5/" />\n'
    .'</Work>\n'
    .'<License rdf:about="http://creativecommons.org/licenses/by/2.5/"><permits rdf:resource="http://web.resource.org/cc/Reproduction"/><permits rdf:resource="http://web.resource.org/cc/Distribution"/><requires rdf:resource="http://web.resource.org/cc/Notice"/><requires rdf:resource="http://web.resource.org/cc/Attribution"/><permits rdf:resource="http://web.resource.org/cc/DerivativeWorks"/></License></rdf:RDF> -->
',
    "11"=>'<!--Creative Commons License--><table><tr><td><a rel="license" href="http://creativecommons.org/licenses/by-sa/2.5/"><img alt="Creative Commons License" border="0" src="http://creativecommons.org/images/public/somerights20.png"/></a><br/>\n'
    .'</td><td>This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-sa/2.5/">Creative Commons Attribution-ShareAlike 2.5 License</a>.\n'
    .'</td></tr></table><!--/Creative Commons License--><!-- <rdf:RDF xmlns="http://web.resource.org/cc/" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">\n'
    .'<Work rdf:about="">\n'
    .'<license rdf:resource="http://creativecommons.org/licenses/by-sa/2.5/" />\n'
    .'</Work>\n'
    .'<License rdf:about="http://creativecommons.org/licenses/by-sa/2.5/"><permits rdf:resource="http://web.resource.org/cc/Reproduction"/><permits rdf:resource="http://web.resource.org/cc/Distribution"/><requires rdf:resource="http://web.resource.org/cc/Notice"/><requires rdf:resource="http://web.resource.org/cc/Attribution"/><permits rdf:resource="http://web.resource.org/cc/DerivativeWorks"/><requires rdf:resource="http://web.resource.org/cc/ShareAlike"/></License></rdf:RDF> -->',
    "10"=>'<!--Creative Commons License--><table><tr><td><a rel="license" href="http://creativecommons.org/licenses/by-nd/2.5/"><img alt="Creative Commons License" border="0" src="http://creativecommons.org/images/public/somerights20.png"/></a><br/>\n'
    .'</td><td>This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nd/2.5/">Creative Commons Attribution-NoDerivs 2.5 License</a>.\n'
    .'</td></tr></table><!--/Creative Commons License--><!-- <rdf:RDF xmlns="http://web.resource.org/cc/" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">\n'
    .'<Work rdf:about="">\n'
    .'<license rdf:resource="http://creativecommons.org/licenses/by-nd/2.5/" />\n'
    .'</Work>\n'
    .'<License rdf:about="http://creativecommons.org/licenses/by-nd/2.5/"><permits rdf:resource="http://web.resource.org/cc/Reproduction"/><permits rdf:resource="http://web.resource.org/cc/Distribution"/><requires rdf:resource="http://web.resource.org/cc/Notice"/><requires rdf:resource="http://web.resource.org/cc/Attribution"/></License></rdf:RDF> -->',
    "02"=>'<!--Creative Commons License--><table><tr><td><a rel="license" href="http://creativecommons.org/licenses/by-nc/2.5/"><img alt="Creative Commons License" border="0" src="http://creativecommons.org/images/public/somerights20.png"/></a><br/>\n'
    .'</td><td>This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nc/2.5/">Creative Commons Attribution-NonCommercial 2.5 License</a>.\n'
    .'</td></tr></table><!--/Creative Commons License--><!-- <rdf:RDF xmlns="http://web.resource.org/cc/" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">\n'
    .'<Work rdf:about="">\n'
    .'<license rdf:resource="http://creativecommons.org/licenses/by-nc/2.5/" />\n'
    .'</Work>\n'
    .'<License rdf:about="http://creativecommons.org/licenses/by-nc/2.5/"><permits rdf:resource="http://web.resource.org/cc/Reproduction"/><permits rdf:resource="http://web.resource.org/cc/Distribution"/><requires rdf:resource="http://web.resource.org/cc/Notice"/><requires rdf:resource="http://web.resource.org/cc/Attribution"/><prohibits rdf:resource="http://web.resource.org/cc/CommercialUse"/><permits rdf:resource="http://web.resource.org/cc/DerivativeWorks"/></License></rdf:RDF> -->',
    "01"=>'<!--Creative Commons License--><table><tr><td><a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/2.5/"><img alt="Creative Commons License" border="0" src="http://creativecommons.org/images/public/somerights20.png"/></a><br/>\n'
    .'</td><td>This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/2.5/">Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License</a>.\n'
    .'</td></tr></table><!--/Creative Commons License--><!-- <rdf:RDF xmlns="http://web.resource.org/cc/" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">\n'
    .'<Work rdf:about="">\n'
    .'<license rdf:resource="http://creativecommons.org/licenses/by-nc-sa/2.5/" />\n'
    .'</Work>\n'
    .'<License rdf:about="http://creativecommons.org/licenses/by-nc-sa/2.5/"><permits rdf:resource="http://web.resource.org/cc/Reproduction"/><permits rdf:resource="http://web.resource.org/cc/Distribution"/><requires rdf:resource="http://web.resource.org/cc/Notice"/><requires rdf:resource="http://web.resource.org/cc/Attribution"/><prohibits rdf:resource="http://web.resource.org/cc/CommercialUse"/><permits rdf:resource="http://web.resource.org/cc/DerivativeWorks"/><requires rdf:resource="http://web.resource.org/cc/ShareAlike"/></License></rdf:RDF> -->',
    "00"=>'<!--Creative Commons License--><table><tr><td><a rel="license" href="http://creativecommons.org/licenses/by-nc-nd/2.5/"><img alt="Creative Commons License" border="0" src="http://creativecommons.org/images/public/somerights20.png"/></a><br/>\n'
    .'</td><td>This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nc-nd/2.5/">Creative Commons Attribution-NonCommercial-NoDerivs 2.5 License</a>.\n'
    .'</td></tr></table><!--/Creative Commons License--><!-- <rdf:RDF xmlns="http://web.resource.org/cc/" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">\n'
    .'<Work rdf:about="">\n'
    .'<license rdf:resource="http://creativecommons.org/licenses/by-nc-nd/2.5/" />\n'
    .'</Work>\n'
    .'<License rdf:about="http://creativecommons.org/licenses/by-nc-nd/2.5/"><permits rdf:resource="http://web.resource.org/cc/Reproduction"/><permits rdf:resource="http://web.resource.org/cc/Distribution"/><requires rdf:resource="http://web.resource.org/cc/Notice"/><requires rdf:resource="http://web.resource.org/cc/Attribution"/><prohibits rdf:resource="http://web.resource.org/cc/CommercialUse"/></License></rdf:RDF> -->'
    );

// input(POST):  rightsEncText, rightsUserCC, rightsCCCommercialUse, rightsCCModification
// output: rightsEncText
function xnpGetRightsConfirmBlock( $item_id, $maxlen=65535 )
{
	$myts =& MyTextSanitizer::getInstance();
	
	if ( (int)$_POST['rightsUseCC'] == 1 ){
		global $xnp_cc_licenses;
		$htmlText = $xnp_cc_licenses[ $_POST['rightsCCCommercialUse'] . $_POST['rightsCCModification'] ];
		$within = $htmlText;
		$without = "";
	}
	else {
		$text = $myts->stripSlashesGPC($_POST['rightsEncText']);
		list( $within, $without ) = xnpTrimString( $text, $maxlen, _CHARSET );
		$htmlText = nl2br( xnpWithinWithoutHtml( $within, $without ) );
	}
	
	if (( substr_count( $_SERVER["HTTP_USER_AGENT"], "Mac" ) > 0 ) && ( substr_count( $_SERVER["HTTP_USER_AGENT"], "Safari" ) > 0 )) {
		$html = $htmlText . "
			<input type='hidden' name='rightsEncText' value='".htmlspecialchars($within.$without)."' />
			<input type='hidden' name='rightsUseCC'           value='" . ((int)$_POST['rightsUseCC']) . "' />
			<input type='hidden' name='rightsCCCommercialUse' value='" . ((int)$_POST['rightsCCCommercialUse']) . "' />
			<input type='hidden' name='rightsCCModification' value='" . ((int)$_POST['rightsCCModification']) . "' />
			";
	}
	else {
		$html = $htmlText . "
			<input type='hidden' name='rightsEncText' value='".xnpHtmlspecialchars($within.$without)."' />
			<input type='hidden' name='rightsUseCC'           value='" . ((int)$_POST['rightsUseCC']) . "' />
			<input type='hidden' name='rightsCCCommercialUse' value='" . ((int)$_POST['rightsCCCommercialUse']) . "' />
			<input type='hidden' name='rightsCCModification' value='" . ((int)$_POST['rightsCCModification']) . "' />
			";
	}
	return array( 'name'=>_MD_XOONIPS_ITEM_TEXTFILE_LABEL, 'value'=> $html, 'within'=>$within, 'without'=>$without );
}

function xnpGetRightsRegisterBlock()
{
	return xnpGetRightsEditBlock( false );
}

/** function of getting rights contents on the following page of confirm.
 * @return contents empty character strings in error.
 */
function xnpGetRights(  ){
	$myts =& MyTextSanitizer::getInstance();
	return array( $myts->stripSlashesGPC($_POST['rightsEncText']), (int)$_POST['rightsUseCC'],
		(int)$_POST['rightsCCCommercialUse'], (int)$_POST['rightsCCModification'] );
}

/**
 * check rights to access to item_id. to control displaying PDF Reprint and Abstract.
 * @return OL_PRIVATE    accessible by way of private index
 * @return OL_GROUP_ONLY accessible by way of group index
 * @return OL_PUBLIC     accessible by way of public index
 * @reutrn false         can't access or error
 */
function xnpGetAccessRights( $item_id )
{
	$xnpsid = $_SESSION['XNPSID'];
	$xids = array();
	$result = xnp_get_index_id_by_item_id( $xnpsid, $item_id, $xids );
	if ( $result != RES_OK )
		return false;
	
	$len = count( $xids );
	$indexes = array();
	$open_levels = array();
	for ( $i = 0; $i < $len; $i++ ){
		$xid = $xids[$i];
		$index = array();
		$result = xnp_get_index( $xnpsid, $xid, $index );
		if ( $result == RES_OK ){
			$open_levels[$index['open_level']] = true;
		}
	}
	
	if ( isset( $open_levels[OL_PRIVATE   ] ) ) return OL_PRIVATE   ;
	if ( isset( $open_levels[OL_GROUP_ONLY] ) ) return OL_GROUP_ONLY;
	if ( isset( $open_levels[OL_PUBLIC    ] ) ) return OL_PUBLIC    ;
	return false;
}

function xoonips_error( $message )
{
    error_log( $message, 0 );
}

function xnpEncodeMacSafariPost() {
	$target = $_POST;
	$_POST = xnpEncodeMacSafariPost2($target);
}

function xnpEncodeMacSafariPost2($target) {
	foreach ($target as $key => $value) {
		if( is_array( $value ) ){
			$value = xnpEncodeMacSafariPost2($value);
			$target[$key] = $value;
		}else{
			$target[$key] = encodeMacSafari2Server($value);
		}
	}
	return $target;
}

function xnpEncodeMacSafariGet() {
	$target = $_GET;
	$_GET = xnpEncodeMacSafariGet2($target);
}

function xnpEncodeMacSafariGet2($target) {
	foreach ($target as $key => $value) {
		if( is_array( $value ) ){
			$value = xnpEncodeMacSafariGet2($value);
			$target[$key] = $value;
		}else{
			$target[$key] = encodeMacSafari2Server($value);
		}
	}
	return $target;
}

function xnpEncodeMacSafariFiles( $name ) {
	$value = $_FILES[$name]['name'];
	$_FILES[$name]['name'] = encodeMacSafari2Server($value);
}
function xnpGetMacSafariAcceptCharset() {
	if (( substr_count( $_SERVER["HTTP_USER_AGENT"], "Mac" ) > 0 ) && ( substr_count( $_SERVER["HTTP_USER_AGENT"], "Safari" ) > 0 )) {
		$accept_charset = ' accept-charset="UTF-8"';
	}
	else {
		$accept_charset = '';
	}
	return $accept_charset;
}

// utf8Ƭ1ХȤ顢1ʸΥХȿ
function xnpUtf8Bytes( $c1 ){
	if( ( $c1 & 0x80 ) == 0 ) return 1;
	if( ( $c1 & 0xe0 ) == 0xc0 ) return 2;
	if( ( $c1 & 0xf0 ) == 0xe0 ) return 3;
	if( ( $c1 & 0xf8 ) == 0xf0 ) return 4;
	return 1; // multibyteʸ0xnpWindowString̵¥롼פ˴٤Τ1byteȤ롣
}


/** eucmultibyteʸwindow򤫤bin2hex()롣
  window˽Ťʤʬʸ < window_size && window˽Ťʤʤʬʸ > 0 ʤ ΤȤbin2hex()leadingtrailing
  
  : window_size=3Ȥ
                  +-leading-+---------middle---------+-trailing-+
                     
                                          
  
  output_leading: leadingϤʤtrue
  output_trailing: trailingϤʤtrue
 */
function xnpWindowString( $str, $output_leading, $output_trailing ){
	$end = strlen($str);
	
	$w0 = 0; // windowκü
	$w1 = 0; // windowαü
	$words = array();
	
	// leading
	for ( $j = 0; $j < XOONIPS_WINDOW_SIZE; $j++ ){
		if ( $output_leading && $w1 )
			$words[] = bin2hex( substr( $str, $w0, $w1-$w0 ) );
		$w1 += 2;
		if ( $w1 >=$end )
			break;
	}
	
	// middle
	while ( true ){
		$words[] = bin2hex( substr( $str, $w0, $w1-$w0 ) );
		
		if ( $w1 >= $end )
			break;
		
		$w0 += 2;
		if ( $w1 < $end ){
			$w1 += 2;
			if ( $w1 >= $end )
				$w1 = $end;
		}
	}
	
	
	// trailing
	if ( $output_trailing ){
		while ( true ){
			$w0 += 2;
			if ( $w0 >= $end )
				break;
			$words[] = bin2hex( substr( $str, $w0, $w1-$w0 ) );
		}
	}
	
	return $words;
}

class XoonipsWordSeparator {
	var $in_buf = '';
	var $output_leading = true;
	var $source;
	function XoonipsWordSeparator(){
	}
	
	var $multibyte_mode; // 0:singlebyte, 1:multibyte
	var $errorMessage;
	/*
	  sb-sb, sb-mb, mb-sb δ֤ϤĤǤڤäƤΤ, mb-mb δ֤Ͼݡ
	
	   window-size=3, leading/trailing 
	
	in: s s m m m m m m|
	                   v     // step1: ϥХåե褿(ޤEOFˤãƤʤ)Ȥ롥
	             v           // step2: window_sizeʸ᤹
	out:s s 
	        m 
	        m-m
	        m-m-m            // step3: output_leading=true, output_trailing=falseǽ

             v               // step4: (window_size-1)ʸ᤹
	in:       m m m m m m s  // step5: ϥХåե˼Υ֥åɤ߹
	                         // step6: Ĥ outpu_leading=false, mb_mode=1 Ȥƽ
	out:      m-m-m
	            m-m-m
	              m-m-m
	                m-m-m
	                  m-m
	                    m
	                      s
	
	
	step1: (window_size*2-1);͵̵ʤ顤Ȥꤢsb-mbޤꡤϥХåե˼Υ֥åɤ߹ߡsb_modeѹ
	in: s s m m m m m m|
	out:s s
	       v
    in:     m m m m m m m s
	*/
	
	function fetch(){
		$is_eof = false;
		$words = array(); // 
		set_time_limit( 300 );
		
		// in_buf64KB餤ɤ߹.  UTF8->_CHARSETѴ롥
		$ar = array();
		$len = strlen($this->in_buf);
		if ( $len )
			$ar[] = $this->in_buf;
		while ( $len < 60000 ){
			list( $tmp, $this->errorMessage ) = $this->source->fetch();
			if ( $tmp === false ){
				$is_eof = true;
				if ( count($ar) == 0 )
					return array( false, false );
				break;
			}
			$ar[] = $tmp;
			$len += strlen($tmp);
		}
		$this->in_buf = $this->in_buf . encodeMeta2Server( str_replace( array( "\n", "\r", "\t" ), " ", implode( '', $ar ) ) );
		
		// ѸĶȡwindow.  utf8 -> latin1 Ѵɬפ
		if ( _CHARSET == 'iso-8859-1' ){
			$str = xnpUtf82Entity( $this->in_buf );
			$str = encodeNumeric2Latin1( $str );
			$this->in_buf = '';
			return array( $str, false );
		}
		
		$len = strlen($this->in_buf);
		if ( $len == 0 )
			return array( false, $this->errorMessage );
		
		if ( $this->multibyte_mode != ( ord($this->in_buf{0}) >= 0x80 ) )
			$words[] = ''; // fetch()Ⱥfetch()Ƭmb/sbۤʤʤ顤1롥
		
		$end = strlen($this->in_buf);
		$w0 = $w1 = 0;
		$this->multibyte_mode = ( ord($this->in_buf{0}) >= 0x80 );
		
		while ( $w1 < $end ){
			if ( $this->multibyte_mode ){
				while ( $w1 < $end && ord($this->in_buf{$w1}) >= 0x80 ){ // Ϣ³multibyte
					$w1++;
				}
				if ( $w1 == $end ){
					if ( $is_eof ){
						$ar = xnpWindowString( substr( $this->in_buf, $w0, $w1-$w0 ), $w0 != 0 || $this->output_leading, false );
						break;
					}
					else if ( $w1-$w0 > XOONIPS_WINDOW_SIZE*2*2 ){ // window_size*2ʸEUCޤ
						//  w1  window_sizeʸ᤹
						$w1 -= XOONIPS_WINDOW_SIZE*2;
						$ar = xnpWindowString( substr( $this->in_buf, $w0, $w1-$w0 ), $w0 != 0 || $this->output_leading, false );
						$this->output_leading = false;
						break;
					}
					else {
						$w1 = $w0;
						break;
					}
				}
				else {
					$ar = xnpWindowString( substr( $this->in_buf, $w0, $w1-$w0 ), $w0 != 0 || $this->output_leading, true );
					$this->multibyte_mode = false;
					$output_leading = true;
				}
			}
			else {
				while ( $w1 < $end && ord($this->in_buf{$w1}) < 0x80 ) // Ϣ³singlebyte
					$w1++;
				$ar = explode( ' ', substr( $this->in_buf, $w0, $w1-$w0 ) );
				if ( $w1 != $end )
					$this->multibyte_mode = true;
			}
			
			
			$ct = count($ar); // $ar$wordsɲáarray_merge٤Τǡ
			for ( $j = 0; $j < $ct; $j++ )
				$words[] = $ar[$j];
			
			$w0 = $w1;
		}
		$this->in_buf = substr( $this->in_buf, $w1 );
		$ret = implode( ' ', $words );
		return array( $ret, false );
	}
	
	
};


/**
 * Ѥʸʬ䤹롥
 * ޥХʸˤĹXOONIPS_WINDOW_SIZEʸΥɥŬѤ롥
 * 1ХʸѴʤ
 * output_leading: strƬmultibyte-wordξˤleadingϤ
 * output_trailing: strmultibyte-wordξˤtrailingϤ
 * ޤ˸ä
 *   search_text   output_leading = true, output_trailing = true 
 *                        եξϤϤxnpWordSeparationϻѤʤ class XoonipsWordSeparator Ѥ
 *   (ʬ)    output_leading = false, output_trailing = false 
 */
function xnpWordSeparation( $str, $output_leading=true, $output_trailing=true ){
	$words = array();
	$w0 = 0; // wordκü
	$w1 = 0; // wordαü
	$end = strlen($str);
	
	$mb_env = xnpChkServerLang();
	$multibyte_mode = ( ord($str{0}) >= 0x80 && $mb_env );
	
	while ( $w1 < $end ){
		if ( $multibyte_mode ){
			while ( $w1 < $end && ord($str{$w1}) >= 0x80 && $mb_env ) // Ϣ³multibyte
				$w1++;
			$ar = xnpWindowString( substr( $str, $w0, $w1-$w0 ), 
			  $w0 != 0 || $output_leading, 
			  $w1 != $end || $output_trailing );
		}
		else {
			while ( $w1 < $end && ( ord($str{$w1}) < 0x80 || !$mb_env ) ) // Ϣ³singlebyte
				$w1++;
			$ar = explode( ' ', substr( $str, $w0, $w1-$w0 ) );
		}
		
		$ct = count($ar); // $ar$wordsɲáarray_merge٤Τǡ
		for ( $j = 0; $j < $ct; $j++ )
			$words[] = $ar[$j];
		
		$w0 = $w1;
		$multibyte_mode = !$multibyte_mode;
	}
	return $words;
}


function xnpCompareModule( $a, $b ){
	return $b['byte_pattern_length'] - $a['byte_pattern_length'];
}

/** file search module ΰ롥 
 * @return $modules: $modulebyte_patternĹΤ¤Ǥ. */
function xnpGetFileSearchModules(){
	$modules = array();
	$dir = XOOPS_ROOT_PATH . '/modules/xoonips/filesearch';
	
	$ar = array();
	if ($h = opendir($dir)) {
		while (false !== ($file = readdir($h))) {
			if ($file != "." && $file != "..")
				$ar[] = $file;
		}
		closedir($h); 
	}
	
	foreach ( $ar as $key => $val ){
		if ( preg_match( '/^def_.*\.php$/', $val ) ){
			$module = array();
			include( $dir.'/'.$val );
			$module['byte_pattern_length'] = isset($module['byte_pattern']) ? strlen($module['byte_pattern']) : -1;
			$modules[] = $module;
		}
	}
	
	// usortӴؿswitch˽񤯤PHP5.0.4SEGVФȤ롣http://bugs.php.net/bug.php?id=29944 
	usort( $modules, "xnpCompareModule" );
	
	return $modules;
}

/** եβϤߤ
 * Ϥ˻Ѥ⥸塼(name,version)ã顢Ǥ롣
 * Ϸ̤search_textơ֥˽
 * @return array( $result, $error_message, $module_name, $module_version )
 *  $result ϤޤϤ˻Ѥ⥸塼ãΤǹפʤtrue
 *  $error_message Ϥ˼Ԥʤ饨顼åʳʤfalse
 *  $module_name, $module_version Ϥʤ顤Υ⥸塼nameversion. ʳʤfalse
 */

function xnpExtractText2( $file_id, $modules, $original_file_name, 
  $mime_type, $module_name, $module_version, $header ){
	global $xoopsDB;
	$errorMessage = true;
	$failed_module_names = array();
	$sess_id = session_id();
	
	$ar = pathinfo( $original_file_name );
	$ext = $ar['extension'];
	
	for ( $i = 0; $i < 3; $i++ ){ // 3̤ˡǻ
		foreach ( $modules as $key => $module ){
			if ( !isset($failed_module_names[$module['name']]) ){
				if ( $i == 0 && isset($module['byte_pattern']) && strncmp( $module['byte_pattern'], $header, $module['byte_pattern_length'] ) == 0 
				 ||  $i == 1 && $module['mime_type'] == $mime_type
				 ||  $i == 2 && in_array( $ext, $module['extensions'] ) ){
					// todo: byte_pattern_length32ۤϡ餯fopenӤɬפ뤬
					
					if ( $module_name == $module['name'] && $module_version == $module['version'] )
						return array( true, false, false, false ); // Ϥ˻Ѥ⥸塼ã
					
					include_once XOOPS_ROOT_PATH . '/modules/xoonips/filesearch/' . $module['php_file_name'];
					$classname = $module['class_name'];
					
/*					if ( !XOOPS_USE_MULTIBYTES ){ // Ѹ⡼ɤǤwindow򤫤ʤ.UTF8latin1+ʸȤѴɬפ롥
						$c = new $classname();
						$c->open( xnpGetUploadFilePath($file_id) );
						$source = new XoonipsUtf82Latin1();
						$source->source = &$c;
					}
					else {
*/						$c = new $classname();
						$c->open( xnpGetUploadFilePath($file_id) );
						$source = new XoonipsWordSeparator(); 
						$source->source = &$c;
//					}
					
					$tmpfile1 = realpath(tempnam('/tmp', 'XooNIpsSearch')); // realpath̵WindowsMySQL顼Ф
					$fo = fopen( $tmpfile1, 'wb' );
					fwrite( $fo, "$file_id\t" );
					if ( $fo ){
						while ( true ){
							list( $buf, $errorMessage ) = $source->fetch();
							
							if ( $buf === false )
								break;
							$b = fwrite( $fo, $buf );
						}
						fclose( $fo );
					}
					else {
						return array( false, "cannot open temporary file $tmpfile1", false, false );
					}
					
					$sql0 = "delete from ".$xoopsDB->prefix('xoonips_search_text')." where file_id=$file_id";
					$result = $xoopsDB->queryF( $sql0 );
					// XSASPHPȡ load data local infile ϥ顼(The used command is not allowed with this MySQL version)ˤʤ.
					// linuxPHPȡ load data infileϥ顼 ERROR 1045: Access denied for user: '@localhost' (Using password: NO)ˤʤ롥chmod 644Ƥᡥ
					$sql1 = 'load data infile "'.addslashes($tmpfile1).'" into table '.$xoopsDB->prefix('xoonips_search_text').' ( file_id, search_text )';
					$result = $xoopsDB->queryF( $sql1 );
					if ( $result == false ){
						$sql1 = 'load data local infile "'.addslashes($tmpfile1).'" into table '.$xoopsDB->prefix('xoonips_search_text').' ( file_id, search_text )';
						$result = $xoopsDB->queryF( $sql1 );
						if ( $result == false ){
							return array( false, 'load data infile failed.', false, false );
						}
					}
					
					$sql2 = "update ".$xoopsDB->prefix('xoonips_file')." set search_module_name='".addslashes($module['name'])."', search_module_version=".$module['version']." where file_id=$file_id";
					$result = $xoopsDB->queryF( $sql2 );
					
					unlink( $tmpfile1 ); // todo: Ƥ ե뤬Ĥʤ褦ˤ٤
					return array( true, false, $module['name'], $module['version'] );

				}
			}
		}
	}
	
	return array( false, 'unsupported file format', false, false );
}

/** file  text Ф롥
 * @return array( $result, $errorMessage )
 *  $result: trueʤޤϴкѤߡfalseʤ鼺
 *  $errorMessage 顼å
 */
function xnpExtractText( $file_id, $modules )
{
	global $xoopsDB;
	$file_table = $xoopsDB->prefix('xoonips_file');
	$sql = "select file_id, original_file_name, mime_type, search_module_name, search_module_version, header, header is null from $file_table where file_id=$file_id";
	
	$result = $xoopsDB->query( $sql );
	if ( $result == false ){
		return array( false, "query error: $sql" );
	}
	
	list($file_id, $original_file_name, $mime_type, $module_name, $module_version, $header, $header_is_null ) = $xoopsDB->fetchRow($result);
	
	// headerDB˽񤫤Ƥʤ餯FileSearch˺줿Τheader񤯡
	if ( $header_is_null ){
		$filename = xnpGetUploadFilePath($file_id);
		$h = @fopen( $filename, 'rb' );
		if ( $h ){
			$header = fread( $h, 32 );
			fclose( $h );
			$escHeader = addslashes( $header );
			$sql = "update $file_table set header='$escHeader' where file_id=$file_id";
			$xoopsDB->query( $sql );
		}
		else
			$header = null; // եμΤ̵
	}
	
	list( $result, $error_message, $module_name, $module_version ) = xnpExtractText2($file_id, $modules, $original_file_name, $mime_type, $module_name, $module_version, $header );
	if ( $error_message )
		return array( false, $error_message );
	
	if ( $module_name ){
		$esc_module_name = addslashes( $module_name );
		$sql = "update $file_table set search_module_name='$esc_module_name', search_module_version=$module_version where file_id=$file_id";
		$xoopsDB->query( $sql );
	}
	return array( true, false );
}



/**
 * file  text Ф롥
 * з̤$file_idб쥳ɤsearch_text˵Ͽ롥
 * modulesˤxnpGetFileSearchModules()븡⥸塼Ϳ
 * 
 * @param file_id оݤΥե
 * @param modules ե븡⥸塼
 * @return ʤ
 * @see xnpGetFileSearchModules
 */
function xnpExtractTextAll(){
	global $xoopsDB;
	$modules = xnpGetFileSearchModules();
	
	$file_table = $xoopsDB->prefix('xoonips_file');
	$sql = "select file_id from $file_table";
	$result = $xoopsDB->query( $sql );
	while ( list( $file_id ) = $xoopsDB->fetchRow( $result ) ){
		list( $res, $errorMessage ) = xnpExtractText( $file_id, $modules );
		// suppress error messages on updating XooNIps
		//if ( $errorMessage )
		//	echo "$errorMessage <br>\n";
		set_time_limit(180);
	}
}


function xnpRescanMetadata(){
	global $xoopsDB;
	
	$meta_table = $xoopsDB->prefix('xoonips_oaipmh_metadata');
	$repo_table = $xoopsDB->prefix('xoonips_oaipmh_repositories');
	$sql = "select identifier, metadata, format, URL from $meta_table 
	 left join $repo_table on $meta_table.repository_id = $repo_table.repository_id order by identifier";
	$result = $xoopsDB->query( $sql );
	
	while ( list( $identifier, $metadata, $format, $URL ) = $xoopsDB->fetchRow($result) ){
		// metadata UTF-8Ѵ
		if ( xnpChkServerLang() ){
			//  EUC -> numeric -> UTF-8 ѴԤȡ$metadatanumericޤѴƤޤäƺ롥ľ EUC -> UTF-8 ѴԤɬפ
			$metadata = mb_convert_encoding( $metadata, 'UTF-8', mb_detect_encoding( $metadata ));
		}
		$metadata = "<dummy1><dummy2>". $metadata . "</dummy2></dummy1>"; // tagstack[2]RECORD֤ɬפΤǡ2ʿ  ListRecordsHandler::startElementHandler
		$parser = xml_parser_create( 'UTF-8' );
		
		$handler = new ListRecordsHandler( $parser, $URL, $format );
		
		if( !xml_parse( $parser, $metadata, true ) ) {
			echo "[XMLParser]".xml_error_string( xml_get_error_code( $parser ) )." at line ".xml_get_current_line_number( $parser ).", column ".xml_get_current_column_number( $parser );
		}
		xml_parser_free( $parser );
		unset( $handler );
		set_time_limit(180);
	}
}

/**
 * 
 * ʸ򡤻ХȿǺĹˤʤ褦ڤȤ
 * $src == $within.$without;
 * 
 * @param src оʸ
 * @param enc srcencoding(ά)
 * @return array( $within, $without )
 * within Хȿ˼ޤʬʸ
 * without ڤȤʬʸ
 * 
 */
function xnpTrimString( $src, $len, $enc = null )
{
    //1 ʬʸ
    //1.1 ܸб(mbstringͭ)ʤСmb_strcutȤäʬʸ
    //1.2 ܸбФʤСsubstrʬʸ
    //2 ʬʸ󤬿ʸȤǽλƤ顤οʸȤ
	if( xnpChkServerLang() ){
		//multi byte charset or numeric character reference
		$dst = mb_strcut( $src, 0, $len, is_null( $enc ) ? mb_detect_encoding( $src ) : $enc );
	}else{
		//for latin or numeric character reference
		//retrieve a substring
		$dst = substr( $src, 0, $len );
	}
	// if the last numeric character reference is incompleted, remove it
	$within = preg_replace( "/^(.*)&[^;]*$/s", '$1', $dst );
	$without = substr( $src, strlen($within) );
	if ( $within == $dst )    // $dstʸȤǤϤʤ
		return array( $within, $without );
	if ( preg_match( "/^&#([0-9]+|[Xx][0-9A-Fa-f]+);/", $without ) ) // $withoutƬʸȤǤ
		return array( $within, $without );
	return array( $dst, substr( $src, strlen($dst) ) );
}

// $ar['without'] ʸ󷿤ĶǤʤʤtrue֤
// $ar[key]['without'] ʸ󷿤ĶǤʤ褦keyʤtrue֤
function xnpHasWithout( $ar ){
	foreach ( $ar as $key => $val ){
		if ( $key == 'without' && strlen($val) != 0 ){
			return true;
		}
		if ( is_array($val) && isset($val['without']) && strlen($val['without']) != 0 ){
			return true;
		}
	}
	return false;
}

/** ơ֥ΥĹ(ʸ󷿤ΥΤ)
 * @param $table_wo_prefix: ơ֥̾(prefix)
 * @return array( name1 => length1, name2 => length2, ... ) 뤤ϥ顼ʤfalse
 */
function xnpGetColumnLengths( $table_wo_prefix ){
	global $xoopsDB;
	$table = $xoopsDB->prefix($table_wo_prefix);
	$result = $xoopsDB->query( "select * from $table limit 1" );
	if ( $result == false )
		return false;
	
	$ar = array();
	for( $i = 0; $i < mysql_num_fields($result); $i++ ){
		$name = mysql_field_name($result, $i);
		$len = mysql_field_len($result, $i);
		$type = mysql_field_type($result, $i);
		if ( $type == 'blob' || $type == 'string' ){
			$ar[$name] = $len;
		}
	}
	return $ar;
}

/** 
 * @param $assoc: Ϣ
 *        array( column_name1 => value1, column_name2 => value2, ... )
 * @param $table_wo_prefix: ơ֥̾(prefix)
 * @param $names: å륫̾.  array( 'readme', 'rights' ) ʤ(άå)
 * @param $enc: valueΥ󥳡(ά)
 * $assoc  ڤͤ᤿ͤ񤯡 
 *          array( column_name1 => within1, column_name2 => within2, ... )
 */
function xnpTrimColumn( &$assoc, $table_wo_prefix, $names=null, $enc=null ){
	$lengths = xnpGetColumnLengths( $table_wo_prefix );
	if ( $lengths == false )
		return false;
	
	foreach ( $lengths as $name => $len ){
		//echo "xnpTrimColumn: name=$name len=$len type=$type <br>\n";
		if ( isset( $assoc[$name] ) && ( is_null( $names ) || in_array( $name, $names ) ) ){
			list( $within, $without ) = xnpTrimString( $assoc[$name], $len, $enc );
			//echo $assoc[$name] . " within=$within, without=$without <br>\n";
			$assoc[$name] = $within;
		}
	}
}

/** 
 * @param $assoc: Ϣ
 *        array( column_name => array( 'value' => value ), ... )
 * @param $table_wo_prefix: prefixơ֥̾
 * @param $names: å륫̾.  array( 'readme', 'rights' ) ʤ
 * $assoc  value, within, without, html_string 񤯡 
 *          array( column_name => array( 'value'=>value, 'within'=>within, 'without'=>without, 'html_string'=>html_string ), ... )
 */
function xnpConfirmHtml( &$assoc, $table_wo_prefix, $names=null, $enc = null ){
	$lengths = xnpGetColumnLengths( $table_wo_prefix );
	if ( $lengths == false )
		return false;
	
	foreach ( $lengths as $name => $len ){
		//echo "xnpTrimColumn: name=$name len=$len type=$type <br>\n";
		if ( isset( $assoc[$name] ) && ( is_null( $names ) || in_array( $name, $names ) ) ){
			$val = $assoc[$name]['value'];
			list( $assoc[$name]['within'], $assoc[$name]['without'] ) = xnpTrimString( $val, $len, $enc );
			$assoc[$name]['value'] = xnpWithinWithoutHtml( $assoc[$name]['within'], $assoc[$name]['without'] );
			$assoc[$name]['html_string'] = xnpHtmlspecialchars($val);
		}
	}
}


function xnpTrimBasic( &$assoc ){
	$column_names = array( 'title', 'keywords', 'description', 'doi' ); // ưåȡlangǤΤǡ
	return xnpConfirmHtml( $assoc, 'xoonips_item_basic', $column_names, _CHARSET );
}

function xnpDate( $year, $month, $day ) {
	$int_year = intval($year);
	$int_month = intval($month);
	$int_day = intval($day);
	if ($int_month == 0) {
		$date = date( YEAR_FORMAT, mktime(0,0,0,1,1, $int_year) );
	}
	else {
		if ($int_day == 0) {
			$date = date( YEAR_MONTH_FORMAT, mktime(0,0,0,$int_month, 1, $int_year) );
		}
		else {
			$date = date( DATE_FORMAT, mktime(0,0,0,$int_month, $int_day, $int_year) );
		}
	}
	if ($int_year < 0) {
		$date = str_replace("1970", strval(abs($int_year)), $date);
		$date .= "B.C.";
	}
	else if ($int_year < 1970) {
		$date = str_replace("1970", strval($int_year), $date);
	}
	else if ($int_year >= 2070) {
		$date = str_replace("1970", strval($int_year), $date);
	}
	return $date;
}

function xnpMktime( $year, $month, $day ) {
	$int_year = intval($year);
	$int_month = intval($month);
	$int_day = intval($day);
	if ($int_month == 0) {
		$int_day = 0;
		$date = sprintf("%04s--%02s", $int_year, $int_day);
	}
	else {
		$date = sprintf("%04s-%02s-%02s", $int_year, $int_month, $int_day);
	}
	return $date;
}

function xnpISO8601( $year, $month, $day ) {
	$int_year = intval($year);
	$int_month = intval($month);
	$int_day = intval($day);
	if ($int_month == 0) {
		$date = sprintf("%04s", $int_year);
	}
	else if ($int_day == 0) {
		$date = sprintf("%04s-%02s", $int_year, $int_month);
	}
	else {
		$date = sprintf("%04s-%02s-%02s", $int_year, $int_month, $int_day);
	}
	return $date;
}

/**
 *  php.iniǥ쥯ƥ֤upload_max_filesizeʤɤ'M','K'ʤ
 *  Ȥäûɽ줿Хȿ򡤥Хȿ˴
 *  
 *  @param $val Хȿûɽޤʸ
 *  @return 줿Хȿ
 *  
 *  http://jp.php.net/manual/ja/function.ini-get.php 
 */
function return_bytes($val) {
   $val = trim($val);
   $last = strtolower($val{strlen($val)-1});
   switch($last) {
       case 'g':
           $val *= 1024;
       case 'm':
           $val *= 1024;
       case 'k':
           $val *= 1024;
   }

   return $val;
}

/**
 * 
 * ե륢åץɽΥ顼ʸѴ֤
 * 
 * @param $_FILES[xxxx]['error']
 * @return бå ޤ NULL
 */
function return_upload_file_error( $err ){
    switch( $err ){
    case UPLOAD_ERR_OK:
        //: 0; 顼Ϥʤե륢åץɤƤޤ 
        return _MD_XOONIPS_UPLOAD_ERR_OK;
        break;
        
    case UPLOAD_ERR_INI_SIZE:
        //: 1; åץɤ줿եϡphp.ini  upload_max_filesize ǥ쥯ƥ֤ͤĶƤޤ 
        return _MD_XOONIPS_UPLOAD_ERR_INI_SIZE;
        break;

    case UPLOAD_ERR_FORM_SIZE:
        //: 2; åץɤ줿եϡHTML եǻꤵ줿 MAX_FILE_SIZE ĶƤޤ 
        return _MD_XOONIPS_UPLOAD_ERR_FORM_SIZE;
        break;

    case UPLOAD_ERR_PARTIAL:
        //: 3; åץɤ줿եϰΤߤåץɤƤޤ 
        return _MD_XOONIPS_UPLOAD_ERR_PARTIAL;
        break;

    case UPLOAD_ERR_NO_FILE:
        //: 4; եϥåץɤޤǤ 
        return _MD_XOONIPS_UPLOAD_ERR_NO_FILE;
        break;

    case UPLOAD_ERR_NO_TMP_DIR:
        //: 6; ƥݥեޤPHP 4.3.10  PHP 5.0.3 Ƴޤ 
        return _MD_XOONIPS_UPLOAD_ERR_NO_TMP_DIR;
        break;

    case UPLOAD_ERR_CANT_WRITE:
        //: 7; ǥؤν񤭹ߤ˼ԤޤPHP 5.1.0 Ƴޤ 
        return _MD_XOONIPS_UPLOAD_ERR_CANT_WRITE;
        break;
    }
}

define( "XOONIPS_SEARCH_TEXT_FAILED", "pdftotext failed." );

// ƥǻѤ륯饹Τδ쥯饹
class XoonipsSearchText {
	function XoonipsSearchText(){}
	var $handle = false;
	
	function open( $filename ){
		if ( PHP_OS == 'WIN32' || PHP_OS == 'WINNT' ) $this->openWin( $filename );
		else                                          $this->openNowin( $filename );
		
		if ( $this->handle == false )
			return XOONIPS_SEARCH_TEXT_FAILED;
		return false;
	}
	
	function close(){
		if ( PHP_OS == 'WIN32' || PHP_OS == 'WINNT' ) $this->closeWin();
		else                                          $this->closeNowin();
	}
	
	/** ե뤫ƥȤΰ
	 *   @return Фƥȡ󥳡ɤUTF8UTF8ʸڤäƤϤʤʤ
	 */
	function fetch(){
		return $this->fetchFromText();
	}
	
	/** $this->handleƥȤΰ
	 *   @return array( text, errorMessage )
	 *    text: Фƥȡ󥳡ɤUTF8Իޤãfalse. UTF8ڤ뤳Ȥ̵.
	 *    errorMessage: Իϥ顼åޤãfalse
	 */
	function fetchFromText(){
		if ( $this->handle == false )
			return array( false, XOONIPS_SEARCH_TEXT_FAILED );
		
		$text = fgets( $this->handle );
		if ( $text == false ){ // ã鼫ưclose
			$this->close();
			$this->handle = false;
			return array( false, false );
		}
		return array( $text, false );
	}
	
	/** fetchFromTextȤۤƱ$this->handleHTMLˤäȤ
	    HTMLTEXTѴ롥
	    todo: ʤʸȡʸλȤUTF8Ѵɬפ뤬&Ȥ<򸡺ΤǤʤ ֤
	 */
	var $in_tag = false;
	function fetchFromHtml(){
		if ( $this->handle == false )
			return array( false, XOONIPS_SEARCH_TEXT_FAILED );
		
		$html = fgets( $this->handle ); // fgetss($h)xsasWrong parameter count for fgetss()ɽƥǡǤʤ
		if ( $html === false ){
			$this->close();
			$this->handle = false;
			return array( false, false );
		}
		
		// (<...>)
		// ιԤΥĤƤʤʤ in_tag == true
		if ( $this->in_tag ) $pattern = '/((?:^[^<>]*|<[^>]*)(?:>|($)))/m';
		else                 $pattern =             '/(<[^>]*(?:>|($)))/m';
		
		$ar = preg_split( $pattern, $html, -1, PREG_SPLIT_DELIM_CAPTURE );
		
		// 
		$count = count($ar);
		for ( $i = 1; $i < $count; $i += 2 )
			unset( $ar[$i] );
		
		if ( $count % 2 == 0 ){
			// $countϴˤʤϤʤΤ($)Υѥ˥ҥåȤƤȶˤʤ롥ĤޤꤳΥϼιԤޤ³Ƥ
			$in_tag = true;
		}
		
		return array( implode( '', $ar ), false );
	}
	
	function openWin( $filename ){
		$this->handle = fopen( $filename, "rb" );
	}
	
	function openNowin( $filename ){
		$this->handle = fopen( $filename, "rb" );
	}
	function closeWin(){
		fclose( $this->handle );
		$this->handle = false;
	}
	function closeNowin(){
		fclose( $this->handle );
		$this->handle = false;
	}
	
}

/** lock xoonips_ranking_*, xoonips_ranking_sum_*
 *  unlock timeout = 180s
 */
function xnpLockRanking(){
	global $xoopsDB;
	$locked = false;
	$timeout = time() + 180;
	$key = 'ranking_lock_timeout';
	if ( RES_OK != xnp_get_config_value( $key, $value ) )
		xnp_set_config_value( $key, '0' );
	
	for ( $retry = 0; $retry < 3; $retry++ ){
		$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix('xoonips_config') . " set value=$timeout where name='$key' and value < unix_timestamp(now())" );
		if ( $result == false ){ echo __LINE__ . mysql_error(); exit; } //@@
		if ( $xoopsDB->getAffectedRows() ){
			return $timeout;
		}
		sleep(1);
	}
	return false;
}

function xnpUnlockRanking( $timeout ){
	global $xoopsDB;
	$result = $xoopsDB->queryF( "update " . $xoopsDB->prefix('xoonips_config') . " set value=0 where name='ranking_lock_timeout' and value='$timeout'" );
	if ( $result == false ){ echo __LINE__ . mysql_error(); exit; } //@@
}

/** update xoonips_ranking_*
 * @param diff differential (bool)
 * @return true: succeeded. false: failed.
 */
function xnpRecalcRanking( $diff ){
	global $xoopsDB;
	
	if ( RES_OK != xnp_get_config_value( 'ranking_last_update'    , $last_update    ) ) $last_update     = 0;
	if ( RES_OK != xnp_get_config_value( 'ranking_days'           , $days           ) ) $days            = 0;
	if ( RES_OK != xnp_get_config_value( 'ranking_days_enabled'   , $days_enabled   ) ) $days_enabled    = false;
	if ( RES_OK != xnp_get_config_value( 'ranking_sum_last_update', $sum_last_update) ) $sum_last_update = 0;
	
	$now = time();
	if ( $now == $last_update && $diff == true )
		return true;
	
	$h = xnpLockRanking();
	if ( $h ){
		if ( $diff ){
			if ( $days_enabled ){
				$add_days_sql = " ( $last_update               <= timestamp and timestamp < $now               ) ";
				$sub_days_sql = " ( $last_update - $days*86400 <= timestamp and timestamp < $now - $days*86400 ) ";
			}
			else {
				$add_days_sql = " ( $last_update <= timestamp and timestamp < $now ) ";
				$sub_days_sql = " 0 ";
			}
		}
		else {
			$names = array(
				'viewed_item',
				'downloaded_item',
				'contributing_user',
				'searched_keyword',
				'active_group',
				'new_item',
				'new_group',
			);
			$columns = array(
				'item_id, count',
				'item_id, count',
				'item_id, uid, timestamp',
				'keyword, count',
				'gid, count',
				'item_id,timestamp',
				'gid,timestamp',
			);
			
			for ( $i = 0; $i < count($names); $i++ ){
				$result = $xoopsDB->query( "delete from " . $xoopsDB->prefix('xoonips_ranking_'.$names[$i] ) );
				if ( $result == false ){ echo __LINE__  . mysql_error(); exit; }
			}
			
			if ( $days_enabled ){
				$add_days_sql = " ( $now - $days*86400 <= timestamp and timestamp < $now )";
				$sub_days_sql = " 0 ";
			}
			else {
				$add_days_sql = " ( timestamp < $now ) ";
				$sub_days_sql = " 0 ";
				
				if ( $sum_last_update != 0 ){
					// ranking is ( sum_start ... sum_last_update of ranking_sum ) + ( sum_last_update ... now of event_log ).
					
					// xoonips_ranking_* = xoonips_ranking_sum_* 
					for ( $i = 0; $i < count( $names ); $i++ ){
						$result = $xoopsDB->query( "insert into " . $xoopsDB->prefix('xoonips_ranking_'.$names[$i]) . 
						  " ( ".$columns[$i]." ) select ".$columns[$i]." from " . $xoopsDB->prefix('xoonips_ranking_sum_'.$names[$i] ) );
						if ( $result == false ){ echo __LINE__  . mysql_error(); exit; }
					}
					
					// xoonips_ranking_* += ( sum_last_update ... now of event_log )
					$add_days_sql = "( $sum_last_update <= timestamp and timestamp < $now )";
				}
				
			}
		}
		
		xnpRecalcRankingSql( $add_days_sql, $sub_days_sql, false );
		xnp_set_config_value( 'ranking_last_update', $now );
		xnpUnlockRanking( $h );
		return true;
	}
	else
		return false;
}

/**  update xoonips_ranking_* or xoonips_ranking_sum_*. 
 *   call xnpLockRanking() before xnpRecalcRankingSql().
 * @param add_sql adding range
 * @param sub_sql subtracting range
 * @param update_sum_table  true:update ranking_sum_*.  false: update ranking_*(visible table only)
 */
function xnpRecalcRankingSql( $add_days_sql, $sub_days_sql, $update_sum ){
	global $xoopsDB;
	$uid = UID_GUEST;
	if ( isset($_SESSION['xoopsUserId']) )
		$uid = $_SESSION['xoopsUserId'];
	
	if ( RES_OK != xnp_get_config_value( 'ranking_visible'      , $visible      ) ) $visible      = "1,1,1,1,1";
	if ( RES_OK != xnp_get_config_value( 'ranking_new_visible'  , $new_visible  ) ) $new_visible  = "1,1";
	if ( RES_OK != xnp_get_config_value( 'ranking_num_rows'     , $num_rows     ) ) $num_rows     = 5;
	if ( RES_OK != xnp_get_config_value( 'ranking_new_num_rows' , $new_num_rows ) ) $new_num_rows = 5;
	
	$visible = explode( ',', $visible );
	$new_visible = explode( ',', $new_visible );
	
	
	$etids = array();
	if ( $visible[0] || $update_sum ) $etids[] = ETID_VIEW_ITEM;
	if ( $visible[1] || $update_sum ) $etids[] = ETID_DOWNLOAD_FILE;
	if ( $visible[2] || $update_sum ) $etids[] = ETID_CERTIFY_ITEM;
	if ( $visible[3] || $update_sum ) { $etids[] = ETID_QUICK_SEARCH; $etids[] = ETID_ADVANCED_SEARCH; }
	if ( $visible[4] || $update_sum ) $etids[] = ETID_REQUEST_CERTIFY_ITEM;

	$new_etids = array();
	if ( $new_visible[0] || $update_sum ) $new_etids[] = ETID_CERTIFY_ITEM;
	if ( $new_visible[1] || $update_sum ) $new_etids[] = ETID_INSERT_GROUP;

	$sum = $update_sum ? '_sum' : '';
	$log_table               = $xoopsDB->prefix("xoonips_event_log");
	$viewed_item_table       = $xoopsDB->prefix("xoonips_ranking${sum}_viewed_item");
	$downloaded_item_table   = $xoopsDB->prefix("xoonips_ranking${sum}_downloaded_item");
	$contributing_user_table = $xoopsDB->prefix("xoonips_ranking${sum}_contributing_user");
	$searched_keyword_table  = $xoopsDB->prefix("xoonips_ranking${sum}_searched_keyword");
	$active_group_table      = $xoopsDB->prefix("xoonips_ranking${sum}_active_group");
	$new_item_table          = $xoopsDB->prefix("xoonips_ranking${sum}_new_item");
	$new_group_table         = $xoopsDB->prefix("xoonips_ranking${sum}_new_group");
	
	if ( count( $etids ) ){
		$etids_str = implode( ',', $etids );
		$sql = "select count(*) from $log_table where event_type_id in ( $etids_str ) and ($add_days_sql or $sub_days_sql) ";
		$result = $xoopsDB->query( $sql );
		if ( $result == false ){ echo __LINE__ . mysql_error(); exit; }
		list( $ct ) = $xoopsDB->fetchRow( $result );
		if ( $ct ){ 
			// log changed. need recalc.
			if ( $visible[0] || $update_sum ){
				$sql = "select item_id, sum($add_days_sql) - sum($sub_days_sql) as count from $log_table where event_type_id=".ETID_VIEW_ITEM." and ( $add_days_sql or $sub_days_sql ) group by item_id";
				$result = $xoopsDB->query( $sql );
				if ( $result == false ){ echo __LINE__  . mysql_error(); exit; }
				while ( $row = $xoopsDB->fetchRow( $result ) ){
					list( $item_id, $count ) = $row;
					$result2 = $xoopsDB->query( "select count from $viewed_item_table where item_id=$item_id" );
					if ( $xoopsDB->getRowsNum( $result2 ) == 0 ){
						$result2 = $xoopsDB->queryF( "insert into $viewed_item_table ( item_id, count ) values ( $item_id, $count ) " );
						if ( $result2 == false ){ echo __LINE__ . mysql_error(); exit; }
					}
					else {
						$resul2 = $xoopsDB->queryF( "update $viewed_item_table set count = count + $count where item_id=$item_id" );
						if ( $result2 == false ){ echo __LINE__ .  mysql_error(); exit; }
					}
				}
			}
			
			if ( $visible[1] || $update_sum ){
				$sql = "select item_id, sum($add_days_sql) - sum($sub_days_sql) as count from $log_table where event_type_id=".ETID_DOWNLOAD_FILE." and ( $add_days_sql or $sub_days_sql ) group by item_id";
				$result = $xoopsDB->query( $sql );
				if ( $result == false ){ echo __LINE__  . mysql_error(); exit; }
				while ( $row = $xoopsDB->fetchRow( $result ) ){
					list( $item_id, $count ) = $row;
					$result2 = $xoopsDB->query( "select count from $downloaded_item_table where item_id=$item_id" );
					if ( $xoopsDB->getRowsNum( $result2 ) == 0 )
						$xoopsDB->queryF( "insert into $downloaded_item_table ( item_id, count ) values ( $item_id, $count ) " );
					else
						$xoopsDB->queryF( "update $downloaded_item_table set count = count + $count where item_id=$item_id" );
				}
			}
			
			if ( $visible[2] || $update_sum ){
				$sql = "select t.item_id, tb.uid, t.timestamp from $log_table as t left join ".$xoopsDB->prefix('xoonips_item_basic')." as tb on tb.item_id=t.item_id where event_type_id=".ETID_CERTIFY_ITEM." and $add_days_sql ";
				$result = $xoopsDB->query( $sql );
				if ( $result == false ){ echo __LINE__  . mysql_error(); exit; }
				while ( $row = $xoopsDB->fetchRow( $result ) ){
					list( $item_id, $uid, $timestamp ) = $row;
					$r = $xoopsDB->queryF( "replace into $contributing_user_table (item_id, uid, timestamp) values ( $item_id, $uid, from_unixtime($timestamp) )" );
				}
				
				// todo: slow if $contributing_user_table.timestamp is not indexed.   use event_log.timestamp instead?
				$xoopsDB->queryF( "delete from $contributing_user_table where " . str_replace( 'timestamp', 'unix_timestamp(timestamp)', $sub_days_sql ) );
				
			}
			
			if ( $visible[3] || $update_sum ){
				$sql = "select search_keyword, if($add_days_sql, 1, -1) as count from $log_table where event_type_id in ( ".ETID_QUICK_SEARCH.",".ETID_ADVANCED_SEARCH.") and ( $add_days_sql or $sub_days_sql ) ";
				
				$result = $xoopsDB->query( $sql );
				if ( $result == false ){ echo __LINE__  . mysql_error(); exit; }
				while ( $row = $xoopsDB->fetchRow( $result ) ){
					list( $keyword, $count ) = $row;
					
					// extract keywords from log
					$matches = array();
					if ( 0 == preg_match( '/(?:^|&)keyword=([^&]*)(?:&|$)/', $keyword, $matches ) )
						continue;
					$keyword = urldecode($matches[1]);
					
					preg_match_all('/([^ "()]+)|(\()|(\))|"([^"]+)"/', $keyword, $match, PREG_SET_ORDER );
					$len = count( $match );
					for ( $i = 0; $i < $len; $i++ ){
						if      ( isset( $match[$i][1] ) ) $keyword = $match[$i][1];
						else if ( isset( $match[$i][4] ) ) $keyword = $match[$i][4];
						else continue;
						
						$keyword = strtolower( $keyword );
						if ( $keyword == 'and' || $keyword == 'or' )
							continue;
						$esc_keyword = addslashes( $keyword );
						
						$result2 = $xoopsDB->query( "select count from $searched_keyword_table where keyword='$esc_keyword'" );
						if ( $xoopsDB->getRowsNum( $result2 ) == 0 )
							$xoopsDB->queryF( "insert into $searched_keyword_table ( keyword, count ) values ( '$esc_keyword', $count ) " );
						else
							$xoopsDB->queryF( "update $searched_keyword_table set count = count + $count where keyword='$esc_keyword'" );
					}
				}
			}
			
			if ( $visible[4] || $update_sum ){
				$sql = "select tx.gid, if($add_days_sql, 1, -1), count( distinct timestamp, item_id, tx.gid ) from $log_table as t left join ".$xoopsDB->prefix('xoonips_index')." as tx on tx.index_id=t.index_id where event_type_id=".ETID_REQUEST_CERTIFY_ITEM." and ( $add_days_sql or $sub_days_sql ) and tx.gid is not null group by timestamp, item_id, tx.gid ";
				$result = $xoopsDB->query( $sql );
				if ( $result == false ){ echo __LINE__  . mysql_error(); exit; }
				while ( $row = $xoopsDB->fetchRow( $result ) ){
					list( $gid, $dir, $count ) = $row;
					$count *= $dir;
					$result2 = $xoopsDB->query( "select count from $active_group_table where gid=$gid" );
					if ( $result2 == false ){ echo __LINE__  . mysql_error(); exit; }
					if ( $xoopsDB->getRowsNum( $result2 ) == 0 ){
						$result3 = $xoopsDB->queryF( "insert into $active_group_table ( gid, count ) values ( $gid, $count ) " );
						if ( $result3 == false ){ echo __LINE__ . mysql_error(); exit; }
					}
					else {
						$result3 = $xoopsDB->queryF( "update $active_group_table set count = count + $count where gid=$gid" );
						if ( $result3 == false ){ echo __LINE__ . mysql_error(); exit; }
					}
				}
			}
		}
	}
	
	if ( count( $new_etids ) ){
		$new_etids_str = implode( ',', $new_etids );
		$sql = "select count(*) from $log_table where event_type_id in ( $new_etids_str ) and ($add_days_sql or $sub_days_sql) ";
		$result = $xoopsDB->query( $sql );
		if ( $result == false ){ echo __LINE__  . mysql_error(); exit; }
		
		list( $ct ) = $xoopsDB->fetchRow( $result );
		if ( $ct ){ 
			if ( $new_visible[0] || $update_sum ){
				$sql = "replace into $new_item_table ( item_id, timestamp ) select t.item_id, from_unixtime(timestamp) from $log_table as t ".
					" left join " . $xoopsDB->prefix('xoonips_index_item_link')." as txil on t.item_id=txil.item_id ".
					" left join " . $xoopsDB->prefix('xoonips_index')." as tx on txil.index_id=tx.index_id ".
					" where tx.open_level = " . OL_PUBLIC . " and event_type_id=".ETID_CERTIFY_ITEM." and ( $add_days_sql ) group by t.item_id order by timestamp desc limit $new_num_rows";
				
				$result = $xoopsDB->queryF( $sql );
				if ( $result == false ){ echo __LINE__  . mysql_error(); exit; }
				while ( $row = $xoopsDB->fetchRow( $result ) ){
					list( $item_id, $timestamp ) = $row;
					$sql = "replace into $new_item_table ( item_id, timestamp ) values ( $item_id, from_unixtime($timestamp) )";
					$result2 = $xoopsDB->queryF( $sql );
					if ( $result2 == false ){ echo __LINE__  . mysql_error(); exit; }
				}
				
				// remove old entry
				$sql = "select unix_timestamp(timestamp) from $new_item_table order by timestamp desc limit $new_num_rows,1";
				$result = $xoopsDB->query( $sql );
				if ( $result == false ){ echo __LINE__  . mysql_error(); exit; }
				if ( $result != false && $xoopsDB->getRowsNum( $result ) != 0 ){
					list( $timestamp ) = $xoopsDB->fetchRow( $result );
					$sql = "delete from $new_item_table where unix_timestamp(timestamp) < $timestamp";
					$result = $xoopsDB->queryF( $sql );
					if ( $result == false ){ echo __LINE__  . mysql_error(); exit; }
				}
			}
			if ( $new_visible[1] || $update_sum ){
				$sql = "select t.gid, timestamp from $log_table as t left join " . $xoopsDB->prefix('xoonips_groups'). " as tg on t.gid=tg.gid "
					." where tg.gid is not null and event_type_id=".ETID_INSERT_GROUP." and ( $add_days_sql ) order by timestamp desc limit $new_num_rows";
				$result = $xoopsDB->query( $sql );
				if ( $result == false ){ echo __LINE__  . mysql_error(); exit; }
				while ( $row = $xoopsDB->fetchRow( $result ) ){
					list( $gid, $timestamp ) = $row;
					$sql = "replace into $new_group_table ( gid, timestamp ) values ( $gid, from_unixtime($timestamp) )";
					$result2 = $xoopsDB->queryF( $sql );
					if ( $result2 == false ){ echo __LINE__  . mysql_error(); exit; }
				}
				
				// remove old entry
				$sql = "select unix_timestamp(timestamp) from $new_group_table order by timestamp desc limit $new_num_rows,1";
				$result = $xoopsDB->query( $sql );
				if ( $result == false ){ echo __LINE__  . mysql_error(); exit; }
				if ( $result != false && $xoopsDB->getRowsNum( $result ) != 0 ){
					list( $timestamp ) = $xoopsDB->fetchRow( $result );
					$sql = "delete from $new_group_table where unix_timestamp(timestamp) < $timestamp";
					$result = $xoopsDB->queryF( $sql );
					if ( $result == false ){ echo __LINE__  . mysql_error(); exit; }
				}
			}
		}
	}
}

// xoops timeout -> xoonips timeout
function xnpGcSession(){
	global $xoopsDB, $xoopsConfig;
	
	// xoops session timeout -> remove xoonips session
	$sql = "select xs.sess_id, uid, su_uid from " . $xoopsDB->prefix('xoonips_session') . " as xs "
		. " left join " . $xoopsDB->prefix('session') . " as s on xs.sess_id=s.sess_id "
		. " where s.sess_id is NULL ";
	$result = $xoopsDB->query( $sql );
	$expire_time =  time()+(60 * $xoopsConfig['session_expire']);
	
	while ( list( $sess_id, $uid, $su_uid ) = $xoopsDB->fetchRow( $result ) ){
		if ( $su_uid )
			xnp_insert_event( $sess_id, ETID_END_SU, $expire_time, $uid, "", array( 'uid'=>$su_uid ) );
		xnp_insert_event( $sess_id, ETID_LOGOUT, $expire_time, $uid, "", array() );
		
		$xoopsDB->queryF( "delete from " . $xoopsDB->prefix('xoonips_session') . " where sess_id='".addslashes($sess_id)."'" );
	}
}

/*
* Function to redirect a user to certain pages
* not to add $xoopsRequestUri
*/
function xnpRedirectHeader($url, $time = 3, $message = '', $addredirect = true)
{
    global $xoopsConfig, $xoopsRequestUri;
    if (preg_match("/[\\0-\\31]/", $url) || preg_match("/^(javascript|vbscript|about):/i", $url)) {
        $url = XOOPS_URL;
    }
    if (!defined('XOOPS_CPFUNC_LOADED')) {
        require_once XOOPS_ROOT_PATH.'/class/template.php';
        $xoopsTpl = new XoopsTpl();
        $xoopsTpl->assign('sitename', htmlspecialchars($xoopsConfig['sitename'], ENT_QUOTES));
        $xoopsTpl->assign('langcode', _LANGCODE);
        $xoopsTpl->assign('charset', _CHARSET);
        $xoopsTpl->assign('time', $time);
        /*
		if ($addredirect && strstr($url, 'user.php')) {
            if (!strstr($url, '?')) {
                $url .= '?xoops_redirect='.urlencode($xoopsRequestUri);
            } else {
                $url .= '&amp;xoops_redirect='.urlencode($xoopsRequestUri);
            }
        }
		*/
        if (defined('SID') && (! isset($_COOKIE[session_name()]) || ($xoopsConfig['use_mysession'] && $xoopsConfig['session_name'] != '' && !isset($_COOKIE[$xoopsConfig['session_name']])))) {
            if (!strstr($url, '?')) {
                $url .= '?' . SID;
            }
            else {
                $url .= '&amp;'.SID;
            }
        }
        $url = preg_replace("/&amp;/i", '&', htmlspecialchars($url, ENT_QUOTES));
        $xoopsTpl->assign('url', $url);
        $message = trim($message) != '' ? $message : _TAKINGBACK;
        $xoopsTpl->assign('message', $message);
        $xoopsTpl->assign('lang_ifnotreload', sprintf(_IFNOTRELOAD, $url));
        $GLOBALS['xoopsModuleUpdate'] = 1;
        $xoopsTpl->display('db:system_redirect.html');
        exit();
    } else {
        $url = preg_replace("/&amp;/i", '&', htmlspecialchars($url, ENT_QUOTES));
        echo '
        <html>
        <head>
        <title>'.htmlspecialchars($xoopsConfig['sitename']).'</title>
        <meta http-equiv="Content-Type" content="text/html; charset='._CHARSET.'" />
        <meta http-equiv="Refresh" content="'.$time.'; url='.$url.'" />
        <style type="text/css">
                body {background-color : #fcfcfc; font-size: 12px; font-family: Trebuchet MS,Verdana, Arial, Helvetica, sans-serif; margin: 0px;}
                .redirect {width: 70%; margin: 110px; text-align: center; padding: 15px; border: #e0e0e0 1px solid; color: #666666; background-color: #f6f6f6;}
                .redirect a:link {color: #666666; text-decoration: none; font-weight: bold;}
                .redirect a:visited {color: #666666; text-decoration: none; font-weight: bold;}
                .redirect a:hover {color: #999999; text-decoration: underline; font-weight: bold;}
        </style>
        </head>
        <body>
        <div align="center">
        <div class="redirect">
          <span style="font-size: 16px; font-weight: bold;">'.$message.'</span>
          <hr style="height: 3px; border: 3px #E18A00 solid; width: 95%;" />
          <p>'.sprintf(_IFNOTRELOAD, $url).'</p>
        </div>
        </div>
        </body>
        </html>';
    }
    exit();
}


?>
