<?php
//  $Revision: 1.12.2.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';

include 'condefs.php';
include_once 'include/lib.php';
require_once 'include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];
if (is_object($xoopsUser))
	$uid = $xoopsUser->getVar('uid');
else
	$uid = UID_GUEST;

$config_handler =& xoops_gethandler('config');
$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
$xoopsOption['template_main'] = 'xoonips_index.html';
include './header.php';

// record events(insert member)
xnp_insert_event( $xnpsid, ETID_VIEW_TOP_PAGE, time(), $uid, xnpGetRemoteHost(), array() );

// exit at here if guest can't access /Public tree
if( !xnp_is_valid_session_id( $_SESSION['XNPSID'] ) ){
    include XOOPS_ROOT_PATH.'/footer.php';
    return;
}

// get blocks
$itemtypes = array();
if( xnp_get_item_types( $itemtypes ) != RES_OK ){
	redirect_header('index.php', 3, "ERROR xnp_get_item_types [AbstractLayer]".xnp_get_last_error_string());
	break;
}
$blocks = array();
$cnt = 0;
foreach ( $itemtypes as $dummy => $itemtype ){
	$modname = $itemtype['name'];
	if ( $itemtype['viewphp'] == ''
	     || !file_exists( XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp']) )
		continue;
	include_once XOOPS_ROOT_PATH . '/modules/' . $itemtype['viewphp'];
	$funcname = $modname."GetTopBlock";
	if ( function_exists( $funcname ) )
		$blocks[] = $funcname( $itemtype );
	$cnt++;
}

if ($cnt > 1) {
	$result = array(); 
	$moduleTable = $xoopsDB->prefix('modules'); 
	$itemtypeTable = $xoopsDB->prefix('xoonips_item_type');
	$sql = "select weight,dirname from $moduleTable,$itemtypeTable where $moduleTable.mid=$itemtypeTable.mid and dirname like 'xnp%' order by weight asc, $moduleTable.mid";
	$result = $xoopsDB->query($sql); 
	while ( list($weight) = $xoopsDB->fetchRow($result) ){ 
		$order[] = $weight; 
	} 
	array_multisort($order,$blocks); 

	$xoopsTpl->assign('blocks', $blocks );
}

$xoopsTpl->assign( 'xoonips_editprofile_url', XOOPS_URL . '/modules/xoonips/edituser.php?uid=' . $uid );
include XOOPS_ROOT_PATH.'/footer.php';
?>
