<?php
//  page for search metadata                                                    //
//  $Revision: 1.12.2.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //
/** 
 * @param op : 'detail' 
 * @param repository_id, identifier : repository_id and identifier of metadata
 * @param params : parameters for itemselect.php
 */
$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';

include_once 'condefs.php';
include_once 'include/lib.php';
include_once 'include/create_session.php';

xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

// If not a user, redirect
if( $xnpsid != 0 ){
    if ( !$xoopsUser ) {
        redirect_header('index.php',3,_MD_XOONIPS_ITEM_FORBIDDEN);
        exit();
    }

    $uid = $_SESSION['xoopsUserId'];

    //can't use uncertified user(expect XOOPS administrator)
    if( !$xoopsUser->isAdmin( $xoopsModule->getVar('mid') )
        && !xnp_is_activated( $xnpsid, $uid ) ){
        redirect_header('index.php', 3, _MD_XOONIPS_MODERATOR_NOT_ACTIVATED);
        exit();
    }
}
else {
    if( !xnp_is_valid_session_id($xnpsid) ){
        // User is guest group, and guest isn't admitted to access the page.
        // -> display login block.
        redirect_header(XOOPS_URL.'/modules/xoonips/user.php',3,_MD_XOONIPS_ITEM_FORBIDDEN);
        exit();
    }
    $uid = 0;
}

foreach( array( 
  'op'            => '',
  'repository_id' => 0,
  'identifier'    => 0,
  'params'        => '',
                 ) as $k => $v ){
    if( array_key_exists( $k, $_GET ) ){
        $$k = $_GET[$k];
    }else if( array_key_exists( $k, $_POST ) ){
        $$k = $_POST[$k];
    }else{
        $$k = $v;
    }
}


$config_handler =& xoops_gethandler('config');
$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
$xoopsOption['template_main'] = 'xoonips_metadata_search.html';
include XOOPS_ROOT_PATH.'/header.php';

// http://jp.php.net/manual/ja/function.utf8-decode.php 
// from morris_hirsch at hotmail dot com 19-Aug-2003 01:43

function numeric_entify_utf8 ($utf8_string) {

  $out = "";
  $ns = strlen ($utf8_string);
  for ($nn = 0; $nn < $ns; $nn++) {
   $ch = $utf8_string [$nn];
   $ii = ord ($ch);

//1 7 0bbbbbbb (127)

   if ($ii < 128) $out .= $ch;

//2 11 110bbbbb 10bbbbbb (2047)

   else if ($ii >>5 == 6) {
  $b1 = ($ii & 31);

  $nn++;
   $ch = $utf8_string [$nn];
   $ii = ord ($ch);
  $b2 = ($ii & 63);

  $ii = ($b1 * 64) + $b2;

     $ent = sprintf ("&#%d;", $ii);
     $out .= $ent;
   }

//3 16 1110bbbb 10bbbbbb 10bbbbbb

   else if ($ii >>4 == 14) {
  $b1 = ($ii & 31);

  $nn++;
   $ch = $utf8_string [$nn];
   $ii = ord ($ch);
  $b2 = ($ii & 63);

  $nn++;
   $ch = $utf8_string [$nn];
   $ii = ord ($ch);
  $b3 = ($ii & 63);

  $ii = ((($b1 * 64) + $b2) * 64) + $b3;

     $ent = sprintf ("&#%d;", $ii);
     $out .= $ent;
   }

//4 21 11110bbb 10bbbbbb 10bbbbbb 10bbbbbb

   else if ($ii >>3 == 30) {
  $b1 = ($ii & 31);

  $nn++;
   $ch = $utf8_string [$nn];
   $ii = ord ($ch);
  $b2 = ($ii & 63);

  $nn++;
   $ch = $utf8_string [$nn];
   $ii = ord ($ch);
  $b3 = ($ii & 63);

  $nn++;
   $ch = $utf8_string [$nn];
   $ii = ord ($ch);
  $b4 = ($ii & 63);

  $ii = ((((($b1 * 64) + $b2) * 64) + $b3) * 64) + $b4;

     $ent = sprintf ("&#%d;", $ii);
     $out .= $ent;
   }

  }
  return $out;
}

// http://jp.php.net/manual/ja/function.html-entity-decode.php 
// from php dot net at c dash ovidiu dot tk 18-Mar-2005 05:37
function replace_num_entity($ord)
{
    $ord = $ord[1];
    if (preg_match('/^x([0-9a-f]+)$/i', $ord, $match))
        $ord = hexdec($match[1]);
    else
        $ord = intval($ord);
   
    $no_bytes = 0;
    $byte = array();

    if ($ord < 128)          return chr($ord);
    elseif ($ord < 2048)     $no_bytes = 2;
    elseif ($ord < 65536)    $no_bytes = 3;
    elseif ($ord < 1114112)  $no_bytes = 4;
    else                     return;

    switch($no_bytes)
    {
        case 2: $prefix = array(31, 192); break;
        case 3: $prefix = array(15, 224); break;
        case 4: $prefix = array(7, 240);
    }

    for ($i = 0; $i < $no_bytes; $i++)
        $byte[$no_bytes - $i - 1] = (($ord & (63 * pow(2, 6 * $i))) / pow(2, 6 * $i)) & 63 | 128;

    $byte[0] = ($byte[0] & $prefix[0]) | $prefix[1];

    $ret = '';
    for ($i = 0; $i < $no_bytes; $i++)
        $ret .= chr($byte[$i]);

    return $ret;
}

function decode_entities($text) {
   $text = preg_replace_callback('/&#([0-9a-fx]+);/mi', 'replace_num_entity', $text);
   return $text;
}


// utf8 + numeric character reference -> utf8
function dec( $str ){
//    return html_entity_decode ( $str, ENT_QUOTES, 'UTF-8' ); // delete
    return decode_entities( $str );
}

// utf8 -> numeric character reference
function enc( $str ){
    return numeric_entify_utf8( $str );
    //return htmlentities( $str, ENT_QUOTES, 'UTF-8' );
}


$table_data = $xoopsDB->prefix( 'xoonips_oaipmh_metadata' );
$table_repo = $xoopsDB->prefix( 'xoonips_oaipmh_repositories' );

if ( $op == '' ){
    // don't search
}
else if ( $op == 'detail' ){
    // get metadatas from database
    $escIdentifier = addslashes( $identifier );
    $repository_id = (int)$repository_id;
    $sql = "select metadata from ${table_data} where identifier='$escIdentifier' and repository_id=$repository_id ";
    $result = $xoopsDB->query( $sql );
    list( $metadata ) = $xoopsDB->fetchRow( $result );
	$metadata = encodeServer2Meta( $metadata );
    
    // analyze metadata
    $index = array(); $vals = array();
    $xml_parser = xml_parser_create( 'UTF-8' );
    xml_parser_set_option($xml_parser,XML_OPTION_SKIP_WHITE,1);
    xml_parse_into_struct($xml_parser,$metadata,$vals,$index);
    xml_parser_free( $xml_parser );
    
    $detail = array();
    foreach ( $vals as $val ){
        if ( $val['type'] == 'complete' ){
            $ar = array();
            $ar['tag'] = enc(nl2br(htmlspecialchars(dec( $val['tag'] ), ENT_QUOTES, 'UTF-8')));
            $ar['value'] = enc(nl2br(htmlspecialchars(dec( $val['value'] ), ENT_QUOTES, 'UTF-8')));
            if ( strtolower($val['tag']) == 'identifier' ){
                $pattern = "/(s?https?:\\/\\/[-_.!~*'\\(\\)a-zA-Z0-9;\\/?:\\@&=+\$,%#]+)/";  // for detail,see http://www.din.or.jp/~ohzaki/perl.htm#httpURL
                $ar['value'] = preg_replace( $pattern, "<a href='\\1'>\\1</a>", $ar['value'] );
            }
            
            $detail[] = $ar;
        }
    }
    $xoopsTpl->assign( 'detail', $detail );
    
    // convert from string like a "a=b&c=d&..." to associative array
    $keyvals = array();
    $params = explode( '&', $params );
    foreach ( $params as $param ){
        $ar = explode( '=', $param );
        $keyvals[] = array( 'name' => $ar[0], 'value' => xnpHtmlspecialchars($ar[1]) );
    }
    $xoopsTpl->assign( 'params', $keyvals );
}

include XOOPS_ROOT_PATH.'/footer.php';
?>
