<?php
// $Id: registeruser.php,v 1.22.2.1 2007/03/22 05:25:07 tani Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
//  Modified like below for XooNIps                                          //
//  - XooNIps user information form and parameter check is added(2005/5/18)  //
//  - XooNIps event of account is added(2005/7/7)                            //
//  - Send e-mail for moderator(2006/9/5)                                    //
//  ------------------------------------------------------------------------ //

$xoopsOption['pagetype'] = 'user';

include '../../mainfile.php';
include_once 'include/lib.php';
require_once 'include/create_session.php';
xnp_load_init_create_session();

$myts =& MyTextSanitizer::getInstance();

$config_handler =& xoops_gethandler('config');
$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);

if (empty($xoopsConfigUser['allow_register'])) {
	redirect_header('index.php', 6, _US_NOREGISTER);
	exit();
}

function userCheck($uname, $email, $pass, $vpass, $notice_mail)
{
	global $xoopsConfigUser;
	$xoopsDB =& Database::getInstance();
	$myts =& MyTextSanitizer::getInstance();
	$stop = '';
	if ( !checkEmail($email) ) {
		$stop .= _US_INVALIDMAIL.'<br />';
	}
	foreach ($xoopsConfigUser['bad_emails'] as $be) {
		if ( !empty($be) && preg_match("/".$be."/i", $email) ) {
			$stop .= _US_INVALIDMAIL.'<br />';
			break;
		}
	}
	if ( strrpos($email,' ') > 0 ) {
		$stop .= _US_EMAILNOSPACES.'<br />';
	}
	$uname = xoops_trim($myts->oopsStripSlashesGPC($uname));
	switch ( $xoopsConfigUser['uname_test_level'] ) {
	case 0:
		// strict
		$restriction = '/[^a-zA-Z0-9\_\-]/';
		break;
	case 1:
		// medium
		$restriction = '/[^a-zA-Z0-9\_\-\<\>\,\.\$\%\#\@\!\\\'\"]/';
		break;
	case 2:
		// loose
		$restriction = '/[\000-\040]/';
		break;
	}
	if (empty($uname) || preg_match($restriction, $uname)) {
		$stop .= _US_INVALIDNICKNAME."<br />";
	}
	if ( strlen($uname) > $xoopsConfigUser['maxuname'] ) {
		$stop .= sprintf(_US_NICKNAMETOOLONG, $xoopsConfigUser['maxuname'])."<br />";
	}
	if ( strlen($uname) < $xoopsConfigUser['minuname'] ) {
		$stop .= sprintf(_US_NICKNAMETOOSHORT, $xoopsConfigUser['minuname'])."<br />";
	}
	foreach ($xoopsConfigUser['bad_unames'] as $bu) {
		if ( !empty($bu) && preg_match("/".$bu."/i", $uname) ) {
			$stop .= _US_NAMERESERVED."<br />";
			break;
		}
	}
	if ( strrpos($uname,' ') > 0 ) {
		$stop .= _US_NICKNAMENOSPACES."<br />";
	}
	$sql = "SELECT COUNT(*) FROM ".$xoopsDB->prefix('users')." WHERE uname='".addslashes($uname)."'";
	$result = $xoopsDB->query($sql);
	list($count) = $xoopsDB->fetchRow($result);
	if ( $count > 0 ) {
		$stop .= _US_NICKNAMETAKEN."<br />";
	}
	$count = 0;
	if ( $email ) {
		$sql = "SELECT COUNT(*) FROM ".$xoopsDB->prefix('users')." where email='".$myts->makeTboxData4Save($email)."'";
		$result = $xoopsDB->query($sql);
		list($count) = $xoopsDB->fetchRow($result);
		if ( $count > 0 ) {
			$stop .= _US_EMAILTAKEN."<br />";
		}
	}
	if ( !isset($pass) || $pass == '' || !isset($vpass) || $vpass == '' ) {
		$stop .= _US_ENTERPWD.'<br />';
	}
	if ( (isset($pass)) && ($pass != $vpass) ) {
		$stop .= _US_PASSNOTSAME.'<br />';
	} elseif ( ($pass != '') && (strlen($pass) < $xoopsConfigUser['minpass']) ) {
		$stop .= sprintf(_US_PWDTOOSHORT,$xoopsConfigUser['minpass'])."<br />";
	}
	if ( $notice_mail < 0 ){
		$stop .= _MD_XOONIPS_ACCOUNT_NOTICE_MAIL_TOO_LITTLE.'<br />';
	}
	return $stop;
}

foreach( array( 'op' => 'register',
                'agree_disc' => null,
                'uname' => null,
                'realname' => null,
                'email' => null,
                'pass' => null,
                'vpass' => null,
                'user_mailok' => 0,
                'address' => null,
                'division' => null,
                'tel' => null,
                'company_name' => null,
                'country' => null,
                'zipcode' => null,
                'fax' => null,
                'notice_mail' => 0,
                'url' => null,
                'timezone_offset' => null,
                'user_viewemail' => null ) as $k => $v ){
    if( array_key_exists( $k, $_GET ) ){
        $$k = $_GET[$k];
    }else if( array_key_exists( $k, $_POST ) ){
        $$k = $_POST[$k];
    }else{
        $$k = $v;
    }
}

switch ( $op ) {
case 'newuser':
	require( XOOPS_ROOT_PATH.'/header.php' );
	if ($xoopsConfigUser['reg_dispdsclmr'] != 0 && $xoopsConfigUser['reg_disclaimer'] != '') {
		if (empty($agree_disc)) {
			redirect_header('registeruser.php', 5, _US_UNEEDAGREE);
			exit();
		}
	}
	$uname = trim($uname);
	$email = trim($email);
	$pass = trim($pass);
	$vpass = trim($vpass);
	
	$division     = trim($division     );
	$company_name = trim($company_name );
	$tel          = trim($tel          );
	$fax          = trim($fax          );
	$address      = trim($address      );
	$country      = trim($country      );
	$zipcode      = trim($zipcode      );
	$notice_mail  = (int)$notice_mail;
	
	$stop = userCheck($uname, $email, $pass, $vpass, $notice_mail);

    // acquire required flags of XooNIps user information
    $val='';
    $required = array();
    foreach( 
        array( 'realname' => _US_REALNAME,
               'address' => _MD_XOONIPS_ACCOUNT_ADDRESS,
               'division' => _MD_XOONIPS_ACCOUNT_DIVISION,
               'tel' => _MD_XOONIPS_ACCOUNT_TEL,
               'company_name' => _MD_XOONIPS_ACCOUNT_COMPANY_NAME,
               'country' => _MD_XOONIPS_ACCOUNT_COUNTRY,
               'zipcode' => _MD_XOONIPS_ACCOUNT_ZIPCODE,
               'fax' => _MD_XOONIPS_ACCOUNT_FAX ) as $k => $v ){
        if( xnp_get_config_value( "account_${k}_optional", $val ) == RES_OK ){
            if( $val != 'on' && ${$k} == '' ){
                $stop = $stop . sprintf( _MD_XOONIPS_ACCOUNT_MUST_BE_FILLED_IN, $v ) . "<br />\n";
            }
        }else{
            if( ${$k} == '' ){
                $stop = $stop . sprintf( _MD_XOONIPS_ACCOUNT_MUST_BE_FILLED_IN, $v ) . "<br />\n";
            }
        }
    }
    
	$errors = array();
	if ( strlen($division    ) > 255 ) $errors[] = _MD_XOONIPS_ACCOUNT_REG_TOO_LONG_DIVISION    ;
	if ( strlen($company_name) > 255 ) $errors[] = _MD_XOONIPS_ACCOUNT_REG_TOO_LONG_COMPANY_NAME;
	if ( strlen($tel         ) > 32  ) $errors[] = _MD_XOONIPS_ACCOUNT_REG_TOO_LONG_TEL         ;
	if ( strlen($fax         ) > 32  ) $errors[] = _MD_XOONIPS_ACCOUNT_REG_TOO_LONG_FAX         ;
	if ( strlen($address     ) > 255 ) $errors[] = _MD_XOONIPS_ACCOUNT_REG_TOO_LONG_ADDRESS     ;
	if ( strlen($country     ) > 255 ) $errors[] = _MD_XOONIPS_ACCOUNT_REG_TOO_LONG_COUNTRY     ;
	if ( strlen($zipcode     ) > 32  ) $errors[] = _MD_XOONIPS_ACCOUNT_REG_TOO_LONG_ZIPCODE     ;
	if ( count($errors) != 0 )
		$stop = $stop . implode("<br />\n", $errors) . "<br />\n";
	
	if ( empty($stop) ) {
//		OpenTable();
		echo _US_USERNAME.": ".$myts->makeTboxData4Preview($uname)."<br />";
		echo _US_EMAIL.": ".$myts->makeTboxData4Preview($email)."<br />";
		//if ( $user_avatar != '' ) {
		//	echo _US_AVATAR.": <img src='uploads/".$user_avatar."' alt='' /><br />";
		//}
		if ( isset($url) && $url != '' ) {
			$url = formatURL($myts->makeTboxData4Preview($url));
			echo _US_WEBSITE.": $url<br />";
		}
		$f_timezone = ($timezone_offset < 0) ? 'GMT '.$timezone_offset : 'GMT +'.$timezone_offset;
		echo _US_TIMEZONE.": $f_timezone<br />";
		
		//@@@ display user information in XNP
		echo _MD_XOONIPS_ACCOUNT_ADDRESS      .": ".$myts->makeTboxData4Preview($address      )."<br />";
		echo _MD_XOONIPS_ACCOUNT_DIVISION     .": ".$myts->makeTboxData4Preview($division     )."<br />";
		echo _MD_XOONIPS_ACCOUNT_COMPANY_NAME .": ".$myts->makeTboxData4Preview($company_name )."<br />";
		echo _MD_XOONIPS_ACCOUNT_TEL          .": ".$myts->makeTboxData4Preview($tel          )."<br />";
		echo _MD_XOONIPS_ACCOUNT_FAX          .": ".$myts->makeTboxData4Preview($fax          )."<br />";
		echo _MD_XOONIPS_ACCOUNT_ADDRESS      .": ".$myts->makeTboxData4Preview($address      )."<br />";
		echo _MD_XOONIPS_ACCOUNT_COUNTRY      .": ".$myts->makeTboxData4Preview($country      )."<br />";
		echo _MD_XOONIPS_ACCOUNT_ZIPCODE      .": ".$myts->makeTboxData4Preview($zipcode      )."<br />";
		echo _MD_XOONIPS_ACCOUNT_NOTICE_MAIL  .": ".$myts->makeTboxData4Preview($notice_mail  )."<br />";
		
		echo "<form action='registeruser.php' method='post'>
		<input type='hidden' name='realname' value='".$myts->makeTboxData4PreviewInForm($realname)."' />
		<input type='hidden' name='uname' value='".$myts->makeTboxData4PreviewInForm($uname)."' />
		<input type='hidden' name='email' value='".$myts->makeTboxData4PreviewInForm($email)."' />";
		//echo "<input type='hidden' name='user_avatar' value='".$myts->makeTboxData4PreviewInForm($user_avatar)."' />";
		$user_viewemail = isset($user_viewemail) ? intval($user_viewemail) : 0;
		echo "<input type='hidden' name='user_viewemail' value='".$user_viewemail."' />
		<input type='hidden' name='url' value='".$myts->makeTboxData4PreviewInForm($url)."' />
		<input type='hidden' name='pass' value='".$myts->makeTboxData4PreviewInForm($pass)."' />
		<input type='hidden' name='vpass' value='".$myts->makeTboxData4PreviewInForm($vpass)."' />
		<input type='hidden' name='division' value='".$myts->makeTboxData4PreviewInForm($division)."' />
		<input type='hidden' name='company_name' value='".$myts->makeTboxData4PreviewInForm($company_name)."' />
		<input type='hidden' name='tel' value='".$myts->makeTboxData4PreviewInForm($tel)."' />
		<input type='hidden' name='fax' value='".$myts->makeTboxData4PreviewInForm($fax)."' />
		<input type='hidden' name='address' value='".$myts->makeTboxData4PreviewInForm($address)."' />
		<input type='hidden' name='country' value='".$myts->makeTboxData4PreviewInForm($country)."' />
		<input type='hidden' name='zipcode' value='".$myts->makeTboxData4PreviewInForm($zipcode)."' />
		<input type='hidden' name='timezone_offset' value='".(float)$timezone_offset."' />
		<input type='hidden' name='notice_mail' value='".intval($notice_mail)."' />
		<input type='hidden' name='user_mailok' value='".intval($user_mailok)."' />";
        
		$value = '';
		xnp_get_config_value( 'private_item_number_limit', $value );
		echo "\n<input type='hidden' name='private_item_number_limit' value='${value}' />\n";
        
		$value = '';
		xnp_get_config_value( 'private_item_storage_limit', $value );
        echo "<input type='hidden' name='private_item_storage_limit' value='${value}' />\n";
        
		$value = '';
		xnp_get_config_value( 'private_index_number_limit', $value );
        echo "<input type='hidden' name='private_index_number_limit' value='${value}' />\n";
        
		echo "<br /><br /><input type='hidden' name='op' value='finish' /><input type='submit' value='". _US_FINISH ."' /></form>";
//		CloseTable();
	} else {
		echo "<span style='color:#ff0000;'>$stop</span>";
		echo "<br />" . _MD_XOONIPS_ACCOUNT_EXPLAIN_REQUIRED_MARK. "<br />\n";
		include 'include/registerform.php';
		$reg_form->display();
	}
	require( XOOPS_ROOT_PATH.'/footer.php' );
	break;
case 'finish':
	require( XOOPS_ROOT_PATH.'/header.php' );
	require_once 'include/create_session.php';
	xnp_load_init_create_session();
	$xnpsid = $_SESSION['XNPSID'];
	
	$uname = trim($uname);
	$email = trim($email);
	$pass = trim($pass);
	$vpass = trim($vpass);
	
	
	//@@@XNP
	$division     = trim($division    );
	$company_name = trim($company_name);
	$tel          = trim($tel         );
	$fax          = trim($fax         );
	$address      = trim($address     );
	$country      = trim($country     );
	$zipcode      = trim($zipcode     );
	$notice_mail  = (int)$notice_mail;
	
	$stop = userCheck($uname, $email, $pass, $vpass, $notice_mail);
	if ( empty($stop) ) {
		$member_handler =& xoops_gethandler('member');
		$newuser =& $member_handler->createUser();
		if ( isset($user_viewemail) ) {
			$newuser->setVar('user_viewemail',$user_viewemail);
		}
		if ( isset($attachsig) ) {
			$newuser->setVar('attachsig',$attachsig);
		}
		$realname = isset($realname) ? $realname : '';
		$newuser->setVar('name', $realname);
		$newuser->setVar('uname', $uname);
		$newuser->setVar('email', $email);
		if ( isset($url) && $url!='' ) {
			$newuser->setVar('url', formatURL($url));
		}

		$newuser->setVar('user_avatar','blank.gif');
		$actkey = substr(md5(uniqid(mt_rand(), 1)), 0, 8);
		$newuser->setVar('actkey',$actkey);
		$newuser->setVar('pass', md5($pass));
		$newuser->setVar('timezone_offset', $timezone_offset);
		$newuser->setVar('user_regdate', time());
		$newuser->setVar('uorder',$xoopsConfig['com_order']);
		$newuser->setVar('umode',$xoopsConfig['com_mode']);
		$newuser->setVar('user_mailok',$user_mailok);
		if ($xoopsConfigUser['activation_type'] == 1) {
			$newuser->setVar('level', 1);
		}
		
		if (!$member_handler->insertUser($newuser)) {
			echo _US_REGISTERNG;
			require( XOOPS_ROOT_PATH.'/footer.php' );
			exit();
		}
		
		// get default value of limits
		$private_item_number_limit  = '';
		$private_index_number_limit = '';
		$private_item_storage_limit = '';
		xnp_get_config_value( "private_item_number_limit" , $private_item_number_limit  );
		xnp_get_config_value( "private_index_number_limit", $private_index_number_limit );
		xnp_get_config_value( "private_item_storage_limit", $private_item_storage_limit );
		
		if ( $private_item_number_limit == ""  ) $private_item_number_limit  = 'NULL';
		else                                     $private_item_number_limit  = (int)   $private_item_number_limit;
		if ( $private_index_number_limit == "" ) $private_index_number_limit = 'NULL';
		else                                     $private_index_number_limit = (int)   $private_index_number_limit;
		if ( $private_item_storage_limit == "" ) $private_item_storage_limit = 'NULL';
		else                                     $private_item_storage_limit = (double)$private_item_storage_limit;
		
		// position value = Registered Users
		$posi = '';
		$potab = $xoopsDB -> prefix("xoonips_positions");
		$posql = "SELECT posi_id FROM ".$potab." WHERE posi_title='Registered Users'";
		$pores = $xoopsDB -> query( $posql );
		// there is no title 'Registered Users' in xoonips_positions => posi = 0
		if ( $pores == FALSE ){
			echo "ERROR: SQL=$posql<br />\n error=" . $xoopsDB -> error() . "<br />\n";
		}
		$po = $xoopsDB -> fetchArray( $pores );
		$posi = intval( $po['posi_id'] );
				
		// add user information in XNP
		$table = $xoopsDB->prefix("xoonips_users");
		$uid = $newuser->getVar('uid');
		$xoonips_keys = array(
			'division'     ,
			'company_name' ,
			'tel'          ,
			'fax'          ,
			'address'      ,
			'country'      ,
			'zipcode'      ,
			'notice_mail'  
		);
		$keys = implode( ',', $xoonips_keys );
		//$val_ar = $xoonips_keys;
		//function addslasher( &$val ){ global $$val, $myts; $val = "'" . $myts->addSlashes( $$val ) . "'"; }
		//array_walk( $val_ar, 'addslasher' );
		
		$val_ar = array();
		foreach ( $xoonips_keys as $key ){
			$val_ar[] = "'" . $myts->addSlashes( $$key ) . "'";
		}
		$vals = implode( ',', $val_ar );
		$sql = "replace $table ( uid, $keys, notice_mail_since, private_item_number_limit, private_index_number_limit, private_item_storage_limit, posi ) ".
		               "values ( $uid, $vals, UNIX_TIMESTAMP(NOW()),$private_item_number_limit,$private_index_number_limit,$private_item_storage_limit,$posi )";
		if ( mysql_query( $sql ) == FALSE ){
			echo _US_REGISTERNG;
			require( XOOPS_ROOT_PATH.'/footer.php' );
			exit();
		}
		
		// insert uid into xoonips_item_show
		$isql = "SELECT item_id FROM ".$xoopsDB->prefix('xoonips_item_status')."";
		$ires = $xoopsDB->query($isql);
			if(!$ires){
				$err = "Can't select data from database.";
			}
			if($ires == FALSE){
				echo "ERROR: SQL=$isql<br />\n error=" . $xoopsDB->error() . "<br />\n";
			}
			$ins_iids = array();
			while( $irow = $xoopsDB->fetchArray($ires) ){
				$ins_iids[] = intval( $irow['item_id'] );
			}
			if( !empty( $ins_iids ) ){
				foreach( $ins_iids as $itemnum => $itid ){
					$ins_sql = "INSERT INTO ".$xoopsDB->prefix('xoonips_item_show')." (item_id, uid) VALUES (".$itid.", ".$uid.")";
					$ins_res = $xoopsDB->query($ins_sql);
					if(!$ins_res) {
					$err = "Can't select data from database.";
					}
					if($ins_res == FALSE) {
						echo "ERROR: SQL=$ins_sql<br />\n error=" . $xoopsDB->error() . "<br />\n";
					}
				}
			}
		
		// record events(request insert account)
		xnp_insert_event( XNPSID_GUEST, ETID_REQUEST_INSERT_ACCOUNT, time(), UID_GUEST, xnpGetRemoteHost(), array( 'uid' => $uid ) );
		
		//Activate Platform user automatically
		$value = '';
		if( xnp_get_config_value( 'certify_user', $value ) == RES_OK ){
			if( $value == 'auto' ){
				$result = xnp_activate( $xnpsid, $uid, true );
				if ( $result == RES_OK ){
					// record events(request cerify account)
					xnp_insert_event( XNPSID_GUEST, ETID_CERTIFY_ACCOUNT, time(), UID_GUEST, xnpGetRemoteHost(), array( 'uid' => $uid ) );
				}else{
					echo _MD_XOONIPS_ACCOUNT_ACTIVATE_NG . "(result=${result})";
					require( XOOPS_ROOT_PATH.'/footer.php' );
					exit();
				}
			}
		}else{
			echo _MD_XOONIPS_ACCOUNT_ACTIVATE_NG;
			require( XOOPS_ROOT_PATH.'/footer.php' );
			exit();
		}
		
		// create private index
		$myts =& MyTextSanitizer::getInstance();
		$escUname = $myts->addSlashes( $uname );
		$table = $xoopsDB->prefix( 'xoonips_item_basic' );
		$success = false;
		if ( $xoopsDB->queryF( "insert into $table ( item_type_id, uid, title, creation_date ) ".
			" values ( 1, $uid, '$escUname', unix_timestamp(now())) " ) ){
			
			// get sort_number
			$index_id = $xoopsDB->getInsertId();
			$table = $xoopsDB->prefix( 'xoonips_index' );
			$result = $xoopsDB->query( "select min(index_id) from $table where parent_index_id = 1 and open_level = 3 " );
			if ( $result ){
				list( $sort_number ) = $xoopsDB->fetchRow($result);
				$sort_number = (int)$sort_number - 1;
				if ( $sort_number == -1 )
					$sort_number = 2147483647; // MAX_INT-1
				if ( $xoopsDB->queryF( "insert into $table (index_id,parent_index_id,uid,gid,open_level,sort_number) ".
					" values ( $index_id, 1, $uid, NULL, 3, $sort_number ) " ) ){
					$table = $xoopsDB->prefix( 'xoonips_users' );
					if ( $xoopsDB->queryF( "update $table set private_index_id = $index_id where uid = $uid " ) ){
						// add data into item_table
						$item_title_table = $xoopsDB->prefix( 'xoonips_item_title' );
						if ( $xoopsDB->query( "insert into $item_title_table (item_id, title_id, title) values ($index_id, 0, '$escUname')" ) ){
							$success = true;
						}
					}
				}
			}
		}
		if ( $success == false ){
			echo _US_REGISTERNG;
			require( XOOPS_ROOT_PATH.'/footer.php' );
			exit();
		}
		
		
		// add to DEFAULT_GROUP
		$table = $xoopsDB->prefix( 'xoonips_groups_users_link' );
		$xoopsDB->query( "insert into $table ( gid, uid, is_admin ) values ( 1, $uid, 0 )" );
		
		
		$newid = $newuser->getVar('uid');
		if (!$member_handler->addUserToGroup(XOOPS_GROUP_USERS, $newid)) {
			echo _US_REGISTERNG;
			require( XOOPS_ROOT_PATH.'/footer.php' );
			exit();
		}
        // 
        // get config value of certify_user
        // 
		$certify_user = null;// certify user auto or manual ( XooNIps )
		if( xnp_get_config_value( 'certify_user', $certify_user ) != RES_OK ){
			redirect_header('index.php',3,"xnp_get_config_value failed(certify_user)");
		}
        // 
		if ($xoopsConfigUser['activation_type'] == 0) {// activate xoops account by user
			$myts =& MyTextSanitizer::getInstance();
			$xoopsMailer =& getMailer();
			$xoopsMailer->useMail();
			$xoopsMailer->setTemplateDir(XOOPS_ROOT_PATH."/modules/xoonips/language/".$xoopsConfig['language']."/mail_template/" );
            
			if( $certify_user == "on" ){
				$xoopsMailer->setTemplate('xoonips_activate_by_user_certify_manual.tpl');
			}else{
				$xoopsMailer->setTemplate('xoonips_activate_by_user_certify_auto.tpl');
			}
			$xoopsMailer->assign('X_UACTLINK', XOOPS_URL."/modules/xoonips/user.php?op=actv&id=".$newuser->getVar('uid')."&actkey=".$newuser -> getVar( 'actkey' ) );
			$xoopsMailer->assign('SITENAME', $xoopsConfig['sitename']);
			$xoopsMailer->assign('ADMINMAIL', $xoopsConfig['adminmail']);
			$xoopsMailer->assign('SITEURL', XOOPS_URL."/");
			$xoopsMailer->setToUsers(new XoopsUser($newuser->getVar('uid')));
			$xoopsMailer->setFromEmail($xoopsConfig['adminmail']);
			$xoopsMailer->setFromName($xoopsConfig['sitename']);
			$xoopsMailer->setSubject(sprintf(_MD_XOONIPS_ACTIVATE_KEY_SUBJECT,$myts->oopsStripSlashesGPC($uname)));
//			OpenTable();
			if ( !$xoopsMailer->send() ) {
				echo _US_YOURREGMAILNG;
			} else {
				if( $certify_user == "on" ){
                    echo _MD_XOONIPS_ACTIVATE_BY_USER_CERTIFY_MANUAL;
                }else{
                    echo _MD_XOONIPS_ACTIVATE_BY_USER_CERTIFY_AUTO;
                }
			}
//			CloseTable();
		}else if ($xoopsConfigUser['activation_type'] == 1) { // activate xoops account automatically

			//To send a e-mail to users who are belong to the group specified by moderator_gid if certify_user is 'manual' 
			if( xnp_get_config_value( 'moderator_gid', $moderator_gid ) == RES_OK ){
				if( $certify_user == "on" ){
					$myts =& MyTextSanitizer::getInstance();
					$xoopsMailer =& getMailer();
					$xoopsMailer->useMail();
					$member_handler =& xoops_gethandler('member');
					$xoopsMailer->setTemplateDir(XOOPS_ROOT_PATH."/modules/xoonips/language/".$xoopsConfig['language']."/mail_template/" );
					$xoopsMailer->setTemplate('xoonips_certify_manual.tpl');
					$xoopsMailer->assign('USERNAME', $myts->oopsStripSlashesGPC($uname));
					$xoopsMailer->assign('USEREMAIL', $myts->oopsStripSlashesGPC($email));
					$xoopsMailer->assign('USERACTLINK', XOOPS_URL.'/modules/xoonips/certifyuser.php' );
					$xoopsMailer->assign('USERINFOLINK', XOOPS_URL.'/modules/xoonips/userinfo.php?uid='. $newuser->getVar('uid') );
					$xoopsMailer->assign('SITENAME', $xoopsConfig['sitename']);
					$xoopsMailer->assign('ADMINMAIL', $xoopsConfig['adminmail']);
					$xoopsMailer->assign('SITEURL', XOOPS_URL."/");
					$xoopsMailer->setToGroups($member_handler->getGroup($moderator_gid));
					$xoopsMailer->setFromEmail($xoopsConfig['adminmail']);
					$xoopsMailer->setFromName($xoopsConfig['sitename']);
					$xoopsMailer->setSubject(_MD_XOONIPS_ACCOUNT_REGISTERD);
					if( !$xoopsMailer->send() ){
						echo _MD_XOONIPS_ACTIVATE_AUTO_CERTIFY_MANUAL_MAILNG;
					}else{
						echo _MD_XOONIPS_ACTIVATE_AUTO_CERTIFY_MANUAL;
					}
				}else{
					redirect_header( 'user.php', 5, _MD_XOONIPS_ACTIVATE_AUTO_CERTIFY_AUTO, false );
				}
			}else{
				echo 'ERROR: moderator group is not specified';
			}
		} else if ($xoopsConfigUser['activation_type'] == 2) { //activate xoops accunt by xoops administrator
			$myts =& MyTextSanitizer::getInstance();
			$xoopsMailer =& getMailer();
			$xoopsMailer->useMail();
			$xoopsMailer->setTemplate('adminactivate.tpl');
			$xoopsMailer->assign('USERNAME', $myts->oopsStripSlashesGPC($uname));
			$xoopsMailer->assign('USEREMAIL', $myts->oopsStripSlashesGPC($email));
			$xoopsMailer->assign('USERACTLINK', XOOPS_URL."/modules/xoonips/user.php?op=actv&id=".$newuser->getVar('uid')."&actkey=".$newuser -> getVar( 'actkey' ) );
			$xoopsMailer->assign('SITENAME', $xoopsConfig['sitename']);
			$xoopsMailer->assign('ADMINMAIL', $xoopsConfig['adminmail']);
			$xoopsMailer->assign('SITEURL', XOOPS_URL."/");
			$member_handler =& xoops_gethandler('member');
			$xoopsMailer->setToGroups($member_handler->getGroup($xoopsConfigUser['activation_group']));
			$xoopsMailer->setFromEmail($xoopsConfig['adminmail']);
			$xoopsMailer->setFromName($xoopsConfig['sitename']);
			$xoopsMailer->setSubject(sprintf(_MD_XOONIPS_ACTIVATE_KEY_SUBJECT,$myts->oopsStripSlashesGPC($uname)));
			if ( !$xoopsMailer->send() ) {
				echo _MD_XOONIPS_ACTIVATE_BY_ADMIN_MAILNG;
			} else {
				if( $certify_user == "on" ){
                    echo _MD_XOONIPS_ACTIVATE_BY_ADMIN_CERTIFY_MANUAL;
                }else{
                    echo _MD_XOONIPS_ACTIVATE_BY_ADMIN_CERTIFY_AUTO;
                }
			}
		}

		// send e-mail to XOOPS Admin
		if ($xoopsConfigUser['activation_type'] != 1
			&& $xoopsConfigUser['new_user_notify'] == 1
			&& !empty($xoopsConfigUser['new_user_notify_group'])) {
			$myts =& MyTextSanitizer::getInstance();
			$xoopsMailer =& getMailer();
			$xoopsMailer->useMail();
			$member_handler =& xoops_gethandler('member');
			$xoopsMailer->setToGroups($member_handler->getGroup($xoopsConfigUser['new_user_notify_group']));
			$xoopsMailer->setFromEmail($xoopsConfig['adminmail']);
			$xoopsMailer->setFromName($xoopsConfig['sitename']);
			$xoopsMailer->setSubject(sprintf(_US_NEWUSERREGAT,$xoopsConfig['sitename']));
			$xoopsMailer->setBody(sprintf(_US_HASJUSTREG,$myts->oopsStripSlashesGPC($uname)));
			$xoopsMailer->send();
		}
	} else {
		echo "<span style='color:#ff0000; font-weight:bold;'>$stop</span>";
		include 'include/registerform.php';
		$reg_form->display();
	}
	require( XOOPS_ROOT_PATH.'/footer.php' );
	break;
case 'register':
default:
	require( XOOPS_ROOT_PATH.'/header.php' );
	//OpenTable();
	echo "<br />" . _MD_XOONIPS_ACCOUNT_EXPLAIN_REQUIRED_MARK. "<br />\n";
	include 'include/registerform.php';
	$reg_form->display();
		
	//CloseTable();
	require( XOOPS_ROOT_PATH.'/footer.php');
	break;
}
?>
