<?php
//  $Revision: 1.4.2.1 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //


$xoopsOption['pagetype'] = "pmsg";
include '../../mainfile.php';

include 'condefs.php';
include_once 'include/lib.php';
require_once 'include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];

// If not a user, redirect
if( $xnpsid != 0 ){
    if ( !$xoopsUser ) {
        redirect_header(XOOPS_URL.'/index.php',3,_MD_XOONIPS_ITEM_FORBIDDEN);
        exit();
    }

    $uid = $_SESSION['xoopsUserId'];

//Uncertified user can't access(except XOOPS administrator).
    if( !$xoopsUser->isAdmin( $xoopsModule->getVar('mid') )
        && !xnp_is_activated( $xnpsid, $uid ) ){
        redirect_header(XOOPS_URL.'/index.php', 3, _MD_XOONIPS_MODERATOR_NOT_ACTIVATED);
        exit();
    }
}

$config_handler =& xoops_gethandler('config');
$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
xoops_header(false);

?>
</head>
<body>
<table border="0" cellspacing="0" cellpadding="0">
 <tr>
  <td id="side_navi">
    <div id="leftcolumn">	          
<?php
$xoopsConfig['nocommon']='';
require_once 'header.php';

require_once '../../class/template.php';
require_once 'blocks/xoonips_blocks.php';

$xoopsModule =& XoopsModule::getByDirname("xoonips");
//print_r($xoopsModule);

$mod_blocks =& XoopsBlock::getByModule($xoopsModule->getVar('mid'));
//print_r($blocks);
$blocks = array();
//copy only necessary block from mod_block to blocks.
foreach( $mod_blocks as $b ){
    if( $b -> getVar( 'mid' ) == $xoopsModule -> getVar( 'mid' ) ){
        if( $b -> getVar( 'show_func' ) == 'b_xoonips_quick_search_show'
            || $b -> getVar( 'show_func' ) == 'b_xoonips_tree_show' ){
            $blocks[$b -> getVar( 'show_func' )] = $b;
        }
    }
}

?>
   <div class="blockTitle"><?php echo $blocks['b_xoonips_tree_show'] -> getVar('title'); ?></div>
   <div class="blockContent">
   <table cellspacing="0">
    <tr>
     <td>
<?php

$tpl = new xoopsTpl();
$block = $blocks['b_xoonips_tree_show'] -> buildBlock();
$block['query'] = "url=related_to_subwin.php";
$tpl->assign('block', $block );
echo $tpl->fetch( "db:xoonips_block_tree.html" );
?>
     </td>
    </tr>
   </table>
   </div>

   <div class="blockTitle"><?php echo $blocks['b_xoonips_quick_search_show'] -> getVar('title'); ?></div>
   <div class="blockContent">
   <table cellspacing="0">
    <tr>
     <td>
<?php
$tpl = new xoopsTpl();
$bl = $blocks['b_xoonips_quick_search_show'] -> buildBlock();
$bl['url'] = XOOPS_URL . "/modules/xoonips/related_to_subwin.php";
$tpl->assign('block', $bl );
echo $tpl->fetch(  "db:xoonips_block_quick_search.html" );
?>
     </td>
    </tr>
   </table>
   </div>
   </div>
  </td>
  <td>
<?php
$xoopsTpl = new XoopsTpl();
$_POST['op']='index';
include "itemselect_body.php";
$xoopsTpl->display( "db:xoonips_related_to_itemselect.html" );
xoops_footer();
?>
  </td>
 </tr>
</table>

<?php
xoops_footer();
?>
