<?php
// $Id: show.php,v 1.0
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';

$op = 'main';

if ( isset($_POST['op']) ) {
    $op = trim($_POST['op']);
} elseif ( isset($_GET['op']) ) {
    $op = trim($_GET['op']);
}

if ($op == 'main') {
    if ( !$xoopsUser ) {
        $xoopsOption['template_main'] = 'xoonips_userform.html';
        include '../../header.php';
        if (isset($_COOKIE[$xoopsConfig['usercookie']])) {
            $xoopsTpl->assign('usercookie', $_COOKIE[$xoopsConfig['usercookie']]);                
        }
        if (isset($_GET['xoops_redirect'])) {
            $xoopsTpl->assign('redirect_page', htmlspecialchars(trim($_GET['xoops_redirect']), ENT_QUOTES));
        }
        include '../../footer.php';
    } elseif ( $xoopsUser ) {
        header('Location: '.XOOPS_URL.'/modules/xoonips/showusers.php?uid='.$xoopsUser->getVar('uid'));
    }
    exit();
}

if ($op == 'login') {
    require_once 'include/create_session.php';
    xnp_load_al();
    include_once XOOPS_ROOT_PATH.'/modules/xoonips/include/checklogin.php';
    exit();
}

if ($op == 'logout') {
    // Platformlogout
    require_once 'include/create_session.php';
    xnp_load_init_create_session();
    $xnpsid = (int)$_SESSION['XNPSID'];
    if ( $xnpsid ){
        xnp_logout_user( $xnpsid );
    }
    
    // ɤΥƥࡦåˤϢʤե
    require_once('include/lib.php');
    xnpCleanup(); 
    
    // ٥ȤεϿ(logout)
    if ( isset($_SESSION['xoopsUserId']) ){ // logoutڡɤ$_SESSIONˤʤΤǡξϽ
        xnp_insert_event( $xnpsid, ETID_LOGOUT, time(), $_SESSION['xoopsUserId'], xnpGetRemoteHost(), array() );
    }
    
    // ̤logout
    $message = '';
    $_SESSION = array();
    session_destroy();
    if ($xoopsConfig['use_mysession'] && $xoopsConfig['session_name'] != '') {
        setcookie($xoopsConfig['session_name'], '', time()- 3600, '/',  '', 0);
    }
    // clear autologin cookies
    //setcookie('autologin_uname', '', time() - 3600, '/', '', 0);
    //setcookie('autologin_pass', '', time() - 3600, '/', '', 0);
    // clear entry from online users table
    if (is_object($xoopsUser)) {
        $online_handler =& xoops_gethandler('online');
        $online_handler->destroy($xoopsUser->getVar('uid'));
    }
    $message = _US_LOGGEDOUT.'<br />'._US_THANKYOUFORVISIT;
    redirect_header(XOOPS_URL.'/index.php', 1, $message);
    
    exit();
}

if ($op == 'lostpass') {
	// _US_* -> xnpaccount_userform.html
	require_once(XOOPS_ROOT_PATH.'/language/'.$xoopsConfig['language'].'/user.php');
	
	// ѥʶΥڡۤuser.phpήѡ
	$xoopsOption['template_main'] = 'xoonips_userform.html';
	require(XOOPS_ROOT_PATH.'/header.php');
	require(XOOPS_ROOT_PATH.'/footer.php');
	exit();
}

?>