<?php
//  $Revision: 1.2 $                                                                  //
//  --------------------------------------------------------------------------  //
//  XooNIps Xoops modules for Neuroinformatics Platforms                        //
//  Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       //
//  http://sourceforge.jp/projects/xoonips/                                     //
//  --------------------------------------------------------------------------  //
//  This program is free software; you can redistribute it and/or               //
//  modify it under the terms of the GNU General Public License                 //
//  as published by the Free Software Foundation; either version 2              //
//  of the License, or (at your option) any later version.                      //
//                                                                              //
//  This program is distributed in the hope that it will be useful,             //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of              //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               //
//  GNU General Public License for more details.                                //
//                                                                              //
//  You should have received a copy of the GNU General Public License           //
//  along with this program; if not, write to the Free Software                 //
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. //
//  --------------------------------------------------------------------------  //

$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';

// reject non-xoops-admin
if ( $xoopsUser ) {
    if ( !$xoopsUser->isAdmin(-1) && !isset($_SESSION['xoonips_old_uid']) ) {
        redirect_header("index.php",2,_MD_XOONIPS_ITEM_FORBIDDEN);
        exit();
    }
} else {
    redirect_header("index.php",2,_MD_XOONIPS_ITEM_FORBIDDEN);
    exit();
}

include 'condefs.php';
include_once 'include/lib.php';
include_once 'include/imexport.php';
require_once 'include/create_session.php';
xnp_load_init_create_session();
$xnpsid = $_SESSION['XNPSID'];
$uid = $_SESSION['xoopsUserId'];

foreach( array( 'op' => '',
                'su_uid' => 0, 
                'password' => '' ) as $k => $v ){
    if( array_key_exists( $k, $_GET ) ){
        $$k = $_GET[$k];
    }else if( array_key_exists( $k, $_POST ) ){
        $$k = $_POST[$k];
    }else{
        $$k = $v;
    }
}

// change uid.  
// don't preserve old uid.
function xoonips_change_uid( $su_uid ){
	$u = new XoopsUser($su_uid);
	$groupids = $u->getGroups();
	$_SESSION['xoopsUserId'] = $su_uid;
	$_SESSION["xoopsUserGroups"] = $groupids;
}

if ( $op == '' ){
	if ( isset($_SESSION['xoonips_old_uid']) ){
		redirect_header( 'index.php', 0, '' ); // already in su-mode
		exit();
	}
	
	$xoopsOption['template_main'] = 'xoonips_su.html';
	include './header.php';
	$users = array();
	$uids = array();
	xnp_dump_uids( $xnpsid, array(), $uids );
	xnp_get_accounts( $xnpsid, $uids, array(), $users );
	// Sort by user account name
	foreach($users as $key=>$values){
		$unameValues[$key] = $values['uname'];
	}
	$users_sort = $users;
	array_multisort($unameValues, SORT_ASC, $users_sort);
	// Send variables to templete
	$xoopsTpl->assign('users',  $users_sort);
	$xoopsTpl->assign('su_uid', $su_uid);
	include XOOPS_ROOT_PATH.'/footer.php';
}
else if ( $op == 'su' ){
	// check admin password
	$sql = "select uid from " . $xoopsDB->prefix('users') . " where uid=$uid and pass='".md5($password)."'";
	$result = $xoopsDB->query($sql);
	if ( $result == FALSE || $xoopsDB->getRowsNum($result) == 0 ){
		redirect_header( 'su.php', 3, _MD_XOONIPS_SU_FAIL );
		exit();
	}
	
	// su
	$_SESSION['xoonips_old_uid'] = $uid;
	xoonips_change_uid( $su_uid );
	
	$sql = "update " . $xoopsDB->prefix('xoonips_session') . " set su_uid=$su_uid where sess_id='".addslashes(session_id())."'";
	$xoopsDB->queryF( $sql );
	
	xnp_insert_event( $xnpsid, ETID_START_SU, time(), $uid, xnpGetRemoteHost(), array( 'uid' => $su_uid ) );
	
	
	redirect_header( 'index.php', 3, _MD_XOONIPS_SU_START );
	exit();
}
if ( $op == 'end' ){
	if ( isset($_SESSION['xoonips_old_uid']) ){
		xnp_insert_event( $xnpsid, ETID_END_SU, time(), $_SESSION['xoonips_old_uid'], xnpGetRemoteHost(), array( 'uid' => $uid ) );
		
		$sql = "update " . $xoopsDB->prefix('xoonips_session') . " set su_uid=null where sess_id='".addslashes(session_id())."'";
		$xoopsDB->queryF( $sql );
		
		xoonips_change_uid( $_SESSION['xoonips_old_uid'] );
		$_SESSION['xoonips_old_uid'] = null;
		
		redirect_header( 'index.php', 3, _MD_XOONIPS_SU_END );
		exit();
	}
	else {
		redirect_header( 'index.php', 0, '' ); // now in su-mode
		exit();
	}
}


?>
