<?php
// $Id: userinfo.php,v 1.10 2006/09/22 09:03:38 tani Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

$xoopsOption['pagetype'] = 'user';
include '../../mainfile.php';
include_once XOOPS_ROOT_PATH.'/class/module.textsanitizer.php';

include_once XOOPS_ROOT_PATH . '/modules/system/constants.php';

require_once 'include/create_session.php';
require_once 'include/lib.php';
xnp_load_init_create_session(  );
$xnpsid = $_SESSION['XNPSID'];

if( !isset( $xoopsUser ) || !$xoopsUser ){
    // Guest桼Υ϶ػ
    // redirect_header(XOOPS_URL.'/index.php',3,_MD_XOONIPS_ITEM_FORBIDDEN);
	$_SESSION["back_url"] = $_SERVER["REQUEST_URI"];
	xnpRedirectHeader( 'user.php', 3, _MD_XOONIPS_ITEM_FORBIDDEN );
    exit();
}

$uid = 0;
if ( isset( $_GET['uid'] ) )
	$uid = intval($_GET['uid']);

if ($uid <= 0) {
    if ( $xoopsUser ) {
        //Next, try to retrive a UID from a xoopsUser.
        $uid=$xoopsUser->getVar('uid');
    }else{
        redirect_header(XOOPS_URL.'/index.php',3,_US_SELECTNG);
    	exit();
    }
}

//error if argument 'uid' is not equal to own UID
if( xnp_is_moderator( $xnpsid, $_SESSION['xoopsUserId'] ) || $xoopsUser->isAdmin( $xoopsModule->getVar( 'mid' ) ) );
else if( $uid != $_SESSION['xoopsUserId'] ){
	redirect_header(XOOPS_URL.'/index.php', 3, _NOPERM);
}

$gperm_handler = & xoops_gethandler( 'groupperm' );
$groups = ( $xoopsUser ) ? $xoopsUser -> getGroups() : XOOPS_GROUP_ANONYMOUS;

$isAdmin = $gperm_handler->checkRight( 'system_admin', XOOPS_SYSTEM_USER, $groups);			// isadmin is true if user has 'edit users' admin rights

if (is_object($xoopsUser)) {
	if ($uid == $xoopsUser->getVar('uid')) {
		$config_handler =& xoops_gethandler('config');
		$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
		$xoopsOption['template_main'] = 'xoonips_userinfo.html';
		include XOOPS_ROOT_PATH.'/header.php';
		$xoopsTpl->assign('user_ownpage', true);
		$xoopsTpl->assign('lang_editprofile', _US_EDITPROFILE);
		$xoopsTpl->assign('lang_avatar', _US_AVATAR);
		$xoopsTpl->assign('lang_inbox', _US_INBOX);
		$xoopsTpl->assign('lang_logout', _US_LOGOUT);
		if ($xoopsConfigUser['self_delete'] == 1) {
			$xoopsTpl->assign('user_candelete', true);
			$xoopsTpl->assign('lang_deleteaccount', _US_DELACCOUNT);
		} else {
			$xoopsTpl->assign('user_candelete', false);
		}
		$thisUser =& $xoopsUser;
	} else {
		$member_handler =& xoops_gethandler('member');
		$thisUser =& $member_handler->getUser($uid);
		if (!is_object($thisUser) || !$thisUser->isActive() ) {
			redirect_header( "certifyuser.php", 3, _US_NOACTTPADM ); // this error occurs when user isn't finising activate in XOOPS.
			exit();
		}
		$xoopsOption['template_main'] = 'xoonips_userinfo.html';
		include XOOPS_ROOT_PATH.'/header.php';
		$xoopsTpl->assign('user_ownpage', false);
	}
} else {
	$member_handler =& xoops_gethandler('member');
	$thisUser =& $member_handler->getUser($uid);
	if (!is_object($thisUser) || !$thisUser->isActive()) {
		redirect_header( "certifyuser.php", 3, _US_NOACTTPADM );
		exit();
	}
	$xoopsOption['template_main'] = 'xoonips_userinfo.html';
	include(XOOPS_ROOT_PATH.'/header.php');
	$xoopsTpl->assign('user_ownpage', false);
}
$myts =& MyTextSanitizer::getInstance();
if ( is_object($xoopsUser) && $isAdmin ) {
	$xoopsTpl->assign('lang_editprofile', _US_EDITPROFILE);
	$xoopsTpl->assign('lang_deleteaccount', _US_DELACCOUNT);
	$xoopsTpl->assign('user_uid', $thisUser->getVar('uid'));
}
$xoopsTpl->assign('lang_allaboutuser', sprintf(_US_ALLABOUT,$thisUser->getVar('uname')));
$xoopsTpl->assign('lang_avatar', _US_AVATAR);
$xoopsTpl->assign('user_avatarurl', '../../uploads/'.$thisUser->getVar('user_avatar'));
$xoopsTpl->assign('lang_realname', _US_REALNAME);
$xoopsTpl->assign('user_realname', $thisUser->getVar('name'));
$xoopsTpl->assign('lang_website', _US_WEBSITE);
$xoopsTpl->assign('user_websiteurl', '<a href="'.$thisUser->getVar('url', 'E').'" target="_blank">'.$thisUser->getVar('url').'</a>');
$xoopsTpl->assign('lang_email', _US_EMAIL);
$xoopsTpl->assign('lang_privmsg', _US_PM);
$xoopsTpl->assign('lang_icq', _US_ICQ);
$xoopsTpl->assign('user_icq', $thisUser->getVar('user_icq'));
$xoopsTpl->assign('lang_aim', _US_AIM);
$xoopsTpl->assign('user_aim', $thisUser->getVar('user_aim'));
$xoopsTpl->assign('lang_yim', _US_YIM);
$xoopsTpl->assign('user_yim', $thisUser->getVar('user_yim'));
$xoopsTpl->assign('lang_msnm', _US_MSNM);
$xoopsTpl->assign('user_msnm', $thisUser->getVar('user_msnm'));
$xoopsTpl->assign('lang_location', _US_LOCATION);
$xoopsTpl->assign('user_location', $thisUser->getVar('user_from'));
$xoopsTpl->assign('lang_occupation', _US_OCCUPATION);
$xoopsTpl->assign('user_occupation', $thisUser->getVar('user_occ'));
$xoopsTpl->assign('lang_interest', _US_INTEREST);
$xoopsTpl->assign('user_interest', $thisUser->getVar('user_intrest'));
$xoopsTpl->assign('lang_extrainfo', _US_EXTRAINFO);
$xoopsTpl->assign('user_extrainfo', $myts->makeTareaData4Show($thisUser->getVar('bio', 'N'),0,1,1));
$xoopsTpl->assign('lang_statistics', _US_STATISTICS);
$xoopsTpl->assign('lang_membersince', _US_MEMBERSINCE);
$xoopsTpl->assign('user_joindate', formatTimestamp($thisUser->getVar('user_regdate'),'s'));
$xoopsTpl->assign('lang_rank', _US_RANK);
$xoopsTpl->assign('lang_posts', _US_POSTS);
$xoopsTpl->assign('lang_basicInfo', _US_BASICINFO);
$xoopsTpl->assign('lang_more', _US_MOREABOUT);
$xoopsTpl->assign('lang_myinfo', _US_MYINFO);
$xoopsTpl->assign('user_posts', $thisUser->getVar('posts'));
$xoopsTpl->assign('lang_lastlogin', _US_LASTLOGIN);
$xoopsTpl->assign('lang_notregistered', _US_NOTREGISTERED);

$xoopsTpl->assign('lang_signature', _US_SIGNATURE);
$xoopsTpl->assign('user_signature', $myts->makeTareaData4Show($thisUser->getVar('user_sig', 'N'),0,1,1));

// The user information on XNP is acquired from uid, and it is an output.
{
	$ts =& MyTextSanitizer::getInstance();
	$table = $xoopsDB->prefix("xoonips_users");
	//$uid = $xoopsUser->getVar('uid');
	$sql = "select * from $table where uid=$uid";
	$result = mysql_query( $sql );
	if ( $result != FALSE && mysql_num_rows($result) != 0 ){
		$xoopsTpl->assign('xnp_user_ownpage', true);
		$row = mysql_fetch_assoc( $result );
		reset( $row );
		while ( list( $key, $val ) = each( $row ) ){
			if( $key == "posi" ) {
				$idp = intval($val);
				$tabp = $xoopsDB->prefix("xoonips_positions");
				$sqlp = "SELECT posi_title FROM $tabp WHERE posi_id=$idp";
				$resp = mysql_query( $sqlp );
				$rowp = mysql_fetch_assoc( $resp );
				$xoopsTpl->assign('xnp_user_posi_t', $rowp['posi_title']);
			}
			else if( $key == "appeal" ) {
				$sap = $myts->makeTareaData4Show($val,0,1,1);
				$xoopsTpl->assign('xnp_user_appeal', $sap);
			}
			else {
			$xoopsTpl->assign( "xnp_user_$key", $ts->htmlSpecialChars($val) );
			//echo "($key $val)";
			}
		}
        mysql_free_result( $result );
	}
	else {
		$xoopsTpl->assign('xnp_user_ownpage', false);
		//echo $sql . mysql_error();
	}
}


if ($thisUser->getVar('user_viewemail') == 1) {
	$xoopsTpl->assign('user_email', $thisUser->getVar('email', 'E'));
} else {
	if (is_object($xoopsUser)) {
	 	// All admins will be allowed to see emails, even those that are not allowed to edit users (I think it's ok like this)
		if ($xoopsUser->isAdmin() || ($xoopsUser->getVar("uid") == $thisUser->getVar("uid"))) {
			$xoopsTpl->assign('user_email', $thisUser->getVar('email', 'E'));
		} else {
			$xoopsTpl->assign('user_email', '&nbsp;');
		}
	}
}
if (is_object($xoopsUser)) {
	$xoopsTpl->assign('user_pmlink', "<a href=\"javascript:openWithSelfMain('".XOOPS_URL."/pmlite.php?send2=1&amp;to_userid=".$thisUser->getVar('uid')."', 'pmlite', 450, 380);\"><img src=\"".XOOPS_URL."/images/icons/pm.gif\" alt=\"".sprintf(_SENDPMTO,$thisUser->getVar('uname'))."\" /></a>");
} else {
	$xoopsTpl->assign('user_pmlink', '');
}
$userrank =& $thisUser->rank();
if ($userrank['image']) {
	$xoopsTpl->assign('user_rankimage', '<img src="'.XOOPS_UPLOAD_URL.'/'.$userrank['image'].'" alt="" />');
}
$xoopsTpl->assign('user_ranktitle', $userrank['title']);
$date = $thisUser->getVar("last_login");
if (!empty($date)) {
	$xoopsTpl->assign('user_lastlogin', formatTimestamp($date,"m"));
}

// To show Curriculum Vitae
// Get date of Curriculum Vitae
$tab_cv = $xoopsDB->prefix("xoonips_cvitaes");
$sql_cv = "SELECT * FROM ".$tab_cv." WHERE uid=".$uid." ORDER BY cvitae_order ASC, from_year ASC, from_month ASC";
$res_cv = $xoopsDB->query($sql_cv);
		if ( $res_cv == FALSE ){
			echo "ERROR: SQL=$sql<br>\n error=" . $xoopsDB -> error() . "<br>\n";
		}
while( $row_cv = $xoopsDB->fetchArray($res_cv) ){
	$bedata["cvitae_from_month"] = $row_cv["from_month"] != 0 ? intval($row_cv["from_month"]) : 0;
	$bedata["cvitae_from_year" ] = $row_cv["from_year" ] != 0 ? intval($row_cv["from_year" ]) : 0;
	$bedata["cvitae_to_month"  ] = $row_cv["to_month"  ] != 0 ? intval($row_cv["to_month"  ]) : 0;
	$bedata["cvitae_to_year"   ] = $row_cv["to_year"   ] != 0 ? intval($row_cv["to_year"   ]) : 0;
	
	if( $bedata["cvitae_from_month"] !== 0 ){
		$cvdata["cvitae_from_month"] = date("M.", mktime(0, 0, 0, $bedata["cvitae_from_month"], 1, 0));
	} else {
		$cvdata["cvitae_from_month"] = '';
	}
	if( $bedata["cvitae_from_year"] !== 0 ){
		$cvdata["cvitae_from_year"] = date("Y", mktime(0, 0, 0, 1, 1, $bedata["cvitae_from_year"]));
	} else {
		$cvdata["cvitae_from_year"] = '';
	}
	if( $bedata["cvitae_to_month"] !== 0 ){
		$cvdata["cvitae_to_month"] = date("M.", mktime(0, 0, 0, $bedata["cvitae_to_month"], 1, 0));
	} else {
		$cvdata["cvitae_to_month"] = '';
	}
	if( $bedata["cvitae_to_year"] !== 0 ){
		$cvdata["cvitae_to_year"] = date("Y", mktime(0, 0, 0, 1, 1, $bedata["cvitae_to_year"]));
	} else {
		$cvdata["cvitae_to_year"] = '';
	}
	$cvdata["cvitae_title"] = $myts -> makeTboxData4Show($row_cv["cvitae_title"]);
	
	$xoopsTpl->append("cv_array", $cvdata);
}


$module_handler =& xoops_gethandler('module');
$criteria = new CriteriaCompo(new Criteria('hassearch', 1));
$criteria->add(new Criteria('isactive', 1));
$mids =& array_keys($module_handler->getList($criteria));

foreach ($mids as $mid) {
    // Hack by marcan : only return results of modules for which user has access permission
  if ( $gperm_handler->checkRight('module_read', $mid, $groups)) {
	$module =& $module_handler->get($mid);
	$results =& $module->search('', '', 5, 0, $thisUser->getVar('uid'));
	$count = count($results);
	if (is_array($results) && $count > 0) {
		for ($i = 0; $i < $count; $i++) {
			if (isset($results[$i]['image']) && $results[$i]['image'] != '') {
				$results[$i]['image'] = 'modules/'.$module->getVar('dirname').'/'.$results[$i]['image'];
			} else {
				$results[$i]['image'] = 'images/icons/posticon2.gif';
			}
			$results[$i]['link'] = 'modules/'.$module->getVar('dirname').'/'.$results[$i]['link'];
			$results[$i]['title'] = $myts->makeTboxData4Show($results[$i]['title']);
			$results[$i]['time'] = $results[$i]['time'] ? formatTimestamp($results[$i]['time']) : '';
		}
		if ($count == 5) {
			$showall_link = '<a href="search.php?action=showallbyuser&amp;mid='.$mid.'&amp;uid='.$thisUser->getVar('uid').'">'._US_SHOWALL.'</a>';
		} else {
			$showall_link = '';
		}
		$xoopsTpl->append('modules', array('name' => $module->getVar('name'), 'results' => $results, 'showall_link' => $showall_link));
	}
	unset($module);
  }
}
include XOOPS_ROOT_PATH.'/footer.php';
?>