/*
 * excel2xoonips - A data convertor from Excel data to XooNIps import file
 *
 * Copyright (C) 2007  RIKEN Japan, All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libsl4.h"
#include "cexcel.h"
#include "excel2xoonips.h"

sl4_string_t *tmpl_array_get( const char *text, strarray_t * options,
                              int is_required )
{
  sl4_string_t *str;
  size_t len;
  str = sl4_string_new( NULL );
  if ( str == NULL ) {
    ERROR_OUTMEM(  );
  }
  len = strlen( text );
  if ( len == 0 ) {
    if ( is_required ) {
      /* empty cell data */
      sl4_string_delete( str );
      return NULL;
    }
  } else {
    sl4_string_t *tag, *start_tag, *end_tag, *tmp1, *tmp2;
    size_t pos;
    tag = strarray_get( options, 0 );
    start_tag = sl4_string_new( NULL );
    end_tag = sl4_string_new( NULL );
    tmp1 = sl4_string_new( text );
    if ( start_tag == NULL || end_tag == NULL || tmp1 == NULL ) {
      ERROR_OUTMEM(  );
    }
    if ( sl4_string_sprintf( start_tag, "<%s>", sl4_string_get( tag ) ) !=
         0
         || sl4_string_sprintf( end_tag, "</%s>",
                                sl4_string_get( tag ) ) != 0 ) {
      ERROR_OUTMEM(  );
    }
    pos = 0;
    tmp2 = sl4_string_tokenize( tmp1, "\n", &pos );
    while ( tmp2 != NULL ) {
      sl4_string_trim( tmp2 );
      if ( sl4_string_empty( tmp2 ) == 0 ) {
        sl4_string_htmlspecialchars( tmp2 );
        /* append string */
        if ( sl4_string_append( str, sl4_string_get( start_tag ) ) != 0 ||
             sl4_string_append( str, sl4_string_get( tmp2 ) ) != 0 ||
             sl4_string_append( str, sl4_string_get( end_tag ) ) != 0 ) {
          ERROR_OUTMEM(  );
        }
      }
      sl4_string_delete( tmp2 );
      tmp2 = sl4_string_tokenize( tmp1, "\n", &pos );
    }
    sl4_string_delete( tmp1 );
    if ( sl4_string_empty( str ) ) {
      if ( is_required ) {
        /* empty cell data */
        sl4_string_delete( start_tag );
        sl4_string_delete( end_tag );
        sl4_string_delete( str );
        return NULL;
      }
      /* insert empty tag */
      if ( sl4_string_append( str, sl4_string_get( start_tag ) ) != 0 ||
           sl4_string_append( str, sl4_string_get( end_tag ) ) != 0 ) {
        ERROR_OUTMEM(  );
      }
    }
    sl4_string_delete( start_tag );
    sl4_string_delete( end_tag );
  }
  return str;
}
