<?php
// $Revision: 1.7.4.1.2.13 $
// ------------------------------------------------------------------------- //
//  XooNIps - Neuroinformatics Base Platform System                          //
//  Copyright (C) 2005-2008 RIKEN, Japan All rights reserved.                //
//  http://xoonips.sourceforge.jp/                                           //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //

include 'include/common.inc.php';
include 'class/base/gtickets.php';
 
$myuid = is_object( $xoopsUser ) ? $xoopsUser->getVar( 'uid', 'n' ) : UID_GUEST;

$formdata =& xoonips_getutility( 'formdata' );

xoonips_deny_guest_access();

$op = $formdata->getValue( 'both', 'op', 's', false, 'list' );
if ( ! in_array( $op, array( 'list', 'modify', 'update' ) ) ) {
  die( 'illegal request' );
}

$xmember_handler =& xoonips_gethandler( 'xoonips', 'member' );
$xgroup_handler =& xoonips_gethandler( 'xoonips', 'group' );

// get group ids
$is_admin = $xmember_handler->isAdmin( $myuid );
if ( $is_admin ) {
  $gids = $xgroup_handler->getGroupIds();
} else {
  $gids = $xgroup_handler->getGroupIds( $uid, true );
}
if ( count( $gids ) == 0 ) {
  die( 'illegal request' );
}

// token ticket area
$ticket_area = 'xoonips_groupadmin_update';

$breadcrumbs = array();
$breadcrumbs[] = array( 'name' => _MI_XOONIPS_ACCOUNT_PANKUZU_GROUP_ADMINISTRATOR );
$breadcrumbs[] = array( 'name' => _MI_XOONIPS_ACCOUNT_PANKUZU_EDIT_GROUPS, 'url' => XOOPS_URL.'/modules/xoonips/groupadmin.php' );
switch ( $op ) {
case 'list':
  $xg_objs =& $xgroup_handler->getGroupObjects( $gids );
  $groups = array();
  foreach ( $xg_objs as $xg_obj ) {
    $gid = $xg_obj->get( 'gid' );
    $groups[] = array(
      'gid' => $gid,
      'gname' => $xg_obj->getVar( 'gname', 's' ),
      'gdesc' => $xg_obj->getVar( 'gdesc', 's' ),
      'link' => XOOPS_URL.'/modules/xoonips/groupadmin.php?op=modify&amp;gid='.$gid
    );
  }
  // title
  $title = _MD_XOONIPS_ACCOUNT_GROUPADMIN_GROUP_LIST;
  break;
case 'update':
  if ( ! $xoopsGTicket->check( true, $ticket_area, false ) ) {
    exit();
  }
  $gid = $formdata->getValue( 'post', 'gid', 'i', true );
  $mode = $formdata->getValue( 'post', 'mode', 's', true );
  $uids = $formdata->getValueArray( 'post', 'uids', 'i', false, array() );
  // check administrative group id
  if ( ! in_array( $gid, $gids ) ) {
    die( 'illegal request' );
  }
  // check mode
  if ( ! in_array( $mode, array( 'add', 'del' ) ) ) {
    die( 'illegal request' );
  }
  $u_handler =& xoonips_getormhandler( 'xoonips', 'xoops_users' );
  foreach ( $uids as $uid ) {
    // check user existance
    // TODO: implement user handler
    $join = new XooNIpsJoinCriteria( 'xoonips_users', 'uid', 'uid', 'INNER', 'xu' );
    $criteria = new CriteriaCompo( new Criteria( 'uid', $uid, '=', 'xu' ) );
    $criteria->add( new Criteria( 'level', 0, '>' ) );
    $criteria->add( new Criteria( 'activate', 1, '=', 'xu' ) );
    $u_objs =& $u_handler->getObjects( $criteria, false, '', false, $join );
    if ( count( $u_objs ) == 0 ) {
      die( 'illegal request' );
    }
    // check requested user is group administrator
    if ( $xgroup_handler->isGroupAdmin( $uid, $gid ) ) {
      // ignore group admin operation
      continue;
    }
    $is_group_member = $xgroup_handler->isGroupMember( $uid, $gid );
    switch ( $mode ) {
    case 'add':
      if ( $is_group_member ) {
        die( 'illegal request' );
      }
      if ( ! $xgroup_handler->addUserToXooNIpsGroup( $gid, $uid, false ) ) {
        die( 'failed to add group member' );
      }
      break;
    case 'del':
      if ( ! $is_group_member ) {
        die( 'illegal request' );
      }
      if ( ! $xgroup_handler->deleteUserFromXooNIpsGroup( $gid, $uid ) ) {
        die( 'failed to delete group member' );
      }
      break;
    }
  }
  // continue to modify operation
case 'modify':
  $gid = $formdata->getValue( 'both', 'gid', 'i', true );
  // check administrative group id
  if ( ! in_array( $gid, $gids ) ) {
    die( 'illegal request' );
  }
  $uids = $xgroup_handler->getUserIds( $gid );
  // TODO: implement user handler
  $u_handler =& xoonips_getormhandler( 'xoonips', 'xoops_users' );
  $join = new XooNIpsJoinCriteria( 'xoonips_users', 'uid', 'uid', 'INNER', 'xu' );
  $criteria = new CriteriaCompo();
  $criteria->add( new Criteria( 'level', 0, '>' ) );
  $criteria->add( new Criteria( 'activate', 1, '=', 'xu' ) );
  $criteria->setSort( 'uname' );
  $criteria->setOrder( 'ASC' );
  $u_objs =& $u_handler->getObjects( $criteria, false, '', false, $join );
  if ( count( $u_objs ) == 0 ) {
    die( 'illegal request' );
  }
  // get group name
  $xg_obj =& $xgroup_handler->getGroupObject( $gid );
  $gname = $xg_obj->getVar( 'gname', 's' );
  // breadcrumbs
  $breadcrumbs[] = array( 'name' => $gname, 'url' => XOOPS_URL.'/modules/xoonips/groupadmin.php?op=modify&amp;gid='.$gid );
  // get user list
  $members = array();
  $non_members = array();
  foreach ( $u_objs as $u_obj ) {
    $uid = $u_obj->get( 'uid' );
    $uname = $u_obj->getVar( 'uname', 's' );
    if ( in_array( $uid, $uids ) ) {
      $members[] = array( 'uid' =>$uid,  'uname' => $uname );
    } else {
      $non_members[] = array( 'uid' =>$uid,  'uname' => $uname );
    }
  }
  // title
  $title = _MD_XOONIPS_ACCOUNT_GROUPADMIN_GROUP_LIST.' : '.$gname;
}

// templates
$xoopsOption['template_main'] = 'xoonips_groupadmin.html';
include XOOPS_ROOT_PATH.'/header.php';
$xoopsTpl->assign( 'xoops_breadcrumbs', $breadcrumbs );
$xoopsTpl->assign( 'op', $op );
$xoopsTpl->assign( 'title', $title );
if ( $op == 'list' ) {
  $xoopsTpl->assign( 'groups', $groups );
} else {
  $token_ticket = $xoopsGTicket->getTicketHtml( __LINE__, 600, $ticket_area );
  $xoopsTpl->assign( 'token_ticket', $token_ticket );
  $xoopsTpl->assign( 'gname', $gname );
  $xoopsTpl->assign( 'gid', $gid );
  $xoopsTpl->assign( 'members', $members );
  $xoopsTpl->assign( 'non_members', $non_members );
}
include XOOPS_ROOT_PATH.'/footer.php';

?>
