<?php
// $Id: xoops_version.php,v 1.2 2005/04/01 05:20:49 kizumo Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

$modversion['name'] = _MI_AG_NAME;
$modversion['version'] = 0.30;
$modversion['description'] = _MI_AG_DESC;
$modversion['author'] = "kizumo";
$modversion['credits'] = "";
$modversion['help'] = "analog.html";
$modversion['license'] = "GNU General Public License (GPL)";
$modversion['official'] = 0;
$modversion['image'] = "images/analog_slogo.png";
$modversion['dirname'] = "analog";

$modversion['author_realname'] = "Masayuki Asami";
$modversion['author_website_url'] = "";
$modversion['author_website_name'] = "";
$modversion['author_email'] = "masayuki@kizumo.com";
$modversion['status_version'] = "BETA";
$modversion['status'] = "BETA";
$modversion['date'] = "2005-03-02";

$modversion['warning'] = _MI_AG_WARNING_BETA;

$modversion['demo_site_url'] = "";
$modversion['demo_site_name'] = "";
$modversion['support_site_url'] = "";
$modversion['support_site_name'] = "";
$modversion['submit_bug'] = "";
$modversion['submit_feature'] = "";

$modversion['author_word'] = "It is a module that offers the interface from xoops to analog of the access log analysis software. An analog setting can be registered. <br>
<br>
This module is tested only on linux analog 5.34 and analog 6.0.";
$modversion['version_history'] = "";

// Sql file (must contain sql generated by phpMyAdmin or phpPgAdmin)
// All tables should not have any prefix!
$modversion['sqlfile']['mysql'] = "sql/mysql.sql";
//$modversion['sqlfile']['postgresql'] = "sql/pgsql.sql";

// Tables created by sql file (without prefix!)
$modversion['tables'][0] = "analog_config";

// Admin things
$modversion['hasAdmin'] = 1;
$modversion['adminindex'] = "admin/index.php";
$modversion['adminmenu'] = "admin/menu.php";

// Templates
//$modversion['templates'][1]['file'] = '';
//$modversion['templates'][1]['description'] = '';

// Menu
$modversion['hasMain'] = 0;

// Config Settings (only for modules that need config settings generated automatically)

// name of config option for accessing its specified value. i.e. $xoopsModuleConfig['storyhome']
$modversion['config'][1]['name'] = 'analog';

// title of this config option displayed in config settings form
$modversion['config'][1]['title'] = '_MI_AG_ANALOGPATH';

// description of this config option displayed under title
$modversion['config'][1]['description'] = '_MI_AG_ANALOGPATHDSC';

// form element type used in config form for this option. can be one of either textbox, textarea, select, select_multi, yesno, group, group_multi
$modversion['config'][1]['formtype'] = 'textbox';

// value type of this config option. can be one of either int, text, float, array, or other
// form type of group_multi, select_multi must always be value type of array
$modversion['config'][1]['valuetype'] = 'text';

// the default value for this option
// ignore it if no default
// 'yesno' formtype must be either 0(no) or 1(yes)
$modversion['config'][1]['default'] = '/usr/bin/analog';

// options to be displayed in selection box
// required and valid for 'select' or 'select_multi' formtype option only
// language constants can be used for array key, otherwise use integer
//$modversion['config'][1]['options'] = ;

$modversion['config'][2]['name'] = 'LOGFILE';
$modversion['config'][2]['title'] = '_MI_AG_LOGFILEPATH';
$modversion['config'][2]['description'] = '_MI_AG_LOGFILEPATHDSC';
$modversion['config'][2]['formtype'] = 'textbox';
$modversion['config'][2]['valuetype'] = 'text';
$modversion['config'][2]['default'] = '/var/log/httpd/access_log';

$modversion['config'][3]['name'] = 'IMAGEDIR';
$modversion['config'][3]['title'] = '_MI_AG_IMAGEDIR';
$modversion['config'][3]['description'] = '_MI_AG_IMAGEDIRDSC';
$modversion['config'][3]['formtype'] = 'textbox';
$modversion['config'][3]['valuetype'] = 'text';
$modversion['config'][3]['default'] = sprintf("%s/modules/%s/images/", XOOPS_URL, 
        $modversion['dirname']);

$modversion['config'][4]['name'] = 'LANGUAGE';
$modversion['config'][4]['title'] = '_MI_AG_LANGUAGE';
$modversion['config'][4]['description'] = '_MI_AG_LANGUAGEDSC';
$modversion['config'][4]['formtype'] = 'select';
$modversion['config'][4]['valuetype'] = 'text';
$modversion['config'][4]['default'] = 1;
$modversion['config'][4]['options'] = array(
	'_MI_AG_LANGUAGE_ARMENIAN' => 'ARMENIAN',
	'_MI_AG_LANGUAGE_BASQUE' => 'BASQUE',
	'_MI_AG_LANGUAGE_BULGARIAN' => 'BULGARIAN',
	'_MI_AG_LANGUAGE_CATALAN' => 'CATALAN',
	'_MI_AG_LANGUAGE_SIMP-CHINESE' => 'SIMP-CHINESE',
	'_MI_AG_LANGUAGE_TRAD-CHINESE' => 'TRAD-CHINESE',
	'_MI_AG_LANGUAGE_CZECH' => 'CZECH',
	'_MI_AG_LANGUAGE_DANISH' => 'DANISH',
	'_MI_AG_LANGUAGE_DUTCH' => 'DUTCH',
	'_MI_AG_LANGUAGE_ENGLISH' => 'ENGLISH',
	'_MI_AG_LANGUAGE_US-ENGLISH' => 'US-ENGLISH',
	'_MI_AG_LANGUAGE_FINNISH' => 'FINNISH',
	'_MI_AG_LANGUAGE_FRENCH' => 'FRENCH',
	'_MI_AG_LANGUAGE_GERMAN' => 'GERMAN',
	'_MI_AG_LANGUAGE_HUNGARIAN' => 'HUNGARIAN',
	'_MI_AG_LANGUAGE_INDONESIAN' => 'INDONESIAN',
	'_MI_AG_LANGUAGE_ITALIAN' =>'ITALIAN' ,
	'_MI_AG_LANGUAGE_JAPANESE' => 'JAPANESE',
	'_MI_AG_LANGUAGE_KOREAN' => 'KOREAN',
	'_MI_AG_LANGUAGE_LATVIAN' => 'LATVIAN',
	'_MI_AG_LANGUAGE_NORWEGIAN' => 'NORWEGIAN',
	'_MI_AG_LANGUAGE_NYNORSK' => 'NYNORSK',
	'_MI_AG_LANGUAGE_POLISH' => 'POLISH',
	'_MI_AG_LANGUAGE_PORTUGUESE' => 'PORTUGUESE',
	'_MI_AG_LANGUAGE_BR-PORTUGUESE' => 'BR-PORTUGUESE',
	'_MI_AG_LANGUAGE_RUSSIAN' => 'RUSSIAN',
	'_MI_AG_LANGUAGE_SERBIAN' => 'SERBIAN',
	'_MI_AG_LANGUAGE_SLOVAK' => 'SLOVAK',
	'_MI_AG_LANGUAGE_SLOVENE' => 'SLOVENE',
	'_MI_AG_LANGUAGE_SPANISH' => 'SPANISH',
	'_MI_AG_LANGUAGE_SWEDISH' => 'SWEDISH',
	'_MI_AG_LANGUAGE_TURKISH' => 'TURKISH',
	'_MI_AG_LANGUAGE_UKRAINIAN' => 'UKRAINIAN'
);

$modversion['config'][5]['name'] = 'OUTPUT';
$modversion['config'][5]['title'] = '_MI_AG_OUTPUT';
$modversion['config'][5]['description'] = '_MI_AG_OUTPUTDSC';
$modversion['config'][5]['formtype'] = 'select';
$modversion['config'][5]['valuetype'] = 'text';
$modversion['config'][5]['default'] = 'HTML';
$modversion['config'][5]['options'] = array(
	'_MI_AG_OUTPUT_XHTML' => 'XHTML',
	'_MI_AG_OUTPUT_HTML' => 'HTML',
	'_MI_AG_OUTPUT_PLAIN' => 'PLAIN',
	'_MI_AG_OUTPUT_ASCII' => 'ASCII',
	'_MI_AG_OUTPUT_XML' => 'XML',
	'_MI_AG_OUTPUT_LATEX' => 'LATEX',
	'_MI_AG_OUTPUT_COMPUTER' => 'COMPUTER',
);

?>