<?php
// $Id: fchecker.php
// v 2.05 2004/2/23 18:30:00 toshimitsu Exp $
if (!defined('XOOPS_ROOT_PATH')) {
	exit();
}
if (file_exists(XOOPS_ROOT_PATH."/class/xoopsobject.php")) {
	include_once XOOPS_ROOT_PATH."/class/xoopsobject.php";
}else {
	trigger_error ("require not found xoopsobject :");
	redirect_header(XOOPS_URL."/",3,_NOPERM);
	exit() ;
}

class XptblcheckFchecker extends XoopsObject
{
    /**
     * Constructor
     **/
	function XptblcheckFchecker($uid = null)	// Constructor
	{
//--------------------------------------------//
        $this->initVar('id', XOBJ_DTYPE_INT, 0, false);
        $this->initVar('icstype', XOBJ_DTYPE_TXTBOX, null, true, 255, true);
        $this->initVar('calname', XOBJ_DTYPE_TXTBOX, null, true, 255, true);
        $this->initVar('calendar_tz', XOBJ_DTYPE_TXTBOX, null, true, 255, true);
//--------------------------------------------//

	}
}


class XptblcheckFcheckerHandler extends XoopsObjectHandler
{

	var $my_xptbl_xprootpath ;
	var $my_xptbl_xpmodpath ;
	var $nocheckdirs ;
    /**
     * Constructor
     **/
	function XptblcheckFcheckerHandler()
	{
		$this->my_xptbl_xprootpath = XOOPS_ROOT_PATH ;
		$this->my_xptbl_xpmodpath = XOOPS_ROOT_PATH."/modules" ;
		$this->nocheckdirs = array("uploads","cache","templates_c","temp") ;
	}

/***** Check ()                              **********************************/

  function Check ($rootpath) {
    ReadSystemPHPInfo ();
	set_time_limit(60); 
    CheckXOOPSCore ($rootpath, "checker.xml"); //** check the XOOPS core system integrity
    CheckModules ($rootpath, "checker.xml");
  }

/* **** WriteFileInfo (...)                   ********************************* */

  function WriteFileInfo ($fp, $filename, $path, $level)
  {
    $space = "";

    for ($n = 0; $n < $level; $n++) {
      $space .= "  ";
    }

    $file  = "$space<file>\n";

    $crc   = CalculateCRC ($filename);
    $fname = str_replace ($path, "", $filename);

    $file .= "$space  <name>".$fname."</name>\n";
    $file .= "$space  <crc>".$crc."</crc>\n";
    $file .= "$space  <size>".filesize ($filename)."</size>\n";
    $file .= "$space</file>\n";

    fwrite ($fp, $file);
  }


/* **** CheckWithChecker (...)                ********************************* */
/*
 * $root     = root path/
 * $filename = checker.xml
 */
  function CheckWithChecker ($root, $filename) {
    $filename = $root.$filename;

    if (!file_exists ($filename)) {
      echo "<div class=\"err1\">no checker.xml for $root</div>\n";
      return;
    }

    $data     = implode ("", file ($filename));
    $parser   = xml_parser_create ('UTF-8');

    xml_parser_set_option ($parser, XML_OPTION_CASE_FOLDING, 0);
    xml_parser_set_option ($parser, XML_OPTION_SKIP_WHITE, 1);

    xml_parse_into_struct ($parser, $data, $values, $tags);
    xml_parser_free ($parser);

    $dir    = array ();
    $pushit = 0;
    $isfile = 0;

    foreach ($values as $key => $val) {
      if ($val['tag'] == 'dir') {                  //** we found the dir tag
        if ($val['type'] == 'open') {              //** it's the open tag
          $pushit = 1;                             //** so store the name of the dir to the dir stack
        }
        else {
          array_pop ($dir);                        //** it's a dir close tag pop the stack
        }
      }

      if ($val['tag'] == 'file') {                 //** a file tag found
        if ($val['type'] == 'open') {              //** it's a file open tag
          $isfile = 1;                             //**  so we are within a file section
        }
        else {                                     //** it's a file close tag
          $isfile = 0;                             //**  so reset the file flag
          $file   = $root;                         //** set $file to the root path

          foreach ($dir as $single) {              //** now build the path to know where we are
            $file .= $single."/";
          }

          $file  .= $filename;                     //** now we have build the complete file path

          if (file_exists ($file)) {               //** does the file exist?
            $crc    = CalculateCRC ($file);        //**  yes, we can calculate the CRC

            if ($crc != $filecrc) {                //** if the CRC isn't correct
              $short = "";

              foreach ($dir as $single) {          //** build the relative path
                $short .= $single."/";
              }

              // echo "Wrong CRC: ".$short.$filename." soll: ".$filecrc." ist: ".$crc."<br />\n";
              echo "<div class=\"err3\">Wrong CRC: ".$short.$filename."</div>\n";  //** and show which file isn't correct
            }
          }
          else {                                    //** the file doesn't exist
            $short = "";

            foreach ($dir as $single) {             //** build the relative path
              $short .= $single."/";
            }

            echo "<div class=\"err2\">file ".$short.$filename." doesn't exist</div>\n"; //** and show that the file doesn't exist.
          }
        }
      }

      if (($val['tag'] == 'name') && ($pushit)) {   //** if it's a directory push name into dir array
        array_push ($dir, $val['value']);
        $pushit = 0;
      }

      if ($isfile) {                                //** we found the file now get the different values and store it
        if ($val['tag'] == 'name') {
          $filename = $val['value'];
        }
        if ($val['tag'] == 'crc') {
          $filecrc  = $val['value'];
        }
        if ($val['tag'] == 'size') {
          $filesize = $val['value'];
        }
      }
    }
  }

/*
//-------------GenerateXML () for checker*/
  function GenerateXML ($fp, $dirlist, $path, $level, $withmodules) {
    $space = "";
    for ($n = 0; $n < $level; $n++) {
      $space .= "  ";
    }

    $modname    = $this->my_xptbl_xprootpath."/modules";
    $installname    = $this->my_xptbl_xprootpath."/install";

    foreach ($dirlist as $filename) {
      if (is_dir ($filename)) {
        $mpos = strpos ($filename, $modname);          // is it modules?
        $ipos = strpos ($filename, $installname);      // is it install?

        if ((($mpos === false) || ($withmodules == true)) &&
            ($ipos === false)) {  //** doen't take modules and install into account
          $file  = "$space<dir>\n";
          $fname = str_replace ($path, "", $filename);
//--- hack start --- toshimitsu 2004/02/11
			if (function_exists('mb_http_output')) {
	          $file .= "$space  <name>".mb_convert_encoding($fname,"UTF-8", "auto")."</name>\n";
			} else {	
	          $file .= "$space  <name>".$fname."</name>\n";
			}
//--- hack end --- 

          fwrite ($fp, $file);

          $level++;
          $newdirlist = GetFileDirList ("$filename/");
          GenerateXML ($fp, $newdirlist, "$filename/", $level, $withmodules);
          $level--;

          $file = "$space</dir>\n";
          fwrite ($fp, $file);
        }
      }
      else {
        if (str_replace ($path, "", $filename) != 'checker.xml') {
          WriteFileInfo ($fp, $filename, $path, $level);
        }
      }
    }
  }

/*
//-------------CalculateCRC (...) 
*/

	function CalculateCRC ($filename) {
		$data   = file($filename);             // Read the file into an array
		$lines  = array ();
		
		foreach ($data as $line) {
		  array_push ($lines, chop ($line));
		}
		
		$data   = implode ('', $lines);         // Join the array into a string
		$crc    = crc32 ($data);                // Calculate the crc
		$crchex = DecHex ($crc * 1);            // convert from decimal to hexadecimal
		
		return ("$crchex");                     // echo the result
		}

	function GenerateCore () {

    $path    = $this->my_xptbl_xprootpath."/";
//--- hack start --- toshimitsu 2004/02/11
	$nocheckdirs = $this->nocheckdirs ;
	$dirlist = GetFileDirList ($path , $nocheckdirs);
//--- hack end --- 

	$fp      = fopen ($path."checker.xml", "w");
	if ($fp) {
//--- hack start --- toshimitsu 2004/02/11
		$text = "<?xml version='1.0' encoding='UTF-8' ?>\n<checker>\n";
//--- hack end --- 
		fwrite ($fp, $text);
		GenerateXML ($fp, $dirlist, $path, 1, false);
		
		$text = "</checker>";
		fwrite ($fp, $text);
		
		fclose ($fp);
		echo $path."checker.xml for XOOPS core generated<br />\n";
	}
	}

/*
//-------------GetDirList ()
*/
	function GetDirList($dirname ,$opt_nochecks = null) {
	    $result = array() ;
		if (!is_dir($dirname)) {
			return false ;
		}
	    $dirname .= "/";
	    $dirname .= "{*, *.*}";
		if (function_exists ("glob")) {
			return (glob ($dirname, GLOB_BRACE)) ;
		}
		else {
			$path_parts = pathinfo ($dirname);
			$dir        = opendir ($path_parts['dirname']);
		
			while (false !== ($file = readdir ($dir))) {
				if ($file != "." && $file != "..") {
					if (isset($opt_nochecks) || !empty($opt_nochecks) || is_array($opt_nochecks)) {
						if (in_array ($file, $opt_nochecks)) {				
						//$result[] = "{$path_parts['dirname']}/$file";
						} else {
			          		$result[] = "{$path_parts['dirname']}/$file";
						}
					} else {	
		          		$result[] = "{$path_parts['dirname']}/$file";
					}
		        }
		      }
		      closedir ($dir);
		}
		
		if (empty($result)) {
			return null ;
		} else {
			sort($result);
			return $result;
		}
	
	}
/*
//-------------GetFileDirList ()
*/
	function GetFileDirList($opt_dirname , $opt_sortprefix=null , $opt_nochecks = null) {
	    $result = array() ;
	// main dir  search 
		unset($temp_rets);
		unset($temp_retdirs);
		if (!is_dir($opt_dirname)) {
			return false ;
		}
		if (!isset($opt_sortprefix) || empty($opt_sortprefix) || $opt_sortprefix == "") {
			$opt_sortprefix = "" ;
			$sortdirkey_arr = split ('[/\]', $opt_dirname);
			foreach ($sortdirkey_arr as $v) {
				if ($opt_sortprefix == "") {
					$opt_sortprefix = $v ;
				} else {
					$opt_sortprefix = $opt_sortprefix.',0,'.$v ;
				}
			}
		}
	
		$temp_rets = array() ;
		$temp_retdirkeys = array() ;
	    $temp_rets = $this->GetDirList($opt_dirname , $opt_nochecks) ;	    		
		if (!empty($temp_rets) && ($temp_rets != null)){
			foreach ($temp_rets as $v) {
				$path_parts = pathinfo ($v);
				if (is_dir($v)) {
					$temp_retdirkeys[$opt_sortprefix.',0,'.basename($v)]= $v ;
				} else {
					$temp_retdirkeys[$opt_sortprefix.',1,'.basename($v)]= $v ;
				}
			}
		    $result = array_merge($result , $temp_retdirkeys );		
		}
	
		unset($temp_rets);
	// dir re search loop
		if (!empty($temp_retdirkeys)){
			foreach($temp_retdirkeys as  $sortdirkey => $v) {
				$temp_rets = array() ;
			    $temp_rets = $this->GetFileDirList($v , $sortdirkey , $opt_nochecks) ;	
				if (!empty($temp_rets) && ($temp_rets != null)){
				    $result = array_merge($result , $temp_rets );		
				}
			}
		}
		unset($temp_rets) ;
		unset($temp_retdirs);
	
		if (empty($result)) {
			return null ;
		} else {
			ksort($result);
			return $result;
		}
	}

}
?>