<?php
/*
 * $Id: details.php,v 1.1 2003/08/29 13:15:39 wellwine Exp $
 * Copyright (c) 2003 by Jeremy N. Cowgar <jc@cowgar.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting
 * source code which is considered copyrighted (c) material of the
 * original comment or credit authors.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

include('header.php');

$xoopsOption['template_main'] = 'weblog_details.html';
$blog_id = $_GET['blog_id'];

// Include the page header
include(XOOPS_ROOT_PATH.'/header.php');

$currentuid = !empty($xoopsUser) ? $xoopsUser->getVar('uid','E') : 0;
$isAdmin = !empty($xoopsUser) && $xoopsUser->isAdmin($xoopsModule->mid());

$myts =& MyTextSanitizer::getInstance();
$sql=sprintf('UPDATE %s SET reads = reads + 1 WHERE blog_id=\'%s\'',
             $xoopsDB->prefix('weblog'), $blog_id);
$xoopsDB->queryF($sql);

$sql = 'SELECT bl.blog_id,bl.created, bl.user_id, u.uname, bl.title, bl.contents, bl.private,bl.reads '.
  'FROM '.$xoopsDB->prefix('weblog').' as bl, '.$xoopsDB->prefix('users').' as u '.
  "WHERE (bl.private = 'N' OR bl.user_id='$currentuid') AND bl.user_id=u.uid AND bl.blog_id='$blog_id'";
$results=$xoopsDB->query($sql);
$blog=$xoopsDB->fetchArray($results);

// Setup the user_id in the HTTP_GET so that the Notifications module will pick it up
$HTTP_GET_VARS['user_id'] = $blog['user_id'];

$use_avatar=0;
$avatar_img = '';

if ($xoopsModuleConfig['showavatar']) {
  $thisOwner=new XoopsUser($blog['user_id']);
  $avatar=$thisOwner->getVar('user_avatar','E');
  if (!empty($avatar) && $avatar != 'blank.gif') {
    $use_avatar = 1;
    $avatar_img = XOOPS_URL.'/uploads/'.$avatar;
  }
}

$xoopsTpl->assign('use_avatar',$use_avatar);
$xoopsTpl->assign('avatar_img',$avatar_img);
$xoopsTpl->assign('avatar_align', $xoopsModuleConfig['alignavatar']);

$xoopsTpl->assign('title', $blog['title']);
$xoopsTpl->assign('blog_id', $blog['blog_id']);
$xoopsTpl->assign('created_date', formatTimestamp($blog['created'],
                                                  $xoopsModuleConfig['dateformat'],
                                                  $xoopsConfig['default_TZ']));
$xoopsTpl->assign('created_time', formatTimestamp($blog['created'],
                                                  $xoopsModuleConfig['timeformat'],
                                                  $xoopsConfig['default_TZ']));
$xoopsTpl->assign('uid', $blog['user_id']);
$xoopsTpl->assign('uname', $blog['uname']);
$xoopsTpl->assign('contents', $myts->displayTarea($blog['contents'],1,1,1,1,1,1,1,1,1));
$xoopsTpl->assign('private', $blog['private']);
$xoopsTpl->assign('profileUri', XOOPS_URL.'/userinfo.php?uid='.$blog['user_id']);
$xoopsTpl->assign('current_uid',!empty($xoopsUser) ? $xoopsUser->getVar("uid", "E") : 0);
$xoopsTpl->assign('is_private', $blog['private'] == 'Y' ? 1 : 0);
$xoopsTpl->assign('private', _BL_PRIVATE);
$xoopsTpl->assign('reads', sprintf(_BL_NUMBER_OF_READS, $blog['reads']));
$xoopsTpl->assign('edit_text', _BL_EDIT);
$xoopsTpl->assign('read_users_blog',sprintf('<a href="index.php?user_id=%d">%s</a>',
                                            $blog['user_id'],
                                            sprintf(_BL_READ_USERS_BLOG, $blog['uname'])));

// Include the commenting module
require XOOPS_ROOT_PATH.'/include/comment_view.php';

include(XOOPS_ROOT_PATH.'/footer.php');
?>